/*
 * R : ~ʂ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclConicalSurface3D.java,v 1.65 2000/08/11 06:18:47 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : ~ʂ\NXB
 * <p>
 * ~ʂ́A̒S̈ʒuƋǏ X/Y/Z ̕ǏWn
 * (zuA{@link JgclAxis2Placement3D JgclAxis2Placement3D}) position 
 * position ɂ XY ʂł̉~̔a radiusA
 *  (p / 2) \px semiAngle Œ`B
 * </p>
 * <p>
 * ~ʂ
 * U ̃p[^`͗LŎIłA
 * ̃vC}ȗLԂ [0, (2 * )] łB
 * V ̃p[^`͖ŔIłB
 * </p>
 * <p>
 * (u, v) p[^Ƃ~ P(u, v) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	P(u, v) = c + (radius + v * tan(semiAngle)) * (cos(u) * x + sin(u) * y) + v * z
 * </pre>
 * ŁAc, x, y, z ͂ꂼ
 * <pre>
 *	c : position.location()
 *	x : position.x()
 *	y : position.y()
 *	z : position.z()
 * </pre>
 * \B
 * </p>
 *
 * @version $Revision: 1.65 $, $Date: 2000/08/11 06:18:47 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclConicalSurface3D extends JgclElementarySurface3D {
    /**
     * Ǐ XY ʂł̉~̔aB
     * @serial
     */
    private double radius;

    /**
     * (p / 2) B
     * @serial
     */
    private double semiAngle;

    /**
     * Ǐ XY ʂł̉~̔a (p / 2) ݒ肷B
     * <p>
     * radius ̒lłꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     * <p>
     * semiAngle ̒lƂpx̋e덷菬
     * 邢 ( / 2 - px̋e덷) 傫ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     *
     * @param radius	Ǐ XY ʂł̉~̔a
     * @param semiAngle	(p / 2)
     * @see	JgclInvalidArgumentValue
     */
    private void setRadius(double radius, double semiAngle)
    {
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double dTol = condition.getToleranceForDistance();
	double aTol = condition.getToleranceForAngle();

	if (radius < 0) {
	    throw new JgclInvalidArgumentValue();
	}
	this.radius = radius;
	if (semiAngle < aTol || Math.PI/2 - aTol < semiAngle) {
	    throw new JgclInvalidArgumentValue();
	}
	this.semiAngle = semiAngle;
    }

    /**
     * ǏWnAǏ XY ʂł̉~̔a (p / 2) ^ăIuWFNg\zB
     * <p>
     * position  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * radius ̒lłꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     * <p>
     * semiAngle ̒lƂpx̋e덷菬
     * 邢 ( / 2 - px̋e덷) 傫ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     * 
     * @param position	Ǐ_ƋǏ X/Y/Z ̕ǏWn
     * @param radius	Ǐ XY ʂł̉~̔a
     * @param semiAngle	(p / 2)
     * @see	JgclInvalidArgumentValue
     */
    public JgclConicalSurface3D(JgclAxis2Placement3D position,
				double radius, double semiAngle)
    {
	super(position);
	setRadius(radius, semiAngle);
    }

    /**
     * SAǏ XY ʂł̉~̔a (p / 2) ^ăIuWFNg\zB
     * <p>
     * pnt  axis  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * radius ̒lłꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     * <p>
     * semiAngle ̒lƂpx̋e덷菬
     * 邢 ( / 2 - px̋e덷) 傫ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     * 
     * @param pnt	Ǐ_
     * @param axis	Ǐ Z 
     * @param radius	Ǐ XY ʂł̉~̔a
     * @param semiAngle	(p / 2)
     */
    public JgclConicalSurface3D(JgclPoint3D pnt, JgclVector3D axis,
				double radius, double semiAngle)
    {
	super(new JgclAxis2Placement3D(pnt, axis,
				      axis.verticalVector().unitized()));
	setRadius(radius, semiAngle);
    }

    /**
     * ̉~ʂ̋Ǐ XY ʂɂ~̔aԂB
     * 
     * @return	Ǐ XY ʂɂ~̔a
     */
    public double radius() {
	return this.radius;
    }

    /**
     * ̉~ʂ (p / 2) ԂB
     * 
     * @return	(p / 2)
     */
    public double semiAngle() {
	return this.semiAngle;
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̍WlԂB
     * 
     * @param uParam	U p[^l
     * @param vParam	V p[^l
     * @return		Wl
     */
    public JgclPoint3D coordinates(double uParam, double vParam) {
	JgclCartesianTransformationOperator3D gtrans = toGlobal();
	// c + (r + v*tan(semiAngle))*(cos(u)*x + sin(u)*y) + v*z
	double rad = radius + vParam*Math.tan(semiAngle);
	double x = rad * Math.cos(uParam);
	double y = rad * Math.sin(uParam);
	JgclPoint3D pnt = new JgclCartesianPoint3D(x, y, vParam);

	return gtrans.transform(pnt);
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̐ڃxNgԂB
     * <p>
     * ł̐ڃxNgƂ́Ap[^ U/V ̊eXɂĂ̈ꎟΓ֐łB
     * </p>
     * <p>
     * ʂƂĕԂz̗vf 2 łB
     * z̍ŏ̗vfɂ U p[^ɂĂ̐ڃxNgA
     * Ԗڂ̗vfɂ V p[^ɂĂ̐ڃxNg܂ށB
     * </p>
     *
     * @param uParam	U p[^l
     * @param vParam	V p[^l
     * @return		ڃxNg̔z
     */
    public JgclVector3D[] tangentVector(double uParam, double vParam) {
	JgclCartesianTransformationOperator3D gtrans = toGlobal();
	double tan_sa = Math.tan(semiAngle);
	double sin_u = Math.sin(uParam);
	double cos_u = Math.cos(uParam);
	double rad = radius + vParam * tan_sa;

	JgclVector3D dup =
	    new JgclLiteralVector3D(-rad * sin_u, rad * cos_u, 0.0);

	JgclVector3D dvp =
	    new JgclLiteralVector3D(tan_sa * cos_u, tan_sa * sin_u, 1.0);

	JgclVector3D[] tang = {gtrans.transform(dup), gtrans.transform(dvp)};
	return tang;
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̖@xNgԂB
     * <p>
     * ̃\bhԂ@xNǵAKꂽPʃxNgłB 
     * </p>
     *
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return		Kꂽ@xNg
     */
    public JgclVector3D normalVector(double uParam, double vParam)
    {
	JgclCartesianTransformationOperator3D gtrans = toGlobal();
	JgclVector3D nrm =
	    new JgclLiteralVector3D(Math.cos(uParam), Math.sin(uParam),
				    -Math.tan(semiAngle));
	return gtrans.transform(nrm).unitized();
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̎ȗԂB
     * <p>
     * ȗ1 (principalCurvature1) ɂ (- 1 / (radius * (tan(semiAngle)^2 + 1)))A
     * ȗ2 (principalCurvature2) ɂ 0A
     * xNg1 (principalDirection1) ɂ U p[^ɂĂ̐ڃxNg̒PʃxNgA
     * xNg2 (principalDirection2) ɂ V p[^ɂĂ̐ڃxNg̒PʃxNg
     * ԂB
     * </p>
     * 
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return		ȗ
     */
    public JgclSurfaceCurvature3D curvature(double uParam, double vParam) {
	JgclVector3D[] tangent = tangentVector(uParam, vParam);
	double tan_sa = Math.tan(semiAngle);
	double rad = radius + vParam * tan_sa;

	return new JgclSurfaceCurvature3D(-1.0 / (rad * (tan_sa * tan_sa + 1)),
					  tangent[0].unitized(),
					  0,
					  tangent[1].unitized());
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̕Γ֐ԂB
     * 
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return		Γ֐
     */
    public JgclSurfaceDerivative3D evaluation(double uParam, double vParam) {
	JgclCartesianTransformationOperator3D gtrans = toGlobal();
	double tan_sa = Math.tan(semiAngle);
	double sin_u = Math.sin(uParam);
	double cos_u = Math.cos(uParam);
	double rad = radius + vParam * tan_sa;

	JgclPoint3D pnt =
	    new JgclCartesianPoint3D(rad * cos_u, rad * sin_u, vParam);
	JgclVector3D dup =
	    new JgclLiteralVector3D(-rad * sin_u, rad * cos_u, 0.0);
	JgclVector3D dvp =
	    new JgclLiteralVector3D(tan_sa * cos_u, tan_sa * sin_u, 1.0);

	JgclVector3D duup =
	    new JgclLiteralVector3D(-rad * cos_u, -rad * sin_u, 0.0);

	JgclVector3D duvp =
	    new JgclLiteralVector3D(-tan_sa * sin_u, tan_sa * cos_u, 0.0);

	JgclVector3D zerov = JgclVector3D.zeroVector;

	return new JgclSurfaceDerivative3D(gtrans.transform(pnt),
					   gtrans.transform(dup),
					   gtrans.transform(dvp),
					   gtrans.transform(duup),
					   gtrans.transform(duvp),
					   gtrans.transform(zerov));
    }

    /**
     * ^ꂽ_炱̋Ȗʂւ̓e_߂B
     * <p>
     * ^ꂽ_̉~ʂ̒SɂȂA
     * ɓ̓e_ԂB
     * </p>
     * <p>
     * ^ꂽ_Ƃ̉~ʂ̒SƂ̋A
     * ݐݒ肳Ă鉉Z̋̋e덷
     * ꍇɂ́A
     * JgclIndefiniteSolution ̗O𓊂B
     * </p>
     * 
     * @param point	e̓_
     * @return		e_̔z
     * @exception	JgclIndefiniteSolution	s (e̓_~ʂ̒Sɂ)
     */
    public JgclPointOnSurface3D[] projectFrom(JgclPoint3D point)
	throws JgclIndefiniteSolution
    {
	JgclCartesianTransformationOperator3D gtrans = toGlobal();
	JgclPoint3D lpoint = gtrans.reverseTransform(point);
	double z = lpoint.z();
	JgclPoint3D apoint = new JgclCartesianPoint3D(0.0, 0.0, z);
	JgclVector3D eduvec = lpoint.subtract(apoint);

	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double dTol = Math.abs(condition.getToleranceForDistance());
	double lx = eduvec.length();

	if (lx < dTol) {
	    // point on axis
	    JgclPointOnSurface3D p;

	    try {
		p = new JgclPointOnSurface3D(this, 0.0, z, doCheckDebug);
	    }
	    catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }

	    throw new JgclIndefiniteSolution(p);
	}

	// get vector angle
	double u = Math.atan2(eduvec.y(), eduvec.x());

	double Btan = Math.tan(semiAngle);
	double Bcos = Math.cos(semiAngle);
	double Bsin = Math.sin(semiAngle);
	double zoff = radius / Btan;
	double ly = z + zoff;

	double edist = (ly * Bcos) + (lx * Bsin);

	if (u < 0)
	    u += 2*Math.PI;
	JgclPointOnSurface3D foot1 =
	    new JgclPointOnSurface3D(this, u, Bcos * edist - zoff, doCheckDebug);

	edist = (ly * Bcos) - (lx * Bsin);
	u += Math.PI;
	if (u >= 2*Math.PI)
	    u -= 2*Math.PI;
	JgclPointOnSurface3D foot2 =
	    new JgclPointOnSurface3D(this, u, Bcos * edist - zoff, doCheckDebug);

 	JgclPointOnSurface3D[] proj = { foot1, foot2 };

	return proj;
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA
     * ^ꂽ덷ŕʋߎiq_QԂB
     * <p>
     * ʂƂĕԂiq_Q\_́A
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D 
     * 邱Ƃ҂łB
     * </p>
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param tol	̋e덷
     * @return	̋Ȗʂ̎w̋Ԃ𕽖ʋߎiq_Q
     * @see	JgclPointOnSurface3D
     */
    public JgclMesh3D
    toMesh(JgclParameterSection uPint,
	   JgclParameterSection vPint,
	   JgclToleranceForDistance tol) {
	return makeMesh(1, uPint, vPint, tol);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA
     * ^ꂽ덷ŕʋߎiq_QԂB
     * <p>
     * ʂƂĕԂiq_Q\_́A
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D 
     * 邱Ƃ҂łB
     * </p>
     * 
     * @param meshType	toMesh Ȃ 1 AtoNonStructuredPoints Ȃ 2
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param tol	̋e덷
     * @return	̋Ȗʂ̎w̋Ԃ𕽖ʋߎiq_Q
     * @see	JgclPointOnSurface3D
     * @see	#toMesh(JgclParameterSection, JgclParameterSection, JgclToleranceForDistance)
     * @see	#toNonStructuredPoints(JgclParameterSection, JgclParameterSection, double, double[])
     */
    private JgclMesh3D
	   makeMesh(int meshType,
		    JgclParameterSection uPint,
		    JgclParameterSection vPint,
		    JgclToleranceForDistance tol) {
	JgclPointOnSurface3D[][] mesh;
	double vStart = vPint.start();
	double vEnd = vPint.end();
	double vMiddle = 0.0;
	double rad = getMaxRadius(vPint);
	int u_npnts, v_npnts;
	double uParam, vParam, uDelta;
	int i, j;

	if (rad <= JgclConditionOfOperation.getCondition().getToleranceForDistance()) {
	    u_npnts = 2;
	} else {
	    /*
	     * ȃ傫p[^ł̒fʂƂȂ~߂B
	     * ɉ~|CߎA̓_̐𓾂B
	     */
	    u_npnts = JgclCircle2D.toPolylineNDivision(rad, uPint.increase(), tol) + 1;
	}

	if (meshType == 1) {
	    /*
	     * v͈̔͂_܂ނƂA_őOɕB
	     * ܂܂ȂƂ͕ȂB
	     */
	    double apexV = apexVParameter();
	    double sp = vStart - apexV;
	    double ep = vEnd - apexV;
	    if (sp * ep >= 0.0) {
		v_npnts = 2;
	    } else {
		JgclPoint3D apex = apex();
		if ((coordinates(0.0, vStart).identical(apex)) ||
		    (coordinates(0.0, vEnd).identical(apex)))
		    v_npnts = 2;
		else {
		    v_npnts = 3;
		    vMiddle = apexV;
		}
	    }
	} else {
	    v_npnts = 3;
	    vMiddle = (vStart + vEnd) / 2.0;
	}

	/*
	 * U u_npnts AV̗[ł̈ʒuiq_ƂB
	 * (~ʂ̃|Cߎ̓p[^ƂȂ͂ł)
	 */
	mesh = new JgclPointOnSurface3D[u_npnts][v_npnts];

	uDelta = uPint.increase() / (u_npnts - 1);
	uParam = uPint.start();
	for (i = 0; i < u_npnts; i++) {
	    for (j = 0; j < v_npnts; j++) {
		if (j == 0)
		    vParam = vStart;
		else if (j == 2 || v_npnts == 2)
		    vParam = vEnd;
		else
		    vParam = vMiddle;
		mesh[i][j] = new JgclPointOnSurface3D(this, uParam, vParam, doCheckDebug);
	    }
	    if (i == (u_npnts - 2))
		uParam = uPint.end();
	    else
		uParam += uDelta;
	}

	return new JgclMesh3D(mesh, false);
    }

    /**
     * ̉~ʂ́A^ꂽ V ̃p[^Ԃ̒ł (Βl) ł傫ȔaԂB
     *
     * @param vPint	V ̃p[^
     * @return		ő唼a
     */
    private double getMaxRadius(JgclParameterSection vPint) {

	double rads = Math.abs(this.radius + vPint.start() * Math.tan(this.semiAngle));
	double rade = Math.abs(this.radius + vPint.end()   * Math.tan(this.semiAngle));
	return Math.max(rads, rade);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂɍČL Bspline ȖʂԂB
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @return		̋Ȗʂ̎w̋ԂČL Bspline Ȗ
     */
    public JgclBsplineSurface3D
	toBsplineSurface(JgclParameterSection uPint,
			 JgclParameterSection vPint)
    {
	JgclCircle2D circle2D =
	    new JgclCircle2D(JgclAxis2Placement2D.origin, this.radius());

	JgclBsplineCurve2D uBsplineCurve2D = circle2D.toBsplineCurve(uPint);

	int uNPoints = uBsplineCurve2D.nControlPoints();
	int vNPoints = 2;

	JgclPoint3D[][] controlPoints = new JgclPoint3D[uNPoints][vNPoints];
	double[][] weights = new double[uNPoints][vNPoints];

	JgclCartesianTransformationOperator3D localTransformationOperator =
	    this.position().toCartesianTransformationOperator(1.0);

	JgclPoint3D localVertex =
	    JgclPoint3D.of(0.0, 0.0, (- (this.radius() / Math.tan(this.semiAngle()))));
	double vLowerCoord = vPint.start() / localVertex.z();
	double vUpperCoord = vPint.end() / localVertex.z();

	for (int ui = 0; ui < uNPoints; ui++) {
	    JgclPoint3D uPoint = uBsplineCurve2D.controlPointAt(ui).to3D();
	    controlPoints[ui][0] =
		localTransformationOperator.toEnclosed(localVertex.linearInterpolate(uPoint, vLowerCoord));
	    controlPoints[ui][1] =
		localTransformationOperator.toEnclosed(localVertex.linearInterpolate(uPoint, vUpperCoord));
	    weights[ui][0] = weights[ui][1] = uBsplineCurve2D.weightAt(ui);
	}

	return new JgclBsplineSurface3D(uBsplineCurve2D.knotData(),
					JgclBsplineKnot.quasiUniformKnotsOfLinearOneSegment,
					controlPoints, weights);
    }

    /**
     * ^ꂽ_̋Ȗʏɂ邩ۂ`FbNB
     * 
     * @param point	ΏۂƂȂ_
     * @return		^ꂽ_̋Ȗʏɂ trueAłȂ false
     */
    boolean checkSolution(JgclPoint3D point) {
 	double dTol = getToleranceForDistance();
 	double tanBsa = Math.tan(this.semiAngle());
	double dist = Math.sqrt(point.x() * point.x() + point.y() * point.y());
 	double ework = (tanBsa * point.z()) + this.radius();
 	return Math.abs(dist - ework) < dTol;
    }
 
    /**
     * ̏Ȗʂ (\ꂽ) RȐ̌_\㐔𐶐B
     * 
     * @param poly	xWGȐ邢͂aXvCȐ̂ZOg̑\̔z
     * @return		̏Ȗʂ poly ̌_\㐔̍
     */
    JgclRealPolynomial makePoly(JgclRealPolynomial[] poly) {
  	double tanBsa = Math.tan(this.semiAngle());
  	boolean isPoly = poly.length < 4;
  	int degree = poly[0].degree();

  	double[] zCoef = new double[degree + 1];

  	if (isPoly) {
 	    for (int j = 0; j <= degree; j++) {
 		zCoef[j] = tanBsa * poly[2].coefficientAt(j);
 	    }
 	    zCoef[0] += this.radius();
  	} else {
 	    for (int j = 0; j <= degree; j++) {
 		zCoef[j] = tanBsa * poly[2].coefficientAt(j) +
                           this.radius() * poly[3].coefficientAt(j);
            }
  	}

  	JgclRealPolynomial xPoly = poly[0].multiply(poly[0]);
  	JgclRealPolynomial yPoly = poly[1].multiply(poly[1]);
  	JgclRealPolynomial workPoly = new JgclRealPolynomial(zCoef);
  	JgclRealPolynomial wPoly = workPoly.multiply(workPoly);
	degree = xPoly.degree();
  	double[] coef = new double[degree + 1];
 	for (int j = 0; j <= degree; j++) {
 	    coef[j] = xPoly.coefficientAt(j) +
 		      yPoly.coefficientAt(j) -
 		      wPoly.coefficientAt(j);
 	}

  	return new JgclRealPolynomial(coef);
    }

    /**
     * ̋ȖʂƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate)
	throws JgclIndefiniteSolution
    {
	return mate.intersect(this, true);
    }

    /**
     * ̋ȖʂƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint3D[] intersect(JgclLine3D mate,boolean doExchange) 
	throws JgclIndefiniteSolution
    {
	// get intersection one side only
	JgclIntersectionPoint3D[] one_side;
	
	one_side = intersectLine(mate,doExchange);
	
	// get reversed cone
	JgclConicalSurface3D another_cone = getReverse();
	
	// get another side intersection
	JgclIntersectionPoint3D[] another_side = another_cone.intersectLine(mate,doExchange);

	JgclIntersectionPoint3D[] returnValue;

	// translate another side intersection 
	if(another_side.length == 2){     // case : both two intersection points exist another side
	    // translate two intersection points
	    JgclPoint3D pnt;
	    double param[] = new double[2];
	    
	    pnt = another_side[0].coordinates();
	    param = pointToParameter(pnt);
	    JgclPointOnSurface3D trans_another_side1 = new JgclPointOnSurface3D(pnt,this,param[0],param[1]);
	    
	    pnt = another_side[1].coordinates();
	    param = pointToParameter(pnt);
	    JgclPointOnSurface3D trans_another_side2 = new JgclPointOnSurface3D(pnt,this,param[0],param[1]);
	    
	    returnValue = new JgclIntersectionPoint3D[2];
	    
	    if (doExchange){
		returnValue[0] = 
		    new JgclIntersectionPoint3D(another_side[0].pointOnGeometry1(),trans_another_side1,false);
		returnValue[1] = 
		    new JgclIntersectionPoint3D(another_side[1].pointOnGeometry1(),trans_another_side2,false);
	    } else {
		returnValue[0] = 
		    new JgclIntersectionPoint3D(trans_another_side1,another_side[0].pointOnGeometry1(),false);
		returnValue[1] = 
		    new JgclIntersectionPoint3D(trans_another_side2,another_side[1].pointOnGeometry1(),false);
	    }
	    return returnValue;
	} else if(another_side.length ==1) {  // case : one intersection point exists another side

	    // translate another side intersection point
	    JgclPoint3D pnt;
	    double param[] = new double[2];
	    
	    pnt = another_side[0].coordinates();
	    param = pointToParameter(pnt);
	    JgclPointOnSurface3D trans_another_side = new JgclPointOnSurface3D(pnt,this,param[0],param[1]);
	    
	    JgclIntersectionPoint3D another_intersection;
	    if (doExchange) 
		another_intersection = 
		    new JgclIntersectionPoint3D(another_side[0].pointOnGeometry1(),trans_another_side,false);
	    else 
		another_intersection = 
		    new JgclIntersectionPoint3D(trans_another_side,another_side[0].pointOnGeometry2(),false);  

	    if(one_side.length == 1) {  // case : one intersection point exists this side

		// together this side intersection point & another side intersection point
		JgclPoint3D this_point = one_side[0].pointOnGeometry2().coordinates();
		JgclPoint3D another_point = another_intersection.pointOnGeometry2().coordinates();

		if(this_point.distance(another_point) < getToleranceForDistance()) {  // case : through vertex point
		    returnValue = new JgclIntersectionPoint3D[1];
		    returnValue[0] = one_side[0];
		} else {  // case : intersection points exists on each other

		    returnValue = new JgclIntersectionPoint3D[2];

		    double this_param;
		    if (doExchange)
		        this_param = ((JgclPointOnCurve3D)one_side[0].pointOnGeometry1()).parameter();
		    else
			this_param = ((JgclPointOnCurve3D)one_side[0].pointOnGeometry2()).parameter();

 		    double another_param;
		    if (doExchange)
		        another_param = ((JgclPointOnCurve3D)another_intersection.pointOnGeometry1()).parameter();
		    else
		        another_param = ((JgclPointOnCurve3D)another_intersection.pointOnGeometry2()).parameter();

 		    if( this_param > another_param ){
 			returnValue[0] = one_side[0];
 			returnValue[1] = another_intersection;
 		    } else {
 			returnValue[0] = another_intersection;
 			returnValue[1] = one_side[0];
 		    }
		}
	    } else {    // case : no intersection point exists this side
		returnValue = new JgclIntersectionPoint3D[1];
		returnValue[0] = another_intersection;
	    }
	    return returnValue;
	} else {  // case : no intersection points exist another side
	    // return this side intersection point
	    return one_side;
	}
    }
    
    /**
     * ̉~ʂ ((radius + v * tan(semiAngle)) > 0) ̕Ƒ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint3D[] intersectLine(JgclLine3D mate, boolean doExchange) 
	throws JgclIndefiniteSolution
    {
	double paraA[] = new double[2];
	double paraB[][] = new double[2][2];
	double ework1,ework2;
	int number_of_intpnt;
	
	// tolerance
	double aTol = getToleranceForAngle();
	double dTol = getToleranceForDistance();

	// epsilon
	double epsilon = JgclMachineEpsilon.DOUBLE;

	// calculate vertex position
	double etan = Math.tan(semiAngle());
	ework1 = radius()/ etan;
	JgclPoint3D dBorg = position().location();
	JgclVector3D dBxyz = position().z();

	JgclCartesianPoint3D Vp = new
	    JgclCartesianPoint3D(dBorg.x() -  ework1 * dBxyz.x(),
				 dBorg.y() -  ework1 * dBxyz.y(),
				 dBorg.z() -  ework1 * dBxyz.z());
	JgclPoint3D int_pnt[];

	// check if line crosses cone's vertex
	JgclPointOnCurve3D project =mate.project1From(Vp);
	if(project.distance(Vp) < dTol){

	    // line passes through the vertex of cone
	    JgclVector3D uAdir = mate.dir().unitized();
	    ework1 = Math.abs(uAdir.dotProduct(dBxyz));
	    if(ework1 > 1.0) ework1 = 1.0;

	    if(Math.abs(Math.acos(ework1) - semiAngle()) < aTol){
		// A & B are overlap
		throw new JgclIndefiniteSolution(mate.pnt());
	    }else{
		// intersection is cone's vertex
		int_pnt = new JgclPoint3D[1];
		int_pnt[0] = new JgclCartesianPoint3D(Vp.x(),Vp.y(),Vp.z());
		JgclVector3D pnt_to_vertex = Vp.subtract(mate.pnt());
		paraA[0] = pnt_to_vertex.length()/mate.dir().length();
		if(pnt_to_vertex.dotProduct(mate.dir()) < 0.0)
		    paraA[0] = -1 * paraA[0];
		paraB[0][0] = 0.0;
		paraB[0][1] = -1 * radius()/ etan;

		number_of_intpnt = 1;
	    }
	}else{
	    // general case 
	    
	    // transform line to cone's local coordinates system
	    JgclCartesianTransformationOperator3D trans = new
		JgclCartesianTransformationOperator3D(position(),1.0);
	    
	    JgclPoint3D dAtpnt = trans.reverseTransform(mate.pnt());
	    JgclVector3D dAtdir = trans.reverseTransform(mate.dir());
	    JgclLine3D dAt = new JgclLine3D(dAtpnt,dAtdir);

	    // make polynomial
	    ework1 = etan * dAtdir.z();
	    ework2 = etan * dAtpnt.z() + radius();
	    
	    double ecoef[] = new double[3];
	    
	    ecoef[2] = (dAtdir.x() * dAtdir.x()) + (dAtdir.y() * dAtdir.y()) - (ework1 * ework1);
	    ecoef[1] = 2.0 * ((dAtpnt.x() * dAtdir.x()) + (dAtpnt.y() * dAtdir.y())-(ework1 * ework2));
	    ecoef[0] = (dAtpnt.x() * dAtpnt.x()) + (dAtpnt.y() * dAtpnt.y()) - (ework2 * ework2);

	    JgclRealPolynomial poly = new JgclRealPolynomial(ecoef);

	    double eroot[] = poly.getRootsIfQuadric();

	    int_pnt = new JgclPoint3D[eroot.length];

	    int j=0;
	    for(int i=0;i<eroot.length;i++){
		JgclPoint3D epnt = dAt.coordinates(eroot[i]);
		if(epnt.z() < (-(radius()/etan + dTol)))
		    continue;
		
		int_pnt[j] = mate.coordinates(eroot[i]);
	
		paraA[j] = eroot[i];
		
		if(Math.abs(epnt.x()) < epsilon)
		    if(epnt.y() > 0.0)
			paraB[j][0] = Math.PI /2.0;
		    else
			paraB[j][0] = -1 * Math.PI /2.0;
		else{
		    paraB[j][0] = Math.atan(epnt.y()/epnt.x());
		    if(epnt.x() < 0.0)
			paraB[j][0] += Math.PI;
		    if(paraB[j][0] < 0.0)
			paraB[j][0] += 2 * Math.PI;
		}
		paraB[j][1] = epnt.z();
		
		j++;
	    }

	    if(j==2){
		double dist = int_pnt[0].distance(int_pnt[1]);
		if(dist < dTol){
		    j = 1;
		    int_pnt[0] = int_pnt[0].midPoint(int_pnt[1]);
		    paraA[0] = (paraA[0] + paraA[1])/2.0;
		    if(Math.abs(paraB[0][0] - paraB[0][1]) < Math.PI)
			paraB[0][0] = (paraB[0][0] + paraB[1][0])/2.0;
		    paraB[0][1] = (paraB[0][1] + paraB[1][1])/2.0;
		}
	    }
	    number_of_intpnt = j;
	}

	JgclIntersectionPoint3D return_pnt[] = new JgclIntersectionPoint3D[number_of_intpnt];

	// make intersection point
	for(int i=0;i<number_of_intpnt;i++){
	    // point on line
	    JgclPointOnCurve3D PonC =
		new JgclPointOnCurve3D(int_pnt[i],mate,paraA[i],doCheckDebug);
	    
	    // point on conic surface
	    JgclPointOnSurface3D PonS =
		new JgclPointOnSurface3D(int_pnt[i],this,paraB[i][0],paraB[i][1],doCheckDebug);

	    // intersection point
	    if(doExchange)
		return_pnt[i] = new JgclIntersectionPoint3D(int_pnt[i],PonC,PonS,doCheckDebug);
	    else
		return_pnt[i] = new JgclIntersectionPoint3D(int_pnt[i],PonS,PonC,doCheckDebug);
	}

	return return_pnt;
    }

    /**
     * ̋ȖʂƑ̋Ȗʂ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ȖʂӏɂẮA (JgclIntersectionCurve3D) ԂB
     * </p>
     * <p>
     * ȖʂڂӏɂẮA_ (JgclIntersectionPoint3D) Ԃ邱ƂB
     * </p>
     * 
     * @param mate	̋Ȗ
     * @return		 (܂͌_) ̔z
     * @exception	JgclIndefiniteSolution	mate ~ʂŁA҂I[o[bvĂAsł
     * @see		JgclIntersectionCurve3D
     * @see		JgclIntersectionPoint3D
     */
    public JgclSurfaceSurfaceInterference3D[] intersect(JgclParametricSurface3D mate)
	 throws JgclIndefiniteSolution
    {
	return mate.intersect(this, true);
    }

    /**
     * ̋ȖʂƑ̋Ȗ () ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsPlnCon3D JgclIntsPlnCon3D}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclPlane3D mate,
						 boolean doExchange) {
	JgclIntsPlnCon3D doObj = new JgclIntsPlnCon3D(mate, this);
	return doObj.getInterference(!doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ () ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsSphCon3D JgclIntsSphCon3D}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclSphericalSurface3D mate,
						 boolean doExchange) {
	JgclIntsSphCon3D doObj = new JgclIntsSphCon3D(mate, this);
	return doObj.getInterference(!doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (~) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsCylCon3D#intersection(JgclCylindricalSurface3D, JgclConicalSurface3D, boolean)
     * JgclIntsCylCon3D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclCylindricalSurface3D mate,
						 boolean doExchange) {
	return JgclIntsCylCon3D.intersection(mate, this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (~) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsConCon3D JgclIntsConCon3D}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     * @exception	JgclIndefiniteSolution	҂I[o[bvĂAsł
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclConicalSurface3D mate,
						 boolean doExchange)
	throws JgclIndefiniteSolution
    {
	JgclIntsConCon3D doObj = new JgclIntsConCon3D(this, mate);
	return doObj.getInterference(doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (xWGȖ) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsQrdBzs3D#intersection(JgclElementarySurface3D, JgclPureBezierSurface3D, boolean)
     * JgclIntsQrdBzs3D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (xWGȖ)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclPureBezierSurface3D mate,
						 boolean doExchange) {
	return JgclIntsQrdBzs3D.intersection(this, mate, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (aXvCȖ) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsSrfBss3D#intersection(JgclElementarySurface3D, JgclBsplineSurface3D, boolean)
     * JgclIntsSrfBss3D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (aXvCȖ)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclBsplineSurface3D mate,
						 boolean doExchange) {
	return JgclIntsSrfBss3D.intersection(this, mate, doExchange);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂItZbgȖʂ
     * ^ꂽ덷ŋߎ Bspline Ȗʂ߂B
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.FRONT/BACK)
     * @param tol     	̋e덷
     * @return		̋Ȗʂ̎w̋`Ԃ̃ItZbgȖʂߎ Bspline Ȗ
     * @see	JgclWhichSide
     */
    public JgclBsplineSurface3D
	offsetByBsplineSurface(JgclParameterSection uPint,
				JgclParameterSection vPint,
				double magni,
				int side,
				JgclToleranceForDistance tol)
    {
	JgclOfst3D doObj = new JgclOfst3D(this,uPint,vPint,magni,side,tol);
	return doObj.offset();
    }
    
    /**
     * ̋Ȗʂ U p[^̈ʒuɂ铙p[^ȐԂB
     *
     * @param uParam	U ̃p[^l
     * @return	w U p[^lł̓p[^Ȑ
     */
    public JgclParametricCurve3D uIsoParametricCurve(double uParam) {
	JgclCartesianTransformationOperator3D trns = position().toCartesianTransformationOperator();

	double tan_sa = Math.tan(semiAngle());
	double cos_u = Math.cos(uParam);
	double sin_u = Math.sin(uParam);

	// point at (para, 0.0) becomes start point of Line
	JgclPoint3D pnt = new JgclCartesianPoint3D(cos_u * radius(), sin_u * radius(), 0.0);
	pnt = trns.toEnclosed(pnt);
	// V-dir tangent vector becomes direction of Line
	JgclVector3D dir = new JgclLiteralVector3D(tan_sa * cos_u, tan_sa * sin_u, 1.0);
	dir = trns.toEnclosed(dir);

	return new JgclLine3D(pnt, dir);
    }

    /**
     * ̋Ȗʂ V p[^̈ʒuɂ铙p[^ȐԂB
     *
     * @param vParam	V ̃p[^l
     * @return	w V p[^lł̓p[^Ȑ
     */
    public JgclParametricCurve3D vIsoParametricCurve(double vParam)
	throws JgclReducedToPoint
    {
	JgclCartesianTransformationOperator3D trns = position().toCartesianTransformationOperator();

	double tan_sa = Math.tan(semiAngle());
	JgclPoint3D cntr = new JgclCartesianPoint3D(0.0, 0.0, vParam);
	cntr = trns.toEnclosed(cntr);	// center of Circle
	double cRadius = radius() + vParam * tan_sa;
	if (cRadius <= getToleranceForDistance()) {
	    throw new JgclReducedToPoint(cntr);
	}

	/*
	 * copy Axis2Placement
	 * but when (virtual) radius is less than zero, reverse X axis.
	 */
	JgclVector3D xVec = position().x();
	if (radius < 0.0) {
	    xVec = xVec.reverse();
	    radius = - radius;
	}
	JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(cntr, position().z(), xVec);
	return new JgclCircle3D(a2p, cRadius);
    }

    /**
     * ̋Ȗʂ U ̃p[^`ԂB
     * <p>
     * LŎIȒ`ԂB
     * </p>
     *
     * @return	̋Ȗʂ U ̃p[^`
     */
    JgclParameterDomain getUParameterDomain() {
	try {
	    return new JgclParameterDomain(true, 0, 2*Math.PI);
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /**
     * ̋Ȗʂ V ̃p[^`ԂB
     * <p>
     * ŔIȒ`ԂB
     * </p>
     *
     * @return	̋Ȗʂ V ̃p[^`
     */
    JgclParameterDomain getVParameterDomain() {
	return new JgclParameterDomain();
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricSurface3D#CONICAL_SURFACE_3D JgclParametricSurface3D.CONICAL_SURFACE_3D}
     */
    int type() {
	return CONICAL_SURFACE_3D;
    }

    /**
     * ̉~ʂ̒_ɂ V ̃p[^lԂB
     *
     * @return	_ɂ V ̃p[^l
     */
    private double apexVParameter() {
	return (- radius() / Math.tan(semiAngle()));
    }

    /**
     * ̉~ʂ̒_̍WlԂB
     *
     * @return	_
     */
    JgclPoint3D apex() {
	return coordinates(0.0, apexVParameter());
    }

    /**
     * ̉~ʂ̒SƂȂ钼ԂB
     *
     * @return	S
     */
    JgclLine3D getAxis() {
	return new JgclLine3D(position().location(), position().z());
    }

    /**
     * ̉~ʂ𔽓]~ʂԂB
     *
     * @return ]~
     */
    JgclConicalSurface3D getReverse() {
	JgclVector3D originToVertex = apex().subtract(position().location());
	JgclPoint3D reverseLocation = getAxis().project1From(apex().add(originToVertex));
	JgclAxis2Placement3D reverse_position = new
	    JgclAxis2Placement3D(reverseLocation,
				 position().z().reverse(),
				 position().x().reverse());

	JgclConicalSurface3D result =
	    new JgclConicalSurface3D(reverse_position, this.radius, this.semiAngle);
	return result;
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA
     * ^ꂽ덷ŕʋߎ_QԂB
     * <p>
     * ʂƂē_Q͈ʂɁAʑIɂ􉽓IɂAiqł͂ȂB
     * </p>
     * <p>
     * scalingFactor ́A͗pł͂ȂAo͗p̈łB
     * scalingFactor ɂ́Avf 2 ̔z^B
     * scalingFactor[0] ɂ U ̏kڔ{A
     * scalingFactor[1] ɂ V ̏kڔ{ԂB
     * ̒l͉炩̐Βlł͂ȂA
     * p[^̐iޑx T ɑ΂āA
     * U/V ɂĎԏŋȖʏ̓_iޑx Pu/Pv \ΒlłB
     * ܂Ap[^ T iނƁA
     * ԏł̋Ȗʏ̓_ U ł Pu (scalingFactor[0])A
     * V ł Pv (scalingFactor[1]) iނƂ\ĂB
     * T ̑傫͖Ȃ̂ŁA̒lQƂۂɂ́A
     * scalingFactor[0]  scalingFactor[1] ̔䂾pׂłB
     * ȂA̒l͂܂łڈłAȑx̂ł͂ȂB
     * </p>
     * <p>
     * ʂƂĕԂ Vector Ɋ܂܂evf
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D
     * ł邱Ƃ҂łB
     * </p>
     *
     * @param uParameterSection	U ̃p[^
     * @param vParameterSection	V ̃p[^
     * @param tolerance	̋e덷
     * @param scalingFactor	_QOp`ۂɗLpƎv U/V ̏kڔ{
     * @return	_Q܂ Vector
     * @see	JgclPointOnSurface3D
     */
    public Vector toNonStructuredPoints(JgclParameterSection uParameterSection,
					JgclParameterSection vParameterSection,
					double tolerance,
					double[] scalingFactor) {
	Vector result = new Vector();

	JgclMesh3D mesh = this.makeMesh(2, uParameterSection, vParameterSection,
					new JgclToleranceForDistance(tolerance));

	for (int u = 0; u < mesh.uNPoints(); u++)
	    for (int v = 0; v < mesh.vNPoints(); v++)
		result.addElement(mesh.pointAt(u, v));

	scalingFactor[0] = getMaxRadius(vParameterSection);
	scalingFactor[1] = Math.sqrt(1.0 + (this.semiAngle * this.semiAngle));

	return result;
    }

    /**
     * ̋ȖʂA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricSurface3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclAxis2Placement3D tPosition =
	    this.position().transformBy(reverseTransform,
					transformationOperator,
					transformedGeometries);
	double tRadius;
	if (reverseTransform != true)
	    tRadius = transformationOperator.transform(this.radius());
	else
	    tRadius = transformationOperator.reverseTransform(this.radius());
	return new JgclConicalSurface3D(tPosition, tRadius, this.semiAngle);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tposition");
        position().output(writer, indent + 2);
        writer.println(indent_tab + "\tradius\t" + radius);
        writer.println(indent_tab + "\tsemiAngle\t" + semiAngle);
        writer.println(indent_tab + "End");
    }
}
