/*
 * Q : ~Ȑ̃NXKw̃[gƂȂ钊ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclConic2D.java,v 1.48 2000/08/11 06:18:46 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;

/**
 * Q : ~Ȑ̃NXKw̃[gƂȂ钊ۃNXB
 * <p>
 * ̃NX̃CX^X́A
 * ~Ȑ̈ʒuƌX肷ǏWn
 * (zuA{@link JgclAxis2Placement2D JgclAxis2Placement2D})
 * position ێB
 * </p>
 * <p>
 * position  null łĂ͂ȂȂB
 * </p>
 *
 * @version $Revision: 1.48 $, $Date: 2000/08/11 06:18:46 $
 * @author Information-technology Promotion Agency, Japan
 */

public abstract class JgclConic2D extends JgclParametricCurve2D {
    /**
     * ~Ȑ́uSvƋǏ̕肷ǏWnB
     * @serial
     */
    private JgclAxis2Placement2D position;

    /**
     * ǏWnw肵ȂIuWFNg͍ȂB
     */
    private JgclConic2D() {
	super();
	this.position = null;
    }

    /**
     * ǏWnw肵ăIuWFNg\zB
     * <p>
     * position  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param position	SƋǏ̕߂ǏWn
     * @see	JgclInvalidArgumentValue
     */
    protected JgclConic2D(JgclAxis2Placement2D position) {
	super();
	if (position == null)
	    throw new JgclInvalidArgumentValue("position is null.");
	this.position = position;
    }

    /**
     * ̋Ȑ̎w̋ԂA^ꂽ덷Œߎ|CԂB
     * <p>
     * ʂƂĕԂ|C\_ JgclPointOnCurve2D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * ȂAʂƂē|C_ɏkނ悤ȏꍇɂ
     * JgclZeroLength ̗O𔭐B
     * </p>
     * 
     * @param pint	ߎp[^
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ𒼐ߎ|C
     * @see	JgclPointOnCurve2D
     * @see	JgclZeroLength
     */
    public JgclPolyline2D toPolyline(JgclParameterSection pint,
				     JgclToleranceForDistance tol) 
    {
	if (pint.increase() < 0.0) {
	    return toPolyline(pint.reverse(), tol).reverse();
	}

	double sp;
	double ep;
	JgclParameterDomain domain = parameterDomain();

	if (domain.isPeriodic()) {
	    // Ellipse
	    sp = domain.wrap(pint.start());
	    ep = sp + pint.increase();
	}
	else {
	    sp = pint.lower();
	    checkValidity(sp);

	    ep = pint.upper();
	    checkValidity(ep);
	}

	double tolerance = Math.abs(tol.value());

	IntervalInfo root_info = new IntervalInfo();
	root_info.left = new JgclPointOnCurve2D(this, sp, doCheckDebug);
	root_info.right = new JgclPointOnCurve2D(this, ep, doCheckDebug);

	JgclBinaryTree pnt_tree = new JgclBinaryTree(root_info);

	int no_pnts = 2;	// left & right
	no_pnts += divideInterval(pnt_tree.rootNode(), tolerance);

	JgclPoint2D[] pnts = new JgclPoint2D[no_pnts];
	FillInfo fill_info = new FillInfo(pnts, 0);

	pnt_tree.rootNode().preOrderTraverse(new FillArray(), fill_info);

	if (no_pnts == 2 && pnts[0].identical(pnts[1]))
	    throw new JgclZeroLength();

	return new JgclPolyline2D(pnts);
    }

    /**
     * ~Ȑ̂ԂNXB
     * <p>
     * ̓NX
     * {@link #toPolyline(JgclParameterSection, JgclToleranceForDistance)
     * toPolyline(JgclParameterSection, JgclToleranceForDistance)}
     * ̓ł̂ݗpB
     * </p>
     */
    private class IntervalInfo {
	/**
	 * Ԃ̍[ ()B
	 */
	JgclPointOnCurve2D left;

	/**
	 * Ԃ̉E[ ()B
	 */
	JgclPointOnCurve2D right;
    }

    /**
     * ̉~Ȑ́A^ꂽԂ𒼐ߎ_𔭐B
     * <p>
     * _̏ crnt_node ȉ̓񕪖ؓɎ߂B
     * </p>
     * <p>
     * ̃\bh
     * {@link #toPolyline(JgclParameterSection, JgclToleranceForDistance)
     * toPolyline(JgclParameterSection, JgclToleranceForDistance)}
     * ̓ł̂ݗpB
     * </p>
     *
     * @param crnt_node	Ԃێ񕪖؂̃m[h
     * @param tol	ߎ̐xƂė^ꂽűe덷v
     * @return	Ȑ𒼐ߎ_̓_̐
     * @see IntervalInfo
     * @see #checkInterval(JgclConic2D.IntervalInfo, double)
     */
    private int divideInterval(JgclBinaryTree.Node crnt_node,
			       double tol) {
	int no_pnts = 1;	// mid

	IntervalInfo crnt_info = (IntervalInfo)crnt_node.data();
	double mid_param = (crnt_info.left.parameter() +
			    crnt_info.right.parameter()) / 2.0;

	// divide current interval into two

	IntervalInfo left_info = new IntervalInfo();
	left_info.left = crnt_info.left;
	try {
	    left_info.right = new JgclPointOnCurve2D(this, mid_param, doCheckDebug);
	}
	catch(JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}

	JgclBinaryTree.Node left_node = crnt_node.makeLeft(left_info);

	IntervalInfo right_info = new IntervalInfo();
	right_info.left = left_info.right;
	right_info.right = crnt_info.right;

	JgclBinaryTree.Node right_node = crnt_node.makeRight(right_info);

	// check

	if (!checkInterval(left_info, tol))
	    no_pnts += divideInterval(left_node, tol);

	if (!checkInterval(right_info, tol))
	    no_pnts += divideInterval(right_node, tol);

	return no_pnts;
    }

    /**
     * ^ꂽp[^ԂɂāA
     * Ԃ̗[Ԍłꂽ_̃p[^l߂钊ۃ\bhB
     * <p>
     * ̃\bh
     * {@link #checkInterval(JgclConic2D.IntervalInfo, double)
     * checkInterval(JgclConic2D.IntervalInfo, double)}
     * ŌĂяoB
     * </p>
     * 
     * @param left	[ (ԉ) ̃p[^l
     * @param right	E[ (ԏ) ̃p[^l
     * @return		łꂽ_̃p[^l
     * @see	#checkInterval(JgclConic2D.IntervalInfo, double)
     */
    abstract double getPeak(double left, double right);

    /**
     * ̋Ȑ́A^ꂽԂ́uvw̐x菬ۂԂB
     * <p>
     * Ԃ́uv
     * {@link #getPeak(double, double) getPeak(double, double)}
     * œB
     * </p>
     * <p>
     * ̃\bh
     * {@link #toPolyline(JgclParameterSection, JgclToleranceForDistance)
     * toPolyline(JgclParameterSection, JgclToleranceForDistance)}
     * ̓ł̂ݗpB
     * mɂ́A
     * toPolyline(JgclParameterSection, JgclToleranceForDistance) 
     * ŌĂяo
     * {@link #divideInterval(JgclBinaryTree.Node, double)
     * divideInterval(JgclBinaryTree.Node, double)}
     * ̒ł̂݌ĂяoB
     * </p>
     *
     * @param info	Ȑ̋
     * @param tol	ߎ̐xƂė^ꂽűe덷v
     * @return	Ԃ́uvw̐x菬 trueAłȂ false
     * @see	#getPeak(double, double)
     */
    private boolean checkInterval(IntervalInfo info, double tol) {
	double peak_param = getPeak(info.left.parameter(),
				    info.right.parameter());

	// ̃R[hŒuč : hideit 2000/03/17
	/***
	JgclPointOnCurve2D peak = null;
	try {
	    peak = new JgclPointOnCurve2D(this, peak_param, doCheckDebug);
	}
	catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}

	JgclLine2D line = new JgclLine2D(info.left, info.right);
	JgclPoint2D proj;
	try {
	    proj = line.project1From(peak);
	}
	catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}

	return (peak.subtract(proj).norm() < (tol * tol));
	***/

	// ̃R[h
	JgclPoint2D peak = this.coordinates(peak_param);
	JgclVector2D unitChord = info.right.subtract(info.left).unitized();
	JgclVector2D left2peak = peak.subtract(info.left);
	double height = Math.abs(left2peak.zOfCrossProduct(unitChord));

	return (height < tol);
    }

    /**
     * qm[hȂm[h́uf[^v
     * ^ꂽzɑ JgclBinaryTree.TraverseProcB
     */
    private class FillArray implements JgclBinaryTree.TraverseProc {
	/**
	 * qm[hȂm[h́uf[^v^ꂽzɑB
	 * <p>
	 * pdata  {@link JgclConic2D.FillInfo JgclConic2D.FillInfo} NX
	 * CX^XłȂ΂ȂȂB
	 * </p>
	 * <p>
	 * ̓NX
	 * {@link #toPolyline(JgclParameterSection, JgclToleranceForDistance)
	 * toPolyline(JgclParameterSection, JgclToleranceForDistance)}
	 * ̓ł̂ݗpB
	 * </p>
	 *
	 * @param node	ΏۂƂȂm[h
	 * @param ctl	Jnm[h node ܂ł̐[ (QƂȂ)
	 * @param pdata	m[h́uf[^vz
	 * @see #toPolyline(JgclParameterSection, JgclToleranceForDistance)
	 */
	public boolean doit(JgclBinaryTree.Node node, int ctl, Object pdata) {
	    if ((node.left() == null) && (node.right() == null)) {

		FillInfo fill_info = (FillInfo)pdata;
		int idx = fill_info.index;
		IntervalInfo info = (IntervalInfo)node.data();

		if (idx == 0)
		    fill_info.pnts[idx++] = info.left;

		fill_info.pnts[idx++] = info.right;
		fill_info.index = idx;
	    }
	    return false;
	}
    }

    /**
     * ̋Ȑ̂Ԃ𒼐ߎ_߂邽߂̔zNXB
     * <p>
     * ̓NX
     * {@link #toPolyline(JgclParameterSection, JgclToleranceForDistance)
     * toPolyline(JgclParameterSection, JgclToleranceForDistance)}
     * ̓ł̂ݗpB
     * </p>
     */
    private class FillInfo {
	/**
	 * ̋Ȑ̂Ԃ𒼐ߎ_B
	 */
	private JgclPoint2D[] pnts;

	/**
	 * ̑ pnts[index] ɑ΂čsȂׂł邱ƂlB
	 */
	private int index;

	/**
	 * _ێׂzƁA̗vf̐擪ԍ^
	 * IuWFNg\zB
	 */
	private FillInfo(JgclPoint2D[] pnts, int index) {
	    super();
	    this.pnts = pnts;
	    this.index = index;
	}
    }

    /**
     * ̉~Ȑ́uSvƋǏ̕肵ĂǏWnԂB
     * 
     * @return	SƋǏ̕ǏWn
     */
    public JgclAxis2Placement2D position() {
	return position;
    }

    /**
     * ̋Ȑ̓ٓ_ԂB
     * <p>
     * ~Ȑɂ͓ٓ_݂͑Ȃ̂ŁAɒ 0 ̔zԂB
     * </p>
     * 
     * @return		ٓ_̔z
     */
    public JgclPointOnCurve2D[] singular() {
        return new JgclPointOnCurve2D[0];
    }

    /**
     * ̋Ȑ̕ϋȓ_ԂB
     * <p>
     * ~Ȑɂ͕ϋȓ_݂͑Ȃ̂ŁAɒ 0 ̔zԂB
     * </p>
     * 
     * @return		ϋȓ_̔z
     */
    public JgclPointOnCurve2D[] inflexion() {
        return new JgclPointOnCurve2D[0];
    }

    /**
     * ̋ȐƑ̋Ȑ (xWGȐ) ̌_߂ (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * <ul>
     * <li>	xWGȐẢ~Ȑ̋ǏWnł̕\ɕϊB
     * <li>	̋ȐƕϊxWGȐ̌_\㐔𐶐B
     * <li>	㐔̍߂B
     * <li>	̊eXɂāAԂł̉ƂđÓł邩ۂ؂B
     * <li>	Ԃł̉ƂđÓȍu_v𐶐B
     * </ul>
     * </p>
     *
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclPureBezierCurve2D mate, boolean doExchange) {
	JgclAxis2Placement2D placement = position();
	JgclCartesianTransformationOperator2D transform =
	new JgclCartesianTransformationOperator2D(placement, 1.0);
	int uicp = mate.nControlPoints();
	JgclPoint2D[] newCp = new JgclPoint2D[uicp];

	// Transform Bezier's control points into conic's local coordinates
	for (int i = 0; i < uicp; i++)
	    newCp[i] = transform.toLocal(mate.controlPointAt(i));

	// make Bezier curve from new control points
	JgclPureBezierCurve2D bzc = new
	    JgclPureBezierCurve2D(newCp, mate.weights(), false);

	// For each segment
	Vector pointVec = new Vector();
	Vector paramVec = new Vector();
	boolean isPoly = bzc.isPolynomial();
	// make polynomial
	JgclRealPolynomial[] poly = bzc.polynomial(isPoly);
	JgclRealPolynomial realPoly = makePoly(poly);
	JgclComplexPolynomial compPoly = realPoly.toComplexPolynomial();

	// solve polynomial
	JgclComplex[] roots;
	try {
	    roots = compPoly.getRootsByDKA();
	}
	catch (JgclComplexPolynomial.DKANotConverge e) {
	    roots = e.getValues();
	}
	catch (JgclComplexPolynomial.ImpossibleEquation e) {
	    throw new JgclFatal();
	}
	catch (JgclComplexPolynomial.IndefiniteEquation e) {
	    throw new JgclFatal();
	}

	int nRoots = roots.length;
	for (int j = 0; j < nRoots; j++) {
	    double realRoot = roots[j].real();
	    if (bzc.parameterValidity(realRoot) == JgclParameterValidity.OUTSIDE)
		continue;

	    if (realRoot < 0.0) realRoot = 0.0;
	    if (realRoot > 1.0) realRoot = 1.0;

	    JgclPoint2D workPoint = bzc.coordinates(realRoot);
	    // check solution
	    if (!checkSolution(workPoint))
		continue;
	    for (int jj = 0; jj < pointVec.size(); jj++) {
		JgclPoint2D pt = (JgclPoint2D)pointVec.elementAt(jj);
		double param = ((Double)paramVec.elementAt(jj)).doubleValue();
		if (pt.identical(workPoint)
		    && bzc.identicalParameter(param, realRoot))
		    break;
	    }
	    // add solution
	    pointVec.addElement(workPoint);
	    paramVec.addElement(new Double(realRoot));
	}

	// make intersection point
	int num = paramVec.size();
	JgclIntersectionPoint2D[] intersectPoint = new JgclIntersectionPoint2D[num];
	for (int i = 0; i < num; i++) {
	    // get Parameter from solution point
	    JgclPoint2D point = (JgclPoint2D)pointVec.elementAt(i);
	    double param = getParameter(point);

	    // make intersection point on Conic
	    JgclPointOnCurve2D pointOnConic = new
		JgclPointOnCurve2D(this, param, doCheckDebug);

	    // make intersection point on Bzc
	    double work = ((Double)paramVec.elementAt(i)).doubleValue();
	    JgclPointOnCurve2D pointOnBzc = new
		JgclPointOnCurve2D(mate, work, doCheckDebug);

	    if (!doExchange)
		intersectPoint[i] = new
		    JgclIntersectionPoint2D(pointOnConic, pointOnBzc, doCheckDebug);
	    else
		intersectPoint[i] = new
		    JgclIntersectionPoint2D(pointOnBzc, pointOnConic, doCheckDebug);
	}

	return intersectPoint;
    }

    /**
     * ̋ȐƑ̋Ȑ (aXvCȐ) ̌_߂ (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * <ul>
     * <li>	aXvCȐẢ~Ȑ̋ǏWnł̕\ɕϊB
     * <li>	ϊaXvCȐ̊eZOgɂ
     * <ul>
     * <li>	̋ȐƕϊaXvCȐ̃ZOǧ_\㐔𐶐B
     * <li>	㐔̍߂B
     * <li>	̊eXɂāAԂł̉ƂđÓł邩ۂ؂B
     * </ul>
     * <li>	Ԃł̉ƂđÓȍu_v𐶐B
     * </ul>
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclBsplineCurve2D mate, boolean doExchange) {
	JgclAxis2Placement2D placement = position();
	JgclCartesianTransformationOperator2D transform =
	new JgclCartesianTransformationOperator2D(placement, 1.0);
	JgclBsplineKnot.ValidSegmentInfo vsegInfo =	mate.validSegments();
	JgclPoint2D[] cp = mate.controlPoints();
	int uicp = mate.nControlPoints();
	JgclPoint2D[] newCp = new JgclPoint2D[uicp];

	// Transform Bspline's control points into conic's local coordinates
	for (int i = 0; i < uicp; i++)
	newCp[i] = transform.toLocal(cp[i]);

	// make Bspline curve from new control points
	JgclBsplineCurve2D bsc = new
	    JgclBsplineCurve2D(mate.knotData(), newCp, mate.weights());

	// For each segment
	Vector pointVec = new Vector();
	Vector paramVec = new Vector();
	int nSeg = vsegInfo.nSegments();
	int k = 0;
	for (int i = 0; i < nSeg; i++) {
	    // make polynomial
	    JgclRealPolynomial[] poly =
		bsc.polynomial(vsegInfo.segmentNumber(i), bsc.isPolynomial());
	    JgclRealPolynomial realPoly = makePoly(poly);
	    JgclComplexPolynomial compPoly = realPoly.toComplexPolynomial();

	    // solve polynomial
	    JgclComplex[] roots;
	    try {
		roots = compPoly.getRootsByDKA();
	    }
	    catch (JgclComplexPolynomial.DKANotConverge e) {
		roots = e.getValues();
	    }
	    catch (JgclComplexPolynomial.ImpossibleEquation e) {
		throw new JgclFatal();
	    }
	    catch (JgclComplexPolynomial.IndefiniteEquation e) {
		throw new JgclFatal();
	    }

	    int nRoots = roots.length;
	    for (int j = 0; j < nRoots; j++) {
		double realRoot = roots[j].real();
		if (bsc.parameterValidity(realRoot) == JgclParameterValidity.OUTSIDE)
		    continue;

		double[] knotParams = vsegInfo.knotPoint(i);
		if (realRoot < knotParams[0]) realRoot = knotParams[0];
		if (realRoot > knotParams[1]) realRoot = knotParams[1];

		JgclPoint2D workPoint = bsc.coordinates(realRoot);
		// check solution
		if (!checkSolution(workPoint))
		    continue;
		int jj;
		for (jj = 0; jj < k; jj++) {
		    double dTol = bsc.getToleranceForDistance();
		    JgclPoint2D pt = (JgclPoint2D)pointVec.elementAt(jj);
		    double param = ((Double)paramVec.elementAt(jj)).doubleValue();
		    if (pt.identical(workPoint)
			&& bsc.identicalParameter(param, realRoot))
			break;
		}
		// add solution
		if (jj >= k) {
		    pointVec.addElement(workPoint);
		    paramVec.addElement(new Double(realRoot));
		    k++;
		}
	    }
	}

	// make intersection point
	int num = paramVec.size();
	JgclIntersectionPoint2D[] intersectPoint = new JgclIntersectionPoint2D[num];
	for (int i = 0; i < k; i++) {
	    // get Parameter from solution point
	    JgclPoint2D point = (JgclPoint2D)pointVec.elementAt(i);
	    double param = getParameter(point);

	    // make intersection point on Conic
	    JgclPointOnCurve2D pointOnConic = new
		JgclPointOnCurve2D(this, param, doCheckDebug);

	    // make intersection point on Bsc
	    double work = ((Double)paramVec.elementAt(i)).doubleValue();
	    JgclPointOnCurve2D pointOnBsc = new
		JgclPointOnCurve2D(mate, work, doCheckDebug);

	    if (!doExchange)
		intersectPoint[i] = new JgclIntersectionPoint2D
		    (pointOnConic, pointOnBsc, doCheckDebug);
	    else
		intersectPoint[i] = new JgclIntersectionPoint2D
		    (pointOnBsc, pointOnConic, doCheckDebug);
	}

	return intersectPoint;
    }

    /**
     * ̉~Ȑ (\ꂽ) RȐ̌_\㐔𐶐钊ۃ\bhB
     * 
     * @param poly	xWGȐ邢͂aXvCȐ̂ZOg̑\̔z
     * @return		̉~Ȑ poly ̌_\㐔̍
     * @see	#intersect(JgclPureBezierCurve2D, boolean)
     * @see	#intersect(JgclBsplineCurve2D, boolean)
     */
    abstract JgclRealPolynomial makePoly(JgclRealPolynomial[] poly);

    /**
     * ^ꂽ_̋Ȑɂ邩ۂ`FbN钊ۃ\bhB
     * 
     * @param point	ΏۂƂȂ_
     * @return		^ꂽ_̋Ȑɂ trueAłȂ false
     * @see	#intersect(JgclPureBezierCurve2D, boolean)
     * @see	#intersect(JgclBsplineCurve2D, boolean)
     */
    abstract boolean checkSolution(JgclPoint2D point);

    /**
     * ^ꂽ_̋Ȑɂ̂ƂāA
     * ̓_̋Ȑł̃p[^l߂钊ۃ\bhB
     * 
     * @param point	ΏۂƂȂ_
     * @return		p[^l
     * @see	#intersect(JgclPureBezierCurve2D, boolean)
     * @see	#intersect(JgclBsplineCurve2D, boolean)
     */
    abstract double getParameter(JgclPoint2D point);

    /**
     * ̋Ȑ̎w̋ԂČ (L) xWGȐ̐_ԂB
     * <p>
     * d݂ɂẮÃ\bhł͊֒mȂB
     * </p>
     * <p>
     * 鐧_̗vf͏ 3 łB
     * </p>
     * <p>
     * pint ̑l͕ł\ȂB
     * pint ̑l̏ꍇɂ́A
     * 鐧_񂪕\xWGȐ̐iśA̋Ȑ̐is̋tɂȂB
     * </p>
     * <p>
     * ȂA^ꂽԂ{̃xWGȐōČłȂꍇA
     * 錋ʂ͐ȂƂɒӁB
     * </p>
     *
     * @param pint	xWGȐōČp[^
     * @return		ԂČxWGȐ̐_
     */
    protected JgclPoint2D[] getControlPointsOfBezierCurve(JgclParameterSection pint) {
	JgclCurveDerivative2D derivative;

	derivative = this.evaluation(pint.lower());
	JgclLine2D lowerTangentLine = new JgclLine2D(derivative.d0D(), derivative.d1D());

	derivative = this.evaluation(pint.upper());
	JgclLine2D upperTangentLine = new JgclLine2D(derivative.d0D(), derivative.d1D());

	JgclPoint2D[] controlPoints = new JgclPoint2D[3];

	if (pint.increase() > 0.0) {
	    controlPoints[0] = lowerTangentLine.pnt();
	    controlPoints[2] = upperTangentLine.pnt();
	} else {
	    controlPoints[2] = lowerTangentLine.pnt();
	    controlPoints[0] = upperTangentLine.pnt();
	}

	double atol = this.getToleranceForAngle();
	boolean push = false;
	double angle = lowerTangentLine.dir().angleWith(upperTangentLine.dir());
	double angleFromParallel;

	if ((angleFromParallel = angle) < atol)
	    push = true;
	else if ((angleFromParallel = Math.abs(Math.PI - angle)) < atol)
	    push = true;
	else if ((angleFromParallel = Math.abs(JgclMath.PI2 - angle)) < atol)
	    push = true;

	if (push == true)
	    JgclConditionOfOperation.getCondition().
		makeCopyWithToleranceForAngle(angleFromParallel / 2.0).push();

	try {
	    controlPoints[1] = lowerTangentLine.intersect1Line(upperTangentLine).literal();
	} catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal("Two tangent lines does not intersect");
	} finally {
	    if (push == true)
		JgclConditionOfOperation.pop();
	}

	return controlPoints;
    }

    /**
     * ~Ȑ̈ꕔČLxWGȐ{̗LaXvCȐɕϊB
     * <p>
     * ^LxWGȐ́A~Ȑ̈ꕔČ̂ŁA
     * Ȑ̗vf 1 Ȃ 3 łA
     * evfׂ͂ĂQȐł̂Ƒz肵ĂB
     * </p>
     * <p>
     * ̐̂߁Ã\bh́A
     * xWGȐ邢͂aXvCȐ̃NXɒuׂł͂ȂƍlB
     * </p>
     *
     * @param bezierCurves	(~Ȑ̈ꕔČ) LxWGȐ
     * @param closed	LxWGȐ񂪕Ă trueAłȂ false
     * @return	LaXvCȐ
     */
    protected static JgclBsplineCurve2D
    convertPolyBezierCurvesToOneBsplineCurve(JgclPureBezierCurve2D[] bezierCurves,
					     boolean closed) {
	int nBeziers = bezierCurves.length;
	int uicp;
	int uik;

	if (closed != true) {
	    // open
	    uicp = (nBeziers != 3) ? (nBeziers + 2) : (nBeziers + 3);
	    uik  = nBeziers + 1;
	} else {
	    // closed : nBeziers should be always 3
	    uicp = 5;   // nBeziers + 2
	    uik  = 6;	// nBeziers + 3
	}

	int degree = 2;
	boolean periodic = closed;
	int[] knotMultiplicities = new int[uik];
	double[] knots = new double[uik];
	JgclPoint2D[] controlPoints = new JgclPoint2D[uicp];
	double[] weights = new double[uicp];

	switch (nBeziers) {
	case 1:
	    for (int i = 0; i < 3; i++) {
		controlPoints[i] = bezierCurves[0].controlPointAt(i);
		weights[i] = bezierCurves[0].weightAt(i);
	    }
	    knots[0] = 0.0; knotMultiplicities[0] = 3;
	    knots[1] = 1.0; knotMultiplicities[1] = 3;
	    break;

	case 2:
	    /*
	     * weights:
	     *              inverse of standard form              bspline
	     *	1 a 1 1 a 1 ========================> 1 b b b b 1 =======> 1 b b 1
	     *
	     *	b = a * a
	     */
	    controlPoints[0] = bezierCurves[0].controlPointAt(0);
	    controlPoints[1] = bezierCurves[0].controlPointAt(1);
	    controlPoints[2] = bezierCurves[1].controlPointAt(1);
	    controlPoints[3] = bezierCurves[1].controlPointAt(2);
	    weights[0] = 1.0;
	    weights[1] = weights[2] =
		bezierCurves[0].weightAt(1) * bezierCurves[0].weightAt(1);
	    weights[3] = 1.0;

	    knots[0] = 0.0; knotMultiplicities[0] = 3;
	    knots[1] = 1.0; knotMultiplicities[1] = 1;
	    knots[2] = 2.0; knotMultiplicities[2] = 3;
	    break;

	case 3:
	    if (closed != true) {
		// open
		controlPoints[0] = bezierCurves[0].controlPointAt(0);
		controlPoints[1] = bezierCurves[0].controlPointAt(1);
		controlPoints[2] = bezierCurves[1].controlPointAt(1);
		controlPoints[3] = bezierCurves[1].controlPointAt(2);
		controlPoints[4] = bezierCurves[2].controlPointAt(1);
		controlPoints[5] = bezierCurves[2].controlPointAt(2);
		weights[0] = 1.0;
		weights[1] = weights[2] =
		    bezierCurves[0].weightAt(1) * bezierCurves[0].weightAt(1);
		weights[3] = 1.0;
		weights[4] = bezierCurves[2].weightAt(1);
		weights[5] = 1.0;

		knots[0] = 0.0; knotMultiplicities[0] = 3;
		knots[1] = 1.0; knotMultiplicities[1] = 1;
		knots[2] = 2.0; knotMultiplicities[2] = 2;
		knots[3] = 4.0; knotMultiplicities[3] = 3; // knots[3] != 3.0
	    } else {
		// closed
		controlPoints[0] = bezierCurves[2].controlPointAt(1);
		controlPoints[1] = bezierCurves[0].controlPointAt(0);
		controlPoints[2] = bezierCurves[0].controlPointAt(1);
		controlPoints[3] = bezierCurves[1].controlPointAt(1);
		controlPoints[4] = bezierCurves[1].controlPointAt(2);
		weights[0] = bezierCurves[2].weightAt(1);
		weights[1] = 1.0;
		weights[2] = weights[3] =
		    bezierCurves[0].weightAt(1) * bezierCurves[0].weightAt(1);
		weights[4] = 1.0;

		knots[0] = (-2.0); knotMultiplicities[0] = 2;
		knots[1] = 0.0;    knotMultiplicities[1] = 2;
		knots[2] = 1.0;    knotMultiplicities[2] = 1;
		knots[3] = 2.0;    knotMultiplicities[3] = 2;
		knots[4] = 4.0;    knotMultiplicities[4] = 2; // knots[4] != 3.0
		knots[5] = 5.0;    knotMultiplicities[5] = 1;
	    }
	    break;
	}

	return new JgclBsplineCurve2D(degree, periodic,
				      knotMultiplicities, knots,
				      controlPoints, weights);
    }
}

