/*
 * Q : Ȑ\ZOg\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclCompositeCurveSegment2D.java,v 1.59 2000/08/11 06:18:46 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * Q : Ȑ\ZOg\NXB
 * <p>
 * ȐƂ́A ([_ŘA) ̗LȐ܂Ƃ߂
 * {̋ȐɌĂ̂łB
 * ̃NX́A
 * ̕Ȑ\X̗LȐ (𕡍Ȑ̃ZOgƂ)
 * \B
 * </p>
 * <p>
 * ̃NX̃CX^X́A
 * <ul>
 * <li> ZOg̎ۂ̋OՂ\LȐ parentCurve (ȐƂ)
 * <li>	ZOgȐƓۂtO sameSense
 * <li> ̃ZOgƂ̘A transition
 * </ul>
 * ێB
 * </p>
 * <p>
 * ȐZOg̒`́AȐ̒`ɈvB
 * </p>
 * <p>
 * <a name="CONSTRAINTS">[Ԃ̍S]</a>
 * </p>
 * <p>
 * parentCurve ͊J`łȂ΂ȂȂB
 * </p>
 *
 * @version $Revision: 1.59 $, $Date: 2000/08/11 06:18:46 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclCompositeCurve2D
 */

public class JgclCompositeCurveSegment2D extends JgclBoundedCurve2D {

    /**
     * ̃ZOgƂ̘AB
     * @serial
     * @see JgclTransitionCode
     */
    private int transition;

    /**
     * ZOgȐƓۂtOB
     * @serial
     */
    private boolean sameSense;

    /**
     * ZOg̎ۂ̋OՂ\ȐB
     * @serial
     */
    private JgclBoundedCurve2D parentCurve;

    /**
     * etB[hɐݒ肷l^ăIuWFNg\zB
     * <p>
     * ̒l <a href="#CONSTRAINTS">[Ԃ̍S]</a> 𖞂Ȃꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param transition	̃ZOgƂ̘A
     * @param sameSense		ȐƓۂtO
     * @param parentCurve	Ȑ
     * @see	JgclTransitionCode
     * @see	JgclInvalidArgumentValue
     */
    public JgclCompositeCurveSegment2D(int transition, boolean sameSense,
				       JgclBoundedCurve2D parentCurve)
    {
	super();

	if (parentCurve.isPeriodic() || parentCurve.isInfinite())
	    throw new JgclInvalidArgumentValue();

	this.transition = transition;
	this.sameSense = sameSense;
	this.parentCurve = parentCurve;
    }

    /**
     * ̃ZOg̎̃ZOgƂ̘AԂB
     * 
     * @return	̃ZOgƂ̘A
     * @see	JgclTransitionCode
     */
    public int transition() {
	return this.transition;
    }

    /**
     * ̃ZOgȐƓۂtOԂB
     * 
     * @return	ȐƓۂtO
     */
    public boolean sameSense() {
	return this.sameSense;
    }

    /**
     * ̃ZOg̕ȐԂB
     * 
     * @return	Ȑ
     */
    public JgclBoundedCurve2D parentCurve() {
	return this.parentCurve;
    }

    /**
     * ̗LȐ̊Jn_ԂB
     *
     * @return	Jn_
     */
    public JgclPoint2D startPoint() {
	if (sameSense)
	    return parentCurve.startPoint();
	else
	    return parentCurve.endPoint();
    }

    /**
     * ̗LȐ̏I_ԂB
     *
     * @return	I_
     */
    public JgclPoint2D endPoint() {
	if (sameSense)
	    return parentCurve.endPoint();
	else
	    return parentCurve.startPoint();
    }

    /**
     * ̗LȐ̊Jn_̃p[^lԂB
     *
     * @return	Jn_̃p[^l
     */
    double sParameter() {
	return parameterDomain().section().start();
    }

    /**
     * ̗LȐ̏I_̃p[^lԂB
     *
     * @return	I_̃p[^l
     */
    double eParameter() {
	return parameterDomain().section().end();
    }

    /**
     * ̃ZOgɑ΂ė^ꂽp[^lA
     * Ȑɑ΂p[^lɕϊB
     * <p>
     * ̃ZOg̒`͕Ȑ̒`ƈv邪A
     * sameSense  false ̏ꍇɂ́Ap[^l̕ϊKvɂȂB
     * </p>
     * <p>
     * ^ꂽp[^l̋Ȑ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param param	ZOgɑ΂p[^l
     * @return	Ȑɑ΂p[^l
     */
    private double toBasisParameter(double param) {
	checkValidity(param);

	if (sameSense)
	    return param;
	else {
	    JgclParameterSection sec = parameterDomain().section();
	    return sec.end() - (param - sec.start());
	}
    }

    /**
     * ̃ZOgɑ΂ė^ꂽp[^ԂA
     * Ȑɑ΂p[^ԂɕϊB
     * <p>
     * ̃ZOg̒`͕Ȑ̒`ƈv邪A
     * sameSense  false ̏ꍇɂ́Ap[^l̕ϊKvɂȂB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ̋Ȑ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param pint	ZOgɑ΂p[^
     * @return	Ȑɑ΂p[^
     */
    public JgclParameterSection toBasisParameter(JgclParameterSection pint) {
	double start = toBasisParameter(pint.start());
	double end = toBasisParameter(pint.end());

	return new JgclParameterSection(start, end - start);
    }

    /**
     * ̃ZOg̕Ȑɑ΂ė^ꂽp[^lA
     * ̃ZOgɑ΂p[^lɕϊB
     * <p>
     * ̃ZOg̒`͕Ȑ̒`ƈv邪A
     * sameSense  false ̏ꍇɂ́Ap[^l̕ϊKvɂȂB
     * </p>
     *
     * @param param	Ȑɑ΂p[^l
     * @return	ZOgɑ΂p[^l
     */
    private double toOwnParameter(double param) {
	double result;

	if (sameSense)
	    result = param;
	else {
	    JgclParameterSection sec = parameterDomain().section();
	    result = sec.start() - (param - sec.end());
	}

	return result;
    }

    /**
     * ^ꂽp[^Ԃɂ邱̋Ȑ̎ԏł̒ (̂) ԂB
     * <p>
     * pint ̑l͕ł܂ȂB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ̋Ȑ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param pint	Ȑ̒߂p[^
     * @return	w肳ꂽp[^ԂɂȐ̒
     * @see	JgclParameterOutOfRange
     */
    public double length(JgclParameterSection pint) {
	return parentCurve.length(toBasisParameter(pint));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		Wl
     * @see	JgclParameterOutOfRange
     */
    public JgclPoint2D coordinates(double param) {
	return parentCurve.coordinates(toBasisParameter(param));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		ڃxNg
     * @see	JgclParameterOutOfRange
     */
    public JgclVector2D tangentVector(double param) {
	JgclVector2D tang = parentCurve.tangentVector(toBasisParameter(param));

	if (sameSense)
	    return tang;
	else
	    return tang.multiply(-1);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		ȗ
     * @see	JgclParameterOutOfRange
     */
    public JgclCurveCurvature2D curvature(double param) {
	return parentCurve.curvature(toBasisParameter(param));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		֐
     * @see	JgclParameterOutOfRange
     */
    public JgclCurveDerivative2D evaluation(double param) {
	JgclCurveDerivative2D curv =
	    parentCurve.evaluation(toBasisParameter(param));
	if (sameSense)
	    return curv;
	else {
	    JgclCurveDerivative2D rcurv =
		new JgclCurveDerivative2D(curv.d0D(), curv.d1D().multiply(-1),
					  curv.d2D());
	    return rcurv;
	}
    }

    /**
     * ̋Ȑ̓ٓ_ԂB
     * <p>
     * ٓ_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @return	ٓ_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    public JgclPointOnCurve2D[] singular() throws JgclIndefiniteSolution {
	JgclPointOnCurve2D[] singular = parentCurve.singular();
	JgclPointOnCurve2D[] thisSingular =
	  new JgclPointOnCurve2D[singular.length];

	for (int i = 0; i < singular.length; i++) {
	    try {
		thisSingular[i] = new JgclPointOnCurve2D
		    (this, toOwnParameter(singular[i].parameter()));
	    }
	    catch(JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }

	}
	return thisSingular;
    }

    /**
     * ̋Ȑ̕ϋȓ_ԂB
     * <p>
     * ϋȓ_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @return	ϋȓ_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    public JgclPointOnCurve2D[] inflexion() throws JgclIndefiniteSolution {
	JgclPointOnCurve2D[] inflexion = parentCurve.inflexion();
	JgclPointOnCurve2D[] thisInflexion =
	    new JgclPointOnCurve2D[inflexion.length];

	for (int i = 0; i < inflexion.length; i++) {
	    try {
		thisInflexion[i] = new JgclPointOnCurve2D
		    (this, toOwnParameter(inflexion[i].parameter()));
	    }
	    catch(JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}
	return thisInflexion;
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * e_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param point	e̓_
     * @return	e_
     * @exception JgclIndefiniteSolution	sł
     */
    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D point) 
        throws JgclIndefiniteSolution
    {
	JgclPointOnCurve2D[] proj = parentCurve.projectFrom(point);
	JgclPointOnCurve2D[] thisProj =
        new JgclPointOnCurve2D[proj.length];
	for (int i = 0; i < proj.length; i++) {
	    try {
		thisProj[i] = new JgclPointOnCurve2D
		    (this, toOwnParameter(proj[i].parameter()));
	    }
	    catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}
	return thisProj;
    }

    /**
     * ̋Ȑ̎w̋ԂA^ꂽ덷Œߎ|CԂB
     * <p>
     * ʂƂĕԂ|C\_
     * ̋Ȑx[XȐƂ JgclPointOnCurve2D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * section ̒lÃxWGȐ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param section	ߎp[^
     * @param tolerance	̋e덷
     * @return		̋Ȑ̎w̋Ԃ𒼐ߎ|C
     * @see	JgclParameterOutOfRange
     */
    public JgclPolyline2D toPolyline(JgclParameterSection pint,
				     JgclToleranceForDistance tol)
    {
	JgclPolyline2D pl = parentCurve.toPolyline(toBasisParameter(pint), tol);
	JgclPoint2D[] pnts = new JgclPoint2D[pl.nPoints()];

	for (int i = 0; i < pnts.length; i++) {
	    JgclPointOnCurve2D p = (JgclPointOnCurve2D)pl.pointAt(i);
	    pnts[i] = new JgclPointOnCurve2D(this, toOwnParameter(p.parameter()), doCheckDebug);
	}
	return new JgclPolyline2D(pnts);
    }

    /**
     * ̋Ȑ̎w̋ԂɍČL Bspline ȐԂB
     * <p>
     * pint ̒lÂaXvCȐ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param pint	L Bspline ȐōČp[^
     * @return		̋Ȑ̎w̋ԂČL Bspline Ȑ
     * @see	JgclParameterOutOfRange
     */
    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
	return parentCurve.toBsplineCurve(toBasisParameter(pint));
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * ̋Ȑ̕ȐƑ̋Ȑ̌_߂ɁA
     * ̕Ȑɑ΂p[^l
     * ̃ZOgɑ΂p[^lɕϊ
     * u_vƂĂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    private JgclIntersectionPoint2D[] doIntersect(JgclParametricCurve2D mate,
						  boolean doExchange) {
	JgclIntersectionPoint2D[] ints;
	try {
	    ints = parentCurve.intersect(mate);
	} catch (JgclIndefiniteSolution e) {
	    return new JgclIntersectionPoint2D[0];	// ??
	}
	JgclIntersectionPoint2D[] thisInts =
	    new JgclIntersectionPoint2D[ints.length];

	for (int i = 0; i < ints.length; i++) {
	    double param = toOwnParameter(ints[i].pointOnCurve1().parameter());
	    JgclPointOnCurve2D thisPnts =
		new JgclPointOnCurve2D(this, param, doCheckDebug);

	    if (!doExchange)
		thisInts[i] =
		    new JgclIntersectionPoint2D(thisPnts, ints[i].pointOnCurve2(), doCheckDebug);
	    else
		thisInts[i] =
		    new JgclIntersectionPoint2D(ints[i].pointOnCurve2(), thisPnts, doCheckDebug);
	}
	return thisInts;
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return	_̔z
     */
    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate) {
	return doIntersect(mate, false);
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclCircle2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȉ~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȉ~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclEllipse2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclParabola2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (oȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (oȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (|C) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclPureBezierCurve2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclBsplineCurve2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (gȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (gȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȐZOg) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȐZOg)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (Ȑ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		Ȑ̊̔z
     */
    public JgclCurveCurveInterference2D[] interfere(JgclBoundedCurve2D mate) {
	return this.interfere(mate, false);
    }

    /**
     * Ȑɑ΂p[^l
     * ZOgɑ΂p[^lւ̕ϊ\NXB
     * @see	#interfere(JgclBoundedCurve2D, boolean)
     */
    class ToSegmentConversion extends JgclParameterConversion2D {
	/**
	 * ^ɃIuWFNg\zB
	 */
	ToSegmentConversion() {
	}

	/**
	 * Ȑɑ΂p[^lZOgɑ΂p[^l֕ϊB
	 * 
	 * @param param	Ȑɑ΂p[^l
	 * @return	ZOgɑ΂p[^l
	 */
	double convParameter(double param) {
	    return JgclCompositeCurveSegment2D.this.toOwnParameter(param);
	}

	/**
	 * Ȑɑ΂p[^lϊΏۂłZOgԂB
	 * 
	 * @param param Ȑɑ΂p[^l
	 * @return	ZOg
	 */
	JgclParametricCurve2D convCurve(double param) {
	    return JgclCompositeCurveSegment2D.this;
	}
    }

    /**
     * ̗LȐƑ̗LȐ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȑ̕ȐƑ̗LȐ̊߂ɁA
     * ̕Ȑɑ΂p[^l
     * ̃ZOgɑ΂p[^lɕϊ
     * uvƂĂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     * @see	JgclCompositeCurveSegment2D.ToSegmentConversion
     */
    JgclCurveCurveInterference2D[] interfere(JgclBoundedCurve2D mate,
					     boolean doExchange) {
	ToSegmentConversion conv = new ToSegmentConversion();
	JgclParameterSection sec = this.parameterDomain().section();

	JgclCurveCurveInterference2D[] intf;
	if (!doExchange) {
	    intf = this.parentCurve.interfere(mate);
	} else {
	    intf = mate.interfere(this.parentCurve);
	}

	Vector vec = new Vector();

	for (int i = 0; i < intf.length; i++) {
	    JgclCurveCurveInterference2D trimintf;
	    if (!doExchange) {
		trimintf = intf[i].trim1(sec, conv);
	    } else {
		trimintf = intf[i].trim2(sec, conv);
	    }
	    if (trimintf != null)
		vec.addElement(trimintf);
	}
	JgclCurveCurveInterference2D[] interf =
	    new JgclCurveCurveInterference2D[vec.size()];
	vec.copyInto(interf);
	return interf;
    }

    /**
     * ̗LȐƑ̗LȐ () ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ ()
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#interfere(JgclBoundedCurve2D, boolean)
     */
    JgclCurveCurveInterference2D[] interfere(JgclBoundedLine2D mate,
					     boolean doExchange)
    {
	return this.interfere((JgclBoundedCurve2D)mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (|C) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (|C)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#interfere(JgclBoundedCurve2D, boolean)
     */
    JgclCurveCurveInterference2D[] interfere(JgclPolyline2D mate,
					     boolean doExchange)
    {
	return this.interfere((JgclBoundedCurve2D)mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (xWGȐ) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (xWGȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#interfere(JgclBoundedCurve2D, boolean)
     */
    JgclCurveCurveInterference2D[] interfere(JgclPureBezierCurve2D mate,
					     boolean doExchange)
    {
	return this.interfere((JgclBoundedCurve2D)mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (aXvCȐ) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (aXvCȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#interfere(JgclBoundedCurve2D, boolean)
     */
    JgclCurveCurveInterference2D[] interfere(JgclBsplineCurve2D mate,
					     boolean doExchange)
    {
	return this.interfere((JgclBoundedCurve2D)mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (gȐ) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (gȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#interfere(JgclBoundedCurve2D, boolean)
     */
    JgclCurveCurveInterference2D[] interfere(JgclTrimmedCurve2D mate,
					     boolean doExchange) {
	return this.interfere((JgclBoundedCurve2D)mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (ȐZOg) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (ȐZOg)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#interfere(JgclBoundedCurve2D, boolean)
     */
    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurveSegment2D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (Ȑ) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (Ȑ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#interfere(JgclBoundedCurve2D, boolean)
     */
    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurve2D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎ Bspline Ȑ߂B
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎ Bspline Ȑ
     * @see	JgclWhichSide
     */
    public JgclBsplineCurve2D offsetByBsplineCurve(JgclParameterSection pint,
						   double magni,
                                                   int side,
                                                   JgclToleranceForDistance tol) {
	JgclOfst2D doObj = new JgclOfst2D(this, pint, magni, side, tol);
	return doObj.offset();
    }

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎLȐ߂B
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎLȐ
     * @see	JgclWhichSide
     */
    public JgclBoundedCurve2D
        offsetByBoundedCurve(JgclParameterSection pint,
			     double magni,
                             int side,
                             JgclToleranceForDistance tol)
    {
	JgclParameterSection basisPint = this.toBasisParameter(pint);
	int basisSide = (this.sameSense() == true)
	    ? side : JgclWhichSide.reverse(side);

	return this.parentCurve().offsetByBoundedCurve(basisPint, magni, basisSide, tol);
    }

    /**
     * ̋Ȑ̎w̋ԂƁA̋Ȑ̎w̋ԂɂtBbg߂B
     * <p>
     * tBbg݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param pint1	̋Ȑ̃p[^
     * @param side1	̋Ȑ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.LEFTȂ΍ARIGHTȂΉEABOTHȂΗ)
     * @param mate	̋Ȑ
     * @param pint2	̋Ȑ̃p[^
     * @param side2	̋Ȑ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.LEFTȂ΍ARIGHTȂΉEABOTHȂΗ)
     * @param radius	tBbga
     * @param doExchange	tBbg point1/2 邩ǂ
     * @return		tBbg̔z
     * @exception JgclIndefiniteSolution	s (ł͔Ȃ)
     */
    JgclFilletObject2D[] doFillet(JgclParameterSection pint1,
				  int side1,
				  JgclParametricCurve2D mate,
				  JgclParameterSection pint2,
				  int side2,
				  double radius,
				  boolean doExchange)
	throws JgclIndefiniteSolution
    {
	JgclFilletObject2D[] flts;
	try {
	    flts = parentCurve.fillet(toBasisParameter(pint1), side1, mate, pint2, side2, radius);
	} catch (JgclIndefiniteSolution e) {
	    flts = new JgclFilletObject2D[1];
	    flts[0] = (JgclFilletObject2D)e.suitable();
	}

	for (int i = 0; i < flts.length; i++) {
	    double param = toOwnParameter(flts[i].pointOnCurve1().parameter());
	    JgclPointOnCurve2D thisPnt = new JgclPointOnCurve2D(this, param, doCheckDebug);

	    if (!doExchange)
		flts[i] = new JgclFilletObject2D(radius, flts[i].center(), thisPnt, flts[i].pointOnCurve2());
	    else
		flts[i] = new JgclFilletObject2D(radius, flts[i].center(), flts[i].pointOnCurve2(), thisPnt);
	}
	return flts;
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʐڐ߂B
     * <p>
     * ʐڐ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     *
     * @param mate	̋Ȑ
     * @return		ʐڐ̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʖ@߂B
     * <p>
     * ʖ@݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		ʖ@̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonNormal2D[] commonNormal(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     * <p>
     * Ȑ̒`ԂB
     * </p>
     *
     * @return	LŔIȃp[^`
     */
    JgclParameterDomain getParameterDomain() {
	return parentCurve.parameterDomain();
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve2D#COMPOSITE_CURVE_SEGMENT_2D JgclParametricCurve2D.COMPOSITE_CURVE_SEGMENT_2D}
     */
    int type() {
	return COMPOSITE_CURVE_SEGMENT_2D;
    }

    /**
     * ̊􉽗vfR`󂩔ۂԂB
     *
     * @return	ȐR`ł trueAłȂ false
     */
    public boolean isFreeform() {
	return this.parentCurve.isFreeform();
    }

    /**
     * ̃ZOǵũZOgƂ̘Av
     * w̒lɕύXIuWFNgԂB
     *
     * @param transition	̃ZOgƂ̘A
     * @return	w̕ύXč쐬ZOg
     */
    JgclCompositeCurveSegment2D makeCopyWithTransition(int transition) {
	return new JgclCompositeCurveSegment2D(transition,
					       this.sameSense,
					       this.parentCurve);
    }

    /**
     * ̃ZOǵũZOgƂ̘Av
     * w̒lɕύXAZOg̕𔽓]IuWFNgԂB
     *
     * @param transition	̃ZOgƂ̘A
     * @return	w̕ύXč쐬ZOg
     */
    JgclCompositeCurveSegment2D makeReverseWithTransition(int transition) {
	return new JgclCompositeCurveSegment2D(transition,
					       !this.sameSense,
					       this.parentCurve);
    }

    /**
     * ̃ZOgA^ꂽp[^ԂŐؒfIuWFNgԂB
     *
     * @param section	ؒfĎc\p[^
     * @return	ؒfĎc\ZOg
     */
    JgclCompositeCurveSegment2D truncate(JgclParameterSection section,
					 int transition) {
	JgclParameterSection parentSection = this.toBasisParameter(section);
	JgclTrimmedCurve2D newParent;

	if (this.parentCurve.type() == TRIMMED_CURVE_2D) {
	    JgclTrimmedCurve2D trc = (JgclTrimmedCurve2D)this.parentCurve;
	    newParent = new JgclTrimmedCurve2D(trc.basisCurve(), parentSection);
	} else {
	    newParent = new JgclTrimmedCurve2D(this.parentCurve, parentSection);
	}

	return new JgclCompositeCurveSegment2D(transition, true, newParent);
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricCurve2D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator2D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclBoundedCurve2D tParentCurve =
	    (JgclBoundedCurve2D)this.parentCurve().transformBy(reverseTransform,
							       transformationOperator,
							       transformedGeometries);
	return new JgclCompositeCurveSegment2D(this.transition(),
					       this.sameSense(),
					       tParentCurve);
    }

    /**
     * ̋Ȑ|C̕܂ނۂԂB
     *
     * @return	̋Ȑ|Cł邩A
     *		܂͎g\镔iƂă|C܂ނȂ trueA
     *		łȂ false
     */
    protected boolean hasPolyline() {
	return parentCurve.hasPolyline();
    }

    /**
     * ̋Ȑ|C̕łłĂ邩ۂԂB
     *
     * @return	̋Ȑ|Cł邩A
     *		܂͎g\镔iƂă|C܂ނȂ trueA
     *		łȂ false
     */
    protected boolean isComposedOfOnlyPolylines() {
	return parentCurve.isComposedOfOnlyPolylines();
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\ttransition\t"
		       + JgclTransitionCode.toString(transition));
        writer.println(indent_tab + "\tsameSense\t" + sameSense);
        writer.println(indent_tab + "\tparentCurve");
        parentCurve.output(writer, indent + 2);
        writer.println(indent_tab + "End");
    }
}
