/*
 * R : Ȑ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclCompositeCurve3D.java,v 1.74 2000/08/11 06:18:45 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;
import java.util.Enumeration;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : Ȑ\NXB
 * <p>
 * ȐƂ́A ([_ŘA) ̗LȐ܂Ƃ߂
 * {̋ȐɌĂ̂łB
 * </p>
 * <p>
 * ̃NX̃CX^X́A
 * <ul>
 * <li> Ȑ\ZOg̔z segments
 * <li> Ȑ`ۂ\tO periodic
 * </ul>
 * ێB
 * </p>
 * <p>
 * Ȑ̒`͗LŁA
 * Ȑ`łΎIA
 * łȂΔIȂ̂ɂȂB
 * p[^` [0, (ZOg̃p[^Ԃ̑l̑a)] ɂȂB
 * </p>
 *
 * @version $Revision: 1.74 $, $Date: 2000/08/11 06:18:45 $
 * @author Information-technology Promotion Agency, Japan
 * @see JgclCompositeCurveSegment3D
 */

public class JgclCompositeCurve3D extends JgclBoundedCurve3D {

    /**
     * Ȑ\ZOg̔zB
     * @serial
     */
    private JgclCompositeCurveSegment3D[] segments;

    /**
     * `ۂ\tOB
     * @serial
     */
    private boolean periodic;

    /**
     * eZOg (̃ZOg̒`ł) Jnp[^l̔zB
     * <p>
     * ̔z̗vf̓ZOgɓ̂ƂB
     * </p>
     * <p>
     * ̃tB[h́ÃNX̓ł̂ݗpB
     * </p>
     * @serial
     */
    private double[] localStartParams;

    /**
     * eZOg (Ȑ̒`ł) Jnp[^l̔zB
     * <p>
     * ̔z̗vf (ZOg + 1) ƂA
     * Ō̗vfɂ͕Ȑ̒`̏Ip[^l܂߂̂ƂB
     * </p>
     * <p>
     * ̃tB[h́ÃNX̓ł̂ݗpB
     * </p>
     * @serial
     */
    private double[] globalStartParams;

    /**
     * ZOg̔zƊJtO^ăIuWFNg\zB
     * 
     * @param segments	Ȑ\ZOg̔z
     * @param periodic	`ۂ\tO
     */
    public JgclCompositeCurve3D(JgclCompositeCurveSegment3D[] segments,
				boolean periodic) 
    {
	super();

	this.segments = new JgclCompositeCurveSegment3D[segments.length];
	this.periodic = periodic;

	this.localStartParams = new double[segments.length];
	this.globalStartParams = new double[segments.length + 1];

	this.globalStartParams[0] = 0;

	for (int i = 0; i < segments.length; i++) {
	    JgclCompositeCurveSegment3D seg = segments[i];
	    JgclParameterSection sec = seg.parameterDomain().section();
	    this.segments[i] = seg;
	    this.localStartParams[i] = sec.start();
	    this.globalStartParams[i+1] = this.globalStartParams[i] + sec.increase();
	}
    }

    /**
     * ZOg̕Ȑ̔z^ăIuWFNg\zB
     * <p>
     * segments ̗vf sense ̗vfvĂȂꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * ̃RXgN^ł segments[i]  sense[i] 
     * ȐZOg ({@link JgclCompositeCurveSegment3D JgclCompositeCurveSegment3D})
     * \z邪A
     * ̍ۂ̊eZOǵũZOgƂ̘AvɂẮA
     * ꂼ̋Ȑ̊􉽓IȓAIɔfB
     * </p>
     * <p>
     * Ō̃ZOg̏I_ƍŏ̃ZOg̎n_
     * vĂȂΊJ`A
     * vĂΕ`
     * ̕Ȑ\zB
     * </p>
     * <p>
     * ׂ荇ZOg􉽓IɘAłȂꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param segments	Ȑ\ZOg̕Ȑ̔z
     * @param sense	Ȑ\ZOǧtO̔z
     * @see	JgclCompositeCurveSegment3D
     * @see	JgclInvalidArgumentValue
     */
    public JgclCompositeCurve3D(JgclBoundedCurve3D[] segments,
				boolean[] sense)
    {
	super();

	if (segments.length != sense.length)
	    throw new JgclInvalidArgumentValue();

	double dTol = JgclConditionOfOperation.getCondition().getToleranceForDistance();

	this.segments = new JgclCompositeCurveSegment3D[segments.length];

	this.localStartParams = new double[segments.length];
	this.globalStartParams = new double[segments.length + 1];

	this.globalStartParams[0] = 0;

	int transition = JgclTransitionCode.UNKNOWN;

	for (int i = 0; i < segments.length; i++) {
	    int j = (i+1 == segments.length) ? 0 : i+1;
	    JgclBoundedCurve3D pseg = segments[i];
	    JgclBoundedCurve3D nseg = segments[j];
	    JgclParameterSection psec = pseg.parameterDomain().section();
	    JgclParameterSection nsec = nseg.parameterDomain().section();
	    double pp = sense[i] ? psec.end() : psec.start();
	    double np = sense[j] ? nsec.start() : nsec.end();
	    JgclCurveDerivative3D pder = pseg.evaluation(pp);
	    JgclCurveDerivative3D nder = nseg.evaluation(np);
	    double pcur = pseg.curvature(pp).curvature();
	    double ncur = nseg.curvature(np).curvature();

	    if (!pder.d0D().identical(nder.d0D())) {
		// sA
		transition = JgclTransitionCode.DISCONTINUOUS;
	    }
	    else if (!pder.d1D().identicalDirection(nder.d1D())) {
		// ڐsA
		transition = JgclTransitionCode.CONTINUOUS;
	    }
	    else if (Math.abs(pcur - ncur) >= dTol) {
		// ڐA & ȗsA
		// CONT_SAME_GRADIENT
		transition = JgclTransitionCode.CONTINUOUS;
	    }
	    else {
		// ڐA & ȗA
		// CONT_SAME_GRADIENT_SAME_CURVATURE
		transition = JgclTransitionCode.CONTINUOUS;
	    }

	    if ((j != 0) && (transition == JgclTransitionCode.DISCONTINUOUS))
		throw new JgclInvalidArgumentValue();

	    this.segments[i] = 
		new JgclCompositeCurveSegment3D(transition, sense[i], pseg);

	    this.localStartParams[i] = psec.start();
	    this.globalStartParams[i+1] = this.globalStartParams[i] + psec.increase();
	}

	this.periodic = (transition == JgclTransitionCode.DISCONTINUOUS) ? false : true;
    }

    /**
     * ̕Ȑ\ZOgԂB
     * 
     * @return	ZOg̔z
     */
    JgclCompositeCurveSegment3D[] segments() {
	return (JgclCompositeCurveSegment3D[]) this.segments.clone();
    }

    /**
     * ̕Ȑ (ċAI) ZOgɕB
     * 
     * @return	ZOg̔z
     */
    JgclCompositeCurveSegment3D[] decomposeAsSegmentsRecursively() {
	Vector resultList = new Vector();

	for (int i = 0; i < nSegments(); i++) {
	    JgclCompositeCurveSegment3D segment = this.segmentAt(i);
	    JgclBoundedCurve3D parent = segment.parentCurve();
	    if (parent.type() == COMPOSITE_CURVE_3D) {
		JgclCompositeCurve3D parentCmc = (JgclCompositeCurve3D)parent;
		JgclCompositeCurveSegment3D[] parentSegments =
		    parentCmc.decomposeAsSegmentsRecursively();
		JgclCompositeCurveSegment3D revised;
		if (segment.sameSense() == true) {
		    int j;
		    for (j = 0; j < (parentSegments.length - 1); j++)
			resultList.addElement(parentSegments[j]);
		    revised = parentSegments[j].
			makeCopyWithTransition(segment.transition());
		    resultList.addElement(revised);
		} else {
		    int j;
		    for (j = (parentSegments.length - 1); j > 0; j--) {
			revised = parentSegments[j].
			    makeReverseWithTransition(parentSegments[j-1].transition());
			resultList.addElement(revised);
		    }
		    revised = parentSegments[j].
			makeReverseWithTransition(segment.transition());
		    resultList.addElement(revised);
		}
	    } else {
		resultList.addElement(segment);
	    }
	}

	JgclCompositeCurveSegment3D[] result =
	    new JgclCompositeCurveSegment3D[resultList.size()];
	resultList.copyInto(result);
	return result;
    }

    /**
     * ̕Ȑ`ۂԂB
     * 
     * @return	`ł trueAȂ false
     */
    public boolean periodic() {
	return this.periodic;
    }

    /**
     * ̕Ȑ\ZOg̐ԂB
     * 
     * @return	ZOg̐
     */
    public int nSegments() {
	return this.segments.length;
    }

    /**
     * ̕Ȑ ith Ԗڂ̃ZOgԂB
     * 
     * @param ith	ZOg̃CfbNX
     * @return		ith Ԗڂ̃ZOg
     */
    public JgclCompositeCurveSegment3D segmentAt(int ith) {
	return this.segments[ith];
    }

    /**
     * ZOg̃CfbNXƂ̃ZOgł̋Ǐp[^l\NXB
     */
    class CompositeIndexParam {
	/**
	 * ZOg̃CfbNXB
	 */
	int index;

	/**
	 * Ǐp[^lB
	 * <p>
	 * ̒l [0, ZOg̃p[^Ԃ̑l] Ɏ܂B
	 * </p>
	 */
	double param;
    }

    /**
     * ̕Ȑɑ΂ė^ꂽp[^lA
     * ɑΉZOg̃CfbNX
     * ̃ZOgł̋ǏIȃp[^lɕϊB
     * <p>
     * ^ꂽp[^l̋Ȑ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param param	p[^l
     * @return		ZOg̃CfbNXƋǏp[^l
     */
    private CompositeIndexParam getIndexParam(double param)
    {
	JgclParameterDomain domain = parameterDomain();
	CompositeIndexParam ip = new CompositeIndexParam();

	checkValidity(param);
	param = domain.wrap(param);
	ip.index = JgclUtil.bsearchDoubleArray(globalStartParams, 1, (nSegments() - 1), param);
	ip.param = localStartParams[ip.index] + (param - globalStartParams[ip.index]);
	return ip;
    }

    /**
     * ̕Ȑ̂ZOg̃CfbNX
     * ̃ZOgł̋ǏIȃp[^l
     * ̕Ȑɑ΂p[^lɕϊB
     * 
     * @param index	ZOg̃CfbNX
     * @param param	ZOgł̋Ǐp[^l
     * @return		̕Ȑɑ΂p[^l
     */
    private double getCompositeParam(int index, double param) {
	return globalStartParams[index] + (param - localStartParams[index]);
    }

    /**
     * ̕Ȑ̊Jn_ԂB
     * <p>
     * ̕Ȑ`̏ꍇɂ null ԂB
     * </p>
     *
     * @return	Jn_
     */
    public JgclPoint3D startPoint() {
	if (isPeriodic())
	    return null;

	return segments[0].startPoint();
    }

    /**
     * ̕Ȑ̏I_ԂB
     * <p>
     * ̕Ȑ`̏ꍇɂ null ԂB
     * </p>
     *
     * @return	I_
     */
    public JgclPoint3D endPoint() {
	if (isPeriodic())
	    return null;

	int n = nSegments();
	return segments[n-1].endPoint();
    }

    /**
     * {@link #length(JgclParameterSection) length(JgclParameterSection)}
     * 邽߂ SegmentAccumulator ̎B
     */
    private class LengthAccumulator extends SegmentAccumulator {
	/**
	 * Ȑ̎w̋Ԃ̒B
	 */
	double length;

	/**
	 * leng  0 ɏB
	 *
	 * @param nsegs	ΏۂƂȂZOg̐
	 */
	void allocate(int nsegs) {
	    length = 0.0;
	}

	/**
	 * ^ꂽZOg̎w̋Ԃ̓̂ leng ɑB
	 *
	 * @param seg	ZOg
	 * @param sec	p[^
	 * @param compIndex	ZOg̔ԍ
	 */
	void doit(JgclCompositeCurveSegment3D seg,
		  JgclParameterSection sec,
		  int compIndex) {
	    length += seg.length(sec);
	}

	/**
	 * Ȑ̎w̋Ԃ̒ԂB
	 *
	 * @param leng ̒l
	 */
	double extract()
	{
	    return length;
	}
    }

    /**
     * ^ꂽp[^Ԃɂ邱̋Ȑ̎ԏł̒ (̂) ԂB
     * <p>
     * pint ̑l͕ł܂ȂB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param pint	Ȑ̒߂p[^
     * @return	w肳ꂽp[^ԂɂȐ̒
     * @see	JgclParameterOutOfRange
     */
    public double length(JgclParameterSection pint)
    {
        LengthAccumulator acc = new LengthAccumulator();
	acc.accumulate(pint);

        return acc.extract();
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		Wl
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterOutOfRange
     */
    public JgclPoint3D coordinates(double param)
    {
	CompositeIndexParam ip = getIndexParam(param);
	return segments[ip.index].coordinates(ip.param);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		ڃxNg
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterOutOfRange
     */
    public JgclVector3D tangentVector(double param)
    {
	CompositeIndexParam ip = getIndexParam(param);
	return segments[ip.index].tangentVector(ip.param);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return	ȗ
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterOutOfRange
     */
    public JgclCurveCurvature3D curvature(double param)
    {
	CompositeIndexParam ip = getIndexParam(param);
	return segments[ip.index].curvature(ip.param);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̃CԂB
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return	C
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterOutOfRange
     */
    public double torsion(double param)
    {
	CompositeIndexParam ip = getIndexParam(param);
	return segments[ip.index].torsion(ip.param);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		֐
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterOutOfRange
     */
    public JgclCurveDerivative3D evaluation(double param)
    {
	CompositeIndexParam ip = getIndexParam(param);
	return segments[ip.index].evaluation(ip.param);
    }

    /**
     * {@link #singular() singular()}
     * 邽߂ SegmentAccumulator ̎B
     */
    private class SingularAccumulator extends SegmentAccumulator {
	JgclCompositeCurve3D curve;
	Vector singularVec;
	JgclIndefiniteSolution inf;

	SingularAccumulator(JgclCompositeCurve3D curve) {
	    this.curve = curve;
	    inf = null;
	}

	void allocate(int nsegs) {
	    singularVec = new Vector();
	}

	void doit(JgclCompositeCurveSegment3D seg,
		  JgclParameterSection sec,
		  int compIndex) {
	    JgclPointOnCurve3D[] singular;

	    try {
		singular = seg.singular();
	    }
	    catch (JgclIndefiniteSolution e) {
		inf = e;
		return;
	    }

	    double param;
	    for (int i = 0; i < singular.length; i++) {
		param = getCompositeParam(compIndex, singular[i].parameter());
		singularVec.addElement
		    (new JgclPointOnCurve3D(curve, param, doCheckDebug));
	    }

	    if (seg.transition() == JgclTransitionCode.CONTINUOUS) {
		param = getCompositeParam(compIndex, sec.end());
		singularVec.addElement
		    (new JgclPointOnCurve3D(curve, param, doCheckDebug));
	    }
	}

	JgclPointOnCurve3D[] extract() throws JgclIndefiniteSolution
	{
	    if (inf != null)
		throw inf;

	    JgclPointOnCurve3D[] thisSingular =
	    new JgclPointOnCurve3D[singularVec.size()];
	    singularVec.copyInto(thisSingular);

	    return thisSingular;
	}
    }

    /**
     * ̋Ȑ̓ٓ_ԂB
     * <p>
     * ٓ_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @return		ٓ_̔z
     * @exception JgclIndefiniteSolution	sł
     */
    public JgclPointOnCurve3D[] singular() throws JgclIndefiniteSolution {
	SingularAccumulator acc = new SingularAccumulator(this);

	try {
	    acc.accumulate(parameterDomain().section());
	}
	catch(JgclParameterOutOfRange e) {
	    throw new JgclFatal();
	}
	return acc.extract();
    }

    /**
     * {@link #inflexion() inflexion()}
     * 邽߂ SegmentAccumulator ̎B
     */
    private class InflexionAccumulator extends SegmentAccumulator {
	JgclCompositeCurve3D curve;
	Vector inflexionVec;
	JgclIndefiniteSolution inf;

	InflexionAccumulator(JgclCompositeCurve3D curve) {
	    this.curve = curve;
	    inf = null;
	}

	void allocate(int nsegs) {
	    inflexionVec = new Vector();
	}

	void doit(JgclCompositeCurveSegment3D seg,
              JgclParameterSection sec,
              int compIndex) {
	    JgclPointOnCurve3D[] inflexion;

	    try {
		inflexion = seg.inflexion();
	    }
	    catch (JgclIndefiniteSolution e) {
		inf = e;
		return;
	    }

	    double param;
	    for (int i = 0; i < inflexion.length; i++) {
		param = getCompositeParam
		    (compIndex, inflexion[i].parameter());
		inflexionVec.addElement
		    (new JgclPointOnCurve3D(curve, param, doCheckDebug));
	    }
	    if (seg.transition() == JgclTransitionCode.CONT_SAME_GRADIENT) {
		param = getCompositeParam(compIndex, sec.end());
		inflexionVec.addElement
		    (new JgclPointOnCurve3D(curve, param, doCheckDebug));
	    }
	}

	JgclPointOnCurve3D[] extract() throws JgclIndefiniteSolution
	{
	    if (inf != null)
		throw inf;

	    JgclPointOnCurve3D[] thisInflexion =
		new JgclPointOnCurve3D[inflexionVec.size()];
	    inflexionVec.copyInto(thisInflexion);

	    return thisInflexion;
	}
    }

    /**
     * ̋Ȑ̕ϋȓ_ԂB
     * <p>
     * ϋȓ_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @return	ϋȓ_̔z
     * @exception JgclIndefiniteSolution	sł
     */
    public JgclPointOnCurve3D[] inflexion() throws JgclIndefiniteSolution {
	InflexionAccumulator acc = new InflexionAccumulator(this);

	try {
	    acc.accumulate(parameterDomain().section());
	}
	catch(JgclParameterOutOfRange e) {
	    throw new JgclFatal();
	}
	return acc.extract();
    }

    /**
     * ΏۂƂȂp[^ԂɊ܂܂ZOgɔCӂ̏{߂̒ۃNXB
     */
    private abstract class SegmentAccumulator {
	/**
	 * ^ꂽZOg̎w͈̔͂ɂāA炩̏sȂۃ\bhB
	 * <p>
	 * ̃\bh
	 * {@link #accumulate(JgclParameterSection) accumulate(JgclParameterSection)}
	 * ̒ŌĂяoB
	 * </p>
	 *
	 * @param seg	ZOg
	 * @param sec	p[^
	 * @param compIndex	ZOg̔ԍ
	 */
	abstract void doit(JgclCompositeCurveSegment3D seg,
			   JgclParameterSection sec,
			   int compIndex);

	/**
	 * ^ꂽZOg̎w͈̔͂ɂāA炩̏sȂۃ\bhB
	 * <p>
	 * ̃\bh
	 * {@link #accumulate(JgclParameterSection) accumulate(JgclParameterSection)}
	 * ̒ŌĂяoB
	 * </p>
	 *
	 * @param seg	ZOg
	 * @param sp	p[^Ԃ̊Jnl
	 * @param ep	p[^Ԃ̏Il
	 * @param compIndex	ZOg̔ԍ
	 */
	void doit(JgclCompositeCurveSegment3D seg, double sp, double ep,
		  int compIndex) {
	    doit(seg, new JgclParameterSection(sp, ep), compIndex);
	}

	/**
	 * 炩̏n߂邽߂̏sȂۃ\bhB
	 * <p>
	 * ̃\bh
	 * {@link #accumulate(JgclParameterSection) accumulate(JgclParameterSection)}
	 * ̒
	 * {@link #doit(JgclCompositeCurveSegment3D, double, double, int)
	 * doit(JgclCompositeCurveSegment3D, double, double, int)}
	 * ĂяoOɌĂяoB
	 * </p>
	 */
	abstract void allocate(int nsegs);

	/**
	 * ^ꂽp[^ԂɊ܂܂ZOg 
	 * {@link #doit(JgclCompositeCurveSegment3D, double, double, int)
	 * doit(JgclCompositeCurveSegment3D, double, double, int)}
	 * ĂяoB
	 */
	void accumulate(JgclParameterSection pint)
	{
	    CompositeIndexParam sx;
	    CompositeIndexParam ex;
	    JgclParameterDomain domain = parameterDomain();
	    boolean wraparound;

	    if (domain.isPeriodic()) {
		double sp = domain.wrap(pint.start());
		double ep = sp + pint.increase();
		sx = getIndexParam(sp);
		ex = getIndexParam(ep);
		wraparound = (domain.section().increase() < ep);
	    }
	    else {
		sx = getIndexParam(pint.lower());
		ex = getIndexParam(pint.upper());
		wraparound = false;
	    }

	    int nsegs;
	    if (wraparound) {
		// tail: segments.length - sx.index
		// head: ex.index + 1
		nsegs = segments.length + ex.index - sx.index + 1;
	    }
	    else {
		nsegs = ex.index - sx.index + 1;
	    }
	    allocate(nsegs);

	    JgclCompositeCurveSegment3D seg;

	    if (nsegs == 1)
		doit(segments[sx.index], sx.param, ex.param, sx.index);
	    else if (wraparound) {
		seg = segments[sx.index];
		doit(seg, sx.param, seg.eParameter(), sx.index);

		int i;
		for (i = sx.index+1; i < segments.length; i++) {
		    seg = segments[i];
		    doit(seg, seg.sParameter(), seg.eParameter(), i);
		}

		for (i = 0; i < ex.index; i++) {
		    seg = segments[i];
		    doit(seg, seg.sParameter(), seg.eParameter(), i);
		}
		seg = segments[ex.index];
		doit(seg, seg.sParameter(), ex.param, ex.index);
	    }
	    else {
		seg = segments[sx.index];
		doit(seg, sx.param, seg.eParameter(), sx.index);

		int i;
		for (i = sx.index+1; i < ex.index; i++) {
		    seg = segments[i];
		    doit(seg, seg.sParameter(), seg.eParameter(), i);
		}
		seg = segments[ex.index];
		doit(seg, seg.sParameter(), ex.param, ex.index);
	    }
	}
    }

    /**
     * {@link #projectFrom(JgclPoint3D) projectFrom(JgclPoint3D)}
     * 邽߂ SegmentAccumulator ̎B
     */
    private class ProjectionAccumulator extends SegmentAccumulator {
	JgclPoint3D point;
	JgclCompositeCurve3D curve;
	JgclPointOnGeometryList projList;
	JgclIndefiniteSolution inf;

	ProjectionAccumulator(JgclPoint3D point,
			      JgclCompositeCurve3D curve) {
	    this.curve = curve;
	    this.point = point;
	    inf = null;
	}

	void allocate(int nsegs) {
	    projList = new JgclPointOnGeometryList();
	}

	void doit(JgclCompositeCurveSegment3D seg,
		  JgclParameterSection sec,
		  int compIndex) {
	    JgclPointOnCurve3D[] proj;
	    try {
		proj = seg.projectFrom(point);
	    }
	    catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	    catch (JgclIndefiniteSolution e) {
		inf = e;
		return;
	    }

	    for (int i = 0; i < proj.length; i++) {
 		double param = getCompositeParam(compIndex, proj[i].parameter());
		projList.addPoint(curve, param);
	    }
	}

	JgclPointOnCurve3D[] extract()
	    throws JgclIndefiniteSolution
	{
	    if (inf != null)
		throw inf;

	    return projList.toJgclPointOnCurve3DArray();
	}
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * e_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param point	e̓_
     * @return	e_
     */
    public JgclPointOnCurve3D[] projectFrom(JgclPoint3D point)
	throws JgclIndefiniteSolution
    {
	ProjectionAccumulator acc = new ProjectionAccumulator(point, this);

	try {
	    acc.accumulate(parameterDomain().section());
	}
	catch(JgclParameterOutOfRange e) {
	    throw new JgclFatal();
	}
	return acc.extract();
    }

    /**
     * {@link #toPolyline(JgclParameterSection, JgclToleranceForDistance)
     * toPolyline(JgclParameterSection, JgclToleranceForDistance)}
     * 邽߂ SegmentAccumulator ̎B
     */
    private class ToPolylineAccumulator extends SegmentAccumulator {
	JgclToleranceForDistance tol;
	JgclPolyline3D[] pls;
	JgclCompositeCurveSegment3D[] segs;
	int[] compIndex;
	JgclCompositeCurve3D curve;
	int segIndex;

	ToPolylineAccumulator(JgclToleranceForDistance tol,
			      JgclCompositeCurve3D curve) {
	    this.tol = tol;
	    this.curve = curve;
	    segIndex = 0;
	}

	void allocate(int nsegs) {
	    pls = new JgclPolyline3D[nsegs];
	    segs = new JgclCompositeCurveSegment3D[nsegs];
	    compIndex = new int[nsegs];
	}

	void doit(JgclCompositeCurveSegment3D seg,
		  JgclParameterSection sec,
		  int compIndex) {
	    segs[segIndex] = seg;
	    this.compIndex[segIndex] = compIndex;
	    try {
		pls[segIndex] = seg.toPolyline(sec, tol);
	    }
	    catch (JgclZeroLength e) {
		pls[segIndex] = null;
	    }
	    segIndex++;
	}

	JgclPolyline3D extract() {
	    int npnts = 1;
	    int i, j, k;

	    for (i = 0; i < pls.length; i++) {
		if (pls[i] == null)
		    continue;
		npnts += (pls[i].nPoints() - 1);
	    }

	    if (npnts < 2)
		throw new JgclZeroLength();

	    JgclPointOnCurve3D[] points = new JgclPointOnCurve3D[npnts];

	    k = 0;

	    double param;
	    for (i = 0; i < pls.length; i++) {
		if (pls[i] == null)
		    continue;
		for (j = 0; j < pls[i].nPoints(); j++) {
		    JgclPointOnCurve3D pnts =
			(JgclPointOnCurve3D)pls[i].pointAt(j);
		    param = getCompositeParam(compIndex[i], pnts.parameter());
		    if (i == 0 || j != 0) {
			try {
			    points[k++] = new JgclPointOnCurve3D(curve, param, doCheckDebug);
			}
			catch(JgclInvalidArgumentValue e) {
			    throw new JgclFatal();
			}
		    }
		}
	    }

	    return new JgclPolyline3D(points);
	}
    }

    /**
     * ̋Ȑ̎w̋ԂA^ꂽ덷Œߎ|CԂB
     * <p>
     * ʂƂĕԂ|C\_́A
     * ̋Ȑx[XƂ JgclPointOnCurve3D 
     * 邱Ƃ҂łB
     * </p>
     * 
     * @param pint	ߎp[^
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ𒼐ߎ|C
     */
    public JgclPolyline3D toPolyline(JgclParameterSection pint,
				     JgclToleranceForDistance tol)
    {
	if (pint.increase() < 0.0) {
	    return toPolyline(new JgclParameterSection(pint.end(),
						       -pint.increase()),
			      tol).reverse();
	}

	ToPolylineAccumulator accm = new ToPolylineAccumulator(tol, this);
	accm.accumulate(pint);

	return accm.extract();
    }

    /**
     * {@link #toBsplineCurve(JgclParameterSection)
     * toBsplineCurve(JgclParameterSection)}
     * 邽߂ SegmentAccumulator ̎B
     */
    private class ToBsplineCurveAccumulator extends SegmentAccumulator {
	JgclBsplineCurve3D result;

	ToBsplineCurveAccumulator() {
	}

	void allocate(int nsegs) {
	    result = null;
	}

	void doit(JgclCompositeCurveSegment3D seg,
		  JgclParameterSection sec,
		  int compIndex) {
	    try {
		JgclBsplineCurve3D bsc = seg.toBsplineCurve(sec);
		result = (result == null) ? bsc : result.mergeIfContinuous(bsc);
	    } catch (JgclTwoGeomertiesAreNotContinuous e) {
		// ł̂H
		throw new JgclFatal();
	    }
	}

	JgclBsplineCurve3D extract() {
	    return result;
	}
    }

    /**
     * ̋Ȑ̎w̋ԂɍČL Bspline ȐԂB
     * 
     * @param pint	L Bspline ȐōČp[^
     * @return		̋Ȑ̎w̋ԂČL Bspline Ȑ
     */
    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection pint) {
	ToBsplineCurveAccumulator accm = new ToBsplineCurveAccumulator();
	accm.accumulate(pint.positiveIncrease());
	JgclBsplineCurve3D result = accm.extract();

	// KOKO : Ăꍇ̏

	if (pint.increase() < 0.0)
	    result = result.reverse();

	return result;
    }

    /**
     * {@link #doIntersect(JgclParametricCurve3D, boolean)
     * doIntersect(JgclParametricCurve3D, boolean)}
     * 邽߂ SegmentAccumulator 
     */
    private class IntersectionAccumulator extends SegmentAccumulator {
	JgclParametricCurve3D mate;
	JgclCompositeCurve3D curve;
	Vector intsvec;

	IntersectionAccumulator(JgclParametricCurve3D mate,
				JgclCompositeCurve3D curve) {
	    this.curve = curve;
	    this.mate = mate;
	}

	void allocate(int nsegs) {
	    intsvec = new Vector();
	}

	void doit(JgclCompositeCurveSegment3D seg,
		  JgclParameterSection sec,
		  int compIndex) {

	    JgclIntersectionPoint3D[] ints = seg.intersect(mate);

	    for (int i = 0; i < ints.length; i++) {
		JgclPointOnCurve3D pnt1 =
		    (JgclPointOnCurve3D)ints[i].pointOnGeometry1();
		double cparam = pnt1.parameter();
 		double sparam = getCompositeParam(compIndex, cparam);

		JgclPointOnCurve3D thisPnts =
		    new JgclPointOnCurve3D(curve, sparam, doCheckDebug);
		JgclIntersectionPoint3D thisInts =
		    new JgclIntersectionPoint3D(thisPnts,
						ints[i].pointOnGeometry2(), doCheckDebug);
		intsvec.addElement(thisInts);
	    }
	}

	JgclIntersectionPoint3D[] extract(boolean doExchange) {
	    JgclIntersectionPoint3D[] ints =
		new JgclIntersectionPoint3D[intsvec.size()];
	    intsvec.copyInto(ints);
	    if (doExchange)
		for (int i = 0; i < ints.length; i++)
		    ints[i] = ints[i].exchange();
	    return ints;
	}
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * ̋Ȑ̊eZOgƑ̋Ȑ̌_߂ɁA
     * ̃ZOgɑ΂p[^l
     * ̋Ȑɑ΂p[^lɕϊ
     * u_vƂĂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     */
    private JgclIntersectionPoint3D[] doIntersect(JgclParametricCurve3D mate,
						  boolean doExchange) {
	IntersectionAccumulator acc = new IntersectionAccumulator(mate, this);
	acc.accumulate(parameterDomain().section());
	return acc.extract(doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return	_̔z
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) {
	return doIntersect(mate, false);
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve3D, boolean)
     */
    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (~)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve3D, boolean)
     */
    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȉ~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȉ~)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve3D, boolean)
     */
    JgclIntersectionPoint3D[] intersect(JgclEllipse3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve3D, boolean)
     */
    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (oȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (oȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve3D, boolean)
     */
    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (|C) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve3D, boolean)
     */
    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve3D, boolean)
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve3D, boolean)
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (gȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (gȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve3D, boolean)
     */
    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȐZOg) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȐZOg)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve3D, boolean)
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (Ȑ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve3D, boolean)
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * intersect(Ȗ) ̂߂ SegmentAccumulator 
     */
    private class IntersectionWithSurfaceAccumulator extends SegmentAccumulator {
	JgclParametricSurface3D mate;
	JgclCompositeCurve3D curve;
	JgclCurveSurfaceInterferenceList intfList;

	IntersectionWithSurfaceAccumulator(JgclParametricSurface3D mate,
					   JgclCompositeCurve3D curve) {
	    this.curve = curve;
	    this.mate = mate;
	}

	void allocate(int nsegs) {
	    intfList = new JgclCurveSurfaceInterferenceList(curve, mate);
	}

	void doit(JgclCompositeCurveSegment3D seg,
		  JgclParameterSection sec,
		  int compIndex) {
	    JgclIntersectionPoint3D[] intp = seg.intersect(mate);

	    for (int i = 0; i < intp.length; i++) {
		JgclPointOnCurve3D crvPnt =
		    (JgclPointOnCurve3D)intp[i].pointOnGeometry1();
		double param = crvPnt.parameter();
 		double compositeParam = getCompositeParam(compIndex, param);
		JgclPointOnSurface3D srfPnt =
		    (JgclPointOnSurface3D)intp[i].pointOnGeometry2();
		intfList.addAsIntersection(intp[i].coordinates(), compositeParam,
					   srfPnt.uParameter(), srfPnt.vParameter());
	    }
	}

	JgclIntersectionPoint3D[] extract(boolean doExchange) {
	    return intfList.toJgclIntersectionPoint3DArray(doExchange);
	}
    }

    /**
     * ̋ȐƑ̋Ȗʂ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     *
     * @param mate	̋Ȗ
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] doIntersect(JgclParametricSurface3D mate,
					  boolean doExchange) {
	IntersectionWithSurfaceAccumulator acc =
	    new IntersectionWithSurfaceAccumulator(mate, this);
	acc.accumulate(parameterDomain().section());
	return acc.extract(doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗʂ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ
     * @return		_̔z
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate) {
	return doIntersect(mate, false);
    }

    /**
     * ̋ȐƑ̋Ȗʂ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate,
					boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗ (͋Ȗ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ (͋Ȗ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D mate,
					boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗ (xWGȖ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ (xWGȖ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierSurface3D mate,
					boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȗ (aXvCȖ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȗ (aXvCȖ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineSurface3D mate,
					boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		Ȑ̊̔z
     */
    public JgclCurveCurveInterference3D[] interfere(JgclBoundedCurve3D mate) {
	return this.getInterference(mate, false);
    }

    /**
     * ̗LȐƑ̗LȐ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * ̋Ȑ̊eZOgƑ̋Ȑ̊߂ɁA
     * ̃ZOgɑ΂p[^l
     * ̋Ȑɑ΂p[^lɕϊ
     * uvƂĂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    private JgclCurveCurveInterference3D[] getInterference(JgclBoundedCurve3D mate,
							   boolean doExchange) {
	JgclCurveCurveInterferenceList interferenceList
	    = new JgclCurveCurveInterferenceList(this, mate);

	// this ̊eZOgɑ΂
	for (int i = 0; i < nSegments(); i++) {
	    // ZOgxł̊𓾂
	    JgclCurveCurveInterference3D[] localInterferences
		= this.segmentAt(i).interfere(mate, false);

	    // _Xgɒǉ
	    Vector intsList
		= JgclCurveCurveInterferenceList.extractIntersections
		(localInterferences);
	    for (Enumeration e = intsList.elements(); e.hasMoreElements();)
	    {
		JgclIntersectionPoint3D ints
		    = (JgclIntersectionPoint3D)e.nextElement();
		interferenceList.addAsIntersection
		    (ints.coordinates(),
		     ints.pointOnCurve1().parameter(),
		     this.getCompositeParam(i, ints.pointOnCurve2().parameter()));
	    }

	    // dXgɒǉ
	    Vector ovlpList
		= JgclCurveCurveInterferenceList.extractOverlaps
		(localInterferences);
	    for (Enumeration e = ovlpList.elements(); e.hasMoreElements();)
	    {
		JgclOverlapCurve3D ovlp
		    = (JgclOverlapCurve3D)e.nextElement();
		interferenceList.addAsOverlap
		    (ovlp.start1(),
		     this.getCompositeParam(i, ovlp.start2()),
		     ovlp.increase1(),
		     ovlp.increase2());
	    }
	}

	interferenceList.removeOverlapsContainedInOtherOverlap();
	interferenceList.removeIntersectionsContainedInOverlap();

	return interferenceList.toJgclCurveCurveInterference3DArray(doExchange);;
    }

    /**
     * ̗LȐƑ̗LȐ () ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ ()
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#getInterference(JgclBoundedCurve3D, boolean)
     */
    JgclCurveCurveInterference3D[] interfere(JgclBoundedLine3D mate,
					     boolean doExchange) {
	return this.getInterference(mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (|C) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (|C)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#getInterference(JgclBoundedCurve3D, boolean)
     */
    JgclCurveCurveInterference3D[] interfere(JgclPolyline3D mate,
					     boolean doExchange) {
	return this.getInterference(mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (xWGȐ) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (xWGȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#getInterference(JgclBoundedCurve3D, boolean)
     */
    JgclCurveCurveInterference3D[] interfere(JgclPureBezierCurve3D mate,
					     boolean doExchange) {
	return this.getInterference(mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (aXvCȐ) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (aXvCȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#getInterference(JgclBoundedCurve3D, boolean)
     */
    JgclCurveCurveInterference3D[] interfere(JgclBsplineCurve3D mate,
					     boolean doExchange) {
	return this.getInterference(mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (gȐ) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (gȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#getInterference(JgclBoundedCurve3D, boolean)
     */
    JgclCurveCurveInterference3D[] interfere(JgclTrimmedCurve3D mate,
					     boolean doExchange) {
	return this.getInterference(mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (ȐZOg) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (ȐZOg)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#getInterference(JgclBoundedCurve3D, boolean)
     */
    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurveSegment3D mate,
					     boolean doExchange) {
	return this.getInterference(mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (Ȑ) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (Ȑ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#getInterference(JgclBoundedCurve3D, boolean)
     */
    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurve3D mate,
					     boolean doExchange) {
	return this.getInterference(mate, doExchange);
    }

    /**
     * ̋ȐA^ꂽxNgɏ]ĕsړȐԂB
     *
     * @param moveVec	sړ̕Ɨʂ\xNg
     * @return		sړ̋Ȑ
     */
    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
	int nSeg = nSegments();
	JgclCompositeCurveSegment3D[] newSegs = new JgclCompositeCurveSegment3D[nSeg];
	for (int i = 0; i < nSeg; i++)
	    newSegs[i] = (JgclCompositeCurveSegment3D)segmentAt(i).parallelTranslate(moveVec);
	return new JgclCompositeCurve3D(newSegs, periodic);
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     *
     * @return	p[^`
     */
    JgclParameterDomain getParameterDomain() {
	try {
	    return new JgclParameterDomain(periodic, 0,
					   globalStartParams[nSegments()]);
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve3D#COMPOSITE_CURVE_3D JgclParametricCurve3D.COMPOSITE_CURVE_3D}
     */
    int type() {
	return COMPOSITE_CURVE_3D;
    }

    /**
     * ̊􉽗vfR`󂩔ۂԂB
     *
     * @return	 true
     */
    public boolean isFreeform() {
	return true;
    }

    /**
     * ̋ȐA^ꂽǏWn Z ̎ɁA
     * ^ꂽpx]ȐԂB
     *
     * @param trns	ǏWn瓾ꂽWϊZq
     * @param rCos	cos(]px)
     * @param rSin	sin(]px)
     * @return		]̋Ȑ
     */
    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns,
				  double rCos, double rSin) {
	int n_segs = nSegments();
	JgclCompositeCurveSegment3D[] segs = new JgclCompositeCurveSegment3D[n_segs];

	for (int i = 0; i < n_segs; i++)
	    segs[i] = (JgclCompositeCurveSegment3D)segmentAt(i).rotateZ(trns, rCos, rSin);

	return new JgclCompositeCurve3D(segs, periodic());
    }

    /**
     * ̋Ȑ̓_ŁA^ꂽɂȂ_ԂB
     *
     * @param line	
     * @return		^ꂽɂȂ_
     */
    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
	JgclParameterSection pint = parameterDomain().section();
	JgclBsplineCurve3D b_spline = toBsplineCurve(pint);
	return b_spline.getPointNotOnLine(line);
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricCurve3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclCompositeCurveSegment3D[] tSegments =
	    new JgclCompositeCurveSegment3D[this.nSegments()];
	for (int i = 0; i < this.nSegments(); i++)
	    tSegments[i] = (JgclCompositeCurveSegment3D)
		this.segmentAt(i).transformBy(reverseTransform,
					      transformationOperator,
					      transformedGeometries);
	return new JgclCompositeCurve3D(tSegments, this.periodic());
    }

    /**
     * ̋Ȑ|C̕܂ނۂԂB
     *
     * @return	̋Ȑ|Cł邩A
     *		܂͎g\镔iƂă|C܂ނȂ trueA
     *		łȂ false
     */
    protected boolean hasPolyline() {
	for (int i = 0; i < this.nSegments(); i++) {
	    if (this.segmentAt(i).hasPolyline() == true)
		return true;
	}
	return false;
    }

    /**
     * ̋Ȑ|C̕łłĂ邩ۂԂB
     *
     * @return	̋Ȑ|Cł邩A
     *		܂͎g\镔iƂă|C܂ނȂ trueA
     *		łȂ false
     */
    protected boolean isComposedOfOnlyPolylines() {
	for (int i = 0; i < this.nSegments(); i++) {
	    if (this.segmentAt(i).isComposedOfOnlyPolylines() == false)
		return false;
	}
	return true;
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tsegments");
	for (int i = 0; i < nSegments(); i++) {
	    segments[i].output(writer, indent + 2);
        }
        writer.println(indent_tab + "\tperiodic\t" + periodic);
        writer.println(indent_tab + "End");
    }
}
