/*
 * R : L () aXvCȖʂїLaXvCȖʂ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclBsplineSurface3D.java,v 1.75 2000/08/11 06:18:44 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;
import java.util.Enumeration;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : L () aXvCȖʂїLaXvCȖʂ\NXB
 * <p>
 * ̃NX̃CX^X́A
 * aXvC U/V ̃mbgɊւ uKnotData/vKnotData
 * ({@link JgclBsplineKnot JgclBsplineKnot})
 * B
 * _ȂǂێtB[hɂẮA
 * {@link JgclFreeformSurfaceWithControlPoints3D X[p[NX̉} QƁB
 * </p>
 * <p>
 * aXvCȖʂ U/V ꂼ̃̕p[^`́A
 * ΉmbgɂČ܂B
 * </p>
 * <p>
 * (u, v) p[^ƂaXvCȖ P(u, v) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	m = U ̎
 *	n = V ̎
 *	p = U ̐_̐
 *	q = V ̐_̐
 *	K = U ̃ZOg̐ (U J` : (p - m), U ` : p)
 *	L = V ̃ZOg̐ (V J` : (q - n), V ` : q)
 *	di,j = controlPoints[i][j]
 *	wi,j = weights[i][j]
 * </pre>
 * ƂāALaXvCȖʂ
 * <pre>
 *	P(u, v) = ((di,j * Nm,i(u)) ̑a) * Nn,j(v) ̑a	(i = 0, ..., K+m-1, j = 0, ..., L+n-1)
 * </pre>
 * LaXvCȖʂ
 * <pre>
 *		  ((wi,j * di,j * Nm,i(u)) ̑a) * Nn,j(v) ̑a
 *	P(u, v) = ------------------------------------------------- 	(i = 0, ..., K+m-1, j = 0, ..., L+n-1)
 *		  ((wi,j * Nm,i(u)) ̑a) * Nn,j(v) ̑a
 * </pre>
 *  Nm,i(u), Nn,j(v) ͂aXvC֐B
 * ȂA
 * U ɕ`̏ꍇ i &gt; (p - 1) ƂȂ i ɂẮA
 * Ή鐧_Əd݂ꂼ dk, wk (k = i - p) ƂȂB
 * lɁA
 * V ɕ`̏ꍇ j &gt; (q - 1) ƂȂ j ɂẮA
 * Ή鐧_Əd݂ꂼ dl, wl (l = j - q) ƂȂB
 * </p>
 *
 * @version $Revision: 1.75 $, $Date: 2000/08/11 06:18:44 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclBsplineSurface3D extends JgclFreeformSurfaceWithControlPoints3D {
    /**
     * U ̃mbgB
     * @serial
     */
    private final JgclBsplineKnot uKnotData;

    /**
     * V ̃mbgB
     * @serial
     */
    private final JgclBsplineKnot vKnotData;

    /**
     * Ȗʂ̌`tOB
     * <p>
     * ̃tB[h́A܂̂Ƃ늈pĂ炸A
     *  JgclBsplineSurfaceForm.UNSPECIFIED ɂȂĂB
     * </p>
     * @serial
     * @see JgclBsplineSurfaceForm
     */
    private int surfaceForm = JgclBsplineSurfaceForm.UNSPECIFIED;

    /**
     * mbg𖾎A
     * _^đȖʂƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformSurfaceWithControlPoints3D#JgclFreeformSurfaceWithControlPoints3D(JgclPoint3D[][])
     * super}(controlPoints)
     * ĂяoĂB
     * </p>
     * <p>
     * uKnotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(uDegree, JgclKnotType.UNSPECIFIED, uPeriodic, uKnotMultiplicities, uKnots, controlPoints.length)
     * ĂяoĂB
     * </p>
     * <p>
     * vKnotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(vDegree, JgclKnotType.UNSPECIFIED, vPeriodic, vKnotMultiplicities, vKnots, controlPoints[0].length)
     * ĂяoĂB
     * </p>
     *
     * @param uDegree			U ̎
     * @param uPeriodic			U `ۂ\tO
     * @param uKnotMultiplicities	U ̃mbgdx̔z
     * @param uKnots			U ̃mbgl̔z
     * @param vDegree			V ̎
     * @param vPeriodic			V `ۂ\tO
     * @param vKnotMultiplicities	V ̃mbgdx̔z
     * @param vKnots			V ̃mbgl̔z
     * @param controlPoints		_̔z
     */
    public JgclBsplineSurface3D(int uDegree, boolean uPeriodic,
				int[] uKnotMultiplicities, double[] uKnots,
				int vDegree, boolean vPeriodic,
				int[] vKnotMultiplicities, double[] vKnots,
				JgclPoint3D[][] controlPoints) {
	super(controlPoints);
	uKnotData = new JgclBsplineKnot(uDegree, JgclKnotType.UNSPECIFIED, uPeriodic,
					uKnotMultiplicities, uKnots,
					controlPoints.length);
	vKnotData = new JgclBsplineKnot(vDegree, JgclKnotType.UNSPECIFIED, vPeriodic,
					vKnotMultiplicities, vKnots,
					controlPoints[0].length);
    }

    /**
     * mbg𖾎
     * mbg̎ʂƐ_^đȖʂƂăIuWFNg\zB
     * <p>
     * ܂̂ƂAuKnotSpec/vKnotSpec Ƃ蓾l JgclKnotType.UNIFORM_KNOTS ł
     * (JgclKnotType.{QUASI_UNIFORM_KNOTS, PIECEWISE_BEZIER_KNOTS} ɂ͖Ή) B
     * </p>
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformSurfaceWithControlPoints3D#JgclFreeformSurfaceWithControlPoints3D(JgclPoint3D[][])
     * super}(controlPoints)
     * ĂяoĂB
     * </p>
     * <p>
     * uKnotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(uDegree, uKnotSpec, uPeriodic, null, null, controlPoints.length)
     * ĂяoĂB
     * </p>
     * <p>
     * vKnotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(vDegree, vKnotSpec, vPeriodic, null, null, controlPoints[0].length)
     * ĂяoĂB
     * </p>
     *
     * @param uDegree			U ̎
     * @param uPeriodic			U `ۂ\tO
     * @param uKnotSpec			U ̃mbg̎
     * @param vDegree			V ̎
     * @param vPeriodic			V `ۂ\tO
     * @param vKnotSpec			V ̃mbg̎
     * @param controlPoints		_̔z
     */
    public JgclBsplineSurface3D(int uDegree, boolean uPeriodic, int uKnotSpec,
				int vDegree, boolean vPeriodic, int vKnotSpec,
				JgclPoint3D[][] controlPoints) {
	super(controlPoints);
	uKnotData = new JgclBsplineKnot(uDegree, uKnotSpec, uPeriodic, null, null,
					controlPoints.length);
	vKnotData = new JgclBsplineKnot(vDegree, vKnotSpec, vPeriodic, null, null,
					controlPoints[0].length);
    }

    /**
     * mbg𖾎A
     * _Ədݗ^ėLȖʂƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformSurfaceWithControlPoints3D#JgclFreeformSurfaceWithControlPoints3D(JgclPoint3D[][], double[][])
     * super}(controlPoints, weights)
     * ĂяoĂB
     * </p>
     * <p>
     * uKnotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(uDegree, JgclKnotType.UNSPECIFIED, uPeriodic, uKnotMultiplicities, uKnots, controlPoints.length)
     * ĂяoĂB
     * </p>
     * <p>
     * vKnotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(vDegree, JgclKnotType.UNSPECIFIED, vPeriodic, vKnotMultiplicities, vKnots, controlPoints[0].length)
     * ĂяoĂB
     * </p>
     *
     * @param uDegree			U ̎
     * @param uPeriodic			U `ۂ\tO
     * @param uKnotMultiplicities	U ̃mbgdx̔z
     * @param uKnots			U ̃mbgl̔z
     * @param vDegree			V ̎
     * @param vPeriodic			V `ۂ\tO
     * @param vKnotMultiplicities	V ̃mbgdx̔z
     * @param vKnots			V ̃mbgl̔z
     * @param controlPoints		_̔z
     * @param weights			d݂̔z
     */
    public JgclBsplineSurface3D(int uDegree, boolean uPeriodic,
				int[] uKnotMultiplicities, double[] uKnots,
				int vDegree, boolean vPeriodic,
				int[] vKnotMultiplicities, double[] vKnots,
				JgclPoint3D[][] controlPoints, double[][] weights) {
	super(controlPoints, weights);
	uKnotData = new JgclBsplineKnot(uDegree, JgclKnotType.UNSPECIFIED, uPeriodic,
					uKnotMultiplicities, uKnots,
					controlPoints.length);
	vKnotData = new JgclBsplineKnot(vDegree, JgclKnotType.UNSPECIFIED, vPeriodic,
					vKnotMultiplicities, vKnots,
					controlPoints[0].length);
    }

    /**
     * mbg𖾎
     * mbg̎ʁA_Ədݗ^ėLȖʂƂăIuWFNg\zB
     * <p>
     * ܂̂ƂAuKnotSpec/vKnotSpec Ƃ蓾l JgclKnotType.UNIFORM_KNOTS ł
     * (JgclKnotType.{QUASI_UNIFORM_KNOTS, PIECEWISE_BEZIER_KNOTS} ɂ͖Ή) B
     * </p>
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformSurfaceWithControlPoints3D#JgclFreeformSurfaceWithControlPoints3D(JgclPoint3D[][], double[][])
     * super}(controlPoints, weights)
     * ĂяoĂB
     * </p>
     * <p>
     * uKnotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(uDegree, uKnotSpec, uPeriodic, null, null, controlPoints.length)
     * ĂяoĂB
     * </p>
     * <p>
     * vKnotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(vDegree, vKnotSpec, vPeriodic, null, null, controlPoints[0].length)
     * ĂяoĂB
     * </p>
     *
     * @param uDegree			U ̎
     * @param uPeriodic			U `ۂ\tO
     * @param uKnotSpec			U ̃mbg̎
     * @param vDegree			V ̎
     * @param vPeriodic			V `ۂ\tO
     * @param vKnotSpec			V ̃mbg̎
     * @param controlPoints		_̔z
     * @param weights			d݂̔z
     */
    public JgclBsplineSurface3D(int uDegree, boolean uPeriodic, int uKnotSpec,
				int vDegree, boolean vPeriodic, int vKnotSpec,
				JgclPoint3D[][] controlPoints, double[][] weights) {
	super(controlPoints, weights);
	uKnotData = new JgclBsplineKnot(uDegree, uKnotSpec, uPeriodic, null, null,
					controlPoints.length);
	vKnotData = new JgclBsplineKnot(vDegree, vKnotSpec, vPeriodic, null, null,
					controlPoints[0].length);
    }

    /**
     * mbg JgclBsplineKnot ̃IuWFNgƂēnA
     * _ (Əd) Ozŗ^
     * Ȗ (邢͗LȖ) ƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformSurfaceWithControlPoints3D#JgclFreeformSurfaceWithControlPoints3D(double[][][])
     * super}(cpArray)
     * ĂяoĂB
     * </p>
     * <p>
     * uKnotData/vKnotData ̎_̐ cpArray ̎_̐vȂꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param uKnotData	U ̃mbg
     * @param vKnotData	V ̃mbg
     * @param cpArray	_ (яd) z
     * @see	JgclInvalidArgumentValue
     */
    JgclBsplineSurface3D(JgclBsplineKnot uKnotData, JgclBsplineKnot vKnotData,
			 double[][][] cpArray) {
	super(cpArray);

	if ((uKnotData.nControlPoints() != uNControlPoints()) ||
	    (vKnotData.nControlPoints() != vNControlPoints()))
	    throw new JgclInvalidArgumentValue();

	/*
	 * ňimplicitAexplicitȃmbgȖʂ
	 * RXgN^[Ȃ߁Â悤ȋȖʂ͍Ȃ悤ɂĂB
	 */
	if (uKnotData.knotSpec() == JgclKnotType.UNSPECIFIED ||
	    vKnotData.knotSpec() == JgclKnotType.UNSPECIFIED) {
	    uKnotData = uKnotData.makeExplicit();
	    vKnotData = vKnotData.makeExplicit();
	}

	this.uKnotData = uKnotData;
	this.vKnotData = vKnotData;
    }

    /**
     * mbg JgclBsplineKnot ̃IuWFNgƂēnA
     * _Ədݗ^
     * Ȗ (邢͗LȖ) ƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformSurfaceWithControlPoints3D#JgclFreeformSurfaceWithControlPoints3D(JgclPoint3D[][], double[][], boolean)
     * super}(controlPoints, weights, false)
     * ĂяoĂB
     * </p>
     * <p>
     * ̃RXgN^ł͈̃`FbNsȂȂ̂ŁApɂ͒ӂKvłB
     * </p>
     *
     * @param uKnotData	U ̃mbg
     * @param vKnotData	V ̃mbg
     * @param controlPoitns	_̔z
     * @param weights	d݂̔z
     */
    JgclBsplineSurface3D(JgclBsplineKnot uKnotData, JgclBsplineKnot vKnotData,
			 JgclPoint3D[][] controlPoints, double[][] weights) {
	super(controlPoints, weights, false);

	/*
	 * ňimplicitAexplicitȃmbgȖʂ
	 * RXgN^[Ȃ߁Â悤ȋȖʂ͍Ȃ悤ɂĂB
	 */
	if (uKnotData.knotSpec() == JgclKnotType.UNSPECIFIED ||
	    vKnotData.knotSpec() == JgclKnotType.UNSPECIFIED) {
	    uKnotData = uKnotData.makeExplicit();
	    vKnotData = vKnotData.makeExplicit();
	}

	this.uKnotData = uKnotData;
	this.vKnotData = vKnotData;
    }

    /**
     * ʑIɊiq̓_ԂƁAU/V ꂼ̓̕_ɑΉp[^l̗^āA
     * ̓_ԂԂ鑽ȖʂƂăIuWFNg\zB
     * <p>
     * uIsClosed  true ̏ꍇA
     * (uParams ̗vf) = (points  U ̗vf + 1) ƂȂĂKvB
     * lɁA
     * vIsClosed  true ̏ꍇA
     * (vParams ̗vf) = (points  V ̗vf + 1) ƂȂĂKvB
     * </p>
     *
     * @param points	Ԃ_
     * @param uParams	_ԓ U ̓_̊e_ɂp[^l̗
     * @param vParams	_ԓ V ̓_̊e_ɂp[^l̗
     * @param uIsClosed	U `ۂ
     * @param vIsClosed	V `ۂ
     */
    public JgclBsplineSurface3D(JgclPoint3D[][] points,
				double[] uParams, double[] vParams,
				boolean uIsClosed, boolean vIsClosed)
    {
	super();
	JgclInterpolationSurface3D doObj = new JgclInterpolationSurface3D(points, uParams, vParams,
									  uIsClosed, vIsClosed);
	this.controlPoints = doObj.controlPoints();
	this.uKnotData = doObj.uKnotData();
	this.vKnotData = doObj.vKnotData();
	this.weights = doObj.weights();	// may be null
    }

    /**
     * ʑIɊiq̓_ԂƁAU/V ꂼ̓̕_ɑΉp[^l̗^āA
     * ̓_Ԃߎ鑽ȖʂƂăIuWFNg\zB
     * <p>
     * uIsClosed  true ̏ꍇA
     * (uParams ̗vf) = (points  U ̗vf + 1) ƂȂĂKvB
     * lɁA
     * vIsClosed  true ̏ꍇA
     * (vParams ̗vf) = (points  V ̗vf + 1) ƂȂĂKvB
     * </p>
     * <p>
     * w肳ꂽxŋߎłȂꍇɂ́A
     * ^ꂽ_ԂԂȖʂ𐶐B
     * </p>
     *
     * @param points	ߎ_
     * @param uParams	_ԓ U ̓_̊e_ɂp[^l̗
     * @param vParams	_ԓ V ̓_̊e_ɂp[^l̗
     * @param uIsClosed	U `ۂ
     * @param vIsClosed	V `ۂ
     * @param tol	ߎ̐x
     */
    public JgclBsplineSurface3D(JgclPoint3D[][] points,
				double[] uParams, double[] vParams,
				boolean uIsClosed, boolean vIsClosed,
				JgclToleranceForDistance tol)
    {
	super();
	JgclApproximationSurface3D doObj = new JgclApproximationSurface3D(points, uParams, vParams,
									  uIsClosed, vIsClosed);
	JgclBsplineSurface3D bss = doObj.getApproximationWithTolerance(tol);
	this.controlPoints = bss.controlPoints;
	this.uKnotData = bss.uKnotData;
	this.vKnotData = bss.vKnotData;
	this.weights = bss.weights;	// may be null
    }

    /**
     * ̋Ȗʂ U ̎ԂB
     * 
     * @return	U ̎
     */
    public int uDegree() {
	return uKnotData.degree();
    }

    /**
     * ̋Ȗʂ U ̃mbg̎ʂԂB
     * 
     * @return	U ̃mbg̎
     * @see	JgclKnotType
     */
    public int uKnotSpec() {
	return uKnotData.knotSpec();
    }

    /**
     * ̋Ȗʂ U ̃mbg̐ԂB
     * <p>
     * Ōumbg̐vƂ
     * uKnotData  knots tB[hɐݒ肳ꂽmbgl̔z̒ł͂ȂA
     * aXvC̃mbg{̃mbg̐łB
     * </p>
     *
     * @return	U ̃mbg̐
     */
    public int uNKnotValues() {
	return uKnotData.nKnotValues();
    }

    /**
     * ̋Ȗʂ U  n Ԃ߂̃mbglԂB
     * <p>
     * Ōun ԖځvƂ
     * uKnotData  knots tB[hɐݒ肳ꂽmbgl̔z̃CfbNXł͂ȂA
     * aXvC̃mbg{̈Ӗł̃CfbNXłB
     * </p>
     *
     * @param n	CfbNX
     * @return	U  n Ԃ߂̃mbgl
     */
    public double uKnotValueAt(int n) {
	return uKnotData.knotValueAt(n);
    }

    /**
     * ̋Ȗʂ U ̃ZOg̐ԂB
     *
     * @return	U ̃ZOg̐
     */
    int uNSegments() {
	return uKnotData.nSegments();
    }

    /**
     * ̋Ȗʂ U ̃p[^IɏkނĂȂLZOg̏ԂB
     *
     * @return	U ̃p[^IɏkނĂȂLZOg̏
     */
    JgclBsplineKnot.ValidSegmentInfo uValidSegments() {
	return uKnotData.validSegments();
    }

    /**
     * ̋Ȗʂ (i, j) Ԗڂ̐_ԂB
     * <p>
     * `̏ꍇ̓CfbNXIɈB
     * </p>
     * 
     * @param i	U ̃CfbNX (i Ԃ)
     * @param j	V ̃CfbNX (j Ԃ)
     * @return	_
     */
    public JgclPoint3D controlPointAt(int i, int j) {
	if (isUPeriodic()) {
	    int ncp = uNControlPoints();
	    while (i < 0) i += ncp;
	    while (i >= ncp) i -= ncp;
	}
	if (isVPeriodic()) {
	    int ncp = vNControlPoints();
	    while (j < 0) j += ncp;
	    while (j >= ncp) j -= ncp;
	}
	return controlPoints[i][j];
    }

    /**
     * ̋Ȗʂ V ̎ԂB
     * 
     * @return	V ̎
     */
    public int vDegree() {
	return vKnotData.degree();
    }

    /**
     * ̋Ȗʂ V ̃mbg̎ʂԂB
     * 
     * @return	V ̃mbg̎
     * @see	JgclKnotType
     */
    public int vKnotSpec() {
	return vKnotData.knotSpec();
    }

    /**
     * ̋Ȗʂ V ̃mbg̐ԂB
     * <p>
     * Ōumbg̐vƂ
     * vKnotData  knots tB[hɐݒ肳ꂽmbgl̔z̒ł͂ȂA
     * aXvC̃mbg{̃mbg̐łB
     * </p>
     *
     * @return	V ̃mbg̐
     */
    public int vNKnotValues() {
	return vKnotData.nKnotValues();
    }

    /**
     * ̋Ȗʂ V  n Ԃ߂̃mbglԂB
     * <p>
     * Ōun ԖځvƂ
     * vKnotData  knots tB[hɐݒ肳ꂽmbgl̔z̃CfbNXł͂ȂA
     * aXvC̃mbg{̈Ӗł̃CfbNXłB
     * </p>
     *
     * @param n	CfbNX
     * @return	V  n Ԃ߂̃mbgl
     */
    public double vKnotValueAt(int n) {
	return vKnotData.knotValueAt(n);
    }

    /**
     * ̋Ȗʂ V ̃ZOg̐ԂB
     *
     * @return	V ̃ZOg̐
     */
    int vNSegments() {
	return vKnotData.nSegments();
    }

    /**
     * ̋Ȗʂ V ̃p[^IɏkނĂȂLZOg̏ԂB
     *
     * @return	V ̃p[^IɏkނĂȂLZOg̏
     */
    JgclBsplineKnot.ValidSegmentInfo vValidSegments() {
	return vKnotData.validSegments();
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̍WlԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param	uParam	U ̃p[^l
     * @param	vParam	V ̃p[^l
     * @return		Wl
     * @see	JgclParameterOutOfRange
     */
    public JgclPoint3D coordinates(double uParam, double vParam)
    {
	double[][][] cntlPnts;
	int uUicp;
	int u_section;
	double[][] bsc;
	double[] d0D;
	boolean isPoly = isPolynomial();
	int i, j;

	uParam = checkUParameter(uParam);
	vParam = checkVParameter(vParam);
	cntlPnts = toDoubleArray(isPoly);
	uUicp = cntlPnts.length;
	bsc = new double[uUicp][];

	/*
	 * evaluate for V-direction
	 */
	if ((u_section = uKnotData.segmentIndex(uParam)) < 0)
	    throw new JgclFatal();
	for (i = j = u_section; i <= (u_section + uDegree()); i++, j++) {
	    if (!isPoly && j == uNControlPoints())
		j = 0;
	    bsc[j] = JgclBsplineCurveEvaluation.coordinates(vKnotData,
							   cntlPnts[j], vParam);
	}

	/*
	 * evaluate for U-direction
	 */
	d0D = JgclBsplineCurveEvaluation.coordinates(uKnotData, bsc, uParam);
	if (!isPoly) {
	    convRational0Deriv(d0D);
	}
	return new JgclCartesianPoint3D(d0D);
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̐ڃxNgԂB
     * <p>
     * ł̐ڃxNgƂ́Ap[^ U/V ̊eXɂĂ̈ꎟΓ֐łB
     * </p>
     * <p>
     * ʂƂĕԂz̗vf 2 łB
     * z̍ŏ̗vfɂ U p[^ɂĂ̐ڃxNgA
     * Ԗڂ̗vfɂ V p[^ɂĂ̐ڃxNg܂ށB
     * </p>
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param	uParam	U ̃p[^l
     * @param	vParam	V ̃p[^l
     * @return		ڃxNg
     * @see	JgclParameterOutOfRange
     */
    public JgclVector3D[] tangentVector(double uParam, double vParam)
    {
	double[][][] cntlPnts;
	int uUicp;
	int u_section;
	double[][] pp, dd, tt;
	double[][] ld1D = new double[2][];
	JgclVector3D[] d1D = new JgclVector3D[2];
	boolean isPoly = isPolynomial();
	int i, j;

	uParam = checkUParameter(uParam);
	vParam = checkVParameter(vParam);
	cntlPnts = toDoubleArray(isPoly);
	uUicp = cntlPnts.length;
	pp = new double[uUicp][4];
	tt = new double[uUicp][4];

	/*
	 * evaluate for V-direction
	 */
	if ((u_section = uKnotData.segmentIndex(uParam)) < 0)
	    throw new JgclFatal();
	for (i = j = u_section; i <= (u_section + uDegree()); i++, j++) {
	    if (!isPoly && j == uNControlPoints())
		j = 0;
	    JgclBsplineCurveEvaluation.evaluation(vKnotData, cntlPnts[j],
						  vParam, pp[j], tt[j],
						  null, null);
	}

	/*
	 * evaluate for U-direction
	 */
	ld1D[0] = new double[4];
	if (isPoly) {
	    JgclBsplineCurveEvaluation.evaluation(uKnotData, pp, uParam,
						  null, ld1D[0],null, null);
	    ld1D[1] = JgclBsplineCurveEvaluation.coordinates(uKnotData, tt, uParam);
	} else {
	    double[] ld0D = new double[4];
	    JgclBsplineCurveEvaluation.evaluation(uKnotData, pp, uParam,
						  ld0D, ld1D[0], null, null);
	    ld1D[1] = JgclBsplineCurveEvaluation.coordinates(uKnotData, tt, uParam);
	    convRational1Deriv(ld0D, ld1D[0], ld1D[1]);
	}
	for (i = 0; i < 2; i++) {
	    d1D[i] = new JgclLiteralVector3D(ld1D[i]);
	}
	return d1D;
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̕Γ֐ԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return		Γ֐
     * @see	JgclParameterOutOfRange
     */
    public JgclSurfaceDerivative3D evaluation(double uParam, double vParam)
    {
	double[][][] cntlPnts;
	int uUicp;
	int u_section;
	double[][] pp, tt, dd;
	double[] ld0, ldu, ldv, lduu, lduv, ldvv;
	JgclPoint3D d0;
	JgclVector3D du, dv, duu, duv, dvv;
	boolean isPoly = isPolynomial();
	int i, j;

	uParam = checkUParameter(uParam);
	vParam = checkVParameter(vParam);
	cntlPnts = toDoubleArray(isPoly);
	uUicp = cntlPnts.length;
	pp = new double[uUicp][4];
	tt = new double[uUicp][4];
	dd = new double[uUicp][4];

	/*
	 * evaluate for V-direction
	 */
	if ((u_section = uKnotData.segmentIndex(uParam)) < 0)
	    throw new JgclFatal();
	for (i = j = u_section; i <= (u_section + uDegree()); i++, j++) {
	    if (!isPoly && j == uNControlPoints())
		j = 0;
	    JgclBsplineCurveEvaluation.evaluation(vKnotData, cntlPnts[j], vParam,
						  pp[j], tt[j], dd[j], null);
	}

	/*
	 * evaluate for U-direction
	 */
	ldv = new double[4];
	lduv = new double[4];
	JgclBsplineCurveEvaluation.evaluation(uKnotData, tt, uParam, ldv, lduv, null, null);
	ldvv = JgclBsplineCurveEvaluation.coordinates(uKnotData, dd, uParam);
	ld0 = new double[4];
	ldu = new double[4];
	lduu = new double[4];
	JgclBsplineCurveEvaluation.evaluation(uKnotData, pp, uParam, ld0, ldu, lduu, null);

	if (!isPoly) {
	    convRational2Deriv(ld0, ldu, ldv, lduu, lduv, ldvv);
	}

	d0 = new JgclCartesianPoint3D(ld0);
	du = new JgclLiteralVector3D(ldu);
	dv = new JgclLiteralVector3D(ldv);
	duu = new JgclLiteralVector3D(lduu);
	duv = new JgclLiteralVector3D(lduv);
	dvv = new JgclLiteralVector3D(ldvv);
	return new JgclSurfaceDerivative3D(d0, du, dv, duu, duv, dvv);
    }

    /**
     * ̋Ȗʏ̓g (u, v) p[^lƂ݂Ȃ邩ۂAԂB
     *
     * @param pA	 (u, v) p[^l
     * @param pB	 (u, v) p[^l
     * @param dTol	̋e덷
     * @return	g (u, v) p[^l trueAłȂ false
     * @see	#projectFrom(JgclPoint3D)
     */
    private boolean twoPointsCoincide(JgclPointOnSurface3D pA,
				      JgclPointOnSurface3D pB,
				      JgclToleranceForDistance dTol) {
	if (pA.coordinates().distance2(pB.coordinates()) > dTol.squared()) {
	    return false;
	}

	double uA = pA.uParameter();
	double vA = pA.vParameter();
	double uB = pB.uParameter();
	double vB = pB.vParameter();

	double pDiff;
	double pTol;
	boolean coincide;

	pDiff = Math.abs(uA - uB);
	pTol = dTol.toToleranceForParameterU(this, uA, vA).value();
	coincide = false;
	if (pDiff < pTol) {
	    coincide = true;
	} else if (this.isUPeriodic() == true) {
	    if (Math.abs(pDiff - this.uParameterDomain().section().absIncrease()) < pTol)
		coincide = true;
	}
	if (coincide == false) {
	    return false;
	}

	pDiff = Math.abs(vA - vB);
	pTol = dTol.toToleranceForParameterV(this, uA, vA).value();
	coincide = false;
	if (pDiff < pTol) {
	    coincide = true;
	} else if (this.isVPeriodic() == true) {
	    if (Math.abs(pDiff - this.vParameterDomain().section().absIncrease()) < pTol)
		coincide = true;
	}
	if (coincide == false) {
	    return false;
	}

	return true;
    }

    /**
     * ^ꂽ_炱̋Ȗʂւ̓e_߂B
     * <p>
     * e_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * aXvCȖʂxWGȖʂ̏WɕϊA
     * _炻ꂼ̃xWGȖʂւ̓e_߂ĂB
     * </p>
     * 
     * @param point	e̓_
     * @return		e_̔z
     * @see	#toPureBezierSurfaceArray()
     */
    public JgclPointOnSurface3D[] projectFrom(JgclPoint3D point)
    {
	Vector projectedPointList = new Vector();

	JgclBsplineKnot.ValidSegmentInfo uValidSegmentsInfo = this.uValidSegments();
	JgclBsplineKnot.ValidSegmentInfo vValidSegmentsInfo = this.vValidSegments();

	JgclPureBezierSurface3D[][] bzss = this.toPureBezierSurfaceArray();
	JgclToleranceForDistance dTol = this.getToleranceForDistanceAsObject();

	for (int ui = 0; ui < uValidSegmentsInfo.nSegments(); ui++) {
	    for (int vi = 0; vi < vValidSegmentsInfo.nSegments(); vi++) {
		JgclPointOnSurface3D[] localProj = bzss[ui][vi].projectFrom(point);
		for (int i = 0; i < localProj.length; i++) {
		    JgclPointOnSurface3D proj =
			new JgclPointOnSurface3D
			(this,
			 uValidSegmentsInfo.l2Gp(ui, localProj[i].uParameter()),
			 vValidSegmentsInfo.l2Gp(vi, localProj[i].vParameter()));

		    boolean isUnique = true;
		    for (Enumeration e = projectedPointList.elements();
			 e.hasMoreElements();) {
			if (this.twoPointsCoincide
			    (proj, (JgclPointOnSurface3D)e.nextElement(), dTol) == true) {
			    isUnique = false;
			    break;
			}
		    }
		    if (isUnique == true)
			projectedPointList.addElement(proj);
		}
	    }
	}

	JgclPointOnSurface3D[] results = new JgclPointOnSurface3D[projectedPointList.size()];
	projectedPointList.copyInto(results);
	return results;
    }

    /**
     *  U Ɂu`v̂aXvCȖʂ̌`ςɁA
     * ^ꂽ U p[^lɑΉ_Jn_Ƃ悤
     * ϊ̂ԂB
     * <p>
     * aXvCȖʂ U ̊Jn_̃p[^l͏ 0 ɂȂB
     * </p>
     *
     * @param	newStartParam	Jn_ƂȂp[^l
     * @return	^ꂽp[^lɑΉ_Jn_ƂaXvCȖ
     * @exception JgclOpenSurfaceForUDirection	U ɊJ`̋Ȗʂł
     */
    public JgclBsplineSurface3D uShiftIfPeriodic(double newStartParam)
	 throws JgclOpenSurfaceForUDirection
    {
	if (this.isUPeriodic() != true)
	    throw new JgclOpenSurfaceForUDirection();

	newStartParam = this.uParameterDomain().wrap(newStartParam);

	// 擪ɂȂZOg̔ԍ𓾂
	int newFirstSegment =
	    this.uKnotData.getSegmentNumberThatStartIsEqualTo(newStartParam);

	if (newFirstSegment == (- 1))
	    return this.uInsertKnot(newStartParam).uShiftIfPeriodic(newStartParam);

	// mbgf[^̐
	JgclBsplineKnot newKnotData = this.uKnotData.shift(newFirstSegment);

	// _̐
	int uNNewControlPoints = newKnotData.nControlPoints();
	int vNNewControlPoints = this.vNControlPoints();

	JgclPoint3D[][] newControlPoints =
	    new JgclPoint3D[uNNewControlPoints][vNNewControlPoints];

	for (int ui = 0; ui < uNNewControlPoints; ui++)
	    for (int vi = 0; vi < vNNewControlPoints; vi++)
		newControlPoints[ui][vi] =
		    this.controlPointAt((ui + newFirstSegment) % uNNewControlPoints, vi);

	// dݗ̐
	double[][] newWeights = null;
	if (this.isRational() == true) {
	    newWeights =
		new double[uNNewControlPoints][vNNewControlPoints];

	    for (int ui = 0; ui < uNNewControlPoints; ui++)
		for (int vi = 0; vi < vNNewControlPoints; vi++)
		    newWeights[ui][vi] =
			this.weightAt((ui + newFirstSegment) % uNNewControlPoints, vi);
	}

	return new JgclBsplineSurface3D(newKnotData, this.vKnotData, newControlPoints, newWeights);
    }

    /**
     *  V Ɂu`v̂aXvCȖʂ̌`ςɁA
     * ^ꂽ V p[^lɑΉ_Jn_Ƃ悤
     * ϊ̂ԂB
     * <p>
     * aXvCȖʂ V ̊Jn_̃p[^l͏ 0 ɂȂB
     * </p>
     *
     * @param	newStartParam	Jn_ƂȂp[^l
     * @return	^ꂽp[^lɑΉ_Jn_ƂaXvCȖ
     * @exception JgclOpenSurfaceForVDirection	V ɊJ`̋Ȗʂł
     */
    public JgclBsplineSurface3D vShiftIfPeriodic(double newStartParam)
	 throws JgclOpenSurfaceForVDirection
    {
	if (this.isVPeriodic() != true)
	    throw new JgclOpenSurfaceForVDirection();

	newStartParam = this.vParameterDomain().wrap(newStartParam);

	// 擪ɂȂZOg̔ԍ𓾂
	int newFirstSegment =
	    this.vKnotData.getSegmentNumberThatStartIsEqualTo(newStartParam);

	if (newFirstSegment == (- 1))
	    return this.vInsertKnot(newStartParam).vShiftIfPeriodic(newStartParam);

	// mbgf[^̐
	JgclBsplineKnot newKnotData = this.vKnotData.shift(newFirstSegment);

	// _̐
	int uNNewControlPoints = this.uNControlPoints();
	int vNNewControlPoints = newKnotData.nControlPoints();

	JgclPoint3D[][] newControlPoints =
	    new JgclPoint3D[uNNewControlPoints][vNNewControlPoints];

	for (int ui = 0; ui < uNNewControlPoints; ui++)
	    for (int vi = 0; vi < vNNewControlPoints; vi++)
		newControlPoints[ui][vi] =
		    this.controlPointAt(ui, (vi + newFirstSegment) % vNNewControlPoints);

	// dݗ̐
	double[][] newWeights = null;
	if (this.isRational() == true) {
	    newWeights =
		new double[uNNewControlPoints][vNNewControlPoints];

	    for (int ui = 0; ui < uNNewControlPoints; ui++)
		for (int vi = 0; vi < vNNewControlPoints; vi++)
		    newWeights[ui][vi] =
			this.weightAt(ui, (vi + newFirstSegment) % vNNewControlPoints);
	}

	return new JgclBsplineSurface3D(this.uKnotData, newKnotData, newControlPoints, newWeights);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA^ꂽ덷ŕʋߎ
     * iq_QԂB
     * <p>
     * ʂƂĕԂiq_Q\_́A
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param tol	̋e덷
     * @return		̋Ȗʂ̎w̋Ԃ𕽖ʋߎiq_Q
     * @see	JgclPointOnSurface3D
     * @see	JgclParameterOutOfRange
     */
    public JgclMesh3D
	toMesh(JgclParameterSection uPint, JgclParameterSection vPint,
	       JgclToleranceForDistance tol)
    {
	JgclBsplineSurface3D t_bss;
	JgclMesh3D Mesh;
	JgclPoint3D[][] mesh;
	int u_npnts, v_npnts;
	double uSp, uIp, vSp, vIp;
	double uParam, vParam;
	boolean isUPeriodic = isUPeriodic();
	boolean isVPeriodic = isVPeriodic();
	int i, j;

	t_bss = truncate(uPint, vPint);
	Mesh = t_bss.toMesh(tol);

	uSp = uPint.start();
	uIp = uPint.increase();
	vSp = vPint.start();
	vIp = vPint.increase();

	u_npnts = Mesh.uNPoints();
	v_npnts = Mesh.vNPoints();
	mesh = Mesh.points();

	for (i = 0; i < u_npnts; i++) {
	    for (j = 0; j < v_npnts; j++) {
		if (isUPeriodic)
		    uParam = uSp + ((JgclPointOnSurface3D)mesh[i][j]).uParameter();
		else
		    uParam = ((JgclPointOnSurface3D)mesh[i][j]).uParameter();
		    
		if (isVPeriodic)
		    vParam = vSp + ((JgclPointOnSurface3D)mesh[i][j]).vParameter();
		else
		    vParam = ((JgclPointOnSurface3D)mesh[i][j]).vParameter();

		try {
		    mesh[i][j] = new JgclPointOnSurface3D(this, uParam, vParam, doCheckDebug);
		} catch (JgclInvalidArgumentValue e) {
		    throw new JgclFatal();
		}
	    }
	}

	return new JgclMesh3D(mesh, false);
    }

    /**
     *  (`̃p[^`) LȖʑŜA^ꂽ덷ŕʋߎ
     * iq_QԂB
     * <p>
     * ʂƂĕԂiq_Q\_́A
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D 
     * 邱Ƃ҂łB
     * </p>
     * 
     * @param tol	̋e덷
     * @return		̗LȖʑŜ𕽖ʋߎiq_Q
     * @see		JgclPointOnSurface3D
     */
    public JgclMesh3D toMesh(JgclToleranceForDistance tol) {
	JgclBsplineSurface3D obss;		/* open bss */
	JgclParameterDomain uDmn, vDmn;		/* parameter domain */

	JgclFreeformSurfaceWithControlPoints3D.SegInfo seg_info; /* a SegInfo */

	JgclFreeformSurfaceWithControlPoints3D.GpList u_gp_list; /* list of MeshParam for U dir. */
	JgclFreeformSurfaceWithControlPoints3D.GpList v_gp_list; /* list of MeshParam for V dir. */

	double[] u_kp = new double[2];	/* array of non-reduced knot points in [UV] dir. */
	double[] v_kp = new double[2];

	uDmn = uParameterDomain();
	vDmn = vParameterDomain();
	obss = openBssIfClosed().truncate(uDmn.section(), vDmn.section());
	// [̃mbg𑽏dɂ邽߁Atruncate()Ă

	/*
	 * divide Bspline into planes and determine mesh.
	 */
	u_gp_list = new JgclFreeformSurfaceWithControlPoints3D.GpList();
	v_gp_list = new JgclFreeformSurfaceWithControlPoints3D.GpList();

	seg_info = new JgclFreeformSurfaceWithControlPoints3D.SegInfo
	    (new MeshParam(0, 0, 1), new MeshParam(0, 1, 1),
	     new MeshParam(0, 0, 1), new MeshParam(0, 1, 1));

	obss.getSrfMesh(seg_info, tol, u_gp_list, v_gp_list);

	/*
	 * make parameters and mesh points
	 */
	u_kp[0] = uDmn.section().start();
	u_kp[1] = uDmn.section().end();

	v_kp[0] = vDmn.section().start();
	v_kp[1] = vDmn.section().end();

	return obss.makeParamAndMesh(u_gp_list, v_gp_list, u_kp, v_kp);
    }

    /**
     * ̋Ȗʂ U/V oɊJ`ɂ̂ԂB
     * <p>
     * this  U/V oɊJ`ł΁Athis ԂB
     * </p>
     *
     * @return	U/V oɊJ`̋Ȗ
     * @see	#toMesh(JgclToleranceForDistance)
     */
    private JgclBsplineSurface3D openBssIfClosed() {
	JgclBsplineSurface3D[] bsss;
	JgclParameterDomain uDmn, vDmn;

	uDmn = uParameterDomain();
	if (uDmn.isPeriodic()) {
	    try {
		bsss = uDivide(uDmn.section().end());
	    } catch (JgclParameterOutOfRange e) {
		throw new JgclFatal();
	    }
	    return bsss[0].openBssIfClosed();
	}

	vDmn = vParameterDomain();
	if (vDmn.isPeriodic()) {
	    try {
		bsss = vDivide(vDmn.section().end());
	    } catch (JgclParameterOutOfRange e) {
		throw new JgclFatal();
	    }
	    return bsss[0];
	}

	return this;
    }

    /**
     * ̋Ȗʂ^ꂽxɂĕʂƌȂȂꍇɁA
     * U/V Ƀp[^_œ񕪊B
     * <p>
     * ̋Ȗʂ U/V oɊJ`łKvB
     * </p>
     * <p>
     * ʂƂēz S ̗vf̐ 4 łB
     * evf́A̋Ȗʂ𕪊Ȗʂ̂ꂼ\B
     * <p>
     * ^ꂽ tol ɂāAȖʂ𕪊KvȂꍇɂ
     * S[i] (i = 0, ..., 3) ɂׂ͂ null B
     * </p>
     * <p>
     * Ȗʂ U/V Ƃɓ񕪊ꍇɂ́A
     * S ̊evf͈ȉ̋Ȗʂ\B
     * <pre>
     *		S[0] : U AV ɂȖ
     *		S[1] : U 㑤AV ɂȖ
     *		S[2] : U AV 㑤ɂȖ
     *		S[3] : U 㑤AV 㑤ɂȖ
     * </pre>
     * </p>
     * <p>
     * Ȗʂ U ɂ̂ݓ񕪊 (V ɂ͕KvȂ) ꍇɂ́A
     * S ̊evf͈ȉ̋Ȗʂ\B
     * <pre>
     *		S[0] : U ɂȖ
     *		S[1] : U 㑤ɂȖ
     *		S[2] : null
     *		S[3] : null
     * </pre>
     * </p>
     * <p>
     * Ȗʂ V ɂ̂ݓ񕪊 (U ɂ͕KvȂ) ꍇɂ́A
     * S ̊evf͈ȉ̋Ȗʂ\B
     * <pre>
     *		S[0] : V ɂȖ
     *		S[1] : null
     *		S[2] : V 㑤ɂȖ
     *		S[3] : null
     * </pre>
     * </p>
     *
     * @param tol	ʂƂ݂Ȃ̋e덷
     * @return		ꂽȖʂ̔z
     */
    JgclFreeformSurfaceWithControlPoints3D[] divideForMesh(JgclToleranceForDistance tol) {
	boolean u_coln;
	boolean v_coln;

	JgclParameterDomain uDmn, vDmn;
	double u_mid_param;
	double v_mid_param;

	if (isUPeriodic() || isVPeriodic())
	    throw new JgclFatal();

	JgclBsplineSurface3D[] bsss;
	JgclBsplineSurface3D vb_bss;
	JgclBsplineSurface3D vu_bss;
	JgclBsplineSurface3D lb_bss;
	JgclBsplineSurface3D rb_bss;
	JgclBsplineSurface3D lu_bss;
	JgclBsplineSurface3D ru_bss;

	double told = tol.value();

	u_coln = uIsColinear(controlPoints, told);
	v_coln = vIsColinear(controlPoints, told);

	uDmn = uParameterDomain();
	vDmn = vParameterDomain();

	u_mid_param = (uDmn.section().start() + uDmn.section().end()) / 2.0;
	v_mid_param = (vDmn.section().start() + vDmn.section().end()) / 2.0;

	try {
	    if (u_coln && v_coln) {
		lb_bss = null;
		rb_bss = null;
		lu_bss = null;
		ru_bss = null;

	    } else if ((!u_coln) && (!v_coln)) {
		bsss = vDivide(v_mid_param);
		vb_bss = bsss[0];
		vu_bss = bsss[1];

		bsss = vb_bss.uDivide(u_mid_param);
		lb_bss = bsss[0];
		rb_bss = bsss[1];

		bsss = vu_bss.uDivide(u_mid_param);
		lu_bss = bsss[0];
		ru_bss = bsss[1];

	    } else if (u_coln) {
		bsss = vDivide(v_mid_param);
		lb_bss = bsss[0];
		lu_bss = bsss[1];

		rb_bss = null;
		ru_bss = null;

	    } else {	// if (v_coln)
		bsss = uDivide(u_mid_param);
		lb_bss = bsss[0];
		rb_bss = bsss[1];

		lu_bss = null;
		ru_bss = null;

	    }
	} catch (JgclParameterOutOfRange e) {
	    throw new JgclFatal();
	}

	bsss = new JgclBsplineSurface3D[4];

	bsss[0] = lb_bss;
	bsss[1] = rb_bss;
	bsss[2] = lu_bss;
	bsss[3] = ru_bss;

	return bsss;
    }

    /**
     * ̋Ȗʂʌ`Ƃ݂Ȃ邩ǂԂB
     *
     * @param tol	ʂƂ݂Ȃ̋e덷
     * @return		ʂƂ݂ȂȂ trueAłȂ false
     * @see	JgclPureBezierSurface3D#isPlaner(JgclToleranceForDistance)
     */
    boolean isPlaner(JgclToleranceForDistance tol) {
	JgclPureBezierSurface3D bzs;

	try {
	    bzs = new JgclPureBezierSurface3D(controlPoints);
	} catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}

	return bzs.isPlaner(tol);
    }

    /**
     * ̂aXvCȖʂČxWGȖʂ̓񎟌zԂB
     * <p>
     * ̋Ȗʂ U/V ƂɃp[^IɏkނĂȂLZOgɑΉ
     * xWGȖʂ̓񎟌zԂB
     * </p>
     * 
     * @return	xWGȖʂ̓񎟌z
     */
    public JgclPureBezierSurface3D[][] toPureBezierSurfaceArray() {
	double[][][] cntlPnts;
	boolean isPoly = isPolynomial();
	double[][][][][] bzs_array;
	JgclPureBezierSurface3D[][] bzss;

	cntlPnts = toDoubleArray(isPoly);
	bzs_array = JgclBsplineCurveEvaluation.toBezierSurface(uKnotData, vKnotData, cntlPnts);
	bzss = new JgclPureBezierSurface3D[bzs_array.length][bzs_array[0].length];
	for (int i = 0; i < bzs_array.length; i++) {
	    for (int j = 0; j < bzs_array[0].length; j++) {
		bzss[i][j] = new JgclPureBezierSurface3D(bzs_array[i][j]);
	    }
	}

	return bzss;
    }

    /**
     *  (`̃p[^`) LȖʑŜɍČ
     * L Bspline ȖʂԂB
     * <p>
     * this LȖʂł΁Athis ԂB
     * </p>
     * 
     * @return		̗LȖʑŜČL Bspline Ȗ
     */
    public JgclBsplineSurface3D toBsplineSurface()
    {
	if (this.isRational() == true)
	    return this;

	return new JgclBsplineSurface3D(this.uKnotData,
					this.vKnotData,
					this.controlPoints,
					this.makeUniformWeights());
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂɍČ
     * L Bspline ȖʂԂB
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @return		̋Ȗʂ̎w̋ԂČL Bspline Ȗ
     * @see	JgclParameterOutOfRange
     * @see	#toBsplineSurface()
     */
    public JgclBsplineSurface3D
	toBsplineSurface(JgclParameterSection uPint,
			 JgclParameterSection vPint)
    {
	JgclBsplineSurface3D target = this;

	// U direction
	if (target.isUPeriodic() == true) {
	    if (uPint.absIncrease() >= target.uParameterDomain().section().absIncrease()) {
		try {
		    target = target.uShiftIfPeriodic(uPint.start());
		} catch (JgclOpenSurfaceForUDirection e) {
		    ;	// N蓾Ȃ͂
		}
		if (uPint.increase() < 0.0)
		    target = target.reverse(true, false);
	    } else {
		target = target.uTruncate(uPint);
	    }
	} else {
	    target = target.uTruncate(uPint);
	}

	// V direction
	if (target.isVPeriodic() == true) {
	    if (vPint.absIncrease() >= target.vParameterDomain().section().absIncrease()) {
		try {
		    target = target.vShiftIfPeriodic(vPint.start());
		} catch (JgclOpenSurfaceForVDirection e) {
		    ;	// N蓾Ȃ͂
		}
		if (vPint.increase() < 0.0)
		    target = target.reverse(false, true);
	    } else {
		target = target.vTruncate(vPint);
	    }
	} else {
	    target = target.vTruncate(vPint);
	}

	return target.toBsplineSurface();
    }

    /**
     * ̋ȖʂƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate)
	throws JgclIndefiniteSolution
    {
	return mate.intersect(this, true);
    }

    /**
     * ̋ȖʂƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsCrvBss3D#intersection(JgclParametricCurve3D, JgclBsplineSurface3D, boolean)
     * JgclIntsCrvBss3D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
	return JgclIntsCrvBss3D.intersection(mate, this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȑ (~Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsCrvBss3D#intersection(JgclParametricCurve3D, JgclBsplineSurface3D, boolean)
     * JgclIntsCrvBss3D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (~Ȑ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclConic3D mate, boolean doExchange) {
	return JgclIntsCrvBss3D.intersection(mate, this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsCrvBss3D#intersection(JgclParametricCurve3D, JgclBsplineSurface3D, boolean)
     * JgclIntsCrvBss3D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
	return JgclIntsCrvBss3D.intersection(mate, this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsCrvBss3D#intersection(JgclParametricCurve3D, JgclBsplineSurface3D, boolean)
     * JgclIntsCrvBss3D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
	return JgclIntsCrvBss3D.intersection(mate, this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗʂ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ȖʂӏɂẮA (JgclIntersectionCurve3D) ԂB
     * </p>
     * <p>
     * ȖʂڂӏɂẮA_ (JgclIntersectionPoint3D) Ԃ邱ƂB
     * </p>
     * 
     * @param mate	̋Ȗ
     * @return		 (܂͌_) ̔z
     * @see		JgclIntersectionCurve3D
     * @see		JgclIntersectionPoint3D
     */
    public JgclSurfaceSurfaceInterference3D[] intersect(JgclParametricSurface3D mate) {
	return mate.intersect(this, true);
    }

    /**
     * ̋ȖʂƑ̋Ȗ () ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsSrfBss3D#intersection(JgclElementarySurface3D, JgclBsplineSurface3D, boolean)
     * JgclIntsSrfBss3D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclPlane3D mate, boolean doExchange) {
	return JgclIntsSrfBss3D.intersection(mate, this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ () ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsSrfBss3D#intersection(JgclElementarySurface3D, JgclBsplineSurface3D, boolean)
     * JgclIntsSrfBss3D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclSphericalSurface3D mate,
						 boolean doExchange) {
	return JgclIntsSrfBss3D.intersection(mate, this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (~) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsSrfBss3D#intersection(JgclElementarySurface3D, JgclBsplineSurface3D, boolean)
     * JgclIntsSrfBss3D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclCylindricalSurface3D mate,
						 boolean doExchange) {
	return JgclIntsSrfBss3D.intersection(mate, this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (~) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsSrfBss3D#intersection(JgclElementarySurface3D, JgclBsplineSurface3D, boolean)
     * JgclIntsSrfBss3D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclConicalSurface3D mate,
						 boolean doExchange) {
	return JgclIntsSrfBss3D.intersection(mate, this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (xWGȖ) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsSrfBss3D#intersection(JgclElementarySurface3D, JgclBsplineSurface3D, boolean)
     * JgclIntsSrfBss3D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (xWGȖ)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclPureBezierSurface3D mate,
						 boolean doExchange) {
	return JgclIntsSrfBss3D.intersection(mate, this, !doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (aXvCȖ) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclIntsSrfBss3D#intersection(JgclElementarySurface3D, JgclBsplineSurface3D, boolean)
     * JgclIntsSrfBss3D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (aXvCȖ)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclBsplineSurface3D mate,
						 boolean doExchange) {
	return JgclIntsSrfBss3D.intersection(mate, this, !doExchange);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂItZbgȖʂ
     * ^ꂽ덷ŋߎ Bspline Ȗʂ߂B
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.FRONT/BACK)
     * @param tol     	̋e덷
     * @return		̋Ȗʂ̎w̋`Ԃ̃ItZbgȖʂߎ Bspline Ȗ
     * @see	JgclWhichSide
     */
    public JgclBsplineSurface3D
	offsetByBsplineSurface(JgclParameterSection uPint,
			       JgclParameterSection vPint,
			       double magni,
			       int side,
			       JgclToleranceForDistance tol)
    {
	JgclOfst3D doObj = new JgclOfst3D(this,uPint,vPint,magni,side,tol);
	return doObj.offset();
    }
    
    /*
     * ̋Ȗʂ U p[^̈ʒuɂ铙p[^ȐԂB
     *
     * @param uParam	U ̃p[^l
     * @return	w U p[^lł̓p[^Ȑ
     */
    public JgclParametricCurve3D uIsoParametricCurve(double uParam) {
	uParam = checkUParameter(uParam);
	boolean isPoly = isPolynomial();
	double[][][] cntlPnts = toDoubleArray(isPoly);
	int uUicp = uNControlPoints();
	int vUicp = vNControlPoints();
	double[][] tBsc = new double[uUicp][];
	double[][] bsc = new double[vUicp][];

	for (int i = 0; i < vUicp; i++) {
	    for (int j = 0; j < uUicp; j++)
		tBsc[j] = cntlPnts[j][i];
	    bsc[i] = JgclBsplineCurveEvaluation.coordinates(uKnotData, tBsc, uParam);
	}
	return new JgclBsplineCurve3D(vKnotData, bsc);
    }

    /*
     * ̋Ȗʂ V p[^̈ʒuɂ铙p[^ȐԂB
     *
     * @param vParam	V ̃p[^l
     * @return	w V p[^lł̓p[^Ȑ
     */
    public JgclParametricCurve3D vIsoParametricCurve(double vParam) {
	vParam = checkVParameter(vParam);
	boolean isPoly = isPolynomial();
	double[][][] cntlPnts = toDoubleArray(isPoly);
	int uUicp = uNControlPoints();
	double[][] bsc = new double[uUicp][];

	for (int i = 0; i < uUicp; i++) {
	    bsc[i] = JgclBsplineCurveEvaluation.coordinates(vKnotData, cntlPnts[i], vParam);
	}
	return new JgclBsplineCurve3D(uKnotData, bsc);
    }

    /**
     * ̋Ȗʂ́A^ꂽ U ̃p[^ʒuɐVȃmbg}B
     * <p>
     * `͕ς炸ɁAU ̃ZOgaXvCȖʂԂB
     * </p>
     *
     * @param uParam	mbg} U ̃p[^ʒu
     * @return	mbg}̂aXvCȖ
     */
    public JgclBsplineSurface3D uInsertKnot(double uParam) {
	double[][][] cntlPnts;
	double [][] bsc;
	double [][][] bss_array = null;
	Object[] objs;
	JgclBsplineKnot newUKd = null;
	double[][] newUCp;
	int newUUicp = 0;
	int uUicp = uNControlPoints();
	int vUicp = vNControlPoints();
	boolean isPoly = isPolynomial();
	int i, j;

	uParam = checkUParameter(uParam);
	cntlPnts = toDoubleArray(isPoly);
	bsc = new double[uUicp][];

	for (i = 0; i < vUicp; i++) {
	    for (j = 0; j < uUicp; j++)
		bsc[j] = cntlPnts[j][i];
	    objs = JgclBsplineCurveEvaluation.insertKnot(uKnotData, bsc, uParam);

	    if (i == 0) {
		newUKd = (JgclBsplineKnot)objs[0];
		newUUicp = newUKd.nControlPoints();
		bss_array = new double[newUUicp][vUicp][];
	    }

	    newUCp = (double[][])objs[1];

	    for (j = 0; j < newUUicp; j++)
		bss_array[j][i] = newUCp[j];
	}

	return new JgclBsplineSurface3D(newUKd, vKnotData, bss_array);
    }

    /**
     * ̋Ȗʂ́A^ꂽ V ̃p[^ʒuɐVȃmbg}B
     * <p>
     * `͕ς炸ɁAV ̃ZOgaXvCȖʂԂB
     * </p>
     *
     * @param vParam	mbg} V ̃p[^ʒu
     * @return	mbg}̂aXvCȖ
     */
    public JgclBsplineSurface3D vInsertKnot(double vParam) {
	double[][][] cntlPnts;
	double [][][] bss_array;
	Object[] objs;
	JgclBsplineKnot newVKd = null;
	int uUicp = uNControlPoints();
	boolean isPoly = isPolynomial();
	int i;

	vParam = checkVParameter(vParam);
	cntlPnts = toDoubleArray(isPoly);
	bss_array = new double[uUicp][][];

	for (i = 0; i < uUicp; i++) {
	    objs = JgclBsplineCurveEvaluation.insertKnot(vKnotData, cntlPnts[i], vParam);
	    if (i == 0)
		newVKd = (JgclBsplineKnot)objs[0];
	    bss_array[i] = (double[][])objs[1];
	}

	return new JgclBsplineSurface3D(uKnotData, newVKd, bss_array);
    }

    /**
     * ̋ȖʂA^ꂽ U ̃p[^lŕB
     * <p>
     * ̋Ȗʂ U ɊJ`̏ꍇA
     * uParam ɑΉ铙p[^ȐőOʂɕB
     * ʂƂēz̗vf 2 ŁA
     * ŏ̗vfɂ U ŐȖʁA
     * Ԗڂ̗vfɂ U 㑤̋Ȗ
     * B
     * </p>
     * <p>
     * ̋Ȗʂ U ɕ`̏ꍇ́A
     * uParam ɑΉ铙p[^ȐEƂ
     * U ɊJ`̈ꖇ̋ȖʂɕϊB
     * ʂƂēz̗vf 1 łB
     * </p>
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param uParam	U ̃p[^l
     * @return	̂aXvCȖʂ̔z
     * @see	JgclParameterOutOfRange
     * @see	#vDivide(double)
     */
    public JgclBsplineSurface3D[] uDivide(double uParam)
    {
	double[][][] cntlPnts;
	double [][] bsc;
	double [][][][] bsss_array = new double[2][][][];
	JgclBsplineKnot[] newUKd = new JgclBsplineKnot[2];
	double[][][] newUCp = new double[2][][];
	int[] newUUicp = new int[2];
	JgclBsplineSurface3D[] bsss;
	int n_bsss = 0;
	int uUicp = uNControlPoints();
	int vUicp = vNControlPoints();
	boolean isPoly = isPolynomial();
	int i, j, k;

	uParam = checkUParameter(uParam);
	cntlPnts = toDoubleArray(isPoly);
	bsc = new double[uUicp][];

	for (i = 0; i < vUicp; i++) {
	    for (j = 0; j < uUicp; j++)
		bsc[j] = cntlPnts[j][i];
	    JgclBsplineCurveEvaluation.divide(uKnotData, bsc, uParam, newUKd, newUCp);
	    if (newUKd[0] == null)
		throw new JgclFatal();
	    else if (newUKd[1] == null)
		n_bsss = 1;
	    else
		n_bsss = 2;

	    if (i == 0) {
		for (k = 0; k < n_bsss; k++) {
		    newUUicp[k] = newUKd[k].nControlPoints();
		    bsss_array[k] = new double[newUUicp[k]][vUicp][];
		}
	    }

	    for (k = 0; k < n_bsss; k++)
		for (j = 0; j < newUUicp[k]; j++)
		    bsss_array[k][j][i] = newUCp[k][j];
	}

	bsss = new JgclBsplineSurface3D[n_bsss];
	for (i = 0; i < n_bsss; i++) {
	    try {
		bsss[i] = new JgclBsplineSurface3D(newUKd[i], vKnotData, bsss_array[i]);
	    } catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}
	return bsss;
    }

    /*
     * ̋ȖʂA^ꂽ V ̃p[^lŕB
     * <p>
     * ̋Ȗʂ V ɊJ`̏ꍇA
     * vParam ɑΉ铙p[^ȐőOʂɕB
     * ʂƂēz̗vf 2 ŁA
     * ŏ̗vfɂ V ŐȖʁA
     * Ԗڂ̗vfɂ V 㑤̋Ȗ
     * B
     * </p>
     * <p>
     * ̋Ȗʂ V ɕ`̏ꍇ́A
     * vParam ɑΉ铙p[^ȐEƂ
     * V ɊJ`̈ꖇ̋ȖʂɕϊB
     * ʂƂēz̗vf 1 łB
     * </p>
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param vParam	V ̃p[^l
     * @return	̂aXvCȖʂ̔z
     * @see	JgclParameterOutOfRange
     * @see	#uDivide(double)
     */
    public JgclBsplineSurface3D[] vDivide(double vParam)
    {
	double[][][] cntlPnts;
	double [][][][] bsss_array;
	JgclBsplineKnot[] newVKd = new JgclBsplineKnot[2];
	double[][][] newVCp = new double[2][][];
	JgclBsplineSurface3D[] bsss;
	int n_bsss;
	int uUicp = uNControlPoints();
	boolean isPoly = isPolynomial();
	int i;

	vParam = checkVParameter(vParam);
	cntlPnts = toDoubleArray(isPoly);
	bsss_array = new double[2][uUicp][][];

	for (i = 0; i < uUicp; i++) {
	    JgclBsplineCurveEvaluation.divide(vKnotData, cntlPnts[i], vParam, newVKd, newVCp);
	    bsss_array[0][i] = newVCp[0];
	    if (newVKd[0] == null)
		throw new JgclFatal();
	    else if (newVKd[1] != null)
		bsss_array[1][i] = newVCp[1];
	}

	if (newVKd[1] == null)
	    n_bsss = 1;
	else
	    n_bsss = 2;

	bsss = new JgclBsplineSurface3D[n_bsss];
	for (i = 0; i < n_bsss; i++) {
	    try {
		bsss[i] = new JgclBsplineSurface3D(uKnotData, newVKd[i], bsss_array[i]);
	    } catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}
	return bsss;
    }

    /**
     * ̂aXvCȖʂA^ꂽ`ԂŐؒfB
     * <p>
     * uSection ̑l̏ꍇɂ́AU ̐is]aXvCȖʂԂB
     * lɁA
     * vSection ̑l̏ꍇɂ́AV ̐is]aXvCȖʂԂB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param uSection	ؒfĎc\ U ̃p[^
     * @param vSection	ؒfĎc\ V ̃p[^
     * @return	ؒfĎc\aXvCȖ
     * @see	JgclParameterOutOfRange
     */
    public JgclBsplineSurface3D truncate(JgclParameterSection uSection,
					 JgclParameterSection vSection)
    {
	JgclBsplineSurface3D t_bss;

	t_bss = uTruncate(uSection);
	t_bss = t_bss.vTruncate(vSection);
	return t_bss;
    }

    /**
     * ̂aXvCȖʂA^ꂽ U ̋ԂŐؒfB
     * <p>
     * section ̑l̏ꍇɂ́AU ̐is]aXvCȖʂԂB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param section	ؒfĎc\ U ̃p[^
     * @return	ؒfĎc\aXvCȖ
     * @see	JgclParameterOutOfRange
     * @see	#truncate(JgclParameterSection, JgclParameterSection)
     * @see	#vTruncate(JgclParameterSection)
     * @see	#reverse(boolean, boolean)
     */
    private JgclBsplineSurface3D uTruncate(JgclParameterSection section)
    {
	double start_par, end_par;
	JgclBsplineSurface3D t_bss;

	if (isUNonPeriodic()) {
	    start_par = checkUParameter(section.lower());
	    end_par = checkUParameter(section.upper());
	    t_bss = uDivide(start_par)[1];
	    t_bss = t_bss.uDivide(end_par)[0];
	} else {
	    double srf_intvl = uParameterDomain().section().increase();
	    double tol_p = JgclConditionOfOperation.getCondition().getToleranceForParameter();

	    start_par = checkUParameter(section.start());
	    t_bss = uDivide(start_par)[0];
	    if (Math.abs(section.increase()) < srf_intvl - tol_p) {
		if (section.increase() > 0.0) {
		    end_par = section.increase();
		    t_bss = t_bss.uDivide(end_par)[0];
		} else {
		    end_par = srf_intvl + section.increase();
		    t_bss = t_bss.uDivide(end_par)[1];
		}
	    }
	}

	if (section.increase() < 0.0)
	    t_bss = t_bss.reverse(true, false);

	return t_bss;
    }

    /**
     * ̂aXvCȖʂA^ꂽ V ̋ԂŐؒfB
     * <p>
     * section ̑l̏ꍇɂ́AV ̐is]aXvCȖʂԂB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param section	ؒfĎc\ V ̃p[^
     * @return	ؒfĎc\aXvCȖ
     * @see	JgclParameterOutOfRange
     * @see	#truncate(JgclParameterSection, JgclParameterSection)
     * @see	#uTruncate(JgclParameterSection)
     * @see	#reverse(boolean, boolean)
     */
    private JgclBsplineSurface3D vTruncate(JgclParameterSection section)
    {
	double start_par, end_par;
	JgclBsplineSurface3D t_bss;

	if (isVNonPeriodic()) {
	    start_par = checkVParameter(section.lower());
	    end_par = checkVParameter(section.upper());
	    t_bss = vDivide(start_par)[1];
	    t_bss = t_bss.vDivide(end_par)[0];
	} else {
	    double srf_intvl = vParameterDomain().section().increase();
	    double tol_p = JgclConditionOfOperation.getCondition().getToleranceForParameter();

	    start_par = checkVParameter(section.start());
	    t_bss = vDivide(start_par)[0];
	    if (Math.abs(section.increase()) < srf_intvl - tol_p) {
		if (section.increase() > 0.0) {
		    end_par = section.increase();
		    t_bss = t_bss.vDivide(end_par)[0];
		} else {
		    end_par = srf_intvl + section.increase();
		    t_bss = t_bss.vDivide(end_par)[1];
		}
	    }
	}

	if (section.increase() < 0.0)
	    t_bss = t_bss.reverse(false, true);

	return t_bss;
    }

    /**
     * ̂aXvCȖʂAw̕ɔ]aXvCȖʂԂB
     *
     * @param isU	U ɔ]ǂ
     * @param isV	V ɔ]ǂ
     * @return		]aXvCȖ
     */
    private JgclBsplineSurface3D reverse(boolean isU, boolean isV) {
	JgclBsplineKnot rUKd, rVKd;
	boolean isRat = isRational();
	int uUicp = uNControlPoints();
	int vUicp = vNControlPoints();
	JgclPoint3D[][] rCp = new JgclPoint3D[uUicp][vUicp];
	double[][] rWt = null;
	int i, j, k, l;

	if ((!isU) && (!isV)) {
	    return this;
	}

	if (isRat)
	    rWt = new double[uUicp][vUicp];

	if (isU) {
	    j = uUicp - 1;
	    rUKd = uKnotData.reverse();
	} else {
	    j = 0;
	    rUKd = uKnotData;
	}
	if (isV)
	    rVKd = vKnotData.reverse();
	else
	    rVKd = vKnotData;

	for (i = 0; i < uUicp; i++) {
	    if (isV)
		l = vUicp - 1;
	    else
		l = 0;
	    for (k = 0; k < vUicp; k++) {
		rCp[i][k] = controlPointAt(j, l);
		if (isRat)
		    rWt[i][k] = weightAt(j, l);
		if (isV)
		    l--;
		else
		    l++;
	    }
	    if (isU)
		j--;
	    else
		j++;
	}

	return new JgclBsplineSurface3D(rUKd, rVKd, rCp, rWt);
    }

    /**
     * ̋Ȗʂ U ̃p[^`ԂB
     * 
     * @return	U ̃p[^`
     * @see	JgclBsplineKnot#getParameterDomain()
     */
    JgclParameterDomain getUParameterDomain() {
	return uKnotData.getParameterDomain();
    }

    /**
     * ̋Ȗʂ V ̃p[^`ԂB
     * 
     * @return	V ̃p[^`
     * @see	JgclBsplineKnot#getParameterDomain()
     */
    JgclParameterDomain getVParameterDomain() {
	return vKnotData.getParameterDomain();
    }

    /*
     * ^ꂽp[^lA̋Ȗʂ U ̒`ɑ΂ėLۂ𒲂ׂB
     * <p>
     * ^ꂽp[^l̋Ȗʂ U ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param param	U ̃p[^l
     * @return	KvɉĂ̋Ȗʂ U ̒`Ɋۂ߂ꂽp[^l
     * @see	JgclParametricSurface#checkUValidity(double)
     * @see	JgclParameterDomain#force(double)
     * @see	JgclParameterDomain#wrap(double)
     * @see	JgclParameterOutOfRange
     */
    private double checkUParameter(double param)
    {
	checkUValidity(param);
	return uParameterDomain().force(uParameterDomain().wrap(param));
    }

    /*
     * ^ꂽp[^lA̋Ȗʂ V ̒`ɑ΂ėLۂ𒲂ׂB
     * <p>
     * ^ꂽp[^l̋Ȗʂ V ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param param	V ̃p[^l
     * @return	KvɉĂ̋Ȗʂ V ̒`Ɋۂ߂ꂽp[^l
     * @see	JgclParametricSurface#checkVValidity(double)
     * @see	JgclParameterDomain#force(double)
     * @see	JgclParameterDomain#wrap(double)
     * @see	JgclParameterOutOfRange
     */
    private double checkVParameter(double param)
    {
	checkVValidity(param);
	return vParameterDomain().force(vParameterDomain().wrap(param));
    }

    /**
     * ̋ȖʂA`̂܂܂ɂāAU ̎グȖʂԂB
     *
     * @return	`ŁAU ̎オȖ
     */
    public JgclBsplineSurface3D uElevateOneDegree() {
	JgclBsplineKnot oldUKnotData = this.uKnotData;
	JgclBsplineKnot oldVKnotData = this.vKnotData;
	int oldUNCP = oldUKnotData.nControlPoints();
	int oldVNCP = oldVKnotData.nControlPoints();
	double[][][] oldControlPoints = this.toDoubleArray(this.isPolynomial());

	JgclBsplineKnot newUKnotData =
	    JgclBsplineCurveEvaluation.getNewKnotDataAtDegreeElevation(oldUKnotData);
	JgclBsplineKnot newVKnotData = oldVKnotData;
	int newUNCP = newUKnotData.nControlPoints();
	int newVNCP = newVKnotData.nControlPoints();
	double[][][] newControlPoints = new double[newUNCP][newVNCP][];

	double[][] oldCurve = new double[oldUNCP][];
	double[][] newCurve;

	for (int vi = 0; vi < oldVNCP; vi++) {
	    for (int ui = 0; ui < oldUNCP; ui++)
		oldCurve[ui] = oldControlPoints[ui][vi];
	    newCurve = JgclBsplineCurveEvaluation.
		getNewControlPointsAtDegreeElevation(oldUKnotData,
						     newUKnotData,
						     oldCurve);
	    for (int ui = 0; ui < newUNCP; ui++)
		newControlPoints[ui][vi] = newCurve[ui];
	}

	return new JgclBsplineSurface3D(newUKnotData, newVKnotData, newControlPoints);
    }

    /**
     * ̋ȖʂA`̂܂܂ɂāAV ̎グȖʂԂB
     *
     * @return	`ŁAV ̎オȖ
     */
    public JgclBsplineSurface3D vElevateOneDegree() {
	JgclBsplineKnot oldUKnotData = this.uKnotData;
	JgclBsplineKnot oldVKnotData = this.vKnotData;
	int oldUNCP = oldUKnotData.nControlPoints();
	int oldVNCP = oldVKnotData.nControlPoints();
	double[][][] oldControlPoints = this.toDoubleArray(this.isPolynomial());

	JgclBsplineKnot newUKnotData = oldUKnotData;
	JgclBsplineKnot newVKnotData =
	    JgclBsplineCurveEvaluation.getNewKnotDataAtDegreeElevation(oldVKnotData);
	int newUNCP = newUKnotData.nControlPoints();
	int newVNCP = newVKnotData.nControlPoints();
	double[][][] newControlPoints = new double[newUNCP][][];

	for (int ui = 0; ui < oldUNCP; ui++) {
	    newControlPoints[ui] = JgclBsplineCurveEvaluation.
		getNewControlPointsAtDegreeElevation(oldVKnotData,
						     newVKnotData,
						     oldControlPoints[ui]);
	}

	return new JgclBsplineSurface3D(newUKnotData, newVKnotData, newControlPoints);
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricSurface3D#BSPLINE_SURFACE_3D JgclParametricSurface3D.BSPLINE_SURFACE_3D}
     */
    int type() {
	return BSPLINE_SURFACE_3D;
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA
     * ^ꂽ덷ŕʋߎ_QԂB
     * <p>
     * ʂƂē_Q͈ʂɁAʑIɂ􉽓IɂAiqł͂ȂB
     * </p>
     * <p>
     * scalingFactor ́A͗pł͂ȂAo͗p̈łB
     * scalingFactor ɂ́Avf 2 ̔z^B
     * scalingFactor[0] ɂ U ̏kڔ{A
     * scalingFactor[1] ɂ V ̏kڔ{ԂB
     * ̒l͉炩̐Βlł͂ȂA
     * p[^̐iޑx T ɑ΂āA
     * U/V ɂĎԏŋȖʏ̓_iޑx Pu/Pv \ΒlłB
     * ܂Ap[^ T iނƁA
     * ԏł̋Ȗʏ̓_ U ł Pu (scalingFactor[0])A
     * V ł Pv (scalingFactor[1]) iނƂ\ĂB
     * T ̑傫͖Ȃ̂ŁA̒lQƂۂɂ́A
     * scalingFactor[0]  scalingFactor[1] ̔䂾pׂłB
     * ȂA̒l͂܂łڈłAȑx̂ł͂ȂB
     * </p>
     * <p>
     * ʂƂĕԂ Vector Ɋ܂܂evf
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D
     * ł邱Ƃ҂łB
     * </p>
     *
     * @param uParameterSection	U ̃p[^
     * @param vParameterSection	V ̃p[^
     * @param tolerance	̋e덷
     * @param scalingFactor	_QOp`ۂɗLpƎv U/V ̏kڔ{
     * @return	_Q܂ Vector
     * @see	JgclPointOnSurface3D
     */
    public Vector toNonStructuredPoints(JgclParameterSection uParameterSection,
					JgclParameterSection vParameterSection,
					double tolerance,
					double[] scalingFactor) {
	Vector result = new Vector();

	// 芸A̎
	JgclMesh3D mesh = this.toMesh(uParameterSection,
				      vParameterSection,
				      new JgclToleranceForDistance(tolerance));

	for (int u = 0; u < mesh.uNPoints(); u++)
	    for (int v = 0; v < mesh.vNPoints(); v++)
		result.addElement(mesh.pointAt(u, v));

	scalingFactor[0] = getMaxLengthOfUControlPolygons(uKnotData.isPeriodic());
	scalingFactor[1] = getMaxLengthOfVControlPolygons(vKnotData.isPeriodic());

	return result;
    }

    /**
     * ̋ȖʂA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricSurface3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclPoint3D[][] tControlPoints = new JgclPoint3D[this.uNControlPoints()][];
	for (int i = 0; i < this.uNControlPoints(); i++)
	    tControlPoints[i] = JgclPoint3D.transform(this.controlPoints[i],
						      reverseTransform,
						      transformationOperator,
						      transformedGeometries);
	return new JgclBsplineSurface3D(this.uKnotData, this.vKnotData,
					tControlPoints, this.weights);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        // output knotData(JgclBsplineKnot)
        //writer.println(indent_tab + "\tuKnotData");
        //uKnotData.output(writer, indent + 2);
        uKnotData.output(writer, indent, 1);
        //writer.println(indent_tab + "\tvKnotData");
        //vKnotData.output(writer, indent + 2);
        vKnotData.output(writer, indent, 2);

        // output controlPoints
        writer.println(indent_tab + "\tcontrolPoints");
	for (int i = 0; i < controlPoints.length; i++) {
            for (int j = 0; j < controlPoints[i].length; j++) {
                controlPoints[i][j].output(writer, indent + 2);
            }
        }

        // output weights
	if (weights() != null) {
	    writer.println(indent_tab + "\tweights ");
	    for (int j = 0; j < weights().length; j++) {
		writer.print(indent_tab + "\t\t");
		for (int k =0; k < weights()[j].length; k++){
		    writer.print(" " + weightAt(j,k));
		}
		writer.println();
	    }
	}
        writer.println(indent_tab + "\tsurfaceForm\t"+ JgclBsplineSurfaceForm.toString(surfaceForm));

        writer.println(indent_tab + "End");
    }
}
