/*
 * Q : L () aXvCȐїLaXvCȐ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclBsplineCurve2D.java,v 1.98 2000/08/11 06:18:42 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * Q : L () aXvCȐїLaXvCȐ\NXB
 * <p>
 * ̃NX̃CX^X́A
 * aXvC̃mbgɊւ knotData ({@link JgclBsplineKnot JgclBsplineKnot})
 * B
 * _ȂǂێtB[hɂẮA
 * {@link JgclFreeformCurveWithControlPoints2D X[p[NX̉} QƁB
 * </p>
 * <p>
 * aXvCȐ̃p[^`́AΉmbgɂČ܂B
 * </p>
 * <p>
 * t p[^ƂaXvCȐ P(t) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	n = Ȑ̎
 *	m = ZOg̐ (J` : (_̐ - Ȑ̎), ` : _̐)
 *	di = controlPoints[i]
 *	wi = weights[i]
 * </pre>
 * ƂāALaXvCȐ
 * <pre>
 *	P(t) =	(di * Nn,i(t)) ̑a		(i = 0, ..., (m + n - 1))
 * </pre>
 * LaXvCȐ
 * <pre>
 *		(wi * di * Nn,i(t)) ̑a
 *	P(t) =	-------------------------- 	(i = 0, ..., (m + n - 1))
 *		(wi * Nn,i(t)) ̑a
 * </pre>
 *  Nn,i(t) ͂aXvC֐B
 * ȂA`̏ꍇ i &gt; (_̐ - 1) ƂȂ i ɂẮA
 * Ή鐧_Əd݂ꂼ dj, wj (j = i - _̐) ƂȂB
 * </p>
 *
 * @version $Revision: 1.98 $, $Date: 2000/08/11 06:18:42 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclBsplineCurve2D extends JgclFreeformCurveWithControlPoints2D {
    /**
     * mbgB
     * @serial
     */
    private JgclBsplineKnot knotData;

    /**
     * Ȑ̌`tOB
     * <p>
     * ̃tB[h́A܂̂Ƃ늈pĂ炸A
     *  JgclBsplineCurveForm.UNSPECIFIED ɂȂĂB
     * </p>
     * @serial
     * @see	JgclBsplineCurveForm
     */
    private int curveForm = JgclBsplineCurveForm.UNSPECIFIED;

    /**
     * mbg𖾎A
     * _^đȐƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints2D#JgclFreeformCurveWithControlPoints2D(JgclPoint2D[])
     * super}(controlPoints)
     * ĂяoĂB
     * </p>
     * <p>
     * knotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(degree, JgclKnotType.UNSPECIFIED, periodic, knotMultiplicities, knots, nControlPoints())
     * ĂяoĂB
     * </p>
     *
     * @param degree	Ȑ̎
     * @param periodic	`ۂ\tO
     * @param knotMultiplicities	mbgdx̔z
     * @param knots	mbgl̔z
     * @param controlPoints	_̔z
     */
    public JgclBsplineCurve2D(int degree, boolean periodic,
			      int[] knotMultiplicities, double[] knots,
			      JgclPoint2D[] controlPoints) {
	super(controlPoints);
	knotData = new JgclBsplineKnot(degree, JgclKnotType.UNSPECIFIED, periodic,
				       knotMultiplicities, knots,
				       nControlPoints());
    }

    /**
     * mbg𖾎A_^ĊJ`̑ȐƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints2D#JgclFreeformCurveWithControlPoints2D(JgclPoint2D[])
     * super}(controlPoints)
     * ĂяoĂB
     * </p>
     * <p>
     * knotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(degree, JgclKnotType.UNSPECIFIED, false, knotMultiplicities, knots, nControlPoints())
     * ĂяoĂB
     * </p>
     *
     * @param degree	Ȑ̎
     * @param knotMultiplicities	mbgdx̔z
     * @param knots	mbgl̔z
     * @param controlPoints	_̔z
     */
    public JgclBsplineCurve2D(int degree,
			      int[] knotMultiplicities, double[] knots,
			      JgclPoint2D[] controlPoints) {
	super(controlPoints);
	knotData = new JgclBsplineKnot(degree, JgclKnotType.UNSPECIFIED, false,
				       knotMultiplicities, knots,
				       nControlPoints());
    }

    /**
     * mbg𖾎A
     * _Ədݗ^ėLȐƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints2D#JgclFreeformCurveWithControlPoints2D(JgclPoint2D[], double[])
     * super}(controlPoints, weights)
     * ĂяoĂB
     * </p>
     * <p>
     * knotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(degree, JgclKnotType.UNSPECIFIED, periodic, knotMultiplicities, knots, nControlPoints())
     * ĂяoĂB
     * </p>
     *
     * @param degree	Ȑ̎
     * @param periodic	`ۂ\tO
     * @param knotMultiplicities	mbgdx̔z
     * @param knots	mbgl̔z
     * @param controlPoints	_̔z
     * @param weights	d݂̔z
     */
    public JgclBsplineCurve2D(int degree, boolean periodic,
			      int[] knotMultiplicities, double[] knots,
			      JgclPoint2D[] controlPoints, double[] weights) {
	super(controlPoints, weights);
	knotData = new JgclBsplineKnot(degree, JgclKnotType.UNSPECIFIED, periodic,
				       knotMultiplicities, knots,
				       nControlPoints());
    }

    /**
     * mbg𖾎A
     * _Ədݗ^ĊJ`̗LȐƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints2D#JgclFreeformCurveWithControlPoints2D(JgclPoint2D[], double[])
     * super}(controlPoints, weights)
     * ĂяoĂB
     * </p>
     * <p>
     * knotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(degree, JgclKnotType.UNSPECIFIED, false, knotMultiplicities, knots, nControlPoints())
     * ĂяoĂB
     * </p>
     *
     * @param degree	Ȑ̎
     * @param knotMultiplicities	mbgdx̔z
     * @param knots	mbgl̔z
     * @param controlPoints	_̔z
     * @param weights	d݂̔z
     */
    public JgclBsplineCurve2D(int degree,
			      int[] knotMultiplicities, double[] knots,
			      JgclPoint2D[] controlPoints, double[] weights) {
	super(controlPoints, weights);
	knotData = new JgclBsplineKnot(degree, JgclKnotType.UNSPECIFIED, false,
				       knotMultiplicities, knots,
				       nControlPoints());
    }

    /**
     * mbg𖾎
     * mbg̎ʂƐ_^đȐƂăIuWFNg\zB
     * <p>
     * ܂̂ƂAknotSpec Ƃ蓾l JgclKnotType.UNIFORM_KNOTS ł
     * (JgclKnotType.{QUASI_UNIFORM_KNOTS, PIECEWISE_BEZIER_KNOTS} ɂ͖Ή) B
     * </p>
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints2D#JgclFreeformCurveWithControlPoints2D(JgclPoint2D[])
     * super}(controlPoints)
     * ĂяoĂB
     * </p>
     * <p>
     * knotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(degree, knotSpec, periodic, null, null, nControlPoints())
     * ĂяoĂB
     * </p>
     *
     * @param degree	Ȑ̎
     * @param periodic	`ۂ\tO
     * @param knotSpec	mbg̎
     * @param controlPoints	_̔z
     */
    public JgclBsplineCurve2D(int degree, boolean periodic,
			      int knotSpec,
			      JgclPoint2D[] controlPoints) {
	super(controlPoints);
	knotData = new JgclBsplineKnot(degree, knotSpec, periodic, null, null,
				       nControlPoints());
    }

    /**
     * mbg𖾎
     * mbg̎ʂƐ_^ĊJȐƂăIuWFNg\zB
     * <p>
     * ܂̂ƂAknotSpec Ƃ蓾l JgclKnotType.UNIFORM_KNOTS ł
     * (JgclKnotType.{QUASI_UNIFORM_KNOTS, PIECEWISE_BEZIER_KNOTS} ɂ͖Ή) B
     * </p>
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints2D#JgclFreeformCurveWithControlPoints2D(JgclPoint2D[])
     * super}(controlPoints)
     * ĂяoĂB
     * </p>
     * <p>
     * knotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(degree, knotSpec, false, null, null, nControlPoints())
     * ĂяoĂB
     * </p>
     *
     * @param degree	Ȑ̎
     * @param knotSpec	mbg̎
     * @param controlPoints	_̔z
     */
    public JgclBsplineCurve2D(int degree,
			      int knotSpec,
			      JgclPoint2D[] controlPoints) {
	super(controlPoints);
	knotData = new JgclBsplineKnot(degree, knotSpec, false, null, null,
				       nControlPoints());
    }

    /**
     * mbg𖾎
     * mbg̎ʂƐ_񂨂яdݗ^ėLȐƂăIuWFNg\zB
     * <p>
     * ܂̂ƂAknotSpec Ƃ蓾l JgclKnotType.UNIFORM_KNOTS ł
     * (JgclKnotType.{QUASI_UNIFORM_KNOTS, PIECEWISE_BEZIER_KNOTS} ɂ͖Ή) B
     * </p>
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints2D#JgclFreeformCurveWithControlPoints2D(JgclPoint2D[], double[])
     * super}(controlPoints, weights)
     * ĂяoĂB
     * </p>
     * <p>
     * knotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(degree, knotSpec, periodic, null, null, nControlPoints())
     * ĂяoĂB
     * </p>
     *
     * @param degree	Ȑ̎
     * @param periodic	`ۂ\tO
     * @param knotSpec	mbg̎
     * @param controlPoints	_̔z
     * @param weights	d݂̔z
     */
    public JgclBsplineCurve2D(int degree, boolean periodic,
			      int knotSpec,
			      JgclPoint2D[] controlPoints, double[] weights) {
	super(controlPoints, weights);
	knotData = new JgclBsplineKnot(degree, knotSpec, periodic, null, null,
				       nControlPoints());
    }

    /**
     * mbg𖾎
     * mbg̎ʂƐ_񂨂яdݗ^ĊJ`̗LȐƂăIuWFNg\zB
     * <p>
     * ܂̂ƂAknotSpec Ƃ蓾l JgclKnotType.UNIFORM_KNOTS ł
     * (JgclKnotType.{QUASI_UNIFORM_KNOTS, PIECEWISE_BEZIER_KNOTS} ɂ͖Ή) B
     * </p>
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints2D#JgclFreeformCurveWithControlPoints2D(JgclPoint2D[], double[])
     * super}(controlPoints, weights)
     * ĂяoĂB
     * </p>
     * <p>
     * knotData ̍\zɂ́A
     * {@link JgclBsplineKnot#JgclBsplineKnot(int, int, boolean, int[], double[], int)
     * new JgclBsplineKnot}(degree, knotSpec, false, null, null, nControlPoints())
     * ĂяoĂB
     * </p>
     *
     * @param degree	Ȑ̎
     * @param knotSpec	mbg̎
     * @param controlPoints	_̔z
     * @param weights	d݂̔z
     */
    public JgclBsplineCurve2D(int degree,
			      int knotSpec,
			      JgclPoint2D[] controlPoints, double[] weights) {
	super(controlPoints, weights);
	knotData = new JgclBsplineKnot(degree, knotSpec, false, null, null,
				       nControlPoints());
    }

    /**
     * mbg JgclBsplineKnot ̃IuWFNgƂēnA
     * _ (Əd) 񎟌zŗ^
     * Ȑ (邢͗LȐ) ƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints2D#JgclFreeformCurveWithControlPoints2D(double[][])
     * super}(cpArray)
     * ĂяoĂB
     * </p>
     * <p>
     * knotData ̎_̐ cpArray ̎_̐vȂꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param knotData	mbg
     * @param cpArray	_ (яd) ̔z
     * @see	JgclInvalidArgumentValue
     */
    JgclBsplineCurve2D(JgclBsplineKnot knotData, double[][] cpArray) {
	super(cpArray);

	if (knotData.nControlPoints() != nControlPoints())
	    throw new JgclInvalidArgumentValue();

	this.knotData = knotData;
    }

    /**
     * mbg JgclBsplineKnot ̃IuWFNgƂēnA
     * _Ədݗ^
     * Ȑ (邢͗LȐ) ƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints2D#JgclFreeformCurveWithControlPoints2D(JgclPoint2D[], double[], boolean)
     * super}(controlPoints, weights, false)
     * ĂяoĂB
     * </p>
     * <p>
     * ̃RXgN^ł͈̃`FbNsȂȂ̂ŁApɂ͒ӂKvłB
     * </p>
     *
     * @param knotData	mbg
     * @param controlPoitns	_̔z
     * @param weights	d݂̔z
     */
    JgclBsplineCurve2D(JgclBsplineKnot knotData,
		       JgclPoint2D[] controlPoints,
		       double[] weights) {
	super(controlPoints, weights, false);
	this.knotData = knotData;
    }

    /**
     * _ƁAɑΉp[^l̗^āA
     * ̓_ԂJ`̑ȐƂăIuWFNg\zB
     *
     * @param points	Ԃ_
     * @param params	_̊e_ɂp[^l̗
     */
    public JgclBsplineCurve2D(JgclPoint2D[] points, double[] params) {
	super();
	JgclInterpolation2D doObj = new JgclInterpolation2D(points, params);
	this.controlPoints = doObj.controlPoints();
	this.knotData = doObj.knotData();
	this.weights = doObj.weights();	// may be null
    }

    /**
     * _ƁAɑΉp[^l̗񂨂ї[_ł̐ڃxNg^āA
     * ̓_ԂJ`̑ȐƂăIuWFNg\zB
     * <p>
     * endvecs[0] Ŏn_ł̐ڃxNgA
     * endvecs[1] ŏI_ł̐ڃxNgB
     * </p>
     *
     * @param points	Ԃ_
     * @param params	_̊e_ɂp[^l̗
     * @param endvecs	[_ł̐ڃxNg
     */
    public JgclBsplineCurve2D(JgclPoint2D[] points, double[] params, JgclVector2D[] endvecs) {
	super();
	JgclInterpolation2D doObj = new JgclInterpolation2D(points, params, endvecs);
	this.controlPoints = doObj.controlPoints();
	this.knotData = doObj.knotData();
	this.weights = doObj.weights();	// may be null
    }

    /**
     * _ƁAɑΉp[^l̗A[_ł̐ڃxNgъJ^āA
     * ̓_Ԃ鑽ȐƂăIuWFNg\zB
     * <p>
     * isClosed  true ̏ꍇA
     * (params ̗vf) = (points ̗vf + 1) ƂȂĂKvB
     * </p>
     * <p>
     * endvecs[0] Ŏn_ł̐ڃxNgA
     * endvecs[1] ŏI_ł̐ڃxNgB
     * ȂAisClosed  true ̏ꍇɂ́A̔z͎QƂȂB
     * </p>
     *
     * @param points	Ԃ_
     * @param params	_̊e_ɂp[^l̗
     * @param endvecs	[_ł̐ڃxNg
     * @param isClosed	`̋Ȑ𐶐邩ۂ̃tO
     */
    public JgclBsplineCurve2D(JgclPoint2D[] points, double[] params, JgclVector2D[] endvecs, boolean isClosed) {
	super();
	JgclInterpolation2D doObj = new JgclInterpolation2D(points, params, endvecs, isClosed);
	this.controlPoints = doObj.controlPoints();
	this.knotData = doObj.knotData();
	this.weights = doObj.weights();	// may be null
    }

    /**
     * _ƁAɑΉp[^l̗A[_ł̐ڐ̕ъJ^āA
     * ̓_ߎ鑽ȐƂăIuWFNg\zB
     * <p>
     * isClosed  true ̏ꍇA
     * (params ̗vf) = (points ̗vf + 1) ƂȂĂKvB
     * </p>
     * <p>
     * endDir[0] Ŏn_ł̐ڐA
     * endDir[1] ŏI_ł̐ڐB
     * ȂAisClosed  true ̏ꍇɂ́A̔z͎QƂȂB
     * </p>
     * <p>
     * w肳ꂽxŋߎłȂꍇɂ́A
     * ^ꂽ_ԂȐ𐶐B
     * </p>
     *
     * @param points	Ԃ_
     * @param params	_̊e_ɂp[^l̗
     * @param endDir	[_ł̐ڐ̕
     * @param isClosed	`̋Ȑ𐶐邩ۂ̃tO
     * @param tol	e_ɂߎ̐x
     * @param midTol	_̒Ԃɂߎ̐x
     */
    public JgclBsplineCurve2D(JgclPoint2D[] points, double[] params, JgclVector2D[] endDir,
			      boolean isClosed, JgclToleranceForDistance tol,
			      JgclToleranceForDistance midTol) {
	super();
	JgclApproximation2D doObj = new JgclApproximation2D(points, params, endDir, isClosed);
	JgclBsplineCurve2D bsc = doObj.getApproximationWithTolerance(tol, midTol);
	this.controlPoints = bsc.controlPoints;
	this.knotData = bsc.knotData;
	this.weights = bsc.weights;	// may be null
    }

    /**
     * ̋Ȑ̎ԂB
     * 
     * @return	
     */
    public int degree() {
	return knotData.degree();
    }

    /**
     * ̋Ȑ̃mbg̎ʂԂB
     * 
     * @return	mbg̎
     * @see	JgclKnotType
     */
    public int knotSpec() {
	return knotData.knotSpec();
    }

    /**
     * ̋Ȑ̃mbg̐ԂB
     * <p>
     * Ōumbg̐vƂ
     * knotData  knots tB[hɐݒ肳ꂽmbgl̔z̒ł͂ȂA
     * aXvC̃mbg{̃mbg̐łB
     * </p>
     *
     * @return	mbg̐
     */
    public int nKnotValues() {
	return knotData.nKnotValues();
    }

    /**
     * ̋Ȑ̃mbg n Ԃ߂̃mbglԂB
     * <p>
     * Ōun ԖځvƂ
     * knotData  knots tB[hɐݒ肳ꂽmbgl̔z̃CfbNXł͂ȂA
     * aXvC̃mbg{̈Ӗł̃CfbNXłB
     * </p>
     *
     * @param n	CfbNX
     * @return	n Ԃ߂̃mbgl
     */
    public double knotValueAt(int n) {
	return knotData.knotValueAt(n);
    }

    /**
     * ̋Ȑ̃ZOg̐ԂB
     *
     * @return	ZOg̐
     */
    int nSegments() {
	return knotData.nSegments();
    }

    /**
     * ̋Ȑ́Ap[^IɏkނĂȂLZOg̏ԂB
     *
     * @return	p[^IɏkނĂȂLZOg̏
     */
    JgclBsplineKnot.ValidSegmentInfo validSegments() {
	return knotData.validSegments();
    }

    /**
     * ̋Ȑ̃mbgԂB
     *
     * @return	mbg
     */
    JgclBsplineKnot knotData() {
	return knotData;
    }

    /**
     * ̋Ȑ̃p[^`悪IۂԂB
     * <p>
     * p[^hC𒲂ׂKvȂ̂ŃI[o[ChB
     * </p>
     * 
     * @return	Ił trueAłȂ false
     */
    public boolean isPeriodic() {
	return knotData.isPeriodic();
    }

    /**
     * ̋Ȑ n Ԗڂ̐_ԂB
     * <p>
     * `̏ꍇ̓CfbNXIɈB
     * </p>
     * 
     * @param n	CfbNX
     * @return	_
     */
    public JgclPoint2D controlPointAt(int n) {
	if (isPeriodic()) {
	    int ncp = nControlPoints();
	    while (n < 0) n += ncp;
	    while (n >= ncp) n -= ncp;
	}
	return controlPoints[n];
    }

    /**
     * ̋Ȑ̎ŵaXvC֐̑\̌W𓾂B
     *
     * @param coef	Zʂł鑽̌Wi[z
     * @param jjj	Z̑ΏۂƂmbg͈̔͂̐擪̃mbg̃CfbNX
     * @param seg	Z̑ΏۂƂZOg̊Jnp[^ƂȂmbg̃CfbNX
     * @param pTol	p[^l̋e덷
     */
    private void make_coef(double[] coef, int jjj, int seg, double pTol) {
	int degree = coef.length - 3;

	if (degree == 0)
	    coef[1] = (jjj == seg) ? 1.0 : 0.0;
	else {
	    double coef_1[] = new double[degree + 2];
	    double aaa;
	    double kj;
	    int ijk;

	    for (ijk = 0; ijk <= degree; ijk++)
		coef[ijk + 1] = 0.0;

	    coef_1[0] = coef_1[degree + 1] = 0.0;

	    if (jjj != (seg - degree)) {
		kj = knotValueAt(jjj);
		aaa = knotValueAt(jjj + degree) - kj;
		if (aaa > pTol) {
		    make_coef(coef_1, jjj, seg, pTol);
		    for (ijk = 0; ijk <= degree; ijk++)
			coef[ijk+1] += (coef_1[ijk+1] - coef_1[ijk]*kj) / aaa;
		}
	    }

	    if (jjj != seg) {
		kj = knotValueAt(jjj + degree + 1);
		aaa = kj - knotValueAt(jjj + 1);
		if (aaa > pTol) {
		    make_coef(coef_1, jjj + 1, seg, pTol);
		    for (ijk = 0; ijk <= degree; ijk++)
			coef[ijk+1] -= (coef_1[ijk+1] - coef_1[ijk]*kj) / aaa;
		}
	    }
	}
    }

    /**
     * ̋Ȑ̎w̃ZOg̑\ԂB
     * <p>
     * ʂƂēz R ̗vf́A
     * ̋ȐLł 2A
     * Lł 3 łB
     * </p>
     * <p>
     * LȐ̏ꍇA
     * R[0]  X A
     * R[1]  Y 
     * ̑\\B
     * </p>
     * <p>
     * LȐ̏ꍇA
     * R[0]  WX A
     * R[1]  WY 
     * R[2]  W 
     * ̑\\B
     * </p>
     *
     * @param iSseg	ZOg̔ԍ
     * @param isPoly	Lł邩ǂ
     * @return	̔z
     */
    public JgclRealPolynomial[] polynomial(int iSseg, boolean isPoly) {
	int degree =  degree();
	int isckt = iSseg;
	int ijk, klm, mno, pklm, i;
	double[][] cntlPnts = toDoubleArray(isPoly);
	int uicp = nControlPoints();
	int dim = cntlPnts[0].length;
	double[][] coef = new double[dim][];
	for (i = 0; i < dim; i++)
	    coef[i] = new double[degree + 1];
        double[] eA = new double[degree + 3];
	double pTol = getToleranceForParameter();
	JgclRealPolynomial[] polynomial = new JgclRealPolynomial[dim];

	for (i = 0; i < dim; i++)
	    for (ijk = 0; ijk <= degree; ijk++)
		coef[i][ijk] = 0.0;

	for (ijk = 0, pklm = klm = isckt; ijk <= degree; ijk++, pklm++, klm++){
	    make_coef(eA, klm, (isckt + degree), pTol);

	    if ((isPeriodic()) && (pklm == uicp))
		pklm = 0;
	    for (i = 0; i < dim; i++) {
		for (mno = 0; mno <= degree; mno++)
		    coef[i][degree - mno] += eA[mno+1] * cntlPnts[pklm][i];
	    }
	}

	for (i = 0; i < dim; i++)
	    polynomial[i] = new JgclRealPolynomial(coef[i]);

	return polynomial;
    }

    /**
     * ^ꂽp[^Ԃɂ邱̋Ȑ̎ԏł̒ (̂) ԂB
     * <p>
     * pint ̑l͕ł܂ȂB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ̋Ȑ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param pint	Ȑ̒߂p[^
     * @return	w肳ꂽp[^ԂɂȐ̒
     * @see	JgclParameterOutOfRange
     */
    public double length(JgclParameterSection pint) {
        double length = 0.0;
        JgclRealFunctionWithOneVariable realFunction;
        double dTol = getToleranceForDistance() / 2.0;
	double pTol = getToleranceForParameter();

        if (!isPolynomial() || Math.abs(pint.increase()) <= pTol) {
            realFunction
                = new JgclRealFunctionWithOneVariable() {
                        public double evaluate(double parameter) {
                            return tangentVector(parameter).length();
                        }
                    };
            length = JgclMath.getDefiniteIntegral(realFunction, pint, dTol);
        }
        else {
	    JgclBsplineCurve2D tbsc = truncate(pint);
            JgclBsplineKnot.ValidSegmentInfo vsegInfo
                = tbsc.knotData.validSegments();
            int nvseg = vsegInfo.nSegments();

            for (int ijk = 0; ijk < nvseg; ijk++) {
                JgclRealPolynomial[] poly =
                    tbsc.polynomial(ijk, isPolynomial());
                final JgclRealPolynomial[] deriv =
                    new JgclRealPolynomial[poly.length];

                for (int klm = 0; klm < poly.length; klm++)
                    deriv[klm] = poly[klm].derive();

                realFunction
                    = new JgclRealFunctionWithOneVariable() {
                            public double evaluate(double parameter) {
                                final double[] tang = new double[2];
                                for (int klm = 0; klm < 2; klm++)
                                    tang[klm] = deriv[klm].evaluate(parameter);

                                return Math.sqrt(tang[0] * tang[0] +
                                                 tang[1] * tang[1]);
                            }
                        };
                JgclParameterSection psec =
                    new JgclParameterSection(vsegInfo.knotPoint(ijk)[0],
                                             vsegInfo.knotPoint(ijk)[1]);
                length += JgclMath.getDefiniteIntegral(realFunction,
                                                       psec, dTol);
            }
        }
        return length;
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		Wl
     * @see	JgclParameterOutOfRange
     */
    public JgclPoint2D coordinates(double param)
    {
	double[][] cntlPnts;
	double[] d0D;
	boolean isPoly = isPolynomial();

	param = checkParameter(param);
	cntlPnts = toDoubleArray(isPoly);
	d0D = JgclBsplineCurveEvaluation.coordinates(knotData, cntlPnts, param);
	if (!isPoly) {
	    convRational0Deriv(d0D);
	}
	return new JgclCartesianPoint2D(d0D[0], d0D[1]);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		ڃxNg
     * @see	JgclParameterOutOfRange
     */
    public JgclVector2D tangentVector(double param)
    {
	double[][] cntlPnts;
	double[] d1D = new double[3];
	boolean isPoly = isPolynomial();

	param = checkParameter(param);
	cntlPnts = toDoubleArray(isPoly);
	if (isPoly) {
	    JgclBsplineCurveEvaluation.evaluation(knotData, cntlPnts, param,
						  null, d1D, null, null);
	} else {
	    double[] d0D = new double[3];

	    JgclBsplineCurveEvaluation.evaluation(knotData, cntlPnts, param,
						  d0D, d1D, null, null);
	    convRational1Deriv(d0D, d1D);
	}
	return new JgclLiteralVector2D(d1D[0], d1D[1]);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		ȗ
     * @see	JgclParameterOutOfRange
     */
    public JgclCurveCurvature2D curvature(double param)
    {
	int degree;
	JgclCurveDerivative2D deriv;
	boolean tang0;
	double tang_leng;
	double dDcrv;
	JgclVector2D dDnrm;
	JgclCurveCurvature2D crv;
	JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
	double tol_d = condition.getToleranceForDistance();

	degree = degree();
	deriv = evaluation(param);

	tang_leng = deriv.d1D().norm();
	if (tang_leng < (tol_d * tol_d)) {
	    tang0 = true;
	} else {
	    tang0 = false;
	}

	if ((degree < 2) || (tang0 == true)) {
	    dDcrv = 0.0;
	    dDnrm = JgclVector2D.zeroVector;
	} else {
	    double ewvec;

	    tang_leng = Math.sqrt(tang_leng);
	    dDcrv = tang_leng * tang_leng * tang_leng;

	    ewvec = deriv.d1D().zOfCrossProduct(deriv.d2D());
	    dDcrv = Math.abs(ewvec) / dDcrv;

	    if (ewvec < 0.0) {
		dDnrm = new JgclLiteralVector2D(deriv.d1D().y(), (- deriv.d1D().x()));
	    } else {
		dDnrm = new JgclLiteralVector2D((- deriv.d1D().y()), deriv.d1D().x());
	    }

	    dDnrm = dDnrm.unitized();
	}

	return new JgclCurveCurvature2D(dDcrv, dDnrm);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		֐
     * @see	JgclParameterOutOfRange
     */
    public JgclCurveDerivative2D evaluation(double param)
    {
	double[][] cntlPnts;
	double[] ld0D = new double[3];
	double[] ld1D = new double[3];
	double[] ld2D = new double[3];
	JgclPoint2D d0D;
	JgclVector2D d1D;
	JgclVector2D d2D;
	boolean isPoly = isPolynomial();

	param = checkParameter(param);
	cntlPnts = toDoubleArray(isPoly);
	JgclBsplineCurveEvaluation.evaluation(knotData, cntlPnts, param,
					      ld0D, ld1D, ld2D, null);
	if (!isPoly) {
	    convRational2Deriv(ld0D, ld1D, ld2D);
	}
	d0D = new JgclCartesianPoint2D(ld0D[0], ld0D[1]);
	d1D = new JgclLiteralVector2D(ld1D[0], ld1D[1]);
	d2D = new JgclLiteralVector2D(ld2D[0], ld2D[1]);
	return new JgclCurveDerivative2D(d0D, d1D, d2D);
    }

    /**
     * ̋Ȑ́A^ꂽp[^ɑ΂ubT~ǑʂԂB
     * <p>
     * parameters ̗vf́A̋Ȑ̎ɈvĂKvB
     * </p>     
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param segNumber	ZΏۂƂȂZOg̔ԍ (擪 0)
     * @param parameters	p[^l̔z
     * @return	ubT~ǑʂłWl
     * @see	JgclParameterOutOfRange
     */
    public JgclPoint2D blossoming(int segNumber,
				  double[] parameters)
    {
	double[] adjustedParameters = new double[this.degree()];
	for (int i = 0; i < this.degree(); i++)
	    adjustedParameters[i] = this.checkParameter(parameters[i]);
	boolean isPoly = this.isPolynomial();

	double[] d0D =
	    JgclBsplineCurveEvaluation.blossoming(knotData,
						  toDoubleArray(isPoly),
						  segNumber,
						  adjustedParameters);

	if (isPoly != true)
	    this.convRational0Deriv(d0D);

	if (isPoly == true)
	    return new JgclCartesianPoint2D(d0D[0], d0D[1]);
	else
	    return new JgclHomogeneousPoint2D(d0D[0], d0D[1], d0D[2]);
    }

    /**
     * ̋Ȑ̒[_ٓ_Aϋȓ_̉ƂȂ邩ǂ𒲂ׂB
     *
     * @param minParam	ZOg̎n_̃p[^l
     * @param maxParam	ZOg̏I_̃p[^l
     * @param minDegree	
     * @param seg	ZOg̃CfbNX
     * @param nvseg	LȃZOg̐
     * @param paramVec	ێ郊Xg
     */
    private void checkEndPoint(double minParam,
			       double maxParam,
			       int minDegree,
			       int seg,
			       int nvseg,
			       Vector paramVec) {
	int mno;
	if (degree() < minDegree) {
	    if (isClosed() && (paramVec.size() == 0)) {
		paramVec.addElement(new Double(minParam));
	    }
	    if (seg != (nvseg - 1)) {
		for (mno = 0; mno < paramVec.size(); mno++)
		    if (identicalParameter(((Double)paramVec.elementAt(mno)).doubleValue(),
					   maxParam))
			break;
		if (mno == paramVec.size())
		    paramVec.addElement(new Double(maxParam));
	    }
	}
    }

    /**
     * ̋Ȑ̓ٓ_ԂB
     * <p>
     * ٓ_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @return		ٓ_̔z
     */
    public JgclPointOnCurve2D[] singular() {
        JgclBsplineKnot.ValidSegmentInfo vsegInfo = knotData.validSegments();
        int nvseg = vsegInfo.nSegments();
        int numseg = nSegments();
        JgclPureBezierCurve2D[] bzcs = toPureBezierCurveArray();
        int minDegree = 2;
        int ijk, klm, mno;
        Vector snglrParam = new Vector();

        for (ijk = 0; ijk < numseg; ijk++) {
	    double minParam;
	    double maxParam;
            if ((klm = vsegInfo.isValidSegment(ijk)) < 0) {
                // kޏi[BkދԂ̃p[^𓾂B
  		minParam = knotValueAt(degree() + ijk);
  		maxParam = knotValueAt(degree() + ijk + 1);
		checkEndPoint(minParam, maxParam, minDegree, ijk, nvseg, snglrParam);
		continue;
            }

	    // ZOg̗[_ɉ邩ǂ̌
            minParam = vsegInfo.knotPoint(klm)[0];
            maxParam = vsegInfo.knotPoint(klm)[1];
	    checkEndPoint(minParam, maxParam, minDegree, klm, nvseg, snglrParam);

	    // ZOgɉ邩ׂ
            JgclPointOnCurve2D[] singularOnBzc;
            try {
                singularOnBzc = bzcs[klm].singular();
            }
            catch (JgclIndefiniteSolution e) {
		// BezierCurve ŜkނĂꍇB
		// BezierCurve ̗[_̃p[^߉ɉB(łɉɉĂH)
		continue;
            }

	    // ̈Ӑ𒲂ׂB
            for (klm = 0; klm < singularOnBzc.length; klm++) {
                double candidateParam = (maxParam - minParam) *
                    singularOnBzc[klm].parameter() + minParam;
                for (mno = 0; mno < snglrParam.size(); mno++) {
                    if (identicalParameter(((Double)snglrParam.elementAt(mno)).
                                           doubleValue(), candidateParam))
                        break;
                }
                if (mno == snglrParam.size())
                    snglrParam.addElement(new Double(candidateParam));
            }
        }
        
        int numberOfSolution = snglrParam.size();
        JgclPointOnCurve2D[] singular =
            new JgclPointOnCurve2D[numberOfSolution];
        for (ijk = 0; ijk < numberOfSolution; ijk++) {
            singular[ijk] =
		new JgclPointOnCurve2D(this,
				       ((Double)snglrParam.elementAt(ijk)).doubleValue(),
				       false);
        }
        return singular;
    }

    /**
     * ̋Ȑ̕ϋȓ_ԂB
     * <p>
     * ϋȓ_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @return	ϋȓ_̔z
     */
    public JgclPointOnCurve2D[] inflexion() {
        JgclBsplineKnot.ValidSegmentInfo vsegInfo = knotData.validSegments();
        int nvseg = vsegInfo.nSegments();
        int numseg = nSegments();
        JgclPureBezierCurve2D[] bzcs = toPureBezierCurveArray();
        int minDegree = 3;
        int ijk, klm, mno;
        Vector inflxParam = new Vector();

        for (ijk = 0; ijk < numseg; ijk++) {
	    double minParam;
	    double maxParam;
            if ((klm = vsegInfo.isValidSegment(ijk)) < 0) {
		// k or ȗ 0 Ԃ̃p[^𓾂B
  		minParam = knotValueAt(degree() + ijk);
  		maxParam = knotValueAt(degree() + ijk + 1);
		checkEndPoint(minParam, maxParam, minDegree, ijk, nvseg, inflxParam);
		continue;
            }

	    // ZOg̗[_ɉ邩ǂ̌
            minParam = vsegInfo.knotPoint(klm)[0];
            maxParam = vsegInfo.knotPoint(klm)[1];
	    checkEndPoint(minParam, maxParam, minDegree, klm, nvseg, inflxParam);

	    // ZOgɉ邩ׂ
            JgclPointOnCurve2D[] inflexionOnBzc;
            try {
                inflexionOnBzc = bzcs[klm].inflexion();
            }
            catch (JgclIndefiniteSolution e) {
		// BezierCurve Ŝ ȗ 0 Ԃ̏ꍇ
		// BezierCurve ̗[_̃p[^߉ɉB(łɉĂ?)
		continue;
            }

	    // ̈Ӑ𒲂ׂB
            for (klm = 0; klm < inflexionOnBzc.length; klm++) {
                double candidateParam = (maxParam - minParam) *
                    inflexionOnBzc[klm].parameter() + minParam;
                for (mno = 0; mno < inflxParam.size(); mno++) {
                    if (identicalParameter(((Double)inflxParam.elementAt(mno)).
                                           doubleValue(), candidateParam))
                        break;
                }
                if (mno == inflxParam.size())
                    inflxParam.addElement(new Double(candidateParam));
            }
        }
        
        int numberOfSolution = inflxParam.size();
        JgclPointOnCurve2D[] inflexion =
            new JgclPointOnCurve2D[numberOfSolution];
        for (ijk = 0; ijk < numberOfSolution; ijk++) {
            inflexion[ijk] = new JgclPointOnCurve2D
                (this, ((Double)inflxParam.elementAt(ijk)).
                 doubleValue(), false);
        }
        return inflexion;
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * e_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * Ȑ̂_ P(t) ^ꂽ_֌xNg
     * P(t) ɂڃxNg P'(t) ̓ς\ D(t) 𐶐A
     * ӂƂ㐔 D(t) = 0 ĂB
     * </p>
     * 
     * @param point	e̓_
     * @return	e_̔z
     */
    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D mate) {
	int dimension = 2;
	int ijk, klm, mno, i;	// loop counter
	int coef_size = isPolynomial() ? dimension : dimension+1;
	JgclRealPolynomial work0, work1, work2, sub;
	double[] work3;
	JgclRealPolynomial[] pointPoly;
	JgclRealPolynomial[] offsPoly = new JgclRealPolynomial[dimension];
	JgclRealPolynomial[] tangPoly = new JgclRealPolynomial[coef_size];
	JgclRealPolynomial[] dotePoly = new JgclRealPolynomial[dimension];
	
        JgclBsplineKnot.ValidSegmentInfo vsegInfo = knotData.validSegments();
	JgclPointOnCurve2D proj;
	JgclPointOnGeometryList projList = new JgclPointOnGeometryList();
	double dTol = getToleranceForDistance();
	JgclComplexPolynomial dtPoly;
	JgclComplex[] root;
	double[] intv;
	JgclParameterDomain domain;
	double par;
	
	for (ijk = 0; ijk < vsegInfo.nSegments(); ijk++) {
	    pointPoly = polynomial(vsegInfo.segmentNumber(ijk), isPolynomial());
	    if (isRational()) {
		offsPoly[0] = pointPoly[dimension].multiply(mate.x());
		offsPoly[1] = pointPoly[dimension].multiply(mate.y());
	    }
	    else {
		double coef[][] = {{ mate.x() }, { mate.y() }};
		offsPoly[0] = new JgclRealPolynomial(coef[0]);
		offsPoly[1] = new JgclRealPolynomial(coef[1]);
	    }

	    for (i = 0; i < dimension; i++)
		pointPoly[i] = pointPoly[i].subtract(offsPoly[i]);

	    // polynomial of tangent vector
	    for (klm = 0; klm < coef_size; klm++)
		tangPoly[klm] = pointPoly[klm].derive();
	    
	    /*
	     * polynomial for position --> for difference with point A
	     * polynomial for dot product
	     */
	    if (!isRational()) {
		for (klm = 0; klm < dimension; klm++)
		    dotePoly[klm] = pointPoly[klm].multiply(tangPoly[klm]);
	    } else {
		for (klm = 0; klm < 2; klm++) {
		    work0 = pointPoly[2].multiply(tangPoly[klm]);
		    work1 = tangPoly[2].multiply(pointPoly[klm]);
		    // ((a * t^n) * (nb * t^(n-1))) - ((na * t^(n-1)) * (b * t^n)) == 0
		    work2 = work0.subtract(work1);
		    work3 = work2.coefficientsBetween(0, (work2.degree() - 1));
		    sub = new JgclRealPolynomial(work3);
		    dotePoly[klm] = pointPoly[klm].multiply(sub);
		}
	    }

	    try {
		dtPoly = dotePoly[0].add(dotePoly[1]).toComplexPolynomial();
	    }
	    catch(JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }

	    try {
		root = dtPoly.getRootsByDKA();
	    }
	    catch (JgclComplexPolynomial.DKANotConverge e) {
		root = e.getValues();
	    }
	    catch (JgclComplexPolynomial.ImpossibleEquation e) {
		throw new JgclFatal();
	    }
	    catch (JgclComplexPolynomial.IndefiniteEquation e) {
		throw new JgclFatal();
	    }
	    
	    // extract proper roots
	    intv = vsegInfo.knotPoint(ijk);
	    domain = new JgclParameterDomain(false, intv[0], intv[1]-intv[0]);

	    for (mno = 0; mno < root.length; mno++) {
		par = root[mno].real();
		if (!domain.isValid(par))
		    continue;
		par = domain.force(par);
		proj = checkProjection(par, mate, dTol*dTol);
		if (proj != null)
		    projList.addPoint(proj);
	    }
	}

	return projList.toJgclPointOnCurve2DArray();
    }

    /**
     * ̗LȐŜɍČL Bspline ȐԂB
     * 
     * @return	̋ȐŜČL Bspline Ȑ
     */
    public JgclBsplineCurve2D toBsplineCurve() {
	if (this.isRational() == true)
	    return this;

	return new JgclBsplineCurve2D(this.knotData,
				      this.controlPoints,
				      this.makeUniformWeights());
    }

    /**
     * ̋Ȑ̎w̋ԂɍČL Bspline ȐԂB
     * <p>
     * pint ̒lÂaXvCȐ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param pint	L Bspline ȐōČp[^
     * @return		̋Ȑ̎w̋ԂČL Bspline Ȑ
     * @see	JgclParameterOutOfRange
     */
    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
	JgclBsplineCurve2D target;
	if (this.isPeriodic() == true) {
	    if (pint.absIncrease() >= this.parameterDomain().section().absIncrease()) {
		target = this;
		try {
		    target = target.shiftIfPeriodic(pint.start());
		} catch (JgclOpenCurve e) {
		    ;	// N蓾Ȃ͂
		}
		if (pint.increase() < 0.0)
		    target = target.reverse();
	    } else {
		target = this.truncate(pint);
	    }
	} else {
	    target = this.truncate(pint);
	}
	return target.toBsplineCurve();
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     */
    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate) {
	return mate.intersect(this, true);
    }

    /**
     * ̂aXvCȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * aXvCƒ̌_\㐔ɋAĉĂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
	JgclBsplineKnot.ValidSegmentInfo vsegInfo = knotData.validSegments();
	JgclAxis2Placement2D placement =
	    new JgclAxis2Placement2D(mate.pnt(), mate.dir());
	JgclCartesianTransformationOperator2D transform =
	    new JgclCartesianTransformationOperator2D(placement, 1.0);
	int uicp = nControlPoints();
	JgclPoint2D[] newCp = new JgclPoint2D[uicp];

	for (int i = 0; i < uicp; i++)
	    newCp[i] = transform.toLocal(controlPointAt(i));

	double[] weights = weights();
	if (isRational()) {
	    double max_weight = 0.0;
	    for (int i = 0; i < uicp; i++)
		if (Math.abs(weights[i]) > max_weight)
		    max_weight = weights[i];
	    
	    if (max_weight > 0.0)
		for (int i = 0; i < uicp; i++) {
		    weights[i] /= max_weight;
		}
	}

	// ̐_(newCp)Bspline
	JgclBsplineCurve2D bsc = new
	    JgclBsplineCurve2D(knotData, newCp, weights);
	
	Vector lineParam = new Vector();
	Vector bscParam = new Vector();
	int nSeg = vsegInfo.nSegments();
	int k = 0;
	for (int i = 0; i < nSeg; i++) {
	    JgclRealPolynomial[] realPoly =
		bsc.polynomial(vsegInfo.segmentNumber(i), isPolynomial());
	    JgclComplexPolynomial compPoly =
		realPoly[1].toComplexPolynomial();
			
	    JgclComplex[] roots;
	    try {
		roots = compPoly.getRootsByDKA();
	    }
	    catch (JgclComplexPolynomial.DKANotConverge e) {
		roots = e.getValues();
	    }
	    catch (JgclComplexPolynomial.ImpossibleEquation e) {
		throw new JgclFatal();
	    }
	    catch (JgclComplexPolynomial.IndefiniteEquation e) {
		throw new JgclFatal();
	    }

	    int nRoots = roots.length;
	    
	    // set new ParameterDomain

	    // ̃`FbN
	    for (int j = 0; j < nRoots; j++) {
		double realRoot = roots[j].real();
		if (bsc.parameterValidity(realRoot) ==
		    JgclParameterValidity.OUTSIDE)
		    continue;

		double[] knotParams = vsegInfo.knotPoint(i);
		if (realRoot < knotParams[0]) realRoot = knotParams[0];
		if (realRoot > knotParams[1]) realRoot = knotParams[1];
		
		JgclPoint2D workPoint = bsc.coordinates(realRoot);
		double dTol = bsc.getToleranceForDistance();
		int jj;
		if (Math.abs(workPoint.y()) < dTol) {
		    for (jj = 0; jj < k; jj++) {
			double paramA = ((Double)lineParam.elementAt(jj)).doubleValue();
			double paramB = ((Double)bscParam.elementAt(jj)).doubleValue();
			if ((Math.abs(paramA - workPoint.x()) < dTol)
			    && (bsc.identicalParameter(paramA, paramB)))
			    break;
		    }
		    if (jj >= k) {
			lineParam.addElement(new Double(workPoint.x()));
			bscParam.addElement(new Double(realRoot));
			k++;
		    }
		}
	    }
	}

	int num = bscParam.size();
	JgclIntersectionPoint2D[] intersectPoint = new
	    JgclIntersectionPoint2D[num];
	double mateLength = mate.dir().length();
	for (int i = 0; i < k; i++) {
	    double work = ((Double)lineParam.elementAt(i)).doubleValue() / mateLength;
	    JgclPointOnCurve2D pointOnLine = new
		JgclPointOnCurve2D(mate, work, doCheckDebug);

	    work = ((Double)bscParam.elementAt(i)).doubleValue();
	    JgclPointOnCurve2D pointOnBsc = new
		JgclPointOnCurve2D(this, work, doCheckDebug);
	    
	    JgclPoint2D coordinates = coordinates(work);
	    
	    if (!doExchange)
		intersectPoint[i] = new JgclIntersectionPoint2D
		    (coordinates, pointOnBsc, pointOnLine, doCheckDebug);
	    else
		intersectPoint[i] = new JgclIntersectionPoint2D
		    (coordinates, pointOnLine, pointOnBsc, doCheckDebug);
	}

	return intersectPoint;
    }

    /**
     * ̂aXvCȐƑ̋Ȑ (~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ~̃NX́u~ vs. aXvCȐv̌_Z\bh
     * {@link JgclCircle2D#intersect(JgclBsplineCurve2D, boolean)
     * JgclCircle2D.intersect(JgclBsplineCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclCircle2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̂aXvCȐƑ̋Ȑ (ȉ~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȉ~̃NX́uȉ~ vs. aXvCȐv̌_Z\bh
     * {@link JgclEllipse2D#intersect(JgclBsplineCurve2D, boolean)
     * JgclEllipse2D.intersect(JgclBsplineCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (ȉ~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclEllipse2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̂aXvCȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ̃NX́u vs. aXvCȐv̌_Z\bh
     * {@link JgclParabola2D#intersect(JgclBsplineCurve2D, boolean)
     * JgclParabola2D.intersect(JgclBsplineCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclParabola2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̂aXvCȐƑ̋Ȑ (oȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * oȐ̃NX́uoȐ vs. aXvCȐv̌_Z\bh
     * {@link JgclHyperbola2D#intersect(JgclBsplineCurve2D, boolean)
     * JgclHyperbola2D.intersect(JgclBsplineCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (oȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̂aXvCȐƑ̋Ȑ (|C) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * |C̃NX́u|C vs. aXvCȐv̌_Z\bh
     * {@link JgclPolyline2D#intersect(JgclBsplineCurve2D, boolean)
     * JgclPolyline2D.intersect(JgclBsplineCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (|C)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̂aXvCȐƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsBzcBsc2D#intersection(JgclPureBezierCurve2D, JgclBsplineCurve2D, boolean)
     * JgclIntsBzcBsc2D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclPureBezierCurve2D mate, boolean doExchange) {
	return JgclIntsBzcBsc2D.intersection(mate, this, !doExchange);
    }

    /**
     * ̂aXvCȐƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsBscBsc2D#intersection(JgclBsplineCurve2D, JgclBsplineCurve2D, boolean)
     * JgclIntsBscBsc2D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclBsplineCurve2D mate, boolean doExchange) {
	return JgclIntsBscBsc2D.intersection(this, mate, doExchange);
    }

    /**
     * ̂aXvCȐƑ̋Ȑ (gȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * gȐ̃NX́ugȐ vs. aXvCȐv̌_Z\bh
     * {@link JgclTrimmedCurve2D#intersect(JgclBsplineCurve2D, boolean)
     * JgclTrimmedCurve2D.intersect(JgclBsplineCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (gȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̂aXvCȐƑ̋Ȑ (ȐZOg) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐZOg̃NX́uȐZOg vs. aXvCȐv̌_Z\bh
     * {@link JgclCompositeCurveSegment2D#intersect(JgclBsplineCurve2D, boolean)
     * JgclCompositeCurveSegment2D.intersect(JgclBsplineCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (ȐZOg)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̂aXvCȐƑ̋Ȑ (Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * Ȑ̃NX́uȐ vs. aXvCȐv̌_Z\bh
     * {@link JgclCompositeCurve2D#intersect(JgclBsplineCurve2D, boolean)
     * JgclCompositeCurve2D.intersect(JgclBsplineCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (Ȑ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LEȐ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		Ȑ̊̔z
     */
    public JgclCurveCurveInterference2D[] interfere(JgclBoundedCurve2D mate) {
	return mate.interfere(this, true);
    }

    /**
     * ̗LȐƑ̗LȐ () ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ̃NX́u vs. aXvCȐv̊Z\bh
     * {@link JgclBoundedLine2D#interfere(JgclBsplineCurve2D, boolean)
     * JgclBoundedLine2D.interfere(JgclBsplineCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ ()
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclBoundedLine2D mate,
					     boolean doExchange)
    {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (|C) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * |C̃NX́u|C vs. aXvCȐv̊Z\bh
     * {@link JgclPolyline2D#interfere(JgclBsplineCurve2D, boolean)
     * JgclPolyline2D.interfere(JgclBsplineCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (|C)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclPolyline2D mate,
					     boolean doExchange)
    {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (xWGȐ) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsBzcBsc2D#interference(JgclPureBezierCurve2D, JgclBsplineCurve2D, boolean)
     * JgclIntsBzcBsc2D.interference}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (xWGȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclPureBezierCurve2D mate,
					     boolean doExchange)
    {
	return JgclIntsBzcBsc2D.interference(mate, this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (aXvCȐ) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsBscBsc2D#interference(JgclBsplineCurve2D, JgclBsplineCurve2D, boolean)
     * JgclIntsBscBsc2D.interference}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (aXvCȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclBsplineCurve2D mate,
					     boolean doExchange)
    {
	return JgclIntsBscBsc2D.interference(this, mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (gȐ) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * gȐ̃NX́ugȐ vs. aXvCȐv̊Z\bh
     * {@link JgclTrimmedCurve2D#interfere(JgclBsplineCurve2D, boolean)
     * JgclTrimmedCurve2D.interfere(JgclBsplineCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (gȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclTrimmedCurve2D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (ȐZOg) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐZOg̃NX́uȐZOg vs. aXvCȐv̊Z\bh
     * {@link JgclCompositeCurveSegment2D#interfere(JgclBsplineCurve2D, boolean)
     * JgclCompositeCurveSegment2D.interfere(JgclBsplineCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (ȐZOg)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurveSegment2D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (Ȑ) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * Ȑ̃NX́uȐ vs. aXvCȐv̊Z\bh
     * {@link JgclCompositeCurve2D#interfere(JgclBsplineCurve2D, boolean)
     * JgclCompositeCurve2D.interfere(JgclBsplineCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (Ȑ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurve2D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎ Bspline Ȑ߂B
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎ Bspline Ȑ
     * @see	JgclWhichSide
     */
    public JgclBsplineCurve2D
	offsetByBsplineCurve(JgclParameterSection pint,
			     double magni,
                             int side,
			     JgclToleranceForDistance tol) {
	JgclOfst2D doObj = new JgclOfst2D(this,pint,magni,side,tol);
	return doObj.offset();
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʐڐ߂B
     * <p>
     * ʐڐ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     *
     * @param mate	̋Ȑ
     * @return		ʐڐ̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʖ@߂B
     * <p>
     * ʖ@݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		ʖ@̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonNormal2D[]	commonNormal(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ́Aw̃p[^l̈ʒuɐVȃmbg}ȐԂB
     * <p>
     * `͂̋Ȑ̂܂܂ŁAZOgaXvCȐԂB
     * </p>
     *
     * @param param	mbg}p[^l
     * @return	mbg}̂aXvCȐ
     */
    public JgclBsplineCurve2D insertKnot(double param) {
	double[][] cntlPnts;
	boolean isPoly = isPolynomial();
	Object[] result;
	JgclBsplineKnot newKnotData;
	double[][] newControlPoints;
	JgclBsplineCurve2D bsc;

	param = checkParameter(param);
	cntlPnts = toDoubleArray(isPoly);
	result = JgclBsplineCurveEvaluation.insertKnot(knotData, cntlPnts, param);
	newKnotData = (JgclBsplineKnot)result[0];
	newControlPoints = (double[][])result[1];
	return new JgclBsplineCurve2D(newKnotData, newControlPoints);
    }

    /**
     * ̂aXvCȐA^ꂽp[^lŕB
     * <p>
     * ̋ȐJ`̏ꍇɂ́A
     * param ɑΉ_őO{ɕB
     * ʂƂēz̗vf 2 ŁA
     * ŏ̗vfɁun_番_܂ł\aXvCȐ AvA
     * Ԗڂ̗vfɁu_I_܂ł\aXvCȐ Bv
     * B
     * ̋Ȑ̃p[^` [start, end] ƂƁA
     * A ̃p[^` [start, param]A
     * B ̃p[^` [0, (end - param)] ɂȂB
     * </p>
     * <p>
     * ̋Ȑ`̏ꍇɂ́A
     * param ɑΉ_𗼒[ƂJ`
     * {̂aXvCȐ C ɕϊB
     * ʂƂēz̗vf 1 łB
     * ̋Ȑ̃p[^` [start, end] ƂƁA
     * C ̃p[^` [0, (end - start)] ɂȂB
     * </p>
     * <p>
     * param ̒lÂaXvCȐ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param param	p[^l
     * @return	̂aXvCȐ܂ޔz
     * @see	JgclParameterOutOfRange
     */
    public JgclBsplineCurve2D[] divide(double param)
    {
	double[][] cntlPnts;
	boolean isPoly = isPolynomial();
	JgclBsplineKnot[] newKnotData = new JgclBsplineKnot[2];
	double[][][] newControlPoints = new double[2][][];
	int n_bsc;
	JgclBsplineCurve2D[] bsc;

	param = checkParameter(param);
	cntlPnts = toDoubleArray(isPoly);
	JgclBsplineCurveEvaluation.divide(knotData, cntlPnts, param,
					  newKnotData, newControlPoints);
	if (newKnotData[0] == null)
	    throw new JgclFatal();
	else if (newKnotData[1] == null)
	    n_bsc = 1;
	else
	    n_bsc = 2;

	bsc = new JgclBsplineCurve2D[n_bsc];

	for (int i = 0; i < n_bsc; i++) {
	    try {
		bsc[i] = new JgclBsplineCurve2D(newKnotData[i], newControlPoints[i]);
	    } catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}

	return bsc;
    }

    /**
     * ̂aXvCȐA^ꂽp[^ԂŐؒfB
     * <p>
     * section ̑l̏ꍇɂ́Ais]aXvCȐԂB
     * </p>
     * <p>
     * section ̒lÂaXvCȐ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * <p>
     * ؒf̋Ȑ̃p[^` [0, section.absIncrease()] ɂȂB
     * </p>
     *
     * @param section	ؒfĎc\p[^
     * @return	ؒfĎc\aXvCȐ
     * @see	JgclParameterOutOfRange
     */
    public JgclBsplineCurve2D truncate(JgclParameterSection section)
    {
	// sKnot𐶐Ă܂߃G[ƂB
	if (Math.abs(section.increase()) <= getToleranceForParameter())
	    throw new JgclInvalidArgumentValue();

	double start_par, end_par;
	JgclBsplineCurve2D t_bsc;

	if (isNonPeriodic()) {	// open curve
	    start_par = checkParameter(section.lower());
	    end_par = checkParameter(section.upper());

	    t_bsc = divide(start_par)[1];
	    t_bsc = t_bsc.divide(end_par - start_par)[0];
	} else {		// closed curve
	    double crv_intvl = parameterDomain().section().increase();
	    double tol_p = JgclConditionOfOperation.getCondition().getToleranceForParameter();

	    start_par = checkParameter(section.start());
	    t_bsc = divide(start_par)[0];
	    if (Math.abs(section.increase()) < crv_intvl - tol_p) {
		if (section.increase() > 0.0) {
		    end_par = section.increase();
		    t_bsc = t_bsc.divide(end_par)[0];
		} else {
		    end_par = crv_intvl + section.increase();
		    t_bsc = t_bsc.divide(end_par)[1];
		}
	    }
	}

	if (section.increase() < 0.0)
	    t_bsc = t_bsc.reverse();

	return t_bsc;
    }

    /**
     * ́u`v̂aXvCȐ̌`ςɁA
     * ^ꂽp[^lɑΉ_Jn_Ƃ悤
     * ϊ̂ԂB
     * <p>
     * ʂƂēaXvCȐ̊Jn_̃p[^l͏ 0 ɂȂB
     * </p>
     *
     * @param	newStartParam	Jn_ƂȂp[^l
     * @return	^ꂽp[^lɑΉ_Jn_ƂaXvCȐ
     * @exception JgclOpenCurve	̋Ȑ͊J`ł
     */
    public JgclBsplineCurve2D shiftIfPeriodic(double newStartParam)
	 throws JgclOpenCurve
    {
	if (this.isPeriodic() != true)
	    throw new JgclOpenCurve();

	newStartParam = this.parameterDomain().wrap(newStartParam);

	// 擪ɂȂZOg̔ԍ𓾂
	int newFirstSegment =
	    this.knotData().getSegmentNumberThatStartIsEqualTo(newStartParam);

	if (newFirstSegment == (- 1))
	    return this.insertKnot(newStartParam).shiftIfPeriodic(newStartParam);

	// mbgf[^̐
	JgclBsplineKnot newKnotData = this.knotData().shift(newFirstSegment);

	// _̐
	int nNewControlPoints = newKnotData.nControlPoints();
	JgclPoint2D[] newControlPoints = new JgclPoint2D[nNewControlPoints];

	for (int i = 0; i < nNewControlPoints; i++)
	    newControlPoints[i] =
		this.controlPointAt((i + newFirstSegment) % nNewControlPoints);

	// dݗ̐
	double[] newWeights = null;
	if (this.isRational() == true) {
	    newWeights = new double[nNewControlPoints];

	    for (int i = 0; i < nNewControlPoints; i++)
		newWeights[i] =
		    this.weightAt((i + newFirstSegment) % nNewControlPoints);
	}

	return new JgclBsplineCurve2D(newKnotData, newControlPoints, newWeights);
    }

    /**
     * ̋Ȑ̎w̋ԂA^ꂽ덷Œߎ|CԂB
     * <p>
     * ʂƂĕԂ|C\_
     * ̋Ȑx[XȐƂ JgclPointOnCurve2D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * section ̒lÃxWGȐ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param section	ߎp[^
     * @param tolerance	̋e덷
     * @return		̋Ȑ̎w̋Ԃ𒼐ߎ|C
     * @see	JgclParameterOutOfRange
     */
    public JgclPolyline2D toPolyline(JgclParameterSection section,
				     JgclToleranceForDistance tolerance)
    {
	JgclBsplineKnot.ValidSegmentInfo vseg_info;
	int nseg;
	double lower_limit, upper_limit;
	double my_sp, my_ep;
	int my_sseg, my_eseg;
	JgclPureBezierCurve2D[] bzcs;
	int no_total_pnts;
	SegmentInfo[] seg_infos;
	double[] kp;
	double bzc_sp, bzc_ep, bzc_ip;
	JgclParameterSection lpint;
	JgclPolyline2D lpol;
	JgclPoint2D[] pnts;
	JgclPointOnCurve2D lpnt;
	JgclPoint2D pnt;
	double param;
	int npnts;
	double tol_p = JgclConditionOfOperation.getCondition().getToleranceForParameter();
	int i, j, m;

	/*
	 * check the parametric consistency
	 */
	vseg_info = knotData.validSegments();
	nseg = vseg_info.nSegments();
	lower_limit = vseg_info.knotPoint(0)[0];
	upper_limit = vseg_info.knotPoint(nseg-1)[1];

	if (isPeriodic()) {
	    /*
	     * closed curve
	     */
	    JgclBsplineCurve2D o_bsc;	/* open curve */
	    double par_intvl = upper_limit - lower_limit; 

	    my_sp = checkParameter(section.start());
	    
	    o_bsc = divide(my_sp)[0];
	    if (section.increase() > 0.0)
		my_sp = lower_limit;
	    else
		my_sp = upper_limit;

	    lpint = new JgclParameterSection(my_sp, section.increase());
	    lpol = o_bsc.toPolyline(lpint, tolerance);

	    pnts = new JgclPoint2D[npnts = lpol.nPoints()];
	    for (i = 0; i < npnts; i++) {
		lpnt = (JgclPointOnCurve2D)lpol.pointAt(i);
		pnt = new JgclCartesianPoint2D(lpnt.x(), lpnt.y());
		param = lpnt.parameter() + section.start();
		if (param > upper_limit) param -= upper_limit;
		pnts[i] = new JgclPointOnCurve2D(pnt, this, param, doCheckDebug);
	    }

	    return new JgclPolyline2D(pnts);
	}

	my_sp = checkParameter(section.lower());
	my_ep = checkParameter(section.upper());
  
	my_sseg = vseg_info.segmentIndex(my_sp);
	my_eseg = vseg_info.segmentIndex(my_ep);

	/*
	 * exchange Bspline Curve to Bezier Curves
	 */
	bzcs = toPureBezierCurveArray();

	/*
	 * solution in bezier form
	 */
	no_total_pnts = 0;
	seg_infos = new SegmentInfo[nseg];

	for (i = my_sseg; i <= my_eseg; i++) {
	    kp = vseg_info.knotPoint(i);

	    seg_infos[i] = new SegmentInfo(kp[0], kp[1]);

	    if (i == my_sseg)
		bzc_sp = (my_sp - seg_infos[i].lp()) / seg_infos[i].dp();
	    else
		bzc_sp = 0.0;

	    if (i == my_eseg)
		bzc_ep = (my_ep - seg_infos[i].lp()) / seg_infos[i].dp();
	    else
		bzc_ep = 1.0;

	    if ((bzc_ip = bzc_ep - bzc_sp) < tol_p) {
		my_eseg = i - 1;
		break;
	    }

	    lpint = new JgclParameterSection(bzc_sp, bzc_ip);
	    try {
		lpol = bzcs[i].toPolyline(lpint, tolerance);
	    } catch (JgclZeroLength e) {
		continue;
	    }
	    seg_infos[i].pnts(lpol.points());

	    no_total_pnts += seg_infos[i].nPnts();
	    if (i > my_sseg)
		no_total_pnts--;
	}

	/*
	 * solution in bspline form
	 */
	if (no_total_pnts < 2)
	    throw new JgclZeroLength();

	pnts = new JgclPoint2D[no_total_pnts];

	boolean first = true;
	for (i = my_sseg, m = 0; i <= my_eseg; i++) {
	    if (first)
		j = 0;
	    else
		j = 1;
	    for (; j < seg_infos[i].nPnts(); j++, m++) {
		lpnt = (JgclPointOnCurve2D)seg_infos[i].pnts(j);
		pnt = new JgclCartesianPoint2D(lpnt.x(), lpnt.y());
		param = seg_infos[i].lp() + (seg_infos[i].dp() * lpnt.parameter());
		pnts[m] = new JgclPointOnCurve2D(pnt, this, param, doCheckDebug);
		first = false;
	    }
	}
	if (section.increase() > 0.0) {
	    return new JgclPolyline2D(pnts);
	} else {
	    return new JgclPolyline2D(pnts).reverse();
	}
    }

    /**
     * ZOg𒼐ߎ_̏\NXB
     */
    private class SegmentInfo {
	/**
	 * ZOg̊Jnp[^lB
	 */
	private double lp;

	/**
	 * ZOg̏Ip[^lB
	 */
	private double up;

	/**
	 * ZOg̑p[^lB
	 */
	private double dp;

	/**
	 * ZOg𒼐ߎ_B
	 */
	private JgclPoint2D[] pnts;

	/**
	 * Jnp[^lƏIp[^l^ăIuWFNg\zB
	 *
	 * @param lp	Jnp[^l
	 * @param up	Ip[^l
	 */
	private SegmentInfo(double lp, double up) {
	    this.lp = lp;
	    this.up = up;
	    this.dp = up - lp;
	}

	/**
	 * ZOg𒼐ߎ_ݒ肷B
	 *
	 * @param pnts	ZOg𒼐ߎ_
	 */
	private void pnts(JgclPoint2D[] pnts) {
	    this.pnts = pnts;
	}

	/**
	 * ZOg̊Jnp[^lԂB
	 *
	 * @return	ZOg̊Jnp[^l
	 */
	private double lp() {
	    return lp;
	}

	/**
	 * ZOg̏Ip[^lԂB
	 *
	 * @return	ZOg̏Ip[^l
	 */
	private double up() {
	    return up;
	}

	/**
	 * ZOg̑p[^lԂB
	 *
	 * @return	ZOg̑p[^l
	 */
	private double dp() {
	    return dp;
	}

	/**
	 * ZOg𒼐ߎ_̓_̐ԂB
	 * <p>
	 * _񂪐ݒ肳ĂȂꍇɂ 0 ԂB
	 * </p>
	 *
	 * @return	ZOg𒼐ߎ_̓_̐
	 */
	private int nPnts() {
	    if (pnts == null)
		return 0;
	    return pnts.length;
	}

	/**
	 * ZOg𒼐ߎ_ n Ԗڂ̓_ԂB
	 *
	 * @return	ZOg𒼐ߎ_ n Ԗڂ̓_
	 */
	private JgclPoint2D pnts(int n) {
	    return pnts[n];
	}
    }

    /**
     * ̂aXvCȐČxWGȐ̗ԂB
     * <p>
     * ̋Ȑ́Ap[^IɏkނĂȂLZOgɑΉxWGȐ̗ԂB
     * </p>
     * 
     * @return	xWGȐ̔z
     */
    public JgclPureBezierCurve2D[] toPureBezierCurveArray() {
	double[][] cntlPnts;
	boolean isPoly = isPolynomial();
	double[][][] bzc_array;
	JgclPureBezierCurve2D[] bzcs;

	cntlPnts = toDoubleArray(isPoly);
	bzc_array = JgclBsplineCurveEvaluation.toBezierCurve(knotData, cntlPnts);
	bzcs = new JgclPureBezierCurve2D[bzc_array.length];
	for (int i = 0; i < bzc_array.length; i++) {
	    try {
		bzcs[i] = new JgclPureBezierCurve2D(bzc_array[i]);
	    } catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}

	return bzcs;
    }

    /**
     * ̂aXvCȐis𔽓]aXvCȐԂB
     *
     * @return	]̂aXvCȐ
     */
    JgclBsplineCurve2D reverse() {
	JgclBsplineKnot rKd;
	boolean isRat = isRational();
	int uicp = nControlPoints();
	JgclPoint2D[] rCp = new JgclPoint2D[uicp];
	double[] rWt = null;
	int i, j;

	rKd = knotData.reverse();
	if (isRat)
	    rWt = new double[uicp];
	for (i = 0, j = uicp - 1; i < uicp; i++, j--) {
	    rCp[i] = controlPointAt(j);
	    if (isRat)
		rWt[i] = weightAt(j);
	}
	return new JgclBsplineCurve2D(rKd, rCp, rWt);
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     * 
     * @return	p[^`
     * @see	JgclBsplineKnot#getParameterDomain()
     */
    JgclParameterDomain getParameterDomain() {
	return knotData.getParameterDomain();
    }

    /**
     * ^ꂽp[^lA̋Ȑ̒`ɑ΂ėLۂ𒲂ׂB
     * <p>
     * ^ꂽp[^l̋Ȑ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @return         KvɉĂ̋Ȑ̒`Ɋۂ߂ꂽp[^l
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterDomain#force(double)
     * @see	JgclParameterDomain#wrap(double)
     * @see	JgclParameterOutOfRange
     */
    private double checkParameter(double param)
    {
	checkValidity(param);
	return parameterDomain().force(parameterDomain().wrap(param));
    }

    /**
     * ̋ȐA`̂܂܂ɂāAグȐԂB
     *
     * @return	`ŁAオȐ
     */
    public JgclBsplineCurve2D elevateOneDegree()
    {
	JgclBsplineKnot oldKnotData = this.knotData();
	double[][] oldControlPoints = this.toDoubleArray(this.isPolynomial());

	JgclBsplineKnot newKnotData = 
	    JgclBsplineCurveEvaluation.
	    getNewKnotDataAtDegreeElevation(oldKnotData);

	double[][] newControlPoints =
	    JgclBsplineCurveEvaluation.
	    getNewControlPointsAtDegreeElevation(oldKnotData,
						 newKnotData,
						 oldControlPoints);

	return new JgclBsplineCurve2D(newKnotData, newControlPoints);
    }

    /**
     * ̂aXvCȐƁA
     * ̂aXvCȐ̏I_Ɋ􉽓IɌqĂaXvCȐ
     * {̂aXvCȐɂB
     *
     * @param mate	̋Ȑ̏I_ɌqȐ
     * @return	this ̏I_ mate ̊Jn_qň{ɂȐ
     * @exception JgclTwoGeomertiesAreNotContinuous
     *			this ̏I_ mate ̊Jn_vȂ
     */
    public JgclBsplineCurve2D mergeIfContinuous(JgclBsplineCurve2D mate)
	 throws JgclTwoGeomertiesAreNotContinuous
    {
	JgclBsplineCurve2D headCurve = this;
	JgclBsplineCurve2D tailCurve = mate;

	JgclParameterSection headSection = headCurve.parameterDomain().section();
	JgclParameterSection tailSection = tailCurve.parameterDomain().section();
	double headEndParameter   = headSection.end();
	double tailStartParameter = tailSection.start();

	// qĂ邩H
	JgclPoint2D headEnd   = headCurve.coordinates(headEndParameter);
	JgclPoint2D tailStart = tailCurve.coordinates(tailStartParameter);
	if (headEnd.identical(tailStart) != true) {
	    // debug
	    // headEnd.output(System.err);
	    // tailStart.output(System.err);
	    throw new JgclTwoGeomertiesAreNotContinuous();
	}

	// Lǂ킹
	boolean headPoly = headCurve.isPolynomial();
	boolean tailPoly = tailCurve.isPolynomial();
	boolean isPoly;

	if ((headPoly == true) && (tailPoly == true)) {
	    isPoly = true;
	} else if (headPoly == true) {
	    isPoly = false;
	    headCurve = headCurve.toBsplineCurve();
	} else if (tailPoly == true) {
	    isPoly = false;
	    tailCurve = tailCurve.toBsplineCurve();
	} else {
	    isPoly = false;
	}

	// 킹
	int headDegree = headCurve.degree();
	int tailDegree = tailCurve.degree();

	while (headDegree < tailDegree) {
	    headCurve = headCurve.elevateOneDegree();
	    headDegree++;
	}

	while (headDegree > tailDegree) {
	    tailCurve = tailCurve.elevateOneDegree();
	    tailDegree++;
	}

	// ꂼڍʒuŕāAmbg̑dxグ
	JgclBsplineCurve2D[] dividedCurves;
	dividedCurves = headCurve.divide(headEndParameter);
	headCurve = dividedCurves[0];
	dividedCurves = tailCurve.divide(tailStartParameter);
	tailCurve = dividedCurves[1];

	// debug
	// headCurve.output(System.err);
	// tailCurve.output(System.err);

	// VȐ̃mbgpӂ
	JgclBsplineKnot headKnotData = headCurve.knotData();
	JgclBsplineKnot tailKnotData = tailCurve.knotData();

	int arrayLength;

	arrayLength = headKnotData.nKnots() + tailKnotData.nKnots() - 1;
	double[] newKnots = new double[arrayLength];
	int[] newKnotMultiplicities = new int[arrayLength];

	int nNewKnots = 0;
	for (int j = 0; j < headKnotData.nKnots(); j++) {
	    newKnots[nNewKnots] = headKnotData.knotAt(j);
	    newKnotMultiplicities[nNewKnots] = headKnotData.knotMultiplicityAt(j);
	    nNewKnots++;
	}
	newKnotMultiplicities[nNewKnots - 1] = headDegree;

	double offset = headEndParameter - tailStartParameter;
	for (int j = 1; j < tailKnotData.nKnots(); j++) {
	    newKnots[nNewKnots] = tailKnotData.knotAt(j) + offset;
	    newKnotMultiplicities[nNewKnots] = tailKnotData.knotMultiplicityAt(j);
	    nNewKnots++;
	}

	// VȐ̐_pӂ
	arrayLength = headKnotData.nControlPoints() + tailKnotData.nControlPoints() - 1;
	JgclPoint2D[] newControlPoints = new JgclPoint2D[arrayLength];
	double[] newWeights = null;
	if (isPoly != true)
	    newWeights = new double[arrayLength];

	int nNewControlPoints = 0;
	for (int j = 0; j < headKnotData.nControlPoints(); j++) {
	    newControlPoints[nNewControlPoints] = headCurve.controlPointAt(j);
	    if (isPoly != true)
		newWeights[nNewControlPoints] = headCurve.weightAt(j);
	    nNewControlPoints++;
	}

	double weightRatio = 0;
	if (isPoly != true)
	    weightRatio = newWeights[nNewControlPoints - 1] / tailCurve.weightAt(0);

	for (int j = 1; j < tailKnotData.nControlPoints(); j++) {
	    newControlPoints[nNewControlPoints] = tailCurve.controlPointAt(j);
	    if (isPoly != true)
		newWeights[nNewControlPoints] = tailCurve.weightAt(j) * weightRatio;
	    nNewControlPoints++;
	}

	// VȐ𐶐
	JgclBsplineCurve2D result;

	if (isPoly == true)
	    result = new JgclBsplineCurve2D(headDegree, false,
					    newKnotMultiplicities, newKnots,
					    newControlPoints);
	else
	    result = new JgclBsplineCurve2D(headDegree, false,
					    newKnotMultiplicities, newKnots,
					    newControlPoints, newWeights);

	return result;
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve2D#BSPLINE_CURVE_2D JgclParametricCurve2D.BSPLINE_CURVE_2D}
     */
    int type() {
	return BSPLINE_CURVE_2D;
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricCurve2D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator2D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclPoint2D[] tControlPoints =
	    JgclPoint2D.transform(this.controlPoints,
				  reverseTransform,
				  transformationOperator,
				  transformedGeometries);
	return new JgclBsplineCurve2D(this.knotData, tControlPoints, this.weights);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);
	StringBuffer buf = new StringBuffer();

        writer.println(indent_tab + getClassName());
        // output knotData(JgclBsplineKnot)
        //knotData.output(writer, indent + 2);
        knotData.output(writer, indent, 0);

        // output others
        writer.println(indent_tab + "\tcontrolPoints");
	for (int i = 0; i < nControlPoints(); i++) {
	    controlPointAt(i).output(writer, indent + 2);
        }
	if (weights() != null) {
	    writer.println(indent_tab + "\tweights ");
	    int i = 0;
	    while(true) {
		for (int j =0; j < 10 && i < weights().length; j++, i++){
		    writer.print(" " + weightAt(i));
		}
		writer.println();
		if (i < weights().length) {
		    writer.print(indent_tab + "\t");
		} else {
		    break;
		}
	    }
	}
        writer.println(indent_tab + "\tcurveForm\t"+ JgclBsplineCurveForm.toString(curveForm));
        writer.println(indent_tab + "End");
    }
}
