/*
 * R : LȋȖʂ\ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclBoundedSurface3D.java,v 1.26 2000/08/11 06:18:42 shikano Exp $
 */

package jp.go.ipa.jgcl;

/**
 * R : LȋȖʂ\ۃNXB
 * <p>
 * ̃NXɂ̓CX^Xׂ͂ȂB
 * </p>
 *
 * @version $Revision: 1.26 $, $Date: 2000/08/11 06:18:42 $
 * @author Information-technology Promotion Agency, Japan
 */

public abstract class JgclBoundedSurface3D extends JgclParametricSurface3D {
    /**
     * ^ɃIuWFNg\zB
     */
    protected JgclBoundedSurface3D() {
	super();
    }

    /**
     *  (`̃p[^`) LȖʑŜA^ꂽ덷ŕʋߎ
     * iq_QԂۃ\bhB
     * <p>
     * ʂƂĕԂiq_Q\_́A
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D 
     * 邱Ƃ҂łB
     * </p>
     * 
     * @param tol	̋e덷
     * @return		̗LȖʑŜ𕽖ʋߎiq_Q
     * @see		JgclPointOnSurface3D
     */
    public abstract JgclMesh3D toMesh(JgclToleranceForDistance tol);

    /**
     *  (`̃p[^`) LȖʑŜɍČ
     * L Bspline ȖʂԂB
     * 
     * @return		̗LȖʑŜČL Bspline Ȗ
     */
    public JgclBsplineSurface3D toBsplineSurface() {
	try {
	    return this.toBsplineSurface(this.uParameterDomain().section(),
					 this.vParameterDomain().section());
	} catch (JgclParameterOutOfRange e) {
	    throw new JgclFatal("Something wrong. Maybe JGCL's bug");
	}
    }

    /**
     *  (`̃p[^`) LȖʑŜItZbgȖʂ
     * ^ꂽ덷ŋߎ Bspline Ȗʂ߂B
     * 
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.FRONT/BACK)
     * @param tol     	̋e덷
     * @return		̗LȖʑŜ̃ItZbgȖʂߎ Bspline Ȗ
     * @see	JgclWhichSide
     */
    public JgclBsplineSurface3D offsetByBsplineSurface(double magni,
						       int side,
						       JgclToleranceForDistance tol) {
	try {
	    return offsetByBsplineSurface(uParameterDomain().section(),
					  vParameterDomain().section(),
					  magni, side, tol);
	} catch (JgclParameterOutOfRange e) {
	    throw new JgclFatal();
	}
    }

    /**
     * ̗LȖʂƑ̗LȖʂ̃tBbg߂B
     * <p>
     * tBbg݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param side1	̋Ȗʂ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.FRONTȂΕ\ARIGHTȂΗABOTHȂΗ)
     * @param mate	̋Ȗ
     * @param side2	̋Ȗʂ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.FRONTȂΕ\ARIGHTȂΗABOTHȂΗ)
     * @param radius	tBbga
     * @return		tBbg̔z
     * @exception JgclIndefiniteSolution	s (ł͔Ȃ)
     * @see	JgclWhichSide
     */
    public JgclFilletObject3D[] fillet(int side1, JgclBoundedSurface3D mate, int side2, double radius)
	throws JgclIndefiniteSolution
    {
	if (mate.type() == CURVE_BOUNDED_SURFACE_3D) {
	    JgclFilletObject3D[] results = mate.fillet(side2, this, side1, radius);
	    for (int i = 0; i < results.length; i++)
		results[i] = results[i].exchange();
	    return results;
	}

	return fillet(uParameterDomain().section(), vParameterDomain().section(), side1,
		      mate,
		      mate.uParameterDomain().section(), mate.vParameterDomain().section(), side2,
		      radius);
    }
}

