/*
 * Q : _̍WƂw̕Œ`ꂽǏWn (zu) \NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclAxis2Placement2D.java,v 1.27 2000/04/26 09:38:41 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * Q : _̍WƂw̕Œ`ꂽǏWn (zu) \NXB
 * <p>
 * ̃NX́A
 * ~Ȑ̈ʒuXA
 * Wϊ̕ϊs̎wȂǂɗp܂B
 * </p>
 * <p>
 * ̃NX̃CX^X́A
 * ǏWň_ƂȂ_ location
 * ƁA
 * ǏWn̂w̕xNg refDirection
 * ێ܂B
 * ̋ǏWńAEn̒Wn\̂ŁA
 * x́̕Aw̕莩IɌ肳܂B
 * w̕ 90 x]x̕ƂȂ܂B
 * wx̊exNǵAɂ̑傫 1 ɒPʉĈ܂B
 * ȂÃxNg
 * {@link JgclGeometrySchemaFunction#build2Axes(JgclVector2D)
 * JgclGeometrySchemaFunction.build2Axes}(refDirection)
 * ɂċ߂Ă܂B
 * </p>
 * <p>
 * location ɗ^_ɂ͓ɐ͂ȂA
 * {@link JgclPoint2D JgclPoint2D} NX̔Cӂ̓_^邱Ƃł܂A
 * null w肷邱Ƃ͂ł܂B
 * refDirection ɗ^xNg {@link JgclVector2D JgclVector2D}
 * ͓ɒPʉĂKv͂܂񂪁A
 * [xNg^邱Ƃ͂ł܂B
 * ȂArefDirection ɗ^xNg
 * w肵Ȃ (null w肷) Ƃł܂B
 * ̏ꍇɂ́Aw̕ (1, 0) ɓ̂Ɖ߂܂B
 * </p>
 *
 * @version $Revision: 1.27 $, $Date: 2000/04/26 09:38:41 $
 * @author Information-technology Promotion Agency, Japan
 * @see JgclAxis2Placement3D
 */

public class JgclAxis2Placement2D extends JgclPlacement2D {
    /**
     * WnB
     * <p>
     * (0, 0) _A(1, 0)  X ̕ƂWnB
     * </p>
     */
    public static final JgclAxis2Placement2D origin;

    /**
     * static ȃtB[hɒlݒ肷B
     */
    static {
	origin = new JgclAxis2Placement2D(JgclPoint2D.origin,
					  JgclVector2D.xUnitVector);
    }

    /**
     * w̕\xNgB
     * @serial
     */
    private final JgclVector2D refDirection;

    /**
     * w/x\PʃxNgB
     * <p>
     * KvɉăLbVB
     * </p>
     * @serial
     */
    private JgclVector2D[] axes;

    /**
     * ǏWň_ƂȂ_
     * w̕xNg^āA
     * IuWFNg\zB
     * <p>
     * location  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * refDirection  null ł\ȂB
     * refDirection  null ̏ꍇɂ́A
     * w̕ (1, 0) ɓ̂Ɖ߂B
     * </p>
     * <p>
     * refDirection ̑傫A
     * ݐݒ肳Ă鉉Z̋̋e덷ȉ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param location	_ƂȂ_
     * @param refDirection	w̕xNg
     * @see	JgclConditionOfOperation
     * @see	JgclInvalidArgumentValue
     */
    public JgclAxis2Placement2D(JgclPoint2D location,
				JgclVector2D refDirection)
    {
	super(location);
	this.refDirection = refDirection;
	checkRefDirection();
    }

    /**
     * w̕xNg̑Ó`FbNB
     * <p>
     * refDirection  null ł\ȂB
     * refDirection  null ̏ꍇɂ́A
     * w̕ (1, 0) ɓ̂Ɖ߂B
     * </p>
     * <p>
     * refDirection ̑傫A
     * ݐݒ肳Ă鉉Z̋̋e덷ȉ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @see	JgclConditionOfOperation
     * @see	JgclInvalidArgumentValue
     */
    private void checkRefDirection()
    {
	if (refDirection != null) {
	    JgclConditionOfOperation condition =
		JgclConditionOfOperation.getCondition();
	    double tol_d = condition.getToleranceForDistance();
	    if (refDirection.norm() <= tol_d * tol_d) {
		throw new JgclInvalidArgumentValue();
	    }
	}
    }

    /**
     * ̋ǏWn̂w̕xNgԂB
     * <p>
     * IuWFNg̍\zɗ^ꂽ refDirection ԂB
     * āAnull Ԃ邱Ƃ肤B
     * </p>
     *
     * @return	w̕xNg
     */
    public JgclVector2D refDirection() {
	return refDirection;
    }

    /**
     * ̋ǏWn̂w̕ (I) xNgԂB
     * <p>
     * refDirection  null łȂ΁ArefDirection ԂB
     * refDirection  null Ȃ΁A(1, 0) ̃xNgԂB
     * </p>
     *
     * @return	w̕ (I) xNg
     */
    public JgclVector2D effectiveRefDirection() {
	return (refDirection != null)
	    ? refDirection : JgclGeometrySchemaFunction.defaultRefDirection2D;
    }

    /**
     * ̋ǏWn̂w\PʃxNgԂB
     *
     * @return	w\PʃxNg
     */
    public JgclVector2D x() {
	if (axes == null)
	    axes();
	return axes[0];
    }

    /**
     * ̋ǏWn̂x\PʃxNgԂB
     *
     * @return	x\PʃxNg
     */
    public JgclVector2D y() {
	if (axes == null)
	    axes();
	return axes[1];
    }

    /**
     * ̋ǏWn̂w/x\PʃxNgԂB
     * <p>
     * ʂƂĕԂz̍ŏ̗vfwA
     * Ԗڂ̗vfx\B
     * </p>
     *
     * @return	w/x\PʃxNg̔z
     * @see	JgclGeometrySchemaFunction#build2Axes(JgclVector2D)
     */
    public JgclVector2D[] axes() {
	if (axes == null) {
	    axes = JgclGeometrySchemaFunction.build2Axes(refDirection);
	}
	return (JgclVector2D[])axes.clone();
    }

    /**
     * ̋ǏWnIȍWnւ̍WϊZqԂB
     *
     * @param scale	XP[O̗ʂK肷l
     * @return	XP[O܂ލWϊZq
     */
    public JgclCartesianTransformationOperator2D
    toCartesianTransformationOperator(double scale) {
	return new JgclCartesianTransformationOperator2D(this, scale);
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclAxis2Placement2D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator2D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclPoint2D tLocation =
	    this.location().transformBy(reverseTransform,
					transformationOperator,
					transformedGeometries);
	JgclVector2D tRefDirection =
	    this.effectiveRefDirection().transformBy(reverseTransform,
						     transformationOperator,
						     transformedGeometries);
	return new JgclAxis2Placement2D(tLocation, tRefDirection);
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    public synchronized JgclAxis2Placement2D
    transformBy(boolean reverseTransform,
		JgclCartesianTransformationOperator2D transformationOperator,
		java.util.Hashtable transformedGeometries)
    {
	if (transformedGeometries == null)
	    return this.doTransformBy(reverseTransform,
				      transformationOperator,
				      transformedGeometries);

	JgclAxis2Placement2D transformed = (JgclAxis2Placement2D)transformedGeometries.get(this);
	if (transformed == null) {
	    transformed = this.doTransformBy(reverseTransform,
					     transformationOperator,
					     transformedGeometries);
	    transformedGeometries.put(this, transformed);
	}
	return transformed;
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    public synchronized JgclAxis2Placement2D
    transformBy(JgclCartesianTransformationOperator2D transformationOperator,
		java.util.Hashtable transformedGeometries)
    {
	return this.transformBy(false,
				transformationOperator,
				transformedGeometries);
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŋtϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŋtϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŋtϊ̂ԂB
     * </p>
     *
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	tϊ̊􉽗vf
     */
    public synchronized JgclAxis2Placement2D
    reverseTransformBy(JgclCartesianTransformationOperator2D transformationOperator,
		       java.util.Hashtable transformedGeometries)
    {
	return this.transformBy(true,
				transformationOperator,
				transformedGeometries);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tlocation");
        location().output(writer, indent + 2);
	if (refDirection != null) {
	    writer.println(indent_tab + "\trefDirection");
	    refDirection.output(writer, indent + 2);
	}
        writer.println(indent_tab + "End");
    }
}
