/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Enumeration;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclBoundedLine2D;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclEmbeddedGraph;
import jp.go.ipa.jgcl.JgclEnclosingBox2D;
import jp.go.ipa.jgcl.JgclException;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclLiteralVector2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclVector2D;
import jp.go.ipa.jgcl.JgclVoronoiDiagram2D;

public class JgclVoronoiDiagram2D {
    private JgclEmbeddedGraph graph;
    private VRegion[] regions;
    private Vector coincidingRegions;
    private double xScale;
    private double yScale;
    private double radiusScale;
    public static final double radiusScaleDefault = 100.0;
    private static final double farScale = 30.0;
    private static JgclConditionOfOperation conditionWithSmallDTol = null;

    public JgclVoronoiDiagram2D(JgclEmbeddedGraph seed, Enumeration points) {
        this.createDiagram(seed, points, 1.0, 1.0, 100.0);
    }

    public JgclVoronoiDiagram2D(JgclEmbeddedGraph seed, Enumeration points, double xScale, double yScale) {
        this.createDiagram(seed, points, xScale, yScale, 100.0);
    }

    public JgclVoronoiDiagram2D(JgclEmbeddedGraph seed, Enumeration points, double xScale, double yScale, double radiusScale) {
        this.createDiagram(seed, points, xScale, yScale, radiusScale);
    }

    private void createDiagram(JgclEmbeddedGraph seed, Enumeration givenPoints, double xScale, double yScale, double radiusScale) {
        if (!(xScale > 0.0)) {
            throw new JgclInvalidArgumentValue("xScale should be positive.");
        }
        if (!(yScale > 0.0)) {
            throw new JgclInvalidArgumentValue("yScale should be positive.");
        }
        if (!(radiusScale > 0.0)) {
            throw new JgclInvalidArgumentValue("radiusScale should be positive.");
        }
        Vector points = new Vector();
        while (givenPoints.hasMoreElements()) {
            points.addElement(givenPoints.nextElement());
        }
        int nPoints = points.size();
        if (nPoints < 2) {
            throw new JgclInvalidArgumentValue("The number of given points is too small.");
        }
        this.graph = seed;
        this.regions = new VRegion[nPoints];
        this.coincidingRegions = new Vector();
        this.xScale = xScale;
        this.yScale = yScale;
        this.radiusScale = radiusScale;
        JgclPoint2D[] scaledPoints = new JgclPoint2D[nPoints];
        int i = 0;
        while (i < nPoints) {
            JgclPoint2D givenPoint = (JgclPoint2D)points.elementAt(i);
            scaledPoints[i] = new JgclCartesianPoint2D(givenPoint.x() * this.xScale, givenPoint.y() * this.yScale);
            this.regions[i] = new VRegion(i, scaledPoints[i]);
            ++i;
        }
        JgclEnclosingBox2D box = new JgclEnclosingBox2D(scaledPoints);
        JgclPoint2D center = box.min().linearInterpolate(box.max(), 0.5);
        double radius = this.radiusScale * center.distance(center.longestPoint(scaledPoints));
        JgclEmbeddedGraph.Vertex[] extraPoints = new JgclEmbeddedGraph.Vertex[3];
        VRegion[] extraRegions = new VRegion[3];
        VRegion lastAddedRegion = this.makeInitialDiagram(center, radius, extraPoints, extraRegions);
        int i2 = 0;
        while (i2 < nPoints) {
            lastAddedRegion = this.addPoint(i2, null, lastAddedRegion);
            ++i2;
        }
        this.removeExtraFaces(extraPoints, extraRegions);
    }

    private VRegion makeInitialDiagram(JgclPoint2D center, double radius, JgclEmbeddedGraph.Vertex[] extraPoints, VRegion[] extraRegions) {
        JgclLiteralVector2D vectorInitialPoint = null;
        JgclLiteralVector2D vectorFarPoint = null;
        double degree30 = 0.5235987755982988;
        double cos30 = Math.cos(degree30);
        double sin30 = Math.sin(degree30);
        double farDist = radius * 30.0;
        double rr = 3.0 * Math.sqrt(2.0) * radius / 4.0;
        double qq = Math.sqrt(3.0) * rr;
        JgclEmbeddedGraph.Result opResult = this.graph.makeVertexFace();
        JgclEmbeddedGraph.Vertex origVrtx = opResult.vrtx;
        JgclEmbeddedGraph.Face outerFace = opResult.face;
        VPoint vpnt = new VPoint(center);
        vpnt.setDistance(2.0 * rr);
        origVrtx.setUserData(vpnt);
        outerFace.setUserData(null);
        int i = 0;
        while (i < 3) {
            switch (i) {
                case 0: {
                    vectorInitialPoint = new JgclLiteralVector2D(0.0, 2.0 * rr);
                    vectorFarPoint = new JgclLiteralVector2D(farDist * cos30, farDist * sin30);
                    break;
                }
                case 1: {
                    vectorInitialPoint = new JgclLiteralVector2D(-qq, -rr);
                    vectorFarPoint = new JgclLiteralVector2D(-farDist * cos30, farDist * sin30);
                    break;
                }
                case 2: {
                    vectorInitialPoint = new JgclLiteralVector2D(qq, -rr);
                    vectorFarPoint = new JgclLiteralVector2D(0.0, -farDist);
                    break;
                }
            }
            opResult = this.graph.makeEdgeVertex(outerFace, origVrtx);
            extraPoints[i] = opResult.vrtx;
            vpnt = new VPoint(center.add(vectorFarPoint));
            vpnt.setDistance(-1.0);
            extraPoints[i].setUserData(vpnt);
            extraRegions[i] = new VRegion(-(i + 101), center.add(vectorInitialPoint));
            switch (i) {
                case 1: {
                    opResult = this.graph.makeEdgeFace(outerFace, extraPoints[1], extraPoints[0]);
                    extraRegions[0].setFace(opResult.face);
                    opResult.face.setUserData(extraRegions[0]);
                    break;
                }
                case 2: {
                    opResult = this.graph.makeEdgeFace(outerFace, extraPoints[2], extraPoints[1]);
                    extraRegions[1].setFace(opResult.face);
                    opResult.face.setUserData(extraRegions[1]);
                    opResult = this.graph.makeEdgeFace(outerFace, extraPoints[0], extraPoints[2]);
                    extraRegions[2].setFace(opResult.face);
                    opResult.face.setUserData(extraRegions[2]);
                    break;
                }
            }
            ++i;
        }
        return extraRegions[2];
    }

    private JgclEmbeddedGraph.Face edgeHasSameFace(JgclEmbeddedGraph.Edge edge) {
        JgclEmbeddedGraph.Face[] faces = edge.getFaces();
        if (faces[0] == faces[1]) {
            return faces[0];
        }
        return null;
    }

    private JgclEmbeddedGraph.Vertex edgeHasIsolateVertex(JgclEmbeddedGraph.Edge edge) {
        JgclEmbeddedGraph.Vertex[] v = edge.getVertices();
        int i = 0;
        while (i < 2) {
            if (v[i].getEdgeCycleInCCW().size() == 1) {
                return v[i];
            }
            ++i;
        }
        return null;
    }

    private JgclEmbeddedGraph.Face killEdges(Vector edges, Vector RandF) {
        JgclEmbeddedGraph.Face lastFace = null;
        while (edges != null) {
            Vector<JgclEmbeddedGraph.Edge> remainedEdges = null;
            Enumeration e = edges.elements();
            while (e.hasMoreElements()) {
                JgclEmbeddedGraph.Edge edge = (JgclEmbeddedGraph.Edge)e.nextElement();
                lastFace = this.edgeHasSameFace(edge);
                if (lastFace != null) {
                    if (this.edgeHasIsolateVertex(edge) != null) {
                        this.graph.killEdgeVertex(edge);
                        continue;
                    }
                    if (remainedEdges == null) {
                        remainedEdges = new Vector<JgclEmbeddedGraph.Edge>();
                    }
                    remainedEdges.addElement(edge);
                    continue;
                }
                JgclEmbeddedGraph.Face rightFace = edge.getRightFace();
                Enumeration e1 = RandF.elements();
                while (e1.hasMoreElements()) {
                    RegionAndFace RF = (RegionAndFace)e1.nextElement();
                    if (RF.killFaceIfGivenIsIt(rightFace)) break;
                }
                this.graph.killEdgeFace(edge, rightFace);
            }
            edges = remainedEdges;
        }
        return lastFace;
    }

    private void addRegion(VRegion newRegion, Vector T) {
        JgclEmbeddedGraph.Result opResult;
        JgclPoint2D newRegionCoord = newRegion.getCoordinates();
        Vector<JgclEmbeddedGraph.Vertex> newVrtcs = new Vector<JgclEmbeddedGraph.Vertex>();
        Vector<JgclEmbeddedGraph.Edge> rmvEdges = new Vector<JgclEmbeddedGraph.Edge>();
        Vector<JgclEmbeddedGraph.Face> dvdFaces = new Vector<JgclEmbeddedGraph.Face>();
        Vector<RegionAndFace> dvdRandF = new Vector<RegionAndFace>();
        Enumeration e0 = T.elements();
        while (e0.hasMoreElements()) {
            JgclEmbeddedGraph.Vertex vrtx = (JgclEmbeddedGraph.Vertex)e0.nextElement();
            Enumeration e1 = vrtx.getEdgeCycleInCCW().elements();
            while (e1.hasMoreElements()) {
                JgclEmbeddedGraph.Face[] twoFaces;
                JgclEmbeddedGraph.Edge rmvEdge;
                JgclEmbeddedGraph.Edge edge = (JgclEmbeddedGraph.Edge)e1.nextElement();
                JgclEmbeddedGraph.Vertex anotherVrtx = this.anotherEnd(edge, vrtx);
                if (T.contains(anotherVrtx)) {
                    if (this.edgeIsContained(rmvEdges, edge)) continue;
                    rmvEdges.addElement(edge);
                    continue;
                }
                opResult = this.graph.makeVertexEdge(edge);
                JgclEmbeddedGraph.Vertex newVrtx = opResult.vrtx;
                JgclEmbeddedGraph.Edge newEdge = opResult.edge;
                this.setMiddlePoint(edge, vrtx, anotherVrtx, newVrtx, newRegionCoord);
                newVrtcs.addElement(newVrtx);
                JgclEmbeddedGraph.Edge edge2 = rmvEdge = this.anotherEnd(edge, newVrtx) == vrtx ? edge : newEdge;
                if (!this.edgeIsContained(rmvEdges, rmvEdge)) {
                    rmvEdges.addElement(rmvEdge);
                }
                if (!dvdFaces.contains((twoFaces = edge.getFaces())[0])) {
                    dvdFaces.addElement(twoFaces[0]);
                }
                if (dvdFaces.contains(twoFaces[1])) continue;
                dvdFaces.addElement(twoFaces[1]);
            }
        }
        Enumeration e02 = dvdFaces.elements();
        while (e02.hasMoreElements()) {
            JgclEmbeddedGraph.Face face = (JgclEmbeddedGraph.Face)e02.nextElement();
            JgclEmbeddedGraph.Vertex tgtVrtx0 = null;
            JgclEmbeddedGraph.Vertex tgtVrtx1 = null;
            Enumeration e1 = newVrtcs.elements();
            while (e1.hasMoreElements()) {
                JgclEmbeddedGraph.Vertex vrtx = (JgclEmbeddedGraph.Vertex)e1.nextElement();
                Vector faces = vrtx.getFaceCycleInCCW();
                if (faces.contains(face)) {
                    if (tgtVrtx0 == null) {
                        tgtVrtx0 = vrtx;
                    } else {
                        tgtVrtx1 = vrtx;
                    }
                }
                if (tgtVrtx0 != null && tgtVrtx1 != null) break;
            }
            if (tgtVrtx0 == null || tgtVrtx1 == null) continue;
            opResult = this.graph.makeEdgeFace(face, tgtVrtx0, tgtVrtx1);
            dvdRandF.addElement(new RegionAndFace((VRegion)face.getUserData(), opResult.face));
        }
        JgclEmbeddedGraph.Face newFace = this.killEdges(rmvEdges, dvdRandF);
        Enumeration e = dvdRandF.elements();
        while (e.hasMoreElements()) {
            ((RegionAndFace)e.nextElement()).reAssociate(newFace);
        }
        newRegion.setFace(newFace);
        newFace.setUserData(newRegion);
    }

    private VRegion addPoint(int index, VRegion nearRegionHint, VRegion lastAddedRegion) {
        Vector T = new Vector();
        JgclEmbeddedGraph.Face nearestFace = this.findT(this.regions[index].getCoordinates(), nearRegionHint, lastAddedRegion, T);
        if (T.size() > 0) {
            this.addRegion(this.regions[index], T);
            lastAddedRegion = this.regions[index];
        } else {
            this.regions[index].setFace(nearestFace);
            this.coincidingRegions.addElement(this.regions[index]);
        }
        return lastAddedRegion;
    }

    private JgclEmbeddedGraph.Face findT(JgclPoint2D tgt, VRegion nearRegionHint, VRegion lastAddedRegion, Vector TV) {
        TVertexInfo tvi;
        JgclEmbeddedGraph.Vertex vrtx;
        JgclEmbeddedGraph.Face nearestFace = this.findNearestRegion(tgt, nearRegionHint, lastAddedRegion);
        JgclVector2D diff = tgt.subtract(((VRegion)nearestFace.getUserData()).getCoordinates());
        if ((diff = new JgclLiteralVector2D(diff.x() / this.xScale, diff.y() / this.yScale)).length() < JgclConditionOfOperation.getCondition().getToleranceForDistance()) {
            return nearestFace;
        }
        JgclEmbeddedGraph.Vertex smallestV = null;
        double smallestH = Double.MAX_VALUE;
        Enumeration e = nearestFace.getVertexCycleInCCW().elements();
        while (e.hasMoreElements()) {
            vrtx = (JgclEmbeddedGraph.Vertex)e.nextElement();
            try {
                double H = this.evaluateH(vrtx, tgt);
                if (smallestV != null && !(H < smallestH)) continue;
                smallestV = vrtx;
                smallestH = H;
            }
            catch (PointIsExtra pointIsExtra) {}
        }
        TVertexInfo T = new TVertexInfo(smallestV, null);
        while ((tvi = T.getTviHasUnevaledNeighbors()) != null) {
            Enumeration e2 = tvi.v.getEdgeCycleInCCW().elements();
            while (e2.hasMoreElements()) {
                vrtx = this.anotherEnd((JgclEmbeddedGraph.Edge)e2.nextElement(), tvi.v);
                if (T.listHasThisVrtx(vrtx)) continue;
                try {
                    if (!(this.evaluateH(vrtx, tgt) < 0.0)) {
                    }
                }
                catch (PointIsExtra pointIsExtra) {}
                continue;
                if (!T.inspectTopologicalValidity(vrtx)) continue;
                T = new TVertexInfo(vrtx, T);
            }
        }
        tvi = T;
        while (tvi != null) {
            TV.addElement(tvi.v);
            tvi = tvi.next;
        }
        return nearestFace;
    }

    private JgclEmbeddedGraph.Face findNearestRegion(JgclPoint2D tgt, VRegion nearRegionHint, VRegion lastAddedRegion) {
        JgclEmbeddedGraph.Face crntFace;
        double nearDist2;
        JgclEmbeddedGraph.Face nearFace;
        if (nearRegionHint != null) {
            nearFace = nearRegionHint.getFace();
            nearDist2 = tgt.distance2(nearRegionHint.getCoordinates());
        } else {
            nearFace = lastAddedRegion.getFace();
            nearDist2 = tgt.distance2(lastAddedRegion.getCoordinates());
        }
        do {
            crntFace = nearFace;
            Vector edges = crntFace.getEdgeCycleInCCW();
            Enumeration e = edges.elements();
            while (e.hasMoreElements()) {
                double dist2;
                JgclEmbeddedGraph.Edge edge = (JgclEmbeddedGraph.Edge)e.nextElement();
                JgclEmbeddedGraph.Face face = this.getAnotherFace(edge, crntFace);
                VRegion rgn = (VRegion)face.getUserData();
                if (rgn == null || !((dist2 = tgt.distance2(rgn.getCoordinates())) < nearDist2)) continue;
                nearFace = face;
                nearDist2 = dist2;
            }
        } while (crntFace != nearFace);
        return nearFace;
    }

    private JgclEmbeddedGraph.Vertex anotherEnd(JgclEmbeddedGraph.Edge e, JgclEmbeddedGraph.Vertex v) {
        JgclEmbeddedGraph.Vertex[] vertices = e.getVertices();
        if (v == vertices[0]) {
            return vertices[1];
        }
        if (v == vertices[1]) {
            return vertices[0];
        }
        return null;
    }

    private JgclEmbeddedGraph.Face getAnotherFace(JgclEmbeddedGraph.Edge e, JgclEmbeddedGraph.Face f) {
        JgclEmbeddedGraph.Face[] faces = e.getFaces();
        if (f == faces[0]) {
            return faces[1];
        }
        if (f == faces[1]) {
            return faces[0];
        }
        return null;
    }

    private double evaluateH(JgclEmbeddedGraph.Vertex vrtx, JgclPoint2D addedPoint) throws PointIsExtra {
        VPoint pnt = (VPoint)vrtx.getUserData();
        if (pnt.getDistance() < 0.0) {
            throw new PointIsExtra();
        }
        return addedPoint.distance(pnt.getCoordinates()) - pnt.getDistance();
    }

    private boolean edgeIsContained(Vector list, JgclEmbeddedGraph.Edge edge) {
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            if (!edge.isIdentWith((JgclEmbeddedGraph.Edge)e.nextElement())) continue;
            return true;
        }
        return false;
    }

    private void setMiddlePoint(JgclEmbeddedGraph.Edge edge, JgclEmbeddedGraph.Vertex vrtx1, JgclEmbeddedGraph.Vertex vrtx2, JgclEmbeddedGraph.Vertex newVrtx, JgclPoint2D tgt) {
        JgclIntersectionPoint2D ints;
        VPoint xy1 = (VPoint)vrtx1.getUserData();
        VPoint xy2 = (VPoint)vrtx2.getUserData();
        JgclBoundedLine2D bln1 = new JgclBoundedLine2D(xy1.getCoordinates(), xy2.getCoordinates());
        JgclEmbeddedGraph.Face[] faces = edge.getFaces();
        JgclLine2D lin2 = null;
        JgclPoint2D old = null;
        int i = 0;
        while (i < 2) {
            VRegion rgn = (VRegion)faces[i].getUserData();
            old = rgn.getCoordinates();
            JgclVector2D dir = old.subtract(tgt);
            if (!(dir.length() < JgclConditionOfOperation.getCondition().getToleranceForDistance())) {
                lin2 = new JgclLine2D(old.linearInterpolate(tgt, 0.5), dir.verticalVector());
                break;
            }
            ++i;
        }
        if (lin2 == null) {
            return;
        }
        if (conditionWithSmallDTol == null) {
            conditionWithSmallDTol = JgclConditionOfOperation.getDefaultCondition().makeCopyWithToleranceForDistance(1.0E-8);
        }
        conditionWithSmallDTol.push();
        try {
            ints = bln1.intersect1AsInfiniteLine(lin2);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            ints = null;
        }
        JgclConditionOfOperation.pop();
        JgclPoint2D middlePoint = ints != null ? ints.coordinates() : xy1.getCoordinates().linearInterpolate(xy2.getCoordinates(), 0.5);
        VPoint vpnt = new VPoint(middlePoint);
        newVrtx.setUserData(vpnt);
        vpnt.setDistance(Math.sqrt((tgt.distance2(middlePoint) + old.distance2(middlePoint)) / 2.0));
    }

    private void removeExtraFaces(JgclEmbeddedGraph.Vertex[] extraPoints, VRegion[] extraRegions) {
        Vector<RegionAndFace> RandF = new Vector<RegionAndFace>();
        int i = 0;
        while (i < 3) {
            RandF.addElement(new RegionAndFace(extraRegions[i], extraRegions[i].getFace()));
            ++i;
        }
        i = 0;
        while (i < 3) {
            this.killEdges(extraPoints[i].getEdgeCycleInCCW(), RandF);
            ++i;
        }
        Enumeration e = RandF.elements();
        while (e.hasMoreElements()) {
            RegionAndFace RF = (RegionAndFace)e.nextElement();
            if (RF.faceKilled) continue;
            RF.face.setUserData(null);
        }
    }

    public JgclEmbeddedGraph getGraph() {
        return this.graph;
    }

    public int getNumberOfPairsOfCoincidingRegions() {
        return this.coincidingRegions.size();
    }

    public Enumeration coincidingRegionElements() {
        return this.coincidingRegions.elements();
    }

    public Enumeration regionElements() {
        return new 2(this);
    }

    public Enumeration pointElements() {
        return new 3(this);
    }

    public JgclEmbeddedGraph stripGeometries() {
        Enumeration e = this.graph.vertexElements();
        while (e.hasMoreElements()) {
            JgclEmbeddedGraph.Vertex vrtx = (JgclEmbeddedGraph.Vertex)e.nextElement();
            VPoint pnt = (VPoint)vrtx.getUserData();
            if (pnt == null) continue;
            vrtx.setUserData(pnt.getUserData());
        }
        Enumeration e2 = this.graph.faceElements();
        while (e2.hasMoreElements()) {
            JgclEmbeddedGraph.Face face = (JgclEmbeddedGraph.Face)e2.nextElement();
            VRegion rgn = (VRegion)face.getUserData();
            if (rgn == null) continue;
            face.setUserData(rgn.getUserData());
        }
        this.regions = null;
        this.coincidingRegions = null;
        return this.graph;
    }

    private void debugPrint(String message) {
        System.out.println("// Start of " + message);
        int i = 0;
        Enumeration e = this.graph.vertexElements();
        while (e.hasMoreElements()) {
            JgclEmbeddedGraph.Vertex vrtx = (JgclEmbeddedGraph.Vertex)e.nextElement();
            VPoint vpnt = (VPoint)vrtx.getUserData();
            JgclPoint2D crd = vpnt.getCoordinates();
            System.out.println("JgclCartesianPoint2D\tpnt" + i);
            System.out.println(String.valueOf(crd.x()) + " " + crd.y());
            System.out.println("End");
            ++i;
        }
        i = 0;
        Enumeration e2 = this.graph.edgeElements();
        while (e2.hasMoreElements()) {
            JgclPoint2D crd1;
            JgclEmbeddedGraph.Edge edge = (JgclEmbeddedGraph.Edge)e2.nextElement();
            JgclEmbeddedGraph.Vertex[] vrtcs = edge.getVertices();
            VPoint vpnt0 = (VPoint)vrtcs[0].getUserData();
            VPoint vpnt1 = (VPoint)vrtcs[1].getUserData();
            JgclPoint2D crd0 = vpnt0.getCoordinates();
            if (!crd0.identical(crd1 = vpnt1.getCoordinates())) {
                System.out.println("JgclLine2D\tlin" + i);
                System.out.println("\tpnt\t" + crd0.x() + " " + crd0.y());
                System.out.println("\tpnt\t" + crd1.x() + " " + crd1.y());
                System.out.println("End");
            }
            ++i;
        }
        System.out.println("// End of " + message);
    }

    public static void main(String[] args) {
        JgclPoint2D crd;
        Vector<JgclCartesianPoint2D> points = new Vector<JgclCartesianPoint2D>();
        points.addElement(new JgclCartesianPoint2D(-0.5, -0.5));
        points.addElement(new JgclCartesianPoint2D(0.5, -0.5));
        points.addElement(new JgclCartesianPoint2D(0.5, 0.5));
        points.addElement(new JgclCartesianPoint2D(-0.5, 0.5));
        JgclVoronoiDiagram2D voronoi = new JgclVoronoiDiagram2D(new JgclEmbeddedGraph(), points.elements());
        System.out.println("# Regions");
        Enumeration e = voronoi.regionElements();
        while (e.hasMoreElements()) {
            VRegion rgn = (VRegion)e.nextElement();
            int idx = rgn.getIndex();
            JgclPoint2D crd2 = rgn.getCoordinates();
            System.out.println("# [" + idx + "] " + crd2.x() + ", " + crd2.y());
            Enumeration e1 = rgn.getVPointCycleInCCW();
            while (e1.hasMoreElements()) {
                VPoint pnt1 = (VPoint)e1.nextElement();
                JgclPoint2D crd1 = pnt1.getCoordinates();
                System.out.println("#\t" + crd1.x() + ", " + crd1.y());
            }
        }
        System.out.println("# Coinciding Regions");
        Enumeration e2 = voronoi.coincidingRegionElements();
        while (e2.hasMoreElements()) {
            VRegion rgn = (VRegion)e2.nextElement();
            int idx = rgn.getIndex();
            crd = rgn.getCoordinates();
            System.out.println("# [" + idx + "] " + crd.x() + ", " + crd.y());
            Enumeration e1 = rgn.getVPointCycleInCCW();
            while (e1.hasMoreElements()) {
                VPoint pnt1 = (VPoint)e1.nextElement();
                JgclPoint2D crd1 = pnt1.getCoordinates();
                System.out.println("#\t" + crd1.x() + ", " + crd1.y());
            }
        }
        System.out.println("# Points");
        Enumeration e3 = voronoi.pointElements();
        while (e3.hasMoreElements()) {
            VPoint pnt = (VPoint)e3.nextElement();
            crd = pnt.getCoordinates();
            System.out.println("# " + crd.x() + ", " + crd.y());
        }
        JgclEmbeddedGraph graph = voronoi.getGraph();
        int i = 0;
        Enumeration e4 = graph.edgeElements();
        while (e4.hasMoreElements()) {
            JgclEmbeddedGraph.Edge edge = (JgclEmbeddedGraph.Edge)e4.nextElement();
            JgclEmbeddedGraph.Vertex[] vrtcs = edge.getVertices();
            VPoint vpnt0 = (VPoint)vrtcs[0].getUserData();
            VPoint vpnt1 = (VPoint)vrtcs[1].getUserData();
            JgclPoint2D pnt0 = vpnt0.getCoordinates();
            JgclPoint2D pnt1 = vpnt1.getCoordinates();
            System.out.println("JgclLine2D\tlin" + i);
            System.out.println("\tpnt\t" + pnt0.x() + " " + pnt0.y());
            System.out.println("\tpnt\t" + pnt1.x() + " " + pnt1.y());
            System.out.println("End");
            ++i;
        }
    }

    public class VRegion {
        private int index;
        private JgclPoint2D coordinates;
        private JgclEmbeddedGraph.Face face;
        private Object userData;

        VRegion(int index, JgclPoint2D coordinates) {
            JgclVoronoiDiagram2D.this = JgclVoronoiDiagram2D.this;
            this.index = index;
            this.coordinates = coordinates;
            this.face = null;
            this.userData = null;
        }

        public int getIndex() {
            return this.index;
        }

        public JgclPoint2D getCoordinates() {
            return this.coordinates;
        }

        void setFace(JgclEmbeddedGraph.Face face) {
            this.face = face;
        }

        public JgclEmbeddedGraph.Face getFace() {
            return this.face;
        }

        public void setUserData(Object userData) {
            this.userData = userData;
        }

        public Object getUserData() {
            return this.userData;
        }

        public Enumeration getVPointCycleInCCW() {
            return new 1(this);
        }

        static /* synthetic */ JgclEmbeddedGraph.Face access$0(VRegion $0) {
            return $0.face;
        }
    }

    public class VPoint {
        private JgclPoint2D coordinates;
        private double distance;
        private Object userData;

        VPoint(JgclPoint2D coordinates) {
            JgclVoronoiDiagram2D.this = JgclVoronoiDiagram2D.this;
            this.coordinates = coordinates;
            this.distance = -1.0;
            this.userData = null;
        }

        public JgclPoint2D getCoordinates() {
            return this.coordinates;
        }

        void setDistance(double distance) {
            this.distance = distance;
        }

        public double getDistance() {
            return this.distance;
        }

        public void setUserData(Object userData) {
            this.userData = userData;
        }

        public Object getUserData() {
            return this.userData;
        }
    }

    private class RegionAndFace {
        VRegion rgn;
        JgclEmbeddedGraph.Face face;
        boolean faceKilled;

        RegionAndFace(VRegion rgn, JgclEmbeddedGraph.Face face) {
            JgclVoronoiDiagram2D.this = JgclVoronoiDiagram2D.this;
            this.rgn = rgn;
            this.face = face;
            this.faceKilled = false;
        }

        boolean killFaceIfGivenIsIt(JgclEmbeddedGraph.Face face) {
            if (this.face != face) {
                return false;
            }
            this.faceKilled = true;
            return true;
        }

        void reAssociate(JgclEmbeddedGraph.Face newFace) {
            if (this.faceKilled || this.face == newFace) {
                return;
            }
            Enumeration e = JgclVoronoiDiagram2D.this.coincidingRegions.elements();
            while (e.hasMoreElements()) {
                VRegion ccr = (VRegion)e.nextElement();
                if (ccr.getFace() != this.rgn.getFace()) continue;
                ccr.setFace(this.face);
            }
            this.rgn.setFace(this.face);
            this.face.setUserData(this.rgn);
        }
    }

    private class TVertexInfo {
        JgclEmbeddedGraph.Vertex v;
        private boolean neighborsAreEvaluated;
        TVertexInfo next;

        TVertexInfo(JgclEmbeddedGraph.Vertex v, TVertexInfo next) {
            JgclVoronoiDiagram2D.this = JgclVoronoiDiagram2D.this;
            this.v = v;
            this.next = next;
            this.neighborsAreEvaluated = false;
        }

        private TVertexInfo getTviHasUnevaledNeighbors() {
            TVertexInfo tvi = this;
            while (tvi != null) {
                if (!tvi.neighborsAreEvaluated) {
                    tvi.neighborsAreEvaluated = true;
                    return tvi;
                }
                tvi = tvi.next;
            }
            return null;
        }

        private boolean listHasThisVrtx(JgclEmbeddedGraph.Vertex tgt) {
            TVertexInfo tvi = this;
            while (tvi != null) {
                if (tvi.v == tgt) {
                    return true;
                }
                tvi = tvi.next;
            }
            return false;
        }

        private boolean inspectTopologicalValidity(JgclEmbeddedGraph.Vertex tgt) {
            Vector<JgclEmbeddedGraph.Face> inspectedFaces = new Vector<JgclEmbeddedGraph.Face>();
            TVertexInfo tvi = this;
            while (tvi != null) {
                Enumeration e = tvi.v.getFaceCycleInCCW().elements();
                while (e.hasMoreElements()) {
                    JgclEmbeddedGraph.Face face = (JgclEmbeddedGraph.Face)e.nextElement();
                    if (inspectedFaces.contains(face)) continue;
                    boolean allAreHaved = true;
                    boolean havedByT = false;
                    boolean headIsHaved = false;
                    int connectionCount = 0;
                    Vector vrtcs = face.getVertexCycleInCCW();
                    int nVrtcs = vrtcs.size();
                    int i = 0;
                    while (i < nVrtcs) {
                        JgclEmbeddedGraph.Vertex vrtx = (JgclEmbeddedGraph.Vertex)vrtcs.elementAt(i);
                        if (!this.listHasThisVrtx(vrtx) && vrtx != tgt) {
                            allAreHaved = false;
                            havedByT = false;
                        } else {
                            if (!havedByT) {
                                ++connectionCount;
                            }
                            havedByT = true;
                            if (i == 0) {
                                headIsHaved = true;
                            }
                            if (i == nVrtcs - 1 && headIsHaved && connectionCount > 1) {
                                --connectionCount;
                            }
                        }
                        ++i;
                    }
                    if (allAreHaved || connectionCount > 1) {
                        return false;
                    }
                    inspectedFaces.addElement(face);
                }
                tvi = tvi.next;
            }
            return true;
        }
    }

    private class PointIsExtra
    extends JgclException {
        protected PointIsExtra() {
            JgclVoronoiDiagram2D.this = JgclVoronoiDiagram2D.this;
        }

        public PointIsExtra(String s) {
            super(s);
            JgclVoronoiDiagram2D.this = JgclVoronoiDiagram2D.this;
        }
    }

    private final class 2
    implements Enumeration {
        Enumeration e;
        Object nextNonOuterFace;

        public boolean hasMoreElements() {
            if (this.nextNonOuterFace != null) {
                return true;
            }
            if (!this.e.hasMoreElements()) {
                return false;
            }
            Object obj = this.e.nextElement();
            if (((JgclEmbeddedGraph.Face)obj).getUserData() != null) {
                this.nextNonOuterFace = obj;
                return true;
            }
            this.nextNonOuterFace = null;
            return this.e.hasMoreElements();
        }

        public Object nextElement() {
            if (this.nextNonOuterFace != null) {
                Object obj = this.nextNonOuterFace;
                this.nextNonOuterFace = null;
                return ((JgclEmbeddedGraph.Face)obj).getUserData();
            }
            Object obj = this.e.nextElement();
            if (((JgclEmbeddedGraph.Face)obj).getUserData() != null) {
                return ((JgclEmbeddedGraph.Face)obj).getUserData();
            }
            return ((JgclEmbeddedGraph.Face)this.e.nextElement()).getUserData();
        }

        /* synthetic */ 2(JgclVoronoiDiagram2D this$0) {
            this.e = this$0.graph.faceElements();
        }
    }

    private final class 3
    implements Enumeration {
        Enumeration e;

        public boolean hasMoreElements() {
            return this.e.hasMoreElements();
        }

        public Object nextElement() {
            return ((JgclEmbeddedGraph.Vertex)this.e.nextElement()).getUserData();
        }

        /* synthetic */ 3(JgclVoronoiDiagram2D this$0) {
            this.e = this$0.graph.vertexElements();
        }
    }
}

