/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Enumeration;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclBooleanFunctionWithRealVariables;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclIntersectionCurve3D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclLiteralVector2D;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclNullArgument;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParametricSurface;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclRealFunction;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterference3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclVector3D;

class JgclSurfaceSurfaceInterferenceList {
    static int debugFlag;
    static final int DEBUG_TRACE = 1;
    static final int OMIT_BOUNDARY_CHECK = 2;
    static final boolean REMOVE_NO_LENGTH_SEGMENT = false;
    JgclParametricSurface3D surfaceA;
    JgclParameterDomain uParameterDomainA;
    JgclParameterDomain vParameterDomainA;
    JgclParametricSurface3D surfaceB;
    JgclParameterDomain uParameterDomainB;
    JgclParameterDomain vParameterDomainB;
    JgclToleranceForDistance dTol;
    Vector listOfPoints;
    Vector listOfCurves;
    Vector listOfCurveSegments;
    private static final int PARAMETERS_NOT_IDENTICAL = 0;
    private static final int PARAMETERS_IDENTICAL = 1;
    private static final int PARAMETERS_CROSSBOUNDARY_U_A = 2;
    private static final int PARAMETERS_CROSSBOUNDARY_V_A = 4;
    private static final int PARAMETERS_CROSSBOUNDARY_U_B = 8;
    private static final int PARAMETERS_CROSSBOUNDARY_V_B = 16;
    static final int Wp_No = 0;
    static final int Wp_Au = 1;
    static final int Wp_Av = 2;
    static final int Wp_Bu = 3;
    static final int Wp_Bv = 4;
    static final int Wp_START = 1;
    static final int Wp_END = 5;
    static final int LOWER = 0;
    static final int UPPER = 1;
    static final int Wside_START = 0;
    static final int Wside_END = 2;
    private RefineInfo ri;
    static final int SAMEP_MAX_RETRY = 4;

    JgclSurfaceSurfaceInterferenceList(JgclParametricSurface3D surfaceA, JgclParametricSurface3D surfaceB) {
        if (surfaceA == null || surfaceB == null) {
            throw new JgclNullArgument();
        }
        this.surfaceA = surfaceA;
        this.uParameterDomainA = surfaceA.uParameterDomain();
        this.vParameterDomainA = surfaceA.vParameterDomain();
        this.surfaceB = surfaceB;
        this.uParameterDomainB = surfaceB.uParameterDomain();
        this.vParameterDomainB = surfaceB.vParameterDomain();
        JgclConditionOfOperation cond = JgclConditionOfOperation.getCondition();
        this.dTol = cond.getToleranceForDistanceAsObject();
        this.listOfPoints = new Vector();
        this.listOfCurves = new Vector();
        this.listOfCurveSegments = new Vector();
    }

    private double getToleranceForParameterU(JgclParametricSurface surface, double uParam, double vParam) {
        return this.dTol.toToleranceForParameterU((JgclParametricSurface3D)surface, uParam, vParam).value();
    }

    private static double adjustParam(JgclParameterDomain domain, double param, double lastParam) {
        if (domain.isNonPeriodic()) {
            return param;
        }
        double absInc = domain.section().absIncrease();
        double threshold = lastParam - absInc / 2.0;
        while (param < threshold) {
            param += absInc;
        }
        threshold = lastParam + absInc / 2.0;
        while (param > threshold) {
            param -= absInc;
        }
        return param;
    }

    private static boolean checkClosed2D(JgclParameterDomain uDomain, JgclParameterDomain vDomain, double uSParam, double vSParam, double uEParam, double vEParam, boolean closed3D) {
        if (!closed3D) {
            return false;
        }
        if (uDomain.isPeriodic() && Math.abs(uEParam - uSParam) > uDomain.section().absIncrease() / 2.0) {
            return false;
        }
        return !vDomain.isPeriodic() || !(Math.abs(vEParam - vSParam) > vDomain.section().absIncrease() / 2.0);
    }

    private double getToleranceForParameterV(JgclParametricSurface surface, double uParam, double vParam) {
        return this.dTol.toToleranceForParameterV((JgclParametricSurface3D)surface, uParam, vParam).value();
    }

    private double[] setupParams(PointInfo pi, PointInfo b_pi) {
        BoundaryInfo bi = this.ri.bi = new BoundaryInfo(0, pi);
        if (bi.param == 0) {
            double Au_gap = Math.abs(pi.uParamA - b_pi.uParamA);
            double Av_gap = Math.abs(pi.vParamA - b_pi.vParamA);
            double Bu_gap = Math.abs(pi.uParamB - b_pi.uParamB);
            double Bv_gap = Math.abs(pi.vParamB - b_pi.vParamB);
            double c_gap = Au_gap;
            bi.param = 1;
            if (c_gap < Av_gap) {
                c_gap = Av_gap;
                bi.param = 2;
            }
            if (c_gap < Bu_gap) {
                c_gap = Bu_gap;
                bi.param = 3;
            }
            if (c_gap < Bv_gap) {
                c_gap = Bv_gap;
                bi.param = 4;
            }
        } else {
            BoundaryInfo b_bi = new BoundaryInfo(0, b_pi);
            double pTol = JgclConditionOfOperation.getCondition().getToleranceForParameter();
            if (b_bi.param == bi.param && b_bi.wend == bi.wend || b_bi.param == 0) {
                switch (bi.param) {
                    case 1: {
                        if (!(Math.abs(pi.uParamA - b_pi.uParamA) < pTol) || !(Math.abs(pi.vParamA - b_pi.vParamA) > pTol)) break;
                        bi.param = 2;
                        break;
                    }
                    case 2: {
                        if (!(Math.abs(pi.vParamA - b_pi.vParamA) < pTol) || !(Math.abs(pi.uParamA - b_pi.uParamA) > pTol)) break;
                        bi.param = 1;
                        break;
                    }
                    case 3: {
                        if (!(Math.abs(pi.uParamB - b_pi.uParamB) < pTol) || !(Math.abs(pi.vParamB - b_pi.vParamB) > pTol)) break;
                        bi.param = 4;
                        break;
                    }
                    case 4: {
                        if (!(Math.abs(pi.vParamB - b_pi.vParamB) < pTol) || !(Math.abs(pi.uParamB - b_pi.uParamB) > pTol)) break;
                        bi.param = 3;
                        break;
                    }
                }
            }
        }
        return this.ri.setupParams(pi);
    }

    private double[] reSetupParams(PointInfo pi) {
        BoundaryInfo bi = this.ri.bi;
        BoundaryInfo nbi = new BoundaryInfo(bi.param, pi);
        if (nbi.param == bi.param) {
            switch (nbi.param) {
                case 1: {
                    nbi.param = 2;
                    break;
                }
                case 2: {
                    nbi.param = 1;
                    break;
                }
                case 3: {
                    nbi.param = 4;
                    break;
                }
                case 4: {
                    nbi.param = 3;
                    break;
                }
            }
        }
        this.ri.bi = nbi;
        return this.ri.setupParams(pi);
    }

    private void clipParam(int n, double[] param) {
        if (param[n] < 0.0) {
            param[n] = 0.0;
        }
        if (param[n] > 1.0) {
            param[n] = 1.0;
        }
    }

    private boolean setbackParams(PointInfo pi, double[] param, PointInfo b_pi, PointInfo a_pi) {
        double[] A_param = new double[2];
        double[] B_param = new double[2];
        switch (this.ri.bi.param) {
            case 1: {
                this.clipParam(1, param);
                this.clipParam(2, param);
                A_param[0] = pi.uParamA;
                A_param[1] = param[0];
                B_param[0] = param[1];
                B_param[1] = param[2];
                break;
            }
            case 2: {
                this.clipParam(1, param);
                this.clipParam(2, param);
                A_param[0] = param[0];
                A_param[1] = pi.vParamA;
                B_param[0] = param[1];
                B_param[1] = param[2];
                break;
            }
            case 3: {
                this.clipParam(2, param);
                A_param[0] = param[0];
                A_param[1] = param[1];
                B_param[0] = pi.uParamB;
                B_param[1] = param[2];
                break;
            }
            case 4: {
                this.clipParam(2, param);
                A_param[0] = param[0];
                A_param[1] = param[1];
                B_param[0] = param[2];
                B_param[1] = pi.vParamB;
                break;
            }
        }
        JgclLiteralVector2D evec1 = new JgclLiteralVector2D(A_param[0] - b_pi.uParamA, A_param[1] - b_pi.vParamA);
        JgclLiteralVector2D evec2 = new JgclLiteralVector2D(pi.uParamA - b_pi.uParamA, pi.vParamA - b_pi.vParamA);
        if (evec1.dotProduct(evec2) < 0.0) {
            return false;
        }
        evec1 = new JgclLiteralVector2D(A_param[0] - a_pi.uParamA, A_param[1] - a_pi.vParamA);
        evec2 = new JgclLiteralVector2D(pi.uParamA - a_pi.uParamA, pi.vParamA - a_pi.vParamA);
        if (evec1.dotProduct(evec2) < 0.0) {
            return false;
        }
        evec1 = new JgclLiteralVector2D(B_param[0] - b_pi.uParamB, B_param[1] - b_pi.vParamB);
        evec2 = new JgclLiteralVector2D(pi.uParamB - b_pi.uParamB, pi.vParamB - b_pi.vParamB);
        if (evec1.dotProduct(evec2) < 0.0) {
            return false;
        }
        evec1 = new JgclLiteralVector2D(B_param[0] - a_pi.uParamB, B_param[1] - a_pi.vParamB);
        evec2 = new JgclLiteralVector2D(pi.uParamB - a_pi.uParamB, pi.vParamB - a_pi.vParamB);
        if (evec1.dotProduct(evec2) < 0.0) {
            return false;
        }
        pi.uParamA = A_param[0];
        pi.vParamA = A_param[1];
        pi.uParamB = B_param[0];
        pi.vParamB = B_param[1];
        return true;
    }

    private boolean refinePointInfo(PointInfo pinfo, PointInfo b_pinfo, PointInfo a_pinfo, boolean do_retry) {
        this.ri = new RefineInfo();
        nlFunc nl_func = new nlFunc();
        JgclRealFunction[] dnl_func = new JgclRealFunction[]{new dnlFunc(0), new dnlFunc(1), new dnlFunc(2)};
        cnvFunc cnv_func = new cnvFunc();
        double[] param = this.setupParams(pinfo, b_pinfo);
        if ((param = JgclMath.solveSimultaneousEquations(nl_func, dnl_func, cnv_func, param)) == null && do_retry) {
            param = this.reSetupParams(pinfo);
            param = JgclMath.solveSimultaneousEquations(nl_func, dnl_func, cnv_func, param);
        }
        if (param == null) {
            return false;
        }
        return this.setbackParams(pinfo, param, b_pinfo, a_pinfo);
    }

    void addIntersectionPoint(PointInfo theIntersection) {
        Enumeration e = this.listOfPoints.elements();
        while (e.hasMoreElements()) {
            if (!theIntersection.isIdenticalWith((PointInfo)e.nextElement())) continue;
            return;
        }
        this.listOfPoints.addElement(theIntersection);
    }

    void addAsIntersectionPoint(JgclPoint3D coord, double uParamA, double vParamA, double uParamB, double vParamB) {
        if ((debugFlag & 1) != 0) {
            coord.output(System.out);
            this.surfaceA.coordinates(uParamA, vParamA).output(System.out);
            this.surfaceB.coordinates(uParamB, vParamB).output(System.out);
        }
        this.addIntersectionPoint(new PointInfo(coord, uParamA, vParamA, uParamB, vParamB));
    }

    void addAsIntersectionPoint(JgclPoint3D coord, double uParamA, double vParamA, double uParamB, double vParamB, double pTolAu, double pTolAv, double pTolBu, double pTolBv) {
        this.addIntersectionPoint(new PointInfo(coord, uParamA, vParamA, uParamB, vParamB, pTolAu, pTolAv, pTolBu, pTolBv));
    }

    void addCurve(CurveSegmentInfo theCurve) {
        this.listOfCurveSegments.addElement(theCurve);
    }

    void addAsIntersectionCurve(JgclPolyline3D pol3, JgclPolyline2D pol2A, JgclPolyline2D pol2B) {
        this.addCurve(new CurveSegmentInfo(pol3, pol2A, pol2B));
    }

    void addAsIntersectionCurve(JgclPolyline3D pol3, JgclPolyline2D pol2A, JgclPolyline2D pol2B, double headPTolAu, double headPTolAv, double headPTolBu, double headPTolBv, double tailPTolAu, double tailPTolAv, double tailPTolBu, double tailPTolBv) {
        this.addCurve(new CurveSegmentInfo(pol3, pol2A, pol2B, headPTolAu, headPTolAv, headPTolBu, headPTolBv, tailPTolAu, tailPTolAv, tailPTolBu, tailPTolBv));
    }

    void connectIntersectionCurves() {
        CurveSegmentInfo ci2;
        int j;
        CurveSegmentInfo ci1;
        int nCurves = this.listOfCurveSegments.size();
        int i = 0;
        while (i < nCurves) {
            ci1 = (CurveSegmentInfo)this.listOfCurveSegments.elementAt(i);
            j = i + 1;
            while (j < nCurves) {
                ci2 = (CurveSegmentInfo)this.listOfCurveSegments.elementAt(j);
                ci1.isSamePolyline(ci2);
                ++j;
            }
            ++i;
        }
        nCurves = this.listOfCurveSegments.size();
        i = 0;
        while (i < nCurves) {
            ci1 = (CurveSegmentInfo)this.listOfCurveSegments.elementAt(i);
            if (!ci1.isKilled()) {
                j = i + 1;
                while (j < nCurves) {
                    ci2 = (CurveSegmentInfo)this.listOfCurveSegments.elementAt(j);
                    if (!ci2.isKilled() && ci2.nPoints() < ci1.nPoints()) {
                        this.listOfCurveSegments.setElementAt(ci2, i);
                        this.listOfCurveSegments.setElementAt(ci1, j);
                        ci1 = ci2;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < nCurves) {
            ci1 = (CurveSegmentInfo)this.listOfCurveSegments.elementAt(i);
            if (!ci1.isKilled()) {
                boolean is_closed;
                boolean found;
                CurveInfo oneCurve = new CurveInfo(ci1);
                block5: do {
                    found = false;
                    j = i + 1;
                    while (!(is_closed = oneCurve.isClosed()) && j < nCurves) {
                        ci2 = (CurveSegmentInfo)this.listOfCurveSegments.elementAt(j);
                        if (!ci2.isKilled() && oneCurve.mergeIfConnectWith(ci2)) {
                            found = true;
                            continue block5;
                        }
                        ++j;
                    }
                } while (found);
                if (is_closed || oneCurve.isComplete()) {
                    this.listOfCurves.addElement(oneCurve);
                }
            }
            ++i;
        }
    }

    void refine() {
        Enumeration e = this.listOfCurves.elements();
        while (e.hasMoreElements()) {
            CurveInfo ints = (CurveInfo)e.nextElement();
            ints.refine();
        }
    }

    JgclSurfaceSurfaceInterference3D[] toJgclSurfaceSurfaceInterference3DArray(boolean doExchange) {
        int totalSize = this.listOfPoints.size() + this.listOfCurves.size();
        JgclSurfaceSurfaceInterference3D[] result = new JgclSurfaceSurfaceInterference3D[totalSize];
        int i = 0;
        Enumeration e = this.listOfPoints.elements();
        while (e.hasMoreElements()) {
            PointInfo ints = (PointInfo)e.nextElement();
            if (!doExchange) {
                result[i++] = ints.coord == null ? new JgclIntersectionPoint3D(this.surfaceA, ints.uParamA, ints.vParamA, this.surfaceB, ints.uParamB, ints.vParamB, false) : new JgclIntersectionPoint3D(ints.coord, this.surfaceA, ints.uParamA, ints.vParamA, this.surfaceB, ints.uParamB, ints.vParamB, false);
                continue;
            }
            JgclSurfaceSurfaceInterference3D jgclSurfaceSurfaceInterference3D = result[i++] = ints.coord == null ? new JgclIntersectionPoint3D(this.surfaceB, ints.uParamB, ints.vParamB, this.surfaceA, ints.uParamA, ints.vParamA, false) : new JgclIntersectionPoint3D(ints.coord, this.surfaceB, ints.uParamB, ints.vParamB, this.surfaceA, ints.uParamA, ints.vParamA, false);
        }
        Enumeration e2 = this.listOfCurves.elements();
        while (e2.hasMoreElements()) {
            CurveInfo ints = (CurveInfo)e2.nextElement();
            result[i++] = ints.getIntersection(doExchange);
        }
        return result;
    }

    static /* synthetic */ int access$6() {
        return 0;
    }

    static /* synthetic */ int access$7() {
        return 1;
    }

    static /* synthetic */ int access$8() {
        return 2;
    }

    static /* synthetic */ int access$9() {
        return 4;
    }

    static /* synthetic */ int access$10() {
        return 8;
    }

    static /* synthetic */ int access$11() {
        return 16;
    }

    class ParametricalIdentityOfTwoIntersections {
        private int value;

        ParametricalIdentityOfTwoIntersections() {
            JgclSurfaceSurfaceInterferenceList.this = JgclSurfaceSurfaceInterferenceList.this;
            this.setNonIdentical();
        }

        private void setNonIdentical() {
            this.value = JgclSurfaceSurfaceInterferenceList.access$6();
        }

        private void setIdentical() {
            this.value |= JgclSurfaceSurfaceInterferenceList.access$7();
        }

        private void setCrossBoundaryOfAu() {
            this.value |= JgclSurfaceSurfaceInterferenceList.access$8();
        }

        private void setCrossBoundaryOfAv() {
            this.value |= JgclSurfaceSurfaceInterferenceList.access$9();
        }

        private void setCrossBoundaryOfBu() {
            this.value |= JgclSurfaceSurfaceInterferenceList.access$10();
        }

        private void setCrossBoundaryOfBv() {
            this.value |= JgclSurfaceSurfaceInterferenceList.access$11();
        }

        private boolean isIdentical() {
            return (this.value & JgclSurfaceSurfaceInterferenceList.access$7()) != 0;
        }

        private boolean isCrossBoundaryOfAu() {
            return (this.value & JgclSurfaceSurfaceInterferenceList.access$8()) != 0;
        }

        private boolean isCrossBoundaryOfAv() {
            return (this.value & JgclSurfaceSurfaceInterferenceList.access$9()) != 0;
        }

        private boolean isCrossBoundaryOfBu() {
            return (this.value & JgclSurfaceSurfaceInterferenceList.access$10()) != 0;
        }

        private boolean isCrossBoundaryOfBv() {
            return (this.value & JgclSurfaceSurfaceInterferenceList.access$11()) != 0;
        }
    }

    class PointInfo {
        JgclPoint3D coord;
        double uParamA;
        double vParamA;
        double uParamB;
        double vParamB;
        double pTolAu;
        double pTolAv;
        double pTolBu;
        double pTolBv;

        PointInfo(JgclPoint3D coord, double uParamA, double vParamA, double uParamB, double vParamB) {
            JgclSurfaceSurfaceInterferenceList.this = JgclSurfaceSurfaceInterferenceList.this;
            this.coord = coord;
            this.uParamA = uParamA;
            this.vParamA = vParamA;
            this.uParamB = uParamB;
            this.vParamB = vParamB;
            this.pTolAu = JgclSurfaceSurfaceInterferenceList.this.getToleranceForParameterU(JgclSurfaceSurfaceInterferenceList.this.surfaceA, uParamA, vParamA);
            this.pTolAv = JgclSurfaceSurfaceInterferenceList.this.getToleranceForParameterV(JgclSurfaceSurfaceInterferenceList.this.surfaceA, uParamA, vParamA);
            this.pTolBu = JgclSurfaceSurfaceInterferenceList.this.getToleranceForParameterU(JgclSurfaceSurfaceInterferenceList.this.surfaceB, uParamB, vParamB);
            this.pTolBv = JgclSurfaceSurfaceInterferenceList.this.getToleranceForParameterV(JgclSurfaceSurfaceInterferenceList.this.surfaceB, uParamB, vParamB);
        }

        PointInfo(JgclPoint3D coord, double uParamA, double vParamA, double uParamB, double vParamB, double pTolAu, double pTolAv, double pTolBu, double pTolBv) {
            JgclSurfaceSurfaceInterferenceList.this = JgclSurfaceSurfaceInterferenceList.this;
            this.coord = coord;
            this.uParamA = uParamA;
            this.vParamA = vParamA;
            this.uParamB = uParamB;
            this.vParamB = vParamB;
            this.pTolAu = pTolAu;
            this.pTolAv = pTolAv;
            this.pTolBu = pTolBu;
            this.pTolBv = pTolBv;
        }

        private JgclPoint3D coordinates() {
            if (this.coord != null) {
                return this.coord;
            }
            JgclPoint3D pntA = JgclSurfaceSurfaceInterferenceList.this.surfaceA.coordinates(this.uParamA, this.vParamA);
            JgclPoint3D pntB = JgclSurfaceSurfaceInterferenceList.this.surfaceB.coordinates(this.uParamB, this.vParamB);
            return pntA.linearInterpolate(pntB, 0.5);
        }

        private ParametricalIdentityOfTwoIntersections getParametricalIdentityWith(PointInfo mate) {
            ParametricalIdentityOfTwoIntersections result = new ParametricalIdentityOfTwoIntersections();
            if (this == mate) {
                result.setIdentical();
                return result;
            }
            double diffAu = Math.abs(this.uParamA - mate.uParamA);
            double diffAv = Math.abs(this.vParamA - mate.vParamA);
            double diffBu = Math.abs(this.uParamB - mate.uParamB);
            double diffBv = Math.abs(this.vParamB - mate.vParamB);
            double pTolAu = Math.max(this.pTolAu, mate.pTolAu);
            double pTolAv = Math.max(this.pTolAv, mate.pTolAv);
            double pTolBu = Math.max(this.pTolBu, mate.pTolBu);
            double pTolBv = Math.max(this.pTolBv, mate.pTolBv);
            if (JgclSurfaceSurfaceInterferenceList.this.uParameterDomainA.isPeriodic() && Math.abs(diffAu - JgclSurfaceSurfaceInterferenceList.this.uParameterDomainA.section().absIncrease()) < pTolAu) {
                result.setCrossBoundaryOfAu();
            }
            if (JgclSurfaceSurfaceInterferenceList.this.vParameterDomainA.isPeriodic() && Math.abs(diffAv - JgclSurfaceSurfaceInterferenceList.this.vParameterDomainA.section().absIncrease()) < pTolAv) {
                result.setCrossBoundaryOfAv();
            }
            if (JgclSurfaceSurfaceInterferenceList.this.uParameterDomainB.isPeriodic() && Math.abs(diffBu - JgclSurfaceSurfaceInterferenceList.this.uParameterDomainB.section().absIncrease()) < pTolBu) {
                result.setCrossBoundaryOfBu();
            }
            if (JgclSurfaceSurfaceInterferenceList.this.vParameterDomainB.isPeriodic() && Math.abs(diffBv - JgclSurfaceSurfaceInterferenceList.this.vParameterDomainB.section().absIncrease()) < pTolBv) {
                result.setCrossBoundaryOfBv();
            }
            if ((result.isCrossBoundaryOfAu() || diffAu < pTolAu) && (result.isCrossBoundaryOfAv() || diffAv < pTolAv) && (result.isCrossBoundaryOfBu() || diffBu < pTolBu) && (result.isCrossBoundaryOfBv() || diffBv < pTolBv)) {
                result.setIdentical();
            }
            return result;
        }

        private boolean isIdenticalWith(PointInfo mate) {
            if (this.coord != null && mate.coord != null && !this.coord.identical(mate.coord)) {
                return false;
            }
            return this.getParametricalIdentityWith(mate).isIdentical();
        }

        private boolean isBoundary() {
            int i = 0;
            while (i < 8) {
                block6: {
                    double v_param_b;
                    double u_param_b;
                    double v_param_a;
                    double u_param_a;
                    block7: {
                        block9: {
                            block8: {
                                block5: {
                                    u_param_a = this.uParamA;
                                    v_param_a = this.vParamA;
                                    u_param_b = this.uParamB;
                                    v_param_b = this.vParamB;
                                    if (i >= 2) break block5;
                                    if (JgclSurfaceSurfaceInterferenceList.this.uParameterDomainA.isPeriodic() || JgclSurfaceSurfaceInterferenceList.this.uParameterDomainA.isInfinite()) break block6;
                                    u_param_a = i == 0 ? JgclSurfaceSurfaceInterferenceList.this.uParameterDomainA.section().start() : JgclSurfaceSurfaceInterferenceList.this.uParameterDomainA.section().end();
                                    break block7;
                                }
                                if (i >= 4) break block8;
                                if (JgclSurfaceSurfaceInterferenceList.this.vParameterDomainA.isPeriodic() || JgclSurfaceSurfaceInterferenceList.this.vParameterDomainA.isInfinite()) break block6;
                                v_param_a = i == 2 ? JgclSurfaceSurfaceInterferenceList.this.vParameterDomainA.section().start() : JgclSurfaceSurfaceInterferenceList.this.vParameterDomainA.section().end();
                                break block7;
                            }
                            if (i >= 6) break block9;
                            if (JgclSurfaceSurfaceInterferenceList.this.uParameterDomainB.isPeriodic() || JgclSurfaceSurfaceInterferenceList.this.uParameterDomainB.isInfinite()) break block6;
                            u_param_b = i == 4 ? JgclSurfaceSurfaceInterferenceList.this.uParameterDomainB.section().start() : JgclSurfaceSurfaceInterferenceList.this.uParameterDomainB.section().end();
                            break block7;
                        }
                        if (JgclSurfaceSurfaceInterferenceList.this.vParameterDomainB.isPeriodic() || JgclSurfaceSurfaceInterferenceList.this.vParameterDomainB.isInfinite()) break block6;
                        v_param_b = i == 6 ? JgclSurfaceSurfaceInterferenceList.this.vParameterDomainB.section().start() : JgclSurfaceSurfaceInterferenceList.this.vParameterDomainB.section().end();
                    }
                    PointInfo pinfo = new PointInfo(null, u_param_a, v_param_a, u_param_b, v_param_b);
                    if (this.isIdenticalWith(pinfo)) {
                        return true;
                    }
                }
                ++i;
            }
            return false;
        }

        private double getBoundaryGap(int which, int side) {
            double para;
            switch (which) {
                default: {
                    throw new JgclFatal();
                }
                case 1: {
                    para = this.uParamA;
                    break;
                }
                case 2: {
                    para = this.vParamA;
                    break;
                }
                case 3: {
                    para = this.uParamB;
                    break;
                }
                case 4: {
                    para = this.vParamB;
                }
            }
            if (side == 1) {
                return Math.abs(1.0 - para);
            }
            return Math.abs(para);
        }
    }

    final class BoundaryInfo {
        int wend;
        int param;
        boolean is_boundary;
        PointInfo pi;

        void setBoundaryInfo(double gap) {
            int i = 1;
            while (i < 5) {
                int j = 0;
                while (j < 2) {
                    double g = this.pi.getBoundaryGap(i, j);
                    if (g < gap && this.param != i) {
                        gap = g;
                        this.param = i;
                        this.wend = j;
                    }
                    ++j;
                }
                ++i;
            }
        }

        BoundaryInfo(int ref_param, PointInfo pi) {
            JgclSurfaceSurfaceInterferenceList.this = JgclSurfaceSurfaceInterferenceList.this;
            double pTol = JgclConditionOfOperation.getCondition().getToleranceForParameter();
            this.param = ref_param;
            this.is_boundary = true;
            this.pi = pi;
            this.setBoundaryInfo(pTol);
        }
    }

    final class RefineInfo {
        JgclPoint3D sA_pnt;
        JgclPoint3D sB_pnt;
        JgclVector3D[] Atang;
        JgclVector3D[] Btang;
        double fx_param;
        BoundaryInfo bi;

        RefineInfo() {
            JgclSurfaceSurfaceInterferenceList.this = JgclSurfaceSurfaceInterferenceList.this;
        }

        double[] setupParams(PointInfo pi) {
            double[] param = new double[3];
            switch (this.bi.param) {
                case 1: {
                    this.fx_param = pi.uParamA;
                    param[0] = pi.vParamA;
                    param[1] = pi.uParamB;
                    param[2] = pi.vParamB;
                    break;
                }
                case 2: {
                    param[0] = pi.uParamA;
                    this.fx_param = pi.vParamA;
                    param[1] = pi.uParamB;
                    param[2] = pi.vParamB;
                    break;
                }
                case 3: {
                    param[0] = pi.uParamA;
                    param[1] = pi.vParamA;
                    this.fx_param = pi.uParamB;
                    param[2] = pi.vParamB;
                    break;
                }
                case 4: {
                    param[0] = pi.uParamA;
                    param[1] = pi.vParamA;
                    param[2] = pi.uParamB;
                    this.fx_param = pi.vParamB;
                    break;
                }
            }
            return param;
        }

        void fillParam(double[] param) {
            double[] A = new double[2];
            double[] B = new double[2];
            switch (this.bi.param) {
                case 1: {
                    A[0] = this.fx_param;
                    A[1] = param[0];
                    B[0] = param[1];
                    B[1] = param[2];
                    break;
                }
                case 2: {
                    A[0] = param[0];
                    A[1] = this.fx_param;
                    B[0] = param[1];
                    B[1] = param[2];
                    break;
                }
                case 3: {
                    A[0] = param[0];
                    A[1] = param[1];
                    B[0] = this.fx_param;
                    B[1] = param[2];
                    break;
                }
                case 4: {
                    A[0] = param[0];
                    A[1] = param[1];
                    B[0] = param[2];
                    B[1] = this.fx_param;
                    break;
                }
            }
            A[0] = JgclSurfaceSurfaceInterferenceList.this.surfaceA.uParameterDomain().force(A[0]);
            A[1] = JgclSurfaceSurfaceInterferenceList.this.surfaceA.vParameterDomain().force(A[1]);
            B[0] = JgclSurfaceSurfaceInterferenceList.this.surfaceB.uParameterDomain().force(B[0]);
            B[1] = JgclSurfaceSurfaceInterferenceList.this.surfaceB.vParameterDomain().force(B[1]);
            this.sA_pnt = JgclSurfaceSurfaceInterferenceList.this.surfaceA.coordinates(A[0], A[1]);
            this.sB_pnt = JgclSurfaceSurfaceInterferenceList.this.surfaceB.coordinates(B[0], B[1]);
            this.Atang = JgclSurfaceSurfaceInterferenceList.this.surfaceA.tangentVector(A[0], A[1]);
            this.Btang = JgclSurfaceSurfaceInterferenceList.this.surfaceB.tangentVector(B[0], B[1]);
            this.Btang[0] = this.Btang[0].multiply(-1.0);
            this.Btang[1] = this.Btang[1].multiply(-1.0);
        }

        JgclVector3D[] getVectors() {
            JgclVector3D[] vecs = null;
            switch (this.bi.param) {
                case 1: {
                    JgclVector3D[] v;
                    vecs = v = new JgclVector3D[]{this.Atang[1], this.Btang[0], this.Btang[1]};
                    break;
                }
                case 2: {
                    JgclVector3D[] v = new JgclVector3D[]{this.Atang[0], this.Btang[0], this.Btang[1]};
                    vecs = v;
                    break;
                }
                case 3: {
                    JgclVector3D[] v = new JgclVector3D[]{this.Atang[0], this.Atang[1], this.Btang[1]};
                    vecs = v;
                    break;
                }
                case 4: {
                    JgclVector3D[] v = new JgclVector3D[]{this.Atang[0], this.Atang[1], this.Btang[0]};
                    vecs = v;
                    break;
                }
            }
            return vecs;
        }
    }

    private class nlFunc
    implements JgclRealFunction {
        private nlFunc() {
            JgclSurfaceSurfaceInterferenceList.this = JgclSurfaceSurfaceInterferenceList.this;
        }

        public double[] evaluate(double[] parameter) {
            double[] vctr = new double[3];
            JgclVector3D evec = ((JgclSurfaceSurfaceInterferenceList)JgclSurfaceSurfaceInterferenceList.this).ri.sA_pnt.subtract(((JgclSurfaceSurfaceInterferenceList)JgclSurfaceSurfaceInterferenceList.this).ri.sB_pnt);
            vctr[0] = evec.x();
            vctr[1] = evec.y();
            vctr[2] = evec.z();
            return vctr;
        }
    }

    private class dnlFunc
    implements JgclRealFunction {
        int idx;

        private dnlFunc(int idx) {
            JgclSurfaceSurfaceInterferenceList.this = JgclSurfaceSurfaceInterferenceList.this;
            this.idx = idx;
        }

        public double[] evaluate(double[] parameter) {
            JgclVector3D[] vecs = JgclSurfaceSurfaceInterferenceList.this.ri.getVectors();
            double[] mtrx = new double[3];
            int i = 0;
            while (i < 3) {
                switch (this.idx) {
                    default: {
                        mtrx[i] = vecs[i].x();
                        break;
                    }
                    case 1: {
                        mtrx[i] = vecs[i].y();
                        break;
                    }
                    case 2: {
                        mtrx[i] = vecs[i].z();
                        break;
                    }
                }
                ++i;
            }
            return mtrx;
        }
    }

    private class cnvFunc
    implements JgclBooleanFunctionWithRealVariables {
        private cnvFunc() {
            JgclSurfaceSurfaceInterferenceList.this = JgclSurfaceSurfaceInterferenceList.this;
        }

        public boolean evaluate(double[] parameter) {
            JgclSurfaceSurfaceInterferenceList.this.ri.fillParam(parameter);
            return ((JgclSurfaceSurfaceInterferenceList)JgclSurfaceSurfaceInterferenceList.this).ri.sA_pnt.identical(((JgclSurfaceSurfaceInterferenceList)JgclSurfaceSurfaceInterferenceList.this).ri.sB_pnt);
        }
    }

    class CurveInfo {
        Vector segments = new Vector();

        private CurveInfo(CurveSegmentInfo firstSegment) {
            JgclSurfaceSurfaceInterferenceList.this = JgclSurfaceSurfaceInterferenceList.this;
            this.segments.addElement(firstSegment);
        }

        private int nPoints() {
            int nPoints = this.segmentAt(0).nPoints();
            int i = 1;
            while (i < this.nSegments()) {
                nPoints += this.segmentAt(i).nPoints() - 1;
                ++i;
            }
            return nPoints;
        }

        private int nSegments() {
            return this.segments.size();
        }

        private CurveSegmentInfo segmentAt(int index) {
            return (CurveSegmentInfo)this.segments.elementAt(index);
        }

        private PointInfo headPoint() {
            CurveSegmentInfo headSeg = (CurveSegmentInfo)this.segments.elementAt(0);
            return headSeg.headPoint();
        }

        private PointInfo tailPoint() {
            CurveSegmentInfo tailSeg = (CurveSegmentInfo)this.segments.elementAt(this.nSegments() - 1);
            return tailSeg.tailPoint();
        }

        private boolean isClosed() {
            if (this.nPoints() <= 2) {
                return false;
            }
            return this.headPoint().isIdenticalWith(this.tailPoint());
        }

        private boolean isComplete() {
            if ((debugFlag & 2) != 0) {
                return true;
            }
            return this.headPoint().isBoundary() && this.tailPoint().isBoundary();
        }

        private boolean addAtHead(CurveSegmentInfo mate) {
            ParametricalIdentityOfTwoIntersections identity = this.headPoint().getParametricalIdentityWith(mate.headPoint());
            if (identity.isIdentical()) {
                mate.reverse();
                this.segments.insertElementAt(mate, 0);
                mate.setKilled();
                return true;
            }
            identity = this.headPoint().getParametricalIdentityWith(mate.tailPoint());
            if (identity.isIdentical()) {
                this.segments.insertElementAt(mate, 0);
                mate.setKilled();
                return true;
            }
            return false;
        }

        private boolean addAtTail(CurveSegmentInfo mate) {
            ParametricalIdentityOfTwoIntersections identity = this.tailPoint().getParametricalIdentityWith(mate.headPoint());
            if (identity.isIdentical()) {
                this.segments.addElement(mate);
                mate.setKilled();
                return true;
            }
            identity = this.tailPoint().getParametricalIdentityWith(mate.tailPoint());
            if (identity.isIdentical()) {
                mate.reverse();
                this.segments.addElement(mate);
                mate.setKilled();
                return true;
            }
            return false;
        }

        private boolean mergeIfConnectWith(CurveSegmentInfo mate) {
            if (this.addAtHead(mate)) {
                return true;
            }
            return this.addAtTail(mate);
        }

        private JgclIntersectionCurve3D getIntersection(boolean doExchange) {
            boolean closed;
            int nPnts;
            int j;
            PointInfo pInfo;
            CurveSegmentInfo segInfo;
            double lastVParamB = 0.0;
            double lastUParamB = 0.0;
            double lastVParamA = 0.0;
            double lastUParamA = 0.0;
            double firstVParamB = 0.0;
            double firstUParamB = 0.0;
            double firstVParamA = 0.0;
            double firstUParamA = 0.0;
            int i = 0;
            while (i < this.nSegments()) {
                segInfo = this.segmentAt(i);
                pInfo = segInfo.pointAt(0);
                if (i == 0) {
                    firstUParamA = lastUParamA = pInfo.uParamA;
                    firstVParamA = lastVParamA = pInfo.vParamA;
                    firstUParamB = lastUParamB = pInfo.uParamB;
                    firstVParamB = lastVParamB = pInfo.vParamB;
                }
                j = 1;
                while (j < segInfo.nPoints()) {
                    pInfo = segInfo.pointAt(j);
                    lastUParamA = JgclSurfaceSurfaceInterferenceList.adjustParam(JgclSurfaceSurfaceInterferenceList.this.uParameterDomainA, pInfo.uParamA, lastUParamA);
                    lastVParamA = JgclSurfaceSurfaceInterferenceList.adjustParam(JgclSurfaceSurfaceInterferenceList.this.vParameterDomainA, pInfo.vParamA, lastVParamA);
                    lastUParamB = JgclSurfaceSurfaceInterferenceList.adjustParam(JgclSurfaceSurfaceInterferenceList.this.uParameterDomainB, pInfo.uParamB, lastUParamB);
                    lastVParamB = JgclSurfaceSurfaceInterferenceList.adjustParam(JgclSurfaceSurfaceInterferenceList.this.vParameterDomainB, pInfo.vParamB, lastVParamB);
                    pInfo.uParamA = lastUParamA;
                    pInfo.vParamA = lastVParamA;
                    pInfo.uParamB = lastUParamB;
                    pInfo.vParamB = lastVParamB;
                    ++j;
                }
                ++i;
            }
            if (this.headPoint().isIdenticalWith(this.tailPoint())) {
                nPnts = this.nPoints() - 1;
                closed = true;
            } else {
                nPnts = this.nPoints();
                closed = false;
            }
            boolean closedA = JgclSurfaceSurfaceInterferenceList.checkClosed2D(JgclSurfaceSurfaceInterferenceList.this.uParameterDomainA, JgclSurfaceSurfaceInterferenceList.this.vParameterDomainA, firstUParamA, firstVParamA, lastUParamA, lastVParamA, closed);
            int nPntsA = closedA ? this.nPoints() - 1 : this.nPoints();
            boolean closedB = JgclSurfaceSurfaceInterferenceList.checkClosed2D(JgclSurfaceSurfaceInterferenceList.this.uParameterDomainB, JgclSurfaceSurfaceInterferenceList.this.vParameterDomainB, firstUParamB, firstVParamB, lastUParamB, lastVParamB, closed);
            int nPntsB = closedB ? this.nPoints() - 1 : this.nPoints();
            Vector<JgclPoint3D> v3d = new Vector<JgclPoint3D>();
            Vector<JgclCartesianPoint2D> v2dA = new Vector<JgclCartesianPoint2D>();
            Vector<JgclCartesianPoint2D> v2dB = new Vector<JgclCartesianPoint2D>();
            int n = 0;
            int k = 0;
            i = 0;
            while (i < this.nSegments()) {
                segInfo = this.segmentAt(i);
                pInfo = segInfo.pointAt(0);
                if (i == 0) {
                    v3d.addElement(pInfo.coordinates());
                    v2dA.addElement(new JgclCartesianPoint2D(pInfo.uParamA, pInfo.vParamA));
                    v2dB.addElement(new JgclCartesianPoint2D(pInfo.uParamB, pInfo.vParamB));
                    ++k;
                }
                j = 1;
                while (j < segInfo.nPoints()) {
                    block16: {
                        block15: {
                            pInfo = segInfo.pointAt(j);
                            JgclPoint3D prevP = (JgclPoint3D)v3d.elementAt(k - 1 - n);
                            if (!prevP.identical(pInfo.coordinates())) break block15;
                            ++n;
                            if (k != this.nPoints() - 1) break block16;
                            v3d.removeElementAt(k - n);
                            v2dA.removeElementAt(k - n);
                            v2dB.removeElementAt(k - n);
                        }
                        if (k != nPnts) {
                            v3d.addElement(pInfo.coordinates());
                        }
                        if (k != nPntsA) {
                            v2dA.addElement(new JgclCartesianPoint2D(pInfo.uParamA, pInfo.vParamA));
                        }
                        if (k != nPntsB) {
                            v2dB.addElement(new JgclCartesianPoint2D(pInfo.uParamB, pInfo.vParamB));
                        }
                    }
                    ++j;
                    ++k;
                }
                ++i;
            }
            Object[] pnts3d = new JgclPoint3D[nPnts - n];
            v3d.copyInto(pnts3d);
            Object[] pnts2dA = new JgclPoint2D[nPntsA - n];
            v2dA.copyInto(pnts2dA);
            Object[] pnts2dB = new JgclPoint2D[nPntsB - n];
            v2dB.copyInto(pnts2dB);
            JgclPolyline3D pol3d = new JgclPolyline3D((JgclPoint3D[])pnts3d, closed);
            JgclPolyline2D pol2dA = new JgclPolyline2D((JgclPoint2D[])pnts2dA, closedA);
            JgclPolyline2D pol2dB = new JgclPolyline2D((JgclPoint2D[])pnts2dB, closedB);
            if (!doExchange) {
                return new JgclIntersectionCurve3D(pol3d, JgclSurfaceSurfaceInterferenceList.this.surfaceA, pol2dA, JgclSurfaceSurfaceInterferenceList.this.surfaceB, pol2dB, 0);
            }
            return new JgclIntersectionCurve3D(pol3d, JgclSurfaceSurfaceInterferenceList.this.surfaceB, pol2dB, JgclSurfaceSurfaceInterferenceList.this.surfaceA, pol2dA, 0);
        }

        private void refine() {
            Enumeration e = this.segments.elements();
            while (e.hasMoreElements()) {
                CurveSegmentInfo ci = (CurveSegmentInfo)e.nextElement();
                ci.refine();
            }
        }
    }

    class CurveSegmentInfo {
        int nPoints;
        PointInfo[] points;
        boolean killed = false;
        boolean reversed = false;

        CurveSegmentInfo(JgclPolyline3D pol3, JgclPolyline2D pol2A, JgclPolyline2D pol2B) {
            JgclSurfaceSurfaceInterferenceList.this = JgclSurfaceSurfaceInterferenceList.this;
            this.nPoints = pol3.nSegments() + 1;
            this.points = new PointInfo[this.nPoints];
            int i = 0;
            while (i < this.nPoints) {
                JgclPoint2D pnt = pol2A.pointAt(i);
                double paramAu = pnt.x();
                double paramAv = pnt.y();
                pnt = pol2B.pointAt(i);
                double paramBu = pnt.x();
                double paramBv = pnt.y();
                paramAu = JgclSurfaceSurfaceInterferenceList.this.uParameterDomainA.wrap(paramAu);
                paramAv = JgclSurfaceSurfaceInterferenceList.this.vParameterDomainA.wrap(paramAv);
                paramBu = JgclSurfaceSurfaceInterferenceList.this.uParameterDomainB.wrap(paramBu);
                paramBv = JgclSurfaceSurfaceInterferenceList.this.vParameterDomainB.wrap(paramBv);
                JgclSurfaceSurfaceInterferenceList jgclSurfaceSurfaceInterferenceList = JgclSurfaceSurfaceInterferenceList.this;
                jgclSurfaceSurfaceInterferenceList.getClass();
                this.points[i] = jgclSurfaceSurfaceInterferenceList.new PointInfo(pol3.pointAt(i), paramAu, paramAv, paramBu, paramBv);
                ++i;
            }
        }

        CurveSegmentInfo(JgclPolyline3D pol3, JgclPolyline2D pol2A, JgclPolyline2D pol2B, double headPTolAu, double headPTolAv, double headPTolBu, double headPTolBv, double tailPTolAu, double tailPTolAv, double tailPTolBu, double tailPTolBv) {
            JgclSurfaceSurfaceInterferenceList.this = JgclSurfaceSurfaceInterferenceList.this;
            this.nPoints = pol3.nSegments() + 1;
            this.points = new PointInfo[this.nPoints];
            int i = 0;
            while (i < this.nPoints) {
                JgclPoint2D pnt = pol2A.pointAt(i);
                double paramAu = pnt.x();
                double paramAv = pnt.y();
                pnt = pol2B.pointAt(i);
                double paramBu = pnt.x();
                double paramBv = pnt.y();
                paramAu = JgclSurfaceSurfaceInterferenceList.this.uParameterDomainA.wrap(paramAu);
                paramAv = JgclSurfaceSurfaceInterferenceList.this.vParameterDomainA.wrap(paramAv);
                paramBu = JgclSurfaceSurfaceInterferenceList.this.uParameterDomainB.wrap(paramBu);
                paramBv = JgclSurfaceSurfaceInterferenceList.this.vParameterDomainB.wrap(paramBv);
                if (i == 0) {
                    JgclSurfaceSurfaceInterferenceList jgclSurfaceSurfaceInterferenceList = JgclSurfaceSurfaceInterferenceList.this;
                    jgclSurfaceSurfaceInterferenceList.getClass();
                    this.points[i] = jgclSurfaceSurfaceInterferenceList.new PointInfo(pol3.pointAt(i), paramAu, paramAv, paramBu, paramBv, headPTolAu, headPTolAv, headPTolBu, headPTolBv);
                } else if (i == this.nPoints - 1) {
                    JgclSurfaceSurfaceInterferenceList jgclSurfaceSurfaceInterferenceList = JgclSurfaceSurfaceInterferenceList.this;
                    jgclSurfaceSurfaceInterferenceList.getClass();
                    this.points[i] = jgclSurfaceSurfaceInterferenceList.new PointInfo(pol3.pointAt(i), paramAu, paramAv, paramBu, paramBv, tailPTolAu, tailPTolAv, tailPTolBu, tailPTolBv);
                } else {
                    JgclSurfaceSurfaceInterferenceList jgclSurfaceSurfaceInterferenceList = JgclSurfaceSurfaceInterferenceList.this;
                    jgclSurfaceSurfaceInterferenceList.getClass();
                    this.points[i] = jgclSurfaceSurfaceInterferenceList.new PointInfo(pol3.pointAt(i), paramAu, paramAv, paramBu, paramBv);
                }
                ++i;
            }
        }

        private int nPoints() {
            return this.nPoints;
        }

        private void nPoints(int newN) {
            this.nPoints = newN;
        }

        private PointInfo pointAt(int index) {
            if (this.reversed) {
                index = this.nPoints - index - 1;
            }
            return this.points[index];
        }

        private void pointAt(int index, PointInfo newPi) {
            this.points[index] = newPi;
        }

        private boolean isValidIndex(int index) {
            return index >= 0 && index < this.nPoints();
        }

        private boolean isKilled() {
            return this.killed;
        }

        private void setKilled() {
            this.killed = true;
        }

        private void reverse() {
            this.reversed = !this.reversed;
        }

        private PointInfo headPoint() {
            return this.pointAt(0);
        }

        private PointInfo tailPoint() {
            return this.pointAt(this.nPoints() - 1);
        }

        private void isValidLengthPolyline() {
            if (this.isKilled()) {
                return;
            }
            if (this.nPoints() > 2) {
                return;
            }
            if (!this.headPoint().isIdenticalWith(this.tailPoint())) {
                return;
            }
            this.setKilled();
        }

        private boolean isIdenticalWith(int this_i, CurveSegmentInfo mate, int mate_i) {
            if (!this.isValidIndex(this_i) || !mate.isValidIndex(mate_i)) {
                return false;
            }
            return this.pointAt(this_i).isIdenticalWith(mate.pointAt(mate_i));
        }

        private void isSamePolyline(CurveSegmentInfo mate) {
            CurveSegmentInfo s_crv;
            CurveSegmentInfo l_crv;
            if (this.isKilled() || mate.isKilled()) {
                return;
            }
            if (this.nPoints() >= mate.nPoints()) {
                l_crv = this;
                s_crv = mate;
            } else {
                l_crv = mate;
                s_crv = this;
            }
            int s_i = -1;
            int l_i = 0;
            while (l_i < l_crv.nPoints()) {
                if (l_crv.pointAt(l_i).isIdenticalWith(s_crv.headPoint())) {
                    s_i = 0;
                    break;
                }
                if (l_crv.pointAt(l_i).isIdenticalWith(s_crv.tailPoint())) {
                    s_i = s_crv.nPoints() - 1;
                    break;
                }
                ++l_i;
            }
            int so_s = s_i;
            if (so_s == -1) {
                return;
            }
            int s_inc = 0;
            int l_inc = 0;
            int rty = 1;
            while (rty < 4) {
                if (l_crv.isIdenticalWith(l_i + 1, s_crv, s_i + rty) || l_crv.isIdenticalWith(l_i + rty, s_crv, s_i + 1)) {
                    l_inc = 1;
                    s_inc = 1;
                    break;
                }
                if (l_crv.isIdenticalWith(l_i + 1, s_crv, s_i - rty) || l_crv.isIdenticalWith(l_i + rty, s_crv, s_i - 1)) {
                    l_inc = 1;
                    s_inc = -1;
                    break;
                }
                if (l_crv.isIdenticalWith(l_i - 1, s_crv, s_i + rty) || l_crv.isIdenticalWith(l_i - rty, s_crv, s_i + 1)) {
                    l_inc = -1;
                    s_inc = 1;
                    break;
                }
                if (l_crv.isIdenticalWith(l_i - 1, s_crv, s_i - rty) || l_crv.isIdenticalWith(l_i - rty, s_crv, s_i - 1)) {
                    l_inc = -1;
                    s_inc = -1;
                    break;
                }
                ++rty;
            }
            if (rty == 4) {
                return;
            }
            int so_e = -1;
            while (l_crv.isValidIndex(l_i += l_inc) && s_crv.isValidIndex(s_i += s_inc)) {
                if (!l_crv.isIdenticalWith(l_i, s_crv, s_i)) {
                    rty = 1;
                    while (rty < 4) {
                        if (l_crv.isIdenticalWith(l_i + rty * l_inc, s_crv, s_i)) {
                            l_i += rty * l_inc;
                            break;
                        }
                        ++rty;
                    }
                    if (rty == 4) {
                        rty = 1;
                        while (rty < 4) {
                            if (l_crv.isIdenticalWith(l_i, s_crv, s_i + rty * s_inc)) {
                                s_i += rty * s_inc;
                                break;
                            }
                            ++rty;
                        }
                        if (rty == 4) break;
                    }
                }
                so_e = s_i;
            }
            if (so_e == -1) {
                throw new JgclFatal();
            }
            if (so_s > so_e) {
                int tmp = so_s;
                so_s = so_e;
                so_e = tmp;
            }
            if (so_e - so_s + 1 == s_crv.nPoints()) {
                s_crv.setKilled();
                return;
            }
            if (so_s == 0) {
                int s_uip = s_crv.nPoints();
                s_i = 0;
                int s_j = so_e;
                while (s_j < s_uip) {
                    s_crv.pointAt(s_i, s_crv.pointAt(s_j));
                    ++s_i;
                    ++s_j;
                }
                s_crv.nPoints(s_i);
            } else if (so_e == s_crv.nPoints() - 1) {
                s_crv.nPoints(so_s + 1);
            }
            if (s_crv.nPoints() <= 1) {
                s_crv.setKilled();
                return;
            }
        }

        private void refine() {
            int i = 0;
            while (i < this.nPoints) {
                PointInfo point = this.points[i];
                PointInfo a_point = i == 0 ? this.points[0] : this.points[i - 1];
                PointInfo b_point = i == this.nPoints - 1 ? this.points[this.nPoints - 1] : this.points[i + 1];
                JgclSurfaceSurfaceInterferenceList.this.refinePointInfo(point, b_point, a_point, true);
                ++i;
            }
        }

        static /* synthetic */ void access$0(CurveSegmentInfo $0) {
            $0.isValidLengthPolyline();
        }
    }
}

