/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclDulaunayDiagram2D;
import jp.go.ipa.jgcl.JgclEmbeddedGraph;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclMesh3D;
import jp.go.ipa.jgcl.JgclNonParametricSurface3D;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclVector2D;
import jp.go.ipa.jgcl.JgclVoronoiDiagram2D;

public class JgclSetOfTriangles3D
extends JgclNonParametricSurface3D {
    private JgclEmbeddedGraph graph;
    private Face outerFace;
    private static final double neverBeAccessedArg = Double.NaN;

    private JgclEmbeddedGraph.GraphItemMaker makeGraphItemMaker() {
        return new 1(this);
    }

    private JgclSetOfTriangles3D() {
    }

    public JgclSetOfTriangles3D(JgclMesh3D mesh) {
        int columnSize = mesh.uNPoints();
        int rowSize = mesh.vNPoints();
        if (rowSize < 2) {
            throw new JgclInvalidArgumentValue("Row size of mesh is less than 2.");
        }
        if (columnSize < 2) {
            throw new JgclInvalidArgumentValue("Column size of mesh is less than 2.");
        }
        this.graph = new JgclEmbeddedGraph(this.makeGraphItemMaker());
        JgclEmbeddedGraph.Vertex[][] vertices = new JgclEmbeddedGraph.Vertex[columnSize][rowSize];
        JgclEmbeddedGraph.Result firstVF = this.graph.makeVertexFace();
        this.outerFace = (Face)firstVF.face;
        vertices[0][0] = firstVF.vrtx;
        ((Vertex)vertices[0][0]).setCoordinates(mesh.pointAt(0, 0));
        try {
            int c = 1;
            int c_ = 0;
            while (c < columnSize) {
                vertices[c][0] = this.graph.makeEdgeVertex((JgclEmbeddedGraph.Face)this.outerFace, (JgclEmbeddedGraph.Vertex)vertices[c_][0]).vrtx;
                ((Vertex)vertices[c][0]).setCoordinates(mesh.pointAt(c, 0));
                ++c;
                ++c_;
            }
            int r = 1;
            int r_ = 0;
            while (r < rowSize) {
                int c2 = 0;
                int c_2 = -1;
                while (c2 < columnSize) {
                    vertices[c2][r] = this.graph.makeEdgeVertex((JgclEmbeddedGraph.Face)this.outerFace, (JgclEmbeddedGraph.Vertex)vertices[c2][r_]).vrtx;
                    ((Vertex)vertices[c2][r]).setCoordinates(mesh.pointAt(c2, r));
                    if (c2 > 0) {
                        Face rectangle = (Face)this.graph.makeEdgeFace((JgclEmbeddedGraph.Face)this.outerFace, (JgclEmbeddedGraph.Vertex)vertices[c_2][r], (JgclEmbeddedGraph.Vertex)vertices[c2][r]).face;
                        this.graph.makeEdgeFace(rectangle, vertices[c_2][r_], vertices[c2][r]);
                    }
                    ++c2;
                    ++c_2;
                }
                ++r;
                ++r_;
            }
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {}
    }

    public JgclSetOfTriangles3D(Enumeration pointsOnSurface) {
        this.createDulaunay(pointsOnSurface, 1, Double.NaN, Double.NaN, Double.NaN);
    }

    public JgclSetOfTriangles3D(Enumeration pointsOnSurface, double xScale, double yScale) {
        this.createDulaunay(pointsOnSurface, 2, xScale, yScale, Double.NaN);
    }

    public JgclSetOfTriangles3D(Enumeration pointsOnSurface, double xScale, double yScale, double radiusScale) {
        this.createDulaunay(pointsOnSurface, 3, xScale, yScale, radiusScale);
    }

    private void createDulaunay(Enumeration pointsOnSurface, int constractorTypeOfVoronoi, double xScale, double yScale, double radiusScale) {
        JgclVoronoiDiagram2D voronoi;
        Vector points3D = new Vector();
        2 points2D = new 2(points3D, pointsOnSurface);
        switch (constractorTypeOfVoronoi) {
            case 1: {
                voronoi = new JgclVoronoiDiagram2D(new JgclEmbeddedGraph(), points2D);
                break;
            }
            case 2: {
                voronoi = new JgclVoronoiDiagram2D(new JgclEmbeddedGraph(), points2D, xScale, yScale);
                break;
            }
            case 3: {
                voronoi = new JgclVoronoiDiagram2D(new JgclEmbeddedGraph(), points2D, xScale, yScale, radiusScale);
                break;
            }
            default: {
                throw new JgclInvalidArgumentValue("constructor type of Voronoi diagram is wrong.");
            }
        }
        this.graph = new JgclEmbeddedGraph(this.makeGraphItemMaker());
        JgclDulaunayDiagram2D dulaunay = new JgclDulaunayDiagram2D(this.graph, voronoi);
        Enumeration e = this.graph.vertexElements();
        while (e.hasMoreElements()) {
            Vertex vrtx = (Vertex)e.nextElement();
            JgclDulaunayDiagram2D.DVertex dvrtx = (JgclDulaunayDiagram2D.DVertex)vrtx.getUserData();
            vrtx.setCoordinates((JgclPointOnSurface3D)points3D.elementAt(dvrtx.getIndex()));
        }
        this.outerFace = null;
        Enumeration e2 = this.graph.faceElements();
        while (e2.hasMoreElements()) {
            Face face = (Face)e2.nextElement();
            if (face.getUserData() != null) continue;
            this.outerFace = face;
            break;
        }
        dulaunay.stripGeometries();
    }

    public Enumeration faceElements() {
        return new 3();
    }

    public Enumeration vertexElements() {
        return this.graph.vertexElements();
    }

    public Enumeration edgeElements() {
        return this.graph.edgeElements();
    }

    public int getNumberOfVertices() {
        return this.graph.getNumberOfVertices();
    }

    public int getNumberOfFaces() {
        return this.graph.getNumberOfFaces() - 1;
    }

    public int getNumberOfEdges() {
        return this.graph.getNumberOfEdges();
    }

    public boolean isFreeform() {
        return true;
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        throw new JgclNotSupported();
    }

    public static void main(String[] args) {
        JgclPlane3D surface = new JgclPlane3D(new JgclCartesianPoint3D(0.0, 0.0, 0.0), new JgclLiteralVector3D(0.0, 0.0, 1.0));
        Vector<JgclPointOnSurface3D> pointsOnSurface = new Vector<JgclPointOnSurface3D>();
        int u = 0;
        while (u < 5) {
            int v = 0;
            while (v < 5) {
                if (v != u) {
                    pointsOnSurface.addElement(new JgclPointOnSurface3D(surface, u, (double)v, false));
                }
                ++v;
            }
            ++u;
        }
        JgclSetOfTriangles3D stri = new JgclSetOfTriangles3D(pointsOnSurface.elements());
        int i = 0;
        Enumeration e = stri.edgeElements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            Vertex[] vrtcs = edge.getVerticesOfStartEnd();
            JgclPoint3D pnt0 = vrtcs[0].getCoordinates();
            JgclPoint3D pnt1 = vrtcs[1].getCoordinates();
            System.out.println("JgclLine3D\tlin" + i);
            System.out.println("\tpnt\t" + pnt0.x() + " " + pnt0.y() + " " + pnt0.z());
            System.out.println("\tpnt\t" + pnt1.x() + " " + pnt1.y() + " " + pnt1.z());
            System.out.println("End");
            ++i;
        }
    }

    public class Vertex
    extends JgclEmbeddedGraph.Vertex {
        private JgclPoint3D coordinates = null;
        private boolean killed = false;

        protected Vertex() {
            JgclSetOfTriangles3D.this = JgclSetOfTriangles3D.this;
        }

        protected void fillFieldsOfReplica() {
            super.fillFieldsOfReplica();
            Vertex replica = (Vertex)this.getReplica();
            replica.coordinates = this.coordinates;
            replica.killed = this.killed;
        }

        public void setCoordinates(JgclPoint3D coordinates) {
            this.coordinates = coordinates;
        }

        public JgclPoint3D getCoordinates() {
            return this.coordinates;
        }

        void setKilled(boolean killed) {
            this.killed = killed;
        }

        boolean isKilled() {
            return this.killed;
        }

        public Face[] getFacesInCCW() {
            Vector faces = this.getFaceCycleInCCW();
            Face[] result = new Face[faces.size()];
            int i = 0;
            while (i < faces.size()) {
                result[i] = (Face)faces.elementAt(i);
                if (result[i] == JgclSetOfTriangles3D.this.outerFace) {
                    result[i] = null;
                }
                ++i;
            }
            return result;
        }

        public Edge[] getEdgesInCCW() {
            Vector edges = this.getEdgeCycleInCCW();
            Edge[] result = new Edge[edges.size()];
            int i = 0;
            while (i < edges.size()) {
                result[i] = (Edge)edges.elementAt(i);
                ++i;
            }
            return result;
        }
    }

    public class Face
    extends JgclEmbeddedGraph.Face {
        private boolean killed = false;

        protected Face() {
            JgclSetOfTriangles3D.this = JgclSetOfTriangles3D.this;
        }

        protected void fillFieldsOfReplica() {
            super.fillFieldsOfReplica();
            Face replica = (Face)this.getReplica();
            replica.killed = this.killed;
        }

        void setKilled(boolean killed) {
            this.killed = killed;
        }

        boolean isKilled() {
            return this.killed;
        }

        public Edge[] getEdgesInCCW() {
            Edge[] result = new Edge[3];
            Vector edges = this.getEdgeCycleInCCW();
            int i = 0;
            while (i < 3) {
                result[i] = (Edge)edges.elementAt(i);
                ++i;
            }
            return result;
        }

        public Vertex[] getVerticesInCCW() {
            Vertex[] result = new Vertex[3];
            Vector vertices = this.getVertexCycleInCCW();
            int i = 0;
            while (i < 3) {
                result[i] = (Vertex)vertices.elementAt(i);
                ++i;
            }
            return result;
        }

        public Vertex getFarVertex(Edge edge) {
            Vertex[] vrtcs = this.getVerticesInCCW();
            Vertex[] edgeVrtcs = edge.getVerticesOfStartEnd();
            int i = 0;
            while (i < 3) {
                if (!vrtcs[i].isIdentWith(edgeVrtcs[0]) && !vrtcs[i].isIdentWith(edgeVrtcs[1])) {
                    return vrtcs[i];
                }
                ++i;
            }
            return null;
        }

        public double[] getAnglesOfStartEndIn2D(Edge edge) {
            Vertex[] vrtcs = this.getVerticesInCCW();
            Vertex[] edgeVrtcs = edge.getVerticesOfStartEnd();
            Vertex far = null;
            int i = 0;
            while (i < 3) {
                if (!vrtcs[i].isIdentWith(edgeVrtcs[0]) && !vrtcs[i].isIdentWith(edgeVrtcs[1])) {
                    far = vrtcs[i];
                    break;
                }
                ++i;
            }
            if (far == null) {
                return null;
            }
            JgclPoint2D[] crds2D = new JgclPoint2D[3];
            JgclPointOnSurface3D crd3D = (JgclPointOnSurface3D)edgeVrtcs[0].getCoordinates();
            crds2D[0] = JgclPoint2D.of(crd3D.parameters());
            crd3D = (JgclPointOnSurface3D)edgeVrtcs[1].getCoordinates();
            crds2D[1] = JgclPoint2D.of(crd3D.parameters());
            crd3D = (JgclPointOnSurface3D)far.getCoordinates();
            crds2D[3] = JgclPoint2D.of(crd3D.parameters());
            JgclVector2D[] vctrs2D = new JgclVector2D[2];
            double[] angles2D = new double[2];
            vctrs2D[0] = crds2D[1].subtract(crds2D[0]);
            vctrs2D[1] = crds2D[2].subtract(crds2D[0]);
            angles2D[0] = vctrs2D[0].angleWith(vctrs2D[1]);
            if (angles2D[0] > Math.PI) {
                angles2D[0] = Math.PI * 2 - angles2D[0];
            }
            vctrs2D[0] = crds2D[0].subtract(crds2D[1]);
            vctrs2D[1] = crds2D[2].subtract(crds2D[1]);
            angles2D[1] = vctrs2D[0].angleWith(vctrs2D[1]);
            if (angles2D[1] > Math.PI) {
                angles2D[1] = Math.PI * 2 - angles2D[1];
            }
            return angles2D;
        }
    }

    public class Edge
    extends JgclEmbeddedGraph.Edge {
        private boolean killed = false;

        protected Edge() {
            JgclSetOfTriangles3D.this = JgclSetOfTriangles3D.this;
        }

        protected void fillFieldsOfReplica() {
            super.fillFieldsOfReplica();
            Edge replica = (Edge)this.getReplica();
            replica.killed = this.killed;
        }

        void setKilled(boolean killed) {
            this.killed = killed;
        }

        boolean isKilled() {
            return this.killed;
        }

        public Vertex[] getVerticesOfStartEnd() {
            JgclEmbeddedGraph.Vertex[] vertices = this.getVertices();
            Vertex[] result = new Vertex[2];
            int i = 0;
            while (i < 2) {
                result[i] = (Vertex)vertices[i];
                ++i;
            }
            return result;
        }

        public Face[] getFacesOfLeftRight() {
            JgclEmbeddedGraph.Face[] faces = this.getFaces();
            Face[] result = new Face[2];
            int i = 0;
            while (i < 2) {
                result[i] = (Face)faces[i];
                if (result[i] == JgclSetOfTriangles3D.this.outerFace) {
                    result[i] = null;
                }
                ++i;
            }
            return result;
        }

        public Edge flipDiagonal() {
            double[] anglesInRF;
            Face[] faces = this.getFacesOfLeftRight();
            Face leftFace = faces[0];
            Face rightFace = faces[1];
            if (leftFace == null || rightFace == null) {
                return null;
            }
            double[] anglesInLF = leftFace.getAnglesOfStartEndIn2D(this);
            if (!(anglesInLF[0] + (anglesInRF = leftFace.getAnglesOfStartEndIn2D(this))[0] < Math.PI) || !(anglesInLF[1] + anglesInRF[1] < Math.PI)) {
                return null;
            }
            Vertex startV = leftFace.getFarVertex(this);
            Vertex endV = rightFace.getFarVertex(this);
            JgclSetOfTriangles3D.this.graph.killEdgeFace(this, rightFace);
            JgclEmbeddedGraph.Result resultMEF = JgclSetOfTriangles3D.this.graph.makeEdgeFace(leftFace, startV, endV);
            Edge newEdge = (Edge)resultMEF.edge;
            newEdge.setKilled(this.isKilled());
            newEdge.setUserData(this.getUserData());
            Face newFace = (Face)resultMEF.face;
            newFace.setKilled(rightFace.isKilled());
            newFace.setUserData(rightFace.getUserData());
            return newEdge;
        }
    }

    private final class 1
    implements JgclEmbeddedGraph.GraphItemMaker {
        JgclSetOfTriangles3D parent;

        public JgclEmbeddedGraph.Vertex newVertex() {
            return this.parent.new Vertex();
        }

        public JgclEmbeddedGraph.Face newFace() {
            return this.parent.new Face();
        }

        public JgclEmbeddedGraph.Edge newEdge() {
            return this.parent.new Edge();
        }

        /* synthetic */ 1(JgclSetOfTriangles3D this$0) {
            this.parent = this$0;
        }
    }

    private static final class 2
    implements Enumeration {
        private final /* synthetic */ Vector val$points3D;
        private final /* synthetic */ Enumeration val$pointsOnSurface;

        public boolean hasMoreElements() {
            return this.val$pointsOnSurface.hasMoreElements();
        }

        public Object nextElement() {
            JgclPointOnSurface3D pos = (JgclPointOnSurface3D)this.val$pointsOnSurface.nextElement();
            this.val$points3D.addElement(pos);
            return new JgclCartesianPoint2D(pos.parameters());
        }

        /* synthetic */ 2(Vector val$points3D, Enumeration val$pointsOnSurface) {
            this.val$points3D = val$points3D;
            this.val$pointsOnSurface = val$pointsOnSurface;
        }
    }

    private final class 3
    implements Enumeration {
        Enumeration e;
        Object nextNonOuterFace;

        public boolean hasMoreElements() {
            if (this.nextNonOuterFace != null) {
                return true;
            }
            if (!this.e.hasMoreElements()) {
                return false;
            }
            Object obj = this.e.nextElement();
            if ((Face)obj != JgclSetOfTriangles3D.this.outerFace) {
                this.nextNonOuterFace = obj;
                return true;
            }
            this.nextNonOuterFace = null;
            return this.e.hasMoreElements();
        }

        public Object nextElement() {
            if (this.nextNonOuterFace != null) {
                Object obj = this.nextNonOuterFace;
                this.nextNonOuterFace = null;
                return obj;
            }
            Object obj = this.e.nextElement();
            if ((Face)obj != JgclSetOfTriangles3D.this.outerFace) {
                return obj;
            }
            return this.e.nextElement();
        }

        /* synthetic */ 3() {
            this.e = JgclSetOfTriangles3D.this.graph.faceElements();
        }
    }
}

