/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclConic3D;
import jp.go.ipa.jgcl.JgclConicalSurface3D;
import jp.go.ipa.jgcl.JgclCylindricalSurface3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclFreeformSurfaceWithControlPoints3D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclIntsBscBzs3D;
import jp.go.ipa.jgcl.JgclIntsBzcBzs3D;
import jp.go.ipa.jgcl.JgclIntsBzsBzs3D;
import jp.go.ipa.jgcl.JgclIntsCncBzs3D;
import jp.go.ipa.jgcl.JgclIntsQrdBzs3D;
import jp.go.ipa.jgcl.JgclIntsSrfBss3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclMesh3D;
import jp.go.ipa.jgcl.JgclOfst3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterOutOfRange;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclProjPntBzs3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierCurveEvaluation;
import jp.go.ipa.jgcl.JgclSphericalSurface3D;
import jp.go.ipa.jgcl.JgclSurfaceDerivative3D;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterference3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclPureBezierSurface3D
extends JgclFreeformSurfaceWithControlPoints3D {
    public JgclPureBezierSurface3D(JgclPoint3D[][] controlPoints) {
        super(controlPoints);
    }

    public JgclPureBezierSurface3D(JgclPoint3D[][] controlPoints, double[][] weights) {
        super(controlPoints, weights);
    }

    JgclPureBezierSurface3D(JgclPoint3D[][] controlPoints, double[][] weights, boolean doCheck) {
        super(controlPoints, weights, doCheck);
    }

    JgclPureBezierSurface3D(double[][][] cpArray) {
        super(cpArray);
    }

    JgclPureBezierSurface3D(double[][][] cpArray, boolean doCheck) {
        super(cpArray, doCheck);
    }

    public int uDegree() {
        return this.uNControlPoints() - 1;
    }

    public int vDegree() {
        return this.vNControlPoints() - 1;
    }

    public JgclPoint3D coordinates(double uParam, double vParam) {
        boolean isPoly = this.isPolynomial();
        uParam = this.checkUParameter(uParam);
        vParam = this.checkVParameter(vParam);
        double[][][] cntlPnts = this.toDoubleArray(isPoly);
        int uUicp = cntlPnts.length;
        int vUicp = cntlPnts[0].length;
        double[][] bzc = new double[uUicp][];
        int i = 0;
        while (i < uUicp) {
            bzc[i] = JgclPureBezierCurveEvaluation.coordinates(cntlPnts[i], vParam);
            ++i;
        }
        double[] d0D = JgclPureBezierCurveEvaluation.coordinates(bzc, uParam);
        if (!isPoly) {
            this.convRational0Deriv(d0D);
        }
        return new JgclCartesianPoint3D(d0D);
    }

    public JgclVector3D[] tangentVector(double uParam, double vParam) {
        double[][] ld1D = new double[2][];
        JgclVector3D[] d1D = new JgclVector3D[2];
        boolean isPoly = this.isPolynomial();
        uParam = this.checkUParameter(uParam);
        vParam = this.checkVParameter(vParam);
        double[][][] cntlPnts = this.toDoubleArray(isPoly);
        int uUicp = cntlPnts.length;
        int vUicp = cntlPnts[0].length;
        double[][] pp = new double[uUicp][4];
        double[][] tt = new double[uUicp][4];
        int i = 0;
        while (i < uUicp) {
            JgclPureBezierCurveEvaluation.evaluation(cntlPnts[i], vParam, pp[i], tt[i], null, null);
            ++i;
        }
        ld1D[0] = new double[4];
        if (isPoly) {
            JgclPureBezierCurveEvaluation.evaluation(pp, uParam, null, ld1D[0], null, null);
            ld1D[1] = JgclPureBezierCurveEvaluation.coordinates(tt, uParam);
        } else {
            double[] ld0D = new double[4];
            JgclPureBezierCurveEvaluation.evaluation(pp, uParam, ld0D, ld1D[0], null, null);
            ld1D[1] = JgclPureBezierCurveEvaluation.coordinates(tt, uParam);
            this.convRational1Deriv(ld0D, ld1D[0], ld1D[1]);
        }
        int i2 = 0;
        while (i2 < 2) {
            d1D[i2] = new JgclLiteralVector3D(ld1D[i2]);
            ++i2;
        }
        return d1D;
    }

    public JgclSurfaceDerivative3D evaluation(double uParam, double vParam) {
        boolean isPoly = this.isPolynomial();
        uParam = this.checkUParameter(uParam);
        vParam = this.checkVParameter(vParam);
        double[][][] cntlPnts = this.toDoubleArray(isPoly);
        int uUicp = cntlPnts.length;
        int vUicp = cntlPnts[0].length;
        double[][] pp = new double[uUicp][4];
        double[][] tt = new double[uUicp][4];
        double[][] dd = new double[uUicp][4];
        int i = 0;
        while (i < uUicp) {
            JgclPureBezierCurveEvaluation.evaluation(cntlPnts[i], vParam, pp[i], tt[i], dd[i], null);
            ++i;
        }
        double[] ldv = new double[4];
        double[] lduv = new double[4];
        JgclPureBezierCurveEvaluation.evaluation(tt, uParam, ldv, lduv, null, null);
        double[] ldvv = JgclPureBezierCurveEvaluation.coordinates(dd, uParam);
        double[] ld0 = new double[4];
        double[] ldu = new double[4];
        double[] lduu = new double[4];
        JgclPureBezierCurveEvaluation.evaluation(pp, uParam, ld0, ldu, lduu, null);
        if (!isPoly) {
            this.convRational2Deriv(ld0, ldu, ldv, lduu, lduv, ldvv);
        }
        JgclCartesianPoint3D d0 = new JgclCartesianPoint3D(ld0);
        JgclLiteralVector3D du = new JgclLiteralVector3D(ldu);
        JgclLiteralVector3D dv = new JgclLiteralVector3D(ldv);
        JgclLiteralVector3D duu = new JgclLiteralVector3D(lduu);
        JgclLiteralVector3D duv = new JgclLiteralVector3D(lduv);
        JgclLiteralVector3D dvv = new JgclLiteralVector3D(ldvv);
        return new JgclSurfaceDerivative3D(d0, du, dv, duu, duv, dvv);
    }

    public JgclPointOnSurface3D[] projectFrom(JgclPoint3D point) {
        return JgclProjPntBzs3D.projection(point, this);
    }

    public JgclMesh3D toMesh(JgclParameterSection uPint, JgclParameterSection vPint, JgclToleranceForDistance tol) {
        JgclPureBezierSurface3D t_bzs = this.truncate(uPint, vPint);
        JgclMesh3D Mesh = t_bzs.toMesh(tol);
        double uSp = uPint.start();
        double uIp = uPint.increase();
        double vSp = vPint.start();
        double vIp = vPint.increase();
        int u_npnts = Mesh.uNPoints();
        int v_npnts = Mesh.vNPoints();
        JgclPoint3D[][] mesh = Mesh.points();
        int i = 0;
        while (i < u_npnts) {
            int j = 0;
            while (j < v_npnts) {
                double uParam = uSp + uIp * ((JgclPointOnSurface3D)mesh[i][j]).uParameter();
                double vParam = vSp + vIp * ((JgclPointOnSurface3D)mesh[i][j]).vParameter();
                try {
                    mesh[i][j] = new JgclPointOnSurface3D(this, uParam, vParam, false);
                }
                catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                    throw new JgclFatal();
                }
                ++j;
            }
            ++i;
        }
        return new JgclMesh3D(mesh, false);
    }

    public JgclMesh3D toMesh(JgclToleranceForDistance tol) {
        double[] kp = new double[2];
        JgclFreeformSurfaceWithControlPoints3D.GpList u_gp_list = new JgclFreeformSurfaceWithControlPoints3D.GpList();
        JgclFreeformSurfaceWithControlPoints3D.GpList v_gp_list = new JgclFreeformSurfaceWithControlPoints3D.GpList();
        JgclPureBezierSurface3D jgclPureBezierSurface3D = this;
        jgclPureBezierSurface3D.getClass();
        JgclPureBezierSurface3D jgclPureBezierSurface3D2 = this;
        jgclPureBezierSurface3D2.getClass();
        JgclFreeformSurfaceWithControlPoints3D.MeshParam meshParam = jgclPureBezierSurface3D2.new JgclFreeformSurfaceWithControlPoints3D.MeshParam(0, 0, 1);
        JgclPureBezierSurface3D jgclPureBezierSurface3D3 = this;
        jgclPureBezierSurface3D3.getClass();
        JgclFreeformSurfaceWithControlPoints3D.MeshParam meshParam2 = jgclPureBezierSurface3D3.new JgclFreeformSurfaceWithControlPoints3D.MeshParam(0, 1, 1);
        JgclPureBezierSurface3D jgclPureBezierSurface3D4 = this;
        jgclPureBezierSurface3D4.getClass();
        JgclFreeformSurfaceWithControlPoints3D.MeshParam meshParam3 = jgclPureBezierSurface3D4.new JgclFreeformSurfaceWithControlPoints3D.MeshParam(0, 0, 1);
        JgclPureBezierSurface3D jgclPureBezierSurface3D5 = this;
        jgclPureBezierSurface3D5.getClass();
        JgclFreeformSurfaceWithControlPoints3D.SegInfo seg_info = jgclPureBezierSurface3D.new JgclFreeformSurfaceWithControlPoints3D.SegInfo(meshParam, meshParam2, meshParam3, jgclPureBezierSurface3D5.new JgclFreeformSurfaceWithControlPoints3D.MeshParam(0, 1, 1));
        this.getSrfMesh(seg_info, tol, u_gp_list, v_gp_list);
        kp[0] = 0.0;
        kp[1] = 1.0;
        return this.makeParamAndMesh(u_gp_list, v_gp_list, kp, kp);
    }

    JgclFreeformSurfaceWithControlPoints3D[] divideForMesh(JgclToleranceForDistance tol) {
        JgclFreeformSurfaceWithControlPoints3D[] bzss;
        JgclFreeformSurfaceWithControlPoints3D ru_bzs;
        JgclFreeformSurfaceWithControlPoints3D lu_bzs;
        JgclPureBezierSurface3D rb_bzs;
        JgclPureBezierSurface3D lb_bzs;
        double told = tol.value();
        boolean u_coln = JgclFreeformSurfaceWithControlPoints3D.uIsColinear(this.controlPoints, told);
        boolean v_coln = JgclFreeformSurfaceWithControlPoints3D.vIsColinear(this.controlPoints, told);
        try {
            if (u_coln && v_coln) {
                lb_bzs = null;
                rb_bzs = null;
                lu_bzs = null;
                ru_bzs = null;
            } else if (!u_coln && !v_coln) {
                bzss = this.vDivide(0.5);
                JgclPureBezierSurface3D vb_bzs = bzss[0];
                JgclPureBezierSurface3D vu_bzs = bzss[1];
                bzss = vb_bzs.uDivide(0.5);
                lb_bzs = bzss[0];
                rb_bzs = bzss[1];
                bzss = vu_bzs.uDivide(0.5);
                lu_bzs = bzss[0];
                ru_bzs = bzss[1];
            } else if (u_coln) {
                bzss = this.vDivide(0.5);
                lb_bzs = bzss[0];
                lu_bzs = bzss[1];
                rb_bzs = null;
                ru_bzs = null;
            } else {
                bzss = this.uDivide(0.5);
                lb_bzs = bzss[0];
                rb_bzs = bzss[1];
                lu_bzs = null;
                ru_bzs = null;
            }
        }
        catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
            throw new JgclFatal();
        }
        bzss = new JgclPureBezierSurface3D[]{lb_bzs, rb_bzs, lu_bzs, ru_bzs};
        return bzss;
    }

    boolean isPlaner(JgclToleranceForDistance tol) {
        int u_uicp = this.uNControlPoints();
        int v_uicp = this.vNControlPoints();
        double tolerance = tol.value();
        JgclPlane3D pln = this.makeRefPln();
        if (pln == null) {
            return true;
        }
        int i = 0;
        while (i < u_uicp) {
            int j = 0;
            while (j < v_uicp) {
                JgclVector3D evec = this.controlPointAt(i, j).subtract(pln.position().location());
                if (Math.abs(evec.dotProduct(pln.position().z())) > tolerance) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private JgclPlane3D makeRefPln() {
        double tol = JgclConditionOfOperation.getCondition().getToleranceForDistance();
        double tol2 = tol * tol;
        double atol = JgclConditionOfOperation.getCondition().getToleranceForAngle();
        int u_uicp = this.uNControlPoints();
        int v_uicp = this.vNControlPoints();
        double[] cos_val = new double[]{Math.cos(1.0471975511965976), Math.cos(0.7853981633974483), Math.cos(0.5235987755982988), Math.cos(atol)};
        JgclPoint3D org = this.controlPointAt(0, 0);
        boolean found = false;
        getDirInfo uInfo = new getDirInfo();
        getDirInfo vInfo = new getDirInfo();
        int i = 0;
        block2: while (i < 3) {
            uInfo.firstCall = true;
            while (this.getUDir(org, uInfo, u_uicp, v_uicp, tol2)) {
                vInfo.firstCall = true;
                while (this.getVDir(org, vInfo, u_uicp, v_uicp, tol2)) {
                    if (!(Math.abs(uInfo.dir.dotProduct(vInfo.dir)) < cos_val[i])) continue;
                    found = true;
                    break block2;
                }
            }
            ++i;
        }
        if (!found) {
            i = 0;
            block5: while (i < 4) {
                boolean isU = true;
                int j = 0;
                while (j < u_uicp) {
                    int k = 0;
                    while (k < v_uicp) {
                        JgclVector3D evec;
                        double leng;
                        if (!(j == 0 && k == 0 || (leng = (evec = this.controlPointAt(j, k).subtract(org)).norm()) < tol2)) {
                            leng = Math.sqrt(leng);
                            evec = evec.divide(leng);
                            if (isU) {
                                isU = false;
                                uInfo.dir = evec;
                            } else {
                                vInfo.dir = evec;
                                if (Math.abs(uInfo.dir.dotProduct(vInfo.dir)) < cos_val[i]) {
                                    found = true;
                                    break block5;
                                }
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (!found) {
            return null;
        }
        JgclVector3D normal = uInfo.dir.crossProduct(vInfo.dir);
        try {
            return new JgclPlane3D(org, normal);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    /*
     * Unable to fully structure code
     */
    boolean getUDir(JgclPoint3D org, getDirInfo info, int u_uicp, int v_uicp, double tol2) {
        if (getDirInfo.access$0(info)) {
            getDirInfo.access$1(info, false);
            getDirInfo.access$5(info, 0);
            getDirInfo.access$7(info, u_uicp - 1);
        } else {
            v0 = info;
            getDirInfo.access$7(v0, getDirInfo.access$6(v0) - 1);
        }
        ** GOTO lbl23
        {
            cpnt = this.controlPointAt(getDirInfo.access$6(info), getDirInfo.access$4(info));
            getDirInfo.access$3(info, cpnt.subtract(org));
            leng = getDirInfo.access$2(info).norm();
            if (v1 > tol2) {
                leng = Math.sqrt(leng);
                getDirInfo.access$3(info, getDirInfo.access$2(info).divide(leng));
                return true;
            }
            v2 = info;
            getDirInfo.access$7(v2, getDirInfo.access$6(v2) - 1);
            do {
                if (getDirInfo.access$6(info) > getDirInfo.access$4(info)) continue block0;
                getDirInfo.access$7(info, u_uicp - 1);
                v3 = info;
                getDirInfo.access$5(v3, getDirInfo.access$4(v3) + 1);
lbl23:
                // 3 sources

            } while (getDirInfo.access$4(info) < v_uicp);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    boolean getVDir(JgclPoint3D org, getDirInfo info, int u_uicp, int v_uicp, double tol2) {
        if (getDirInfo.access$0(info)) {
            getDirInfo.access$1(info, false);
            getDirInfo.access$7(info, 0);
            getDirInfo.access$5(info, v_uicp - 1);
        } else {
            v0 = info;
            getDirInfo.access$5(v0, getDirInfo.access$4(v0) - 1);
        }
        ** GOTO lbl23
        {
            cpnt = this.controlPointAt(getDirInfo.access$6(info), getDirInfo.access$4(info));
            getDirInfo.access$3(info, cpnt.subtract(org));
            leng = getDirInfo.access$2(info).norm();
            if (v1 > tol2) {
                leng = Math.sqrt(leng);
                getDirInfo.access$3(info, getDirInfo.access$2(info).divide(leng));
                return true;
            }
            v2 = info;
            getDirInfo.access$5(v2, getDirInfo.access$4(v2) - 1);
            do {
                if (getDirInfo.access$4(info) > getDirInfo.access$6(info)) continue block0;
                getDirInfo.access$5(info, v_uicp - 1);
                v3 = info;
                getDirInfo.access$7(v3, getDirInfo.access$6(v3) + 1);
lbl23:
                // 3 sources

            } while (getDirInfo.access$6(info) < u_uicp);
        }
        return false;
    }

    JgclPureBezierCurve3D getBoundaryCurve(int nth) {
        int u_uicp = this.uNControlPoints();
        int v_uicp = this.vNControlPoints();
        int uicp = nth % 2 == 0 ? u_uicp : v_uicp;
        JgclPoint3D[] pnts = new JgclPoint3D[uicp];
        double[] ws = this.isRational() ? new double[uicp] : null;
        switch (nth) {
            case 0: {
                int i = 0;
                while (i < u_uicp) {
                    pnts[i] = this.controlPointAt(i, 0);
                    if (this.isRational()) {
                        ws[i] = this.weightAt(i, 0);
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i < v_uicp) {
                    pnts[i] = this.controlPointAt(u_uicp - 1, i);
                    if (this.isRational()) {
                        ws[i] = this.weightAt(u_uicp - 1, i);
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < u_uicp) {
                    pnts[i] = this.controlPointAt(u_uicp - 1 - i, v_uicp - 1);
                    if (this.isRational()) {
                        ws[i] = this.weightAt(u_uicp - 1 - i, v_uicp - 1);
                    }
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i < v_uicp) {
                    pnts[i] = this.controlPointAt(0, v_uicp - 1 - i);
                    if (this.isRational()) {
                        ws[i] = this.weightAt(0, v_uicp - 1 - i);
                    }
                    ++i;
                }
                break;
            }
        }
        JgclPureBezierCurve3D result = this.isRational() ? new JgclPureBezierCurve3D(pnts, ws) : new JgclPureBezierCurve3D(pnts);
        return result;
    }

    public JgclBsplineSurface3D toBsplineSurface() {
        double[][] www = this.isRational() ? this.weights : this.makeUniformWeights();
        return new JgclBsplineSurface3D(JgclBsplineKnot.quasiUniformKnotsOfLinearOneSegment, JgclBsplineKnot.quasiUniformKnotsOfLinearOneSegment, this.controlPoints, www);
    }

    public JgclBsplineSurface3D toBsplineSurface(JgclParameterSection uPint, JgclParameterSection vPint) {
        return this.truncate(uPint, vPint).toBsplineSurface();
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
        return JgclIntsCncBzs3D.intersection(mate, this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclConic3D mate, boolean doExchange) {
        return JgclIntsCncBzs3D.intersection(mate, this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
        return JgclIntsBzcBzs3D.intersection(mate, this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
        return JgclIntsBscBzs3D.intersection(mate, this, !doExchange);
    }

    public JgclSurfaceSurfaceInterference3D[] intersect(JgclParametricSurface3D mate) {
        return mate.intersect(this, true);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclPlane3D mate, boolean doExchange) {
        return JgclIntsQrdBzs3D.intersection(mate, this, !doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclSphericalSurface3D mate, boolean doExchange) {
        return JgclIntsQrdBzs3D.intersection(mate, this, !doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclCylindricalSurface3D mate, boolean doExchange) {
        return JgclIntsQrdBzs3D.intersection(mate, this, !doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclConicalSurface3D mate, boolean doExchange) {
        return JgclIntsQrdBzs3D.intersection(mate, this, !doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclPureBezierSurface3D mate, boolean doExchange) {
        if (doExchange) {
            return JgclIntsBzsBzs3D.intersection(mate, this);
        }
        return JgclIntsBzsBzs3D.intersection(this, mate);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclBsplineSurface3D mate, boolean doExchange) {
        return JgclIntsSrfBss3D.intersection(this, mate, doExchange);
    }

    public JgclBsplineSurface3D offsetByBsplineSurface(JgclParameterSection uPint, JgclParameterSection vPint, double magni, int side, JgclToleranceForDistance tol) {
        JgclOfst3D doObj = new JgclOfst3D(this, uPint, vPint, magni, side, tol);
        return doObj.offset();
    }

    public JgclParametricCurve3D uIsoParametricCurve(double uParam) {
        uParam = this.checkUParameter(uParam);
        boolean isPoly = this.isPolynomial();
        double[][][] cntlPnts = this.toDoubleArray(isPoly);
        int uUicp = this.uNControlPoints();
        int vUicp = this.vNControlPoints();
        double[][] tBzc = new double[uUicp][];
        double[][] bzc = new double[vUicp][];
        int i = 0;
        while (i < vUicp) {
            int j = 0;
            while (j < uUicp) {
                tBzc[j] = cntlPnts[j][i];
                ++j;
            }
            bzc[i] = JgclPureBezierCurveEvaluation.coordinates(tBzc, uParam);
            ++i;
        }
        return new JgclPureBezierCurve3D(bzc);
    }

    public JgclParametricCurve3D vIsoParametricCurve(double vParam) {
        vParam = this.checkVParameter(vParam);
        boolean isPoly = this.isPolynomial();
        double[][][] cntlPnts = this.toDoubleArray(isPoly);
        int uUicp = this.uNControlPoints();
        double[][] bzc = new double[uUicp][];
        int i = 0;
        while (i < uUicp) {
            bzc[i] = JgclPureBezierCurveEvaluation.coordinates(cntlPnts[i], vParam);
            ++i;
        }
        return new JgclPureBezierCurve3D(bzc);
    }

    double[][][][] allocateIntermediateDoubleArrayForDividing() {
        boolean isPoly = this.isPolynomial();
        int uUicp = this.uNControlPoints();
        int vUicp = this.vNControlPoints();
        double[][][][] bzss_array = new double[2][][][];
        int i = 0;
        while (i < 2) {
            bzss_array[i] = JgclFreeformSurfaceWithControlPoints3D.allocateDoubleArray(isPoly, uUicp, vUicp);
            ++i;
        }
        return bzss_array;
    }

    public JgclPureBezierSurface3D[] uDivide(double uParam) {
        return this.uDivide(uParam, this.allocateIntermediateDoubleArrayForDividing());
    }

    JgclPureBezierSurface3D[] uDivide(double uParam, double[][][][] bzssArray) {
        int uUicp = this.uNControlPoints();
        int vUicp = this.vNControlPoints();
        boolean isPoly = this.isPolynomial();
        uParam = this.checkUParameter(uParam);
        double[][][] cntlPnts = this.toDoubleArray(isPoly);
        double[][] bzc = new double[uUicp][];
        double[][][] bzcsArray = new double[2][uUicp][];
        int i = 0;
        while (i < vUicp) {
            int j = 0;
            while (j < uUicp) {
                bzc[j] = cntlPnts[j][i];
                bzcsArray[0][j] = bzssArray[0][j][i];
                bzcsArray[1][j] = bzssArray[1][j][i];
                ++j;
            }
            try {
                JgclPureBezierCurveEvaluation.divide(bzc, uParam, bzcsArray);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        JgclPureBezierSurface3D[] bzss = new JgclPureBezierSurface3D[2];
        i = 0;
        while (i < 2) {
            try {
                bzss[i] = new JgclPureBezierSurface3D(bzssArray[i], false);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        return bzss;
    }

    public JgclPureBezierSurface3D[] vDivide(double vParam) {
        return this.vDivide(vParam, this.allocateIntermediateDoubleArrayForDividing());
    }

    JgclPureBezierSurface3D[] vDivide(double vParam, double[][][][] bzssArray) {
        int uUicp = this.uNControlPoints();
        int vUicp = this.vNControlPoints();
        boolean isPoly = this.isPolynomial();
        vParam = this.checkVParameter(vParam);
        double[][][] cntlPnts = this.toDoubleArray(isPoly);
        double[][][] bzcsArray = new double[2][][];
        int i = 0;
        while (i < uUicp) {
            bzcsArray[0] = bzssArray[0][i];
            bzcsArray[1] = bzssArray[1][i];
            try {
                JgclPureBezierCurveEvaluation.divide(cntlPnts[i], vParam, bzcsArray);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        JgclPureBezierSurface3D[] bzss = new JgclPureBezierSurface3D[2];
        i = 0;
        while (i < 2) {
            try {
                bzss[i] = new JgclPureBezierSurface3D(bzssArray[i], false);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        return bzss;
    }

    public JgclPureBezierSurface3D truncate(JgclParameterSection uSection, JgclParameterSection vSection) {
        JgclPureBezierSurface3D t_bzs = this.truncate(uSection, true);
        t_bzs = t_bzs.truncate(vSection, false);
        return t_bzs;
    }

    private JgclPureBezierSurface3D truncate(JgclParameterSection section, boolean isU) {
        JgclPureBezierSurface3D t_bzs;
        double end_par;
        double start_par;
        if (isU) {
            start_par = this.checkUParameter(section.lower());
            end_par = this.checkUParameter(section.upper());
            t_bzs = this.uDivide(start_par)[1];
        } else {
            start_par = this.checkVParameter(section.lower());
            end_par = this.checkVParameter(section.upper());
            t_bzs = this.vDivide(start_par)[1];
        }
        end_par = (end_par - start_par) / (1.0 - start_par);
        t_bzs = isU ? t_bzs.uDivide(end_par)[0] : t_bzs.vDivide(end_par)[0];
        if (section.increase() < 0.0) {
            t_bzs = isU ? t_bzs.reverse(true, false) : t_bzs.reverse(false, true);
        }
        return t_bzs;
    }

    private JgclPureBezierSurface3D reverse(boolean isU, boolean isV) {
        boolean isRat = this.isRational();
        int uUicp = this.uNControlPoints();
        int vUicp = this.vNControlPoints();
        JgclPoint3D[][] rCp = new JgclPoint3D[uUicp][vUicp];
        double[][] rWt = null;
        if (!isU && !isV) {
            return this;
        }
        if (isRat) {
            rWt = new double[uUicp][vUicp];
        }
        int j = isU ? uUicp - 1 : 0;
        int i = 0;
        while (i < uUicp) {
            int l = isV ? vUicp - 1 : 0;
            int k = 0;
            while (k < vUicp) {
                rCp[i][k] = this.controlPointAt(j, l);
                if (isRat) {
                    rWt[i][k] = this.weightAt(j, l);
                }
                l = isV ? --l : ++l;
                ++k;
            }
            j = isU ? --j : ++j;
            ++i;
        }
        try {
            JgclPureBezierSurface3D result = isRat ? new JgclPureBezierSurface3D(rCp, rWt) : new JgclPureBezierSurface3D(rCp);
            return result;
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    JgclParameterDomain getUParameterDomain() {
        try {
            return new JgclParameterDomain(false, 0.0, 1.0);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    JgclParameterDomain getVParameterDomain() {
        try {
            return new JgclParameterDomain(false, 0.0, 1.0);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    private double checkUParameter(double param) {
        this.checkUValidity(param);
        return this.uParameterDomain().force(param);
    }

    private double checkVParameter(double param) {
        this.checkVValidity(param);
        return this.vParameterDomain().force(param);
    }

    public JgclPureBezierSurface3D uElevateOneDegree() {
        boolean isPoly = this.isPolynomial();
        int uNCP = this.uNControlPoints();
        int vNCP = this.vNControlPoints();
        double[][][] newCP = JgclFreeformSurfaceWithControlPoints3D.allocateDoubleArray(isPoly, uNCP + 1, vNCP);
        this.setCoordinatesToDoubleArray(isPoly, uNCP, vNCP, newCP);
        double[][] curve = new double[uNCP + 1][];
        int vi = 0;
        while (vi < vNCP) {
            int ui = 0;
            while (ui < uNCP + 1) {
                curve[ui] = newCP[ui][vi];
                ++ui;
            }
            JgclPureBezierCurveEvaluation.elevateOneDegree(uNCP, curve);
            ++vi;
        }
        return new JgclPureBezierSurface3D(newCP);
    }

    public JgclPureBezierSurface3D vElevateOneDegree() {
        boolean isPoly = this.isPolynomial();
        int uNCP = this.uNControlPoints();
        int vNCP = this.vNControlPoints();
        double[][][] newCP = JgclFreeformSurfaceWithControlPoints3D.allocateDoubleArray(isPoly, uNCP, vNCP + 1);
        this.setCoordinatesToDoubleArray(isPoly, uNCP, vNCP, newCP);
        int ui = 0;
        while (ui < uNCP) {
            JgclPureBezierCurveEvaluation.elevateOneDegree(vNCP, newCP[ui]);
            ++ui;
        }
        return new JgclPureBezierSurface3D(newCP);
    }

    int type() {
        return 31;
    }

    public Vector toNonStructuredPoints(JgclParameterSection uParameterSection, JgclParameterSection vParameterSection, double tolerance, double[] scalingFactor) {
        Vector<JgclPoint3D> result = new Vector<JgclPoint3D>();
        JgclMesh3D mesh = this.toMesh(uParameterSection, vParameterSection, new JgclToleranceForDistance(tolerance));
        int u = 0;
        while (u < mesh.uNPoints()) {
            int v = 0;
            while (v < mesh.vNPoints()) {
                result.addElement(mesh.pointAt(u, v));
                ++v;
            }
            ++u;
        }
        scalingFactor[0] = this.getMaxLengthOfUControlPolygons(false);
        scalingFactor[1] = this.getMaxLengthOfVControlPolygons(false);
        return result;
    }

    protected synchronized JgclParametricSurface3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint3D[][] tControlPoints = new JgclPoint3D[this.uNControlPoints()][];
        int i = 0;
        while (i < this.uNControlPoints()) {
            tControlPoints[i] = JgclPoint3D.transform(this.controlPoints[i], reverseTransform, transformationOperator, transformedGeometries);
            ++i;
        }
        if (this.isPolynomial()) {
            return new JgclPureBezierSurface3D(tControlPoints);
        }
        return new JgclPureBezierSurface3D(tControlPoints, this.weights);
    }

    protected void output(PrintWriter writer, int indent) {
        int j;
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tuNControlPoints\t" + this.uNControlPoints());
        writer.println(String.valueOf(indent_tab) + "\tvNControlPoints\t" + this.vNControlPoints());
        writer.println(String.valueOf(indent_tab) + "\tcontrolPoints");
        int i = 0;
        while (i < this.controlPoints.length) {
            j = 0;
            while (j < this.controlPoints[i].length) {
                this.controlPoints[i][j].output(writer, indent + 2);
                ++j;
            }
            ++i;
        }
        if (this.weights() != null) {
            writer.println(String.valueOf(indent_tab) + "\tweights ");
            j = 0;
            while (j < this.weights().length) {
                writer.print(String.valueOf(indent_tab) + "\t\t");
                int k = 0;
                while (k < this.weights()[j].length) {
                    writer.print(" " + this.weightAt(j, k));
                    ++k;
                }
                writer.println();
                ++j;
            }
        }
        writer.println(String.valueOf(indent_tab) + "End");
    }

    private class getDirInfo {
        private boolean firstCall;
        private int u;
        private int v;
        private JgclVector3D dir;

        private getDirInfo() {
            JgclPureBezierSurface3D.this = JgclPureBezierSurface3D.this;
        }

        static /* synthetic */ boolean access$0(getDirInfo $0) {
            return $0.firstCall;
        }

        static /* synthetic */ int access$4(getDirInfo $0) {
            return $0.v;
        }

        static /* synthetic */ void access$5(getDirInfo $0, int $1) {
            $0.v = $1;
        }

        static /* synthetic */ int access$6(getDirInfo $0) {
            return $0.u;
        }

        static /* synthetic */ void access$7(getDirInfo $0, int $1) {
            $0.u = $1;
        }
    }
}

