/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclAxis2Placement2D;
import jp.go.ipa.jgcl.JgclBinaryTree;
import jp.go.ipa.jgcl.JgclBoundedCurve2D;
import jp.go.ipa.jgcl.JgclBoundedLine2D;
import jp.go.ipa.jgcl.JgclBsplineCurve2D;
import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclCommonNormal2D;
import jp.go.ipa.jgcl.JgclCommonTangent2D;
import jp.go.ipa.jgcl.JgclComplex;
import jp.go.ipa.jgcl.JgclComplexPolynomial;
import jp.go.ipa.jgcl.JgclCompositeCurve2D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment2D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclCurveCurvature2D;
import jp.go.ipa.jgcl.JgclCurveCurveInterference2D;
import jp.go.ipa.jgcl.JgclCurveDerivative2D;
import jp.go.ipa.jgcl.JgclEllipse2D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclFreeformCurveWithControlPoints2D;
import jp.go.ipa.jgcl.JgclHomogeneousPoint2D;
import jp.go.ipa.jgcl.JgclHyperbola2D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclIntsBzcBsc2D;
import jp.go.ipa.jgcl.JgclIntsBzcBzc2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclLiteralVector2D;
import jp.go.ipa.jgcl.JgclMachineEpsilon;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclOfst2D;
import jp.go.ipa.jgcl.JgclParabola2D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterOutOfRange;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPointOnGeometryList;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclPolynomialCurve2D;
import jp.go.ipa.jgcl.JgclPureBezierCurveEvaluation;
import jp.go.ipa.jgcl.JgclRealFunctionWithOneVariable;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve2D;
import jp.go.ipa.jgcl.JgclVector2D;
import jp.go.ipa.jgcl.JgclZeroLength;

public class JgclPureBezierCurve2D
extends JgclFreeformCurveWithControlPoints2D {
    public JgclPureBezierCurve2D(JgclPoint2D[] controlPoints) {
        super(controlPoints);
    }

    public JgclPureBezierCurve2D(JgclPoint2D[] controlPoints, double[] weights) {
        super(controlPoints, weights);
    }

    public JgclPureBezierCurve2D(JgclPoint2D[] controlPoints, double[] weights, boolean doCheck) {
        super(controlPoints, weights, doCheck);
    }

    JgclPureBezierCurve2D(double[][] cpArray) {
        super(cpArray);
    }

    public int degree() {
        return this.nControlPoints() - 1;
    }

    public JgclRealPolynomial[] polynomial(boolean isPoly) {
        int uicp = this.nControlPoints();
        double[][] dDcoef = this.toDoubleArray(isPoly);
        int npoly = dDcoef[0].length;
        double[] coef = new double[uicp];
        JgclRealPolynomial[] polynomial = new JgclRealPolynomial[npoly];
        int klm = 0;
        while (klm < npoly) {
            int ijk = 0;
            while (ijk < uicp) {
                coef[ijk] = dDcoef[ijk][klm];
                ++ijk;
            }
            ijk = 0;
            while (ijk < uicp) {
                int mno = uicp - 1;
                while (ijk < mno) {
                    int n = mno;
                    coef[n] = coef[n] - coef[mno - 1];
                    --mno;
                }
                ++ijk;
            }
            int binml = 1;
            ijk = 1;
            int kji = uicp - 2;
            while (ijk < kji) {
                binml = binml * (uicp - ijk) / ijk;
                int n = ijk++;
                coef[n] = coef[n] * (double)binml;
                int n2 = kji--;
                coef[n2] = coef[n2] * (double)binml;
            }
            if (ijk == kji) {
                binml = binml * (uicp - ijk) / ijk;
                int n = ijk;
                coef[n] = coef[n] * (double)binml;
            }
            polynomial[klm] = new JgclRealPolynomial(coef);
            ++klm;
        }
        return polynomial;
    }

    public JgclPolynomialCurve2D polynomialCurve(boolean isPoly) {
        JgclRealPolynomial[] poly = this.polynomial(isPoly);
        if (isPoly) {
            return new JgclPolynomialCurve2D(poly[0], poly[1]);
        }
        return new JgclPolynomialCurve2D(poly[0], poly[1], poly[2]);
    }

    JgclParameterSection checkBoundary(JgclParameterSection pint) {
        this.checkValidity(pint);
        double start = pint.start();
        if (start < 0.0) {
            start = 0.0;
        } else if (start > 1.0) {
            start = 1.0;
        }
        double end = pint.end();
        if (end < 0.0) {
            end = 0.0;
        } else if (end > 1.0) {
            end = 1.0;
        }
        return new JgclParameterSection(start, end - start);
    }

    public double length(JgclParameterSection pint) {
        JgclRealFunctionWithOneVariable realFunction;
        pint = this.checkBoundary(pint);
        if (!this.isPolynomial()) {
            realFunction = new 1();
        } else {
            JgclRealPolynomial[] poly = this.polynomial(this.isPolynomial());
            JgclRealPolynomial[] deriv = new JgclRealPolynomial[poly.length];
            int ijk = 0;
            while (ijk < 2) {
                deriv[ijk] = poly[ijk].derive();
                ++ijk;
            }
            realFunction = new 2(deriv);
        }
        double dTol = this.getToleranceForDistance() / 2.0;
        return JgclMath.getDefiniteIntegral(realFunction, pint, dTol);
    }

    public JgclPoint2D coordinates(double param) {
        boolean isPoly = this.isPolynomial();
        param = this.checkParameter(param);
        double[][] cntlPnts = this.toDoubleArray(isPoly);
        double[] d0D = JgclPureBezierCurveEvaluation.coordinates(cntlPnts, param);
        if (!isPoly) {
            this.convRational0Deriv(d0D);
        }
        return new JgclCartesianPoint2D(d0D[0], d0D[1]);
    }

    public JgclVector2D tangentVector(double param) {
        double[] d1D = new double[3];
        boolean isPoly = this.isPolynomial();
        param = this.checkParameter(param);
        double[][] cntlPnts = this.toDoubleArray(isPoly);
        if (isPoly) {
            JgclPureBezierCurveEvaluation.evaluation(cntlPnts, param, null, d1D, null, null);
        } else {
            double[] d0D = new double[3];
            JgclPureBezierCurveEvaluation.evaluation(cntlPnts, param, d0D, d1D, null, null);
            this.convRational1Deriv(d0D, d1D);
        }
        return new JgclLiteralVector2D(d1D[0], d1D[1]);
    }

    public JgclCurveCurvature2D curvature(double param) {
        JgclVector2D dDnrm;
        double dDcrv;
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double tol_d = condition.getToleranceForDistance();
        int degree = this.degree();
        JgclCurveDerivative2D deriv = this.evaluation(param);
        double tang_leng = deriv.d1D().norm();
        boolean tang0 = tang_leng < tol_d * tol_d;
        if (degree < 2 || tang0) {
            dDcrv = 0.0;
            dDnrm = JgclVector2D.zeroVector;
        } else {
            tang_leng = Math.sqrt(tang_leng);
            dDcrv = tang_leng * tang_leng * tang_leng;
            double ewvec = deriv.d1D().zOfCrossProduct(deriv.d2D());
            dDcrv = Math.abs(ewvec) / dDcrv;
            dDnrm = ewvec < 0.0 ? new JgclLiteralVector2D(deriv.d1D().y(), -deriv.d1D().x()) : new JgclLiteralVector2D(-deriv.d1D().y(), deriv.d1D().x());
            dDnrm = dDnrm.unitized();
        }
        return new JgclCurveCurvature2D(dDcrv, dDnrm);
    }

    public JgclCurveDerivative2D evaluation(double param) {
        double[] ld0D = new double[3];
        double[] ld1D = new double[3];
        double[] ld2D = new double[3];
        boolean isPoly = this.isPolynomial();
        param = this.checkParameter(param);
        double[][] cntlPnts = this.toDoubleArray(isPoly);
        JgclPureBezierCurveEvaluation.evaluation(cntlPnts, param, ld0D, ld1D, ld2D, null);
        if (!isPoly) {
            this.convRational2Deriv(ld0D, ld1D, ld2D);
        }
        JgclCartesianPoint2D d0D = new JgclCartesianPoint2D(ld0D[0], ld0D[1]);
        JgclLiteralVector2D d1D = new JgclLiteralVector2D(ld1D[0], ld1D[1]);
        JgclLiteralVector2D d2D = new JgclLiteralVector2D(ld2D[0], ld2D[1]);
        return new JgclCurveDerivative2D(d0D, d1D, d2D);
    }

    public JgclPoint2D blossoming(double[] parameters) {
        double[] adjustedParameters = new double[this.nControlPoints() - 1];
        int i = 0;
        while (i < this.nControlPoints() - 1) {
            adjustedParameters[i] = this.checkParameter(parameters[i]);
            ++i;
        }
        boolean isPoly = this.isPolynomial();
        double[] d0D = JgclPureBezierCurveEvaluation.blossoming(this.toDoubleArray(isPoly), adjustedParameters);
        if (isPoly) {
            return new JgclCartesianPoint2D(d0D[0], d0D[1]);
        }
        return new JgclHomogeneousPoint2D(d0D[0], d0D[1], d0D[2]);
    }

    public JgclPointOnCurve2D[] singular() throws JgclIndefiniteSolution {
        JgclComplex[] root;
        JgclComplexPolynomial dtPoly;
        int uicp = this.nControlPoints();
        int uicp_1 = uicp - 1;
        Vector<Double> paramVec = new Vector<Double>();
        int ijk = 1;
        while (ijk < uicp) {
            if (!this.startPoint().identical(this.controlPointAt(ijk))) break;
            ++ijk;
        }
        if (ijk == uicp) {
            throw new JgclIndefiniteSolution(this);
        }
        if (this.startPoint().identical(this.controlPointAt(1))) {
            paramVec.addElement(new Double(0.0));
        }
        if (this.endPoint().identical(this.controlPointAt(uicp_1 - 1))) {
            paramVec.addElement(new Double(1.0));
        }
        JgclRealPolynomial[] pointPoly = this.polynomial(this.isPolynomial());
        int polySize = pointPoly.length;
        JgclRealPolynomial[] tangPoly = new JgclRealPolynomial[polySize];
        JgclRealPolynomial[] dotePoly = new JgclRealPolynomial[2];
        int klm = 0;
        while (klm < polySize) {
            tangPoly[klm] = pointPoly[klm].derive();
            ++klm;
        }
        if (!this.isRational()) {
            klm = 0;
            while (klm < 2) {
                dotePoly[klm] = tangPoly[klm].multiply(tangPoly[klm]);
                ++klm;
            }
        } else {
            klm = 0;
            while (klm < 2) {
                JgclRealPolynomial work0 = pointPoly[2].multiply(tangPoly[klm]);
                JgclRealPolynomial work1 = tangPoly[2].multiply(pointPoly[klm]);
                JgclRealPolynomial sub = work0.subtract(work1);
                dotePoly[klm] = sub.multiply(sub);
                ++klm;
            }
        }
        try {
            dtPoly = dotePoly[0].add(dotePoly[1]).normalize().toComplexPolynomial();
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
        try {
            root = dtPoly.getRootsByDKA();
        }
        catch (JgclComplexPolynomial.DKANotConverge e) {
            root = e.getValues();
        }
        catch (JgclComplexPolynomial.ImpossibleEquation impossibleEquation) {
            throw new JgclFatal();
        }
        catch (JgclComplexPolynomial.IndefiniteEquation indefiniteEquation) {
            throw new JgclFatal();
        }
        JgclParameterDomain pdmn = this.parameterDomain();
        ijk = 0;
        while (ijk < root.length) {
            if (pdmn.isValid(root[ijk].real())) {
                JgclVector2D tangent;
                if (root[ijk].real() < 0.0) {
                    root[ijk] = new JgclComplex(0.0);
                }
                if (root[ijk].real() > 1.0) {
                    root[ijk] = new JgclComplex(1.0);
                }
                try {
                    JgclPoint2D point = this.coordinates(root[ijk].real());
                    tangent = this.tangentVector(root[ijk].real());
                }
                catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
                    throw new JgclFatal();
                }
                double dTol2 = this.getToleranceForDistance2();
                if (!(tangent.norm() > dTol2)) {
                    klm = 0;
                    while (klm < paramVec.size()) {
                        if (this.identicalParameter(root[ijk].real(), (Double)paramVec.elementAt(klm))) break;
                        ++klm;
                    }
                    if (klm >= paramVec.size()) {
                        paramVec.addElement(new Double(root[ijk].real()));
                    }
                }
            }
            ++ijk;
        }
        JgclPointOnCurve2D[] singularPoint = new JgclPointOnCurve2D[paramVec.size()];
        ijk = 0;
        while (ijk < paramVec.size()) {
            singularPoint[ijk] = new JgclPointOnCurve2D(this, (Double)paramVec.elementAt(ijk), false);
            ++ijk;
        }
        return singularPoint;
    }

    public JgclPointOnCurve2D[] inflexion() throws JgclIndefiniteSolution {
        JgclComplex[] root;
        JgclCurveCurvature2D crv;
        int uicp = this.nControlPoints();
        int uicp_1 = uicp - 1;
        JgclPoint2D[] cp = this.controlPoints();
        if (uicp_1 < 2) {
            throw new JgclIndefiniteSolution(this);
        }
        Vector<Double> paramVec = new Vector<Double>();
        Vector<JgclCurveCurvature2D> crvVec = new Vector<JgclCurveCurvature2D>();
        JgclVector2D collinearDir = JgclPoint2D.collinear(cp, 0, uicp_1);
        if (collinearDir != null) {
            throw new JgclIndefiniteSolution(this);
        }
        collinearDir = JgclPoint2D.collinear(cp, 0, 2);
        if (collinearDir != null) {
            crv = this.curvature(0.0);
            paramVec.addElement(new Double(0.0));
            crvVec.addElement(crv);
        }
        if ((collinearDir = JgclPoint2D.collinear(cp, uicp_1 - 2, uicp_1)) != null) {
            crv = this.curvature(1.0);
            paramVec.addElement(new Double(1.0));
            crvVec.addElement(crv);
        }
        JgclPolynomialCurve2D polyCurve = this.polynomialCurve(this.isPolynomial());
        JgclRealPolynomial crossPoly = polyCurve.crossProductD1D2();
        JgclRealPolynomial normalizedPoly = crossPoly.normalize();
        JgclComplexPolynomial complexPoly = normalizedPoly.toComplexPolynomial();
        try {
            root = complexPoly.getRootsByDKA();
        }
        catch (JgclComplexPolynomial.DKANotConverge e) {
            root = e.getValues();
        }
        catch (JgclComplexPolynomial.ImpossibleEquation impossibleEquation) {
            throw new JgclFatal();
        }
        catch (JgclComplexPolynomial.IndefiniteEquation indefiniteEquation) {
            throw new JgclFatal();
        }
        JgclParameterDomain pdmn = this.parameterDomain();
        int ijk = 0;
        while (ijk < root.length) {
            if (pdmn.isValid(root[ijk].real())) {
                if (root[ijk].real() < 0.0) {
                    root[ijk] = new JgclComplex(0.0);
                }
                if (root[ijk].real() > 1.0) {
                    root[ijk] = new JgclComplex(1.0);
                }
                crv = this.curvature(root[ijk].real());
                double dTol = this.getToleranceForDistance();
                if (!(Math.abs(crv.curvature()) > dTol)) {
                    double intvl = 1.0 / (double)uicp_1;
                    int klm = 0;
                    while (klm < paramVec.size()) {
                        if (Math.abs(root[ijk].real() - (Double)paramVec.elementAt(klm)) < intvl) {
                            int mno = 1;
                            while (mno < uicp_1) {
                                double stake = (double)mno * intvl;
                                if ((root[ijk].real() - stake) * ((Double)paramVec.elementAt(klm) - stake) < 0.0) break;
                                ++mno;
                            }
                            if (mno == uicp_1) {
                                if (!(Math.abs(crv.curvature()) < Math.abs(((JgclCurveCurvature2D)crvVec.elementAt(klm)).curvature()))) break;
                                paramVec.addElement(new Double(root[ijk].real()));
                                crvVec.addElement(crv);
                                break;
                            }
                        }
                        ++klm;
                    }
                    if (klm >= paramVec.size()) {
                        paramVec.addElement(new Double(root[ijk].real()));
                        crvVec.addElement(crv);
                    }
                }
            }
            ++ijk;
        }
        JgclPointOnCurve2D[] inflexion = new JgclPointOnCurve2D[paramVec.size()];
        ijk = 0;
        while (ijk < paramVec.size()) {
            inflexion[ijk] = new JgclPointOnCurve2D(this, (Double)paramVec.elementAt(ijk), false);
            ++ijk;
        }
        return inflexion;
    }

    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D mate) {
        JgclComplex[] root;
        JgclComplexPolynomial dtPoly;
        JgclRealPolynomial[] pointPoly = this.polynomial(this.isPolynomial());
        JgclRealPolynomial[] offsPoly = new JgclRealPolynomial[2];
        int coef_size = pointPoly.length;
        if (this.isRational()) {
            offsPoly[0] = pointPoly[2].multiply(mate.x());
            offsPoly[1] = pointPoly[2].multiply(mate.y());
        } else {
            double[][] coef = new double[][]{{mate.x()}, {mate.y()}};
            offsPoly[0] = new JgclRealPolynomial(coef[0]);
            offsPoly[1] = new JgclRealPolynomial(coef[1]);
        }
        int i = 0;
        while (i < 2) {
            pointPoly[i] = pointPoly[i].subtract(offsPoly[i]);
            ++i;
        }
        JgclRealPolynomial[] tangPoly = new JgclRealPolynomial[coef_size];
        JgclRealPolynomial[] dotePoly = new JgclRealPolynomial[2];
        int klm = 0;
        while (klm < coef_size) {
            tangPoly[klm] = pointPoly[klm].derive();
            ++klm;
        }
        if (!this.isRational()) {
            int klm2 = 0;
            while (klm2 < 2) {
                dotePoly[klm2] = pointPoly[klm2].multiply(tangPoly[klm2]);
                ++klm2;
            }
        } else {
            int klm3 = 0;
            while (klm3 < 2) {
                JgclRealPolynomial work0 = pointPoly[2].multiply(tangPoly[klm3]);
                JgclRealPolynomial work1 = tangPoly[2].multiply(pointPoly[klm3]);
                JgclRealPolynomial work2 = work0.subtract(work1);
                double[] work3 = work2.coefficientsBetween(0, work2.degree() - 1);
                JgclRealPolynomial sub = new JgclRealPolynomial(work3);
                dotePoly[klm3] = pointPoly[klm3].multiply(sub);
                ++klm3;
            }
        }
        try {
            dtPoly = dotePoly[0].add(dotePoly[1]).toComplexPolynomial();
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
        try {
            root = dtPoly.getRootsByDKA();
        }
        catch (JgclComplexPolynomial.DKANotConverge e) {
            root = e.getValues();
        }
        catch (JgclComplexPolynomial.ImpossibleEquation impossibleEquation) {
            throw new JgclFatal();
        }
        catch (JgclComplexPolynomial.IndefiniteEquation indefiniteEquation) {
            throw new JgclFatal();
        }
        JgclPointOnGeometryList projList = new JgclPointOnGeometryList();
        JgclParameterDomain domain = this.parameterDomain();
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol = condition.getToleranceForDistance();
        int i2 = 0;
        while (i2 < root.length) {
            double par = root[i2].real();
            if (domain.isValid(par)) {
                JgclPointOnCurve2D proj;
                if (par > 1.0) {
                    par = 1.0;
                }
                if (par < 0.0) {
                    par = 0.0;
                }
                if ((proj = this.checkProjection(par, mate, dTol * dTol)) != null) {
                    projList.addPoint(proj);
                }
            }
            ++i2;
        }
        return projList.toJgclPointOnCurve2DArray();
    }

    public JgclBsplineCurve2D toBsplineCurve() {
        double[] www = this.isRational() ? this.weights : this.makeUniformWeights();
        return new JgclBsplineCurve2D(JgclBsplineKnot.quasiUniformKnotsOfLinearOneSegment, this.controlPoints, www);
    }

    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
        return this.truncate(pint).toBsplineCurve();
    }

    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate) {
        return mate.intersect(this, true);
    }

    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
        JgclComplex[] roots;
        JgclAxis2Placement2D placement = new JgclAxis2Placement2D(mate.pnt(), mate.dir());
        JgclCartesianTransformationOperator2D transform = new JgclCartesianTransformationOperator2D(placement, 1.0);
        int uicp = this.nControlPoints();
        JgclPoint2D[] newCp = new JgclPoint2D[uicp];
        int i = 0;
        while (i < uicp) {
            newCp[i] = transform.toLocal(this.controlPointAt(i));
            ++i;
        }
        double[] weights = this.weights();
        if (this.isRational()) {
            double max_weight = 0.0;
            int i2 = 0;
            while (i2 < uicp) {
                if (Math.abs(weights[i2]) > max_weight) {
                    max_weight = weights[i2];
                }
                ++i2;
            }
            if (max_weight > 0.0) {
                int i3 = 0;
                while (i3 < uicp) {
                    int n = i3++;
                    weights[n] = weights[n] / max_weight;
                }
            }
        }
        JgclPureBezierCurve2D bzc = new JgclPureBezierCurve2D(newCp, weights, false);
        JgclRealPolynomial[] realPoly = bzc.polynomial(this.isPolynomial());
        JgclComplexPolynomial compPoly = realPoly[1].toComplexPolynomial();
        try {
            roots = compPoly.getRootsByDKA();
        }
        catch (JgclComplexPolynomial.DKANotConverge e) {
            roots = e.getValues();
        }
        catch (JgclComplexPolynomial.ImpossibleEquation impossibleEquation) {
            throw new JgclFatal();
        }
        catch (JgclComplexPolynomial.IndefiniteEquation indefiniteEquation) {
            throw new JgclFatal();
        }
        int nRoots = roots.length;
        Vector<Double> lineParam = new Vector<Double>();
        Vector<Double> bzcParam = new Vector<Double>();
        Vector<JgclPoint2D> bzcPoints = new Vector<JgclPoint2D>();
        int j = 0;
        while (j < nRoots) {
            double realRoot = roots[j].real();
            if (bzc.parameterValidity(realRoot) != 3) {
                if (realRoot < 0.0) {
                    realRoot = 0.0;
                }
                if (realRoot > 1.0) {
                    realRoot = 1.0;
                }
                JgclPoint2D workPoint = bzc.coordinates(realRoot);
                double dTol = bzc.getToleranceForDistance();
                int paramNum = bzcParam.size();
                if (Math.abs(workPoint.y()) < dTol) {
                    int k = 0;
                    while (k < paramNum) {
                        double paramA = (Double)bzcParam.elementAt(k);
                        double paramB = (Double)lineParam.elementAt(k);
                        if (Math.abs(paramB - workPoint.x()) < dTol && bzc.identicalParameter(realRoot, paramA)) break;
                        ++k;
                    }
                    if (k >= paramNum) {
                        bzcParam.addElement(new Double(realRoot));
                        lineParam.addElement(new Double(workPoint.x()));
                        bzcPoints.addElement(transform.toEnclosed(workPoint));
                    }
                }
            }
            ++j;
        }
        int num = bzcParam.size();
        JgclIntersectionPoint2D[] intersectPoint = new JgclIntersectionPoint2D[num];
        double mateLength = mate.dir().length();
        int i4 = 0;
        while (i4 < num) {
            double work = (Double)lineParam.elementAt(i4) / mateLength;
            JgclPointOnCurve2D pointOnLine = new JgclPointOnCurve2D(mate, work, false);
            work = (Double)bzcParam.elementAt(i4);
            JgclPointOnCurve2D pointOnBzc = new JgclPointOnCurve2D(this, work, false);
            JgclPoint2D coordinates = (JgclPoint2D)bzcPoints.elementAt(i4);
            intersectPoint[i4] = !doExchange ? new JgclIntersectionPoint2D(coordinates, pointOnBzc, pointOnLine, false) : new JgclIntersectionPoint2D(coordinates, pointOnLine, pointOnBzc, false);
            ++i4;
        }
        return intersectPoint;
    }

    JgclIntersectionPoint2D[] intersect(JgclCircle2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclEllipse2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclParabola2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclPureBezierCurve2D mate, boolean doExchange) {
        return JgclIntsBzcBzc2D.intersection(this, mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclBsplineCurve2D mate, boolean doExchange) {
        return JgclIntsBzcBsc2D.intersection(this, mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    public JgclCurveCurveInterference2D[] interfere(JgclBoundedCurve2D mate) {
        return mate.interfere(this, true);
    }

    JgclCurveCurveInterference2D[] interfere(JgclBoundedLine2D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclPolyline2D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclPureBezierCurve2D mate, boolean doExchange) {
        return JgclIntsBzcBzc2D.interference(this, mate, doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclBsplineCurve2D mate, boolean doExchange) {
        return JgclIntsBzcBsc2D.interference(this, mate, doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclTrimmedCurve2D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurveSegment2D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurve2D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    public JgclBsplineCurve2D offsetByBsplineCurve(JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tol) {
        JgclOfst2D doObj = new JgclOfst2D(this, pint, magni, side, tol);
        return doObj.offset();
    }

    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    public JgclCommonNormal2D[] commonNormal(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    public JgclPureBezierCurve2D[] divide(double param) {
        double[][][] bzcs_array;
        boolean isPoly = this.isPolynomial();
        param = this.checkParameter(param);
        double[][] cntlPnts = this.toDoubleArray(isPoly);
        try {
            bzcs_array = JgclPureBezierCurveEvaluation.divide(cntlPnts, param);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
        JgclPureBezierCurve2D[] bzcs = new JgclPureBezierCurve2D[2];
        int i = 0;
        while (i < 2) {
            try {
                bzcs[i] = new JgclPureBezierCurve2D(bzcs_array[i]);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        return bzcs;
    }

    public JgclPureBezierCurve2D truncate(JgclParameterSection section) {
        double start_par = this.checkParameter(section.lower());
        double end_par = this.checkParameter(section.upper());
        JgclPureBezierCurve2D t_bzc = this.divide(start_par)[1];
        end_par = (end_par - start_par) / (1.0 - start_par);
        t_bzc = t_bzc.divide(end_par)[0];
        if (section.increase() < 0.0) {
            t_bzc = t_bzc.reverse();
        }
        return t_bzc;
    }

    public JgclPolyline2D toPolyline(JgclParameterSection section, JgclToleranceForDistance tolerance) {
        double tol = tolerance.value();
        double tol_2 = tol * tol;
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double tol_p = condition.getToleranceForParameter();
        JgclPureBezierCurve2D root_bzc = this.truncate(section.positiveIncrease());
        double sp = this.checkParameter(section.lower());
        double ep = this.checkParameter(section.upper());
        IntervalInfo root_info = new IntervalInfo(root_bzc, sp, ep);
        JgclBinaryTree pnt_tree = new JgclBinaryTree(root_info);
        int no_pnts = this.divideInterval(2, pnt_tree.rootNode(), tol_2);
        JgclPoint2D[] pnts = new JgclPoint2D[no_pnts];
        FillInfo fill_info = new FillInfo(this, pnts, 0, tol_p, ep);
        pnt_tree.rootNode().preOrderTraverse(new fillArray(), fill_info);
        if (no_pnts == 2 && pnts[0].identical(pnts[1])) {
            throw new JgclZeroLength();
        }
        if (section.increase() > 0.0) {
            return new JgclPolyline2D(pnts);
        }
        return new JgclPolyline2D(pnts).reverse();
    }

    private int divideInterval(int no_pnts, JgclBinaryTree.Node crnt_node, double tol_2) {
        JgclPureBezierCurve2D[] div_bzcs;
        double half_point = 0.5;
        ++no_pnts;
        IntervalInfo crnt_info = (IntervalInfo)crnt_node.data();
        double mid_param = (crnt_info.sp() + crnt_info.ep()) / 2.0;
        try {
            div_bzcs = crnt_info.bzc().divide(half_point);
        }
        catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
            throw new JgclFatal();
        }
        JgclPureBezierCurve2D left_bzc = div_bzcs[0];
        JgclPureBezierCurve2D right_bzc = div_bzcs[1];
        IntervalInfo left_info = new IntervalInfo(left_bzc, crnt_info.sp(), mid_param);
        JgclBinaryTree.Node left_node = crnt_node.makeLeft(left_info);
        IntervalInfo right_info = new IntervalInfo(right_bzc, mid_param, crnt_info.ep());
        JgclBinaryTree.Node right_node = crnt_node.makeRight(right_info);
        if (!this.checkInterval(left_info, tol_2)) {
            no_pnts = this.divideInterval(no_pnts, left_node, tol_2);
        }
        if (!this.checkInterval(right_info, tol_2)) {
            no_pnts = this.divideInterval(no_pnts, right_node, tol_2);
        }
        return no_pnts;
    }

    private boolean checkInterval(IntervalInfo bi, double tol_2) {
        JgclPureBezierCurve2D bzc = bi.bzc();
        int uicp_1 = bzc.nControlPoints() - 1;
        JgclVector2D edirs = bzc.controlPointAt(uicp_1).subtract(bzc.controlPointAt(0));
        int i = 1;
        while (i < uicp_1) {
            JgclPoint2D ppnt = this.projectPointLine(bzc.controlPointAt(i), bzc.controlPointAt(0), edirs);
            double dist = bzc.controlPointAt(i).subtract(ppnt).norm();
            if (dist > tol_2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private JgclPoint2D projectPointLine(JgclPoint2D dApnt, JgclPoint2D dB_pnt, JgclVector2D dB_dir) {
        double d;
        double m_eps = JgclMachineEpsilon.DOUBLE;
        double magni_dir = dB_dir.magnitude();
        JgclVector2D euvec = d < m_eps ? JgclVector2D.zeroVector : dB_dir.divide(magni_dir);
        JgclVector2D evpp = dApnt.subtract(dB_pnt);
        double edot = euvec.dotProduct(evpp);
        return dB_pnt.add(euvec.multiply(edot));
    }

    public JgclPoint2D startPoint() {
        return this.controlPointAt(0);
    }

    public JgclPoint2D endPoint() {
        int index = this.nControlPoints() - 1;
        return this.controlPointAt(index);
    }

    JgclPureBezierCurve2D reverse() {
        boolean isRat = this.isRational();
        int uicp = this.nControlPoints();
        JgclPoint2D[] rCp = new JgclPoint2D[uicp];
        double[] rWt = null;
        if (isRat) {
            rWt = new double[uicp];
        }
        int i = 0;
        int j = uicp - 1;
        while (i < uicp) {
            rCp[i] = this.controlPointAt(j);
            if (isRat) {
                rWt[i] = this.weightAt(j);
            }
            ++i;
            --j;
        }
        try {
            if (isRat) {
                return new JgclPureBezierCurve2D(rCp, rWt);
            }
            return new JgclPureBezierCurve2D(rCp);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    JgclParameterDomain getParameterDomain() {
        try {
            return new JgclParameterDomain(false, 0.0, 1.0);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    private double checkParameter(double param) {
        this.checkValidity(param);
        return this.parameterDomain().force(param);
    }

    public JgclPureBezierCurve2D elevateOneDegree() {
        boolean isPoly = this.isPolynomial();
        int nCP = this.nControlPoints();
        double[][] newCP = JgclFreeformCurveWithControlPoints2D.allocateDoubleArray(isPoly, nCP + 1);
        this.setCoordinatesToDoubleArray(isPoly, nCP, newCP);
        JgclPureBezierCurveEvaluation.elevateOneDegree(nCP, newCP);
        return new JgclPureBezierCurve2D(newCP);
    }

    int type() {
        return 22;
    }

    protected synchronized JgclParametricCurve2D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint2D[] tControlPoints = JgclPoint2D.transform(this.controlPoints, reverseTransform, transformationOperator, transformedGeometries);
        if (this.isPolynomial()) {
            return new JgclPureBezierCurve2D(tControlPoints);
        }
        return new JgclPureBezierCurve2D(tControlPoints, this.weights);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        StringBuffer buf = new StringBuffer();
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tcontrolPoints");
        int i = 0;
        while (i < this.nControlPoints()) {
            this.controlPointAt(i).output(writer, indent + 2);
            ++i;
        }
        if (this.weights() != null) {
            writer.println(String.valueOf(indent_tab) + "\tweights ");
            int i2 = 0;
            while (true) {
                int j = 0;
                while (j < 10 && i2 < this.weights().length) {
                    writer.print(" " + this.weightAt(i2));
                    ++j;
                    ++i2;
                }
                writer.println();
                if (i2 >= this.weights().length) break;
                writer.print(String.valueOf(indent_tab) + "\t");
            }
        }
        writer.println(String.valueOf(indent_tab) + "End");
    }

    private final class 1
    implements JgclRealFunctionWithOneVariable {
        public double evaluate(double parameter) {
            return JgclPureBezierCurve2D.this.tangentVector(parameter).length();
        }

        /* synthetic */ 1() {
        }
    }

    private static final class 2
    implements JgclRealFunctionWithOneVariable {
        private final /* synthetic */ JgclRealPolynomial[] val$deriv;

        public double evaluate(double parameter) {
            double[] tang = new double[2];
            int ijk = 0;
            while (ijk < 2) {
                tang[ijk] = this.val$deriv[ijk].evaluate(parameter);
                ++ijk;
            }
            return Math.sqrt(tang[0] * tang[0] + tang[1] * tang[1]);
        }

        /* synthetic */ 2(JgclRealPolynomial[] val$deriv) {
            this.val$deriv = val$deriv;
        }
    }

    private class IntervalInfo {
        private JgclPureBezierCurve2D bzc;
        private double sp;
        private double ep;

        private IntervalInfo(JgclPureBezierCurve2D bzc, double sp, double ep) {
            JgclPureBezierCurve2D.this = JgclPureBezierCurve2D.this;
            this.bzc = bzc;
            this.sp = sp;
            this.ep = ep;
        }

        private JgclPureBezierCurve2D bzc() {
            return this.bzc;
        }

        private double sp() {
            return this.sp;
        }

        private double ep() {
            return this.ep;
        }
    }

    private class FillInfo {
        private JgclParametricCurve2D basisCurve;
        private JgclPoint2D[] pnts;
        private int index;
        private double tol_p;
        private double ep;

        private FillInfo(JgclParametricCurve2D basisCurve, JgclPoint2D[] pnts, int index, double tol_p, double ep) {
            JgclPureBezierCurve2D.this = JgclPureBezierCurve2D.this;
            this.basisCurve = basisCurve;
            this.pnts = pnts;
            this.index = index;
            this.tol_p = tol_p;
            this.ep = ep;
        }
    }

    private class fillArray
    implements JgclBinaryTree.TraverseProc {
        public boolean doit(JgclBinaryTree.Node node, int ctl, Object pdata) {
            if (node.left() == null && node.right() == null) {
                try {
                    FillInfo fill_info = (FillInfo)pdata;
                    int idx = fill_info.index;
                    IntervalInfo bi = (IntervalInfo)node.data();
                    ((FillInfo)fill_info).pnts[idx++] = new JgclPointOnCurve2D(bi.bzc().controlPointAt(0), fill_info.basisCurve, bi.sp());
                    if (idx == fill_info.pnts.length - 1) {
                        ((FillInfo)fill_info).pnts[idx++] = new JgclPointOnCurve2D(bi.bzc().controlPointAt(bi.bzc().nControlPoints() - 1), fill_info.basisCurve, bi.ep());
                    }
                    fill_info.index = idx;
                }
                catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                    throw new JgclFatal();
                }
            }
            return false;
        }

        fillArray() {
            JgclPureBezierCurve2D.this = JgclPureBezierCurve2D.this;
        }
    }
}

