/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclBsplineCurve2D;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclCommonNormal2D;
import jp.go.ipa.jgcl.JgclCommonTangent2D;
import jp.go.ipa.jgcl.JgclCompositeCurve2D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment2D;
import jp.go.ipa.jgcl.JgclCurveCurvature2D;
import jp.go.ipa.jgcl.JgclCurveDerivative2D;
import jp.go.ipa.jgcl.JgclEllipse2D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclFilletObject2D;
import jp.go.ipa.jgcl.JgclHomogeneousPoint2D;
import jp.go.ipa.jgcl.JgclHomogeneousVector2D;
import jp.go.ipa.jgcl.JgclHyperbola2D;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclLiteralVector2D;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclParabola2D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;
import jp.go.ipa.jgcl.JgclRealFunctionWithOneVariable;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve2D;
import jp.go.ipa.jgcl.JgclVector2D;

public class JgclPolynomialCurve2D
extends JgclParametricCurve2D {
    private final JgclRealPolynomial polyX;
    private final JgclRealPolynomial polyY;
    private final JgclRealPolynomial polyW;
    private JgclPolynomialCurve2D derivativeCurve;

    private JgclPolynomialCurve2D() {
        this.polyX = null;
        this.polyY = null;
        this.polyW = null;
    }

    public JgclPolynomialCurve2D(JgclRealPolynomial xPoly, JgclRealPolynomial yPoly) {
        if (xPoly == null || yPoly == null) {
            throw new JgclFatal("one of arguments is null");
        }
        if (xPoly.degree() != yPoly.degree()) {
            throw new JgclFatal("given polynomials have different degrees");
        }
        this.polyX = xPoly;
        this.polyY = yPoly;
        this.polyW = null;
        this.derivativeCurve = null;
    }

    public JgclPolynomialCurve2D(JgclRealPolynomial wxPoly, JgclRealPolynomial wyPoly, JgclRealPolynomial wPoly) {
        if (wxPoly == null || wyPoly == null || wPoly == null) {
            throw new JgclFatal("one of arguments is null");
        }
        if (wxPoly.degree() != wPoly.degree() || wyPoly.degree() != wPoly.degree()) {
            throw new JgclFatal("given polynomials have different degrees");
        }
        this.polyX = wxPoly;
        this.polyY = wyPoly;
        this.polyW = wPoly;
        this.derivativeCurve = null;
    }

    public int degree() {
        return this.polyX.degree();
    }

    public boolean isIntegral() {
        return this.polyW == null;
    }

    public boolean isRational() {
        return this.polyW != null;
    }

    private JgclPolynomialCurve2D derivative() {
        if (this.derivativeCurve == null) {
            this.derivativeCurve = this.isIntegral() ? new JgclPolynomialCurve2D(this.polyX.derive(), this.polyY.derive()) : new JgclPolynomialCurve2D(this.polyX.derive(), this.polyY.derive(), this.polyW.derive());
        }
        return this.derivativeCurve;
    }

    JgclParameterDomain getParameterDomain() {
        return new JgclParameterDomain();
    }

    boolean getClosedFlag() {
        return false;
    }

    public boolean isFreeform() {
        return true;
    }

    private JgclLiteralVector2D evaluateAsIntegral(double param) {
        return new JgclLiteralVector2D(this.polyX.evaluate(param), this.polyY.evaluate(param));
    }

    private JgclHomogeneousVector2D evaluateAsRational(double param) {
        return new JgclHomogeneousVector2D(this.polyX.evaluate(param), this.polyY.evaluate(param), this.polyW.evaluate(param));
    }

    private JgclPoint2D evaluateD0(double param) {
        JgclPoint2D result;
        if (this.isIntegral()) {
            JgclLiteralVector2D D0 = this.evaluateAsIntegral(param);
            result = new JgclCartesianPoint2D(D0.x(), D0.y());
        } else {
            JgclHomogeneousVector2D D0H = this.evaluateAsRational(param);
            result = new JgclHomogeneousPoint2D(D0H.wx(), D0H.wy(), D0H.w());
        }
        return result;
    }

    private JgclVector2D evaluateD1(double param) {
        JgclVector2D result;
        if (this.isIntegral()) {
            result = this.derivative().evaluateAsIntegral(param);
        } else {
            JgclHomogeneousVector2D D0H = this.evaluateAsRational(param);
            JgclHomogeneousVector2D D1H = this.derivative().evaluateAsRational(param);
            JgclHomogeneousVector2D D0 = D0H;
            JgclHomogeneousVector2D D1 = new JgclHomogeneousVector2D(D1H.wx() - D1H.w() * ((JgclVector2D)D0).x(), D1H.wy() - D1H.w() * ((JgclVector2D)D0).y(), D0H.w());
            result = D1;
        }
        return result;
    }

    private JgclVector2D[] evaluateD1D2(double param) {
        JgclVector2D[] result = new JgclVector2D[2];
        if (this.isIntegral()) {
            result[0] = this.derivative().evaluateAsIntegral(param);
            result[1] = this.derivative().derivative().evaluateAsIntegral(param);
        } else {
            JgclHomogeneousVector2D D0H = this.evaluateAsRational(param);
            JgclHomogeneousVector2D D1H = this.derivative().evaluateAsRational(param);
            JgclHomogeneousVector2D D2H = this.derivative().derivative().evaluateAsRational(param);
            JgclHomogeneousVector2D D0 = D0H;
            JgclHomogeneousVector2D D1 = new JgclHomogeneousVector2D(D1H.wx() - D1H.w() * ((JgclVector2D)D0).x(), D1H.wy() - D1H.w() * ((JgclVector2D)D0).y(), D0H.w());
            JgclHomogeneousVector2D D2 = new JgclHomogeneousVector2D(D2H.wx() - (2.0 * D1H.w() * ((JgclVector2D)D1).x() + D2H.w() * ((JgclVector2D)D0).x()), D2H.wy() - (2.0 * D1H.w() * ((JgclVector2D)D1).y() + D2H.w() * ((JgclVector2D)D0).y()), D0H.w());
            result[0] = D1;
            result[1] = D2;
        }
        return result;
    }

    public JgclPoint2D coordinates(double param) {
        return this.evaluateD0(param);
    }

    public JgclVector2D tangentVector(double param) {
        return this.evaluateD1(param);
    }

    public JgclCurveCurvature2D curvature(double param) {
        JgclVector2D[] D1D2 = this.evaluateD1D2(param);
        JgclVector2D D1 = D1D2[0];
        JgclVector2D D2 = D1D2[1];
        double D1Leng = D1.length();
        double crsProd = D1.zOfCrossProduct(D2);
        double curvature = Math.abs(crsProd) / (D1Leng * D1Leng * D1Leng);
        JgclVector2D normal = crsProd < 0.0 ? new JgclLiteralVector2D(D1.y(), -D1.x()) : new JgclLiteralVector2D(-D1.y(), D1.x());
        normal = normal.unitized();
        return new JgclCurveCurvature2D(curvature, normal);
    }

    public JgclCurveDerivative2D evaluation(double param) {
        JgclPoint2D D0 = this.evaluateD0(param);
        JgclVector2D[] D1D2 = this.evaluateD1D2(param);
        return new JgclCurveDerivative2D(D0, D1D2[0], D1D2[1]);
    }

    public JgclPointOnCurve2D[] singular() {
        throw new JgclNotSupported();
    }

    public JgclPointOnCurve2D[] inflexion() {
        throw new JgclNotSupported();
    }

    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D mate) {
        throw new JgclNotSupported();
    }

    public JgclPolyline2D toPolyline(JgclParameterSection section, JgclToleranceForDistance tolerance) {
        throw new JgclNotSupported();
    }

    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection section) {
        throw new JgclNotSupported();
    }

    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint2D[] intersect(JgclCircle2D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint2D[] intersect(JgclEllipse2D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint2D[] intersect(JgclParabola2D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint2D[] intersect(JgclPureBezierCurve2D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint2D[] intersect(JgclBsplineCurve2D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    public JgclBsplineCurve2D offsetByBsplineCurve(JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tol) {
        throw new JgclNotSupported();
    }

    public JgclFilletObject2D[] fillet(JgclParameterSection pint1, int side1, JgclParametricCurve2D mate, JgclParameterSection pint2, int side2, double radius) {
        throw new JgclNotSupported();
    }

    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    public JgclCommonNormal2D[] commonNormal(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    public double length(JgclParameterSection pint) {
        double dTol = this.getToleranceForDistance() / 2.0;
        return JgclMath.getDefiniteIntegral(new 1(), pint, dTol);
    }

    int type() {
        return 30;
    }

    private JgclRealPolynomial[] toPolynomialArray() {
        if (this.isIntegral()) {
            JgclRealPolynomial[] polyArray = new JgclRealPolynomial[]{this.polyX, this.polyY};
            return polyArray;
        }
        JgclRealPolynomial[] polyArray = new JgclRealPolynomial[]{this.polyX, this.polyY, this.polyW};
        return polyArray;
    }

    public JgclRealPolynomial crossProductD1D2() {
        JgclRealPolynomial[] d2Poly;
        JgclRealPolynomial[] d1Poly;
        JgclPolynomialCurve2D d1 = this.derivative();
        JgclPolynomialCurve2D d2 = d1.derivative();
        if (this.isIntegral()) {
            d1Poly = d1.toPolynomialArray();
            d2Poly = d2.toPolynomialArray();
        } else {
            JgclRealPolynomial[] d0WPoly = this.toPolynomialArray();
            JgclRealPolynomial[] d1WPoly = d1.toPolynomialArray();
            JgclRealPolynomial[] d2WPoly = d2.toPolynomialArray();
            d1Poly = new JgclRealPolynomial[2];
            d2Poly = new JgclRealPolynomial[2];
            int klm = 0;
            while (klm < 2) {
                JgclRealPolynomial workPoly1 = this.polyW.multiply(d1WPoly[klm]);
                JgclRealPolynomial workPoly2 = d1.polyW.multiply(d0WPoly[klm]);
                d1Poly[klm] = workPoly1.subtract(workPoly2);
                JgclRealPolynomial workPoly = this.polyW.multiply(this.polyW);
                workPoly1 = workPoly.multiply(d2WPoly[klm]);
                workPoly = d1.polyW.multiply(d0WPoly[klm]);
                workPoly2 = workPoly.multiply(d1WPoly[klm]);
                workPoly = d1.polyW.multiply(d1.polyW);
                JgclRealPolynomial workPoly3 = workPoly.multiply(d0WPoly[klm]);
                workPoly = d2.polyW.multiply(this.polyW);
                JgclRealPolynomial workPoly4 = workPoly.multiply(d0WPoly[klm]);
                workPoly = workPoly2.subtract(workPoly3).multiply(2.0);
                d2Poly[klm] = workPoly1.subtract(workPoly).subtract(workPoly4);
                ++klm;
            }
        }
        JgclRealPolynomial crossPoly1 = d1Poly[0].multiply(d2Poly[1]);
        JgclRealPolynomial crossPoly2 = d1Poly[1].multiply(d2Poly[0]);
        return crossPoly1.subtract(crossPoly2);
    }

    protected synchronized JgclParametricCurve2D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        throw new JgclNotSupported();
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        StringBuffer buf = new StringBuffer();
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        if (this.polyW == null) {
            writer.print(String.valueOf(indent_tab) + "\tpolyX");
            writer.print(" [" + this.polyX.coefficientAt(0));
            int i = 1;
            while (i <= this.polyX.degree()) {
                writer.print(", " + this.polyX.coefficientAt(i));
                ++i;
            }
            writer.println("]");
            writer.print(String.valueOf(indent_tab) + "\tpolyY");
            writer.print(" [" + this.polyY.coefficientAt(0));
            int i2 = 1;
            while (i2 <= this.polyY.degree()) {
                writer.print(", " + this.polyY.coefficientAt(i2));
                ++i2;
            }
            writer.println("]");
        } else {
            writer.print(String.valueOf(indent_tab) + "\tpolyWX");
            writer.print(" [" + this.polyX.coefficientAt(0));
            int i = 1;
            while (i <= this.polyX.degree()) {
                writer.print(", " + this.polyX.coefficientAt(i));
                ++i;
            }
            writer.println("]");
            writer.print(String.valueOf(indent_tab) + "\tpolyWY");
            writer.print(" [" + this.polyY.coefficientAt(0));
            int i3 = 1;
            while (i3 <= this.polyY.degree()) {
                writer.print(", " + this.polyY.coefficientAt(i3));
                ++i3;
            }
            writer.println("]");
            writer.print(String.valueOf(indent_tab) + "\tpolyW");
            writer.print(" [" + this.polyW.coefficientAt(0));
            int i4 = 1;
            while (i4 <= this.polyW.degree()) {
                writer.print(", " + this.polyW.coefficientAt(i4));
                ++i4;
            }
            writer.println("]");
        }
    }

    private static void test1(String[] argv) throws JgclInvalidArgumentValue {
        JgclPoint2D[] cntrlPoints = new JgclPoint2D[]{new JgclCartesianPoint2D(0.0, 0.0), new JgclCartesianPoint2D(10.0, 10.0), new JgclCartesianPoint2D(20.0, 10.0), new JgclCartesianPoint2D(30.0, 0.0)};
        JgclRealPolynomial[] polynomial = new JgclPureBezierCurve2D(cntrlPoints).polynomial(true);
        JgclPolynomialCurve2D polynomialCurve = new JgclPolynomialCurve2D(polynomial[0], polynomial[1]);
        int i = 0;
        while (i <= 100) {
            double param = 0.01 * (double)i;
            JgclPoint2D crd = polynomialCurve.coordinates(param);
            JgclVector2D tng = polynomialCurve.tangentVector(param);
            JgclCurveCurvature2D crv = polynomialCurve.curvature(param);
            System.out.println(String.valueOf(crd.x()) + "\t" + crd.y() + "\t" + tng.x() + "\t" + tng.y() + "\t" + crv.curvature());
            ++i;
        }
    }

    private static void test2(String[] argv) throws JgclInvalidArgumentValue {
        JgclPoint2D[] cntrlPoints = new JgclPoint2D[]{new JgclCartesianPoint2D(0.0, 0.0), new JgclCartesianPoint2D(10.0, 10.0), new JgclCartesianPoint2D(20.0, 10.0), new JgclCartesianPoint2D(30.0, 0.0)};
        double[] weights = new double[]{1.0, 1.0, 1.0, 1.0};
        JgclRealPolynomial[] polynomial = new JgclPureBezierCurve2D(cntrlPoints, weights).polynomial(false);
        JgclPolynomialCurve2D polynomialCurve = new JgclPolynomialCurve2D(polynomial[0], polynomial[1], polynomial[2]);
        int i = 0;
        while (i <= 100) {
            double param = 0.01 * (double)i;
            JgclPoint2D crd = polynomialCurve.coordinates(param);
            JgclVector2D tng = polynomialCurve.tangentVector(param);
            JgclCurveCurvature2D crv = polynomialCurve.curvature(param);
            System.out.println(String.valueOf(crd.x()) + "\t" + crd.y() + "\t" + tng.x() + "\t" + tng.y() + "\t" + crv.curvature());
            ++i;
        }
    }

    public static void main(String[] argv) {
        try {
            JgclPolynomialCurve2D.test2(argv);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {}
    }

    private final class 1
    implements JgclRealFunctionWithOneVariable {
        public double evaluate(double parameter) {
            return JgclPolynomialCurve2D.this.tangentVector(parameter).length();
        }

        /* synthetic */ 1() {
        }
    }
}

