/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclBoundedCurve2D;
import jp.go.ipa.jgcl.JgclBoundedLine2D;
import jp.go.ipa.jgcl.JgclBsplineCurve2D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclCommonNormal2D;
import jp.go.ipa.jgcl.JgclCommonTangent2D;
import jp.go.ipa.jgcl.JgclCompositeCurve2D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment2D;
import jp.go.ipa.jgcl.JgclCurveCurvature2D;
import jp.go.ipa.jgcl.JgclCurveCurveInterference2D;
import jp.go.ipa.jgcl.JgclCurveCurveInterferenceList;
import jp.go.ipa.jgcl.JgclCurveDerivative2D;
import jp.go.ipa.jgcl.JgclEllipse2D;
import jp.go.ipa.jgcl.JgclEnclosingBox2D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclFilletObject2D;
import jp.go.ipa.jgcl.JgclFilletObjectList;
import jp.go.ipa.jgcl.JgclHyperbola2D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclIntsPolPol2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclParabola2D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterOutOfRange;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPointOnGeometryList;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;
import jp.go.ipa.jgcl.JgclSelfIntsPol2D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve2D;
import jp.go.ipa.jgcl.JgclVector2D;
import jp.go.ipa.jgcl.JgclZeroLength;

public class JgclPolyline2D
extends JgclBoundedCurve2D {
    private static final boolean CHECK_SAME_POINTS = false;
    private JgclPoint2D[] points;
    private boolean closed;

    private void setPoints(JgclPoint2D[] points, boolean closed) {
        if (!closed && points.length < 2 || closed && points.length < 3) {
            throw new JgclInvalidArgumentValue();
        }
        this.closed = closed;
        this.points = new JgclPoint2D[points.length];
        this.points[0] = points[0];
        int i = 1;
        while (i < points.length) {
            this.points[i] = points[i];
            ++i;
        }
    }

    public JgclPolyline2D(JgclPoint2D[] points, boolean closed) {
        this.setPoints(points, closed);
    }

    public JgclPolyline2D(JgclPoint2D[] points) {
        this.setPoints(points, false);
    }

    public JgclPolyline2D(JgclBoundedCurve2D curve, JgclToleranceForDistance tol) {
        JgclPolyline2D pl = curve.toPolyline(tol);
        this.points = pl.points;
        this.closed = pl.closed;
    }

    public JgclPolyline2D(JgclParametricCurve2D curve, JgclParameterSection pint, JgclToleranceForDistance tol) {
        JgclPolyline2D pl = curve.toPolyline(pint, tol);
        this.points = pl.points;
        this.closed = pl.closed;
    }

    public JgclPoint2D[] points() {
        JgclPoint2D[] pnts = new JgclPoint2D[this.points.length];
        int i = 0;
        while (i < this.points.length) {
            pnts[i] = this.points[i];
            ++i;
        }
        return pnts;
    }

    public JgclPoint2D pointAt(int i) {
        if (this.closed() && i == this.nPoints()) {
            return this.points[0];
        }
        return this.points[i];
    }

    public boolean closed() {
        return this.closed;
    }

    public int nPoints() {
        return this.points.length;
    }

    public int nSegments() {
        if (this.closed()) {
            return this.nPoints();
        }
        return this.nPoints() - 1;
    }

    private PolyParam checkParameter(double param) {
        int n;
        PolyParam p = new PolyParam();
        int n2 = n = this.closed ? this.points.length : this.points.length - 1;
        if (this.closed) {
            param = this.parameterDomain().wrap(param);
        } else {
            this.checkValidity(param);
        }
        int idx = (int)Math.floor(param);
        if (idx < 0) {
            idx = 0;
        }
        if (n - 1 < idx) {
            idx = n - 1;
        }
        p.sp = this.points[idx];
        p.ep = idx + 1 == this.points.length ? this.points[0] : this.points[idx + 1];
        p.weight = param - (double)idx;
        p.param = param;
        p.index = idx;
        return p;
    }

    public double length(JgclParameterSection pint) {
        if (pint.increase() < 0.0) {
            return this.length(pint.reverse());
        }
        LengthAccumulator acc = new LengthAccumulator();
        acc.accumulate(pint);
        return acc.extract();
    }

    public JgclPoint2D coordinates(double param) {
        PolyParam p = this.checkParameter(param);
        return p.ep.linearInterpolate(p.sp, p.weight);
    }

    public JgclVector2D tangentVector(double param) {
        PolyParam p = this.checkParameter(param);
        return p.ep.subtract(p.sp);
    }

    public JgclCurveCurvature2D curvature(double param) {
        this.checkParameter(param);
        return new JgclCurveCurvature2D(0.0, JgclVector2D.zeroVector());
    }

    public JgclCurveDerivative2D evaluation(double param) {
        return new JgclCurveDerivative2D(this.coordinates(param), this.tangentVector(param), JgclVector2D.zeroVector());
    }

    public JgclPointOnCurve2D[] singular() {
        SingularAccumulator acc = new SingularAccumulator(this);
        acc.accumulate(this.parameterDomain().section());
        return acc.extract();
    }

    public JgclPointOnCurve2D[] inflexion() {
        return new JgclPointOnCurve2D[0];
    }

    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D point) {
        double dTol = this.getToleranceForDistance();
        ProjectionAccumulator acc = new ProjectionAccumulator(this, point, dTol);
        try {
            acc.accumulate(this.parameterDomain().section());
        }
        catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
            throw new JgclFatal();
        }
        return acc.extract();
    }

    public JgclPolyline2D toPolyline(JgclParameterSection pint, JgclToleranceForDistance tol) {
        if (pint.increase() < 0.0) {
            return this.toPolyline(pint.reverse(), tol).reverse();
        }
        ToPolylineAccumulator acc = new ToPolylineAccumulator(this);
        acc.accumulate(pint);
        return acc.extract();
    }

    public JgclBsplineCurve2D toBsplineCurve() {
        int ik;
        int degree = 1;
        boolean periodic = this.closed();
        int uicp = this.nPoints();
        int uik = !periodic ? uicp : uicp + 2;
        int[] knotMultiplicities = new int[uik];
        double[] knots = new double[uik];
        JgclPoint2D[] controlPoints = new JgclPoint2D[uicp];
        double[] weights = new double[uicp];
        int n = ik = !periodic ? 0 : 1;
        if (!periodic) {
            ik = 0;
        } else {
            ik = 1;
            knots[0] = -1.0;
            knots[uik - 1] = uicp + 1;
            knotMultiplicities[0] = 1;
            knotMultiplicities[uik - 1] = 1;
        }
        int i = 0;
        while (i < uicp) {
            knots[ik] = i;
            knotMultiplicities[ik] = !periodic && (i == 0 || i == this.nPoints() - 1) ? 2 : 1;
            controlPoints[i] = this.pointAt(i);
            weights[i] = 1.0;
            ++i;
            ++ik;
        }
        return new JgclBsplineCurve2D(degree, periodic, knotMultiplicities, knots, controlPoints, weights);
    }

    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
        JgclPolyline2D target;
        if (this.closed()) {
            if (pint.absIncrease() >= this.parameterDomain().section().absIncrease()) {
                target = this;
                if (pint.increase() < 0.0) {
                    target = target.reverse();
                }
            } else {
                target = this.toPolyline(pint, this.getToleranceForDistanceAsObject());
            }
        } else {
            target = this.toPolyline(pint, this.getToleranceForDistanceAsObject());
        }
        return target.toBsplineCurve();
    }

    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate) {
        return mate.intersect(this, true);
    }

    private double segLength(int nseg, int segIdx) {
        if (this.closed()) {
            while (segIdx < 0) {
                segIdx += nseg;
            }
            while (segIdx > nseg - 1) {
                segIdx -= nseg;
            }
        }
        int head_pnt_idx = segIdx;
        int tail_pnt_idx = this.closed() && head_pnt_idx == this.nSegments() ? 0 : head_pnt_idx + 1;
        return this.points[head_pnt_idx].distance(this.points[tail_pnt_idx]);
    }

    /*
     * Unable to fully structure code
     */
    private JgclIntersectionPoint2D[] doIntersect(JgclParametricCurve2D mate, boolean doExchange) {
        nSeg = this.nSegments();
        intf = new JgclCurveCurveInterferenceList(this, mate);
        i = 0;
        while (i < nSeg) {
            block13: {
                try {
                    realSegment = new JgclLine2D(this.pointAt(i), this.pointAt(i + 1));
                    segment = new JgclBoundedLine2D(this.pointAt(i), this.pointAt(i + 1));
                }
                catch (JgclInvalidArgumentValue v0) {
                    break block13;
                }
                try {
                    segIntersect = realSegment.intersect(mate);
                }
                catch (JgclIndefiniteSolution v1) {
                    segIntersect = new JgclIntersectionPoint2D[1];
                    segmentMidPoint = realSegment.coordinates(0.5);
                    paramOnMate = mate.pointToParameter(segmentMidPoint);
                    segIntersect[0] = new JgclIntersectionPoint2D(realSegment, 0.5, mate, paramOnMate, false);
                }
                if (segIntersect == null || segIntersect.length == 0) break block13;
                segResolution = segIntersect.length;
                j = 0;
                while (j < segResolution) {
                    point = segIntersect[j].coordinates();
                    segParam = segIntersect[j].pointOnCurve1().parameter();
                    validity = segment.parameterValidity(segParam);
                    switch (validity) {
                        case 1: {
                            if (segParam < 0.0) {
                                segParam = !this.closed() && i == 0 ? 0.0 : this.segLength(nSeg, i) * segParam / this.segLength(nSeg, i - 1);
                            }
                            ** GOTO lbl34
                        }
                        case 2: {
                            if (segParam > 1.0) {
                                segParam = this.closed() == false && i == nSeg - 1 ? 1.0 : 1.0 + this.segLength(nSeg, i) * (segParam - 1.0) / this.segLength(nSeg, i + 1);
                            }
                        }
lbl34:
                        // 5 sources

                        default: {
                            intf.addAsIntersection(point, segParam + (double)i, segIntersect[j].pointOnCurve2().parameter());
                        }
                        case 3: 
                    }
                    ++j;
                }
            }
            ++i;
        }
        return intf.toJgclIntersectionPoint2DArray(doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCircle2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclEllipse2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclParabola2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
        return JgclIntsPolPol2D.intersection(this, mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclPureBezierCurve2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclBsplineCurve2D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    public JgclCurveCurveInterference2D[] interfere(JgclBoundedCurve2D mate) {
        return mate.interfere(this, true);
    }

    JgclCurveCurveInterference2D[] interfere(JgclBoundedLine2D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclPolyline2D mate, boolean doExchange) {
        if (!doExchange) {
            return JgclIntsPolPol2D.interference(this, mate);
        }
        return JgclIntsPolPol2D.interference(mate, this);
    }

    private JgclCurveCurveInterference2D[] convertInterferences(JgclCurveCurveInterference2D[] sourceInterferences, boolean doExchange) {
        Vector<JgclCurveCurveInterference2D> resultVector = new Vector<JgclCurveCurveInterference2D>();
        int i = 0;
        while (i < sourceInterferences.length) {
            JgclCurveCurveInterference2D intf = !doExchange ? sourceInterferences[i].changeCurve1(this) : sourceInterferences[i].changeCurve2(this);
            if (intf != null) {
                resultVector.addElement(intf);
            }
            ++i;
        }
        Object[] result = new JgclCurveCurveInterference2D[resultVector.size()];
        resultVector.copyInto(result);
        return result;
    }

    JgclCurveCurveInterference2D[] interfere(JgclPureBezierCurve2D mate, boolean doExchange) {
        return this.convertInterferences(this.toBsplineCurve().interfere(mate, doExchange), doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclBsplineCurve2D mate, boolean doExchange) {
        return this.convertInterferences(this.toBsplineCurve().interfere(mate, doExchange), doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclTrimmedCurve2D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurveSegment2D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurve2D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    public JgclIntersectionPoint2D[] selfIntersect() {
        return JgclSelfIntsPol2D.intersection(this);
    }

    public JgclCurveCurveInterference2D[] selfInterfere() {
        return JgclSelfIntsPol2D.interference(this);
    }

    public JgclCompositeCurve2D offsetByCompositeCurve(JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tol) {
        boolean offsettedIsPeriodic = false;
        if (this.isPeriodic() && this.parameterDomain().section().absIncrease() - pint.absIncrease() < this.getToleranceForParameter()) {
            offsettedIsPeriodic = true;
        }
        JgclBoundedLine2D[] boundedLines = this.toBoundedLines(pint);
        int nBoundedLines = boundedLines.length;
        Object[] offsetted = new JgclCompositeCurveSegment2D[2 * nBoundedLines];
        JgclBoundedLine2D prevOffsettedCurve = null;
        JgclBoundedLine2D crntOffsettedCurve = null;
        JgclBoundedLine2D firstOffsettedCurve = null;
        int i = 0;
        while (i <= nBoundedLines) {
            int transition;
            if (i == nBoundedLines) {
                crntOffsettedCurve = firstOffsettedCurve;
            } else {
                crntOffsettedCurve = (JgclBoundedLine2D)boundedLines[i].offsetByBoundedCurve(magni, side, tol);
                if (i == 0) {
                    firstOffsettedCurve = crntOffsettedCurve;
                }
                transition = 1;
                if (!offsettedIsPeriodic && i == nBoundedLines - 1) {
                    transition = 0;
                }
                offsetted[2 * i] = new JgclCompositeCurveSegment2D(transition, true, crntOffsettedCurve);
            }
            if (i != 0) {
                if (i == nBoundedLines && !offsettedIsPeriodic) {
                    offsetted[2 * i - 1] = null;
                } else if (prevOffsettedCurve.epnt().identical(crntOffsettedCurve.spnt())) {
                    offsetted[2 * i - 1] = null;
                } else {
                    JgclPoint2D center = i < nBoundedLines ? boundedLines[i].spnt() : boundedLines[0].spnt();
                    JgclTrimmedCurve2D offsettedCorner = JgclCircle2D.makeTrimmedCurve(center, prevOffsettedCurve.epnt(), crntOffsettedCurve.spnt());
                    transition = 1;
                    offsetted[2 * i - 1] = new JgclCompositeCurveSegment2D(transition, true, offsettedCorner);
                }
            }
            prevOffsettedCurve = crntOffsettedCurve;
            ++i;
        }
        Vector<Object> listOfOffsetted = new Vector<Object>();
        int i2 = 0;
        while (i2 < 2 * nBoundedLines) {
            if (offsetted[i2] != null) {
                listOfOffsetted.addElement(offsetted[i2]);
            }
            ++i2;
        }
        offsetted = new JgclCompositeCurveSegment2D[listOfOffsetted.size()];
        listOfOffsetted.copyInto(offsetted);
        return new JgclCompositeCurve2D((JgclCompositeCurveSegment2D[])offsetted, offsettedIsPeriodic);
    }

    public JgclBsplineCurve2D offsetByBsplineCurve(JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tol) {
        JgclCompositeCurve2D cmc = this.offsetByCompositeCurve(pint, magni, side, tol);
        return cmc.toBsplineCurve();
    }

    public JgclBoundedCurve2D offsetByBoundedCurve(JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tol) {
        return this.offsetByCompositeCurve(pint, magni, side, tol);
    }

    JgclFilletObject2D[] doFillet(JgclParameterSection pint1, int side1, JgclParametricCurve2D mate, JgclParameterSection pint2, int side2, double radius, boolean doExchange) throws JgclIndefiniteSolution {
        FilletAccumulator acc = new FilletAccumulator(mate, pint2, side2, this, side1, radius, doExchange);
        acc.accumulate(pint1);
        return acc.extract();
    }

    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    public JgclCommonNormal2D[] commonNormal(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    JgclPolyline2D reverse() {
        int i;
        int uip = this.nPoints();
        JgclPoint2D[] rPnts = new JgclPoint2D[uip];
        if (this.closed) {
            rPnts[0] = this.points[0];
            i = 1;
        } else {
            i = 0;
        }
        int j = uip - 1;
        while (i < uip) {
            rPnts[i] = this.points[j];
            ++i;
            --j;
        }
        return new JgclPolyline2D(rPnts, this.closed);
    }

    JgclEnclosingBox2D enclosingBox() {
        double min_crd_y;
        double min_crd_x;
        double max_crd_x = min_crd_x = this.pointAt(0).x();
        double max_crd_y = min_crd_y = this.pointAt(0).y();
        int i = 1;
        while (i < this.nPoints()) {
            min_crd_x = Math.min(min_crd_x, this.pointAt(i).x());
            min_crd_y = Math.min(min_crd_y, this.pointAt(i).y());
            max_crd_x = Math.max(max_crd_x, this.pointAt(i).x());
            max_crd_y = Math.max(max_crd_y, this.pointAt(i).y());
            ++i;
        }
        return new JgclEnclosingBox2D(min_crd_x, min_crd_y, max_crd_x, max_crd_y);
    }

    JgclParameterDomain getParameterDomain() {
        double n = this.closed ? this.points.length : this.points.length - 1;
        try {
            return new JgclParameterDomain(this.closed, 0.0, n);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    public boolean isFreeform() {
        return true;
    }

    public JgclPoint2D startPoint() {
        if (this.isPeriodic()) {
            return null;
        }
        return this.points[0];
    }

    public JgclPoint2D endPoint() {
        if (this.isPeriodic()) {
            return null;
        }
        return this.points[this.points.length - 1];
    }

    int type() {
        return 20;
    }

    public JgclBoundedLine2D[] toBoundedLines(JgclParameterSection pint) {
        ToBoundedLinesAccumulator acc = new ToBoundedLinesAccumulator(pint.increase() < 0.0);
        acc.accumulate(pint);
        return acc.extract();
    }

    public JgclBoundedLine2D[] toBoundedLines() {
        return this.toBoundedLines(this.parameterDomain().section());
    }

    protected synchronized JgclParametricCurve2D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint2D[] tPoints = JgclPoint2D.transform(this.points, reverseTransform, transformationOperator, transformedGeometries);
        return new JgclPolyline2D(tPoints, this.closed);
    }

    protected boolean hasPolyline() {
        return true;
    }

    protected boolean isComposedOfOnlyPolylines() {
        return true;
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tpoints");
        int i = 0;
        while (i < this.nPoints()) {
            this.points[i].output(writer, indent + 2);
            ++i;
        }
        writer.println(String.valueOf(indent_tab) + "\tclosed\t" + this.closed);
        writer.println(String.valueOf(indent_tab) + "End");
    }

    private class PolyParam {
        JgclPoint2D sp;
        JgclPoint2D ep;
        double weight;
        double param;
        int index;

        PolyParam() {
            JgclPolyline2D.this = JgclPolyline2D.this;
        }
    }

    private abstract class LineSegmentAccumulator {
        abstract void doit(JgclPoint2D var1, JgclPoint2D var2, double var3, double var5);

        abstract void allocate(int var1);

        void accumulate(JgclParameterSection pint) {
            PolyParam sPolyParam = JgclPolyline2D.this.checkParameter(pint.start());
            PolyParam ePolyParam = JgclPolyline2D.this.checkParameter(pint.end());
            JgclParameterDomain domain = JgclPolyline2D.this.parameterDomain();
            boolean wrapAround = domain.isPeriodic() ? sPolyParam.param > ePolyParam.param : false;
            if (wrapAround) {
                this.allocate(JgclPolyline2D.this.nPoints() - sPolyParam.index + ePolyParam.index);
                JgclPoint2D sPoint = JgclPolyline2D.this.coordinates(sPolyParam.param);
                JgclPoint2D ePoint = sPolyParam.ep;
                this.doit(sPoint, ePoint, sPolyParam.param, (double)sPolyParam.index + 1.0);
                int seg = sPolyParam.index + 1;
                while (seg < JgclPolyline2D.this.nPoints()) {
                    int wrappedSeg1 = (seg + 1) % JgclPolyline2D.this.nPoints();
                    this.doit(JgclPolyline2D.this.points[seg], JgclPolyline2D.this.points[wrappedSeg1], seg, seg + 1);
                    ++seg;
                }
                int seg2 = 0;
                while (seg2 < ePolyParam.index) {
                    int wrappedSeg1 = (seg2 + 1) % JgclPolyline2D.this.nPoints();
                    this.doit(JgclPolyline2D.this.points[seg2], JgclPolyline2D.this.points[wrappedSeg1], seg2, seg2 + 1);
                    ++seg2;
                }
                sPoint = ePolyParam.sp;
                ePoint = JgclPolyline2D.this.coordinates(ePolyParam.param);
                this.doit(sPoint, ePoint, ePolyParam.index, ePolyParam.param);
            } else if (sPolyParam.index == ePolyParam.index) {
                this.allocate(1);
                JgclPoint2D sPoint = JgclPolyline2D.this.coordinates(sPolyParam.param);
                JgclPoint2D ePoint = JgclPolyline2D.this.coordinates(ePolyParam.param);
                this.doit(sPoint, ePoint, sPolyParam.param, ePolyParam.param);
            } else {
                this.allocate(ePolyParam.index - sPolyParam.index + 1);
                JgclPoint2D sPoint = JgclPolyline2D.this.coordinates(sPolyParam.param);
                JgclPoint2D ePoint = sPolyParam.ep;
                this.doit(sPoint, ePoint, sPolyParam.param, (double)sPolyParam.index + 1.0);
                int seg = sPolyParam.index + 1;
                while (seg < ePolyParam.index) {
                    this.doit(JgclPolyline2D.this.points[seg], JgclPolyline2D.this.points[seg + 1], seg, seg + 1);
                    ++seg;
                }
                sPoint = ePolyParam.sp;
                ePoint = JgclPolyline2D.this.coordinates(ePolyParam.param);
                this.doit(sPoint, ePoint, ePolyParam.index, ePolyParam.param);
            }
        }

        LineSegmentAccumulator() {
            JgclPolyline2D.this = JgclPolyline2D.this;
        }
    }

    private class LengthAccumulator
    extends LineSegmentAccumulator {
        double leng;

        void allocate(int nsegs) {
            this.leng = 0.0;
        }

        void doit(JgclPoint2D sp, JgclPoint2D ep, double sParam, double eParam) {
            this.leng += sp.distance(ep);
        }

        double extract() {
            return this.leng;
        }

        LengthAccumulator() {
            JgclPolyline2D.this = JgclPolyline2D.this;
        }
    }

    private class SingularAccumulator
    extends LineSegmentAccumulator {
        private JgclParametricCurve2D curve;
        private Vector singularVec;
        private JgclVector2D prevTangVec;

        SingularAccumulator(JgclParametricCurve2D curve) {
            JgclPolyline2D.this = JgclPolyline2D.this;
            this.curve = curve;
        }

        void allocate(int nsegs) {
            this.singularVec = new Vector();
            this.prevTangVec = null;
        }

        void doit(JgclPoint2D sp, JgclPoint2D ep, double sParam, double eParam) {
            JgclVector2D tangVec = ep.subtract(sp);
            if (this.prevTangVec != null && !tangVec.identicalDirection(this.prevTangVec)) {
                JgclPointOnCurve2D candidate = new JgclPointOnCurve2D(this.curve, sParam, false);
                this.singularVec.addElement(candidate);
            }
            this.prevTangVec = tangVec;
        }

        JgclPointOnCurve2D[] extract() {
            Object[] singular = new JgclPointOnCurve2D[this.singularVec.size()];
            this.singularVec.copyInto(singular);
            return singular;
        }
    }

    private class ProjectionAccumulator
    extends LineSegmentAccumulator {
        JgclPointOnGeometryList projList;
        JgclPoint2D point;
        double dTol;
        JgclPolyline2D curv;

        ProjectionAccumulator(JgclPolyline2D curv, JgclPoint2D point, double dTol) {
            JgclPolyline2D.this = JgclPolyline2D.this;
            this.point = point;
            this.dTol = dTol;
            this.curv = curv;
        }

        void allocate(int nsegs) {
            this.projList = new JgclPointOnGeometryList();
        }

        void doit(JgclPoint2D sp, JgclPoint2D ep, double sParam, double eParam) {
            JgclLine2D line;
            try {
                line = new JgclLine2D(sp, ep);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                return;
            }
            JgclPointOnCurve2D proj = line.project1From(this.point);
            double length = line.dir().length();
            double param = proj.parameter();
            double fromSp = param * length;
            if (-this.dTol <= fromSp && fromSp <= length + this.dTol) {
                if (param < 0.0) {
                    param = 0.0;
                } else if (param > 1.0) {
                    param = 1.0;
                }
                double p2 = sParam + (eParam - sParam) * param;
                this.projList.addPoint(this.curv, p2);
            }
        }

        JgclPointOnCurve2D[] extract() {
            return this.projList.toJgclPointOnCurve2DArray();
        }
    }

    private class ToPolylineAccumulator
    extends LineSegmentAccumulator {
        Vector pntVec;
        JgclPoint2D lastPoint;
        JgclPolyline2D curv;

        ToPolylineAccumulator(JgclPolyline2D curv) {
            JgclPolyline2D.this = JgclPolyline2D.this;
            this.curv = curv;
        }

        void allocate(int nsegs) {
            this.pntVec = new Vector();
            this.lastPoint = null;
        }

        void doit(JgclPoint2D sp, JgclPoint2D ep, double sParam, double eParam) {
            JgclPointOnCurve2D newPoint;
            if (this.lastPoint == null) {
                this.lastPoint = new JgclPointOnCurve2D(this.curv, sParam, false);
                this.pntVec.addElement(this.lastPoint);
            }
            if (!(newPoint = new JgclPointOnCurve2D(this.curv, eParam, false)).identical(this.lastPoint)) {
                this.pntVec.addElement(newPoint);
                this.lastPoint = newPoint;
            }
        }

        JgclPolyline2D extract() {
            int nPnts = this.pntVec.size();
            if (nPnts < 2) {
                throw new JgclZeroLength();
            }
            Object[] pntsArray = new JgclPoint2D[nPnts];
            this.pntVec.copyInto(pntsArray);
            return new JgclPolyline2D((JgclPoint2D[])pntsArray);
        }
    }

    private class FilletAccumulator
    extends LineSegmentAccumulator {
        JgclParametricCurve2D mate;
        JgclPolyline2D curve;
        JgclParameterSection mateSec;
        int mateSide;
        int mySide;
        double radius;
        boolean doExchange;
        JgclFilletObjectList fltList;
        JgclParameterSection sec;

        FilletAccumulator(JgclParametricCurve2D mate, JgclParameterSection mateSec, int mateSide, JgclPolyline2D curve, int mySide, double radius, boolean doExchange) {
            JgclPolyline2D.this = JgclPolyline2D.this;
            this.curve = curve;
            this.mate = mate;
            this.mateSec = mateSec;
            this.mateSide = mateSide;
            this.mySide = mySide;
            this.radius = radius;
            this.doExchange = doExchange;
            this.sec = new JgclParameterSection(0.0, 1.0);
        }

        void allocate(int nsegs) {
            this.fltList = new JgclFilletObjectList();
        }

        void doit(JgclPoint2D sp, JgclPoint2D ep, double sParam, double eParam) {
            JgclFilletObject2D[] flts;
            JgclBoundedLine2D blin = new JgclBoundedLine2D(sp, ep);
            try {
                flts = blin.doFillet(this.sec, this.mySide, this.mate, this.mateSec, this.mateSide, this.radius, false);
            }
            catch (JgclIndefiniteSolution e) {
                flts = new JgclFilletObject2D[]{(JgclFilletObject2D)e.suitable()};
            }
            int i = 0;
            while (i < flts.length) {
                double param = sParam + (eParam - sParam) * flts[i].pointOnCurve1().parameter();
                JgclPointOnCurve2D thisPnt = new JgclPointOnCurve2D(this.curve, param, false);
                JgclFilletObject2D thisFlt = !this.doExchange ? new JgclFilletObject2D(this.radius, flts[i].center(), thisPnt, flts[i].pointOnCurve2()) : new JgclFilletObject2D(this.radius, flts[i].center(), flts[i].pointOnCurve2(), thisPnt);
                this.fltList.addFillet(thisFlt);
                ++i;
            }
        }

        JgclFilletObject2D[] extract() {
            return this.fltList.toJgclFilletObject2DArray(false);
        }
    }

    private class ToBoundedLinesAccumulator
    extends LineSegmentAccumulator {
        JgclBoundedLine2D[] boundedLines;
        int index;
        boolean rvrs;

        ToBoundedLinesAccumulator(boolean reverse) {
            JgclPolyline2D.this = JgclPolyline2D.this;
            this.rvrs = reverse;
        }

        void allocate(int nsegs) {
            this.boundedLines = new JgclBoundedLine2D[nsegs];
            this.index = !this.rvrs ? 0 : nsegs - 1;
        }

        void doit(JgclPoint2D sp, JgclPoint2D ep, double sParam, double eParam) {
            if (!this.rvrs) {
                this.boundedLines[this.index++] = new JgclBoundedLine2D(sp, ep, false);
            } else {
                this.boundedLines[this.index--] = new JgclBoundedLine2D(ep, sp, false);
            }
        }

        JgclBoundedLine2D[] extract() {
            return this.boundedLines;
        }
    }
}

