/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPoint;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclVector3D;

public abstract class JgclPoint3D
extends JgclPoint {
    public static final JgclPoint3D origin = new JgclCartesianPoint3D(0.0, 0.0, 0.0);

    protected JgclPoint3D() {
    }

    public int dimension() {
        return 3;
    }

    public boolean is3D() {
        return true;
    }

    public abstract double x();

    public abstract double y();

    public abstract double z();

    public JgclPoint3D add(JgclVector3D vector) {
        return new JgclCartesianPoint3D(this.x() + vector.x(), this.y() + vector.y(), this.z() + vector.z());
    }

    public JgclPoint3D subtract(JgclVector3D vector) {
        return new JgclCartesianPoint3D(this.x() - vector.x(), this.y() - vector.y(), this.z() - vector.z());
    }

    public JgclVector3D subtract(JgclPoint3D mate) {
        return new JgclLiteralVector3D(this.x() - mate.x(), this.y() - mate.y(), this.z() - mate.z());
    }

    public JgclPoint3D multiply(double scale) {
        return new JgclCartesianPoint3D(this.x() * scale, this.y() * scale, this.z() * scale);
    }

    public JgclPoint3D divide(double scale) {
        return new JgclCartesianPoint3D(this.x() / scale, this.y() / scale, this.z() / scale);
    }

    public JgclPoint3D linearInterpolate(JgclPoint3D mate, double weightForThis) {
        double weightForMate = 1.0 - weightForThis;
        return new JgclCartesianPoint3D(this.x() * weightForThis + mate.x() * weightForMate, this.y() * weightForThis + mate.y() * weightForMate, this.z() * weightForThis + mate.z() * weightForMate);
    }

    public JgclPoint3D midPoint(JgclPoint3D mate) {
        return this.linearInterpolate(mate, 0.5);
    }

    public boolean identical(JgclPoint3D mate) {
        return this.distance2(mate) < this.getToleranceForDistance2();
    }

    public JgclVector3D toVector3D() {
        return new JgclLiteralVector3D(this.x(), this.y(), this.z());
    }

    public static JgclVector3D[] toVector3D(JgclPoint3D[] pnts) {
        JgclVector3D[] vecs = new JgclVector3D[pnts.length];
        int i = 0;
        while (i < pnts.length) {
            vecs[i] = pnts[i].toVector3D();
            ++i;
        }
        return vecs;
    }

    public JgclPointOnCurve3D[] project(JgclParametricCurve3D mate) throws JgclIndefiniteSolution {
        return mate.projectFrom(this);
    }

    public boolean isOn(JgclParametricCurve3D mate) {
        JgclPointOnCurve3D prjp = mate.nearestProjectFrom(this);
        return prjp != null && this.identical(prjp);
    }

    public boolean isOn(JgclParametricSurface3D mate) {
        JgclPointOnSurface3D prjp = mate.nearestProjectFrom(this);
        return prjp != null && this.identical(prjp);
    }

    public double distance(JgclPoint3D mate) {
        return Math.sqrt(this.distance2(mate));
    }

    public double distance2(JgclPoint3D mate) {
        double dx = this.x() - mate.x();
        double dy = this.y() - mate.y();
        double dz = this.z() - mate.z();
        return dx * dx + dy * dy + dz * dz;
    }

    public JgclPoint3D longestPoint(JgclPoint3D[] pnts) {
        return this.longestPoint(pnts, 0, pnts.length - 1);
    }

    public JgclPoint3D longestPoint(JgclPoint3D[] pnts, int start, int end) {
        if (start < 0 || end >= pnts.length) {
            throw new JgclInvalidArgumentValue();
        }
        double max_dist = this.distance2(pnts[start]);
        int index = 0;
        int i = start + 1;
        while (i <= end) {
            double d;
            double dist = this.distance2(pnts[i]);
            if (d > max_dist) {
                max_dist = dist;
                index = i;
            }
            ++i;
        }
        return pnts[index];
    }

    static JgclVector3D collinear(JgclPoint3D[] points, int start, int end) {
        if (start < 0 || points.length <= end) {
            throw new JgclInvalidArgumentValue();
        }
        if (end - start <= 1) {
            return JgclVector3D.zeroVector;
        }
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol = condition.getToleranceForDistance();
        double dTol2 = dTol * dTol;
        JgclPoint3D basisPoint = points[start];
        JgclPoint3D longestPoint = basisPoint.longestPoint(points, start + 1, end);
        JgclVector3D uax = longestPoint.subtract(basisPoint);
        if (uax.norm() < dTol2) {
            return JgclVector3D.zeroVector;
        }
        uax = uax.unitized();
        int i = start + 1;
        while (i <= end) {
            JgclVector3D evec = points[i].subtract(points[start]);
            double ecrs = evec.crossProduct(uax).norm();
            if (ecrs > dTol2) {
                return null;
            }
            ++i;
        }
        return uax;
    }

    JgclPoint3D rotateZ(JgclCartesianTransformationOperator3D trns, double rCos, double rSin) {
        JgclPoint3D lpnt = trns.toLocal(this);
        double x = rCos * lpnt.x() - rSin * lpnt.y();
        double y = rSin * lpnt.x() + rCos * lpnt.y();
        double z = lpnt.z();
        JgclCartesianPoint3D rpnt = new JgclCartesianPoint3D(x, y, z);
        return trns.toEnclosed(rpnt);
    }

    JgclPoint2D to2D() {
        return new JgclCartesianPoint2D(this.x(), this.y());
    }

    JgclPoint2D to2D(JgclCartesianTransformationOperator3D transform) {
        return transform.toLocal(this).to2D();
    }

    JgclCartesianPoint3D literal() {
        return new JgclCartesianPoint3D(this.x(), this.y(), this.z());
    }

    protected abstract JgclPoint3D doTransformBy(boolean var1, JgclCartesianTransformationOperator3D var2, Hashtable var3);

    public synchronized JgclPoint3D transformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        if (transformedGeometries == null) {
            return this.doTransformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        JgclPoint3D transformed = (JgclPoint3D)transformedGeometries.get(this);
        if (transformed == null) {
            transformed = this.doTransformBy(reverseTransform, transformationOperator, transformedGeometries);
            transformedGeometries.put(this, transformed);
        }
        return transformed;
    }

    public synchronized JgclPoint3D transformBy(JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        return this.transformBy(false, transformationOperator, transformedGeometries);
    }

    public synchronized JgclPoint3D reverseTransformBy(JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        return this.transformBy(true, transformationOperator, transformedGeometries);
    }

    public static JgclPoint3D[] transform(JgclPoint3D[] points, boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint3D[] tPoints = new JgclPoint3D[points.length];
        int i = 0;
        while (i < points.length) {
            tPoints[i] = points[i].transformBy(reverseTransform, transformationOperator, transformedGeometries);
            ++i;
        }
        return tPoints;
    }

    public static JgclPoint3D[] transform(JgclPoint3D[] points, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        return JgclPoint3D.transform(points, false, transformationOperator, transformedGeometries);
    }

    public static JgclPoint3D[] reverseTransform(JgclPoint3D[] points, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        return JgclPoint3D.transform(points, true, transformationOperator, transformedGeometries);
    }

    public static JgclCartesianPoint3D of(double x, double y, double z) {
        return new JgclCartesianPoint3D(x, y, z);
    }

    public static JgclCartesianPoint3D of(double[] components) {
        return new JgclCartesianPoint3D(components);
    }
}

