/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclConic3D;
import jp.go.ipa.jgcl.JgclConicalSurface3D;
import jp.go.ipa.jgcl.JgclCylindricalSurface3D;
import jp.go.ipa.jgcl.JgclElementarySurface3D;
import jp.go.ipa.jgcl.JgclEllipse3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionCurve3D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclIntsPlnCon3D;
import jp.go.ipa.jgcl.JgclIntsQrdBzs3D;
import jp.go.ipa.jgcl.JgclIntsSrfBss3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclMesh3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPointOnGeometry3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclSphericalSurface3D;
import jp.go.ipa.jgcl.JgclSurfaceCurvature3D;
import jp.go.ipa.jgcl.JgclSurfaceDerivative3D;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterference3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclPlane3D
extends JgclElementarySurface3D {
    public JgclPlane3D(JgclAxis2Placement3D position) {
        super(position);
    }

    public JgclPlane3D(JgclPoint3D pnt, JgclVector3D normal) {
        super(new JgclAxis2Placement3D(pnt, normal, normal.verticalVector().unitized()));
    }

    public JgclPoint3D coordinates(double uParam, double vParam) {
        JgclPoint3D center = this.position().location();
        JgclVector3D x = this.position().x();
        JgclVector3D y = this.position().y();
        return center.add(x.multiply(uParam)).add(y.multiply(vParam));
    }

    public JgclVector3D[] tangentVector(double uParam, double vParam) {
        JgclVector3D[] tangent = new JgclVector3D[]{this.position().x(), this.position().y()};
        return tangent;
    }

    public JgclVector3D normalVector(double uParam, double vParam) {
        return this.position().z();
    }

    public JgclSurfaceCurvature3D curvature(double uParam, double vParam) {
        return new JgclSurfaceCurvature3D(0.0, this.position().x(), 0.0, this.position().y());
    }

    public JgclSurfaceDerivative3D evaluation(double uParam, double vParam) {
        JgclPoint3D center = this.position().location();
        JgclVector3D x = this.position().x();
        JgclVector3D y = this.position().y();
        JgclVector3D zerov = JgclVector3D.zeroVector;
        JgclPoint3D p = center.add(x.multiply(uParam)).add(y.multiply(vParam));
        return new JgclSurfaceDerivative3D(p, x, y, zerov, zerov, zerov);
    }

    public JgclPointOnSurface3D project1From(JgclPoint3D point) {
        JgclCartesianTransformationOperator3D gtrans = this.toGlobal();
        JgclPoint3D lpoint = gtrans.reverseTransform(point);
        JgclPointOnSurface3D foot = new JgclPointOnSurface3D(this, lpoint.x(), lpoint.y(), false);
        return foot;
    }

    public JgclPointOnSurface3D[] projectFrom(JgclPoint3D point) {
        JgclPointOnSurface3D[] proj = new JgclPointOnSurface3D[]{this.project1From(point)};
        return proj;
    }

    public JgclMesh3D toMesh(JgclParameterSection uPint, JgclParameterSection vPint, JgclToleranceForDistance tol) {
        JgclPoint3D[][] mesh = new JgclPointOnSurface3D[2][2];
        double uParam = uPint.lower();
        int i = 0;
        while (i < 2) {
            double vParam = vPint.lower();
            int j = 0;
            while (j < 2) {
                try {
                    mesh[i][j] = new JgclPointOnSurface3D(this, uParam, vParam, false);
                }
                catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                    throw new JgclFatal();
                }
                vParam = vPint.upper();
                ++j;
            }
            uParam = uPint.upper();
            ++i;
        }
        return new JgclMesh3D(mesh, false);
    }

    public JgclBsplineSurface3D toBsplineSurface(JgclParameterSection uPint, JgclParameterSection vPint) {
        JgclPoint3D[][] controlPoints = new JgclPoint3D[2][2];
        double[][] weights = new double[2][2];
        double[] uParams = new double[]{uPint.start(), uPint.end()};
        double[] vParams = new double[]{vPint.start(), vPint.end()};
        int vi = 0;
        while (vi < 2) {
            int ui = 0;
            while (ui < 2) {
                controlPoints[ui][vi] = this.coordinates(uParams[ui], vParams[vi]);
                weights[ui][vi] = 1.0;
                ++ui;
            }
            ++vi;
        }
        return new JgclBsplineSurface3D(JgclBsplineKnot.quasiUniformKnotsOfLinearOneSegment, JgclBsplineKnot.quasiUniformKnotsOfLinearOneSegment, controlPoints, weights);
    }

    JgclRealPolynomial makePoly(JgclRealPolynomial[] poly) {
        return poly[2];
    }

    boolean checkSolution(JgclPoint3D point) {
        double dTol = this.getToleranceForDistance();
        return Math.abs(point.z()) < dTol;
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    public JgclIntersectionPoint3D intersect1(JgclLine3D mate) throws JgclIndefiniteSolution {
        JgclCartesianTransformationOperator3D gtrans = this.toGlobal();
        JgclPoint3D localPnt = gtrans.reverseTransform(mate.pnt());
        JgclVector3D localDir = gtrans.reverseTransform(mate.dir());
        double dTol = this.getToleranceForDistance();
        JgclVector3D unitDir = localDir.unitized();
        if (Math.abs(unitDir.z()) < dTol) {
            if (Math.abs(localPnt.z()) < dTol) {
                throw new JgclIndefiniteSolution(mate.pnt());
            }
            return null;
        }
        double eT = -localPnt.z() / localDir.z();
        double eU = localPnt.x() + eT * localDir.x();
        double eV = localPnt.y() + eT * localDir.y();
        JgclPointOnSurface3D Apnt = new JgclPointOnSurface3D(this, eU, eV, false);
        JgclPointOnCurve3D Bpnt = new JgclPointOnCurve3D(mate, eT, false);
        JgclIntersectionPoint3D intersectionPoint = new JgclIntersectionPoint3D(Apnt, Apnt, Bpnt, false);
        return intersectionPoint;
    }

    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclIntersectionPoint3D intp;
        try {
            intp = this.intersect1(mate);
        }
        catch (JgclIndefiniteSolution e) {
            JgclIntersectionPoint3D intp2 = (JgclIntersectionPoint3D)e.suitable();
            if (doExchange) {
                intp2 = intp2.exchange();
            }
            throw new JgclIndefiniteSolution(intp2);
        }
        if (intp == null) {
            return new JgclIntersectionPoint3D[0];
        }
        if (doExchange) {
            intp = intp.exchange();
        }
        JgclIntersectionPoint3D[] ints = new JgclIntersectionPoint3D[]{intp};
        return ints;
    }

    JgclIntersectionPoint3D[] intersect(JgclConic3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclLine3D intAB;
        JgclPlane3D osculating_plane = new JgclPlane3D(mate.position());
        try {
            intAB = this.intersect1Plane(osculating_plane);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            JgclPoint3D pnt = this.coordinates(0.0, 0.0);
            throw new JgclIndefiniteSolution(pnt);
        }
        if (intAB == null) {
            return new JgclIntersectionPoint3D[0];
        }
        JgclIntersectionPoint3D[] int_pnt = mate.intersect(intAB, false);
        JgclIntersectionPoint3D[] return_pnt = new JgclIntersectionPoint3D[int_pnt.length];
        int i = 0;
        while (i < int_pnt.length) {
            JgclPoint3D pnt = int_pnt[i].coordinates();
            JgclAxis2Placement3D plane_axis = this.position();
            JgclPoint3D plane_org = plane_axis.location();
            JgclVector3D dir_vec = pnt.subtract(plane_org);
            double dU = dir_vec.dotProduct(plane_axis.x());
            double dV = dir_vec.dotProduct(plane_axis.y());
            JgclPointOnSurface3D PonS = new JgclPointOnSurface3D(this, dU, dV, false);
            JgclPointOnGeometry3D PonC = int_pnt[i].pointOnGeometry1();
            return_pnt[i] = !doExchange ? new JgclIntersectionPoint3D(pnt, PonS, PonC, false) : new JgclIntersectionPoint3D(pnt, PonC, PonS, false);
            ++i;
        }
        return return_pnt;
    }

    public JgclSurfaceSurfaceInterference3D[] intersect(JgclParametricSurface3D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    public JgclLine3D intersect1Plane(JgclPlane3D mate) throws JgclIndefiniteSolution {
        JgclPoint3D pnt;
        double aTol = this.getToleranceForAngle();
        JgclVector3D eAnorm = this.position().z();
        JgclVector3D eBnorm = mate.position().z();
        JgclPoint3D eAloc = this.position().location();
        JgclPoint3D eBloc = mate.position().location();
        if (Math.abs(eAnorm.dotProduct(eBnorm)) > Math.cos(aTol)) {
            JgclVector3D evec = eBloc.subtract(eAloc);
            double dTol = this.getToleranceForDistance();
            if (Math.abs(evec.dotProduct(eAnorm)) < dTol && Math.abs(evec.dotProduct(eBnorm)) < dTol) {
                double dTol2 = this.getToleranceForDistance2();
                JgclPoint3D pnt2 = this.position().location();
                JgclVector3D dir = mate.position().x();
                JgclLine3D intersectLine = new JgclLine3D(pnt2, dir);
                throw new JgclIndefiniteSolution(intersectLine);
            }
            return null;
        }
        JgclVector3D dir = eAnorm.crossProduct(eBnorm).unitized();
        JgclVector3D pdir = dir.crossProduct(eAnorm);
        JgclLine3D perpendicularOfIntersection = new JgclLine3D(eAloc, pdir);
        try {
            pnt = mate.intersect1(perpendicularOfIntersection);
        }
        catch (JgclIndefiniteSolution e) {
            pnt = (JgclPoint3D)e.suitable();
        }
        JgclLine3D line = new JgclLine3D(pnt, dir);
        return line;
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclPlane3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclLine3D line;
        boolean indefinite = false;
        try {
            line = this.intersect1Plane(mate);
        }
        catch (JgclIndefiniteSolution e) {
            line = (JgclLine3D)e.suitable();
            indefinite = true;
        }
        if (line == null) {
            return new JgclSurfaceSurfaceInterference3D[0];
        }
        JgclIntersectionCurve3D ints = this.curveToIntersectionCurve(line, mate, doExchange);
        if (indefinite) {
            throw new JgclIndefiniteSolution(ints);
        }
        JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints};
        return sol;
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclSphericalSurface3D mate, boolean doExchange) {
        JgclPointOnSurface3D pcenter = this.project1From(mate.position().location());
        double dist = pcenter.distance(mate.position().location());
        double d_tol = this.getToleranceForDistance();
        if (Math.abs(dist - mate.radius()) <= d_tol) {
            double[] mateParams = mate.pointToParameter(pcenter);
            JgclIntersectionPoint3D intsPnt = !doExchange ? new JgclIntersectionPoint3D(this, pcenter.uParameter(), pcenter.vParameter(), (JgclParametricSurface3D)mate, mateParams[0], mateParams[1], false) : new JgclIntersectionPoint3D(mate, mateParams[0], mateParams[1], (JgclParametricSurface3D)this, pcenter.uParameter(), pcenter.vParameter(), false);
            JgclSurfaceSurfaceInterference3D[] intf = new JgclSurfaceSurfaceInterference3D[]{intsPnt};
            return intf;
        }
        if (dist > mate.radius()) {
            return new JgclSurfaceSurfaceInterference3D[0];
        }
        JgclAxis2Placement3D axis = new JgclAxis2Placement3D(pcenter.coordinates(), this.position().z(), this.position().x());
        double radius = Math.sqrt(mate.radius() * mate.radius() - dist * dist);
        JgclCircle3D res = new JgclCircle3D(axis, radius);
        JgclIntersectionCurve3D ints = this.curveToIntersectionCurve(res, mate, doExchange);
        JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints};
        return sol;
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclCylindricalSurface3D mate, boolean doExchange) {
        JgclPoint3D Borg = mate.position().location();
        JgclVector3D Bz = mate.position().z();
        JgclVector3D ecrs = this.position().z().crossProduct(Bz);
        double a_tol = this.getToleranceForAngle();
        if (ecrs.length() < Math.sin(a_tol)) {
            JgclPointOnSurface3D pcenter = this.project1From(Borg);
            JgclAxis2Placement3D axis = new JgclAxis2Placement3D(pcenter.coordinates(), this.position().z(), this.position().x());
            double radius = mate.radius();
            JgclCircle3D res = new JgclCircle3D(axis, radius);
            JgclIntersectionCurve3D ints = this.curveToIntersectionCurve(res, mate, doExchange);
            JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints};
            return sol;
        }
        double d_tol = this.getToleranceForDistance();
        double edot = Math.abs(this.position().z().dotProduct(Bz));
        if (edot < Math.sin(a_tol)) {
            JgclPointOnSurface3D pcenter = this.project1From(Borg);
            double dist = pcenter.distance(Borg);
            if (Math.abs(dist - mate.radius()) < d_tol) {
                JgclLine3D res = new JgclLine3D(pcenter.coordinates(), Bz);
                JgclIntersectionCurve3D ints = this.curveToIntersectionCurve(res, mate, doExchange);
                JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints};
                return sol;
            }
            if (dist < mate.radius()) {
                dist = Math.sqrt(mate.radius() * mate.radius() - dist * dist);
                ecrs = ecrs.unitized().multiply(dist);
                JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[2];
                JgclLine3D res1 = new JgclLine3D(pcenter.add(ecrs), Bz);
                JgclLine3D res2 = new JgclLine3D(pcenter.subtract(ecrs), Bz);
                sol[0] = this.curveToIntersectionCurve(res1, mate, doExchange);
                sol[1] = this.curveToIntersectionCurve(res2, mate, doExchange);
                return sol;
            }
            return new JgclSurfaceSurfaceInterference3D[0];
        }
        JgclCartesianTransformationOperator3D trns = this.toGlobal();
        JgclPoint3D BorginA = trns.toLocal(Borg);
        JgclVector3D BzinA = trns.toLocal(Bz);
        double dist = -BorginA.z() / BzinA.z();
        JgclAxis2Placement3D axis = new JgclAxis2Placement3D(Borg.add(Bz.multiply(dist)), this.position().z(), this.position().z().crossProduct(ecrs));
        JgclEllipse3D res = new JgclEllipse3D(axis, mate.radius() / edot, mate.radius());
        JgclIntersectionCurve3D ints = this.curveToIntersectionCurve(res, mate, doExchange);
        JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints};
        return sol;
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclConicalSurface3D mate, boolean doExchange) {
        JgclIntsPlnCon3D doObj = new JgclIntsPlnCon3D(this, mate);
        return doObj.getInterference(doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclPureBezierSurface3D mate, boolean doExchange) {
        return JgclIntsQrdBzs3D.intersection(this, mate, doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclBsplineSurface3D mate, boolean doExchange) {
        return JgclIntsSrfBss3D.intersection(this, mate, doExchange);
    }

    public JgclBsplineSurface3D offsetByBsplineSurface(JgclParameterSection uPint, JgclParameterSection vPint, double magni, int side, JgclToleranceForDistance tol) {
        JgclVector3D offset_vector;
        int uicp = 4;
        int uik = 2;
        double[] uknots = new double[2];
        double[] vknots = new double[2];
        int[] uknot_multi = new int[2];
        int[] vknot_multi = new int[2];
        uknots[0] = 0.0;
        uknot_multi[0] = 4;
        uknots[1] = Math.abs(uPint.increase());
        uknot_multi[1] = 4;
        vknots[0] = 0.0;
        vknot_multi[0] = 4;
        vknots[1] = Math.abs(vPint.increase());
        vknot_multi[1] = 4;
        double uparam_interval = uPint.increase() / (double)(uicp - 1);
        double vparam_interval = vPint.increase() / (double)(uicp - 1);
        if (side == 3) {
            offset_vector = this.normalVector(uPint.start(), vPint.start());
        } else if (side == 4) {
            offset_vector = this.normalVector(uPint.start(), vPint.start());
            offset_vector = offset_vector.reverse();
        } else {
            throw new JgclInvalidArgumentValue();
        }
        offset_vector = offset_vector.multiply(magni);
        JgclPoint3D[][] crnt_pnt = new JgclPoint3D[uicp][uicp];
        int i = 0;
        while (i < uicp) {
            int j = 0;
            while (j < uicp) {
                crnt_pnt[i][j] = this.coordinates(uPint.start() + (double)i * uparam_interval, vPint.start() + (double)j * vparam_interval);
                crnt_pnt[i][j] = crnt_pnt[i][j].add(offset_vector);
                ++j;
            }
            ++i;
        }
        JgclBsplineSurface3D bss = new JgclBsplineSurface3D(3, false, uknot_multi, uknots, 3, false, vknot_multi, vknots, crnt_pnt);
        return bss;
    }

    public JgclParametricCurve3D uIsoParametricCurve(double uParam) {
        JgclPoint3D pnt = this.coordinates(uParam, 0.0);
        JgclVector3D dir = this.position().y();
        return new JgclLine3D(pnt, dir);
    }

    public JgclParametricCurve3D vIsoParametricCurve(double vParam) {
        JgclPoint3D pnt = this.coordinates(0.0, vParam);
        JgclVector3D dir = this.position().x();
        return new JgclLine3D(pnt, dir);
    }

    JgclParameterDomain getUParameterDomain() {
        return new JgclParameterDomain();
    }

    JgclParameterDomain getVParameterDomain() {
        return new JgclParameterDomain();
    }

    int type() {
        return 1;
    }

    int pointIsWhichSide(JgclPoint3D point) {
        double d_tol = this.getToleranceForDistance();
        JgclCartesianTransformationOperator3D trns = new JgclCartesianTransformationOperator3D(this.position(), 1.0);
        JgclPoint3D eApnt = trns.toLocal(point);
        int result = eApnt.z() > d_tol ? 3 : (eApnt.z() < -d_tol ? 4 : 0);
        return result;
    }

    public static JgclVector3D coplaner(JgclPoint3D[] points) {
        JgclVector3D evec;
        int npnts = points.length;
        if (npnts <= 2) {
            return JgclVector3D.zeroVector();
        }
        JgclVector3D[] spanPlane = new JgclVector3D[2];
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol2 = condition.getToleranceForDistance2();
        double aTol = condition.getToleranceForAngle();
        int k = 0;
        int j = 1;
        while (j < npnts) {
            evec = points[j].subtract(points[0]);
            if (evec.norm() > dTol2) {
                evec = evec.unitized();
                if (k == 0 || !(Math.abs(evec.dotProduct(spanPlane[0])) > Math.cos(aTol))) {
                    spanPlane[k] = evec;
                    if (++k == 2) break;
                }
            }
            ++j;
        }
        if (k != 2) {
            return JgclVector3D.zeroVector();
        }
        JgclVector3D uax = spanPlane[0].crossProduct(spanPlane[1]).unitized();
        int j2 = 1;
        while (j2 < npnts) {
            evec = points[j2].subtract(points[0]);
            if (Math.abs(evec.dotProduct(uax)) > condition.getToleranceForDistance()) {
                return null;
            }
            ++j2;
        }
        return uax;
    }

    public Vector toNonStructuredPoints(JgclParameterSection uParameterSection, JgclParameterSection vParameterSection, double tolerance, double[] scalingFactor) {
        Vector<JgclPointOnSurface3D> result = new Vector<JgclPointOnSurface3D>();
        int u = 0;
        while (u < 2) {
            double uParameter = u == 0 ? uParameterSection.start() : uParameterSection.end();
            int v = 0;
            while (v < 2) {
                double vParameter = v == 0 ? vParameterSection.start() : vParameterSection.end();
                JgclPointOnSurface3D point = new JgclPointOnSurface3D(this, uParameter, vParameter, false);
                result.addElement(point);
                ++v;
            }
            ++u;
        }
        scalingFactor[0] = 1.0;
        scalingFactor[1] = 1.0;
        return result;
    }

    protected synchronized JgclParametricSurface3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclAxis2Placement3D tPosition = this.position().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        return new JgclPlane3D(tPosition);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tposition");
        this.position().output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

