/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCompositeCurve3D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment3D;
import jp.go.ipa.jgcl.JgclConic3D;
import jp.go.ipa.jgcl.JgclConicalSurface3D;
import jp.go.ipa.jgcl.JgclCylindricalSurface3D;
import jp.go.ipa.jgcl.JgclElementarySurface3D;
import jp.go.ipa.jgcl.JgclFilletObject3D;
import jp.go.ipa.jgcl.JgclFiltSrfSrf3D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclMesh3D;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclReducedToPoint;
import jp.go.ipa.jgcl.JgclSphericalSurface3D;
import jp.go.ipa.jgcl.JgclSurfaceCurvature3D;
import jp.go.ipa.jgcl.JgclSurfaceDerivative3D;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterference3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve3D;
import jp.go.ipa.jgcl.JgclVector3D;

public abstract class JgclParametricSurface3D
extends JgclParametricSurface {
    static final int PLANE_3D = 1;
    static final int CYLINDRICAL_SURFACE_3D = 10;
    static final int CONICAL_SURFACE_3D = 11;
    static final int SPHERICAL_SURFACE_3D = 12;
    static final int SURFACE_OF_LINEAR_EXTRUSION_3D = 20;
    static final int SURFACE_OF_REVOLUTION_3D = 21;
    static final int BSPLINE_SURFACE_3D = 30;
    static final int PURE_BEZIER_SURFACE_3D = 31;
    static final int RECTANGULAR_TRIMMED_SURFACE_3D = 32;
    static final int CURVE_BOUNDED_SURFACE_3D = 33;
    static final int MESH_3D = 40;

    protected JgclParametricSurface3D() {
    }

    public abstract JgclPoint3D coordinates(double var1, double var3);

    public abstract JgclVector3D[] tangentVector(double var1, double var3);

    public JgclVector3D normalVector(double uParam, double vParam) {
        JgclVector3D[] tang = this.tangentVector(uParam, vParam);
        return tang[0].crossProduct(tang[1]).unitized();
    }

    public JgclSurfaceCurvature3D curvature(double uParam, double vParam) {
        JgclSurfaceDerivative3D deriv = this.evaluation(uParam, vParam);
        return deriv.principalCurvature();
    }

    public abstract JgclSurfaceDerivative3D evaluation(double var1, double var3);

    public abstract JgclPointOnSurface3D[] projectFrom(JgclPoint3D var1) throws JgclIndefiniteSolution;

    public JgclPointOnSurface3D nearestProjectFrom(JgclPoint3D pnt) {
        JgclPointOnSurface3D[] proj;
        try {
            proj = this.projectFrom(pnt);
        }
        catch (JgclIndefiniteSolution e) {
            proj = new JgclPointOnSurface3D[]{(JgclPointOnSurface3D)e.suitable()};
        }
        if (proj.length == 0) {
            return null;
        }
        double dist = proj[0].distance2(pnt);
        int idx = 0;
        int i = 1;
        while (i < proj.length) {
            double dist2 = proj[i].distance2(pnt);
            if (dist2 < dist) {
                dist = dist2;
                idx = i;
            }
            ++i;
        }
        return proj[idx];
    }

    public JgclPointOnSurface3D nearestProjectWithDistanceFrom(JgclPoint3D pnt, double distance) {
        JgclPointOnSurface3D[] proj;
        try {
            proj = this.projectFrom(pnt);
        }
        catch (JgclIndefiniteSolution e) {
            proj = new JgclPointOnSurface3D[]{(JgclPointOnSurface3D)e.suitable()};
        }
        if (proj.length == 0) {
            return null;
        }
        double diff = Math.abs(distance - proj[0].distance(pnt));
        int idx = 0;
        int i = 1;
        while (i < proj.length) {
            double diff2 = Math.abs(distance - proj[i].distance(pnt));
            if (diff2 < diff) {
                diff = diff2;
                idx = i;
            }
            ++i;
        }
        return proj[idx];
    }

    public abstract JgclMesh3D toMesh(JgclParameterSection var1, JgclParameterSection var2, JgclToleranceForDistance var3);

    public abstract JgclBsplineSurface3D toBsplineSurface(JgclParameterSection var1, JgclParameterSection var2);

    public abstract JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D var1) throws JgclIndefiniteSolution;

    abstract JgclIntersectionPoint3D[] intersect(JgclLine3D var1, boolean var2) throws JgclIndefiniteSolution;

    abstract JgclIntersectionPoint3D[] intersect(JgclConic3D var1, boolean var2) throws JgclIndefiniteSolution;

    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    abstract JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D var1, boolean var2) throws JgclIndefiniteSolution;

    abstract JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D var1, boolean var2) throws JgclIndefiniteSolution;

    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    public abstract JgclSurfaceSurfaceInterference3D[] intersect(JgclParametricSurface3D var1) throws JgclIndefiniteSolution;

    abstract JgclSurfaceSurfaceInterference3D[] intersect(JgclPlane3D var1, boolean var2) throws JgclIndefiniteSolution;

    abstract JgclSurfaceSurfaceInterference3D[] intersect(JgclSphericalSurface3D var1, boolean var2) throws JgclIndefiniteSolution;

    abstract JgclSurfaceSurfaceInterference3D[] intersect(JgclCylindricalSurface3D var1, boolean var2) throws JgclIndefiniteSolution;

    abstract JgclSurfaceSurfaceInterference3D[] intersect(JgclConicalSurface3D var1, boolean var2) throws JgclIndefiniteSolution;

    abstract JgclSurfaceSurfaceInterference3D[] intersect(JgclPureBezierSurface3D var1, boolean var2);

    abstract JgclSurfaceSurfaceInterference3D[] intersect(JgclBsplineSurface3D var1, boolean var2);

    public abstract JgclBsplineSurface3D offsetByBsplineSurface(JgclParameterSection var1, JgclParameterSection var2, double var3, int var5, JgclToleranceForDistance var6);

    public JgclFilletObject3D[] fillet(JgclParameterSection uSect1, JgclParameterSection vSect1, int side1, JgclParametricSurface3D mate, JgclParameterSection uSect2, JgclParameterSection vSect2, int side2, double radius) throws JgclIndefiniteSolution {
        return JgclFiltSrfSrf3D.fillet(this, uSect1, vSect1, side1, mate, uSect2, vSect2, side2, radius);
    }

    public abstract JgclParametricCurve3D uIsoParametricCurve(double var1) throws JgclReducedToPoint;

    public abstract JgclParametricCurve3D vIsoParametricCurve(double var1) throws JgclReducedToPoint;

    public int dimension() {
        return 3;
    }

    public boolean is3D() {
        return true;
    }

    abstract int type();

    public double[] pointToParameter(JgclPoint3D pnt) {
        JgclPointOnSurface3D proj = this.nearestProjectFrom(pnt);
        if (proj == null) {
            throw new JgclInvalidArgumentValue();
        }
        if (pnt.identical(proj)) {
            return proj.parameters();
        }
        throw new JgclInvalidArgumentValue();
    }

    JgclIntersectionPoint3D pointToIntersectionPoint(JgclPoint3D point, JgclElementarySurface3D mate, boolean doExchange) {
        double[] thisParams = this.pointToParameter(point);
        double[] mateParams = mate.pointToParameter(point);
        if (!doExchange) {
            return new JgclIntersectionPoint3D(point, this, thisParams[0], thisParams[1], mate, mateParams[0], mateParams[1], false);
        }
        return new JgclIntersectionPoint3D(point, mate, mateParams[0], mateParams[1], this, thisParams[0], thisParams[1], false);
    }

    void confirmConnectionOfPointsOnSurface(JgclPoint2D[] pnts) {
        double gapp;
        double gapm;
        double gap0;
        double val_j;
        double val_i;
        int j;
        int i;
        double width;
        int uip = pnts.length;
        if (this.isUFinite() && this.isUPeriodic()) {
            width = this.uParameterDomain().section().absIncrease();
            i = 0;
            j = 1;
            while (j < uip) {
                val_i = pnts[i].x();
                val_j = pnts[j].x();
                gap0 = Math.abs(val_j - val_i);
                gapm = Math.abs(val_j - width - val_i);
                if (gapm < (gapp = Math.abs(val_j + width - val_i))) {
                    if (gapm < gap0) {
                        pnts[j] = new JgclCartesianPoint2D(pnts[j].x() - width, pnts[j].y());
                    }
                } else if (gapp < gap0) {
                    pnts[j] = new JgclCartesianPoint2D(pnts[j].x() + width, pnts[j].y());
                }
                ++i;
                ++j;
            }
        }
        if (this.isVFinite() && this.isVPeriodic()) {
            width = this.vParameterDomain().section().absIncrease();
            i = 0;
            j = 1;
            while (j < uip) {
                val_i = pnts[i].y();
                val_j = pnts[j].y();
                gap0 = Math.abs(val_j - val_i);
                gapm = Math.abs(val_j - width - val_i);
                if (gapm < (gapp = Math.abs(val_j + width - val_i))) {
                    if (gapm < gap0) {
                        pnts[j] = new JgclCartesianPoint2D(pnts[j].x(), pnts[j].y() - width);
                    }
                } else if (gapp < gap0) {
                    pnts[j] = new JgclCartesianPoint2D(pnts[j].x(), pnts[j].y() + width);
                }
                ++i;
                ++j;
            }
        }
    }

    public abstract Vector toNonStructuredPoints(JgclParameterSection var1, JgclParameterSection var2, double var3, double[] var5);

    protected abstract JgclParametricSurface3D doTransformBy(boolean var1, JgclCartesianTransformationOperator3D var2, Hashtable var3);

    public synchronized JgclParametricSurface3D transformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        if (transformedGeometries == null) {
            return this.doTransformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        JgclParametricSurface3D transformed = (JgclParametricSurface3D)transformedGeometries.get(this);
        if (transformed == null) {
            transformed = this.doTransformBy(reverseTransform, transformationOperator, transformedGeometries);
            transformedGeometries.put(this, transformed);
        }
        return transformed;
    }

    public synchronized JgclParametricSurface3D transformBy(JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        return this.transformBy(false, transformationOperator, transformedGeometries);
    }

    public synchronized JgclParametricSurface3D reverseTransformBy(JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        return this.transformBy(true, transformationOperator, transformedGeometries);
    }
}

