/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclGeometry;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;

public abstract class JgclParametricSurface
extends JgclGeometry {
    private JgclParameterDomain uDomain;
    private JgclParameterDomain vDomain;

    protected JgclParametricSurface() {
        this.initFields();
    }

    private void initFields() {
        this.uDomain = null;
        this.vDomain = null;
    }

    public JgclParameterDomain uParameterDomain() {
        if (this.uDomain == null) {
            this.uDomain = this.getUParameterDomain();
        }
        return this.uDomain;
    }

    public JgclParameterDomain vParameterDomain() {
        if (this.vDomain == null) {
            this.vDomain = this.getVParameterDomain();
        }
        return this.vDomain;
    }

    public boolean isSurface() {
        return true;
    }

    public boolean isParametric() {
        return true;
    }

    public boolean isUFinite() {
        return this.uParameterDomain().isFinite();
    }

    public boolean isVFinite() {
        return this.vParameterDomain().isFinite();
    }

    public boolean isUInfinite() {
        return this.uParameterDomain().isInfinite();
    }

    public boolean isVInfinite() {
        return this.vParameterDomain().isInfinite();
    }

    public boolean isUPeriodic() {
        return this.uParameterDomain().isPeriodic();
    }

    public boolean isVPeriodic() {
        return this.vParameterDomain().isPeriodic();
    }

    public boolean isUNonPeriodic() {
        return this.uParameterDomain().isNonPeriodic();
    }

    public boolean isVNonPeriodic() {
        return this.vParameterDomain().isNonPeriodic();
    }

    public boolean isValidUParameter(double value) {
        return this.uParameterDomain().isValid(value);
    }

    public boolean isValidVParameter(double value) {
        return this.vParameterDomain().isValid(value);
    }

    public void checkUValidity(double value) {
        this.uParameterDomain().checkValidity(value);
    }

    public void checkVValidity(double value) {
        this.vParameterDomain().checkValidity(value);
    }

    public void checkUValidity(JgclParameterSection section) {
        this.uParameterDomain().checkValidity(section);
    }

    public void checkVValidity(JgclParameterSection section) {
        this.vParameterDomain().checkValidity(section);
    }

    abstract JgclParameterDomain getUParameterDomain();

    abstract JgclParameterDomain getVParameterDomain();
}

