/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclGeometry;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;

public abstract class JgclParametricCurve
extends JgclGeometry {
    private JgclParameterDomain domain;
    private int closedCurve;

    protected JgclParametricCurve() {
        this.initFields();
    }

    private void initFields() {
        this.domain = null;
        this.closedCurve = -1;
    }

    public abstract double length(JgclParameterSection var1);

    public JgclParameterDomain parameterDomain() {
        if (this.domain == null) {
            this.domain = this.getParameterDomain();
        }
        return this.domain;
    }

    public boolean isClosed() {
        if (this.closedCurve == -1) {
            this.closedCurve = this.getClosedFlag() ? 1 : 0;
        }
        return this.closedCurve == 1;
    }

    public boolean isOpen() {
        return !this.isClosed();
    }

    public boolean isCurve() {
        return true;
    }

    public boolean isParametric() {
        return true;
    }

    public boolean isFinite() {
        return this.parameterDomain().isFinite();
    }

    public boolean isInfinite() {
        return this.parameterDomain().isInfinite();
    }

    public boolean isPeriodic() {
        return this.parameterDomain().isPeriodic();
    }

    public boolean isNonPeriodic() {
        return this.parameterDomain().isNonPeriodic();
    }

    public boolean isValid(double value) {
        return this.parameterDomain().isValid(value);
    }

    public void checkValidity(double value) {
        this.parameterDomain().checkValidity(value);
    }

    public void checkValidity(JgclParameterSection section) {
        this.parameterDomain().checkValidity(section);
    }

    abstract JgclParameterDomain getParameterDomain();

    abstract boolean getClosedFlag();
}

