/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.Serializable;
import jp.go.ipa.jgcl.JgclConditionOfOperation;

public class JgclParameterSection
implements Serializable {
    private final double start;
    private final double increase;
    private final double end;

    public JgclParameterSection(double start, double increase) {
        this.start = start;
        this.increase = increase;
        this.end = start + increase;
    }

    public double start() {
        return this.start;
    }

    public double end() {
        return this.end;
    }

    public double increase() {
        return this.increase;
    }

    public double absIncrease() {
        return Math.abs(this.increase);
    }

    public double lower() {
        if (this.increase() < 0.0) {
            return this.end();
        }
        return this.start();
    }

    public double upper() {
        if (this.increase() >= 0.0) {
            return this.end();
        }
        return this.start();
    }

    public JgclParameterSection reverse() {
        return new JgclParameterSection(this.end(), -this.increase());
    }

    public JgclParameterSection positiveIncrease() {
        return this.increase() < 0.0 ? this.reverse() : this;
    }

    public boolean isValid(double value) {
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double sval = this.start();
        double eval = this.end();
        double pTol = condition.getToleranceForParameter();
        if (this.increase() >= 0.0) {
            return sval - pTol <= value && value <= eval + pTol;
        }
        return eval - pTol <= value && value <= sval + pTol;
    }

    public boolean identical(JgclParameterSection mate) {
        if (this == mate) {
            return true;
        }
        double pTol = JgclConditionOfOperation.getCondition().getToleranceForParameter();
        if (Math.abs(this.start() - mate.start()) > pTol) {
            return false;
        }
        return !(Math.abs(this.increase() - mate.increase()) > pTol);
    }
}

