/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclAxis2Placement2D;
import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclCompositeCurve3D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclConic2D;
import jp.go.ipa.jgcl.JgclConic3D;
import jp.go.ipa.jgcl.JgclCurveCurvature3D;
import jp.go.ipa.jgcl.JgclCurveDerivative3D;
import jp.go.ipa.jgcl.JgclEllipse3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclHyperbola3D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclIntsCncBzs3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclParabola2D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclTrimmedCurve3D;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclParabola3D
extends JgclConic3D {
    private double focalDist;

    private void setFocalDist(double focalDist) {
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol = condition.getToleranceForDistance();
        if (focalDist < dTol) {
            throw new JgclInvalidArgumentValue();
        }
        this.focalDist = focalDist;
    }

    public JgclParabola3D(JgclAxis2Placement3D position, double focalDist) {
        super(position);
        this.setFocalDist(focalDist);
    }

    JgclConic2D toLocal2D(JgclAxis2Placement2D position) {
        return new JgclParabola2D(position, this.focalDist());
    }

    public double focalDist() {
        return this.focalDist;
    }

    public JgclPoint3D coordinates(double param) {
        JgclAxis2Placement3D ax = this.position();
        JgclVector3D x = ax.x().multiply(param * param * this.focalDist);
        JgclVector3D y = ax.y().multiply(2.0 * param * this.focalDist);
        return ax.location().add(x.add(y));
    }

    public JgclVector3D tangentVector(double param) {
        JgclAxis2Placement3D ax = this.position();
        JgclVector3D x1 = ax.x().multiply(2.0 * param * this.focalDist);
        JgclVector3D y1 = ax.y().multiply(2.0 * this.focalDist);
        return x1.add(y1);
    }

    public JgclCurveCurvature3D curvature(double param) {
        JgclAxis2Placement3D ax = this.position();
        double x1len = 2.0 * param * this.focalDist;
        double y1len = 2.0 * this.focalDist;
        double x2len = 2.0 * this.focalDist;
        double tlen = Math.sqrt(x1len * x1len + y1len * y1len);
        double crv = Math.abs(y1len * x2len) / (tlen * tlen * tlen);
        JgclVector3D ex1 = ax.x().multiply(x1len);
        JgclVector3D ey1 = ax.y().multiply(y1len);
        JgclVector3D tangent = ex1.add(ey1);
        JgclVector3D nrmDir = tangent.crossProduct(ax.z());
        return new JgclCurveCurvature3D(crv, nrmDir.unitized());
    }

    public JgclCurveDerivative3D evaluation(double param) {
        JgclAxis2Placement3D ax = this.position();
        JgclVector3D ex = ax.x().multiply(param * param * this.focalDist);
        JgclVector3D ey = ax.y().multiply(2.0 * param * this.focalDist);
        JgclVector3D ex1 = ax.x().multiply(2.0 * param * this.focalDist);
        JgclVector3D ey1 = ax.y().multiply(2.0 * this.focalDist);
        JgclVector3D ex2 = ax.x().multiply(2.0 * this.focalDist);
        JgclPoint3D d0 = ax.location().add(ex.add(ey));
        JgclVector3D d1 = ex1.add(ey1);
        JgclVector3D zero = JgclVector3D.zeroVector;
        return new JgclCurveDerivative3D(d0, d1, ex2, zero);
    }

    double getPeak(double left, double right) {
        return (left + right) / 2.0;
    }

    public JgclPureBezierCurve3D[] toPolyBezierCurves(JgclParameterSection pint) {
        JgclParabola2D this2D = (JgclParabola2D)this.toLocal2D(JgclAxis2Placement2D.origin);
        JgclPureBezierCurve2D[] bzcs2D = this2D.toPolyBezierCurves(pint);
        return this.transformPolyBezierCurvesInLocal2DToGrobal3D(bzcs2D);
    }

    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection pint) {
        JgclPureBezierCurve3D[] bzcs = this.toPolyBezierCurves(pint);
        return bzcs[0].toBsplineCurve();
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    JgclRealPolynomial makePoly(JgclRealPolynomial[] poly) {
        JgclRealPolynomial yPoly = poly[1].multiply(poly[1]);
        double dA4fd = 4.0 * this.focalDist();
        boolean isPoly = poly.length < 4;
        int degree = yPoly.degree();
        double[] coef = new double[degree + 1];
        if (isPoly) {
            int deg = poly[1].degree();
            int j = 0;
            while (j <= degree) {
                coef[j] = j > degree - deg ? yPoly.coefficientAt(j) : yPoly.coefficientAt(j) - dA4fd * poly[0].coefficientAt(j);
                ++j;
            }
        } else {
            JgclRealPolynomial xwPoly = poly[0].multiply(poly[3]);
            int j = 0;
            while (j <= degree) {
                coef[j] = yPoly.coefficientAt(j) - dA4fd * xwPoly.coefficientAt(j);
                ++j;
            }
        }
        return new JgclRealPolynomial(coef);
    }

    boolean checkSolution(JgclPoint3D point) {
        double param = this.getParameter(point);
        double px = this.focalDist() * param * param;
        double py = 2.0 * this.focalDist() * param;
        return point.identical(new JgclCartesianPoint3D(px, py, 0.0));
    }

    double getParameter(JgclPoint3D point) {
        return point.y() / (2.0 * this.focalDist());
    }

    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) {
        try {
            return this.intersectCnc(mate, doExchange);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
    }

    JgclIntersectionPoint3D[] intersect(JgclEllipse3D mate, boolean doExchange) {
        try {
            return this.intersectCnc(mate, doExchange);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
    }

    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return this.intersectCnc(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) {
        try {
            return this.intersectCnc(mate, doExchange);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
    }

    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
        return new JgclParabola3D(this.position().parallelTranslate(moveVec), this.focalDist);
    }

    JgclParameterDomain getParameterDomain() {
        return new JgclParameterDomain();
    }

    boolean getClosedFlag() {
        return false;
    }

    int type() {
        return 13;
    }

    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns, double rCos, double rSin) {
        JgclAxis2Placement3D rpos = this.position().rotateZ(trns, rCos, rSin);
        return new JgclParabola3D(rpos, this.focalDist());
    }

    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
        JgclVector3D vector;
        JgclPoint3D point;
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol2 = condition.getToleranceForDistance2();
        double start = 0.0;
        double increase = 1.0;
        int itry = 0;
        int limit = 100;
        do {
            if (itry > limit) {
                throw new JgclFatal();
            }
            point = this.coordinates(start + increase * (double)itry);
            vector = point.subtract(line.project1From(point));
            ++itry;
        } while (point.isOn(line) || vector.norm() < dTol2);
        return point;
    }

    boolean checkInterfere(JgclIntsCncBzs3D.BezierSurfaceInfo bi) {
        double dTol = this.getToleranceForDistance();
        if (!(bi.box.min().z() < -dTol) || !(bi.box.max().z() > dTol)) {
            return false;
        }
        if (bi.box.max().x() < -dTol) {
            return false;
        }
        boolean all_in = true;
        boolean all_out = true;
        JgclPoint2D point = null;
        int i = 0;
        while (i < 4) {
            switch (i) {
                case 0: {
                    point = new JgclCartesianPoint2D(bi.box.min().x(), bi.box.min().y());
                    break;
                }
                case 1: {
                    point = new JgclCartesianPoint2D(bi.box.max().x(), bi.box.min().y());
                    break;
                }
                case 2: {
                    point = new JgclCartesianPoint2D(bi.box.max().x(), bi.box.max().y());
                    break;
                }
                case 3: {
                    point = new JgclCartesianPoint2D(bi.box.min().x(), bi.box.max().y());
                    break;
                }
            }
            double epara = point.y() / (2.0 * this.focalDist());
            double ex = this.focalDist() * epara * epara;
            ex = point.x() - ex;
            if (ex < -dTol) {
                all_in = false;
            } else if (ex > dTol) {
                all_out = false;
            } else {
                all_out = false;
                all_in = false;
            }
            ++i;
        }
        if (all_in) {
            return false;
        }
        if (all_out) {
            return !(bi.box.min().y() * bi.box.max().y() > 0.0);
        }
        return true;
    }

    JgclIntersectionPoint3D[] intersectConicPlane(JgclPlane3D plane) {
        JgclAxis2Placement3D position = new JgclAxis2Placement3D(JgclPoint3D.origin, null, null);
        JgclParabola3D parabola = new JgclParabola3D(position, this.focalDist());
        try {
            return parabola.intersect(plane);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
    }

    JgclPoint3D nlFunc(double parameter) {
        double y = this.focalDist() * parameter;
        double x = y * parameter;
        y = 2.0 * y;
        double z = 0.0;
        return new JgclCartesianPoint3D(x, y, z);
    }

    JgclVector3D dnlFunc(double parameter) {
        double y = 2.0 * this.focalDist();
        double x = y * parameter;
        double z = 0.0;
        return new JgclLiteralVector3D(x, y, z);
    }

    protected synchronized JgclParametricCurve3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclAxis2Placement3D tPosition = this.position().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        double tFocalDist = !reverseTransform ? transformationOperator.transform(this.focalDist()) : transformationOperator.reverseTransform(this.focalDist());
        return new JgclParabola3D(tPosition, tFocalDist);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tposition");
        this.position().output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tfocalDist " + this.focalDist);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

