/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import jp.go.ipa.jgcl.JgclCurveCurveInterference2D;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclNonParametricCurve2D;
import jp.go.ipa.jgcl.JgclParameterConversion2D;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclTrimmedCurve2D;

public class JgclOverlapCurve2D
extends JgclNonParametricCurve2D
implements JgclCurveCurveInterference2D {
    private JgclTrimmedCurve2D trc1;
    private JgclTrimmedCurve2D trc2;

    private JgclOverlapCurve2D() {
        this.trc1 = null;
        this.trc2 = null;
    }

    JgclOverlapCurve2D(JgclTrimmedCurve2D trc1, JgclTrimmedCurve2D trc2, boolean doCheck) {
        this.trc1 = trc1;
        this.trc2 = trc2;
    }

    JgclOverlapCurve2D(JgclParametricCurve2D curve1, JgclParameterSection section1, JgclParametricCurve2D curve2, JgclParameterSection section2, boolean doCheck) {
        this.trc1 = new JgclTrimmedCurve2D(curve1, section1);
        this.trc2 = new JgclTrimmedCurve2D(curve2, section2);
    }

    public JgclOverlapCurve2D(JgclParametricCurve2D curve1, double start1, double inc1, JgclParametricCurve2D curve2, double start2, double inc2, boolean doCheck) {
        this.trc1 = new JgclTrimmedCurve2D(curve1, new JgclParameterSection(start1, inc1));
        this.trc2 = new JgclTrimmedCurve2D(curve2, new JgclParameterSection(start2, inc2));
    }

    public JgclParametricCurve2D curve1() {
        return this.trc1.basisCurve();
    }

    public double start1() {
        return this.trc1.tParam1();
    }

    public double end1() {
        return this.trc1.tParam2();
    }

    public double increase1() {
        return this.end1() - this.start1();
    }

    public JgclParametricCurve2D curve2() {
        return this.trc2.basisCurve();
    }

    public double start2() {
        return this.trc2.tParam1();
    }

    public double end2() {
        return this.trc2.tParam2();
    }

    public double increase2() {
        return this.end2() - this.start2();
    }

    public boolean isIntersectionPoint() {
        return false;
    }

    public boolean isOverlapCurve() {
        return true;
    }

    public JgclIntersectionPoint2D toIntersectionPoint() {
        return null;
    }

    public JgclOverlapCurve2D toOverlapCurve() {
        return this;
    }

    public JgclOverlapCurve2D exchange() {
        JgclOverlapCurve2D ex = new JgclOverlapCurve2D();
        ex.trc1 = this.trc2;
        ex.trc2 = this.trc1;
        return ex;
    }

    public JgclCurveCurveInterference2D trim1(JgclParameterSection sec, JgclParameterConversion2D conv) {
        double upper1;
        double lower1;
        if (this.trc1.senseAgreement()) {
            lower1 = sec.lower();
            upper1 = sec.upper();
        } else {
            lower1 = sec.upper();
            upper1 = sec.lower();
        }
        double lower = this.trc1.toOwnParameter(lower1);
        double upper = this.trc1.toOwnParameter(upper1);
        int lowerValidity = this.trc1.parameterValidity(lower);
        int upperValidity = this.trc1.parameterValidity(upper);
        if (lowerValidity == 3 && lower > 0.0) {
            return null;
        }
        if (upperValidity == 3 && upper <= 0.0) {
            return null;
        }
        if (lowerValidity == 2) {
            JgclPointOnCurve2D poc2 = new JgclPointOnCurve2D(this.trc2.basisCurve(), this.trc2.tParam2(), false);
            return new JgclIntersectionPoint2D(conv.convToPoint(lower1), poc2, false);
        }
        if (upperValidity == 1) {
            JgclPointOnCurve2D poc1 = new JgclPointOnCurve2D(this.trc2.basisCurve(), this.trc2.tParam1(), false);
            return new JgclIntersectionPoint2D(conv.convToPoint(upper1), poc1, false);
        }
        double lparam1 = 0.0;
        double uparam1 = Math.abs(this.trc1.tParam2() - this.trc1.tParam1());
        double lparam2 = 0.0;
        double uparam2 = Math.abs(this.trc2.tParam2() - this.trc2.tParam1());
        if (upperValidity == 0) {
            JgclPointOnCurve2D upoint1 = new JgclPointOnCurve2D(this.trc1.basisCurve(), upper1, false);
            uparam2 = this.trc2.pointToParameter(upoint1);
            uparam1 = upper;
        }
        if (lowerValidity == 0) {
            JgclPointOnCurve2D lpoint1 = new JgclPointOnCurve2D(this.trc1.basisCurve(), lower1, false);
            lparam2 = this.trc2.pointToParameter(lpoint1);
            lparam1 = lower;
        }
        JgclParameterSection pint1 = this.trc1.toBasisParameter(new JgclParameterSection(lparam1, uparam1 - lparam1));
        JgclParameterSection pint2 = this.trc2.toBasisParameter(new JgclParameterSection(lparam2, uparam2 - lparam2));
        if (upperValidity != 0 && lowerValidity != 0) {
            return new JgclOverlapCurve2D(conv.convToTrimmedCurve(pint1), this.trc2, false);
        }
        JgclTrimmedCurve2D trc = new JgclTrimmedCurve2D(this.trc2.basisCurve(), pint2);
        return new JgclOverlapCurve2D(conv.convToTrimmedCurve(pint1), trc, false);
    }

    public JgclCurveCurveInterference2D trim2(JgclParameterSection sec, JgclParameterConversion2D conv) {
        double upper2;
        double lower2;
        if (this.trc2.senseAgreement()) {
            lower2 = sec.lower();
            upper2 = sec.upper();
        } else {
            lower2 = sec.upper();
            upper2 = sec.lower();
        }
        double lower = this.trc2.toOwnParameter(lower2);
        double upper = this.trc2.toOwnParameter(upper2);
        int lowerValidity = this.trc2.parameterValidity(lower);
        int upperValidity = this.trc2.parameterValidity(upper);
        if (lowerValidity == 3 && lower > 0.0) {
            return null;
        }
        if (upperValidity == 3 && upper <= 0.0) {
            return null;
        }
        if (lowerValidity == 2) {
            JgclPointOnCurve2D poc2 = new JgclPointOnCurve2D(this.trc1.basisCurve(), this.trc1.tParam2(), false);
            return new JgclIntersectionPoint2D(poc2, conv.convToPoint(lower2), false);
        }
        if (upperValidity == 1) {
            JgclPointOnCurve2D poc1 = new JgclPointOnCurve2D(this.trc1.basisCurve(), this.trc1.tParam1(), false);
            return new JgclIntersectionPoint2D(poc1, conv.convToPoint(upper2), false);
        }
        double lparam1 = 0.0;
        double uparam1 = Math.abs(this.trc1.tParam2() - this.trc1.tParam1());
        double lparam2 = 0.0;
        double uparam2 = Math.abs(this.trc2.tParam2() - this.trc2.tParam1());
        if (upperValidity == 0) {
            JgclPointOnCurve2D upoint2 = new JgclPointOnCurve2D(this.trc2.basisCurve(), upper2, false);
            uparam2 = upper;
            uparam1 = this.trc1.pointToParameter(upoint2);
        }
        if (lowerValidity == 0) {
            JgclPointOnCurve2D lpoint2 = new JgclPointOnCurve2D(this.trc2.basisCurve(), lower2, false);
            lparam2 = lower;
            lparam1 = this.trc1.pointToParameter(lpoint2);
        }
        JgclParameterSection pint1 = this.trc1.toBasisParameter(new JgclParameterSection(lparam1, uparam1 - lparam1));
        JgclParameterSection pint2 = this.trc2.toBasisParameter(new JgclParameterSection(lparam2, uparam2 - lparam2));
        if (upperValidity != 0 && lowerValidity != 0) {
            return new JgclOverlapCurve2D(this.trc1, conv.convToTrimmedCurve(pint2), false);
        }
        JgclTrimmedCurve2D trc = new JgclTrimmedCurve2D(this.trc1.basisCurve(), pint1);
        return new JgclOverlapCurve2D(trc, conv.convToTrimmedCurve(pint2), false);
    }

    public JgclCurveCurveInterference2D changeCurve1(JgclParametricCurve2D newCurve) {
        JgclTrimmedCurve2D newTrc1 = new JgclTrimmedCurve2D(newCurve, this.trc1.tPnt1(), this.trc1.tPnt2(), this.trc1.tParam1(), this.trc1.tParam2(), this.trc1.masterRepresentation1(), this.trc1.masterRepresentation2(), this.trc1.senseAgreement());
        return new JgclOverlapCurve2D(newTrc1, this.trc2, false);
    }

    public JgclCurveCurveInterference2D changeCurve2(JgclParametricCurve2D newCurve) {
        JgclTrimmedCurve2D newTrc2 = new JgclTrimmedCurve2D(newCurve, this.trc2.tPnt1(), this.trc2.tPnt2(), this.trc2.tParam1(), this.trc2.tParam2(), this.trc2.masterRepresentation1(), this.trc2.masterRepresentation2(), this.trc2.senseAgreement());
        return new JgclOverlapCurve2D(this.trc1, newTrc2, false);
    }

    public boolean isFreeform() {
        return this.trc1.isFreeform() && this.trc2.isFreeform();
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\ttrc1");
        this.trc1.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\ttrc2");
        this.trc2.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

