/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclMachineEpsilon;
import jp.go.ipa.jgcl.JgclRuntimeException;

public class JgclMatrix
implements Cloneable {
    private static final double epsilon4DiagonalElements = 1.0E-8;
    private int nRows;
    private int nCols;
    private double[][] elm;
    private int[] pvt;
    private boolean LUDecomposed;

    private JgclMatrix(JgclMatrix src) {
        this.nRows = src.getRowSize();
        this.nCols = src.getColumnSize();
        this.elm = new double[this.nRows][this.nCols];
        this.pvt = new int[this.nRows];
        int i = 0;
        while (i < this.nRows) {
            this.pvt[i] = src.pvt[i];
            int j = 0;
            while (j < this.nCols) {
                this.elm[this.pvt[i]][j] = src.elm[src.pvt[i]][j];
                ++j;
            }
            ++i;
        }
        this.LUDecomposed = src.LUDecomposed;
    }

    public JgclMatrix(int r, int c) {
        this.nRows = r;
        this.nCols = c;
        this.elm = new double[this.nRows][this.nCols];
        this.pvt = new int[this.nRows];
        int i = 0;
        while (i < this.nRows) {
            this.pvt[i] = i;
            int j = 0;
            while (j < this.nCols) {
                this.elm[this.pvt[i]][j] = 0.0;
                ++j;
            }
            ++i;
        }
        this.LUDecomposed = false;
    }

    public JgclMatrix(double[][] values) {
        this.nRows = values.length;
        this.nCols = values[0].length;
        this.elm = new double[this.nRows][this.nCols];
        this.pvt = new int[this.nRows];
        int i = 0;
        while (i < this.nRows) {
            this.pvt[i] = i;
            int j = 0;
            while (j < this.nCols) {
                this.elm[this.pvt[i]][j] = values[i][j];
                ++j;
            }
            ++i;
        }
        this.LUDecomposed = false;
    }

    public int getRowSize() {
        return this.nRows;
    }

    public int getColumnSize() {
        return this.nCols;
    }

    public void setElementsAt(int i, double[] value) {
        if (this.LUDecomposed) {
            throw new MatrixIsLUDecomposed();
        }
        int j = 0;
        while (j < this.nCols) {
            this.elm[this.pvt[i]][j] = value[j];
            ++j;
        }
    }

    public void setElementAt(int i, int j, double value) {
        if (this.LUDecomposed) {
            throw new MatrixIsLUDecomposed();
        }
        this.elm[this.pvt[i]][j] = value;
    }

    public double getElementAt(int i, int j) {
        return this.elm[this.pvt[i]][j];
    }

    private double elm(int i, int j) {
        return this.elm[this.pvt[i]][j];
    }

    public JgclMatrix copy() {
        return new JgclMatrix(this);
    }

    public Object clone() {
        return this.copy();
    }

    public JgclMatrix add(JgclMatrix mate) {
        if (this.nRows != mate.nRows || this.nCols != mate.nCols) {
            throw new JgclInvalidArgumentValue();
        }
        JgclMatrix add = new JgclMatrix(this.nRows, this.nCols);
        int i = 0;
        while (i < this.nRows) {
            int j = 0;
            while (j < this.nCols) {
                add.setElementAt(i, j, this.getElementAt(i, j) + mate.getElementAt(i, j));
                ++j;
            }
            ++i;
        }
        return add;
    }

    public JgclMatrix subtract(JgclMatrix mate) {
        if (this.nRows != mate.nRows || this.nCols != mate.nCols) {
            throw new JgclInvalidArgumentValue();
        }
        JgclMatrix sub = new JgclMatrix(this.nRows, this.nCols);
        int i = 0;
        while (i < this.nRows) {
            int j = 0;
            while (j < this.nCols) {
                sub.setElementAt(i, j, this.getElementAt(i, j) - mate.getElementAt(i, j));
                ++j;
            }
            ++i;
        }
        return sub;
    }

    public JgclMatrix multiply(JgclMatrix mate) {
        if (this.nCols != mate.nRows) {
            throw new JgclInvalidArgumentValue();
        }
        JgclMatrix multi = new JgclMatrix(this.nRows, mate.nCols);
        int i = 0;
        while (i < this.nRows) {
            double[] iRow = this.elm[i];
            int j = 0;
            while (j < mate.nCols) {
                double value = 0.0;
                int k = 0;
                while (k < this.nCols) {
                    value += iRow[k] * mate.getElementAt(k, j);
                    ++k;
                }
                multi.setElementAt(i, j, value);
                ++j;
            }
            ++i;
        }
        return multi;
    }

    public double determinant() {
        if (this.nRows != this.nCols) {
            throw new MatrixIsNotSquare();
        }
        int theSize = this.nRows;
        if (theSize == 2) {
            return this.elm(0, 0) * this.elm(1, 1) - this.elm(0, 1) * this.elm(1, 0);
        }
        double result = 0.0;
        int i = 0;
        while (i < theSize) {
            double valueP = 1.0;
            double valueM = 1.0;
            int j = 0;
            while (j < theSize) {
                int k = (i + j) % theSize;
                valueP *= this.elm(k, j);
                valueM *= this.elm(theSize - 1 - k, j);
                ++j;
            }
            result += valueP;
            result -= valueM;
            ++i;
        }
        return result;
    }

    private boolean doLUDecompose() {
        if (this.nRows != this.nCols) {
            throw new MatrixIsNotSquare();
        }
        int theSize = this.nRows;
        int i = 0;
        while (i < theSize) {
            int maxIdx = i;
            double maxVal = Math.abs(this.elm(maxIdx, i));
            int j = i + 1;
            while (j < theSize) {
                double jValue = Math.abs(this.elm(j, i));
                if (jValue > maxVal) {
                    maxIdx = j;
                    maxVal = jValue;
                }
                ++j;
            }
            if (maxIdx != i) {
                int pvtVal = this.pvt[i];
                this.pvt[i] = this.pvt[maxIdx];
                this.pvt[maxIdx] = pvtVal;
            }
            if (Math.abs(this.elm(i, i)) < 1.0E-8) {
                return false;
            }
            this.setElementAt(i, i, 1.0 / this.elm(i, i));
            int j2 = i + 1;
            while (j2 < theSize) {
                this.setElementAt(j2, i, this.elm(j2, i) * this.elm(i, i));
                int k = i + 1;
                while (k < theSize) {
                    this.setElementAt(j2, k, this.elm(j2, k) - this.elm(j2, i) * this.elm(i, k));
                    ++k;
                }
                ++j2;
            }
            ++i;
        }
        return true;
    }

    public JgclMatrix makeLUDecomposition() {
        if (this.nRows != this.nCols) {
            throw new MatrixIsNotSquare();
        }
        if (this.LUDecomposed) {
            return this;
        }
        JgclMatrix dst = this.copy();
        if (!dst.doLUDecompose()) {
            return null;
        }
        dst.LUDecomposed = true;
        return dst;
    }

    private double[] doSolveSimultaneousLinearEquations(double[] rightHandValues) {
        double theValue;
        if (!this.LUDecomposed) {
            return null;
        }
        int n = this.nRows;
        if (n != rightHandValues.length) {
            throw new JgclInvalidArgumentValue();
        }
        double[] result = new double[n];
        int i = 0;
        while (i < n) {
            theValue = rightHandValues[this.pvt[i]];
            int j = 0;
            while (j < i) {
                theValue -= this.elm(i, j) * result[j];
                ++j;
            }
            result[i] = theValue;
            ++i;
        }
        int i2 = n - 1;
        while (i2 >= 0) {
            theValue = result[i2];
            int j = i2 + 1;
            while (j < n) {
                theValue -= this.elm(i2, j) * result[j];
                ++j;
            }
            result[i2] = theValue * this.elm(i2, i2);
            --i2;
        }
        return result;
    }

    public double[] solveSimultaneousLinearEquations(double[] rightHandValues) {
        JgclMatrix LUDecomp = this.makeLUDecomposition();
        if (LUDecomp == null) {
            return null;
        }
        return LUDecomp.doSolveSimultaneousLinearEquations(rightHandValues);
    }

    private QRDecomposition doHouseHolderQRDecomposition() {
        int n = this.getRowSize();
        int m = this.getColumnSize();
        int[] ip = new int[m];
        double[] rd = new double[m];
        double[] g2 = new double[m];
        double[] coef = new double[m];
        double gmax = 0.0;
        double tmax = 0.0;
        double my_minute = 1.0E-75;
        int i = 0;
        while (i < m) {
            ip[i] = i;
            ++i;
        }
        int k = 0;
        while (k < m) {
            int kp = 0;
            gmax = 0.0;
            tmax = 0.0;
            int j = k;
            while (j < m) {
                double t = 0.0;
                i = k;
                while (i < n) {
                    t += this.elm(i, ip[j]) * this.elm(i, ip[j]);
                    ++i;
                }
                if (k == 0) {
                    g2[ip[j]] = t;
                    if (t > tmax) {
                        tmax = t;
                        kp = j;
                    }
                } else {
                    double gv = 0.0;
                    if (g2[ip[j]] != 0.0) {
                        gv = t / g2[ip[j]];
                    }
                    if (gv > gmax) {
                        gmax = gv;
                        tmax = t;
                        kp = j;
                    }
                }
                ++j;
            }
            if (k == 0 && tmax < my_minute || k > 0 && gmax < JgclMachineEpsilon.DOUBLE) {
                int rank = k;
                double cond = 1.0 / Math.sqrt(JgclMachineEpsilon.DOUBLE);
                return new QRDecomposition(rd, coef, ip, rank, cond);
            }
            if (kp != k) {
                int kv = ip[k];
                ip[k] = ip[kp];
                ip[kp] = kv;
            }
            double s = Math.sqrt(tmax);
            if (this.elm(k, ip[k]) < 0.0) {
                s = -s;
            }
            this.setElementAt(k, ip[k], this.elm(k, ip[k]) + s);
            coef[ip[k]] = 1.0 / (this.elm(k, ip[k]) * s);
            rd[ip[k]] = -1.0 / s;
            j = k + 1;
            while (j < m) {
                double t = 0.0;
                int l = k;
                while (l < n) {
                    t += this.elm(l, ip[k]) * this.elm(l, ip[j]);
                    ++l;
                }
                this.setElementAt(k, ip[j], this.elm(k, ip[j]) - (t *= coef[ip[k]]) * this.elm(k, ip[k]));
                i = k + 1;
                while (i < n) {
                    this.setElementAt(i, ip[j], this.elm(i, ip[j]) - t * this.elm(i, ip[k]));
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        int rank = m;
        double cond = 1.0 / Math.sqrt(gmax);
        return new QRDecomposition(rd, coef, ip, rank, cond);
    }

    private double[] solveQREquations(QRDecomposition decomposition, double[] rightHandValues) {
        double[] rd = decomposition.getDiagonalElementOfR();
        double[] coef = decomposition.getCoefficent();
        int[] ip = decomposition.getIndexVector();
        int rank = decomposition.getApproximatedRankOfA();
        int n = this.getRowSize();
        int m = this.getColumnSize();
        double[] solution = new double[m];
        int k = 0;
        while (k < rank) {
            double t = 0.0;
            int l = k;
            while (l < n) {
                t += this.elm(l, ip[k]) * rightHandValues[l];
                ++l;
            }
            t *= coef[ip[k]];
            int i = k;
            while (i < n) {
                int n2 = i;
                rightHandValues[n2] = rightHandValues[n2] - t * this.elm(i, ip[k]);
                ++i;
            }
            ++k;
        }
        int k2 = rank - 1;
        while (k2 >= 0) {
            double t = rightHandValues[k2];
            int j = k2 + 1;
            while (j < rank) {
                t -= this.elm(k2, ip[j]) * solution[ip[j]];
                ++j;
            }
            solution[ip[k2]] = t * rd[ip[k2]];
            --k2;
        }
        if (rank != m) {
            int k3 = rank;
            while (k3 < m) {
                solution[ip[k3]] = 0.0;
                ++k3;
            }
        }
        return solution;
    }

    public LinearLeastSquareSolution solveLinearLeastSquare(double[] rightHandValues) {
        if (this.nRows != rightHandValues.length) {
            throw new JgclInvalidArgumentValue();
        }
        JgclMatrix me = this.copy();
        QRDecomposition decomposition = me.doHouseHolderQRDecomposition();
        double[] solutions = me.solveQREquations(decomposition, rightHandValues);
        return new LinearLeastSquareSolution(decomposition.getApproximatedRankOfA(), decomposition.getCondition(), solutions);
    }

    private QRDecomposition doHouseHolderQRDecomposition2() {
        int n = this.getRowSize();
        int m = this.getColumnSize();
        double[] rd = new double[m];
        double[] coef = new double[m];
        double[] g2 = new double[m];
        double gmax = 0.0;
        double tmax = 0.0;
        double my_minute = 1.0E-75;
        int k = 0;
        while (k < m) {
            int i;
            double t;
            int j;
            gmax = 0.0;
            tmax = 0.0;
            if (k == 0) {
                j = k;
                while (j < m) {
                    t = 0.0;
                    i = k;
                    while (i < n) {
                        if (this.elm(i, j) != 0.0) {
                            t += this.elm(i, j) * this.elm(i, j);
                        }
                        ++i;
                    }
                    g2[j] = t;
                    ++j;
                }
                tmax = g2[0];
            } else {
                t = 0.0;
                i = k;
                while (i < n) {
                    if (this.elm(i, k) != 0.0) {
                        t += this.elm(i, k) * this.elm(i, k);
                    }
                    ++i;
                }
                gmax = g2[k] != 0.0 ? t / g2[k] : 0.0;
                tmax = t;
            }
            if (k == 0 && tmax < my_minute || k > 0 && gmax < JgclMachineEpsilon.DOUBLE) {
                int rank = k;
                double cond = 1.0 / Math.sqrt(JgclMachineEpsilon.DOUBLE);
                return new QRDecomposition(rd, coef, null, rank, cond);
            }
            double s = Math.sqrt(tmax);
            if (this.elm(k, k) < 0.0) {
                s = -s;
            }
            this.setElementAt(k, k, this.elm(k, k) + s);
            coef[k] = 1.0 / (this.elm(k, k) * s);
            rd[k] = -1.0 / s;
            j = k + 1;
            while (j < m) {
                double t2 = 0.0;
                int l = k;
                while (l < n) {
                    if (this.elm(l, k) == 0.0) break;
                    if (this.elm(l, j) != 0.0) {
                        t2 += this.elm(l, k) * this.elm(l, j);
                    }
                    ++l;
                }
                this.setElementAt(k, j, this.elm(k, j) - (t2 *= coef[k]) * this.elm(k, k));
                i = k + 1;
                while (i < n) {
                    if (this.elm(i, k) == 0.0) break;
                    this.setElementAt(i, j, this.elm(i, j) - t2 * this.elm(i, k));
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        int rank = m;
        double cond = 1.0 / Math.sqrt(gmax);
        return new QRDecomposition(rd, coef, null, rank, cond);
    }

    private double[] solveQREquations2(QRDecomposition decomposition, double[] rightHandValues) {
        double[] rd = decomposition.getDiagonalElementOfR();
        double[] coef = decomposition.getCoefficent();
        int rank = decomposition.getApproximatedRankOfA();
        int n = this.getRowSize();
        int m = this.getColumnSize();
        double[] solution = new double[m];
        int k = 0;
        while (k < rank) {
            double t = 0.0;
            int l = k;
            while (l < n) {
                if (this.elm(l, k) != 0.0) {
                    t += this.elm(l, k) * rightHandValues[l];
                }
                ++l;
            }
            t *= coef[k];
            int i = k;
            while (i < n) {
                if (this.elm(i, k) != 0.0) {
                    int n2 = i;
                    rightHandValues[n2] = rightHandValues[n2] - t * this.elm(i, k);
                }
                ++i;
            }
            ++k;
        }
        int k2 = rank - 1;
        while (k2 >= 0) {
            double t = rightHandValues[k2];
            int j = k2 + 1;
            while (j < rank) {
                if (this.elm(k2, j) != 0.0) {
                    t -= this.elm(k2, j) * solution[j];
                }
                ++j;
            }
            solution[k2] = t * rd[k2];
            --k2;
        }
        if (rank != m) {
            int k3 = rank;
            while (k3 < m) {
                solution[k3] = 0.0;
                ++k3;
            }
        }
        return solution;
    }

    public LinearLeastSquareSolution solveLinearLeastSquare2(double[] rightHandValues) {
        JgclMatrix me;
        int n = this.getRowSize();
        int m = this.getColumnSize();
        if (n != rightHandValues.length) {
            throw new JgclInvalidArgumentValue();
        }
        int i = 0;
        while (i < n) {
            if (this.elm(i, 0) == 0.0) break;
            ++i;
        }
        while (i < n) {
            if (this.elm(i, 0) != 0.0) break;
            ++i;
        }
        if (i < n) {
            JgclMatrix copy = new JgclMatrix(n, m);
            double[] rhsv2 = new double[n];
            int j = 0;
            while (j < n) {
                if (i >= n) {
                    i = 0;
                }
                int k = 0;
                while (k < m) {
                    copy.setElementAt(j, k, this.elm(i, k));
                    ++k;
                }
                rhsv2[j] = rightHandValues[i];
                ++j;
                ++i;
            }
            me = copy;
            rightHandValues = rhsv2;
        } else {
            me = this.copy();
        }
        QRDecomposition decomposition = me.doHouseHolderQRDecomposition2();
        double[] solutions = me.solveQREquations2(decomposition, rightHandValues);
        return new LinearLeastSquareSolution(decomposition.getApproximatedRankOfA(), decomposition.getCondition(), solutions);
    }

    public static void main(String[] argv) {
        double[] m0 = new double[]{3.0, 4.0, 7.0};
        double[] m1 = new double[]{-2.0, 3.0, 19.0};
        double[] m2 = new double[]{5.0, -10.0, 6.0};
        double[][] mmm = new double[][]{m0, m1, m2};
        JgclMatrix matrix = new JgclMatrix(mmm);
        JgclMatrix add = matrix.add(matrix);
        JgclMatrix sub = matrix.subtract(matrix);
        JgclMatrix multi = matrix.multiply(matrix);
        System.out.println("\n[matrix + matrix]");
        int i = 0;
        while (i < 3) {
            System.out.println(String.valueOf(i) + "th row : (" + add.getElementAt(i, 0) + ", " + add.getElementAt(i, 1) + ", " + add.getElementAt(i, 2) + ")");
            ++i;
        }
        System.out.println("\n[matrix - matrix]");
        int i2 = 0;
        while (i2 < 3) {
            System.out.println(String.valueOf(i2) + "th row : (" + sub.getElementAt(i2, 0) + ", " + sub.getElementAt(i2, 1) + ", " + sub.getElementAt(i2, 2) + ")");
            ++i2;
        }
        System.out.println("\n[matrix * matrix]");
        int i3 = 0;
        while (i3 < 3) {
            System.out.println(String.valueOf(i3) + "th row : (" + multi.getElementAt(i3, 0) + ", " + multi.getElementAt(i3, 1) + ", " + multi.getElementAt(i3, 2) + ")");
            ++i3;
        }
        System.out.println();
        double[] rrr = new double[]{3.0, -4.0, 8.0};
        double[] result = matrix.solveSimultaneousLinearEquations(rrr);
        int i4 = 0;
        while (i4 < 3) {
            System.out.println("Equations solving result : " + result[i4] + ", value : " + (matrix.getElementAt(i4, 0) * result[0] + matrix.getElementAt(i4, 1) * result[1] + matrix.getElementAt(i4, 2) * result[2] - rrr[i4]));
            ++i4;
        }
        LinearLeastSquareSolution result1 = matrix.solveLinearLeastSquare(rrr);
        System.out.println("LinearLeastSquare result : {" + result1.solutionAt(0) + ", " + result1.solutionAt(1) + ", " + result1.solutionAt(2) + "}");
        LinearLeastSquareSolution result2 = matrix.solveLinearLeastSquare2(rrr);
        System.out.println("LinearLeastSquare2 result : {" + result2.solutionAt(0) + ", " + result2.solutionAt(1) + ", " + result2.solutionAt(2) + "}");
    }

    public class MatrixIsLUDecomposed
    extends JgclRuntimeException {
        public MatrixIsLUDecomposed() {
            JgclMatrix.this = JgclMatrix.this;
        }

        public MatrixIsLUDecomposed(String s) {
            super(s);
            JgclMatrix.this = JgclMatrix.this;
        }
    }

    public class MatrixIsNotSquare
    extends JgclRuntimeException {
        public MatrixIsNotSquare() {
            JgclMatrix.this = JgclMatrix.this;
        }

        public MatrixIsNotSquare(String s) {
            super(s);
            JgclMatrix.this = JgclMatrix.this;
        }
    }

    private class QRDecomposition {
        private double[] rd;
        private double[] coef;
        private int rank;
        private int[] ip;
        private double cond;

        QRDecomposition(double[] rd, double[] coef, int[] ip, int rank, double cond) {
            JgclMatrix.this = JgclMatrix.this;
            this.rd = rd;
            this.coef = coef;
            this.ip = ip;
            this.rank = rank;
            this.cond = cond;
        }

        private double[] getDiagonalElementOfR() {
            return this.rd;
        }

        private double[] getCoefficent() {
            return this.coef;
        }

        private int[] getIndexVector() {
            return this.ip;
        }

        private int getApproximatedRankOfA() {
            return this.rank;
        }

        private double getCondition() {
            return this.cond;
        }
    }

    public class LinearLeastSquareSolution {
        private int rank;
        private double condition;
        private double[] solutions;

        private LinearLeastSquareSolution(int rank, double condition, double[] solutions) {
            JgclMatrix.this = JgclMatrix.this;
            this.rank = rank;
            this.condition = condition;
            this.solutions = solutions;
        }

        public int rank() {
            return this.rank;
        }

        public double condition() {
            return this.condition;
        }

        public double solutionAt(int i) {
            return this.solutions[i];
        }

        public double[] solutions() {
            return (double[])this.solutions.clone();
        }
    }
}

