/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclCompositeCurve3D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclConicalSurface3D;
import jp.go.ipa.jgcl.JgclCurveCurvature3D;
import jp.go.ipa.jgcl.JgclCurveDerivative3D;
import jp.go.ipa.jgcl.JgclCylindricalSurface3D;
import jp.go.ipa.jgcl.JgclElementarySurface3D;
import jp.go.ipa.jgcl.JgclEllipse3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclHyperbola3D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclIntsCncBzs3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclParabola3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclSphericalSurface3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve3D;
import jp.go.ipa.jgcl.JgclVector3D;
import jp.go.ipa.jgcl.JgclZeroLength;

public class JgclLine3D
extends JgclParametricCurve3D {
    private final JgclPoint3D pnt;
    private final JgclVector3D dir;

    public JgclLine3D(JgclPoint3D pnt, JgclVector3D dir) {
        if (dir.norm() < this.getToleranceForDistance2()) {
            throw new JgclInvalidArgumentValue();
        }
        this.pnt = pnt;
        this.dir = dir;
    }

    public JgclLine3D(JgclPoint3D pnt1, JgclPoint3D pnt2) {
        if (pnt1.identical(pnt2)) {
            throw new JgclInvalidArgumentValue();
        }
        this.pnt = pnt1;
        this.dir = pnt2.subtract(pnt1);
    }

    public JgclPoint3D pnt() {
        return this.pnt;
    }

    public JgclVector3D dir() {
        return this.dir;
    }

    public double length(JgclParameterSection pint) {
        return this.dir.length() * Math.abs(pint.increase());
    }

    public JgclPoint3D coordinates(double param) {
        return this.pnt.add(this.dir.multiply(param));
    }

    public JgclVector3D tangentVector(double param) {
        return this.dir;
    }

    public JgclCurveCurvature3D curvature(double param) {
        return new JgclCurveCurvature3D(0.0, JgclVector3D.zeroVector);
    }

    public JgclCurveDerivative3D evaluation(double param) {
        return new JgclCurveDerivative3D(this.coordinates(param), this.dir, JgclVector3D.zeroVector, JgclVector3D.zeroVector);
    }

    public double torsion(double param) {
        return 0.0;
    }

    public JgclPointOnCurve3D[] singular() {
        return new JgclPointOnCurve3D[0];
    }

    public JgclPointOnCurve3D[] inflexion() {
        return new JgclPointOnCurve3D[0];
    }

    public JgclPointOnCurve3D[] projectFrom(JgclPoint3D point) {
        JgclPointOnCurve3D[] proj = new JgclPointOnCurve3D[]{this.project1From(point)};
        return proj;
    }

    public JgclPolyline3D toPolyline(JgclParameterSection pint, JgclToleranceForDistance tol) {
        JgclPoint3D[] points = new JgclPoint3D[]{new JgclPointOnCurve3D(this, pint.start(), false), new JgclPointOnCurve3D(this, pint.end(), false)};
        if (points[0].identical(points[1])) {
            throw new JgclZeroLength();
        }
        return new JgclPolyline3D(points);
    }

    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection pint) {
        JgclPoint3D[] controlPoints = new JgclPoint3D[]{this.coordinates(pint.start()), this.coordinates(pint.end())};
        double[] weights = new double[]{1.0, 1.0};
        return new JgclBsplineCurve3D(JgclBsplineKnot.quasiUniformKnotsOfLinearOneSegment, controlPoints, weights);
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    public JgclIntersectionPoint3D intersect1Line(JgclLine3D mate) throws JgclIndefiniteSolution {
        JgclVector3D p = mate.pnt().subtract(this.pnt());
        JgclVector3D pa = p.crossProduct(this.dir());
        JgclVector3D pb = p.crossProduct(mate.dir());
        double dTol = this.getToleranceForDistance();
        if (this.dir().parallelDirection(mate.dir())) {
            if (pa.length() / this.dir().length() < dTol || pb.length() / mate.dir().length() < dTol) {
                JgclPointOnCurve3D pnt1 = new JgclPointOnCurve3D(this, 0.0, false);
                JgclPointOnCurve3D pnt2 = mate.project1From(pnt1);
                JgclIntersectionPoint3D ip = new JgclIntersectionPoint3D(pnt1, pnt2, false);
                throw new JgclIndefiniteSolution(ip);
            }
            return null;
        }
        JgclVector3D o = this.dir().crossProduct(mate.dir());
        if (!o.parallelDirection(pa) || !o.parallelDirection(pb)) {
            return null;
        }
        double paramT = pb.length() / o.length();
        if (pb.dotProduct(o) < 0.0) {
            paramT = -paramT;
        }
        double paramM = pa.length() / o.length();
        if (pa.dotProduct(o) < 0.0) {
            paramM = -paramM;
        }
        return new JgclIntersectionPoint3D(this, paramT, mate, paramM, false);
    }

    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclIntersectionPoint3D ints = this.intersect1Line(mate);
        if (ints == null) {
            return new JgclIntersectionPoint3D[0];
        }
        if (doExchange) {
            ints = ints.exchange();
        }
        JgclIntersectionPoint3D[] sol = new JgclIntersectionPoint3D[]{ints};
        return sol;
    }

    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclEllipse3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return mate.intersect(this, !doExchange);
    }

    public JgclIntersectionPoint3D[] intersect(JgclPlane3D mate) throws JgclIndefiniteSolution {
        JgclIntersectionPoint3D intersectionPoint = mate.intersect1(this);
        JgclIntersectionPoint3D[] ints = new JgclIntersectionPoint3D[]{intersectionPoint.exchange()};
        return ints;
    }

    JgclIntersectionPoint3D[] intersect(JgclPlane3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclIntersectionPoint3D intersectionPoint = mate.intersect1(this);
        if (!doExchange) {
            intersectionPoint = intersectionPoint.exchange();
        }
        JgclIntersectionPoint3D[] ints = new JgclIntersectionPoint3D[]{intersectionPoint};
        return ints;
    }

    JgclIntersectionPoint3D[] intersect(JgclSphericalSurface3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCylindricalSurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclConicalSurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierSurface3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineSurface3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    public JgclPointOnCurve3D project1From(JgclPoint3D point) {
        JgclVector3D evpp = point.subtract(this.pnt);
        double edot = this.dir.dotProduct(evpp);
        double param = edot / this.dir.norm();
        return new JgclPointOnCurve3D(this, param, false);
    }

    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
        return new JgclLine3D(this.pnt().add(moveVec), this.dir());
    }

    JgclParameterDomain getParameterDomain() {
        return new JgclParameterDomain();
    }

    boolean getClosedFlag() {
        return false;
    }

    int type() {
        return 1;
    }

    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns, double rCos, double rSin) {
        JgclPoint3D rpnt = this.pnt().rotateZ(trns, rCos, rSin);
        JgclVector3D rdir = this.dir().rotateZ(trns, rCos, rSin);
        return new JgclLine3D(rpnt, rdir);
    }

    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
        JgclVector3D vector;
        JgclPoint3D point;
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol2 = condition.getToleranceForDistance2();
        double start = 0.0;
        double increase = 1.0;
        int itry = 0;
        int limit = 100;
        do {
            if (itry > limit) {
                throw new JgclFatal();
            }
            point = this.coordinates(start + increase * (double)itry);
            vector = point.subtract(line.project1From(point));
            ++itry;
        } while (point.isOn(line) || vector.norm() < dTol2);
        return point;
    }

    JgclLine2D toLocal2D(JgclCartesianTransformationOperator3D transform) {
        return new JgclLine2D(this.pnt().to2D(transform), this.dir().to2D(transform));
    }

    JgclPointOnCurve3D[] commonNormal(JgclLine3D mate) throws JgclIndefiniteSolution {
        JgclVector3D thisUnitVec = this.dir().unitized();
        JgclVector3D mateUnitVec = mate.dir().unitized();
        double aTol = this.getToleranceForAngle();
        if (Math.abs(thisUnitVec.dotProduct(mateUnitVec)) > Math.cos(aTol)) {
            throw new JgclIndefiniteSolution(this);
        }
        JgclVector3D crossVec = thisUnitVec.crossProduct(mateUnitVec);
        JgclVector3D aNormVec = thisUnitVec.crossProduct(crossVec);
        JgclAxis2Placement3D position = new JgclAxis2Placement3D(this.pnt(), aNormVec, aNormVec.verticalVector());
        JgclPlane3D planeA = new JgclPlane3D(position);
        JgclIntersectionPoint3D[] planeAlineB = planeA.intersect(mate);
        JgclVector3D bNormVec = mateUnitVec.crossProduct(crossVec);
        position = new JgclAxis2Placement3D(mate.pnt(), bNormVec, bNormVec.verticalVector());
        JgclPlane3D planeB = new JgclPlane3D(position);
        JgclIntersectionPoint3D[] planeBlineA = planeB.intersect(this);
        JgclPointOnCurve3D[] point = new JgclPointOnCurve3D[]{planeAlineB[0].pointOnCurve2(), planeBlineA[0].pointOnCurve2()};
        return point;
    }

    double angleWith(JgclLine3D mate) {
        JgclVector3D mateVec;
        JgclVector3D thisVec = this.dir().unitized();
        double cosAB = thisVec.dotProduct(mateVec = mate.dir().unitized());
        if (cosAB > 1.0) {
            cosAB = 1.0;
        }
        if (cosAB < -1.0) {
            cosAB = -1.0;
        }
        return Math.acos(cosAB);
    }

    double distanceFrom(JgclPoint3D point) {
        JgclVector3D subVec = point.toVector3D().subtract(this.pnt().toVector3D());
        JgclVector3D unitVec = this.dir().unitized();
        JgclVector3D crossVec = unitVec.crossProduct(subVec);
        return Math.sqrt(crossVec.norm());
    }

    double distanceFrom(JgclLine3D mate) throws JgclIndefiniteSolution {
        JgclVector3D thisVec = this.dir().unitized();
        JgclVector3D mateVec = mate.dir().unitized();
        JgclVector3D crossVec = thisVec.crossProduct(mateVec);
        double aTol = this.getToleranceForAngle();
        double aTol2 = aTol * aTol;
        double dTol = this.getToleranceForDistance();
        if (crossVec.norm() < aTol2) {
            double dist = mate.distanceFrom(this.pnt());
            if (Math.abs(dist) < dTol) {
                throw new JgclIndefiniteSolution(this);
            }
            return dist;
        }
        JgclVector3D normVec = this.dir().crossProduct(mate.dir());
        JgclVector3D axis = normVec.crossProduct(this.dir());
        JgclAxis2Placement3D position = new JgclAxis2Placement3D(this.pnt(), axis, this.dir());
        JgclPlane3D plane = new JgclPlane3D(position);
        JgclIntersectionPoint3D[] point = mate.intersect(plane);
        if (point.length != 1) {
            throw new JgclFatal();
        }
        return this.distanceFrom(point[0]);
    }

    boolean checkInterfere(JgclIntsCncBzs3D.BezierSurfaceInfo bi) {
        double dTol = this.getToleranceForDistance();
        if (!(bi.box.min().y() < dTol)) {
            return false;
        }
        if (!(bi.box.min().z() < dTol)) {
            return false;
        }
        if (!(bi.box.max().y() > -dTol)) {
            return false;
        }
        return bi.box.max().z() > -dTol;
    }

    JgclPoint3D nlFunc(double parameter) {
        double ework = Math.sqrt(this.dir().norm());
        JgclLine3D line = new JgclLine3D(JgclPoint3D.origin, new JgclLiteralVector3D(ework, 0.0, 0.0));
        double x = line.dir().x() * parameter;
        double y = 0.0;
        double z = 0.0;
        return new JgclCartesianPoint3D(x, y, z);
    }

    JgclVector3D dnlFunc(double parameter) {
        double ework = Math.sqrt(this.dir().norm());
        return new JgclLiteralVector3D(ework, 0.0, 0.0);
    }

    protected synchronized JgclParametricCurve3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint3D tPnt = this.pnt().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        JgclVector3D tDir = this.dir().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        return new JgclLine3D(tPnt, tDir);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tpnt");
        this.pnt.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tdir");
        this.dir.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

