/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclElementarySurface3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionCurve3D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterference3D;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterferenceList;

final class JgclIntsSrfBss3D {
    private static final boolean DEBUG = false;

    private static JgclPolyline2D l2Gc(JgclBsplineKnot.ValidSegmentInfo uValidSegments, int uIndex, JgclBsplineKnot.ValidSegmentInfo vValidSegments, int vIndex, JgclPolyline2D pol2d) {
        int npnts = pol2d.nPoints();
        JgclPoint2D[] pnts = new JgclPoint2D[npnts];
        int i = 0;
        while (i < npnts) {
            pnts[i] = new JgclCartesianPoint2D(uValidSegments.l2Gp(uIndex, pol2d.pointAt(i).x()), vValidSegments.l2Gp(vIndex, pol2d.pointAt(i).y()));
            ++i;
        }
        return new JgclPolyline2D(pnts, pol2d.closed());
    }

    private static JgclSurfaceSurfaceInterferenceList getInterference(JgclElementarySurface3D elmA, JgclBsplineSurface3D bssB) {
        int i;
        JgclSurfaceSurfaceInterferenceList interferenceList = new JgclSurfaceSurfaceInterferenceList(elmA, bssB);
        if (elmA.type() == 1) {
            JgclPlane3D plnA = (JgclPlane3D)elmA;
            int uUicp = bssB.uNControlPoints();
            int vUicp = bssB.vNControlPoints();
            int pside = plnA.pointIsWhichSide(bssB.controlPointAt(0, 0));
            if (pside != 0) {
                boolean sameSide = true;
                i = 0;
                block2: while (i < uUicp) {
                    int j = 0;
                    while (j < vUicp) {
                        if ((i != 0 || j != 0) && plnA.pointIsWhichSide(bssB.controlPointAt(i, j)) != pside) {
                            sameSide = false;
                            break block2;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (sameSide) {
                    return interferenceList;
                }
            }
        }
        JgclBsplineKnot.ValidSegmentInfo vldsBu = bssB.uValidSegments();
        JgclBsplineKnot.ValidSegmentInfo vldsBv = bssB.vValidSegments();
        JgclPureBezierSurface3D[][] bzssB = bssB.toPureBezierSurfaceArray();
        int iBu = 0;
        while (iBu < bzssB.length) {
            int iBv = 0;
            while (iBv < bzssB[iBu].length) {
                JgclSurfaceSurfaceInterference3D[] ints;
                try {
                    ints = elmA.intersect(bzssB[iBu][iBv]);
                }
                catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                    throw new JgclFatal();
                }
                i = 0;
                while (i < ints.length) {
                    if (ints[i].isIntersectionPoint()) {
                        JgclIntersectionPoint3D intp = ints[i].toIntersectionPoint();
                        interferenceList.addAsIntersectionPoint(intp.coordinates(), intp.pointOnSurface1().uParameter(), intp.pointOnSurface1().vParameter(), vldsBu.l2Gp(iBu, intp.pointOnSurface2().uParameter()), vldsBv.l2Gp(iBv, intp.pointOnSurface2().vParameter()));
                    } else {
                        JgclIntersectionCurve3D intc = ints[i].toIntersectionCurve();
                        interferenceList.addAsIntersectionCurve((JgclPolyline3D)intc.curve3d(), (JgclPolyline2D)intc.curve2d(), JgclIntsSrfBss3D.l2Gc(vldsBu, iBu, vldsBv, iBv, (JgclPolyline2D)intc.curve2d2()));
                    }
                    ++i;
                }
                ++iBv;
            }
            ++iBu;
        }
        interferenceList.connectIntersectionCurves();
        return interferenceList;
    }

    private static JgclSurfaceSurfaceInterferenceList getInterference(JgclPureBezierSurface3D bzsA, JgclBsplineSurface3D bssB) {
        JgclSurfaceSurfaceInterferenceList interferenceList = new JgclSurfaceSurfaceInterferenceList(bzsA, bssB);
        JgclBsplineKnot.ValidSegmentInfo vldsBu = bssB.uValidSegments();
        JgclBsplineKnot.ValidSegmentInfo vldsBv = bssB.vValidSegments();
        JgclPureBezierSurface3D[][] bzssB = bssB.toPureBezierSurfaceArray();
        int iBu = 0;
        while (iBu < bzssB.length) {
            int iBv = 0;
            while (iBv < bzssB[iBu].length) {
                JgclSurfaceSurfaceInterference3D[] ints = bzsA.intersect(bzssB[iBu][iBv]);
                int i = 0;
                while (i < ints.length) {
                    if (ints[i].isIntersectionPoint()) {
                        JgclIntersectionPoint3D intp = ints[i].toIntersectionPoint();
                        interferenceList.addAsIntersectionPoint(intp.coordinates(), intp.pointOnSurface1().uParameter(), intp.pointOnSurface1().vParameter(), vldsBu.l2Gp(iBu, intp.pointOnSurface2().uParameter()), vldsBv.l2Gp(iBv, intp.pointOnSurface2().vParameter()));
                    } else {
                        JgclIntersectionCurve3D intc = ints[i].toIntersectionCurve();
                        interferenceList.addAsIntersectionCurve((JgclPolyline3D)intc.curve3d(), (JgclPolyline2D)intc.curve2d(), JgclIntsSrfBss3D.l2Gc(vldsBu, iBu, vldsBv, iBv, (JgclPolyline2D)intc.curve2d2()));
                    }
                    ++i;
                }
                ++iBv;
            }
            ++iBu;
        }
        interferenceList.connectIntersectionCurves();
        return interferenceList;
    }

    private static JgclSurfaceSurfaceInterferenceList getInterference(JgclBsplineSurface3D bssA, JgclBsplineSurface3D bssB) {
        JgclSurfaceSurfaceInterferenceList interferenceList = new JgclSurfaceSurfaceInterferenceList(bssA, bssB);
        JgclBsplineKnot.ValidSegmentInfo vldsAu = bssA.uValidSegments();
        JgclBsplineKnot.ValidSegmentInfo vldsAv = bssA.vValidSegments();
        JgclPureBezierSurface3D[][] bzssA = bssA.toPureBezierSurfaceArray();
        JgclBsplineKnot.ValidSegmentInfo vldsBu = bssB.uValidSegments();
        JgclBsplineKnot.ValidSegmentInfo vldsBv = bssB.vValidSegments();
        JgclPureBezierSurface3D[][] bzssB = bssB.toPureBezierSurfaceArray();
        int iAu = 0;
        while (iAu < bzssA.length) {
            int iAv = 0;
            while (iAv < bzssA[iAu].length) {
                int iBu = 0;
                while (iBu < bzssB.length) {
                    int iBv = 0;
                    while (iBv < bzssB[iBu].length) {
                        JgclSurfaceSurfaceInterference3D[] ints = bzssA[iAu][iAv].intersect(bzssB[iBu][iBv]);
                        int i = 0;
                        while (i < ints.length) {
                            if (ints[i].isIntersectionPoint()) {
                                JgclIntersectionPoint3D intp = ints[i].toIntersectionPoint();
                                interferenceList.addAsIntersectionPoint(intp.coordinates(), vldsAu.l2Gp(iAu, intp.pointOnSurface1().uParameter()), vldsAv.l2Gp(iAv, intp.pointOnSurface1().vParameter()), vldsBu.l2Gp(iBu, intp.pointOnSurface2().uParameter()), vldsBv.l2Gp(iBv, intp.pointOnSurface2().vParameter()));
                            } else {
                                JgclIntersectionCurve3D intc = ints[i].toIntersectionCurve();
                                interferenceList.addAsIntersectionCurve((JgclPolyline3D)intc.curve3d(), JgclIntsSrfBss3D.l2Gc(vldsAu, iAu, vldsAv, iAv, (JgclPolyline2D)intc.curve2d()), JgclIntsSrfBss3D.l2Gc(vldsBu, iBu, vldsBv, iBv, (JgclPolyline2D)intc.curve2d2()));
                            }
                            ++i;
                        }
                        ++iBv;
                    }
                    ++iBu;
                }
                ++iAv;
            }
            ++iAu;
        }
        interferenceList.connectIntersectionCurves();
        return interferenceList;
    }

    static JgclSurfaceSurfaceInterference3D[] intersection(JgclElementarySurface3D elmA, JgclBsplineSurface3D bssB, boolean doExchange) {
        return JgclIntsSrfBss3D.getInterference(elmA, bssB).toJgclSurfaceSurfaceInterference3DArray(doExchange);
    }

    static JgclSurfaceSurfaceInterference3D[] intersection(JgclPureBezierSurface3D bzsA, JgclBsplineSurface3D bssB, boolean doExchange) {
        return JgclIntsSrfBss3D.getInterference(bzsA, bssB).toJgclSurfaceSurfaceInterference3DArray(doExchange);
    }

    static JgclSurfaceSurfaceInterference3D[] intersection(JgclBsplineSurface3D bssA, JgclBsplineSurface3D bssB, boolean doExchange) {
        return JgclIntsSrfBss3D.getInterference(bssA, bssB).toJgclSurfaceSurfaceInterference3DArray(doExchange);
    }

    JgclIntsSrfBss3D() {
    }
}

