/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Vector;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclComplex;
import jp.go.ipa.jgcl.JgclHyperbola2D;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclIntsCncCnc2D;
import jp.go.ipa.jgcl.JgclParabola2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclVector2D;

class JgclIntsParCnc2D
extends JgclIntsCncCnc2D {
    JgclIntsParCnc2D() {
    }

    double[] getCoefficent(JgclParabola2D par, JgclHyperbola2D hyp, JgclCartesianTransformationOperator2D trans) {
        double dTol = par.getToleranceForDistance();
        JgclVector2D Ac2Bc = hyp.position().location().subtract(par.position().location());
        JgclPoint2D eiBc = trans.toLocal(Ac2Bc).toPoint2D();
        double dAslp = Math.atan2(par.position().x().y(), par.position().x().x());
        double dBslp = Math.atan2(hyp.position().x().y(), hyp.position().x().x());
        double eslope = dBslp - dAslp;
        double erc = Math.cos(eslope);
        double ers = Math.sin(eslope);
        double[] eprep = new double[6];
        double[] ercoef = new double[5];
        double a = par.focalDist();
        double e = hyp.xRadius();
        double f = hyp.yRadius();
        double cx = eiBc.x();
        double cy = eiBc.y();
        eprep[0] = e * ers * (e * ers);
        eprep[1] = f * erc * (f * erc);
        eprep[2] = 2.0 * e * f * erc * ers;
        eprep[3] = 2.0 * e * (cy * ers - 2.0 * a * erc);
        eprep[4] = 2.0 * f * (cy * erc + 2.0 * a * ers);
        eprep[5] = cy * cy - 4.0 * a * cx;
        ercoef[4] = eprep[1] + eprep[0];
        ercoef[0] = eprep[5] + eprep[0];
        ercoef[1] = eprep[2] * eprep[3];
        ercoef[3] = 2.0 * (ercoef[4] * eprep[4] - ercoef[1]);
        ercoef[1] = 2.0 * (ercoef[0] * eprep[4] - ercoef[1]);
        ercoef[2] = 2.0 * ercoef[4] * ercoef[0] + eprep[4] * eprep[4] - eprep[2] * eprep[2] - eprep[3] * eprep[3];
        ercoef[4] = ercoef[4] * ercoef[4] - eprep[2] * eprep[2];
        ercoef[0] = ercoef[0] * ercoef[0] - eprep[3] * eprep[3];
        return ercoef;
    }

    private JgclIntersectionPoint2D[] getIntersection(JgclParabola2D par, JgclHyperbola2D hyp, JgclComplex[] root, JgclCartesianTransformationOperator2D trans, boolean doExchange) {
        double dTol = par.getToleranceForDistance();
        Vector<JgclIntersectionPoint2D> intervec = new Vector<JgclIntersectionPoint2D>();
        int i = 0;
        while (i < root.length) {
            JgclIntersectionPoint2D inter;
            JgclPointOnCurve2D bPnt;
            double coshB;
            double sinhB = root[i].real();
            double Bparam = Math.log(sinhB + (coshB = Math.sqrt(1.0 + sinhB * sinhB)));
            JgclPoint2D dDpnt = trans.toLocal(hyp.coordinates(Bparam));
            double Aparam = dDpnt.y() / (2.0 * par.focalDist());
            JgclPointOnCurve2D aPnt = new JgclPointOnCurve2D(par, Aparam, false);
            if (aPnt.identical(bPnt = new JgclPointOnCurve2D(hyp, Bparam, false)) && (inter = new JgclIntersectionPoint2D(aPnt, bPnt, false)) != null && this.checkUnique(inter, intervec)) {
                intervec.addElement(inter);
            }
            ++i;
        }
        JgclIntersectionPoint2D[] intersectPoints = this.vectorToArray(intervec, doExchange);
        return intersectPoints;
    }

    JgclIntersectionPoint2D[] intersection(JgclParabola2D par, JgclHyperbola2D hyp, boolean doExchange) {
        JgclCartesianTransformationOperator2D trans = new JgclCartesianTransformationOperator2D(par.position(), 1.0);
        double[] coefficent = this.getCoefficent(par, hyp, trans);
        JgclComplex[] root = this.getRoot(coefficent);
        if (root == null) {
            return new JgclIntersectionPoint2D[0];
        }
        return this.getIntersection(par, hyp, root, trans, doExchange);
    }

    double[] getCoefficent(JgclParabola2D parA, JgclParabola2D parB, JgclCartesianTransformationOperator2D trans) {
        double dTol = parA.getToleranceForDistance();
        JgclVector2D Ac2Bc = parB.position().location().subtract(parA.position().location());
        JgclPoint2D eiBc = trans.toLocal(Ac2Bc).toPoint2D();
        double dAslp = Math.atan2(parA.position().x().y(), parA.position().x().x());
        double dBslp = Math.atan2(parB.position().x().y(), parB.position().x().x());
        double eslope = dBslp - dAslp;
        double erc = Math.cos(eslope);
        double ers = Math.sin(eslope);
        double[] ercoef = new double[5];
        double a = parA.focalDist();
        double b = parB.focalDist();
        double vx = eiBc.x();
        double vy = eiBc.y();
        ercoef[4] = b * ers * (b * ers);
        ercoef[3] = 4.0 * b * b * ers * erc;
        ercoef[2] = 2.0 * b * (vy * ers + 2.0 * b * erc * erc - 2.0 * a * erc);
        ercoef[1] = 4.0 * b * (vy * erc + 2.0 * a * ers);
        ercoef[0] = vy * vy - 4.0 * a * vx;
        return ercoef;
    }

    private JgclIntersectionPoint2D[] getIntersection(JgclParabola2D parA, JgclParabola2D parB, JgclComplex[] root, JgclCartesianTransformationOperator2D trans, boolean doExchange) {
        double dTol = parA.getToleranceForDistance();
        Vector<JgclIntersectionPoint2D> intervec = new Vector<JgclIntersectionPoint2D>();
        int i = 0;
        while (i < root.length) {
            JgclIntersectionPoint2D inter;
            JgclPointOnCurve2D bPnt;
            double Bparam = root[i].real();
            JgclPoint2D dDpnt = trans.toLocal(parB.coordinates(Bparam));
            double Aparam = dDpnt.y() / (2.0 * parA.focalDist());
            JgclPointOnCurve2D aPnt = new JgclPointOnCurve2D(parA, Aparam, false);
            if (aPnt.identical(bPnt = new JgclPointOnCurve2D(parB, Bparam, false)) && (inter = new JgclIntersectionPoint2D(aPnt, bPnt, false)) != null && this.checkUnique(inter, intervec)) {
                intervec.addElement(inter);
            }
            ++i;
        }
        JgclIntersectionPoint2D[] intersectPoints = this.vectorToArray(intervec, doExchange);
        return intersectPoints;
    }

    JgclIntersectionPoint2D[] intersection(JgclParabola2D parA, JgclParabola2D parB, boolean doExchange) {
        JgclCartesianTransformationOperator2D trans = new JgclCartesianTransformationOperator2D(parA.position(), 1.0);
        double[] coefficent = this.getCoefficent(parA, parB, trans);
        JgclComplex[] root = this.getRoot(coefficent);
        if (root == null) {
            return new JgclIntersectionPoint2D[0];
        }
        return this.getIntersection(parA, parB, root, trans, doExchange);
    }
}

