/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclConicalSurface3D;
import jp.go.ipa.jgcl.JgclCylindricalSurface3D;
import jp.go.ipa.jgcl.JgclEllipse3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclGeometry;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterference3D;
import jp.go.ipa.jgcl.JgclUtil;
import jp.go.ipa.jgcl.JgclVector3D;

class JgclIntsCylCon3D {
    private static final int SPECIAL_CASE_1 = 0;
    private static final int SPECIAL_CASE_2 = 1;
    private static final int SPECIAL_CASE_3 = 2;
    private static final int CONE_VERTEX_ON_CYLINDER = 3;
    private static final int CONE_ENTIRE_OUTSIDE_CYLINDER = 30;
    private static final int CONE_RULE_ON_CYLINDER = 31;
    private static final int THETA_EQUAL_SEMI_ANGLE = 32;
    private static final int THETA_NOT_EQUAL_SEMI_ANGLE = 33;
    private static final int CONE_ANGLE_INSIDE_CYLINDER = 34;
    private static final int CONE_VERTEX_IN_CYLINDER = 4;
    private static final int BOTH_AXIS_IS_EQUAL_SEMI_ANGLE = 40;
    private static final int BOTH_AXIS_IS_NOT_EQUAL_SEMI_ANGLE = 41;
    private static final int CONE_VERTEX_OUT_CYLINDER = 5;
    private static final int RULING_IS_PARALLEL_TO_AXIS = 50;
    private static final int ANGLE_IS_SMALLER_CONS_SEMI_ANGLE = 51;
    private static final int ANGLE_IS_GREATER_CONS_SEMI_ANGLE = 52;
    private JgclCylindricalSurface3D cyl;
    private JgclPoint3D cylOrg;
    private JgclLine3D cylAxis;
    private JgclConicalSurface3D con;
    private JgclPoint3D conOrg;
    private JgclLine3D conAxis;
    private static final int nst = 41;
    private boolean doExchange;
    private double dTol;
    private double aTol;
    private double dist;
    private double theta;
    private double beta;
    private JgclVector3D con2cyl;
    private JgclPoint3D specialCase3Point;
    private double conCos;
    private double conTan;
    private JgclVector3D[] cylAxes;
    private JgclVector3D[] conAxes;

    private JgclIntsCylCon3D(JgclCylindricalSurface3D cyl, JgclConicalSurface3D con, boolean doExchange) {
        this.cyl = cyl;
        this.con = con;
        this.doExchange = doExchange;
        this.cylOrg = cyl.position().location();
        this.cylAxis = cyl.getAxis();
        this.cylAxes = cyl.position().axes();
        this.conCos = Math.cos(con.semiAngle());
        this.conTan = Math.tan(con.semiAngle());
        this.conOrg = con.position().location();
        this.conAxis = con.getAxis();
        this.conAxes = con.position().axes();
        this.conOrg = this.conOrg.subtract(this.conAxes[2].multiply(con.radius() / this.conTan));
        this.dTol = cyl.getToleranceForDistance();
        this.aTol = cyl.getToleranceForAngle();
        JgclPointOnCurve3D[] projectedPoint = this.cylAxis.projectFrom(this.conOrg);
        this.dist = this.conOrg.distance(projectedPoint[0]);
        this.con2cyl = projectedPoint[0].subtract(this.conOrg);
        double ework = this.cylAxes[2].dotProduct(this.conAxes[2]);
        if (ework > 1.0) {
            ework = 1.0;
        }
        if (ework < -1.0) {
            ework = -1.0;
        }
        this.theta = Math.acos(ework);
        if (this.dist > this.dTol) {
            ework = this.con2cyl.dotProduct(this.conAxes[2]) / this.dist;
            if (ework > 1.0) {
                ework = 1.0;
            }
            if (ework < -1.0) {
                ework = -1.0;
            }
            this.beta = Math.acos(ework);
        }
    }

    private boolean isSpecialCase1() {
        return (this.theta < this.dTol || this.theta > Math.PI - this.dTol) && this.dist < this.dTol;
    }

    private boolean isSpecialCase2() {
        double semiAngle = this.con.semiAngle();
        return (Math.abs(this.theta - semiAngle) < this.aTol || Math.abs(this.theta - (Math.PI - semiAngle)) < this.aTol) && (Math.abs(this.beta - (1.5707963267948966 - semiAngle)) < this.aTol || Math.abs(this.beta - (1.5707963267948966 + semiAngle)) < this.aTol) && Math.abs(this.dist - this.cyl.radius()) < this.dTol;
    }

    private boolean isSpecialCase3() {
        JgclIntersectionPoint3D[] intp;
        JgclSurfaceSurfaceInterference3D[] intf;
        JgclAxis2Placement3D position = new JgclAxis2Placement3D(this.conOrg, this.cylAxes[2], this.cylAxes[0]);
        JgclPlane3D plane = new JgclPlane3D(position);
        try {
            intf = plane.intersect(this.con);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
        if (intf.length != 2) {
            return false;
        }
        int i = 0;
        while (i < 2) {
            try {
                double ework = ((JgclLine3D)intf[i].toIntersectionCurve().curve3d()).distanceFrom(this.cylAxis);
                if (Math.abs(ework - this.cyl.radius()) > this.dTol) {
                    return false;
                }
            }
            catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                return false;
            }
            ++i;
        }
        try {
            intp = ((JgclLine3D)((Object)intf[0])).intersect(this.cyl);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
        if (intp.length != 1) {
            throw new JgclFatal();
        }
        this.specialCase3Point = intp[0];
        return true;
    }

    private boolean isConesVertexOnCylinder() {
        return Math.abs(this.dist - this.cyl.radius()) < this.dTol;
    }

    private boolean isConesVertexInCylinder() {
        return this.dist < this.cyl.radius();
    }

    private JgclGeometry[] oneCircle() {
        double radius = this.cyl.radius();
        double d = radius / this.conTan;
        JgclVector3D axis = this.conAxes[2];
        JgclPoint3D org = this.conOrg.add(axis.multiply(d));
        JgclAxis2Placement3D position = new JgclAxis2Placement3D(org, axis, this.cylAxes[0]);
        JgclCircle3D circle = new JgclCircle3D(position, radius);
        JgclGeometry[] sol = new JgclGeometry[]{circle};
        return sol;
    }

    private JgclGeometry[] oneEllipseOneLine() {
        JgclGeometry[] ellipse = null;
        if (Math.abs(this.beta - (1.5707963267948966 - this.con.semiAngle())) < this.aTol && (ellipse = this.oneEllipse()).length != 1) {
            throw new JgclFatal();
        }
        JgclLine3D line = new JgclLine3D(this.conOrg, this.cyl.position().z());
        JgclGeometry[] sol = ellipse != null ? new JgclGeometry[]{line, ellipse[0]} : new JgclGeometry[]{line};
        return sol;
    }

    private JgclGeometry[] oneEllipse() {
        JgclSurfaceSurfaceInterference3D[] intf;
        JgclVector3D conW = this.conAxes[2];
        JgclVector3D conV = this.cylAxes[2].crossProduct(conW);
        JgclVector3D conU = conV.crossProduct(conW);
        conU = conU.unitized();
        conV = conV.unitized();
        JgclPoint3D[] planePoint = new JgclPoint3D[3];
        int i = 0;
        int j = 0;
        while (i < 4) {
            double t = 1.5707963267948966 * (double)i;
            JgclVector3D dir = this.cnPointFromT(conU, conV, conW, t);
            JgclLine3D conRuling = new JgclLine3D(this.conOrg, dir);
            JgclVector3D evec = dir.unitized();
            if (!(Math.abs(evec.dotProduct(this.cylAxes[2])) > Math.cos(this.aTol))) {
                JgclIntersectionPoint3D[] intp;
                try {
                    intp = conRuling.intersect(this.cyl);
                }
                catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                    throw new JgclFatal();
                }
                double ework = this.conOrg.distance(intp[0]);
                planePoint[j] = ework > this.dTol ? intp[0] : intp[1];
            }
            ++i;
            ++j;
        }
        JgclPoint3D planeOrg = planePoint[1];
        JgclVector3D planeRef1 = planePoint[0].subtract(planePoint[1]);
        JgclVector3D planeRef2 = planePoint[1].subtract(planePoint[1]);
        JgclVector3D planeAxis = planeRef1.crossProduct(planeRef2);
        JgclAxis2Placement3D position = new JgclAxis2Placement3D(planeOrg, planeAxis, planeRef1);
        JgclPlane3D plane = new JgclPlane3D(position);
        try {
            intf = plane.intersect(this.cyl);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
        if (intf.length != 0 || !intf[0].isIntersectionCurve()) {
            throw new JgclFatal();
        }
        JgclParametricCurve3D curve = intf[0].toIntersectionCurve().curve3d();
        JgclGeometry[] sol = new JgclGeometry[]{curve};
        return sol;
    }

    private JgclGeometry[] twoEllipse() {
        JgclVector3D conW = this.conAxes[2];
        JgclVector3D conV = this.cylAxes[2].crossProduct(conW);
        JgclVector3D conU = conV.crossProduct(conW);
        conU = conU.unitized();
        conV = conV.unitized();
        JgclPoint3D[][] xRadiusPoint = new JgclPoint3D[2][2];
        int i = 0;
        while (i < 2) {
            JgclIntersectionPoint3D[] intp;
            double t = Math.PI * (double)i;
            JgclVector3D dir = this.cnPointFromT(conU, conV, conW, t);
            JgclLine3D conRuling = new JgclLine3D(this.conOrg, dir);
            try {
                intp = conRuling.intersect(this.cyl);
            }
            catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                throw new JgclFatal();
            }
            double dist0 = this.conOrg.distance(intp[0]);
            double dist1 = this.conOrg.distance(intp[1]);
            if (dist0 < dist1) {
                if (i == 0) {
                    xRadiusPoint[0][0] = intp[0];
                    xRadiusPoint[1][0] = intp[1];
                } else {
                    xRadiusPoint[0][1] = intp[1];
                    xRadiusPoint[1][1] = intp[0];
                }
            } else if (i == 0) {
                xRadiusPoint[0][0] = intp[1];
                xRadiusPoint[1][0] = intp[0];
            } else {
                xRadiusPoint[0][1] = intp[0];
                xRadiusPoint[1][1] = intp[1];
            }
            ++i;
        }
        JgclGeometry[] sol = new JgclGeometry[2];
        int i2 = 0;
        while (i2 < 2) {
            JgclSurfaceSurfaceInterference3D[] intf;
            JgclPoint3D planeOrg = this.specialCase3Point;
            JgclVector3D planeRef1 = xRadiusPoint[i2][0].subtract(this.specialCase3Point);
            JgclVector3D planeRef2 = xRadiusPoint[i2][1].subtract(this.specialCase3Point);
            JgclVector3D planeAxis = planeRef1.crossProduct(planeRef2);
            JgclAxis2Placement3D position = new JgclAxis2Placement3D(planeOrg, planeAxis, planeRef1);
            JgclPlane3D plane = new JgclPlane3D(position);
            try {
                intf = plane.intersect(this.cyl);
            }
            catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                throw new JgclFatal();
            }
            if (intf.length != 1 || intf[0].isIntersectionCurve()) {
                throw new JgclFatal();
            }
            JgclParametricCurve3D curve = intf[0].toIntersectionCurve().curve3d();
            sol[i2] = curve;
            ++i2;
        }
        return sol;
    }

    private int getRelationInConeVertexOnCylinder() {
        double HARF_PI = 1.5707963267948966;
        double semiAngle = this.con.semiAngle();
        if (Math.abs(this.beta - (HARF_PI + semiAngle)) < this.aTol || this.beta > HARF_PI + semiAngle) {
            return 30;
        }
        if (Math.abs(this.beta - (HARF_PI - semiAngle)) < this.aTol) {
            return 31;
        }
        if (this.beta > HARF_PI - semiAngle && this.beta < HARF_PI + semiAngle) {
            if (Math.abs(this.theta - semiAngle) < this.aTol || Math.abs(this.theta - (Math.PI - semiAngle)) < this.aTol) {
                return 32;
            }
            return 33;
        }
        return 34;
    }

    private JgclGeometry[] coneVertexOnCylinder() {
        switch (this.getRelationInConeVertexOnCylinder()) {
            case 30: {
                return this.onePoint();
            }
            case 31: {
                return this.oneCurve();
            }
            case 32: {
                return this.oneLineOneCurve();
            }
            case 33: {
                return this.oneLeafOfEightFigureCurve();
            }
            case 34: {
                return this.oneCurveOnePoint();
            }
        }
        throw new JgclFatal();
    }

    private JgclGeometry[] onePoint() {
        JgclGeometry[] sol = new JgclGeometry[]{this.conOrg};
        return sol;
    }

    private JgclGeometry[] oneCurve() {
        JgclVector3D conW = this.conAxes[2];
        JgclVector3D conV = this.con2cyl.crossProduct(conW);
        JgclVector3D conU = conV.crossProduct(conW);
        conU = conU.unitized();
        conV = conV.unitized();
        JgclPoint3D[] point = new JgclPoint3D[41];
        double step = 0.15707963267948966;
        int i = 0;
        while (i < 41) {
            double t = -Math.PI + (double)i * step;
            JgclVector3D evec = this.cnPointFromT(conU, conV, conW, t);
            double s = -this.coefBCon(evec, this.cylAxes[2]) / this.coefACon(evec, this.cylAxes[2]);
            point[i] = this.conOrg.add(evec.multiply(s));
            ++i;
        }
        JgclGeometry[] sol = new JgclGeometry[]{new JgclPolyline3D(point)};
        return sol;
    }

    private JgclGeometry[] oneLineOneCurve() {
        double t3;
        double t2;
        double t1;
        double step2;
        double step1;
        double t0;
        double[] bzero;
        JgclVector3D conW = this.conAxes[2];
        JgclVector3D conV = this.con2cyl.crossProduct(conW);
        JgclVector3D conU = conV.crossProduct(conW);
        JgclVector3D evec = this.cnPointFromT(conU = conU.unitized(), conV = conV.unitized(), conW, (bzero = this.bZero(this.cylAxes[2], conU, conW))[0]);
        if (Math.abs(this.coefACon(evec, this.cylAxes[2])) < this.dTol) {
            t0 = bzero[0];
            if (bzero[0] < bzero[1]) {
                step1 = (bzero[1] - bzero[0]) / 40.0;
                step2 = (Math.PI * 2 + bzero[0] - bzero[1]) / 40.0;
                t1 = t0 + step1 / 2.0;
                t2 = bzero[1];
                t3 = t0 + Math.PI * 2 - step2 / 2.0;
            } else {
                step1 = (bzero[0] - bzero[1]) / 40.0;
                step2 = (Math.PI * 2 + bzero[1] - bzero[0]) / 40.0;
                t1 = t0 + step1 / 2.0;
                t2 = bzero[1] + Math.PI * 2;
                t3 = t0 + Math.PI * 2 - step2 / 2.0;
            }
        } else {
            t0 = bzero[1];
            if (bzero[1] < bzero[0]) {
                step1 = (bzero[0] - bzero[1]) / 40.0;
                step2 = (Math.PI * 2 + bzero[1] - bzero[0]) / 40.0;
                t1 = t0 + step1 / 2.0;
                t2 = bzero[0];
                t3 = t0 + Math.PI * 2 - step2 / 2.0;
            } else {
                step1 = (bzero[1] - bzero[0]) / 40.0;
                step2 = (Math.PI * 2 + bzero[0] - bzero[1]) / 40.0;
                t1 = t0 + step1 / 2.0;
                t2 = bzero[0] + Math.PI * 2;
                t3 = t0 + Math.PI * 2 - step2 / 2.0;
            }
        }
        double t = (t1 + t2) / 2.0;
        evec = this.cnPointFromT(conU, conV, conW, t);
        double a = this.coefACon(evec, this.cylAxes[2]);
        double b = this.coefBCon(evec, this.cylAxes[2]);
        if (b / a > 0.0) {
            t1 = t2;
            t2 = t3;
        }
        double step = (t2 - t1) / 40.0;
        JgclPoint3D[] points = new JgclPoint3D[41];
        int i = 0;
        while (i < 41) {
            t = t1 + (double)i * step;
            evec = this.cnPointFromT(conU, conV, conW, t);
            a = this.coefACon(evec, this.cylAxes[2]);
            b = this.coefBCon(evec, this.cylAxes[2]);
            points[i] = this.conOrg.add(evec.multiply(-b / a));
            ++i;
        }
        JgclPolyline3D polyline = new JgclPolyline3D(points);
        evec = this.cnPointFromT(conU, conV, conW, t0);
        JgclLine3D line = new JgclLine3D(this.conOrg, evec);
        JgclGeometry[] sol = new JgclGeometry[]{polyline, line};
        return sol;
    }

    private JgclGeometry[] oneLeafOfEightFigureCurve() {
        double t2;
        double t1;
        JgclVector3D conW = this.conAxes[2];
        JgclVector3D conV = this.con2cyl.crossProduct(conW);
        JgclVector3D conU = conV.crossProduct(conW);
        conU = conU.unitized();
        conV = conV.unitized();
        double[] bzero = this.bZero(this.cylAxes[2], conU, conW);
        if (bzero[0] < bzero[1]) {
            t1 = bzero[0];
            t2 = bzero[1];
        } else {
            t2 = bzero[0];
            t1 = bzero[1];
        }
        double t = (t1 + t2) / 2.0;
        JgclVector3D evec = this.cnPointFromT(conU, conV, conW, t);
        double a = this.coefACon(evec, this.cylAxes[2]);
        double b = this.coefBCon(evec, this.cylAxes[2]);
        if (b / a > 0.0) {
            t1 = t2;
            t2 = t1 + Math.PI * 2;
        }
        double step = (t2 - t1) / 40.0;
        JgclPoint3D[] point = new JgclPoint3D[41];
        int i = 0;
        while (i < 41) {
            t = t1 + (double)i * step;
            evec = this.cnPointFromT(conU, conV, conW, t);
            a = this.coefACon(evec, this.cylAxes[2]);
            b = this.coefBCon(evec, this.cylAxes[2]);
            point[i] = this.conOrg.add(evec.multiply(-b / a));
            ++i;
        }
        JgclGeometry[] sol = new JgclGeometry[]{new JgclPolyline3D(point)};
        return sol;
    }

    private JgclGeometry[] oneCurveOnePoint() {
        JgclVector3D conW = this.conAxes[2];
        JgclVector3D conV = this.beta < this.aTol ? conW.crossProduct(this.cylAxes[2]) : this.con2cyl.crossProduct(conW);
        JgclVector3D conU = conV.crossProduct(conW);
        conU = conU.unitized();
        conV = conV.unitized();
        double step = 0.15707963267948966;
        JgclPoint3D[] points = new JgclPoint3D[41];
        int i = 0;
        while (i < 41) {
            double t = -Math.PI + (double)i * step;
            JgclVector3D evec = this.cnPointFromT(conU, conV, conW, t);
            double s = -this.coefBCon(evec, this.cylAxes[2]) / this.coefACon(evec, this.cylAxes[2]);
            points[i] = this.conOrg.add(evec.multiply(s));
            ++i;
        }
        JgclGeometry[] sol = new JgclGeometry[]{new JgclPolyline3D(points), this.conOrg};
        return sol;
    }

    private int getRelationInConeVertexInCylinder() {
        double semiAngle = this.con.semiAngle();
        if (Math.abs(this.theta - semiAngle) < this.aTol || Math.abs(this.theta - (Math.PI - semiAngle)) < this.aTol) {
            return 40;
        }
        return 41;
    }

    private JgclGeometry[] coneVertexInCylinder() {
        switch (this.getRelationInConeVertexInCylinder()) {
            case 40: {
                return this.thetaAndSemiAngleIsSame();
            }
            case 41: {
                return this.thetaAndSemiAngleIsNotSame();
            }
        }
        throw new JgclFatal();
    }

    private JgclGeometry[] thetaAndSemiAngleIsSame() {
        JgclVector3D evec;
        JgclSurfaceSurfaceInterference3D[] intf;
        JgclVector3D cylW = this.cylAxes[2];
        JgclVector3D cylV = cylW.crossProduct(this.con2cyl);
        JgclVector3D cylU = cylV.crossProduct(cylW);
        cylU = cylU.unitized();
        cylV = cylV.unitized();
        JgclVector3D conW = this.conAxes[2];
        JgclVector3D conV = conW.crossProduct(this.con2cyl).reverse();
        JgclVector3D conU = conV.crossProduct(conW);
        conU = conU.unitized();
        conV = conV.unitized();
        JgclVector3D norm = conW.project(cylW);
        JgclAxis2Placement3D position = new JgclAxis2Placement3D(this.conOrg, norm, cylW);
        JgclPlane3D plane = new JgclPlane3D(position);
        try {
            intf = plane.intersect(this.cyl);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
        double[] t = new double[2];
        int i = 0;
        while (i < intf.length) {
            if (!intf[i].isIntersectionCurve()) {
                throw new JgclFatal();
            }
            JgclParametricCurve3D curve = intf[i].toIntersectionCurve().curve3d();
            JgclLine3D line = (JgclLine3D)curve;
            evec = line.pnt().subtract(this.cylOrg);
            evec = evec.project(cylW);
            t[i] = cylU.angleWith(evec, cylW);
            ++i;
        }
        if (t[0] > t[1]) {
            double ework = t[0];
            t[0] = t[1];
            t[1] = ework;
        }
        double t0 = (t[0] + t[1]) / 2.0;
        JgclPoint3D epnt = this.clPointFromT(this.cylOrg, cylU, cylV, this.cyl.radius(), t0);
        double b = this.coefBCyl(epnt, conW, cylW);
        double c = this.coefCCyl(epnt, conW);
        double s = -c / b;
        JgclPoint3D epnt2 = epnt.add(cylW.multiply(s));
        evec = epnt2.subtract(this.conOrg);
        if (evec.dotProduct(conW) < 0.0) {
            double ework = t[0];
            t[0] = t[1];
            t[1] = ework + Math.PI * 2;
        }
        double step = (t[1] - t[0]) / 40.0;
        t[0] = t[0] + step / 2.0;
        t[1] = t[1] - step / 2.0;
        step = (t[1] - t[0]) / 40.0;
        JgclPoint3D[] points = new JgclPoint3D[41];
        int i2 = 0;
        while (i2 < 41) {
            t0 = t[0] + (double)i2 * step;
            epnt = this.clPointFromT(this.cylOrg, cylU, cylV, this.cyl.radius(), t0);
            s = -this.coefCCyl(epnt, conW) / this.coefBCyl(epnt, conW, cylW);
            points[i2] = epnt.add(cylW.multiply(s));
            ++i2;
        }
        JgclPolyline3D polyline = new JgclPolyline3D(points);
        JgclGeometry[] sol = new JgclGeometry[]{polyline};
        return sol;
    }

    private JgclGeometry[] thetaAndSemiAngleIsNotSame() {
        JgclVector3D conW = this.conAxes[2];
        JgclVector3D conV = this.dist < this.dTol ? this.cylAxes[2].crossProduct(conW) : this.con2cyl.crossProduct(conW);
        JgclVector3D conU = conV.crossProduct(conW);
        conU = conU.unitized();
        conV = conV.unitized();
        double step = 0.15707963267948966;
        double[] dA = new double[3];
        dA[0] = this.coefCCon(this.cylAxes[2], this.cyl.radius());
        JgclPoint3D[] points = new JgclPoint3D[41];
        int i = 0;
        while (i < 41) {
            double dX0;
            double dX1;
            double t = -Math.PI + (double)i * step;
            JgclVector3D evec = this.cnPointFromT(conU, conV, conW, t);
            dA[2] = this.coefACon(evec, this.cylAxes[2]);
            dA[1] = this.coefBCon(evec, this.cylAxes[2]);
            double[] dX = new JgclRealPolynomial(dA).getAlwaysRootsIfQuadric();
            if (dX == null) {
                throw new JgclFatal();
            }
            if (dX.length == 1) {
                dX0 = dX1 = dX[0];
            } else if (dX[0] < dX[1]) {
                dX0 = dX[1];
                dX1 = dX[0];
            } else {
                dX0 = dX[0];
                dX1 = dX[1];
            }
            points[i] = this.conOrg.add(evec.multiply(dX0));
            ++i;
        }
        JgclPolyline3D polyline = new JgclPolyline3D(points);
        JgclGeometry[] sol = new JgclGeometry[]{polyline};
        return sol;
    }

    private int getRelationInConeVertexOutCylinder() {
        double semiAngle = this.con.semiAngle();
        if (Math.abs(this.theta - semiAngle) < this.aTol || Math.abs(this.theta - (Math.PI - semiAngle)) < this.aTol) {
            return 50;
        }
        if (this.theta < semiAngle || this.theta > Math.PI - semiAngle) {
            return 51;
        }
        return 52;
    }

    private JgclGeometry[] coneVertexOutCylinder() {
        switch (this.getRelationInConeVertexOutCylinder()) {
            case 50: {
                return this.rulingIsParallelToAxis();
            }
            case 51: {
                return this.angleIsSmallerConsSemiAngle();
            }
            case 52: {
                return this.angleIsGreaterConsSemiAngle();
            }
        }
        throw new JgclFatal();
    }

    private JgclGeometry[] rulingIsParallelToAxis() {
        if (this.con2cyl.dotProduct(this.conAxes[2]) < 0.0) {
            return new JgclGeometry[0];
        }
        JgclVector3D cylW = this.cylAxes[2];
        JgclVector3D cylV = cylW.crossProduct(this.con2cyl);
        JgclVector3D cylU = cylV.crossProduct(cylW);
        cylU = cylU.unitized();
        cylV = cylV.unitized();
        JgclVector3D conW = this.conAxes[2];
        double step = 0.15707963267948966;
        JgclPoint3D[] points = new JgclPoint3D[41];
        int i = 0;
        while (i < 41) {
            double t = -Math.PI + (double)i * step;
            JgclPoint3D epnt = this.clPointFromT(this.cylOrg, cylU, cylV, this.cyl.radius(), t);
            double s = -this.coefCCyl(epnt, conW) / this.coefBCyl(epnt, conW, cylW);
            points[i] = epnt.add(cylW.multiply(s));
            ++i;
        }
        JgclPolyline3D polyline = new JgclPolyline3D(points);
        JgclGeometry[] sol = new JgclGeometry[]{polyline};
        return sol;
    }

    private JgclGeometry[] angleIsSmallerConsSemiAngle() {
        double dX0;
        double dX1;
        JgclVector3D cylW = this.cylAxes[2];
        JgclVector3D cylV = cylW.crossProduct(this.con2cyl);
        JgclVector3D cylU = cylV.crossProduct(cylW);
        cylU = cylU.unitized();
        cylV = cylV.unitized();
        JgclVector3D conW = this.conAxes[2];
        double[] dA = new double[3];
        dA[2] = this.coefACyl(conW, cylW);
        JgclPoint3D epnt = this.clPointFromT(this.cylOrg, cylU, cylV, this.cyl.radius(), 0.0);
        dA[1] = this.coefBCyl(epnt, conW, cylW);
        dA[0] = this.coefCCyl(epnt, conW);
        double[] dX = new JgclRealPolynomial(dA).getAlwaysRootsIfQuadric();
        if (dX == null) {
            throw new JgclFatal();
        }
        if (dX.length == 1) {
            dX0 = dX1 = dX[0];
        } else if (dX.length == 2 && dX[0] < dX[1]) {
            dX0 = dX[1];
            dX1 = dX[0];
        } else {
            dX0 = dX[0];
            dX1 = dX[1];
        }
        JgclPoint3D epnt2 = epnt.add(cylW.multiply(dX0));
        JgclVector3D evec = epnt.subtract(this.conOrg);
        double step = 0.15707963267948966;
        JgclPoint3D[] points = new JgclPoint3D[41];
        int i = 0;
        while (i < 41) {
            double t = Math.PI + (double)i * step;
            epnt = this.clPointFromT(this.cylOrg, cylU, cylV, this.cyl.radius(), t);
            dA[1] = this.coefBCyl(epnt, conW, cylW);
            dA[0] = this.coefCCyl(epnt, conW);
            dX = new JgclRealPolynomial(dA).getAlwaysRootsIfQuadric();
            if (dX == null) {
                throw new JgclFatal();
            }
            if (dX.length == 1) {
                dX0 = dX1 = dX[0];
            } else if (dX.length == 2 && dX[0] < dX[1]) {
                dX0 = dX[1];
                dX1 = dX[0];
            } else {
                dX0 = dX[0];
                dX1 = dX[1];
            }
            double s = evec.dotProduct(conW) > 0.0 ? dX0 : dX1;
            points[i] = epnt.add(cylW.multiply(s));
            ++i;
        }
        JgclPolyline3D polyline = new JgclPolyline3D(points);
        JgclGeometry[] sol = new JgclGeometry[]{polyline};
        return sol;
    }

    private JgclGeometry[] angleIsGreaterConsSemiAngle() {
        double esin;
        double dX0;
        double dX1;
        int myNst = 20;
        JgclPoint3D[][] points = new JgclPoint3D[10][];
        if (this.con2cyl.dotProduct(this.conAxes[2]) < 0.0) {
            return new JgclGeometry[0];
        }
        JgclVector3D evec = this.con2cyl.unitized();
        JgclVector3D cylW = this.cylAxes[2];
        JgclVector3D conW = this.conAxes[2];
        JgclVector3D cylV = Math.abs(cylW.dotProduct(evec)) > Math.cos(this.aTol) ? cylW.crossProduct(conW) : cylW.crossProduct(this.con2cyl);
        JgclVector3D cylU = cylV.crossProduct(cylW);
        cylU = cylU.unitized();
        cylV = cylV.unitized();
        JgclVector3D conV = Math.abs(conW.dotProduct(evec)) > Math.cos(this.aTol) ? conW.crossProduct(cylW) : conW.crossProduct(this.con2cyl);
        conV = conV.reverse();
        JgclVector3D conU = conV.crossProduct(conW);
        conU = conU.unitized();
        conV = conV.unitized();
        double euw = conU.dotProduct(cylW);
        double evw = conV.dotProduct(cylW);
        double eww = conW.dotProduct(cylW);
        double[] dA = new double[3];
        dA[2] = euw * euw + evw * evw;
        dA[1] = 2.0 * this.conTan * eww * euw;
        dA[0] = this.conTan * this.conTan * eww * eww - evw * evw;
        double[] dX = new JgclRealPolynomial(dA).getAlwaysRootsIfQuadric();
        if (dX == null) {
            throw new JgclFatal();
        }
        int nnn = dX.length;
        if (nnn == 1) {
            dX0 = dX1 = dX[0];
        } else if (nnn == 2 && dX[0] < dX[1]) {
            dX0 = dX[1];
            dX1 = dX[0];
        } else {
            dX0 = dX[0];
            dX1 = dX[1];
        }
        double ecos = dX0;
        int nnnn = 0;
        JgclVector3D[] norm = new JgclVector3D[2];
        double reps = 1.0E-8;
        if (-1.0 - reps < ecos && ecos < 1.0 + reps) {
            if (ecos > 1.0) {
                ecos = 1.0;
            }
            if (ecos < -1.0) {
                ecos = -1.0;
            }
            if (Math.abs(this.conTan * eww + ecos * euw + (esin = Math.sqrt(1.0 - ecos * ecos)) * evw) > this.dTol) {
                esin = -esin;
            }
            norm[0] = conW.multiply(this.conTan);
            norm[0] = norm[0].add(conU.multiply(ecos));
            norm[0] = norm[0].add(conV.multiply(esin));
            ++nnnn;
        }
        if (nnn == 2 && -1.0 - reps < (ecos = dX1) && ecos < 1.0 + reps) {
            if (ecos > 1.0) {
                ecos = 1.0;
            }
            if (ecos < -1.0) {
                ecos = -1.0;
            }
            if (Math.abs(this.conTan * eww + ecos * euw + (esin = Math.sqrt(1.0 - ecos * ecos)) * evw) > this.dTol) {
                esin = -esin;
            }
            norm[nnnn] = conW.multiply(this.conTan);
            norm[nnnn] = norm[nnnn].add(conU.multiply(ecos));
            norm[nnnn] = norm[nnnn].add(conV.multiply(esin));
            ++nnnn;
        }
        nnn = nnnn;
        int n = 0;
        JgclLine3D savedLine = null;
        double[] t = new double[5];
        int num = 0;
        int i = 0;
        while (i < nnn) {
            JgclSurfaceSurfaceInterference3D[] intf;
            JgclAxis2Placement3D position = new JgclAxis2Placement3D(this.conOrg, norm[i], cylW);
            JgclPlane3D plane = new JgclPlane3D(position);
            try {
                intf = plane.intersect(this.cyl);
            }
            catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                throw new JgclFatal();
            }
            if (intf.length > 0) {
                JgclLine3D line = null;
                int j = 0;
                while (j < intf.length) {
                    line = (JgclLine3D)intf[j].toIntersectionCurve().curve3d();
                    if (num == 0) {
                        savedLine = new JgclLine3D(line.pnt(), line.dir());
                    }
                    evec = line.pnt().subtract(this.cylOrg);
                    evec = evec.project(cylW);
                    t[num++] = cylU.angleWith(evec, cylW);
                    ++j;
                }
            }
            ++i;
        }
        if (num != 0) {
            int j0 = 0;
            int jn = num - 1;
            JgclUtil.sortDoubleArray(t, j0, jn);
            t[num] = t[0] + Math.PI * 2;
        } else {
            num = 1;
            t[0] = -Math.PI;
            t[num] = Math.PI;
        }
        dA[2] = this.coefACyl(conW, cylW);
        JgclPolyline3D[] polyline = new JgclPolyline3D[10];
        int i2 = 0;
        while (i2 < num) {
            int nn;
            int j;
            double t0 = (t[i2] + t[i2 + 1]) / 2.0;
            JgclPoint3D epnt = this.clPointFromT(this.cylOrg, cylU, cylV, this.cyl.radius(), t0);
            dA[1] = this.coefBCyl(epnt, conW, cylW);
            dA[0] = this.coefCCyl(epnt, conW);
            double d = dA[1] * dA[1] - 4.0 * dA[2] * dA[0];
            if (d < 0.0) {
                if (num == 1 && savedLine != null) {
                    JgclPointOnCurve3D[] pt;
                    try {
                        pt = this.conAxis.commonNormal(savedLine);
                    }
                    catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                        throw new JgclFatal();
                    }
                    JgclPointOnCurve3D point = pt[1];
                    JgclGeometry[] sol = new JgclGeometry[]{point};
                    return sol;
                }
            } else if (num == 1) {
                points[n] = new JgclPoint3D[41];
                points[n + 1] = new JgclPoint3D[41];
                double step = (t[i2 + 1] - t[i2]) / 40.0;
                j = 0;
                while (j < 41) {
                    t0 = t[i2] + (double)j * step;
                    epnt = this.clPointFromT(this.cylOrg, cylU, cylV, this.cyl.radius(), t0);
                    dA[1] = this.coefBCyl(epnt, conW, cylW);
                    dA[0] = this.coefCCyl(epnt, conW);
                    dX = new JgclRealPolynomial(dA).getAlwaysRootsIfQuadric();
                    if (dX == null) {
                        throw new JgclFatal();
                    }
                    nn = dX.length;
                    if (nn == 1) {
                        dX0 = dX1 = dX[0];
                    } else if (nn == 2 && dX[0] < dX[1]) {
                        dX0 = dX[1];
                        dX1 = dX[0];
                    } else {
                        dX0 = dX[0];
                        dX1 = dX[1];
                    }
                    points[n][j] = epnt.add(cylW.multiply(dX0));
                    points[n + 1][j] = epnt.add(cylW.multiply(dX1));
                    ++j;
                }
                n += 2;
            } else {
                points[n] = new JgclPoint3D[41];
                double step = (t[i2 + 1] - t[i2]) / (double)myNst;
                j = 0;
                while (j < myNst) {
                    t0 = t[i2] + (double)j * step;
                    epnt = this.clPointFromT(this.cylOrg, cylU, cylV, this.cyl.radius(), t0);
                    dA[1] = this.coefBCyl(epnt, conW, cylW);
                    dA[0] = this.coefCCyl(epnt, conW);
                    dX = new JgclRealPolynomial(dA).getAlwaysRootsIfQuadric();
                    if (dX == null) {
                        throw new JgclFatal();
                    }
                    nn = dX.length;
                    if (nn == 1) {
                        dX0 = dX1 = dX[0];
                    } else if (nn == 2 && dX[0] < dX[1]) {
                        dX0 = dX[1];
                        dX1 = dX[0];
                    } else {
                        dX0 = dX[0];
                        dX1 = dX[1];
                    }
                    points[n][j] = epnt.add(cylW.multiply(dX0));
                    points[n][40 - j] = epnt.add(cylW.multiply(dX1));
                    ++j;
                }
                t0 = t[i2] + (double)j * step;
                epnt = this.clPointFromT(this.cylOrg, cylU, cylV, this.cyl.radius(), t0);
                dA[1] = this.coefBCyl(epnt, conW, cylW);
                dA[0] = this.coefCCyl(epnt, conW);
                dX = new JgclRealPolynomial(dA).getAlwaysRootsIfQuadric();
                if (dX == null) {
                    throw new JgclFatal();
                }
                nn = dX.length;
                if (nn == 1) {
                    dX0 = dX1 = dX[0];
                } else if (nn == 2 && dX[0] < dX[1]) {
                    dX0 = dX[1];
                    dX1 = dX[0];
                } else {
                    dX0 = dX[0];
                    dX1 = dX[1];
                }
                points[n][j] = epnt.add(cylW.multiply(dX0));
                ++n;
            }
            ++i2;
        }
        JgclGeometry[] sol = new JgclGeometry[n];
        int i3 = 0;
        while (i3 < n) {
            sol[i3] = new JgclPolyline3D(points[i3], false);
            ++i3;
        }
        return sol;
    }

    private JgclVector3D cnPointFromT(JgclVector3D conU, JgclVector3D conV, JgclVector3D conW, double t) {
        double cost = Math.cos(t);
        double sint = Math.sin(t);
        return new JgclLiteralVector3D(this.conTan * (cost * conU.x() + sint * conV.x()) + conW.x(), this.conTan * (cost * conU.y() + sint * conV.y()) + conW.y(), this.conTan * (cost * conU.z() + sint * conV.z()) + conW.z());
    }

    private double coefACon(JgclVector3D conVec, JgclVector3D cylW) {
        double edot = conVec.dotProduct(cylW);
        return this.conTan * this.conTan + 1.0 - edot * edot;
    }

    private double coefBCon(JgclVector3D conVec, JgclVector3D cylW) {
        JgclVector3D cyl2con = this.con2cyl.reverse();
        double edot = cyl2con.dotProduct(cylW);
        JgclVector3D evec = cyl2con.subtract(cylW.multiply(edot));
        return 2.0 * evec.dotProduct(conVec);
    }

    private double coefCCon(JgclVector3D cylW, double clr) {
        double edot = this.con2cyl.dotProduct(this.con2cyl);
        double edot2 = this.con2cyl.dotProduct(cylW);
        return edot - edot2 * edot2 - clr * clr;
    }

    private double[] bZero(JgclVector3D cylW, JgclVector3D conU, JgclVector3D conW) {
        JgclIntersectionPoint3D[] intp;
        JgclVector3D axis = conU.project(cylW);
        JgclAxis2Placement3D position = new JgclAxis2Placement3D(this.conOrg, axis, cylW);
        JgclPlane3D plane = new JgclPlane3D(position);
        JgclCircle3D circle = new JgclCircle3D(this.con.position(), this.con.radius());
        try {
            intp = circle.intersect(plane);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
        double[] bzero = new double[intp.length];
        int i = 0;
        while (i < intp.length) {
            JgclVector3D evec = intp[i].subtract(this.conOrg);
            evec = evec.project(conW);
            bzero[i] = conU.angleWith(evec, conW);
            ++i;
        }
        return bzero;
    }

    private JgclPoint3D clPointFromT(JgclPoint3D c, JgclVector3D u, JgclVector3D v, double r, double t) {
        double cost = Math.cos(t);
        double sint = Math.sin(t);
        return new JgclCartesianPoint3D(c.x() + r * (cost * u.x() + sint * v.x()), c.y() + r * (cost * u.y() + sint * v.y()), c.z() + r * (cost * u.z() + sint * v.z()));
    }

    private double coefACyl(JgclVector3D conW, JgclVector3D cylW) {
        double edot = conW.dotProduct(cylW);
        return edot * edot - this.conCos * this.conCos;
    }

    private double coefBCyl(JgclPoint3D pepnt, JgclVector3D conW, JgclVector3D cylW) {
        double edot = conW.dotProduct(cylW);
        double conCos2 = this.conCos * this.conCos;
        JgclLiteralVector3D evec2 = new JgclLiteralVector3D(edot * conW.x() - conCos2 * cylW.x(), edot * conW.y() - conCos2 * cylW.y(), edot * conW.z() - conCos2 * cylW.z());
        JgclVector3D evec3 = pepnt.subtract(this.conOrg);
        return 2.0 * evec3.dotProduct(evec2);
    }

    private double coefCCyl(JgclPoint3D pepnt, JgclVector3D conW) {
        JgclVector3D evec = pepnt.subtract(this.conOrg);
        double edot = evec.dotProduct(conW);
        double edot2 = evec.dotProduct(evec);
        return edot * edot - this.conCos * this.conCos * edot2;
    }

    private JgclGeometry[] noIntersectionCurve() {
        return new JgclGeometry[0];
    }

    private int getRelation() {
        if (this.isSpecialCase1()) {
            return 0;
        }
        if (this.isSpecialCase2()) {
            return 1;
        }
        if (this.isSpecialCase3()) {
            return 2;
        }
        if (this.isConesVertexOnCylinder()) {
            return 3;
        }
        if (this.isConesVertexInCylinder()) {
            return 4;
        }
        return 5;
    }

    JgclGeometry[] doIntersect(int relation) {
        switch (relation) {
            case 0: {
                return this.oneCircle();
            }
            case 1: {
                return this.oneEllipseOneLine();
            }
            case 2: {
                return this.twoEllipse();
            }
            case 3: {
                return this.coneVertexOnCylinder();
            }
            case 4: {
                return this.coneVertexInCylinder();
            }
            case 5: {
                return this.coneVertexOutCylinder();
            }
        }
        throw new JgclFatal();
    }

    static JgclGeometry[] adjustSolution(JgclGeometry[] geoms1, JgclGeometry[] geoms2, int relation) {
        switch (relation) {
            case 0: {
                JgclCircle3D circle1 = (JgclCircle3D)geoms1[0];
                JgclCircle3D circle2 = (JgclCircle3D)geoms2[0];
                JgclAxis2Placement3D circlePos = new JgclAxis2Placement3D(circle2.position().location(), circle1.position().axis(), circle1.position().refDirection());
                geoms2[0] = new JgclCircle3D(circlePos, circle2.radius());
                break;
            }
            case 1: {
                if (geoms2.length == 1) {
                    if (!(geoms2[0] instanceof JgclLine3D)) break;
                    geoms2 = new JgclGeometry[]{};
                    break;
                }
                if (geoms2.length == 2) {
                    JgclEllipse3D ellipse;
                    if (geoms2[0] instanceof JgclLine3D && geoms2[1] instanceof JgclEllipse3D) {
                        ellipse = (JgclEllipse3D)geoms2[1];
                    } else if (geoms2[1] instanceof JgclLine3D && geoms2[0] instanceof JgclEllipse3D) {
                        ellipse = (JgclEllipse3D)geoms2[0];
                    } else {
                        throw new JgclFatal();
                    }
                    JgclAxis2Placement3D ellipsePos = new JgclAxis2Placement3D(ellipse.position().location(), ellipse.position().axis().reverse(), ellipse.position().refDirection().reverse());
                    geoms2 = new JgclGeometry[]{new JgclEllipse3D(ellipsePos, ellipse.semiAxis1(), ellipse.semiAxis2())};
                    break;
                }
                throw new JgclFatal();
            }
            case 3: {
                if (geoms2.length == 1) {
                    if (!(geoms2[0] instanceof JgclPoint3D)) break;
                    geoms2 = new JgclGeometry[]{};
                    break;
                }
                if (geoms2.length == 2) {
                    JgclParametricCurve3D curve;
                    if (geoms2[0] instanceof JgclLine3D || geoms2[1] instanceof JgclLine3D) {
                        JgclParametricCurve3D curve2;
                        if (geoms2[0] instanceof JgclLine3D && geoms2[1] instanceof JgclParametricCurve3D) {
                            curve2 = (JgclParametricCurve3D)geoms2[1];
                        } else if (geoms2[1] instanceof JgclLine3D && geoms2[0] instanceof JgclParametricCurve3D) {
                            curve2 = (JgclParametricCurve3D)geoms2[0];
                        } else {
                            throw new JgclFatal();
                        }
                        geoms2 = new JgclGeometry[]{curve2};
                        break;
                    }
                    if (!(geoms2[0] instanceof JgclPoint3D) && !(geoms2[1] instanceof JgclPoint3D)) break;
                    if (geoms2[0] instanceof JgclPoint3D && geoms2[1] instanceof JgclParametricCurve3D) {
                        curve = (JgclParametricCurve3D)geoms2[1];
                    } else if (geoms2[1] instanceof JgclPoint3D && geoms2[0] instanceof JgclParametricCurve3D) {
                        curve = (JgclParametricCurve3D)geoms2[0];
                    } else {
                        throw new JgclFatal();
                    }
                    geoms2 = new JgclGeometry[]{curve};
                    break;
                }
                throw new JgclFatal();
            }
            default: {
                throw new JgclFatal();
            }
            case 2: 
            case 4: 
            case 5: 
        }
        return geoms2;
    }

    static JgclSurfaceSurfaceInterference3D[] intersection(JgclCylindricalSurface3D cyl, JgclConicalSurface3D con, boolean doExchange) {
        JgclIntsCylCon3D doObj = new JgclIntsCylCon3D(cyl, con, doExchange);
        int relation1 = doObj.getRelation();
        JgclGeometry[] geoms1 = doObj.doIntersect(relation1);
        JgclConicalSurface3D reversedCone = con.getReverse();
        JgclIntsCylCon3D reversedDoObj = new JgclIntsCylCon3D(cyl, reversedCone, doExchange);
        int relation2 = reversedDoObj.getRelation();
        JgclGeometry[] geoms2 = reversedDoObj.doIntersect(relation2);
        if (relation1 != relation2) {
            throw new JgclFatal();
        }
        geoms2 = JgclIntsCylCon3D.adjustSolution(geoms1, geoms2, relation2);
        JgclSurfaceSurfaceInterference3D[] intf = new JgclSurfaceSurfaceInterference3D[geoms1.length + geoms2.length];
        int i = 0;
        int j = 0;
        while (j < geoms1.length) {
            intf[i] = geoms1[j].isCurve() ? cyl.curveToIntersectionCurve((JgclParametricCurve3D)geoms1[j], con, doExchange) : cyl.pointToIntersectionPoint((JgclPoint3D)geoms1[j], con, doExchange);
            ++j;
            ++i;
        }
        int j2 = 0;
        while (j2 < geoms2.length) {
            intf[i] = geoms2[j2].isCurve() ? cyl.curveToIntersectionCurve((JgclParametricCurve3D)geoms2[j2], con, doExchange) : cyl.pointToIntersectionPoint((JgclPoint3D)geoms2[j2], con, doExchange);
            ++j2;
            ++i;
        }
        return intf;
    }
}

