/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Vector;
import jp.go.ipa.jgcl.JgclAxis2Placement2D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclComplex;
import jp.go.ipa.jgcl.JgclEllipse2D;
import jp.go.ipa.jgcl.JgclHyperbola2D;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclIntsCncCnc2D;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclParabola2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclVector2D;

class JgclIntsCirCnc2D
extends JgclIntsCncCnc2D {
    JgclIntsCirCnc2D() {
    }

    private double[] getCoefficent(JgclCircle2D dA, JgclEllipse2D dB, JgclPoint2D eAic, double dBlrd, double dBsrd) {
        double[] ercoef = new double[5];
        double r = dA.radius();
        double a = dBlrd;
        double b = dBsrd;
        double cx = eAic.x();
        double cy = eAic.y();
        ercoef[4] = cy * cy - b * b;
        ercoef[2] = ercoef[4] + 2.0 * r * r;
        ercoef[4] = a * a * ercoef[4];
        ercoef[0] = ercoef[4];
        ercoef[4] = ercoef[4] + b * b * (cx - r) * (cx - r);
        ercoef[0] = ercoef[0] + b * b * (cx + r) * (cx + r);
        ercoef[2] = 2.0 * (a * a * ercoef[2] + b * b * (cx * cx - r * r));
        ercoef[3] = 4.0 * a * a * r * cy;
        ercoef[1] = ercoef[3];
        return ercoef;
    }

    private JgclIntersectionPoint2D[] getIntersection(JgclCircle2D dA, JgclEllipse2D dB, JgclComplex[] erroot, JgclPoint2D eAic, double dBlrd, double dBsrd, boolean doExchange) {
        double dAslp = Math.atan2(dA.position().x().y(), dA.position().x().x());
        double dBslp = Math.atan2(dB.position().x().y(), dB.position().x().x());
        if (dB.xRadius() < dB.yRadius()) {
            dBslp += 1.5707963267948966;
        }
        Vector<JgclIntersectionPoint2D> intervec = new Vector<JgclIntersectionPoint2D>();
        int i = 0;
        while (i < erroot.length) {
            JgclIntersectionPoint2D inter;
            JgclPointOnCurve2D bPnt;
            JgclPointOnCurve2D aPnt;
            double eTHETA = 2.0 * Math.atan(erroot[i].real());
            double aParam = eTHETA + dBslp - dAslp;
            if (aParam < 0.0 || aParam > Math.PI * 2) {
                aParam = JgclMath.normalizeAngle(aParam);
            }
            double tPntx = (eAic.x() + dA.radius() * Math.cos(eTHETA)) / dBlrd;
            double tPnty = (eAic.y() + dA.radius() * Math.sin(eTHETA)) / dBsrd;
            if (tPntx > 1.0) {
                tPntx = 1.0;
            }
            if (tPntx < -1.0) {
                tPntx = -1.0;
            }
            double bParam = Math.acos(tPntx);
            if (tPnty < 0.0) {
                bParam = Math.PI * 2 - bParam;
            }
            if (dB.xRadius() < dB.yRadius()) {
                bParam += 1.5707963267948966;
            }
            if (bParam < 0.0 || bParam > Math.PI * 2) {
                bParam = JgclMath.normalizeAngle(bParam);
            }
            if ((aPnt = new JgclPointOnCurve2D(dA, aParam, false)).identical(bPnt = new JgclPointOnCurve2D(dB, bParam, false)) && (inter = new JgclIntersectionPoint2D(aPnt, bPnt, false)) != null && this.checkUnique(inter, intervec)) {
                intervec.addElement(inter);
            }
            ++i;
        }
        JgclIntersectionPoint2D[] intersectPoints = this.vectorToArray(intervec, doExchange);
        return intersectPoints;
    }

    JgclIntersectionPoint2D[] intersection(JgclCircle2D dA, JgclEllipse2D dB, boolean doExchange) {
        JgclCartesianTransformationOperator2D trans;
        double dBsrd;
        double dBlrd;
        double dTol = dA.getToleranceForDistance();
        if (dB.xRadius() < dB.yRadius()) {
            dBlrd = dB.yRadius();
            dBsrd = dB.xRadius();
            JgclAxis2Placement2D axis = new JgclAxis2Placement2D(dB.position().location(), dB.position().y());
            trans = new JgclCartesianTransformationOperator2D(axis, 1.0);
        } else {
            dBlrd = dB.xRadius();
            dBsrd = dB.yRadius();
            trans = new JgclCartesianTransformationOperator2D(dB.position(), 1.0);
        }
        JgclVector2D Bc2Ac = dA.position().location().subtract(dB.position().location());
        double lengBc2Ac = Bc2Ac.length();
        if (lengBc2Ac - (dA.radius() + dBlrd) > dTol || dA.radius() - dBlrd - lengBc2Ac > dTol || dBsrd - dA.radius() - lengBc2Ac > dTol) {
            return new JgclIntersectionPoint2D[0];
        }
        JgclPoint2D eAic = trans.toLocal(Bc2Ac).toPoint2D();
        double[] coefficent = this.getCoefficent(dA, dB, eAic, dBlrd, dBsrd);
        JgclComplex[] erroot = this.getRoot(coefficent);
        if (erroot == null) {
            return new JgclIntersectionPoint2D[0];
        }
        return this.getIntersection(dA, dB, erroot, eAic, dBlrd, dBsrd, doExchange);
    }

    private double[] getCoefficent(JgclCircle2D circle, JgclHyperbola2D hyp, JgclPoint2D eiAc) {
        double[] ercoef = new double[5];
        double a = hyp.xRadius();
        double b = hyp.yRadius();
        double r = circle.radius();
        double cx = eiAc.x();
        double cy = eiAc.y();
        ercoef[4] = a * a + b * b;
        ercoef[0] = a * a - r * r + cx * cx + cy * cy;
        ercoef[3] = -4.0 * b * cy * ercoef[4];
        ercoef[1] = -4.0 * b * cy * ercoef[0];
        double workX = -2.0 * a * a * cx * cx;
        double workY = 2.0 * b * b * cy * cy;
        ercoef[2] = 2.0 * (ercoef[0] * ercoef[4] + workY + workX);
        ercoef[4] = ercoef[4] * ercoef[4];
        ercoef[0] = ercoef[0] * ercoef[0] + 2.0 * workX;
        return ercoef;
    }

    private JgclIntersectionPoint2D[] getIntersection(JgclCircle2D circle, JgclHyperbola2D hyp, JgclComplex[] erroot, JgclPoint2D eiAc, boolean doExchange) {
        double dTol = circle.getToleranceForDistance();
        double dAslp = Math.atan2(circle.position().x().y(), circle.position().x().x());
        double dBslp = Math.atan2(hyp.position().x().y(), hyp.position().x().x());
        Vector<JgclIntersectionPoint2D> intervec = new Vector<JgclIntersectionPoint2D>();
        int i = 0;
        while (i < erroot.length) {
            block9: {
                JgclIntersectionPoint2D inter;
                double bParam;
                JgclPointOnCurve2D bPnt;
                JgclPointOnCurve2D aPnt;
                double aParam;
                double cosA;
                double sinA;
                double coshB;
                double sinhB;
                block10: {
                    sinhB = erroot[i].real();
                    coshB = Math.sqrt(1.0 + sinhB * sinhB);
                    double Ppntx = hyp.xRadius() * coshB;
                    double Ppnty = hyp.yRadius() * sinhB;
                    if (Math.abs(Ppnty - eiAc.y()) > circle.radius() + dTol) break block9;
                    sinA = (Ppnty - eiAc.y()) / circle.radius();
                    if (sinA > 1.0) {
                        sinA = 1.0;
                    }
                    if (sinA < -1.0) {
                        sinA = -1.0;
                    }
                    cosA = Math.sqrt(1.0 - sinA * sinA);
                    double xA = eiAc.x() + circle.radius() * cosA;
                    if (!(Math.abs(Ppntx - xA) > dTol)) break block10;
                    cosA = -cosA;
                    xA = eiAc.x() + circle.radius() * cosA;
                    if (Math.abs(Ppntx - xA) > dTol) break block9;
                }
                double T = Math.acos(cosA);
                if (sinA < 0.0) {
                    T = Math.PI * 2 - T;
                }
                if ((aParam = T + dBslp - dAslp) < 0.0 || aParam > Math.PI * 2) {
                    aParam = JgclMath.normalizeAngle(aParam);
                }
                if ((aPnt = new JgclPointOnCurve2D(circle, aParam, false)).identical(bPnt = new JgclPointOnCurve2D(hyp, bParam = Math.log(sinhB + coshB), false)) && (inter = new JgclIntersectionPoint2D(aPnt, bPnt, false)) != null && this.checkUnique(inter, intervec)) {
                    intervec.addElement(inter);
                }
            }
            ++i;
        }
        JgclIntersectionPoint2D[] intersectPoints = this.vectorToArray(intervec, doExchange);
        return intersectPoints;
    }

    JgclIntersectionPoint2D[] intersection(JgclCircle2D circle, JgclHyperbola2D hyp, boolean doExchange) {
        JgclVector2D Bc2Ac = circle.position().location().subtract(hyp.position().location());
        JgclCartesianTransformationOperator2D trans = new JgclCartesianTransformationOperator2D(hyp.position(), 1.0);
        JgclPoint2D eiAc = trans.toLocal(Bc2Ac).toPoint2D();
        double[] coefficent = this.getCoefficent(circle, hyp, eiAc);
        JgclComplex[] erroot = this.getRoot(coefficent);
        if (erroot == null) {
            return new JgclIntersectionPoint2D[0];
        }
        return this.getIntersection(circle, hyp, erroot, eiAc, doExchange);
    }

    double[] getCoefficent(JgclCircle2D circle, JgclParabola2D par, JgclPoint2D eiAc) {
        double[] ercoef = new double[5];
        double a = par.focalDist();
        double cx = eiAc.x();
        double cy = eiAc.y();
        double r = circle.radius();
        ercoef[4] = a * a;
        ercoef[3] = 0.0;
        ercoef[2] = 2.0 * a * (2.0 * a - cx);
        ercoef[1] = -4.0 * a * cy;
        ercoef[0] = cx * cx + cy * cy - r * r;
        return ercoef;
    }

    private JgclIntersectionPoint2D[] getIntersection(JgclCircle2D circle, JgclParabola2D par, JgclComplex[] erroot, JgclPoint2D eiAc, boolean doExchange) {
        double dTol = circle.getToleranceForDistance();
        double dAslp = Math.atan2(circle.position().x().y(), circle.position().x().x());
        double dBslp = Math.atan2(par.position().x().y(), par.position().x().x());
        Vector<JgclIntersectionPoint2D> intervec = new Vector<JgclIntersectionPoint2D>();
        int i = 0;
        while (i < erroot.length) {
            JgclIntersectionPoint2D inter;
            JgclPointOnCurve2D bPnt;
            JgclPointOnCurve2D aPnt;
            double bParam = erroot[i].real();
            double Ppntx = par.focalDist() * bParam * bParam;
            double Ppnty = 2.0 * par.focalDist() * bParam;
            Ppntx = (Ppntx - eiAc.x()) / circle.radius();
            Ppnty = (Ppnty - eiAc.y()) / circle.radius();
            if (Ppntx > 1.0) {
                Ppntx = 1.0;
            }
            if (Ppntx < -1.0) {
                Ppntx = -1.0;
            }
            double aParam = Math.acos(Ppntx);
            if (Ppnty < 0.0) {
                aParam = Math.PI * 2 - aParam;
            }
            if ((aParam = aParam + dBslp - dAslp) < 0.0 || aParam > Math.PI * 2) {
                aParam = JgclMath.normalizeAngle(aParam);
            }
            if ((aPnt = new JgclPointOnCurve2D(circle, aParam, false)).identical(bPnt = new JgclPointOnCurve2D(par, bParam, false)) && (inter = new JgclIntersectionPoint2D(aPnt, bPnt, false)) != null && this.checkUnique(inter, intervec)) {
                intervec.addElement(inter);
            }
            ++i;
        }
        JgclIntersectionPoint2D[] intersectPoints = this.vectorToArray(intervec, doExchange);
        return intersectPoints;
    }

    JgclIntersectionPoint2D[] intersection(JgclCircle2D circle, JgclParabola2D par, boolean doExchange) {
        double dTol = circle.getToleranceForDistance();
        JgclVector2D Bc2Ac = circle.position().location().subtract(par.position().location());
        JgclCartesianTransformationOperator2D trans = new JgclCartesianTransformationOperator2D(par.position(), 1.0);
        JgclPoint2D eiAc = trans.toLocal(Bc2Ac).toPoint2D();
        if (eiAc.x() + circle.radius() < -dTol) {
            return new JgclIntersectionPoint2D[0];
        }
        double[] coefficent = this.getCoefficent(circle, par, eiAc);
        JgclComplex[] erroot = this.getRoot(coefficent);
        if (erroot == null) {
            return new JgclIntersectionPoint2D[0];
        }
        return this.getIntersection(circle, par, erroot, eiAc, doExchange);
    }
}

