/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclBinaryTree;
import jp.go.ipa.jgcl.JgclBooleanFunctionWithRealVariables;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclCursor;
import jp.go.ipa.jgcl.JgclCurveSurfaceInterferenceList;
import jp.go.ipa.jgcl.JgclEnclosingBox3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclGeometry;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclLiteralVector2D;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclObjectVector;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclQuadTree;
import jp.go.ipa.jgcl.JgclRealFunction;
import jp.go.ipa.jgcl.JgclVector2D;
import jp.go.ipa.jgcl.JgclVector3D;

final class JgclIntsBzcBzs3D {
    JgclPureBezierCurve3D dA;
    JgclPureBezierSurface3D dB;
    JgclBinaryTree aTree;
    JgclQuadTree bTree;
    JgclCurveSurfaceInterferenceList solutions;
    double dTol;
    double dTol2;
    double pTol;
    JgclPoint3D sApnt;
    JgclPoint3D sBpnt;
    JgclVector3D aTang;
    JgclVector3D[] bTang;
    private static final int UNKNOWN = 0;
    private static final int BEZIER = 1;
    private static final int LINE = 2;
    private static final int POINT = 3;
    private static final int PLANER = 4;

    JgclIntsBzcBzs3D(JgclPureBezierCurve3D bzc, JgclPureBezierSurface3D bzs) {
        this.dA = bzc;
        this.dB = bzs;
        JgclConditionOfOperation cond = JgclConditionOfOperation.getCondition();
        this.dTol2 = cond.getToleranceForDistance2();
        this.dTol = cond.getToleranceForDistance();
        this.pTol = cond.getToleranceForParameter();
        this.aTree = new JgclBinaryTree(new BezierCurveInfo(this.dA, 0.0, 1.0, false));
        BezierSurfaceInfo dBRoot = new BezierSurfaceInfo(this.dB, this.dB, 0.0, 1.0, 0.0, 1.0, true);
        dBRoot.rivals.addElement(this.aTree.rootNode());
        this.bTree = new JgclQuadTree(dBRoot);
        this.solutions = new JgclCurveSurfaceInterferenceList(bzc, bzs);
    }

    private JgclPlane3D makeNormPlane(JgclLine3D line) {
        JgclPoint3D org = line.pnt();
        JgclVector3D z = line.dir();
        JgclVector3D x = z.verticalVector();
        return new JgclPlane3D(new JgclAxis2Placement3D(org, z, x));
    }

    private JgclEnclosingBox3D translateBox(JgclPoint3D boxMin, JgclPoint3D boxMax, JgclPlane3D plane) {
        JgclPoint3D[] boxPoints = new JgclPoint3D[]{new JgclCartesianPoint3D(boxMin.x(), boxMin.y(), boxMin.z()), new JgclCartesianPoint3D(boxMax.x(), boxMin.y(), boxMin.z()), new JgclCartesianPoint3D(boxMax.x(), boxMax.y(), boxMin.z()), new JgclCartesianPoint3D(boxMin.x(), boxMax.y(), boxMin.z()), new JgclCartesianPoint3D(boxMin.x(), boxMin.y(), boxMax.z()), new JgclCartesianPoint3D(boxMax.x(), boxMin.y(), boxMax.z()), new JgclCartesianPoint3D(boxMax.x(), boxMax.y(), boxMax.z()), new JgclCartesianPoint3D(boxMin.x(), boxMax.y(), boxMax.z())};
        JgclAxis2Placement3D position = plane.position();
        JgclCartesianTransformationOperator3D transformer = new JgclCartesianTransformationOperator3D(position, 1.0);
        boxPoints[0] = transformer.toLocal(boxPoints[0]);
        JgclPoint3D tBoxMin = boxPoints[0];
        JgclPoint3D tBoxMax = boxPoints[0];
        int i = 0;
        while (i < 8) {
            boxPoints[i] = transformer.toLocal(boxPoints[i]);
            tBoxMin = new JgclCartesianPoint3D(Math.min(boxPoints[i].x(), tBoxMin.x()), Math.min(boxPoints[i].y(), tBoxMin.y()), Math.min(boxPoints[i].z(), tBoxMin.z()));
            tBoxMax = new JgclCartesianPoint3D(Math.max(boxPoints[i].x(), tBoxMin.x()), Math.max(boxPoints[i].y(), tBoxMin.y()), Math.max(boxPoints[i].z(), tBoxMin.z()));
            ++i;
        }
        return new JgclEnclosingBox3D(tBoxMin, tBoxMax);
    }

    private boolean checkInterfere(BezierCurveInfo bci, BezierSurfaceInfo bsi) {
        if (bci.currentType == 2 && bsi.pb != null) {
            JgclPlane3D plane = this.makeNormPlane((JgclLine3D)bci.geom);
            JgclEnclosingBox3D box = this.translateBox(bsi.box.min(), bsi.box.max(), plane);
            return !(box.min().x() < this.dTol && box.min().y() < this.dTol && box.max().x() > -this.dTol && box.max().y() > -this.dTol);
        }
        int pside = 0;
        int cside = 0;
        if (bsi.pb == null && (bci.currentType == 0 || bci.currentType == 1)) {
            int j = 0;
            while (j < bci.bzc.nControlPoints()) {
                JgclPlane3D pl = new JgclPlane3D(bsi.pb.origin(), bsi.pb.zaxis());
                cside = pl.pointIsWhichSide(bci.bzc.controlPointAt(j));
                if (j == 0) {
                    pside = cside;
                } else if (pside != cside) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        return !(bci.box.min().x() > bsi.box.max().x() + this.dTol || bci.box.min().y() > bsi.box.max().y() + this.dTol || bci.box.min().z() > bsi.box.max().z() + this.dTol || bsi.box.min().x() > bci.box.max().x() + this.dTol || bsi.box.min().y() > bci.box.max().y() + this.dTol || bsi.box.min().z() > bci.box.max().z() + this.dTol);
    }

    private boolean divideRivals(JgclBinaryTree.Node dANode, JgclObjectVector new_rivals) {
        JgclBinaryTree.Node binR;
        JgclBinaryTree.Node binL;
        if (dANode.left() == null && dANode.right() == null) {
            BezierCurveInfo bi = (BezierCurveInfo)dANode.data();
            if (bi.whatTypeIsBezierCurve() != 1) {
                new_rivals.addElement(dANode);
                return false;
            }
            double harf_point = 0.5;
            JgclPureBezierCurve3D[] bzcs = bi.bzc.divide(harf_point);
            double g_harf_point = (bi.sp + bi.ep) / 2.0;
            BezierCurveInfo biL = new BezierCurveInfo(bzcs[0], bi.sp, g_harf_point, false);
            binL = dANode.makeLeft(biL);
            BezierCurveInfo biR = new BezierCurveInfo(bzcs[1], g_harf_point, bi.ep, false);
            binR = dANode.makeRight(biR);
        } else {
            binL = dANode.left();
            binR = dANode.right();
        }
        new_rivals.addElement(binL);
        new_rivals.addElement(binR);
        return true;
    }

    private void intersectLinePlane(BezierCurveInfo bci, BezierSurfaceInfo bsi) {
        double svParam;
        double suParam;
        JgclLine3D line = (JgclLine3D)bci.geom;
        JgclPlane3D plane = new JgclPlane3D(((BezierSurfaceInfo)bsi).pb.axis);
        JgclCartesianTransformationOperator3D transform = new JgclCartesianTransformationOperator3D(plane.position(), 1.0);
        JgclPoint3D eApnt = transform.toLocal(line.pnt());
        JgclVector3D eAdir = transform.toLocal(line.dir());
        double et = -eApnt.z() / eAdir.z();
        JgclPoint3D dCpnt = line.pnt().add(line.dir().multiply(et));
        if (et < -this.pTol || 1.0 + this.pTol < et) {
            return;
        }
        if (!bsi.isPointInPlane(dCpnt)) {
            return;
        }
        double cParam = (1.0 - et) * bci.sp + et * bci.ep;
        PointInfo pi = new PointInfo(dCpnt, cParam, suParam = (bsi.usp + bsi.uep) / 2.0, svParam = (bsi.vsp + bsi.vep) / 2.0);
        if (this.refinePointInfo(pi)) {
            this.solutions.addAsIntersection(pi.pnt, pi.aParam, pi.bUParam, pi.bVParam);
        }
    }

    private void setbackParams(PointInfo pi, double[] param) {
        pi.aParam = this.dA.parameterDomain().force(param[0]);
        pi.bUParam = this.dB.uParameterDomain().force(param[1]);
        pi.bVParam = this.dB.vParameterDomain().force(param[2]);
        JgclPoint3D aPnt = this.dA.coordinates(pi.aParam);
        JgclPoint3D bPnt = this.dB.coordinates(pi.bUParam, pi.bVParam);
        pi.pnt = aPnt.linearInterpolate(bPnt, 0.5);
    }

    boolean refinePointInfo(PointInfo pi) {
        double[] param = new double[]{pi.aParam, pi.bUParam, pi.bVParam};
        nlFunc nl_func = new nlFunc();
        JgclRealFunction[] dnl_func = new JgclRealFunction[]{new dnlFunc1(), new dnlFunc2(), new dnlFunc3()};
        cnvFunc cnv_func = new cnvFunc();
        if ((param = JgclMath.solveSimultaneousEquations(nl_func, dnl_func, cnv_func, param)) == null) {
            return false;
        }
        this.setbackParams(pi, param);
        return true;
    }

    void getIntersections(JgclQuadTree.Node crnt_node) {
        JgclCursor cursor;
        JgclBinaryTree.Node dANode = null;
        Object dBNode = null;
        BezierSurfaceInfo crnt_bi = (BezierSurfaceInfo)crnt_node.data();
        int n_rivals = crnt_bi.rivals.size();
        if (crnt_bi.bzs == this.dB) {
            cursor = crnt_bi.rivals.cursor();
            while (cursor.hasMoreElements()) {
                dANode = (JgclBinaryTree.Node)cursor.nextElement();
                if (this.checkInterfere((BezierCurveInfo)dANode.data(), crnt_bi)) continue;
                cursor.removePrevElement();
            }
            if (crnt_bi.rivals.size() == 0) {
                return;
            }
        }
        if (crnt_bi.whatTypeIsBezierSurface() != 1) {
            JgclObjectVector new_rivals = new JgclObjectVector();
            boolean all_rivals_are_line = true;
            n_rivals = crnt_bi.rivals.size();
            int i = 0;
            while (i < n_rivals) {
                if (this.divideRivals((JgclBinaryTree.Node)crnt_bi.rivals.elementAt(i), new_rivals)) {
                    all_rivals_are_line = false;
                }
                ++i;
            }
            crnt_bi.rivals = new_rivals;
            if (!all_rivals_are_line) {
                this.getIntersections(crnt_node);
            } else {
                n_rivals = crnt_bi.rivals.size();
                i = 0;
                while (i < n_rivals) {
                    dANode = (JgclBinaryTree.Node)crnt_bi.rivals.elementAt(i);
                    this.intersectLinePlane((BezierCurveInfo)dANode.data(), crnt_bi);
                    ++i;
                }
            }
            return;
        }
        double ug_half = (crnt_bi.usp + crnt_bi.uep) / 2.0;
        double vg_half = (crnt_bi.vsp + crnt_bi.vep) / 2.0;
        double half_point = 0.5;
        JgclPureBezierSurface3D[] bzsx = crnt_bi.bzs.vDivide(half_point);
        JgclPureBezierSurface3D[] bzs0 = bzsx[0].uDivide(half_point);
        JgclPureBezierSurface3D[] bzs1 = bzsx[1].uDivide(half_point);
        if (crnt_bi.uep - crnt_bi.usp < 0.75 || crnt_bi.vep - crnt_bi.vsp < 0.75) {
            crnt_bi.bzs = null;
        }
        BezierSurfaceInfo bi00 = new BezierSurfaceInfo(crnt_bi.root, bzs0[0], crnt_bi.usp, ug_half, crnt_bi.vsp, vg_half, true);
        BezierSurfaceInfo bi10 = new BezierSurfaceInfo(crnt_bi.root, bzs1[0], crnt_bi.uep, ug_half, vg_half, crnt_bi.vep, true);
        BezierSurfaceInfo bi11 = new BezierSurfaceInfo(crnt_bi.root, bzs1[1], ug_half, crnt_bi.uep, vg_half, crnt_bi.vep, true);
        BezierSurfaceInfo bi01 = new BezierSurfaceInfo(crnt_bi.root, bzs0[1], ug_half, crnt_bi.uep, crnt_bi.vsp, vg_half, true);
        n_rivals = crnt_bi.rivals.size();
        int i = 0;
        while (i < n_rivals) {
            this.divideRivals((JgclBinaryTree.Node)crnt_bi.rivals.elementAt(i), bi00.rivals);
            ++i;
        }
        n_rivals = bi00.rivals.size();
        i = 0;
        while (i < n_rivals) {
            bi01.rivals.addElement(bi00.rivals.elementAt(i));
            bi11.rivals.addElement(bi00.rivals.elementAt(i));
            bi10.rivals.addElement(bi00.rivals.elementAt(i));
            ++i;
        }
        cursor = bi00.rivals.cursor();
        while (cursor.hasMoreElements()) {
            dANode = (JgclBinaryTree.Node)cursor.nextElement();
            if (this.checkInterfere((BezierCurveInfo)dANode.data(), crnt_bi)) continue;
            cursor.removePrevElement();
        }
        if (bi00.rivals.size() != 0) {
            JgclQuadTree.Node bin00 = crnt_node.makeChild(0, bi00);
            this.getIntersections(bin00);
        }
        cursor = bi01.rivals.cursor();
        while (cursor.hasMoreElements()) {
            dANode = (JgclBinaryTree.Node)cursor.nextElement();
            if (this.checkInterfere((BezierCurveInfo)dANode.data(), crnt_bi)) continue;
            cursor.removePrevElement();
        }
        if (bi01.rivals.size() != 0) {
            JgclQuadTree.Node bin01 = crnt_node.makeChild(1, bi01);
            this.getIntersections(bin01);
        }
        cursor = bi10.rivals.cursor();
        while (cursor.hasMoreElements()) {
            dANode = (JgclBinaryTree.Node)cursor.nextElement();
            if (this.checkInterfere((BezierCurveInfo)dANode.data(), crnt_bi)) continue;
            cursor.removePrevElement();
        }
        if (bi10.rivals.size() != 0) {
            JgclQuadTree.Node bin10 = crnt_node.makeChild(2, bi10);
            this.getIntersections(bin10);
        }
        cursor = bi11.rivals.cursor();
        while (cursor.hasMoreElements()) {
            dANode = (JgclBinaryTree.Node)cursor.nextElement();
            if (this.checkInterfere((BezierCurveInfo)dANode.data(), crnt_bi)) continue;
            cursor.removePrevElement();
        }
        if (bi11.rivals.size() != 0) {
            JgclQuadTree.Node bin11 = crnt_node.makeChild(3, bi11);
            this.getIntersections(bin11);
        }
    }

    JgclCurveSurfaceInterferenceList intsBzcBzs() {
        BezierCurveInfo dARoot = (BezierCurveInfo)this.aTree.rootNode().data();
        JgclQuadTree.Node dBRootNode = this.bTree.rootNode();
        BezierSurfaceInfo dBRoot = (BezierSurfaceInfo)dBRootNode.data();
        if (dARoot.box.min().x() > dBRoot.box.max().x() + this.dTol || dARoot.box.min().y() > dBRoot.box.max().y() + this.dTol || dARoot.box.min().z() > dBRoot.box.max().z() + this.dTol || dBRoot.box.min().x() > dARoot.box.max().x() + this.dTol || dBRoot.box.min().y() > dARoot.box.max().y() + this.dTol || dBRoot.box.min().z() > dARoot.box.max().z() + this.dTol) {
            return this.solutions;
        }
        this.getIntersections(dBRootNode);
        return this.solutions;
    }

    static JgclIntersectionPoint3D[] intersection(JgclPureBezierCurve3D bzc, JgclPureBezierSurface3D bzs, boolean doExchange) {
        JgclIntsBzcBzs3D doObj = new JgclIntsBzcBzs3D(bzc, bzs);
        return doObj.intsBzcBzs().toJgclIntersectionPoint3DArray(doExchange);
    }

    static /* synthetic */ int access$0() {
        return 0;
    }

    static /* synthetic */ int access$1() {
        return 1;
    }

    static /* synthetic */ int access$2() {
        return 3;
    }

    static /* synthetic */ int access$3() {
        return 2;
    }

    static /* synthetic */ int access$4() {
        return 4;
    }

    class BezierCurveInfo {
        private JgclPureBezierCurve3D bzc;
        private double sp;
        private double ep;
        private JgclEnclosingBox3D box;
        private JgclObjectVector rivals;
        private int currentType;
        private JgclGeometry geom;

        BezierCurveInfo(JgclPureBezierCurve3D bzc, double sp, double ep, boolean hasRival) {
            JgclIntsBzcBzs3D.this = JgclIntsBzcBzs3D.this;
            this.bzc = bzc;
            this.sp = sp;
            this.ep = ep;
            this.box = bzc.approximateEnclosingBox();
            this.rivals = hasRival ? new JgclObjectVector() : null;
            this.currentType = JgclIntsBzcBzs3D.access$0();
            this.geom = null;
        }

        private JgclPoint3D pnt() {
            return (JgclPoint3D)this.geom;
        }

        private int whatTypeIsBezierCurve() {
            if (this.currentType != JgclIntsBzcBzs3D.access$0()) {
                return this.currentType;
            }
            int uicp = this.bzc.nControlPoints();
            JgclVector3D s2e = this.bzc.controlPointAt(uicp - 1).subtract(this.bzc.controlPointAt(0));
            double leng_s2e = s2e.length();
            if (leng_s2e < JgclIntsBzcBzs3D.this.dTol) {
                int i = 1;
                while (i < uicp - 1) {
                    JgclVector3D s2c = this.bzc.controlPointAt(i).subtract(this.bzc.controlPointAt(0));
                    if (!(s2c.length() < JgclIntsBzcBzs3D.this.dTol)) break;
                    ++i;
                }
                if (i == uicp - 1) {
                    JgclPoint3D pnt_geom = this.bzc.controlPointAt(uicp - 1).linearInterpolate(this.bzc.controlPointAt(0), 0.5);
                    this.geom = pnt_geom;
                    this.currentType = JgclIntsBzcBzs3D.access$2();
                    return this.currentType;
                }
                this.geom = null;
                this.currentType = JgclIntsBzcBzs3D.access$1();
                return this.currentType;
            }
            JgclVector3D unit_s2e = s2e.divide(leng_s2e);
            int i = 1;
            while (i < uicp - 1) {
                JgclVector3D s2c = this.bzc.controlPointAt(i).subtract(this.bzc.controlPointAt(0));
                JgclVector3D crsv = unit_s2e.crossProduct(s2c);
                if (crsv.length() > JgclIntsBzcBzs3D.this.dTol) {
                    this.geom = null;
                    this.currentType = JgclIntsBzcBzs3D.access$1();
                    return this.currentType;
                }
                double leng = unit_s2e.dotProduct(s2c);
                if (leng < 0.0 - JgclIntsBzcBzs3D.this.dTol || leng > leng_s2e + JgclIntsBzcBzs3D.this.dTol) {
                    this.geom = null;
                    this.currentType = JgclIntsBzcBzs3D.access$1();
                    return this.currentType;
                }
                ++i;
            }
            JgclLine3D lin_geom = new JgclLine3D(this.bzc.controlPointAt(0), s2e);
            this.geom = lin_geom;
            this.currentType = JgclIntsBzcBzs3D.access$3();
            return this.currentType;
        }
    }

    class BezierSurfaceInfo {
        private JgclPureBezierSurface3D bzs;
        private JgclPureBezierSurface3D root;
        private double usp;
        private double uep;
        private double vsp;
        private double vep;
        private JgclEnclosingBox3D box;
        private JgclObjectVector rivals;
        private PlaneBezier pb;
        private int currentType;

        BezierSurfaceInfo(JgclPureBezierSurface3D root, JgclPureBezierSurface3D bzs, double usp, double uep, double vsp, double vep, boolean hasRivals) {
            JgclIntsBzcBzs3D.this = JgclIntsBzcBzs3D.this;
            this.root = root;
            this.bzs = bzs;
            this.usp = usp;
            this.uep = uep;
            this.vsp = vsp;
            this.vep = vep;
            this.box = bzs.approximateEnclosingBox();
            this.rivals = hasRivals ? new JgclObjectVector() : null;
            this.currentType = JgclIntsBzcBzs3D.access$0();
            JgclIntsBzcBzs3D jgclIntsBzcBzs3D = JgclIntsBzcBzs3D.this;
            jgclIntsBzcBzs3D.getClass();
            this.pb = jgclIntsBzcBzs3D.new PlaneBezier(bzs);
        }

        int whatTypeIsBezierSurface() {
            JgclVector3D evec;
            int i;
            PlaneBezier pb;
            if (this.currentType != JgclIntsBzcBzs3D.access$0()) {
                return this.currentType;
            }
            int u_uicp = this.bzs.uNControlPoints();
            int v_uicp = this.bzs.vNControlPoints();
            this.currentType = JgclIntsBzcBzs3D.access$1();
            this.pb = pb = new PlaneBezier(this.bzs);
            JgclPoint3D org = pb.origin();
            JgclVector3D zaxis = pb.zaxis();
            JgclVector3D[] xyz = pb.axis.axes();
            int j = 0;
            while (j < v_uicp) {
                i = 0;
                while (i < u_uicp) {
                    evec = this.bzs.controlPointAt(i, j).subtract(org);
                    if (Math.abs(evec.dotProduct(zaxis)) > JgclIntsBzcBzs3D.this.dTol) {
                        return this.currentType;
                    }
                    ++i;
                }
                ++j;
            }
            this.currentType = JgclIntsBzcBzs3D.access$2();
            i = 0;
            while (i < 4) {
                int uicp;
                int n = uicp = i % 2 == 0 ? u_uicp : v_uicp;
                if (pb.shape_info[i] == 0) {
                    pb.bcrv[i] = null;
                } else {
                    JgclPoint3D[] pnts = new JgclPoint3D[uicp];
                    JgclPoint2D[] pnt2d = new JgclPoint2D[uicp];
                    double[] ws = null;
                    if (this.bzs.isRational()) {
                        ws = new double[uicp];
                    }
                    int j2 = 0;
                    while (j2 < uicp) {
                        switch (i) {
                            case 0: {
                                pnts[j2] = this.bzs.controlPointAt(j2, 0);
                                if (!this.bzs.isRational()) break;
                                ws[j2] = this.bzs.weightAt(j2, 0);
                                break;
                            }
                            case 1: {
                                pnts[j2] = this.bzs.controlPointAt(u_uicp - 1, j2);
                                if (!this.bzs.isRational()) break;
                                ws[j2] = this.bzs.weightAt(u_uicp - 1, j2);
                                break;
                            }
                            case 2: {
                                pnts[j2] = this.bzs.controlPointAt(u_uicp - 1 - j2, v_uicp - 1);
                                if (!this.bzs.isRational()) break;
                                ws[j2] = this.bzs.weightAt(u_uicp - 1 - j2, v_uicp - 1);
                                break;
                            }
                            case 3: {
                                pnts[j2] = this.bzs.controlPointAt(0, v_uicp - 1 - j2);
                                if (!this.bzs.isRational()) break;
                                ws[j2] = this.bzs.weightAt(0, v_uicp - 1 - j2);
                                break;
                            }
                        }
                        evec = pnts[j2].subtract(org);
                        pnt2d[j2] = new JgclCartesianPoint2D(evec.dotProduct(xyz[0]), evec.dotProduct(xyz[1]));
                        ++j2;
                    }
                    pb.bcrv[i] = new JgclPureBezierCurve2D(pnt2d, ws, false);
                    JgclVector2D s2e = pnt2d[uicp - 1].subtract(pnt2d[0]).unitized();
                    int j3 = 1;
                    while (j3 < uicp - 1) {
                        JgclVector2D evec2 = pnt2d[j3].subtract(pnt2d[0]);
                        double edot = evec2.dotProduct(s2e);
                        if (Math.abs(evec2.norm() - edot * edot) > JgclIntsBzcBzs3D.this.dTol2) break;
                        ++j3;
                    }
                    pb.bcrv_is_line[i] = j3 == uicp - 1;
                    this.currentType = pb.bcrv_is_line[i] ? JgclIntsBzcBzs3D.access$3() : JgclIntsBzcBzs3D.access$4();
                }
                ++i;
            }
            return this.currentType;
        }

        private boolean isPointInPlane(JgclPoint3D point) {
            JgclVector3D evec = point.subtract(this.pb.origin());
            JgclCartesianPoint2D point2d = new JgclCartesianPoint2D(evec.dotProduct(this.pb.axis.x()), evec.dotProduct(this.pb.axis.y()));
            JgclLiteralVector2D dir = new JgclLiteralVector2D(0.70710678, 0.70710678);
            JgclLine2D line2d = new JgclLine2D((JgclPoint2D)point2d, dir);
            JgclObjectVector saved_ipl_list = new JgclObjectVector();
            double saved_ipl = 0.0;
            int icnt = 0;
            int i = 0;
            while (i < 4) {
                block11: {
                    if (this.pb.bcrv[i] != null) {
                        JgclIntersectionPoint2D[] intp;
                        try {
                            intp = line2d.intersect(this.pb.bcrv[i]);
                        }
                        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                            throw new JgclFatal();
                        }
                        catch (JgclFatal jgclFatal) {
                            break block11;
                        }
                        if (intp.length > 0) {
                            int j = 0;
                            while (j < intp.length) {
                                double ipl = intp[j].pointOnCurve1().parameter();
                                if (ipl > -JgclIntsBzcBzs3D.this.dTol) {
                                    if (ipl < JgclIntsBzcBzs3D.this.dTol) {
                                        return true;
                                    }
                                    int k = 0;
                                    while (k < saved_ipl_list.size()) {
                                        saved_ipl = (Double)saved_ipl_list.elementAt(k);
                                        if (Math.abs(ipl - saved_ipl) < JgclIntsBzcBzs3D.this.dTol) break;
                                        ++k;
                                    }
                                    if (k == saved_ipl_list.size()) {
                                        saved_ipl_list.addElement(new Double(ipl));
                                        ++icnt;
                                    }
                                }
                                ++j;
                            }
                        }
                    }
                }
                ++i;
            }
            return icnt % 2 != 0;
        }
    }

    final class PlaneBezier {
        JgclAxis2Placement3D axis;
        JgclPureBezierCurve2D[] bcrv;
        boolean[] bcrv_is_line;
        int edge_cnt;
        int[] shape_info;

        PlaneBezier(JgclPureBezierSurface3D bzs) {
            JgclIntsBzcBzs3D.this = JgclIntsBzcBzs3D.this;
            int u_uicp = bzs.uNControlPoints();
            int v_uicp = bzs.vNControlPoints();
            boolean retrying = false;
            JgclVector3D udir = null;
            JgclVector3D vdir = null;
            this.shape_info = new int[4];
            this.bcrv_is_line = new boolean[4];
            this.bcrv = new JgclPureBezierCurve2D[4];
            JgclPoint3D c00 = bzs.controlPointAt(0, 0);
            JgclPoint3D c10 = bzs.controlPointAt(u_uicp - 1, 0);
            JgclPoint3D c01 = bzs.controlPointAt(0, v_uicp - 1);
            JgclPoint3D c11 = bzs.controlPointAt(u_uicp - 1, v_uicp - 1);
            JgclVector3D u0dir = c10.subtract(c00);
            JgclVector3D v1dir = c11.subtract(c10);
            JgclVector3D u1dir = c01.subtract(c11);
            JgclVector3D v0dir = c00.subtract(c01);
            block5: while (true) {
                double u0norm;
                int iu0dir = (u0norm = u0dir.norm()) > JgclIntsBzcBzs3D.this.dTol2 ? 1 : 0;
                double v0norm = v0dir.norm();
                int iv0dir = v0norm > JgclIntsBzcBzs3D.this.dTol2 ? 1 : 0;
                double u1norm = u1dir.norm();
                int iu1dir = u1norm > JgclIntsBzcBzs3D.this.dTol2 ? 1 : 0;
                double v1norm = v1dir.norm();
                int iv1dir = v1norm > JgclIntsBzcBzs3D.this.dTol2 ? 1 : 0;
                this.edge_cnt = iu0dir + iv0dir + iu1dir + iv1dir;
                this.shape_info[0] = iu0dir;
                this.shape_info[3] = iv0dir;
                this.shape_info[2] = iu1dir;
                this.shape_info[1] = iv1dir;
                switch (this.edge_cnt) {
                    case 4: {
                        udir = u0dir;
                        vdir = v0dir;
                        break block5;
                    }
                    case 3: {
                        if (iu0dir == 0) {
                            udir = v1dir.multiply(-1.0);
                            vdir = v0dir;
                            break block5;
                        }
                        if (iv0dir == 0) {
                            udir = u0dir;
                            vdir = u1dir.multiply(-1.0);
                            break block5;
                        }
                        udir = u0dir;
                        vdir = v0dir;
                        break block5;
                    }
                    case 2: {
                        vdir = null;
                        udir = null;
                        if (iu0dir == 1) {
                            udir = bzs.controlPointAt(1, 0).subtract(bzs.controlPointAt(0, 0));
                        }
                        if (iv0dir == 1) {
                            if (udir == null) {
                                udir = bzs.controlPointAt(0, 1).subtract(bzs.controlPointAt(0, 0));
                            } else {
                                vdir = bzs.controlPointAt(0, 1).subtract(bzs.controlPointAt(0, 0));
                                break block5;
                            }
                        }
                        if (iu1dir == 1) {
                            if (udir == null) {
                                udir = bzs.controlPointAt(u_uicp - 2, v_uicp - 1).subtract(bzs.controlPointAt(u_uicp - 1, v_uicp - 1));
                                break block5;
                            }
                            if (iu0dir == 1) {
                                vdir = bzs.controlPointAt(1, v_uicp - 1).subtract(bzs.controlPointAt(0, v_uicp - 1));
                                break block5;
                            }
                            vdir = bzs.controlPointAt(u_uicp - 2, v_uicp - 1).subtract(bzs.controlPointAt(u_uicp - 1, v_uicp - 1));
                            break block5;
                        }
                        if (iv0dir == 1) {
                            vdir = bzs.controlPointAt(u_uicp - 1, 1).subtract(bzs.controlPointAt(u_uicp - 1, 0));
                            break block5;
                        }
                        vdir = bzs.controlPointAt(u_uicp - 1, v_uicp - 2).subtract(bzs.controlPointAt(u_uicp - 1, v_uicp - 1));
                        break block5;
                    }
                    default: {
                        if (retrying) {
                            return;
                        }
                        retrying = true;
                        u0dir = bzs.controlPointAt(1, 0).subtract(bzs.controlPointAt(0, 0));
                        v0dir = bzs.controlPointAt(0, 1).subtract(bzs.controlPointAt(0, 0));
                        u1dir = bzs.controlPointAt(u_uicp - 2, v_uicp - 1).subtract(bzs.controlPointAt(u_uicp - 1, v_uicp - 1));
                        v1dir = bzs.controlPointAt(u_uicp - 1, v_uicp - 2).subtract(bzs.controlPointAt(u_uicp - 1, v_uicp - 1));
                        continue block5;
                    }
                }
                break;
            }
            udir = udir.unitized();
            vdir = vdir.unitized();
            this.axis = new JgclAxis2Placement3D(c00, udir.crossProduct(vdir), udir);
        }

        JgclPoint3D origin() {
            return this.axis.location();
        }

        JgclVector3D zaxis() {
            return this.axis.z();
        }
    }

    final class PointInfo {
        JgclPoint3D pnt;
        double aParam;
        double bUParam;
        double bVParam;

        PointInfo(JgclPoint3D pnt, double aParam, double bUParam, double bVParam) {
            JgclIntsBzcBzs3D.this = JgclIntsBzcBzs3D.this;
            this.pnt = pnt;
            this.aParam = aParam;
            this.bUParam = bUParam;
            this.bVParam = bVParam;
        }
    }

    private class nlFunc
    implements JgclRealFunction {
        private nlFunc() {
            JgclIntsBzcBzs3D.this = JgclIntsBzcBzs3D.this;
        }

        public double[] evaluate(double[] parameter) {
            JgclVector3D evec = JgclIntsBzcBzs3D.this.sApnt.subtract(JgclIntsBzcBzs3D.this.sBpnt);
            double[] vec = new double[]{evec.x(), evec.y(), evec.z()};
            return vec;
        }
    }

    private class dnlFunc1
    implements JgclRealFunction {
        private dnlFunc1() {
            JgclIntsBzcBzs3D.this = JgclIntsBzcBzs3D.this;
        }

        public double[] evaluate(double[] parameter) {
            JgclIntsBzcBzs3D.this.aTang = JgclIntsBzcBzs3D.this.dA.tangentVector(JgclIntsBzcBzs3D.this.dA.parameterDomain().force(parameter[0]));
            JgclIntsBzcBzs3D.this.bTang = JgclIntsBzcBzs3D.this.dB.tangentVector(JgclIntsBzcBzs3D.this.dB.uParameterDomain().force(parameter[1]), JgclIntsBzcBzs3D.this.dB.vParameterDomain().force(parameter[2]));
            double[] mtrx = new double[]{JgclIntsBzcBzs3D.this.aTang.x(), -JgclIntsBzcBzs3D.this.bTang[0].x(), -JgclIntsBzcBzs3D.this.bTang[1].x()};
            return mtrx;
        }
    }

    private class dnlFunc2
    implements JgclRealFunction {
        private dnlFunc2() {
            JgclIntsBzcBzs3D.this = JgclIntsBzcBzs3D.this;
        }

        public double[] evaluate(double[] parameter) {
            double[] mtrx = new double[]{JgclIntsBzcBzs3D.this.aTang.y(), -JgclIntsBzcBzs3D.this.bTang[0].y(), -JgclIntsBzcBzs3D.this.bTang[1].y()};
            return mtrx;
        }
    }

    private class dnlFunc3
    implements JgclRealFunction {
        private dnlFunc3() {
            JgclIntsBzcBzs3D.this = JgclIntsBzcBzs3D.this;
        }

        public double[] evaluate(double[] parameter) {
            double[] mtrx = new double[]{JgclIntsBzcBzs3D.this.aTang.z(), -JgclIntsBzcBzs3D.this.bTang[0].z(), -JgclIntsBzcBzs3D.this.bTang[1].z()};
            return mtrx;
        }
    }

    private class cnvFunc
    implements JgclBooleanFunctionWithRealVariables {
        private cnvFunc() {
            JgclIntsBzcBzs3D.this = JgclIntsBzcBzs3D.this;
        }

        public boolean evaluate(double[] parameter) {
            JgclIntsBzcBzs3D.this.sApnt = JgclIntsBzcBzs3D.this.dA.coordinates(JgclIntsBzcBzs3D.this.dA.parameterDomain().force(parameter[0]));
            JgclIntsBzcBzs3D.this.sBpnt = JgclIntsBzcBzs3D.this.dB.coordinates(JgclIntsBzcBzs3D.this.dB.uParameterDomain().force(parameter[1]), JgclIntsBzcBzs3D.this.dB.vParameterDomain().force(parameter[2]));
            return JgclIntsBzcBzs3D.this.sApnt.identical(JgclIntsBzcBzs3D.this.sBpnt);
        }
    }
}

