/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Vector;
import jp.go.ipa.jgcl.JgclBinaryTree;
import jp.go.ipa.jgcl.JgclBooleanFunctionWithRealVariables;
import jp.go.ipa.jgcl.JgclBoundedLine3D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCurveCurveInterference3D;
import jp.go.ipa.jgcl.JgclCurveCurveInterferenceList;
import jp.go.ipa.jgcl.JgclEnclosingBox3D;
import jp.go.ipa.jgcl.JgclGeometry;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclOverlapCurve3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclRealFunction;
import jp.go.ipa.jgcl.JgclVector3D;

class JgclIntsBzcBzc3D {
    private JgclPureBezierCurve3D dA;
    private JgclPureBezierCurve3D dB;
    private JgclBinaryTree Atree;
    private JgclCurveCurveInterferenceList sol_list;
    static final int IGNORE_X = 0;
    static final int IGNORE_Y = 1;
    static final int IGNORE_Z = 2;
    private int ignoredDimension;
    private JgclPoint3D sApnt;
    private JgclPoint3D sBpnt;
    private JgclVector3D sAtang;
    private JgclVector3D sBtang;
    private static final int UNKNOWN = 0;
    private static final int BEZIER = 1;
    private static final int LINE = 2;
    private static final int POINT = 3;

    private JgclIntsBzcBzc3D(JgclPureBezierCurve3D bzc1, JgclPureBezierCurve3D bzc2) {
        this.dA = bzc1;
        this.dB = bzc2;
        double d_tol = this.dA.getToleranceForDistance();
        this.Atree = new JgclBinaryTree(new BezierInfo(this.dA, 0.0, 1.0, false));
        this.sol_list = new JgclCurveCurveInterferenceList(bzc1, bzc2);
    }

    private boolean checkLineBezier(BezierInfo dA, BezierInfo dB) {
        if (dA.crnt_type == 2 && (dB.crnt_type == 0 || dB.crnt_type == 1)) {
            double max_y;
            double max_x;
            JgclEnclosingBox3D bx = dB.box;
            JgclVector3D[] xyz = new JgclVector3D[3];
            JgclPoint3D[] box_pnts = new JgclPoint3D[8];
            double d_tol = dA.bzc.getToleranceForDistance();
            JgclLine3D line = dA.line();
            xyz[2] = line.dir();
            xyz[0] = xyz[2].verticalVector();
            xyz[1] = xyz[2].crossProduct(xyz[0]);
            JgclCartesianTransformationOperator3D trns = new JgclCartesianTransformationOperator3D(xyz[0], xyz[1], xyz[2], line.pnt(), 1.0);
            box_pnts[0] = new JgclCartesianPoint3D(bx.min().x(), bx.min().y(), bx.min().z());
            box_pnts[1] = new JgclCartesianPoint3D(bx.max().x(), bx.min().y(), bx.min().z());
            box_pnts[2] = new JgclCartesianPoint3D(bx.max().x(), bx.max().y(), bx.min().z());
            box_pnts[3] = new JgclCartesianPoint3D(bx.min().x(), bx.max().y(), bx.min().z());
            box_pnts[4] = new JgclCartesianPoint3D(bx.min().x(), bx.min().y(), bx.max().z());
            box_pnts[5] = new JgclCartesianPoint3D(bx.max().x(), bx.min().y(), bx.max().z());
            box_pnts[6] = new JgclCartesianPoint3D(bx.max().x(), bx.max().y(), bx.max().z());
            box_pnts[7] = new JgclCartesianPoint3D(bx.min().x(), bx.max().y(), bx.max().z());
            box_pnts[0] = trns.toLocal(box_pnts[0]);
            double min_x = max_x = box_pnts[0].x();
            double min_y = max_y = box_pnts[0].y();
            int i = 1;
            while (i < 8) {
                box_pnts[i] = trns.toLocal(box_pnts[i]);
                min_x = Math.min(box_pnts[i].x(), min_x);
                min_y = Math.min(box_pnts[i].y(), min_y);
                max_x = Math.max(box_pnts[i].x(), max_x);
                max_y = Math.max(box_pnts[i].y(), max_y);
                ++i;
            }
            if (!(min_x < d_tol && min_y < d_tol && max_x > -d_tol && max_y > -d_tol)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkInterfere(BezierInfo dA, BezierInfo dB) {
        if (!this.checkLineBezier(dA, dB)) {
            return false;
        }
        if (!this.checkLineBezier(dB, dA)) {
            return false;
        }
        return dA.box.hasIntersection(dB.box);
    }

    private boolean divideRivals(JgclBinaryTree.Node dANode, Vector new_rivals) {
        JgclBinaryTree.Node binR;
        JgclBinaryTree.Node binL;
        if (dANode.left() == null && dANode.right() == null) {
            BezierInfo bi = (BezierInfo)dANode.data();
            if (bi.whatTypeIsBezier() != 1) {
                new_rivals.addElement(dANode);
                return false;
            }
            double half_point = 0.5;
            JgclPureBezierCurve3D[] bzcs = bi.bzc.divide(half_point);
            double g_half_point = (bi.sp + bi.ep) / 2.0;
            BezierInfo biL = new BezierInfo(bzcs[0], bi.sp, g_half_point, false);
            binL = dANode.makeLeft(biL);
            BezierInfo biR = new BezierInfo(bzcs[1], g_half_point, bi.ep, false);
            binR = dANode.makeRight(biR);
        } else {
            binL = dANode.left();
            binR = dANode.right();
        }
        new_rivals.addElement(binL);
        new_rivals.addElement(binR);
        return true;
    }

    private PointInfo intersectPntLine(BezierInfo pbi, BezierInfo lbi) {
        JgclPoint3D pnt = pbi.pnt();
        JgclLine3D line = lbi.line();
        JgclBoundedLine3D bln = new JgclBoundedLine3D(line.pnt(), line.dir());
        JgclPointOnCurve3D poc = bln.project1From(pnt);
        if (poc == null) {
            return null;
        }
        double Apara = (pbi.sp + pbi.ep) / 2.0;
        double Bpara = lbi.toBezierParam(poc.parameter());
        return new PointInfo(poc.x(), poc.y(), poc.z(), Apara, Bpara);
    }

    private double[] setupParams(PointInfo pinfo) {
        JgclVector3D ecrs;
        JgclVector3D Btang;
        double[] param = new double[]{pinfo.Apara, pinfo.Bpara};
        double Apara = this.dA.parameterDomain().force(param[0]);
        double Bpara = this.dB.parameterDomain().force(param[1]);
        JgclVector3D Atang = this.dA.tangentVector(Apara);
        if (Atang.identical(JgclVector3D.zeroVector)) {
            Apara = Apara < 0.5 ? (Apara += 0.01) : (Apara -= 0.01);
            Atang = this.dA.tangentVector(Apara);
        }
        if ((Btang = this.dB.tangentVector(Bpara)).identical(JgclVector3D.zeroVector)) {
            Bpara = Bpara < 0.5 ? (Bpara += 0.01) : (Bpara -= 0.01);
            Btang = this.dB.tangentVector(Bpara);
        }
        int n = this.ignoredDimension = Math.abs((ecrs = Atang.crossProduct(Btang)).x()) > Math.abs(ecrs.y()) ? 0 : 1;
        if (this.ignoredDimension == 0) {
            if (Math.abs(ecrs.x()) < Math.abs(ecrs.z())) {
                this.ignoredDimension = 2;
            }
        } else if (Math.abs(ecrs.y()) < Math.abs(ecrs.z())) {
            this.ignoredDimension = 2;
        }
        return param;
    }

    private void setbackParams(PointInfo pi, double[] param) {
        pi.Apara = this.dA.parameterDomain().force(param[0]);
        pi.Bpara = this.dB.parameterDomain().force(param[1]);
        JgclPoint3D Apnt = this.dA.coordinates(pi.Apara);
        JgclPoint3D Bpnt = this.dB.coordinates(pi.Bpara);
        pi.pnt = Apnt.linearInterpolate(Bpnt, 0.5);
    }

    private boolean refinePointInfo(PointInfo pinfo) {
        nlFunc nl_func = new nlFunc();
        JgclRealFunction[] dnl_func = new JgclRealFunction[]{new dnlFunc(0), new dnlFunc(1)};
        cnvFunc cnv_func = new cnvFunc();
        double[] param = this.setupParams(pinfo);
        if ((param = JgclMath.solveSimultaneousEquations(nl_func, dnl_func, cnv_func, param)) == null) {
            return false;
        }
        this.setbackParams(pinfo, param);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void intersectLines(BezierInfo dA, BezierInfo dB) {
        PointInfo ints_pnt;
        if (dA.crnt_type == 3) {
            if (dB.crnt_type == 3) {
                double x = (dA.pnt().x() + dB.pnt().x()) / 2.0;
                double y = (dA.pnt().y() + dB.pnt().y()) / 2.0;
                double z = (dA.pnt().z() + dB.pnt().z()) / 2.0;
                double Apara = (dA.sp + dA.ep) / 2.0;
                double Bpara = (dB.sp + dB.ep) / 2.0;
                ints_pnt = new PointInfo(x, y, z, Apara, Bpara);
            } else {
                ints_pnt = this.intersectPntLine(dA, dB);
                if (ints_pnt == null) {
                    return;
                }
            }
        } else {
            if (dA.crnt_type != 2) {
                return;
            }
            if (dB.crnt_type == 2) {
                JgclBoundedLine3D Bbln;
                JgclBoundedLine3D Abln = new JgclBoundedLine3D(dA.bzc.controlPointAt(0), dA.bzc.controlPointAt(dA.bzc.nControlPoints() - 1));
                JgclCurveCurveInterference3D intf = Abln.interfere1(Bbln = new JgclBoundedLine3D(dB.bzc.controlPointAt(0), dB.bzc.controlPointAt(dB.bzc.nControlPoints() - 1)));
                if (intf == null) {
                    return;
                }
                if (!intf.isIntersectionPoint()) {
                    JgclOverlapCurve3D ovlp = intf.toOverlapCurve();
                    double x1 = dA.toBezierParam(ovlp.start1());
                    double y1 = dB.toBezierParam(ovlp.start2());
                    double x2 = dA.toBezierParam(ovlp.end1());
                    double y2 = dB.toBezierParam(ovlp.end2());
                    this.sol_list.addAsOverlap(x1, y1, x2 - x1, y2 - y1);
                    return;
                }
                JgclIntersectionPoint3D ints = intf.toIntersectionPoint();
                double Apara = dA.toBezierParam(ints.pointOnCurve1().parameter());
                double Bpara = dB.toBezierParam(ints.pointOnCurve2().parameter());
                ints_pnt = new PointInfo(ints.x(), ints.y(), ints.z(), Apara, Bpara);
            } else {
                ints_pnt = this.intersectPntLine(dB, dA);
                if (ints_pnt == null) {
                    return;
                }
            }
        }
        if (this.refinePointInfo(ints_pnt)) {
            this.sol_list.addAsIntersection(ints_pnt.pnt, ints_pnt.Apara, ints_pnt.Bpara);
        }
    }

    private void getIntersections(BezierInfo crnt_bi) {
        JgclBinaryTree.Node dANode;
        int n_rivals = crnt_bi.rivals.size();
        int i = n_rivals - 1;
        while (i >= 0) {
            dANode = (JgclBinaryTree.Node)crnt_bi.rivals.elementAt(i);
            if (!this.checkInterfere((BezierInfo)dANode.data(), crnt_bi)) {
                crnt_bi.rivals.removeElementAt(i);
            }
            --i;
        }
        if (crnt_bi.rivals.size() == 0) {
            return;
        }
        if (crnt_bi.whatTypeIsBezier() != 1) {
            Vector new_rivals = new Vector();
            boolean all_rivals_are_line = true;
            n_rivals = crnt_bi.rivals.size();
            i = 0;
            while (i < n_rivals) {
                if (this.divideRivals((JgclBinaryTree.Node)crnt_bi.rivals.elementAt(i), new_rivals)) {
                    all_rivals_are_line = false;
                }
                ++i;
            }
            crnt_bi.rivals = new_rivals;
            if (!all_rivals_are_line) {
                this.getIntersections(crnt_bi);
            } else {
                n_rivals = crnt_bi.rivals.size();
                i = 0;
                while (i < n_rivals) {
                    dANode = (JgclBinaryTree.Node)crnt_bi.rivals.elementAt(i);
                    this.intersectLines((BezierInfo)dANode.data(), crnt_bi);
                    ++i;
                }
            }
            return;
        }
        double half_point = 0.5;
        JgclPureBezierCurve3D[] bzcs = crnt_bi.bzc.divide(half_point);
        double g_half_point = (crnt_bi.sp + crnt_bi.ep) / 2.0;
        BezierInfo biL = new BezierInfo(bzcs[0], crnt_bi.sp, g_half_point, true);
        BezierInfo biR = new BezierInfo(bzcs[1], g_half_point, crnt_bi.ep, true);
        n_rivals = crnt_bi.rivals.size();
        i = 0;
        while (i < n_rivals) {
            this.divideRivals((JgclBinaryTree.Node)crnt_bi.rivals.elementAt(i), biL.rivals);
            ++i;
        }
        n_rivals = biL.rivals.size();
        i = 0;
        while (i < n_rivals) {
            biR.rivals.addElement(biL.rivals.elementAt(i));
            ++i;
        }
        this.getIntersections(biL);
        this.getIntersections(biR);
    }

    private JgclCurveCurveInterferenceList getInterference() {
        BezierInfo dBRoot = new BezierInfo(this.dB, 0.0, 1.0, true);
        dBRoot.rivals.addElement(this.Atree.rootNode());
        this.getIntersections(dBRoot);
        this.sol_list.removeOverlapsContainedInOtherOverlap();
        this.sol_list.removeIntersectionsContainedInOverlap();
        return this.sol_list;
    }

    static JgclIntersectionPoint3D[] intersection(JgclPureBezierCurve3D bzc1, JgclPureBezierCurve3D bzc2, boolean doExchange) {
        JgclIntsBzcBzc3D doObj = new JgclIntsBzcBzc3D(bzc1, bzc2);
        return doObj.getInterference().toJgclIntersectionPoint3DArray(doExchange);
    }

    static JgclCurveCurveInterference3D[] interference(JgclPureBezierCurve3D bzc1, JgclPureBezierCurve3D bzc2, boolean doExchange) {
        JgclIntsBzcBzc3D doObj = new JgclIntsBzcBzc3D(bzc1, bzc2);
        return doObj.getInterference().toJgclCurveCurveInterference3DArray(doExchange);
    }

    static /* synthetic */ int access$11() {
        return 0;
    }

    static /* synthetic */ int access$12() {
        return 3;
    }

    static /* synthetic */ int access$13() {
        return 1;
    }

    static /* synthetic */ int access$14() {
        return 2;
    }

    private class BezierInfo {
        private JgclPureBezierCurve3D bzc;
        private double sp;
        private double ep;
        private JgclEnclosingBox3D box;
        private Vector rivals;
        private int crnt_type;
        private JgclGeometry geom;

        private BezierInfo(JgclPureBezierCurve3D bzc, double sp, double ep, boolean hasRivals) {
            JgclIntsBzcBzc3D.this = JgclIntsBzcBzc3D.this;
            this.bzc = bzc;
            this.sp = sp;
            this.ep = ep;
            this.box = bzc.approximateEnclosingBox();
            this.rivals = hasRivals ? new Vector() : null;
            this.crnt_type = JgclIntsBzcBzc3D.access$11();
            this.geom = null;
        }

        private JgclPoint3D pnt() {
            return (JgclPoint3D)this.geom;
        }

        private JgclLine3D line() {
            return (JgclLine3D)this.geom;
        }

        private int whatTypeIsBezier() {
            if (this.crnt_type != JgclIntsBzcBzc3D.access$11()) {
                return this.crnt_type;
            }
            int uicp = this.bzc.nControlPoints();
            double d_tol = this.bzc.getToleranceForDistance();
            JgclVector3D s2e = this.bzc.controlPointAt(uicp - 1).subtract(this.bzc.controlPointAt(0));
            double leng_s2e = s2e.length();
            if (leng_s2e < d_tol) {
                int i = 1;
                while (i < uicp - 1) {
                    JgclVector3D s2c = this.bzc.controlPointAt(i).subtract(this.bzc.controlPointAt(0));
                    if (!(s2c.length() < d_tol)) break;
                    ++i;
                }
                if (i == uicp - 1) {
                    JgclPoint3D pnt_geom = this.bzc.controlPointAt(uicp - 1).linearInterpolate(this.bzc.controlPointAt(0), 0.5);
                    this.geom = pnt_geom;
                    this.crnt_type = JgclIntsBzcBzc3D.access$12();
                    return this.crnt_type;
                }
                this.geom = null;
                this.crnt_type = JgclIntsBzcBzc3D.access$13();
                return this.crnt_type;
            }
            JgclVector3D unit_s2e = s2e.divide(leng_s2e);
            int i = 1;
            while (i < uicp - 1) {
                JgclVector3D s2c = this.bzc.controlPointAt(i).subtract(this.bzc.controlPointAt(0));
                JgclVector3D crsv = unit_s2e.crossProduct(s2c);
                if (crsv.length() > d_tol) {
                    this.geom = null;
                    this.crnt_type = JgclIntsBzcBzc3D.access$13();
                    return this.crnt_type;
                }
                double leng = unit_s2e.dotProduct(s2c);
                if (leng < 0.0 - d_tol || leng > leng_s2e + d_tol) {
                    this.geom = null;
                    this.crnt_type = JgclIntsBzcBzc3D.access$13();
                    return this.crnt_type;
                }
                ++i;
            }
            JgclLine3D lin_geom = new JgclLine3D(this.bzc.controlPointAt(0), s2e);
            this.geom = lin_geom;
            this.crnt_type = JgclIntsBzcBzc3D.access$14();
            return this.crnt_type;
        }

        private double toBezierParam(double param) {
            return (1.0 - param) * this.sp + param * this.ep;
        }
    }

    private class PointInfo {
        private JgclPoint3D pnt;
        private double Apara;
        private double Bpara;

        private PointInfo(JgclPoint3D pnt, double Apara, double Bpara) {
            JgclIntsBzcBzc3D.this = JgclIntsBzcBzc3D.this;
            this.pnt = pnt;
            this.Apara = Apara;
            this.Bpara = Bpara;
        }

        private PointInfo(double x, double y, double z, double Apara, double Bpara) {
            JgclIntsBzcBzc3D.this = JgclIntsBzcBzc3D.this;
            this.pnt = new JgclCartesianPoint3D(x, y, z);
            this.Apara = Apara;
            this.Bpara = Bpara;
        }
    }

    private class nlFunc
    implements JgclRealFunction {
        private nlFunc() {
            JgclIntsBzcBzc3D.this = JgclIntsBzcBzc3D.this;
        }

        public double[] evaluate(double[] parameter) {
            double[] vctr = new double[2];
            JgclVector3D evec = JgclIntsBzcBzc3D.this.sApnt.subtract(JgclIntsBzcBzc3D.this.sBpnt);
            switch (JgclIntsBzcBzc3D.this.ignoredDimension) {
                case 0: {
                    vctr[0] = evec.y();
                    vctr[1] = evec.z();
                    break;
                }
                case 1: {
                    vctr[0] = evec.z();
                    vctr[1] = evec.x();
                    break;
                }
                case 2: {
                    vctr[0] = evec.x();
                    vctr[1] = evec.y();
                    break;
                }
            }
            return vctr;
        }
    }

    private class dnlFunc
    implements JgclRealFunction {
        int idx;

        private dnlFunc(int idx) {
            JgclIntsBzcBzc3D.this = JgclIntsBzcBzc3D.this;
            this.idx = idx;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public double[] evaluate(double[] parameter) {
            double[] mtrx = new double[2];
            if (this.idx == 0) {
                JgclIntsBzcBzc3D.this.sAtang = JgclIntsBzcBzc3D.this.dA.tangentVector(JgclIntsBzcBzc3D.this.dA.parameterDomain().force(parameter[0]));
                JgclIntsBzcBzc3D.this.sBtang = JgclIntsBzcBzc3D.this.dB.tangentVector(JgclIntsBzcBzc3D.this.dB.parameterDomain().force(parameter[1]));
                switch (JgclIntsBzcBzc3D.this.ignoredDimension) {
                    case 0: {
                        mtrx[0] = JgclIntsBzcBzc3D.this.sAtang.y();
                        mtrx[1] = -JgclIntsBzcBzc3D.this.sBtang.y();
                        return mtrx;
                    }
                    case 1: {
                        mtrx[0] = JgclIntsBzcBzc3D.this.sAtang.z();
                        mtrx[1] = -JgclIntsBzcBzc3D.this.sBtang.z();
                        return mtrx;
                    }
                    case 2: {
                        mtrx[0] = JgclIntsBzcBzc3D.this.sAtang.x();
                        mtrx[1] = -JgclIntsBzcBzc3D.this.sBtang.x();
                        return mtrx;
                    }
                    default: {
                        return mtrx;
                    }
                }
            }
            switch (JgclIntsBzcBzc3D.this.ignoredDimension) {
                case 0: {
                    mtrx[0] = JgclIntsBzcBzc3D.this.sAtang.z();
                    mtrx[1] = -JgclIntsBzcBzc3D.this.sBtang.z();
                    break;
                }
                case 1: {
                    mtrx[0] = JgclIntsBzcBzc3D.this.sAtang.x();
                    mtrx[1] = -JgclIntsBzcBzc3D.this.sBtang.x();
                    break;
                }
                case 2: {
                    mtrx[0] = JgclIntsBzcBzc3D.this.sAtang.y();
                    mtrx[1] = -JgclIntsBzcBzc3D.this.sBtang.y();
                }
            }
            return mtrx;
        }
    }

    private class cnvFunc
    implements JgclBooleanFunctionWithRealVariables {
        private cnvFunc() {
            JgclIntsBzcBzc3D.this = JgclIntsBzcBzc3D.this;
        }

        public boolean evaluate(double[] parameter) {
            JgclIntsBzcBzc3D.this.sApnt = JgclIntsBzcBzc3D.this.dA.coordinates(JgclIntsBzcBzc3D.this.dA.parameterDomain().force(parameter[0]));
            JgclIntsBzcBzc3D.this.sBpnt = JgclIntsBzcBzc3D.this.dB.coordinates(JgclIntsBzcBzc3D.this.dB.parameterDomain().force(parameter[1]));
            return JgclIntsBzcBzc3D.this.sApnt.identical(JgclIntsBzcBzc3D.this.sBpnt);
        }
    }
}

