/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Vector;
import jp.go.ipa.jgcl.JgclBinaryTree;
import jp.go.ipa.jgcl.JgclBooleanFunctionWithRealVariables;
import jp.go.ipa.jgcl.JgclBoundedLine2D;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCurveCurveInterference2D;
import jp.go.ipa.jgcl.JgclCurveCurveInterferenceList;
import jp.go.ipa.jgcl.JgclEnclosingBox2D;
import jp.go.ipa.jgcl.JgclGeometry;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclOverlapCurve2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;
import jp.go.ipa.jgcl.JgclRealFunction;
import jp.go.ipa.jgcl.JgclVector2D;

class JgclIntsBzcBzc2D {
    private static final double pTol = 0.001;
    private JgclPureBezierCurve2D dA;
    private JgclPureBezierCurve2D dB;
    private double aprx_ptolA;
    private double aprx_ptolB;
    private JgclBinaryTree Atree;
    private JgclCurveCurveInterferenceList sol_list;
    private JgclPoint2D sApnt;
    private JgclPoint2D sBpnt;
    private JgclVector2D sAtang;
    private JgclVector2D sBtang;
    private static final int UNKNOWN = 0;
    private static final int BEZIER = 1;
    private static final int LINE = 2;
    private static final int POINT = 3;

    private static double getPtol(double d_tol, double length) {
        double tol = d_tol / length * 10.0;
        if (tol < 0.001) {
            tol = 0.001;
        }
        return tol;
    }

    private JgclIntsBzcBzc2D(JgclPureBezierCurve2D bzc1, JgclPureBezierCurve2D bzc2) {
        this.dA = bzc1;
        this.dB = bzc2;
        double d_tol = this.dA.getToleranceForDistance();
        this.aprx_ptolA = JgclIntsBzcBzc2D.getPtol(d_tol, this.dA.approximateLength());
        this.aprx_ptolB = JgclIntsBzcBzc2D.getPtol(d_tol, this.dB.approximateLength());
        this.Atree = new JgclBinaryTree(new BezierInfo(this.dA, 0.0, 1.0, false));
        this.sol_list = new JgclCurveCurveInterferenceList(bzc1, bzc2);
    }

    private boolean checkLineBezier(BezierInfo dA, BezierInfo dB) {
        if (dA.crnt_type == 2 && (dB.crnt_type == 0 || dB.crnt_type == 1)) {
            JgclLine2D line = dA.line();
            JgclLine2D unit_line = new JgclLine2D(line.pnt(), line.dir().unitized());
            int uicp = dB.bzc.nControlPoints();
            int pside = unit_line.pointIsWhichSide(dB.bzc.controlPointAt(0));
            if (pside == 0) {
                return true;
            }
            int i = 1;
            while (i < uicp) {
                int cside = unit_line.pointIsWhichSide(dB.bzc.controlPointAt(i));
                if (pside != cside) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    private boolean checkInterfere(BezierInfo dA, BezierInfo dB) {
        if (!this.checkLineBezier(dA, dB)) {
            return false;
        }
        if (!this.checkLineBezier(dB, dA)) {
            return false;
        }
        return dA.box.hasIntersection(dB.box);
    }

    private boolean divideRivals(JgclBinaryTree.Node dANode, Vector new_rivals) {
        JgclBinaryTree.Node binR;
        JgclBinaryTree.Node binL;
        if (dANode.left() == null && dANode.right() == null) {
            BezierInfo bi = (BezierInfo)dANode.data();
            if (bi.whatTypeIsBezier() != 1) {
                new_rivals.addElement(dANode);
                return false;
            }
            double half_point = 0.5;
            JgclPureBezierCurve2D[] bzcs = bi.bzc.divide(half_point);
            double g_half_point = (bi.sp + bi.ep) / 2.0;
            BezierInfo biL = new BezierInfo(bzcs[0], bi.sp, g_half_point, false);
            binL = dANode.makeLeft(biL);
            BezierInfo biR = new BezierInfo(bzcs[1], g_half_point, bi.ep, false);
            binR = dANode.makeRight(biR);
        } else {
            binL = dANode.left();
            binR = dANode.right();
        }
        new_rivals.addElement(binL);
        new_rivals.addElement(binR);
        return true;
    }

    private PointInfo intersectPntLine(BezierInfo pbi, BezierInfo lbi) {
        JgclPoint2D pnt = pbi.pnt();
        JgclLine2D line = lbi.line();
        JgclBoundedLine2D bln = new JgclBoundedLine2D(line.pnt(), line.dir());
        JgclPointOnCurve2D poc = bln.project1From(pnt);
        if (poc == null) {
            return null;
        }
        double Apara = (pbi.sp + pbi.ep) / 2.0;
        double Bpara = lbi.toBezierParam(poc.parameter());
        return new PointInfo(poc.x(), poc.y(), Apara, Bpara);
    }

    private void setbackParams(PointInfo pi, double[] param) {
        pi.Apara = this.dA.parameterDomain().force(param[0]);
        pi.Bpara = this.dB.parameterDomain().force(param[1]);
        JgclPoint2D Apnt = this.dA.coordinates(pi.Apara);
        JgclPoint2D Bpnt = this.dB.coordinates(pi.Bpara);
        pi.pnt = Apnt.linearInterpolate(Bpnt, 0.5);
    }

    private boolean refinePointInfo(PointInfo pinfo) {
        nlFunc nl_func = new nlFunc();
        JgclRealFunction[] dnl_func = new JgclRealFunction[]{new dnlFunc(0), new dnlFunc(1)};
        cnvFunc cnv_func = new cnvFunc();
        double[] param = new double[]{pinfo.Apara, pinfo.Bpara};
        if ((param = JgclMath.solveSimultaneousEquations(nl_func, dnl_func, cnv_func, param)) == null) {
            return false;
        }
        this.setbackParams(pinfo, param);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void intersectLines(BezierInfo dA, BezierInfo dB) {
        PointInfo ints_pnt;
        if (dA.crnt_type == 3) {
            if (dB.crnt_type == 3) {
                double x = (dA.pnt().x() + dB.pnt().x()) / 2.0;
                double y = (dA.pnt().y() + dB.pnt().y()) / 2.0;
                double Apara = (dA.sp + dA.ep) / 2.0;
                double Bpara = (dB.sp + dB.ep) / 2.0;
                ints_pnt = new PointInfo(x, y, Apara, Bpara);
            } else {
                ints_pnt = this.intersectPntLine(dA, dB);
                if (ints_pnt == null) {
                    return;
                }
            }
        } else {
            if (dA.crnt_type != 2) {
                return;
            }
            if (dB.crnt_type == 2) {
                JgclBoundedLine2D Bbln;
                JgclBoundedLine2D Abln = new JgclBoundedLine2D(dA.bzc.controlPointAt(0), dA.bzc.controlPointAt(dA.bzc.nControlPoints() - 1));
                JgclCurveCurveInterference2D intf = Abln.interfere1(Bbln = new JgclBoundedLine2D(dB.bzc.controlPointAt(0), dB.bzc.controlPointAt(dB.bzc.nControlPoints() - 1)));
                if (intf == null) {
                    return;
                }
                if (!intf.isIntersectionPoint()) {
                    JgclOverlapCurve2D ovlp = intf.toOverlapCurve();
                    double x1 = dA.toBezierParam(ovlp.start1());
                    double y1 = dB.toBezierParam(ovlp.start2());
                    double x2 = dA.toBezierParam(ovlp.end1());
                    double y2 = dB.toBezierParam(ovlp.end2());
                    this.sol_list.addAsOverlap(x1, y1, x2 - x1, y2 - y1, this.aprx_ptolA, this.aprx_ptolB, this.aprx_ptolA, this.aprx_ptolB);
                    return;
                }
                JgclIntersectionPoint2D ints = intf.toIntersectionPoint();
                double Apara = dA.toBezierParam(ints.pointOnCurve1().parameter());
                double Bpara = dB.toBezierParam(ints.pointOnCurve2().parameter());
                ints_pnt = new PointInfo(ints.x(), ints.y(), Apara, Bpara);
            } else {
                ints_pnt = this.intersectPntLine(dB, dA);
                if (ints_pnt == null) {
                    return;
                }
            }
        }
        if (this.refinePointInfo(ints_pnt)) {
            this.sol_list.addAsIntersection(ints_pnt.pnt, ints_pnt.Apara, ints_pnt.Bpara, this.aprx_ptolA, this.aprx_ptolB);
        }
    }

    private void getIntersections(BezierInfo crnt_bi) {
        JgclBinaryTree.Node dANode;
        int n_rivals = crnt_bi.rivals.size();
        int i = n_rivals - 1;
        while (i >= 0) {
            dANode = (JgclBinaryTree.Node)crnt_bi.rivals.elementAt(i);
            if (!this.checkInterfere((BezierInfo)dANode.data(), crnt_bi)) {
                crnt_bi.rivals.removeElementAt(i);
            }
            --i;
        }
        if (crnt_bi.rivals.size() == 0) {
            return;
        }
        if (crnt_bi.whatTypeIsBezier() != 1) {
            Vector new_rivals = new Vector();
            boolean all_rivals_are_line = true;
            n_rivals = crnt_bi.rivals.size();
            i = 0;
            while (i < n_rivals) {
                if (this.divideRivals((JgclBinaryTree.Node)crnt_bi.rivals.elementAt(i), new_rivals)) {
                    all_rivals_are_line = false;
                }
                ++i;
            }
            crnt_bi.rivals = new_rivals;
            if (!all_rivals_are_line) {
                this.getIntersections(crnt_bi);
            } else {
                n_rivals = crnt_bi.rivals.size();
                i = 0;
                while (i < n_rivals) {
                    dANode = (JgclBinaryTree.Node)crnt_bi.rivals.elementAt(i);
                    this.intersectLines((BezierInfo)dANode.data(), crnt_bi);
                    ++i;
                }
            }
            return;
        }
        double half_point = 0.5;
        JgclPureBezierCurve2D[] bzcs = crnt_bi.bzc.divide(half_point);
        double g_half_point = (crnt_bi.sp + crnt_bi.ep) / 2.0;
        BezierInfo biL = new BezierInfo(bzcs[0], crnt_bi.sp, g_half_point, true);
        BezierInfo biR = new BezierInfo(bzcs[1], g_half_point, crnt_bi.ep, true);
        n_rivals = crnt_bi.rivals.size();
        i = 0;
        while (i < n_rivals) {
            this.divideRivals((JgclBinaryTree.Node)crnt_bi.rivals.elementAt(i), biL.rivals);
            ++i;
        }
        n_rivals = biL.rivals.size();
        i = 0;
        while (i < n_rivals) {
            biR.rivals.addElement(biL.rivals.elementAt(i));
            ++i;
        }
        this.getIntersections(biL);
        this.getIntersections(biR);
    }

    private JgclCurveCurveInterferenceList getInterference() {
        BezierInfo dBRoot = new BezierInfo(this.dB, 0.0, 1.0, true);
        dBRoot.rivals.addElement(this.Atree.rootNode());
        this.getIntersections(dBRoot);
        this.sol_list.removeOverlapsContainedInOtherOverlap();
        this.sol_list.removeIntersectionsContainedInOverlap();
        return this.sol_list;
    }

    static JgclIntersectionPoint2D[] intersection(JgclPureBezierCurve2D bzc1, JgclPureBezierCurve2D bzc2, boolean doExchange) {
        JgclIntsBzcBzc2D doObj = new JgclIntsBzcBzc2D(bzc1, bzc2);
        return doObj.getInterference().toJgclIntersectionPoint2DArray(doExchange);
    }

    static JgclCurveCurveInterference2D[] interference(JgclPureBezierCurve2D bzc1, JgclPureBezierCurve2D bzc2, boolean doExchange) {
        JgclIntsBzcBzc2D doObj = new JgclIntsBzcBzc2D(bzc1, bzc2);
        return doObj.getInterference().toJgclCurveCurveInterference2DArray(doExchange);
    }

    static /* synthetic */ int access$10() {
        return 0;
    }

    static /* synthetic */ int access$11() {
        return 3;
    }

    static /* synthetic */ int access$12() {
        return 1;
    }

    static /* synthetic */ int access$13() {
        return 2;
    }

    private class BezierInfo {
        private JgclPureBezierCurve2D bzc;
        private double sp;
        private double ep;
        private JgclEnclosingBox2D box;
        private Vector rivals;
        private int crnt_type;
        private JgclGeometry geom;

        private BezierInfo(JgclPureBezierCurve2D bzc, double sp, double ep, boolean hasRivals) {
            JgclIntsBzcBzc2D.this = JgclIntsBzcBzc2D.this;
            this.bzc = bzc;
            this.sp = sp;
            this.ep = ep;
            this.box = bzc.approximateEnclosingBox();
            this.rivals = hasRivals ? new Vector() : null;
            this.crnt_type = JgclIntsBzcBzc2D.access$10();
            this.geom = null;
        }

        private JgclPoint2D pnt() {
            return (JgclPoint2D)this.geom;
        }

        private JgclLine2D line() {
            return (JgclLine2D)this.geom;
        }

        private int whatTypeIsBezier() {
            if (this.crnt_type != JgclIntsBzcBzc2D.access$10()) {
                return this.crnt_type;
            }
            int uicp = this.bzc.nControlPoints();
            double d_tol = this.bzc.getToleranceForDistance();
            JgclVector2D s2e = this.bzc.controlPointAt(uicp - 1).subtract(this.bzc.controlPointAt(0));
            double leng_s2e = s2e.length();
            if (leng_s2e < d_tol) {
                int i = 1;
                while (i < uicp - 1) {
                    JgclVector2D s2c = this.bzc.controlPointAt(i).subtract(this.bzc.controlPointAt(0));
                    if (!(s2c.length() < d_tol)) break;
                    ++i;
                }
                if (i == uicp - 1) {
                    JgclPoint2D pnt_geom = this.bzc.controlPointAt(uicp - 1).linearInterpolate(this.bzc.controlPointAt(0), 0.5);
                    this.geom = pnt_geom;
                    this.crnt_type = JgclIntsBzcBzc2D.access$11();
                    return this.crnt_type;
                }
                this.geom = null;
                this.crnt_type = JgclIntsBzcBzc2D.access$12();
                return this.crnt_type;
            }
            JgclVector2D unit_s2e = s2e.divide(leng_s2e);
            int i = 1;
            while (i < uicp - 1) {
                JgclVector2D s2c = this.bzc.controlPointAt(i).subtract(this.bzc.controlPointAt(0));
                double dist = unit_s2e.zOfCrossProduct(s2c);
                if (Math.abs(dist) > d_tol) {
                    this.geom = null;
                    this.crnt_type = JgclIntsBzcBzc2D.access$12();
                    return this.crnt_type;
                }
                double leng = unit_s2e.dotProduct(s2c);
                if (leng < 0.0 - d_tol || leng > leng_s2e + d_tol) {
                    this.geom = null;
                    this.crnt_type = JgclIntsBzcBzc2D.access$12();
                    return this.crnt_type;
                }
                ++i;
            }
            JgclLine2D lin_geom = new JgclLine2D(this.bzc.controlPointAt(0), s2e);
            this.geom = lin_geom;
            this.crnt_type = JgclIntsBzcBzc2D.access$13();
            return this.crnt_type;
        }

        private double toBezierParam(double param) {
            return (1.0 - param) * this.sp + param * this.ep;
        }
    }

    private class PointInfo {
        private JgclPoint2D pnt;
        private double Apara;
        private double Bpara;

        private PointInfo(JgclPoint2D pnt, double Apara, double Bpara) {
            JgclIntsBzcBzc2D.this = JgclIntsBzcBzc2D.this;
            this.pnt = pnt;
            this.Apara = Apara;
            this.Bpara = Bpara;
        }

        private PointInfo(double x, double y, double Apara, double Bpara) {
            JgclIntsBzcBzc2D.this = JgclIntsBzcBzc2D.this;
            this.pnt = new JgclCartesianPoint2D(x, y);
            this.Apara = Apara;
            this.Bpara = Bpara;
        }
    }

    private class nlFunc
    implements JgclRealFunction {
        private nlFunc() {
            JgclIntsBzcBzc2D.this = JgclIntsBzcBzc2D.this;
        }

        public double[] evaluate(double[] parameter) {
            double[] vctr = new double[2];
            JgclVector2D evec = JgclIntsBzcBzc2D.this.sApnt.subtract(JgclIntsBzcBzc2D.this.sBpnt);
            vctr[0] = evec.x();
            vctr[1] = evec.y();
            return vctr;
        }
    }

    private class dnlFunc
    implements JgclRealFunction {
        int idx;

        private dnlFunc(int idx) {
            JgclIntsBzcBzc2D.this = JgclIntsBzcBzc2D.this;
            this.idx = idx;
        }

        public double[] evaluate(double[] parameter) {
            double[] mtrx = new double[2];
            if (this.idx == 0) {
                JgclIntsBzcBzc2D.this.sAtang = JgclIntsBzcBzc2D.this.dA.tangentVector(JgclIntsBzcBzc2D.this.dA.parameterDomain().force(parameter[0]));
                JgclIntsBzcBzc2D.this.sBtang = JgclIntsBzcBzc2D.this.dB.tangentVector(JgclIntsBzcBzc2D.this.dB.parameterDomain().force(parameter[1]));
                mtrx[0] = JgclIntsBzcBzc2D.this.sAtang.x();
                mtrx[1] = -JgclIntsBzcBzc2D.this.sBtang.x();
            } else {
                mtrx[0] = JgclIntsBzcBzc2D.this.sAtang.y();
                mtrx[1] = -JgclIntsBzcBzc2D.this.sBtang.y();
            }
            return mtrx;
        }
    }

    private class cnvFunc
    implements JgclBooleanFunctionWithRealVariables {
        private cnvFunc() {
            JgclIntsBzcBzc2D.this = JgclIntsBzcBzc2D.this;
        }

        public boolean evaluate(double[] parameter) {
            JgclIntsBzcBzc2D.this.sApnt = JgclIntsBzcBzc2D.this.dA.coordinates(JgclIntsBzcBzc2D.this.dA.parameterDomain().force(parameter[0]));
            JgclIntsBzcBzc2D.this.sBpnt = JgclIntsBzcBzc2D.this.dB.coordinates(JgclIntsBzcBzc2D.this.dB.parameterDomain().force(parameter[1]));
            return JgclIntsBzcBzc2D.this.sApnt.identical(JgclIntsBzcBzc2D.this.sBpnt);
        }
    }
}

