/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclCurveCurveInterference2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclOverlapCurve2D;
import jp.go.ipa.jgcl.JgclParameterConversion2D;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;

public class JgclIntersectionPoint2D
extends JgclPoint2D
implements JgclCurveCurveInterference2D {
    private final JgclPoint2D coordinates;
    private final JgclPointOnCurve2D pointOnCurve1;
    private final JgclPointOnCurve2D pointOnCurve2;

    private void checkPoints() {
        if (!(this.coordinates.identical(this.pointOnCurve1) && this.coordinates.identical(this.pointOnCurve2) && this.pointOnCurve1.identical(this.pointOnCurve2))) {
            throw new JgclInvalidArgumentValue();
        }
    }

    JgclIntersectionPoint2D(JgclPoint2D coordinates, JgclPointOnCurve2D pointOnCurve1, JgclPointOnCurve2D pointOnCurve2, boolean doCheck) {
        this.coordinates = coordinates;
        this.pointOnCurve1 = pointOnCurve1;
        this.pointOnCurve2 = pointOnCurve2;
        if (doCheck) {
            this.checkPoints();
        }
    }

    JgclIntersectionPoint2D(JgclPointOnCurve2D pointOnCurve1, JgclPointOnCurve2D pointOnCurve2, boolean doCheck) {
        this.pointOnCurve1 = pointOnCurve1;
        this.pointOnCurve2 = pointOnCurve2;
        this.coordinates = this.pointOnCurve1.linearInterpolate(this.pointOnCurve2, 0.5);
        if (doCheck) {
            this.checkPoints();
        }
    }

    JgclIntersectionPoint2D(JgclPoint2D coordinates, JgclParametricCurve2D curve1, double param1, JgclParametricCurve2D curve2, double param2, boolean doCheck) {
        this.coordinates = coordinates;
        this.pointOnCurve1 = new JgclPointOnCurve2D(curve1, param1, false);
        this.pointOnCurve2 = new JgclPointOnCurve2D(curve2, param2, false);
        if (doCheck) {
            this.checkPoints();
        }
    }

    JgclIntersectionPoint2D(JgclParametricCurve2D curve1, double param1, JgclParametricCurve2D curve2, double param2, boolean doCheck) {
        this.pointOnCurve1 = new JgclPointOnCurve2D(curve1, param1, false);
        this.pointOnCurve2 = new JgclPointOnCurve2D(curve2, param2, false);
        this.coordinates = this.pointOnCurve1.linearInterpolate(this.pointOnCurve2, 0.5);
        if (doCheck) {
            this.checkPoints();
        }
    }

    public double x() {
        return this.coordinates.x();
    }

    public double y() {
        return this.coordinates.y();
    }

    public JgclPoint2D coordinates() {
        return this.coordinates;
    }

    public JgclPointOnCurve2D pointOnCurve1() {
        return this.pointOnCurve1;
    }

    public JgclPointOnCurve2D pointOnCurve2() {
        return this.pointOnCurve2;
    }

    public boolean isIntersectionPoint() {
        return true;
    }

    public boolean isOverlapCurve() {
        return false;
    }

    public JgclIntersectionPoint2D toIntersectionPoint() {
        return this;
    }

    public JgclOverlapCurve2D toOverlapCurve() {
        return null;
    }

    public JgclIntersectionPoint2D exchange() {
        JgclIntersectionPoint2D ex = new JgclIntersectionPoint2D(this.coordinates, this.pointOnCurve2, this.pointOnCurve1, false);
        return ex;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JgclCurveCurveInterference2D trim1(JgclParameterSection sec, JgclParameterConversion2D conv) {
        double param;
        block2: {
            JgclCurveCurveInterference2D jgclCurveCurveInterference2D;
            param = this.pointOnCurve1.parameter();
            JgclParametricCurve2D curve = (JgclParametricCurve2D)this.pointOnCurve1.geometry();
            JgclConditionOfOperation cond = JgclConditionOfOperation.getCondition();
            cond.makeCopy(cond.getToleranceForDistanceAsObject().toToleranceForParameter(curve, param)).push();
            try {
                if (sec.isValid(param)) break block2;
                jgclCurveCurveInterference2D = null;
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                JgclConditionOfOperation.pop();
                throw throwable;
            }
            JgclConditionOfOperation.pop();
            return jgclCurveCurveInterference2D;
        }
        Object var9_9 = null;
        JgclConditionOfOperation.pop();
        JgclPointOnCurve2D poc = conv.convToPoint(param);
        return new JgclIntersectionPoint2D(poc, this.pointOnCurve2, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JgclCurveCurveInterference2D trim2(JgclParameterSection sec, JgclParameterConversion2D conv) {
        double param;
        block2: {
            JgclCurveCurveInterference2D jgclCurveCurveInterference2D;
            param = this.pointOnCurve2.parameter();
            JgclParametricCurve2D curve = (JgclParametricCurve2D)this.pointOnCurve2.geometry();
            JgclConditionOfOperation cond = JgclConditionOfOperation.getCondition();
            cond.makeCopy(cond.getToleranceForDistanceAsObject().toToleranceForParameter(curve, param)).push();
            try {
                if (sec.isValid(param)) break block2;
                jgclCurveCurveInterference2D = null;
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                JgclConditionOfOperation.pop();
                throw throwable;
            }
            JgclConditionOfOperation.pop();
            return jgclCurveCurveInterference2D;
        }
        Object var9_9 = null;
        JgclConditionOfOperation.pop();
        JgclPointOnCurve2D poc = conv.convToPoint(param);
        return new JgclIntersectionPoint2D(this.pointOnCurve1, poc, false);
    }

    public JgclCurveCurveInterference2D changeCurve1(JgclParametricCurve2D newCurve) {
        JgclPointOnCurve2D newPointOnCurve1 = new JgclPointOnCurve2D(newCurve, this.pointOnCurve1.parameter(), false);
        return new JgclIntersectionPoint2D(newPointOnCurve1, this.pointOnCurve2, false);
    }

    public JgclCurveCurveInterference2D changeCurve2(JgclParametricCurve2D newCurve) {
        JgclPointOnCurve2D newPointOnCurve2 = new JgclPointOnCurve2D(newCurve, this.pointOnCurve2.parameter(), false);
        return new JgclIntersectionPoint2D(this.pointOnCurve1, newPointOnCurve2, false);
    }

    protected synchronized JgclPoint2D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint2D tCoordinates = this.coordinates.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        JgclPointOnCurve2D tPointOnCurve1 = (JgclPointOnCurve2D)this.pointOnCurve1.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        JgclPointOnCurve2D tPointOnCurve2 = (JgclPointOnCurve2D)this.pointOnCurve2.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        return new JgclIntersectionPoint2D(tCoordinates, tPointOnCurve1, tPointOnCurve2, false);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tcoordinates");
        this.coordinates.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tpointOnCurve1");
        this.pointOnCurve1.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tpointOnCurve2");
        this.pointOnCurve2.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

