/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclMatrix;

final class JgclInterpolation {
    final double[] params;
    final int uip;
    private double[] pInt;
    final JgclMatrix matrix;
    final boolean isClosed;

    JgclInterpolation(double[] params) {
        if (params.length < 2) {
            throw new JgclInvalidArgumentValue();
        }
        this.params = params;
        this.isClosed = false;
        this.uip = params.length;
        this.pInt = this.getInterval();
        this.matrix = this.setupLinearSystem();
        this.computeLeftSideLinearSystem();
    }

    JgclInterpolation(double[] params, boolean isClosed) {
        if (params.length < 2) {
            throw new JgclInvalidArgumentValue();
        }
        this.params = params;
        this.isClosed = isClosed;
        this.uip = this.isClosed ? params.length - 1 : params.length;
        this.pInt = this.getInterval();
        if (!isClosed) {
            this.matrix = this.setupLinearSystem();
            this.computeLeftSideLinearSystem();
        } else {
            this.matrix = this.setupLinearSystemClosed();
        }
    }

    double pInt(int i) {
        if (!this.isClosed) {
            return this.pInt[i + 1];
        }
        return this.pInt[i + 2];
    }

    private void pInt(int i, double value) {
        if (!this.isClosed) {
            this.pInt[i + 1] = value;
        } else {
            this.pInt[i + 2] = value;
        }
    }

    private double[] getInterval() {
        if (!this.isClosed) {
            this.pInt = new double[this.uip + 1];
            this.pInt(-1, 0.0);
            int i = 0;
            while (i < this.uip - 1) {
                this.pInt(i, this.params[i + 1] - this.params[i]);
                ++i;
            }
            this.pInt(this.uip - 1, 0.0);
        } else {
            this.pInt = new double[this.uip + 3];
            int i = 0;
            while (i < this.uip) {
                this.pInt(i, this.params[i + 1] - this.params[i]);
                ++i;
            }
            this.pInt(i, this.pInt(0));
            this.pInt(-2, this.pInt(this.uip - 2));
            this.pInt(-1, this.pInt(this.uip - 1));
        }
        return this.pInt;
    }

    private JgclMatrix setupLinearSystem() {
        JgclMatrix matrix = new JgclMatrix(this.uip, 3);
        double[] dArray = new double[3];
        dArray[1] = 1.0;
        double[] firstRow = dArray;
        matrix.setElementsAt(0, firstRow);
        double denomJ = this.pInt(-1) + this.pInt(0) + this.pInt(1);
        int j = 1;
        while (j < this.uip - 1) {
            double denomJ1 = this.pInt(j - 1) + this.pInt(j) + this.pInt(j + 1);
            double[] value = new double[]{this.pInt(j) * this.pInt(j) / denomJ, this.pInt(j) * (this.pInt(j - 2) + this.pInt(j - 1)) / denomJ + this.pInt(j - 1) * (this.pInt(j) + this.pInt(j + 1)) / denomJ1, this.pInt(j - 1) * this.pInt(j - 1) / denomJ1};
            matrix.setElementsAt(j, value);
            denomJ = denomJ1;
            ++j;
        }
        double[] dArray2 = new double[3];
        dArray2[1] = 1.0;
        double[] lastRow = dArray2;
        matrix.setElementsAt(this.uip - 1, lastRow);
        return matrix;
    }

    private JgclMatrix setupLinearSystemClosed() {
        JgclMatrix matrix = new JgclMatrix(this.uip, this.uip);
        int j = 0;
        while (j < this.uip) {
            int k = 0;
            while (k < this.uip) {
                matrix.setElementAt(j, k, 0.0);
                ++k;
            }
            ++j;
        }
        double denomJ = this.pInt(-2) + this.pInt(-1) + this.pInt(0);
        int j2 = 0;
        while (j2 < this.uip) {
            double denomJ1 = this.pInt(j2 - 1) + this.pInt(j2) + this.pInt(j2 + 1);
            int alpha = j2 == 0 ? this.uip - 1 : j2 - 1;
            int beta = j2;
            int gamma = j2 == this.uip - 1 ? 0 : j2 + 1;
            matrix.setElementAt(j2, alpha, this.pInt(j2) * this.pInt(j2) / denomJ);
            matrix.setElementAt(j2, beta, this.pInt(j2) * (this.pInt(j2 - 2) + this.pInt(j2 - 1)) / denomJ + this.pInt(j2 - 1) * (this.pInt(j2) + this.pInt(j2 + 1)) / denomJ1);
            matrix.setElementAt(j2, gamma, this.pInt(j2 - 1) * this.pInt(j2 - 1) / denomJ1);
            denomJ = denomJ1;
            ++j2;
        }
        matrix.makeLUDecomposition();
        return matrix;
    }

    private void computeLeftSideLinearSystem() {
        int i = 1;
        while (i < this.uip) {
            double val0 = this.matrix.getElementAt(i, 0);
            double val1 = this.matrix.getElementAt(i - 1, 1);
            double val2 = this.matrix.getElementAt(i - 1, 2);
            double value = this.matrix.getElementAt(i, 1);
            double value0 = val0 / val1;
            this.matrix.setElementAt(i, 0, value0);
            this.matrix.setElementAt(i, 1, value -= value0 * val2);
            ++i;
        }
        int i2 = this.uip - 2;
        while (i2 >= 0) {
            double value0 = this.matrix.getElementAt(i2, 2);
            double value1 = this.matrix.getElementAt(i2 + 1, 1);
            double value = value0 / value1;
            this.matrix.setElementAt(i2, 2, value);
            --i2;
        }
    }

    private JgclBsplineKnot knotDataOpened() {
        int uik = this.uip;
        double[] knots = new double[uik];
        int[] knotMultiplicities = new int[uik];
        knots[0] = this.params[0];
        knotMultiplicities[0] = 4;
        int i = 1;
        while (i < uik - 1) {
            knots[i] = this.params[i];
            knotMultiplicities[i] = 1;
            ++i;
        }
        knots[i] = this.params[i];
        knotMultiplicities[i] = 4;
        return new JgclBsplineKnot(3, 1, this.isClosed, uik, knotMultiplicities, knots, this.uip + 2);
    }

    private JgclBsplineKnot knotDataClosed() {
        int degree = 3;
        int uik = 2 * degree + this.uip + 1;
        double[] knots = new double[uik];
        int[] knotMultiplicities = new int[uik];
        knots[degree] = this.params[0];
        knotMultiplicities[degree] = 1;
        int i = degree - 1;
        int j = this.uip - 1;
        while (i >= 0) {
            knots[i] = knots[i + 1] - this.pInt(j);
            knotMultiplicities[i] = 1;
            --i;
            --j;
        }
        i = degree + 1;
        j = 1;
        while (j < this.uip + 1) {
            knots[i] = this.params[j];
            knotMultiplicities[i] = 1;
            ++i;
            ++j;
        }
        j = 0;
        while (j < degree) {
            knots[i] = knots[i - 1] + this.pInt(j);
            knotMultiplicities[i] = 1;
            ++i;
            ++j;
        }
        return new JgclBsplineKnot(3, 1, this.isClosed, uik, knotMultiplicities, knots, this.uip);
    }

    JgclBsplineKnot knotData() {
        if (!this.isClosed) {
            return this.knotDataOpened();
        }
        return this.knotDataClosed();
    }

    int nControlPoints() {
        if (this.isClosed) {
            return this.uip;
        }
        return this.uip + 2;
    }
}

