/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclAxis2Placement2D;
import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclCompositeCurve3D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclConic2D;
import jp.go.ipa.jgcl.JgclConic3D;
import jp.go.ipa.jgcl.JgclCurveCurvature3D;
import jp.go.ipa.jgcl.JgclCurveDerivative3D;
import jp.go.ipa.jgcl.JgclEllipse3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclHyperbola2D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclIntsCncBzs3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclParabola3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclTrimmedCurve3D;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclHyperbola3D
extends JgclConic3D {
    private double semiAxis;
    private double semiImagAxis;

    private void setSemiAxis(double semiAxis, double semiImagAxis) {
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol = condition.getToleranceForDistance();
        if (semiAxis < dTol) {
            throw new JgclInvalidArgumentValue();
        }
        this.semiAxis = semiAxis;
        if (semiImagAxis < dTol) {
            throw new JgclInvalidArgumentValue();
        }
        this.semiImagAxis = semiImagAxis;
    }

    public JgclHyperbola3D(JgclAxis2Placement3D position, double semiAxis, double semiImagAxis) {
        super(position);
        this.setSemiAxis(semiAxis, semiImagAxis);
    }

    JgclConic2D toLocal2D(JgclAxis2Placement2D position) {
        return new JgclHyperbola2D(position, this.semiAxis(), this.semiImagAxis());
    }

    public double semiAxis() {
        return this.semiAxis;
    }

    public double xRadius() {
        return this.semiAxis;
    }

    public double semiImagAxis() {
        return this.semiImagAxis;
    }

    public double yRadius() {
        return this.semiImagAxis;
    }

    public JgclPoint3D coordinates(double param) {
        JgclAxis2Placement3D ax = this.position();
        JgclVector3D x = ax.x().multiply(JgclMath.cosh(param) * this.semiAxis);
        JgclVector3D y = ax.y().multiply(JgclMath.sinh(param) * this.semiImagAxis);
        return ax.location().add(x.add(y));
    }

    public JgclVector3D tangentVector(double param) {
        JgclAxis2Placement3D ax = this.position();
        JgclVector3D x1 = ax.x().multiply(JgclMath.sinh(param) * this.semiAxis);
        JgclVector3D y1 = ax.y().multiply(JgclMath.cosh(param) * this.semiImagAxis);
        return x1.add(y1);
    }

    public JgclCurveCurvature3D curvature(double param) {
        JgclAxis2Placement3D ax = this.position();
        double x1len = JgclMath.sinh(param) * this.semiAxis;
        double y1len = JgclMath.cosh(param) * this.semiImagAxis;
        double x2len = JgclMath.cosh(param) * this.semiAxis;
        double y2len = JgclMath.sinh(param) * this.semiImagAxis;
        double tlen = Math.sqrt(x1len * x1len + y1len * y1len);
        double crv = Math.abs(x1len * y2len - y1len * x2len) / (tlen * tlen * tlen);
        JgclVector3D ex1 = ax.x().multiply(x1len);
        JgclVector3D ey1 = ax.y().multiply(y1len);
        JgclVector3D tangent = ex1.add(ey1);
        JgclVector3D nrmDir = tangent.crossProduct(ax.z());
        return new JgclCurveCurvature3D(crv, nrmDir.unitized());
    }

    public JgclCurveDerivative3D evaluation(double param) {
        JgclAxis2Placement3D ax = this.position();
        JgclVector3D ex = ax.x().multiply(JgclMath.cosh(param) * this.semiAxis);
        JgclVector3D ey = ax.y().multiply(JgclMath.sinh(param) * this.semiImagAxis);
        JgclVector3D ex1 = ax.x().multiply(JgclMath.sinh(param) * this.semiAxis);
        JgclVector3D ey1 = ax.y().multiply(JgclMath.cosh(param) * this.semiImagAxis);
        JgclVector3D d1 = ex1.add(ey1);
        JgclVector3D d2 = ex.add(ey);
        JgclPoint3D d0 = ax.location().add(d2);
        return new JgclCurveDerivative3D(d0, d1, d2, d1);
    }

    double getPeak(double left, double right) {
        return JgclMath.atanh((JgclMath.cosh(right) - JgclMath.cosh(left)) / (JgclMath.sinh(right) - JgclMath.sinh(left)));
    }

    public JgclPureBezierCurve3D[] toPolyBezierCurves(JgclParameterSection pint) {
        JgclHyperbola2D this2D = (JgclHyperbola2D)this.toLocal2D(JgclAxis2Placement2D.origin);
        JgclPureBezierCurve2D[] bzcs2D = this2D.toPolyBezierCurves(pint);
        return this.transformPolyBezierCurvesInLocal2DToGrobal3D(bzcs2D);
    }

    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection pint) {
        JgclPureBezierCurve3D[] bzcs = this.toPolyBezierCurves(pint);
        return bzcs[0].toBsplineCurve();
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    JgclRealPolynomial makePoly(JgclRealPolynomial[] poly) {
        JgclRealPolynomial xPoly = poly[0].multiply(poly[0]);
        JgclRealPolynomial yPoly = poly[1].multiply(poly[1]);
        double dAlrd2 = this.xRadius() * this.xRadius();
        double dAsrd2 = this.yRadius() * this.yRadius();
        boolean isPoly = poly.length < 4;
        int degree = xPoly.degree();
        double[] coef = new double[degree + 1];
        if (isPoly) {
            int j = 0;
            while (j <= degree) {
                coef[j] = xPoly.coefficientAt(j) / dAlrd2 - yPoly.coefficientAt(j) / dAsrd2;
                ++j;
            }
            coef[0] = coef[0] - 1.0;
        } else {
            JgclRealPolynomial wPoly = poly[3].multiply(poly[3]);
            int j = 0;
            while (j <= degree) {
                coef[j] = dAsrd2 * xPoly.coefficientAt(j) - dAlrd2 * yPoly.coefficientAt(j) - dAlrd2 * dAsrd2 * wPoly.coefficientAt(j);
                ++j;
            }
        }
        return new JgclRealPolynomial(coef);
    }

    boolean checkSolution(JgclPoint3D point) {
        double param = this.getParameter(point);
        double px = this.xRadius() * JgclMath.cosh(param);
        double py = this.yRadius() * JgclMath.sinh(param);
        return point.identical(new JgclCartesianPoint3D(px, py, 0.0));
    }

    double getParameter(JgclPoint3D point) {
        double sinh = point.y() / this.yRadius();
        return JgclMath.asinh(sinh);
    }

    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) {
        try {
            return this.intersectCnc(mate, doExchange);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
    }

    JgclIntersectionPoint3D[] intersect(JgclEllipse3D mate, boolean doExchange) {
        try {
            return this.intersectCnc(mate, doExchange);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
    }

    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange) {
        try {
            return this.intersectCnc(mate, doExchange);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
    }

    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return this.intersectCnc(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
        return new JgclHyperbola3D(this.position().parallelTranslate(moveVec), this.semiAxis, this.semiImagAxis);
    }

    JgclParameterDomain getParameterDomain() {
        return new JgclParameterDomain();
    }

    boolean getClosedFlag() {
        return false;
    }

    int type() {
        return 12;
    }

    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns, double rCos, double rSin) {
        JgclAxis2Placement3D rpos = this.position().rotateZ(trns, rCos, rSin);
        return new JgclHyperbola3D(rpos, this.semiAxis(), this.semiImagAxis());
    }

    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
        JgclVector3D vector;
        JgclPoint3D point;
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol2 = condition.getToleranceForDistance2();
        double start = 0.0;
        double increase = 1.0;
        int itry = 0;
        int limit = 100;
        do {
            if (itry > limit) {
                throw new JgclFatal();
            }
            point = this.coordinates(start + increase * (double)itry);
            vector = point.subtract(line.projectFrom(point)[0]);
            ++itry;
        } while (point.isOn(line) || vector.norm() < dTol2);
        return point;
    }

    boolean checkInterfere(JgclIntsCncBzs3D.BezierSurfaceInfo bi) {
        double dTol = this.getToleranceForDistance();
        if (!(bi.box.min().z() < -dTol) || !(bi.box.max().z() > dTol)) {
            return false;
        }
        if (bi.box.max().x() < this.xRadius() - dTol) {
            return false;
        }
        boolean all_in = true;
        boolean all_out = true;
        JgclPoint2D point = null;
        int i = 0;
        while (i < 4) {
            switch (i) {
                case 0: {
                    point = new JgclCartesianPoint2D(bi.box.min().x(), bi.box.min().y());
                    break;
                }
                case 1: {
                    point = new JgclCartesianPoint2D(bi.box.max().x(), bi.box.min().y());
                    break;
                }
                case 2: {
                    point = new JgclCartesianPoint2D(bi.box.max().x(), bi.box.max().y());
                    break;
                }
                case 3: {
                    point = new JgclCartesianPoint2D(bi.box.min().x(), bi.box.max().y());
                    break;
                }
            }
            double epara = point.y() / this.yRadius();
            double ex = this.xRadius() * Math.sqrt(1.0 + epara * epara);
            ex = point.x() - ex;
            if (ex < -dTol) {
                all_in = false;
            } else if (ex > dTol) {
                all_out = false;
            } else {
                all_out = false;
                all_in = false;
            }
            ++i;
        }
        if (all_in) {
            return false;
        }
        if (all_out) {
            return !(bi.box.min().y() * bi.box.max().y() > 0.0);
        }
        return true;
    }

    JgclIntersectionPoint3D[] intersectConicPlane(JgclPlane3D plane) {
        JgclAxis2Placement3D position = new JgclAxis2Placement3D(JgclPoint3D.origin, null, null);
        JgclHyperbola3D hyperbola = new JgclHyperbola3D(position, this.xRadius(), this.yRadius());
        try {
            return hyperbola.intersect(plane);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
    }

    JgclPoint3D nlFunc(double parameter) {
        double x = this.xRadius() * JgclMath.cosh(parameter);
        double y = this.yRadius() * JgclMath.sinh(parameter);
        double z = 0.0;
        return new JgclCartesianPoint3D(x, y, z);
    }

    JgclVector3D dnlFunc(double parameter) {
        double x = this.xRadius() * JgclMath.sinh(parameter);
        double y = this.yRadius() * JgclMath.cosh(parameter);
        double z = 0.0;
        return new JgclLiteralVector3D(x, y, z);
    }

    protected synchronized JgclParametricCurve3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        double tSemiImagAxis;
        double tSemiAxis;
        JgclAxis2Placement3D tPosition = this.position().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        if (!reverseTransform) {
            tSemiAxis = transformationOperator.transform(this.semiAxis());
            tSemiImagAxis = transformationOperator.transform(this.semiImagAxis());
        } else {
            tSemiAxis = transformationOperator.reverseTransform(this.semiAxis());
            tSemiImagAxis = transformationOperator.reverseTransform(this.semiImagAxis());
        }
        return new JgclHyperbola3D(tPosition, tSemiAxis, tSemiImagAxis);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tposition");
        this.position().output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tsemiAxis " + this.semiAxis);
        writer.println(String.valueOf(indent_tab) + "\tsemiImagAxis " + this.semiImagAxis);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

