/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclHomogeneousVector3D
extends JgclVector3D {
    private double wx;
    private double wy;
    private double wz;
    private double w;

    private void setArgs(double wx, double wy, double wz, double w) {
        this.wx = wx;
        this.wy = wy;
        this.wz = wz;
        this.w = w;
    }

    public JgclHomogeneousVector3D(double wx, double wy, double wz, double w) {
        this.setArgs(wx, wy, wz, w);
    }

    public JgclHomogeneousVector3D(double[] c) {
        this.setArgs(c[0], c[1], c[2], c[3]);
    }

    JgclHomogeneousVector3D(double wx, double wy, double wz, double w, boolean confirmedAsUnitized) {
        super(confirmedAsUnitized);
        this.setArgs(wx, wy, wz, w);
    }

    JgclHomogeneousVector3D(double[] c, boolean confirmedAsUnitized) {
        super(confirmedAsUnitized);
        this.setArgs(c[0], c[1], c[2], c[3]);
    }

    public double x() {
        return this.wx / this.w;
    }

    public double y() {
        return this.wy / this.w;
    }

    public double z() {
        return this.wz / this.w;
    }

    public double wx() {
        return this.wx;
    }

    public double wy() {
        return this.wy;
    }

    public double wz() {
        return this.wz;
    }

    public double w() {
        return this.w;
    }

    protected synchronized JgclVector3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclVector3D vec = !reverseTransform ? transformationOperator.transform(this) : transformationOperator.reverseTransform(this);
        return new JgclHomogeneousVector3D(this.w * vec.x(), this.w * vec.y(), this.w * vec.z(), this.w);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName() + " " + this.wx() + " " + this.wy() + " " + this.wz() + " " + this.w() + " End");
    }
}

