/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclBoundedCurve3D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclEnclosingBox3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclUtil;

public abstract class JgclFreeformCurveWithControlPoints3D
extends JgclBoundedCurve3D {
    protected JgclPoint3D[] controlPoints;
    protected double[] weights;
    private double[][] controlPointsArray;

    protected JgclFreeformCurveWithControlPoints3D() {
    }

    protected JgclFreeformCurveWithControlPoints3D(JgclPoint3D[] controlPoints) {
        int npnts = this.setControlPoints(controlPoints);
        this.weights = null;
    }

    protected JgclFreeformCurveWithControlPoints3D(JgclPoint3D[] controlPoints, double[] weights) {
        int npnts = this.setControlPoints(controlPoints);
        this.setWeights(npnts, weights);
    }

    protected JgclFreeformCurveWithControlPoints3D(double[][] cpArray) {
        boolean isPoly;
        int npnts = cpArray.length;
        JgclPoint3D[] cp = new JgclPoint3D[npnts];
        boolean bl = isPoly = cpArray[0].length == 3;
        if (!isPoly) {
            double[] tmp = new double[4];
            double[] wt = new double[npnts];
            int i = 0;
            while (i < npnts) {
                int j = 0;
                while (j < 4) {
                    tmp[j] = cpArray[i][j];
                    ++j;
                }
                this.convRational0Deriv(tmp);
                cp[i] = new JgclCartesianPoint3D(tmp[0], tmp[1], tmp[2]);
                wt[i] = tmp[3];
                ++i;
            }
            this.setWeights(npnts, wt);
        } else {
            int i = 0;
            while (i < npnts) {
                cp[i] = new JgclCartesianPoint3D(cpArray[i][0], cpArray[i][1], cpArray[i][2]);
                ++i;
            }
            this.weights = null;
        }
        npnts = this.setControlPoints(cp);
    }

    protected JgclFreeformCurveWithControlPoints3D(JgclPoint3D[] controlPoints, double[] weights, boolean doCheck) {
        if (doCheck) {
            int npnts = this.setControlPoints(controlPoints);
            if (weights == null) {
                weights = null;
            } else {
                this.setWeights(npnts, weights);
            }
        } else {
            this.controlPoints = controlPoints;
            this.weights = weights;
        }
    }

    public JgclPoint3D[] controlPoints() {
        JgclPoint3D[] copied = new JgclPoint3D[this.controlPoints.length];
        int i = 0;
        while (i < this.controlPoints.length) {
            copied[i] = this.controlPoints[i];
            ++i;
        }
        return copied;
    }

    public JgclPoint3D controlPointAt(int i) {
        return this.controlPoints[i];
    }

    public double[] weights() {
        if (this.weights == null) {
            return null;
        }
        return (double[])this.weights.clone();
    }

    public double weightAt(int i) {
        if (this.weights == null) {
            throw new JgclInvalidArgumentValue();
        }
        return this.weights[i];
    }

    public int nControlPoints() {
        return this.controlPoints.length;
    }

    public boolean isRational() {
        return this.weights != null;
    }

    public boolean isPolynomial() {
        return this.weights == null;
    }

    double approximateLength() {
        double aprx_leng = 0.0;
        int i = 0;
        int j = 1;
        while (j < this.nControlPoints()) {
            aprx_leng += this.controlPointAt(i).distance(this.controlPointAt(j));
            ++i;
            ++j;
        }
        return aprx_leng;
    }

    JgclEnclosingBox3D approximateEnclosingBox() {
        double min_crd_z;
        double min_crd_y;
        double min_crd_x;
        int n = this.nControlPoints();
        JgclPoint3D point = this.controlPointAt(0);
        double max_crd_x = min_crd_x = point.x();
        double max_crd_y = min_crd_y = point.y();
        double max_crd_z = min_crd_z = point.z();
        int i = 1;
        while (i < n) {
            point = this.controlPointAt(i);
            double x = point.x();
            double y = point.y();
            double z = point.z();
            if (x < min_crd_x) {
                min_crd_x = x;
            } else if (x > max_crd_x) {
                max_crd_x = x;
            }
            if (y < min_crd_y) {
                min_crd_y = y;
            } else if (y > max_crd_y) {
                max_crd_y = y;
            }
            if (z < min_crd_z) {
                min_crd_z = z;
            } else if (z > max_crd_z) {
                max_crd_z = z;
            }
            ++i;
        }
        return new JgclEnclosingBox3D(min_crd_x, min_crd_y, min_crd_z, max_crd_x, max_crd_y, max_crd_z);
    }

    private int setControlPoints(JgclPoint3D[] controlPoints) {
        if (controlPoints == null) {
            throw new JgclInvalidArgumentValue();
        }
        int npnts = controlPoints.length;
        if (npnts < 2) {
            throw new JgclInvalidArgumentValue();
        }
        this.controlPoints = new JgclPoint3D[npnts];
        int i = 0;
        while (i < npnts) {
            if (controlPoints[i] == null) {
                throw new JgclInvalidArgumentValue();
            }
            this.controlPoints[i] = controlPoints[i];
            ++i;
        }
        return npnts;
    }

    private void setWeights(int npnts, double[] weights) {
        if (weights == null) {
            throw new JgclInvalidArgumentValue();
        }
        if (weights.length != npnts) {
            throw new JgclInvalidArgumentValue();
        }
        double max_weight = 0.0;
        int i = 0;
        while (i < npnts) {
            if (weights[i] > max_weight) {
                max_weight = weights[i];
            }
            ++i;
        }
        if (max_weight <= 0.0) {
            throw new JgclInvalidArgumentValue();
        }
        this.weights = new double[npnts];
        int i2 = 0;
        while (i2 < npnts) {
            if (weights[i2] <= 0.0 || !JgclUtil.isDividable(max_weight, weights[i2])) {
                throw new JgclInvalidArgumentValue();
            }
            this.weights[i2] = weights[i2];
            ++i2;
        }
    }

    protected static double[][] allocateDoubleArray(boolean isPoly, int size) {
        return new double[size][isPoly ? 3 : 4];
    }

    protected void setCoordinatesToDoubleArray(boolean isPoly, int uicp, double[][] doubleArray) {
        if (isPoly) {
            int i = 0;
            while (i < uicp) {
                doubleArray[i][0] = this.controlPoints[i].x();
                doubleArray[i][1] = this.controlPoints[i].y();
                doubleArray[i][2] = this.controlPoints[i].z();
                ++i;
            }
        } else {
            int i = 0;
            while (i < uicp) {
                doubleArray[i][0] = this.controlPoints[i].x() * this.weights[i];
                doubleArray[i][1] = this.controlPoints[i].y() * this.weights[i];
                doubleArray[i][2] = this.controlPoints[i].z() * this.weights[i];
                doubleArray[i][3] = this.weights[i];
                ++i;
            }
        }
    }

    protected double[][] toDoubleArray(boolean isPoly) {
        if (this.controlPointsArray != null) {
            return this.controlPointsArray;
        }
        int uicp = this.nControlPoints();
        this.controlPointsArray = JgclFreeformCurveWithControlPoints3D.allocateDoubleArray(isPoly, uicp);
        this.setCoordinatesToDoubleArray(isPoly, uicp, this.controlPointsArray);
        return this.controlPointsArray;
    }

    protected void convRational0Deriv(double[] d0D) {
        int i = 0;
        while (i < 3) {
            int n = i++;
            d0D[n] = d0D[n] / d0D[3];
        }
    }

    protected void convRational1Deriv(double[] d0D, double[] d1D) {
        this.convRational0Deriv(d0D);
        int i = 0;
        while (i < 3) {
            d1D[i] = (d1D[i] - d1D[3] * d0D[i]) / d0D[3];
            ++i;
        }
    }

    protected void convRational2Deriv(double[] d0D, double[] d1D, double[] d2D) {
        this.convRational1Deriv(d0D, d1D);
        int i = 0;
        while (i < 3) {
            d2D[i] = (d2D[i] - (2.0 * d1D[3] * d1D[i] + d2D[3] * d0D[i])) / d0D[3];
            ++i;
        }
    }

    protected void convRational3Deriv(double[] d0D, double[] d1D, double[] d2D, double[] d3D) {
        this.convRational2Deriv(d0D, d1D, d2D);
        int i = 0;
        while (i < 3) {
            d3D[i] = (d3D[i] - (3.0 * (d1D[3] * d2D[i] + d2D[3] * d1D[i]) + d3D[3] * d0D[i])) / d0D[3];
            ++i;
        }
    }

    public boolean isFreeform() {
        return true;
    }

    public double[] makeUniformWeights() {
        double[] uniformWeights = new double[this.nControlPoints()];
        int i = 0;
        while (i < uniformWeights.length) {
            uniformWeights[i] = 1.0;
            ++i;
        }
        return uniformWeights;
    }
}

