/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclBoundedCurve2D;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclEnclosingBox2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclUtil;

public abstract class JgclFreeformCurveWithControlPoints2D
extends JgclBoundedCurve2D {
    protected JgclPoint2D[] controlPoints;
    protected double[] weights;
    private double[][] controlPointsArray;

    protected JgclFreeformCurveWithControlPoints2D() {
    }

    protected JgclFreeformCurveWithControlPoints2D(JgclPoint2D[] controlPoints) {
        int npnts = this.setControlPoints(controlPoints);
        this.weights = null;
    }

    protected JgclFreeformCurveWithControlPoints2D(JgclPoint2D[] controlPoints, double[] weights) {
        int npnts = this.setControlPoints(controlPoints);
        this.setWeights(npnts, weights);
    }

    protected JgclFreeformCurveWithControlPoints2D(double[][] cpArray) {
        boolean isPoly;
        int npnts = cpArray.length;
        JgclPoint2D[] cp = new JgclPoint2D[npnts];
        boolean bl = isPoly = cpArray[0].length == 2;
        if (!isPoly) {
            double[] tmp = new double[3];
            double[] wt = new double[npnts];
            int i = 0;
            while (i < npnts) {
                int j = 0;
                while (j < 3) {
                    tmp[j] = cpArray[i][j];
                    ++j;
                }
                this.convRational0Deriv(tmp);
                cp[i] = new JgclCartesianPoint2D(tmp[0], tmp[1]);
                wt[i] = tmp[2];
                ++i;
            }
            this.setWeights(npnts, wt);
        } else {
            int i = 0;
            while (i < npnts) {
                cp[i] = new JgclCartesianPoint2D(cpArray[i][0], cpArray[i][1]);
                ++i;
            }
            this.weights = null;
        }
        npnts = this.setControlPoints(cp);
    }

    protected JgclFreeformCurveWithControlPoints2D(JgclPoint2D[] controlPoints, double[] weights, boolean doCheck) {
        if (doCheck) {
            int npnts = this.setControlPoints(controlPoints);
            if (weights == null) {
                weights = null;
            } else {
                this.setWeights(npnts, weights);
            }
        } else {
            this.controlPoints = controlPoints;
            this.weights = weights;
        }
    }

    public JgclPoint2D[] controlPoints() {
        JgclPoint2D[] copied = new JgclPoint2D[this.controlPoints.length];
        int i = 0;
        while (i < this.controlPoints.length) {
            copied[i] = this.controlPoints[i];
            ++i;
        }
        return copied;
    }

    public JgclPoint2D controlPointAt(int i) {
        return this.controlPoints[i];
    }

    public double[] weights() {
        if (this.weights == null) {
            return null;
        }
        return (double[])this.weights.clone();
    }

    public double weightAt(int i) {
        if (this.weights == null) {
            throw new JgclInvalidArgumentValue();
        }
        return this.weights[i];
    }

    public int nControlPoints() {
        return this.controlPoints.length;
    }

    public boolean isRational() {
        return this.weights != null;
    }

    public boolean isPolynomial() {
        return this.weights == null;
    }

    double approximateLength() {
        double aprx_leng = 0.0;
        int i = 0;
        int j = 1;
        while (j < this.nControlPoints()) {
            aprx_leng += this.controlPointAt(i).distance(this.controlPointAt(j));
            ++i;
            ++j;
        }
        return aprx_leng;
    }

    JgclEnclosingBox2D approximateEnclosingBox() {
        double min_crd_y;
        double min_crd_x;
        int n = this.nControlPoints();
        JgclPoint2D point = this.controlPointAt(0);
        double max_crd_x = min_crd_x = point.x();
        double max_crd_y = min_crd_y = point.y();
        int i = 1;
        while (i < n) {
            point = this.controlPointAt(i);
            double x = point.x();
            double y = point.y();
            if (x < min_crd_x) {
                min_crd_x = x;
            } else if (x > max_crd_x) {
                max_crd_x = x;
            }
            if (y < min_crd_y) {
                min_crd_y = y;
            } else if (y > max_crd_y) {
                max_crd_y = y;
            }
            ++i;
        }
        return new JgclEnclosingBox2D(min_crd_x, min_crd_y, max_crd_x, max_crd_y);
    }

    private int setControlPoints(JgclPoint2D[] controlPoints) {
        if (controlPoints == null) {
            throw new JgclInvalidArgumentValue();
        }
        int npnts = controlPoints.length;
        if (npnts < 2) {
            throw new JgclInvalidArgumentValue();
        }
        this.controlPoints = new JgclPoint2D[npnts];
        int i = 0;
        while (i < npnts) {
            if (controlPoints[i] == null) {
                throw new JgclInvalidArgumentValue();
            }
            this.controlPoints[i] = controlPoints[i];
            ++i;
        }
        return npnts;
    }

    private void setWeights(int npnts, double[] weights) {
        if (weights == null) {
            throw new JgclInvalidArgumentValue();
        }
        if (weights.length != npnts) {
            throw new JgclInvalidArgumentValue();
        }
        double max_weight = 0.0;
        int i = 0;
        while (i < npnts) {
            if (weights[i] > max_weight) {
                max_weight = weights[i];
            }
            ++i;
        }
        if (max_weight <= 0.0) {
            throw new JgclInvalidArgumentValue();
        }
        this.weights = new double[npnts];
        int i2 = 0;
        while (i2 < npnts) {
            if (weights[i2] <= 0.0 || !JgclUtil.isDividable(max_weight, weights[i2])) {
                throw new JgclInvalidArgumentValue();
            }
            this.weights[i2] = weights[i2];
            ++i2;
        }
    }

    protected static double[][] allocateDoubleArray(boolean isPoly, int size) {
        return new double[size][isPoly ? 2 : 3];
    }

    protected void setCoordinatesToDoubleArray(boolean isPoly, int uicp, double[][] doubleArray) {
        if (isPoly) {
            int i = 0;
            while (i < uicp) {
                doubleArray[i][0] = this.controlPoints[i].x();
                doubleArray[i][1] = this.controlPoints[i].y();
                ++i;
            }
        } else {
            int i = 0;
            while (i < uicp) {
                doubleArray[i][0] = this.controlPoints[i].x() * this.weights[i];
                doubleArray[i][1] = this.controlPoints[i].y() * this.weights[i];
                doubleArray[i][2] = this.weights[i];
                ++i;
            }
        }
    }

    protected double[][] toDoubleArray(boolean isPoly) {
        if (this.controlPointsArray != null) {
            return this.controlPointsArray;
        }
        int uicp = this.nControlPoints();
        this.controlPointsArray = JgclFreeformCurveWithControlPoints2D.allocateDoubleArray(isPoly, uicp);
        this.setCoordinatesToDoubleArray(isPoly, uicp, this.controlPointsArray);
        return this.controlPointsArray;
    }

    protected void convRational0Deriv(double[] d0D) {
        int i = 0;
        while (i < 2) {
            int n = i++;
            d0D[n] = d0D[n] / d0D[2];
        }
    }

    protected void convRational1Deriv(double[] d0D, double[] d1D) {
        this.convRational0Deriv(d0D);
        int i = 0;
        while (i < 2) {
            d1D[i] = (d1D[i] - d1D[2] * d0D[i]) / d0D[2];
            ++i;
        }
    }

    protected void convRational2Deriv(double[] d0D, double[] d1D, double[] d2D) {
        this.convRational1Deriv(d0D, d1D);
        int i = 0;
        while (i < 2) {
            d2D[i] = (d2D[i] - (2.0 * d1D[2] * d1D[i] + d2D[2] * d0D[i])) / d0D[2];
            ++i;
        }
    }

    public boolean isFreeform() {
        return true;
    }

    public double[] makeUniformWeights() {
        double[] uniformWeights = new double[this.nControlPoints()];
        int i = 0;
        while (i < uniformWeights.length) {
            uniformWeights[i] = 1.0;
            ++i;
        }
        return uniformWeights;
    }
}

