/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclBooleanFunctionWithRealVariables;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclConicalSurface3D;
import jp.go.ipa.jgcl.JgclCylindricalSurface3D;
import jp.go.ipa.jgcl.JgclFilletObject3D;
import jp.go.ipa.jgcl.JgclFilletObjectList;
import jp.go.ipa.jgcl.JgclFilletSection3D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionCurve3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclMatrix;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclRealFunction;
import jp.go.ipa.jgcl.JgclRectangularTrimmedSurface3D;
import jp.go.ipa.jgcl.JgclReducedToPoint;
import jp.go.ipa.jgcl.JgclSphericalSurface3D;
import jp.go.ipa.jgcl.JgclSurfaceDerivative3D;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterference3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve3D;
import jp.go.ipa.jgcl.JgclVector3D;
import jp.go.ipa.jgcl.JgclWhichSide;

final class JgclFiltSrfSrf3D {
    static boolean debug;
    private JgclFilletObjectList fillets;
    private SurfaceInfo[] infoA;
    private SurfaceInfo[] infoB;
    private double radius;
    static final int A_U_FIX = 0;
    static final int A_V_FIX = 1;
    static final int B_U_FIX = 2;
    static final int B_V_FIX = 3;

    private JgclFiltSrfSrf3D(JgclParametricSurface3D surfaceA, JgclParameterSection uSectA, JgclParameterSection vSectA, int sideA, JgclParametricSurface3D surfaceB, JgclParameterSection uSectB, JgclParameterSection vSectB, int sideB, double radius) {
        surfaceA.checkUValidity(uSectA);
        surfaceA.checkVValidity(vSectA);
        surfaceB.checkUValidity(uSectB);
        surfaceB.checkVValidity(vSectB);
        double tol = surfaceA.getToleranceForDistance();
        if (radius < tol) {
            throw new JgclInvalidArgumentValue();
        }
        this.fillets = new JgclFilletObjectList();
        this.radius = radius;
        this.infoA = this.getInfo(surfaceA, uSectA, vSectA, sideA);
        this.infoB = this.getInfo(surfaceB, uSectB, vSectB, sideB);
    }

    private JgclParametricSurface3D offsetSurface(JgclParametricSurface3D surface, JgclParameterSection uSection, JgclParameterSection vSection, int side, double radius) {
        switch (surface.type()) {
            case 1: {
                JgclPlane3D pln = (JgclPlane3D)surface;
                JgclVector3D enrm = pln.normalVector(0.0, 0.0);
                if (side == 4) {
                    enrm = enrm.reverse();
                }
                JgclPoint3D pnt = pln.position().location().add(enrm.multiply(radius));
                JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(pnt, pln.position().z(), pln.position().x());
                pln = new JgclPlane3D(a2p);
                return new JgclRectangularTrimmedSurface3D(pln, uSection, vSection);
            }
            case 12: {
                double sRadius;
                JgclSphericalSurface3D sph = (JgclSphericalSurface3D)surface;
                if (side == 3) {
                    sRadius = sph.radius() + radius;
                } else {
                    sRadius = sph.radius() - radius;
                    if (sRadius < 0.0) break;
                }
                if (sRadius < surface.getToleranceForDistance()) break;
                JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(sph.position().location(), sph.position().z(), sph.position().x());
                sph = new JgclSphericalSurface3D(a2p, sRadius);
                return new JgclRectangularTrimmedSurface3D(sph, uSection, vSection);
            }
            case 10: {
                double sRadius;
                JgclCylindricalSurface3D cyl = (JgclCylindricalSurface3D)surface;
                JgclVector3D x = cyl.position().x();
                if (side == 3) {
                    sRadius = cyl.radius() + radius;
                } else {
                    sRadius = cyl.radius() - radius;
                    if (sRadius < 0.0) {
                        x = x.reverse();
                        sRadius = -sRadius;
                    }
                }
                if (sRadius < surface.getToleranceForDistance()) break;
                JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(cyl.position().location(), cyl.position().z(), x);
                cyl = new JgclCylindricalSurface3D(a2p, sRadius);
                return new JgclRectangularTrimmedSurface3D(cyl, uSection, vSection);
            }
            case 11: {
                JgclConicalSurface3D con = (JgclConicalSurface3D)surface;
                double sinCon = Math.sin(con.semiAngle());
                double cosCon = Math.cos(con.semiAngle());
                double moveZ = radius * sinCon;
                if (side == 3) {
                    moveZ = -moveZ;
                }
                JgclPoint3D loc = con.position().location().add(con.position().z().multiply(moveZ));
                JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(loc, con.position().z(), con.position().x());
                double oftRadius = con.radius() + radius * cosCon;
                con = new JgclConicalSurface3D(a2p, oftRadius, con.semiAngle());
                return new JgclRectangularTrimmedSurface3D(con, uSection, vSection);
            }
            case 32: {
                JgclRectangularTrimmedSurface3D rts = (JgclRectangularTrimmedSurface3D)surface;
                uSection = rts.toBasisUParameter(uSection);
                vSection = rts.toBasisVParameter(vSection);
                if (rts.uSense() != rts.vSense()) {
                    side = JgclWhichSide.reverse(side);
                }
                return this.offsetSurface(rts.basisSurface(), uSection, vSection, side, radius);
            }
        }
        JgclToleranceForDistance ofst_tol = new JgclToleranceForDistance(radius / 100.0);
        return surface.offsetByBsplineSurface(uSection, vSection, radius, side, ofst_tol);
    }

    private JgclPointOnSurface3D nearestPointOnBoundaryWithDistance(JgclParametricSurface3D surface, JgclParameterDomain uPInfo, JgclParameterDomain vPInfo, JgclPoint3D point, double radius) {
        JgclPoint3D prj = null;
        double uParam = 0.0;
        double vParam = 0.0;
        double minDist = -1.0;
        int i = 0;
        while (i < 8) {
            block24: {
                JgclPoint3D prj0;
                double vParam0;
                double uParam0;
                switch (i) {
                    case 0: 
                    case 1: {
                        JgclPointOnCurve3D poc;
                        JgclTrimmedCurve3D trc;
                        if (!uPInfo.isPeriodic()) {
                            uParam0 = i == 0 ? uPInfo.section().start() : uPInfo.section().end();
                            try {
                                if (surface.type() == 12) {
                                    trc = (JgclTrimmedCurve3D)surface.uIsoParametricCurve(uParam0);
                                    trc = new JgclTrimmedCurve3D((JgclCircle3D)trc.basisCurve(), vPInfo.section());
                                } else {
                                    trc = new JgclTrimmedCurve3D(surface.uIsoParametricCurve(uParam0), vPInfo.section());
                                }
                                poc = trc.nearestProjectWithDistanceFrom(point, radius);
                                if (poc != null) {
                                    vParam0 = trc.toBasisParameter(poc.parameter());
                                    if (surface.type() == 12) {
                                        JgclParameterDomain dmn = new JgclParameterDomain(true, -Math.PI, Math.PI * 2);
                                        vParam0 = dmn.wrap(vParam0);
                                    }
                                    prj0 = poc;
                                }
                                break block24;
                            }
                            catch (JgclReducedToPoint e) {
                                vParam0 = (vPInfo.section().start() + vPInfo.section().end()) / 2.0;
                                prj0 = (JgclPoint3D)e.point();
                            }
                            break;
                        }
                        break block24;
                    }
                    case 2: 
                    case 3: {
                        JgclPointOnCurve3D poc;
                        JgclTrimmedCurve3D trc;
                        if (!vPInfo.isPeriodic()) {
                            vParam0 = i == 2 ? vPInfo.section().start() : vPInfo.section().end();
                            try {
                                trc = new JgclTrimmedCurve3D(surface.vIsoParametricCurve(vParam0), uPInfo.section());
                                poc = trc.nearestProjectWithDistanceFrom(point, radius);
                                if (poc != null) {
                                    uParam0 = trc.toBasisParameter(poc.parameter());
                                    prj0 = poc;
                                }
                                break block24;
                            }
                            catch (JgclReducedToPoint e) {
                                uParam0 = (uPInfo.section().start() + uPInfo.section().end()) / 2.0;
                                prj0 = (JgclPoint3D)e.point();
                            }
                            break;
                        }
                        break block24;
                    }
                    case 4: {
                        if (!uPInfo.isPeriodic() && !vPInfo.isPeriodic()) {
                            uParam0 = uPInfo.section().start();
                            vParam0 = vPInfo.section().start();
                            prj0 = surface.coordinates(uParam0, vParam0);
                            break;
                        }
                        break block24;
                    }
                    case 5: {
                        if (!uPInfo.isPeriodic() && !vPInfo.isPeriodic()) {
                            uParam0 = uPInfo.section().end();
                            vParam0 = vPInfo.section().start();
                            prj0 = surface.coordinates(uParam0, vParam0);
                            break;
                        }
                        break block24;
                    }
                    case 6: {
                        if (!uPInfo.isPeriodic() && !vPInfo.isPeriodic()) {
                            uParam0 = uPInfo.section().start();
                            vParam0 = vPInfo.section().end();
                            prj0 = surface.coordinates(uParam0, vParam0);
                            break;
                        }
                        break block24;
                    }
                    default: {
                        if (uPInfo.isPeriodic() || vPInfo.isPeriodic()) break block24;
                        uParam0 = uPInfo.section().end();
                        vParam0 = vPInfo.section().end();
                        prj0 = surface.coordinates(uParam0, vParam0);
                    }
                }
                double dist = Math.abs(radius - point.distance(prj0));
                if (prj == null || dist < minDist) {
                    prj = prj0;
                    minDist = dist;
                    uParam = uParam0;
                    vParam = vParam0;
                }
            }
            ++i;
        }
        if (prj == null) {
            return null;
        }
        return new JgclPointOnSurface3D(prj, surface, uParam, vParam, false);
    }

    private JgclPointOnSurface3D project(JgclParametricSurface3D surface, JgclParameterDomain uPInfo, JgclParameterDomain vPInfo, JgclPoint3D point, double radius) {
        JgclRectangularTrimmedSurface3D rts = new JgclRectangularTrimmedSurface3D(surface, uPInfo.section(), vPInfo.section());
        JgclPointOnSurface3D pos = rts.nearestProjectWithDistanceFrom(point, radius);
        JgclPointOnSurface3D pos2 = this.nearestPointOnBoundaryWithDistance(surface, uPInfo, vPInfo, point, radius);
        if (pos == null) {
            if (pos2 != null) {
                pos = pos2;
            }
        } else {
            pos = new JgclPointOnSurface3D(pos, surface, rts.toBasisUParameter(pos.uParameter()), rts.toBasisVParameter(pos.vParameter()), false);
            if (pos2 != null && Math.abs(radius - point.distance(pos2)) < Math.abs(radius - point.distance(pos))) {
                pos = pos2;
            }
        }
        if (debug) {
            System.out.println("// project defference = " + Math.abs(radius - point.distance(pos)));
        }
        return pos;
    }

    private SurfaceInfo[] getInfo(JgclParametricSurface3D surface, JgclParameterSection uSection, JgclParameterSection vSection, int side) {
        int[] sides;
        int nInfo;
        switch (side) {
            case -1: {
                nInfo = 2;
                sides = new int[]{3, 4};
                break;
            }
            case 3: 
            case 4: {
                nInfo = 1;
                sides = new int[]{side};
                break;
            }
            default: {
                throw new JgclInvalidArgumentValue();
            }
        }
        SurfaceInfo[] infoArray = new SurfaceInfo[nInfo];
        int i = 0;
        while (i < nInfo) {
            infoArray[i] = new SurfaceInfo(surface, uSection, vSection, sides[i]);
            ++i;
        }
        return infoArray;
    }

    private JgclFilletObject3D[] getFillets() {
        int i = 0;
        while (i < this.infoA.length) {
            int j = 0;
            while (j < this.infoB.length) {
                FilletInfo doObj = new FilletInfo(this.infoA[i], this.infoB[j]);
                if (debug) {
                    System.out.println("fillet doing at each FilletInfo");
                }
                doObj.getFillets();
                ++j;
            }
            ++i;
        }
        return this.fillets.toJgclFilletObject3DArray(false);
    }

    static JgclFilletObject3D[] fillet(JgclParametricSurface3D surfaceA, JgclParameterSection uSectA, JgclParameterSection vSectA, int sideA, JgclParametricSurface3D surfaceB, JgclParameterSection uSectB, JgclParameterSection vSectB, int sideB, double radius) throws JgclIndefiniteSolution {
        if (debug) {
            System.out.println("fillet start");
        }
        int typeA = surfaceA.type();
        int typeB = surfaceB.type();
        switch (typeA) {
            case 1: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 30: 
            case 31: 
            case 32: {
                switch (typeB) {
                    case 1: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 20: 
                    case 21: 
                    case 30: 
                    case 31: 
                    case 32: {
                        JgclFiltSrfSrf3D doObj = new JgclFiltSrfSrf3D(surfaceA, uSectA, vSectA, sideA, surfaceB, uSectB, vSectB, sideB, radius);
                        if (debug) {
                            System.out.println("fillet doing");
                        }
                        return doObj.getFillets();
                    }
                }
                throw new JgclNotSupported();
            }
        }
        throw new JgclNotSupported();
    }

    private class SurfaceDeriv {
        JgclPoint3D pnt;
        JgclSurfaceDerivative3D deriv;
        JgclVector3D nrm;

        private SurfaceDeriv(JgclPoint3D pnt, JgclSurfaceDerivative3D deriv, JgclVector3D nrm) {
            JgclFiltSrfSrf3D.this = JgclFiltSrfSrf3D.this;
            this.pnt = pnt;
            this.deriv = deriv;
            this.nrm = nrm;
        }
    }

    private class SurfaceInfo {
        JgclParametricSurface3D surface;
        JgclParameterDomain uPInfo;
        JgclParameterDomain vPInfo;
        double magni;
        JgclParametricSurface3D ofstSrf;

        private JgclParameterDomain cyclicPInfo(JgclParameterSection section, JgclParameterDomain domain, double ptol) {
            double start = section.start();
            double increase = section.increase();
            boolean periodic = false;
            if (domain.isPeriodic()) {
                double dInc = domain.section().increase();
                if (Math.abs(increase) > dInc - ptol) {
                    periodic = true;
                    increase = increase > 0.0 ? dInc : -dInc;
                }
            }
            return new JgclParameterDomain(periodic, start, increase);
        }

        private SurfaceInfo(JgclParametricSurface3D surface, JgclParameterSection uSection, JgclParameterSection vSection, int side) {
            JgclFiltSrfSrf3D.this = JgclFiltSrfSrf3D.this;
            this.surface = surface;
            double ptol = surface.getToleranceForParameter();
            this.uPInfo = this.cyclicPInfo(uSection, surface.uParameterDomain(), ptol);
            this.vPInfo = this.cyclicPInfo(vSection, surface.vParameterDomain(), ptol);
            this.magni = side == 3 ? JgclFiltSrfSrf3D.this.radius : -JgclFiltSrfSrf3D.this.radius;
            this.ofstSrf = JgclFiltSrfSrf3D.this.offsetSurface(surface, this.uPInfo.section(), this.vPInfo.section(), side, JgclFiltSrfSrf3D.this.radius);
        }

        private SurfaceDeriv evaluate(double[] parameter) {
            JgclSurfaceDerivative3D deriv = this.surface.evaluation(parameter[0], parameter[1]);
            JgclVector3D nrm = deriv.du().crossProduct(deriv.dv()).unitized();
            JgclPoint3D pnt = deriv.d0().add(nrm.multiply(this.magni));
            return new SurfaceDeriv(pnt, deriv, nrm);
        }
    }

    private class FilletInfo {
        SurfaceInfo sInfoA;
        SurfaceInfo sInfoB;
        private nlFunc nl_func;
        private JgclRealFunction[] dnl_func;
        private cnvFunc cnv_func;
        private dltFunc dlt_func;
        private SurfaceDeriv derivA;
        private SurfaceDeriv derivB;
        private int fixedParamType;
        private double fxParam;
        private double[][] sMatrix = new double[3][3];

        private FilletInfo(SurfaceInfo sInfoA, SurfaceInfo sInfoB) {
            JgclFiltSrfSrf3D.this = JgclFiltSrfSrf3D.this;
            this.sInfoA = sInfoA;
            this.sInfoB = sInfoB;
            this.nl_func = new nlFunc();
            this.dnl_func = new JgclRealFunction[3];
            int i = 0;
            while (i < 3) {
                this.dnl_func[i] = new dnlFunc(i);
                ++i;
            }
            this.cnv_func = new cnvFunc();
            this.dlt_func = new dltFunc();
        }

        /*
         * Unable to fully structure code
         */
        private double refineParam(JgclParameterDomain domain, JgclParameterDomain pInfo, double param) {
            block5: {
                if (domain.isNonPeriodic()) {
                    return param;
                }
                lo = pInfo.section().lower();
                up = pInfo.section().upper();
                il = domain.section().increase();
                if (!(pInfo.section().increase() > 0.0)) ** GOTO lbl15
                while (param < lo) {
                    param += il;
                }
                while (param > up) {
                    param -= il;
                }
                break block5;
lbl-1000:
                // 1 sources

                {
                    param -= il;
lbl15:
                    // 2 sources

                    ** while (param > lo)
                }
lbl16:
                // 2 sources

                while (param < up) {
                    param += il;
                }
            }
            return param;
        }

        private double[] setupParams(int i, double uParamA, double vParamA, double uParamB, double vParamB) {
            double[] param = new double[3];
            switch (i) {
                case 0: {
                    this.fixedParamType = 0;
                    break;
                }
                case 1: {
                    this.fixedParamType = 1;
                    break;
                }
                case 2: {
                    this.fixedParamType = 2;
                    break;
                }
                case 3: {
                    this.fixedParamType = 3;
                    break;
                }
            }
            switch (this.fixedParamType) {
                case 0: {
                    this.fxParam = uParamA;
                    param[0] = vParamA;
                    param[1] = uParamB;
                    param[2] = vParamB;
                    break;
                }
                case 1: {
                    param[0] = uParamA;
                    this.fxParam = vParamA;
                    param[1] = uParamB;
                    param[2] = vParamB;
                    break;
                }
                case 2: {
                    param[0] = uParamA;
                    param[1] = vParamA;
                    this.fxParam = uParamB;
                    param[2] = vParamB;
                    break;
                }
                case 3: {
                    param[0] = uParamA;
                    param[1] = vParamA;
                    param[2] = uParamB;
                    this.fxParam = vParamB;
                    break;
                }
            }
            return param;
        }

        private void reformParam(double[][] paramS) {
            JgclParameterDomain[] domainA = new JgclParameterDomain[]{this.sInfoA.surface.uParameterDomain(), this.sInfoA.surface.vParameterDomain()};
            JgclParameterDomain[] domainB = new JgclParameterDomain[]{this.sInfoB.surface.uParameterDomain(), this.sInfoB.surface.vParameterDomain()};
            JgclParameterDomain[] pInfoA = new JgclParameterDomain[]{this.sInfoA.uPInfo, this.sInfoA.vPInfo};
            JgclParameterDomain[] pInfoB = new JgclParameterDomain[]{this.sInfoB.uPInfo, this.sInfoB.vPInfo};
            JgclParameterDomain[] pInfo = pInfoA;
            JgclParameterDomain[] domain = domainA;
            double param_lo_p = 0.0;
            double param_up_s = 0.0;
            int i = 0;
            while (i < 2) {
                int j = 0;
                while (j < 2) {
                    double pup = pInfo[j].section().upper();
                    double plo = pInfo[j].section().lower();
                    boolean s_exist = false;
                    if (domain[j].isPeriodic()) {
                        double lo = domain[j].section().lower();
                        double up = domain[j].section().upper();
                        double il = domain[j].section().increase();
                        while (paramS[i][j] < lo) {
                            double[] dArray = paramS[i];
                            int n = j;
                            dArray[n] = dArray[n] + il;
                        }
                        while (paramS[i][j] > up) {
                            double[] dArray = paramS[i];
                            int n = j;
                            dArray[n] = dArray[n] - il;
                        }
                        if (pup > up) {
                            param_lo_p = plo;
                            param_up_s = lo + (pup - up);
                            s_exist = true;
                        } else if (plo < lo) {
                            param_lo_p = up - (plo - lo);
                            param_up_s = pup;
                            s_exist = true;
                        }
                    }
                    if (pInfo[j].isNonPeriodic()) {
                        if (!s_exist) {
                            if (paramS[i][j] < plo) {
                                paramS[i][j] = plo;
                            }
                            if (paramS[i][j] > pup) {
                                paramS[i][j] = pup;
                            }
                        } else if (param_up_s < paramS[i][j] && paramS[i][j] < param_lo_p) {
                            paramS[i][j] = paramS[i][j] - param_up_s < param_lo_p - paramS[i][j] ? param_up_s : param_lo_p;
                        }
                    }
                    ++j;
                }
                domain = domainB;
                pInfo = pInfoB;
                ++i;
            }
        }

        private double[][] fillParam(double[] param) {
            double[][] paramS = new double[2][2];
            switch (this.fixedParamType) {
                case 0: {
                    paramS[0][0] = this.fxParam;
                    paramS[0][1] = param[0];
                    paramS[1][0] = param[1];
                    paramS[1][1] = param[2];
                    break;
                }
                case 1: {
                    paramS[0][0] = param[0];
                    paramS[0][1] = this.fxParam;
                    paramS[1][0] = param[1];
                    paramS[1][1] = param[2];
                    break;
                }
                case 2: {
                    paramS[0][0] = param[0];
                    paramS[0][1] = param[1];
                    paramS[1][0] = this.fxParam;
                    paramS[1][1] = param[2];
                    break;
                }
                case 3: {
                    paramS[0][0] = param[0];
                    paramS[0][1] = param[1];
                    paramS[1][0] = param[2];
                    paramS[1][1] = this.fxParam;
                    break;
                }
            }
            this.reformParam(paramS);
            return paramS;
        }

        private JgclFilletSection3D setbackParams(double[] parameter) {
            double[][] paramS = this.fillParam(parameter);
            JgclPoint3D cntr = this.derivA.pnt.midPoint(this.derivB.pnt);
            JgclPointOnSurface3D posA = new JgclPointOnSurface3D(this.sInfoA.surface, paramS[0][0], paramS[0][1], false);
            JgclPointOnSurface3D posB = new JgclPointOnSurface3D(this.sInfoB.surface, paramS[1][0], paramS[1][1], false);
            return new JgclFilletSection3D(JgclFiltSrfSrf3D.this.radius, cntr, posA, posB);
        }

        private JgclFilletSection3D refineFillet(JgclPoint3D intp, double uParamA, double vParamA, double uParamB, double vParamB, boolean doProjection) {
            JgclFilletSection3D sec = null;
            double diff = -1.0;
            uParamA = this.refineParam(this.sInfoA.surface.uParameterDomain(), this.sInfoA.uPInfo, uParamA);
            vParamA = this.refineParam(this.sInfoA.surface.vParameterDomain(), this.sInfoA.vPInfo, vParamA);
            uParamB = this.refineParam(this.sInfoB.surface.uParameterDomain(), this.sInfoB.uPInfo, uParamB);
            vParamB = this.refineParam(this.sInfoB.surface.vParameterDomain(), this.sInfoB.vPInfo, vParamB);
            int i = 0;
            while (i < 4) {
                double[] param = this.setupParams(i, uParamA, vParamA, uParamB, vParamB);
                double[] refined = JgclMath.solveSimultaneousEquationsWithCorrection(this.nl_func, this.dnl_func, this.cnv_func, this.dlt_func, param);
                if (refined != null) {
                    JgclFilletSection3D secI = this.setbackParams(refined);
                    double diffI = secI.center().distance(intp);
                    if (sec == null || diffI < diff) {
                        sec = secI;
                        diff = diffI;
                    }
                }
                ++i;
            }
            return sec;
        }

        private JgclFilletObject3D toFillet(JgclSurfaceSurfaceInterference3D intf) {
            JgclIntersectionCurve3D ints = intf.toIntersectionCurve();
            if (ints == null) {
                return null;
            }
            JgclParametricCurve3D curve3d = ints.curve3d();
            JgclPolyline3D pol = curve3d.type() == 20 ? (JgclPolyline3D)curve3d : curve3d.toPolyline(curve3d.parameterDomain().section(), curve3d.getToleranceForDistanceAsObject());
            int nPoints = pol.nPoints();
            JgclFilletObjectList secList = new JgclFilletObjectList();
            int i = 0;
            while (i < nPoints) {
                JgclPointOnSurface3D posA = JgclFiltSrfSrf3D.this.project(this.sInfoA.surface, this.sInfoA.uPInfo, this.sInfoA.vPInfo, pol.pointAt(i), JgclFiltSrfSrf3D.this.radius);
                JgclPointOnSurface3D posB = JgclFiltSrfSrf3D.this.project(this.sInfoB.surface, this.sInfoB.uPInfo, this.sInfoB.vPInfo, pol.pointAt(i), JgclFiltSrfSrf3D.this.radius);
                double uParamA = posA.uParameter();
                double vParamA = posA.vParameter();
                double uParamB = posB.uParameter();
                double vParamB = posB.vParameter();
                JgclFilletSection3D oneSec = this.refineFillet(pol.pointAt(i), uParamA, vParamA, uParamB, vParamB, false);
                if (oneSec != null) {
                    secList.addSection(oneSec);
                }
                ++i;
            }
            return secList.toJgclFilletObject3D(false);
        }

        private void getFillets() {
            JgclSurfaceSurfaceInterference3D[] ints;
            try {
                if (debug) {
                    System.out.println("intersection start");
                    this.sInfoA.ofstSrf.output(System.out);
                    this.sInfoB.ofstSrf.output(System.out);
                }
                ints = this.sInfoA.ofstSrf.intersect(this.sInfoB.ofstSrf);
                if (debug) {
                    System.out.println("intersection OK");
                    if (ints.length < 1) {
                        System.out.println("no intersection");
                    }
                }
            }
            catch (JgclIndefiniteSolution e) {
                JgclSurfaceSurfaceInterference3D intf = (JgclSurfaceSurfaceInterference3D)((Object)e.suitable());
                ints = new JgclSurfaceSurfaceInterference3D[]{intf};
            }
            int i = 0;
            while (i < ints.length) {
                JgclFilletObject3D oneSol = this.toFillet(ints[i]);
                if (oneSol != null) {
                    JgclFiltSrfSrf3D.this.fillets.addFillet(oneSol);
                }
                ++i;
            }
        }

        private class nlFunc
        implements JgclRealFunction {
            private nlFunc() {
                FilletInfo.this = FilletInfo.this;
            }

            public double[] evaluate(double[] parameter) {
                JgclVector3D evec = ((FilletInfo)FilletInfo.this).derivA.pnt.subtract(((FilletInfo)FilletInfo.this).derivB.pnt);
                return evec.toDoubleArray();
            }
        }

        private class dnlFunc
        implements JgclRealFunction {
            int idx;

            private dnlFunc(int idx) {
                FilletInfo.this = FilletInfo.this;
                this.idx = idx;
            }

            private void fillMatrix(int m_idx, JgclVector3D vec, double magni, double[] dX, boolean reverse) {
                ((FilletInfo)FilletInfo.this).sMatrix[0][m_idx] = vec.x() + magni * dX[0];
                ((FilletInfo)FilletInfo.this).sMatrix[1][m_idx] = vec.y() + magni * dX[1];
                ((FilletInfo)FilletInfo.this).sMatrix[2][m_idx] = vec.z() + magni * dX[2];
                if (reverse) {
                    int i = 0;
                    while (i < 3) {
                        double[] dArray = FilletInfo.this.sMatrix[i];
                        int n = m_idx;
                        dArray[n] = dArray[n] * -1.0;
                        ++i;
                    }
                }
            }

            public double[] evaluate(double[] parameter) {
                if (this.idx == 0) {
                    double[] dX;
                    JgclMatrix dDm = new JgclMatrix(3, 3);
                    double[] dB = new double[3];
                    int m_idx = 0;
                    if (FilletInfo.this.fixedParamType != 0) {
                        dDm.setElementsAt(0, ((FilletInfo)FilletInfo.this).derivA.deriv.du().toDoubleArray());
                        dDm.setElementsAt(1, ((FilletInfo)FilletInfo.this).derivA.deriv.dv().toDoubleArray());
                        dDm.setElementsAt(2, ((FilletInfo)FilletInfo.this).derivA.nrm.toDoubleArray());
                        dB[0] = -((FilletInfo)FilletInfo.this).derivA.deriv.duu().dotProduct(((FilletInfo)FilletInfo.this).derivA.nrm);
                        dB[1] = -((FilletInfo)FilletInfo.this).derivA.deriv.duv().dotProduct(((FilletInfo)FilletInfo.this).derivA.nrm);
                        dB[2] = 0.0;
                        dX = dDm.solveSimultaneousLinearEquations(dB);
                        if (dX == null) {
                            return null;
                        }
                        this.fillMatrix(m_idx, ((FilletInfo)FilletInfo.this).derivA.deriv.du(), FilletInfo.this.sInfoA.magni, dX, false);
                        ++m_idx;
                    }
                    if (FilletInfo.this.fixedParamType != 1) {
                        dDm.setElementsAt(0, ((FilletInfo)FilletInfo.this).derivA.deriv.dv().toDoubleArray());
                        dDm.setElementsAt(1, ((FilletInfo)FilletInfo.this).derivA.deriv.du().toDoubleArray());
                        dDm.setElementsAt(2, ((FilletInfo)FilletInfo.this).derivA.nrm.toDoubleArray());
                        dB[0] = -((FilletInfo)FilletInfo.this).derivA.deriv.dvv().dotProduct(((FilletInfo)FilletInfo.this).derivA.nrm);
                        dB[1] = -((FilletInfo)FilletInfo.this).derivA.deriv.duv().dotProduct(((FilletInfo)FilletInfo.this).derivA.nrm);
                        dB[2] = 0.0;
                        dX = dDm.solveSimultaneousLinearEquations(dB);
                        if (dX == null) {
                            return null;
                        }
                        this.fillMatrix(m_idx, ((FilletInfo)FilletInfo.this).derivA.deriv.dv(), FilletInfo.this.sInfoA.magni, dX, false);
                        ++m_idx;
                    }
                    if (FilletInfo.this.fixedParamType != 2) {
                        dDm.setElementsAt(0, ((FilletInfo)FilletInfo.this).derivB.deriv.du().toDoubleArray());
                        dDm.setElementsAt(1, ((FilletInfo)FilletInfo.this).derivB.deriv.dv().toDoubleArray());
                        dDm.setElementsAt(2, ((FilletInfo)FilletInfo.this).derivB.nrm.toDoubleArray());
                        dB[0] = -((FilletInfo)FilletInfo.this).derivB.deriv.duu().dotProduct(((FilletInfo)FilletInfo.this).derivB.nrm);
                        dB[1] = -((FilletInfo)FilletInfo.this).derivB.deriv.duv().dotProduct(((FilletInfo)FilletInfo.this).derivB.nrm);
                        dB[2] = 0.0;
                        dX = dDm.solveSimultaneousLinearEquations(dB);
                        if (dX == null) {
                            return null;
                        }
                        this.fillMatrix(m_idx, ((FilletInfo)FilletInfo.this).derivB.deriv.du(), FilletInfo.this.sInfoB.magni, dX, true);
                        ++m_idx;
                    }
                    if (FilletInfo.this.fixedParamType != 3) {
                        dDm.setElementsAt(0, ((FilletInfo)FilletInfo.this).derivB.deriv.dv().toDoubleArray());
                        dDm.setElementsAt(1, ((FilletInfo)FilletInfo.this).derivB.deriv.du().toDoubleArray());
                        dDm.setElementsAt(2, ((FilletInfo)FilletInfo.this).derivB.nrm.toDoubleArray());
                        dB[0] = -((FilletInfo)FilletInfo.this).derivB.deriv.dvv().dotProduct(((FilletInfo)FilletInfo.this).derivB.nrm);
                        dB[1] = -((FilletInfo)FilletInfo.this).derivB.deriv.duv().dotProduct(((FilletInfo)FilletInfo.this).derivB.nrm);
                        dB[2] = 0.0;
                        dX = dDm.solveSimultaneousLinearEquations(dB);
                        if (dX == null) {
                            return null;
                        }
                        this.fillMatrix(m_idx, ((FilletInfo)FilletInfo.this).derivB.deriv.dv(), FilletInfo.this.sInfoB.magni, dX, true);
                        ++m_idx;
                    }
                    double tol = FilletInfo.this.sInfoA.surface.getToleranceForDistance();
                    int i = 0;
                    while (i < 3) {
                        int j = 0;
                        while (j < 3) {
                            if (Math.abs(FilletInfo.this.sMatrix[i][j]) > tol) break;
                            ++j;
                        }
                        if (j == 3) {
                            return null;
                        }
                        ++i;
                    }
                }
                return FilletInfo.this.sMatrix[this.idx];
            }
        }

        private class cnvFunc
        implements JgclBooleanFunctionWithRealVariables {
            private cnvFunc() {
                FilletInfo.this = FilletInfo.this;
            }

            public boolean evaluate(double[] parameter) {
                double[][] paramS = FilletInfo.this.fillParam(parameter);
                FilletInfo.this.derivA = FilletInfo.this.sInfoA.evaluate(paramS[0]);
                FilletInfo.this.derivB = FilletInfo.this.sInfoB.evaluate(paramS[1]);
                if (debug) {
                    System.out.println("// refine dist = " + ((FilletInfo)FilletInfo.this).derivA.pnt.distance(((FilletInfo)FilletInfo.this).derivB.pnt));
                }
                return ((FilletInfo)FilletInfo.this).derivA.pnt.identical(((FilletInfo)FilletInfo.this).derivB.pnt);
            }
        }

        private class dltFunc
        implements JgclRealFunction {
            private dltFunc() {
                FilletInfo.this = FilletInfo.this;
            }

            public double[] evaluate(double[] parameter) {
                double[][] paramS = FilletInfo.this.fillParam(parameter);
                switch (FilletInfo.this.fixedParamType) {
                    case 0: {
                        parameter[0] = paramS[0][1];
                        parameter[1] = paramS[1][0];
                        parameter[2] = paramS[1][1];
                        break;
                    }
                    case 1: {
                        parameter[0] = paramS[0][0];
                        parameter[1] = paramS[1][0];
                        parameter[2] = paramS[1][1];
                        break;
                    }
                    case 2: {
                        parameter[0] = paramS[0][0];
                        parameter[1] = paramS[0][1];
                        parameter[2] = paramS[1][1];
                        break;
                    }
                    case 3: {
                        parameter[0] = paramS[0][0];
                        parameter[1] = paramS[0][1];
                        parameter[2] = paramS[1][0];
                        break;
                    }
                }
                return parameter;
            }
        }
    }
}

