/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import jp.go.ipa.jgcl.JgclAxis2Placement2D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclNonParametricCurve2D;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclTrimmedCurve2D;
import jp.go.ipa.jgcl.JgclVector2D;

public class JgclFilletObject2D
extends JgclNonParametricCurve2D {
    private double radius;
    private JgclPoint2D center;
    private JgclPointOnCurve2D pointOnCurve1;
    private JgclPointOnCurve2D pointOnCurve2;

    JgclFilletObject2D(double radius, JgclPoint2D center, JgclPointOnCurve2D pointOnCurve1, JgclPointOnCurve2D pointOnCurve2) {
        this.radius = radius;
        this.center = center;
        this.pointOnCurve1 = pointOnCurve1;
        this.pointOnCurve2 = pointOnCurve2;
    }

    public double radius() {
        return this.radius;
    }

    public JgclPoint2D center() {
        return this.center;
    }

    public JgclPointOnCurve2D pointOnCurve1() {
        return this.pointOnCurve1;
    }

    public JgclPointOnCurve2D pointOnCurve2() {
        return this.pointOnCurve2;
    }

    public JgclTrimmedCurve2D toCurve(boolean smallFan) {
        JgclVector2D vecE;
        JgclVector2D vecS = this.pointOnCurve1().subtract(this.center()).unitized();
        if (vecS.parallelDirection(vecE = this.pointOnCurve2().subtract(this.center()).unitized())) {
            throw new JgclInvalidArgumentValue();
        }
        double angle = vecS.angleWith(vecE);
        if (angle < Math.PI && !smallFan || angle > Math.PI && smallFan) {
            angle -= Math.PI * 2;
        }
        JgclAxis2Placement2D a2p = new JgclAxis2Placement2D(this.center(), vecS);
        JgclCircle2D cir = new JgclCircle2D(a2p, this.radius);
        JgclParameterSection section = new JgclParameterSection(0.0, angle);
        return new JgclTrimmedCurve2D(cir, section);
    }

    JgclFilletObject2D exchange() {
        return new JgclFilletObject2D(this.radius(), this.center(), this.pointOnCurve2(), this.pointOnCurve1());
    }

    boolean parametricallyIdentical(JgclFilletObject2D mate) {
        if (!this.center.identical(mate.center())) {
            return false;
        }
        if (!this.pointOnCurve1.parametricallyIdentical(mate.pointOnCurve1())) {
            return false;
        }
        return this.pointOnCurve2.parametricallyIdentical(mate.pointOnCurve2());
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tradius " + this.radius);
        writer.println(String.valueOf(indent_tab) + "\tcenter");
        this.center().output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tpointOnCurve1");
        this.pointOnCurve1().output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tpointOnCurve2");
        this.pointOnCurve2().output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

