/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclPoint2D;

public class JgclEnclosingBox2D {
    private final JgclPoint2D min;
    private final JgclPoint2D max;

    public JgclEnclosingBox2D(JgclPoint2D min, JgclPoint2D max) {
        if (min.x() > max.x() || min.y() > max.y()) {
            throw new JgclInvalidArgumentValue();
        }
        this.min = min;
        this.max = max;
    }

    public JgclEnclosingBox2D(double minX, double minY, double maxX, double maxY) {
        if (minX > maxX || minY > maxY) {
            throw new JgclInvalidArgumentValue();
        }
        this.min = new JgclCartesianPoint2D(minX, minY);
        this.max = new JgclCartesianPoint2D(maxX, maxY);
    }

    public JgclEnclosingBox2D(JgclPoint2D[] points) {
        double max_y;
        double max_x;
        double min_x = max_x = points[0].x();
        double min_y = max_y = points[0].y();
        int i = 1;
        while (i < points.length) {
            if (max_x < points[i].x()) {
                max_x = points[i].x();
            }
            if (max_y < points[i].y()) {
                max_y = points[i].y();
            }
            if (min_x > points[i].x()) {
                min_x = points[i].x();
            }
            if (min_y > points[i].y()) {
                min_y = points[i].y();
            }
            ++i;
        }
        this.min = new JgclCartesianPoint2D(min_x, min_y);
        this.max = new JgclCartesianPoint2D(max_x, max_y);
    }

    public JgclPoint2D min() {
        return this.min;
    }

    public JgclPoint2D max() {
        return this.max;
    }

    public JgclPoint2D[] toArray() {
        JgclPoint2D[] array = new JgclPoint2D[]{this.min, this.max};
        return array;
    }

    public boolean hasIntersection(JgclEnclosingBox2D mate) {
        double d_tol = JgclConditionOfOperation.getCondition().getToleranceForDistance();
        return !(this.min().x() > mate.max().x() + d_tol || this.min().y() > mate.max().y() + d_tol || mate.min().x() > this.max().x() + d_tol) && !(mate.min().y() > this.max().y() + d_tol);
    }
}

