/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclAxis2Placement2D;
import jp.go.ipa.jgcl.JgclBsplineCurve2D;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclCommonNormal2D;
import jp.go.ipa.jgcl.JgclCommonTangent2D;
import jp.go.ipa.jgcl.JgclComplex;
import jp.go.ipa.jgcl.JgclComplexPolynomial;
import jp.go.ipa.jgcl.JgclCompositeCurve2D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment2D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclConic2D;
import jp.go.ipa.jgcl.JgclCurveCurvature2D;
import jp.go.ipa.jgcl.JgclCurveDerivative2D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclHyperbola2D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclIntsEllCnc2D;
import jp.go.ipa.jgcl.JgclIntsLinCnc2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclLiteralVector2D;
import jp.go.ipa.jgcl.JgclMachineEpsilon;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclOfst2D;
import jp.go.ipa.jgcl.JgclParabola2D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPointOnGeometryList;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;
import jp.go.ipa.jgcl.JgclRealFunctionWithOneVariable;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve2D;
import jp.go.ipa.jgcl.JgclVector2D;

public class JgclEllipse2D
extends JgclConic2D {
    private double semiAxis1;
    private double semiAxis2;

    private void setSemiAxis(double semiAxis1, double semiAxis2) {
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol = condition.getToleranceForDistance();
        if (semiAxis1 < dTol) {
            throw new JgclInvalidArgumentValue();
        }
        this.semiAxis1 = semiAxis1;
        if (semiAxis2 < dTol) {
            throw new JgclInvalidArgumentValue();
        }
        this.semiAxis2 = semiAxis2;
    }

    public JgclEllipse2D(JgclAxis2Placement2D position, double semiAxis1, double semiAxis2) {
        super(position);
        this.setSemiAxis(semiAxis1, semiAxis2);
    }

    public double semiAxis1() {
        return this.semiAxis1;
    }

    public double xRadius() {
        return this.semiAxis1;
    }

    public double semiAxis2() {
        return this.semiAxis2;
    }

    public double yRadius() {
        return this.semiAxis2;
    }

    public double length(JgclParameterSection pint) {
        double m2eal_majrd2 = this.semiAxis1() * this.semiAxis1();
        double m2eal_minrd2 = this.semiAxis2() * this.semiAxis2();
        double dTol = this.getToleranceForDistance() / 2.0;
        return JgclMath.getDefiniteIntegral(new 1(m2eal_majrd2, m2eal_minrd2), pint, dTol);
    }

    public JgclPoint2D coordinates(double param) {
        param = this.parameterDomain().wrap(param);
        JgclAxis2Placement2D ax = this.position();
        JgclVector2D ex = ax.x().multiply(Math.cos(param) * this.semiAxis1);
        JgclVector2D ey = ax.y().multiply(Math.sin(param) * this.semiAxis2);
        return ax.location().add(ex.add(ey));
    }

    public JgclVector2D tangentVector(double param) {
        param = this.parameterDomain().wrap(param);
        JgclAxis2Placement2D ax = this.position();
        JgclVector2D ex1 = ax.x().multiply(-Math.sin(param) * this.semiAxis1);
        JgclVector2D ey1 = ax.y().multiply(Math.cos(param) * this.semiAxis2);
        return ex1.add(ey1);
    }

    public JgclCurveCurvature2D curvature(double param) {
        param = this.parameterDomain().wrap(param);
        JgclAxis2Placement2D ax = this.position();
        double xlen = Math.cos(param) * this.semiAxis1;
        double ylen = Math.sin(param) * this.semiAxis2;
        double x1len = -Math.sin(param) * this.semiAxis1;
        double y1len = Math.cos(param) * this.semiAxis2;
        double plen = Math.sqrt(x1len * x1len + y1len * y1len);
        double crv = Math.abs(x1len * ylen - y1len * xlen) / (plen * plen * plen);
        JgclVector2D ex1 = ax.x().multiply(x1len);
        JgclVector2D ey1 = ax.y().multiply(y1len);
        JgclVector2D tangent = ex1.add(ey1);
        JgclLiteralVector2D nrmDir = new JgclLiteralVector2D(-tangent.y(), tangent.x());
        return new JgclCurveCurvature2D(crv, nrmDir.unitized());
    }

    public JgclCurveDerivative2D evaluation(double param) {
        param = this.parameterDomain().wrap(param);
        JgclAxis2Placement2D ax = this.position();
        JgclVector2D ex = ax.x().multiply(Math.cos(param) * this.semiAxis1);
        JgclVector2D ey = ax.y().multiply(Math.sin(param) * this.semiAxis2);
        JgclVector2D ex1 = ax.x().multiply(-Math.sin(param) * this.semiAxis1);
        JgclVector2D ey1 = ax.y().multiply(Math.cos(param) * this.semiAxis2);
        JgclPoint2D d0 = ax.location().add(ex.add(ey));
        JgclVector2D d1 = ex1.add(ey1);
        JgclVector2D d2 = ex.add(ey).multiply(-1.0);
        return new JgclCurveDerivative2D(d0, d1, d2);
    }

    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D point) throws JgclIndefiniteSolution {
        JgclComplex[] root;
        JgclComplexPolynomial pol;
        JgclCartesianTransformationOperator2D trans;
        double dBsrd;
        double dBlrd;
        double dTol2 = this.getToleranceForDistance2();
        if (this.semiAxis1 < this.semiAxis2) {
            dBlrd = this.semiAxis2;
            dBsrd = this.semiAxis1;
            try {
                JgclAxis2Placement2D ax = new JgclAxis2Placement2D(this.position().location(), this.position().y());
                trans = new JgclCartesianTransformationOperator2D(ax, 1.0);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
        }
        dBlrd = this.semiAxis1;
        dBsrd = this.semiAxis2;
        try {
            trans = new JgclCartesianTransformationOperator2D(this.position(), 1.0);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
        JgclVector2D Bc2A = point.subtract(this.position().location());
        if ((this.semiAxis1 - this.semiAxis2) * (this.semiAxis1 - this.semiAxis2) < dTol2 && Bc2A.norm() < dTol2) {
            JgclPointOnCurve2D p;
            try {
                p = new JgclPointOnCurve2D(this, 0.0, false);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            throw new JgclIndefiniteSolution(p);
        }
        JgclVector2D eAir = trans.reverseTransform(Bc2A);
        double eDDD = dBlrd * eAir.x();
        double eEEE = dBsrd * eAir.y();
        double eFFF = dBlrd * dBlrd - dBsrd * dBsrd;
        double[] ercoef = new double[5];
        ercoef[4] = -eFFF * eFFF;
        ercoef[0] = eDDD * eDDD;
        ercoef[3] = 2.0 * eDDD * eFFF;
        ercoef[1] = -ercoef[3];
        ercoef[2] = ercoef[4] + ercoef[0] + eEEE * eEEE;
        ercoef[2] = -ercoef[2];
        try {
            pol = new JgclComplexPolynomial(ercoef);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
        try {
            root = pol.getRootsByDKA();
        }
        catch (JgclComplexPolynomial.DKANotConverge e) {
            root = e.getValues();
        }
        catch (JgclComplexPolynomial.ImpossibleEquation impossibleEquation) {
            throw new JgclFatal();
        }
        catch (JgclComplexPolynomial.IndefiniteEquation indefiniteEquation) {
            throw new JgclFatal();
        }
        JgclPointOnGeometryList projList = new JgclPointOnGeometryList();
        int i = 0;
        while (i < root.length) {
            JgclPointOnCurve2D proj;
            double eCOS = root[i].real();
            if (eCOS > 1.0) {
                eCOS = 1.0;
            }
            if (eCOS < -1.0) {
                eCOS = -1.0;
            }
            double Bparam1 = Math.acos(eCOS);
            double Bparam2 = Math.PI * 2 - Bparam1;
            if (this.semiAxis1 < this.semiAxis2) {
                Bparam1 += 1.5707963267948966;
                Bparam2 += 1.5707963267948966;
            }
            if ((proj = this.checkProjection(this.parameterDomain().wrap(Bparam1), point, dTol2)) != null) {
                projList.addPoint(proj);
            }
            if ((proj = this.checkProjection(this.parameterDomain().wrap(Bparam2), point, dTol2)) != null) {
                projList.addPoint(proj);
            }
            ++i;
        }
        return projList.toJgclPointOnCurve2DArray();
    }

    double getPeak(double left, double right) {
        double peak = Math.atan2(Math.cos(left) - Math.cos(right), Math.sin(right) - Math.sin(left));
        while (peak < left) {
            peak += Math.PI;
        }
        while (peak > right) {
            peak -= Math.PI;
        }
        return peak;
    }

    public JgclPureBezierCurve2D[] toPolyBezierCurves(JgclParameterSection pint) {
        double increaseP;
        int nCurves;
        double increase = pint.increase();
        if (Math.abs(increase) > Math.PI * 2) {
            nCurves = 3;
            increaseP = increase > 0.0 ? 2.0943951023931953 : -2.0943951023931953;
        } else if (Math.abs(increase) > 5.026548245743669) {
            nCurves = 3;
            increaseP = increase / 3.0;
        } else if (Math.abs(increase) > 2.5132741228718345) {
            nCurves = 2;
            increaseP = increase / 2.0;
        } else {
            nCurves = 1;
            increaseP = increase;
        }
        JgclCartesianTransformationOperator2D localTransformationOperator = this.position().toCartesianTransformationOperator(1.0);
        JgclPureBezierCurve2D[] bzcs = new JgclPureBezierCurve2D[nCurves];
        int i = 0;
        double startP = pint.start();
        while (i < nCurves) {
            double d;
            JgclParameterSection pintl = new JgclParameterSection(startP, increaseP);
            JgclPoint2D[] controlPoints = this.getControlPointsOfBezierCurve(pintl);
            double[] weights = new double[]{1.0, 1.0, 1.0};
            JgclVector2D mvec = controlPoints[2].subtract(controlPoints[0]);
            JgclVector2D tmvec = localTransformationOperator.toLocal(mvec).unitized();
            double tmpBuf = this.xRadius() * tmvec.y();
            double shoulderParam = Math.abs(d) > JgclMachineEpsilon.DOUBLE ? Math.atan(-(this.yRadius() * tmvec.x()) / tmpBuf) : 1.5707963267948966;
            while (shoulderParam < pintl.lower()) {
                shoulderParam += Math.PI;
            }
            while (shoulderParam > pintl.upper()) {
                shoulderParam -= Math.PI;
            }
            JgclPoint2D shoulderPoint = this.coordinates(shoulderParam);
            JgclPoint2D middlePoint = controlPoints[0].midPoint(controlPoints[2]);
            double vvv = Math.sqrt(shoulderPoint.subtract(middlePoint).norm() / controlPoints[1].subtract(middlePoint).norm());
            weights[1] = vvv / (1.0 - vvv);
            bzcs[i] = new JgclPureBezierCurve2D(controlPoints, weights);
            ++i;
            startP += increaseP;
        }
        return bzcs;
    }

    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
        JgclPureBezierCurve2D[] bzcs = this.toPolyBezierCurves(pint);
        boolean closed = Math.abs(pint.increase()) >= Math.PI * 2;
        return JgclConic2D.convertPolyBezierCurvesToOneBsplineCurve(bzcs, closed);
    }

    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    JgclRealPolynomial makePoly(JgclRealPolynomial[] poly) {
        JgclRealPolynomial xPoly = poly[0].multiply(poly[0]);
        JgclRealPolynomial yPoly = poly[1].multiply(poly[1]);
        double dAlrd2 = this.xRadius() * this.xRadius();
        double dAsrd2 = this.yRadius() * this.yRadius();
        boolean isPoly = poly.length < 3;
        int degree = xPoly.degree();
        double[] coef = new double[degree + 1];
        if (isPoly) {
            int j = 0;
            while (j <= degree) {
                coef[j] = xPoly.coefficientAt(j) / dAlrd2 + yPoly.coefficientAt(j) / dAsrd2;
                ++j;
            }
            coef[0] = coef[0] - 1.0;
        } else {
            JgclRealPolynomial wPoly = poly[2].multiply(poly[2]);
            int j = 0;
            while (j <= degree) {
                coef[j] = dAsrd2 * xPoly.coefficientAt(j) + dAlrd2 * yPoly.coefficientAt(j) - dAlrd2 * dAsrd2 * wPoly.coefficientAt(j);
                ++j;
            }
        }
        return new JgclRealPolynomial(coef);
    }

    boolean checkSolution(JgclPoint2D point) {
        double param = this.getParameter(point);
        double px = this.xRadius() * Math.cos(param);
        double py = this.yRadius() * Math.sin(param);
        return point.identical(new JgclCartesianPoint2D(px, py));
    }

    double getParameter(JgclPoint2D point) {
        double cos = point.x() / this.xRadius();
        if (cos > 1.0) {
            cos = 1.0;
        }
        if (cos < -1.0) {
            cos = -1.0;
        }
        double acos = Math.acos(cos);
        if (point.y() < 0.0) {
            acos = Math.PI * 2 - acos;
        }
        return acos;
    }

    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
        JgclIntsLinCnc2D doObj = new JgclIntsLinCnc2D(mate, this);
        return doObj.intersection(mate, this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCircle2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclEllipse2D mate, boolean doExchange) throws JgclIndefiniteSolution {
        double d_tol = this.getToleranceForDistance();
        if (this.position().location().identical(mate.position().location())) {
            if (this.position().x().parallelDirection(mate.position().x()) && Math.abs(this.xRadius() - mate.xRadius()) <= d_tol && Math.abs(this.yRadius() - mate.yRadius()) <= d_tol) {
                double mateParam = this.position().x().dotProduct(mate.position().x()) > 0.0 ? 0.0 : Math.PI;
                JgclIntersectionPoint2D one_sol = !doExchange ? new JgclIntersectionPoint2D(this, 0.0, mate, mateParam, false) : new JgclIntersectionPoint2D(mate, mateParam, this, 0.0, false);
                throw new JgclIndefiniteSolution(one_sol);
            }
            if (this.position().x().parallelDirection(mate.position().y()) && Math.abs(this.xRadius() - mate.yRadius()) <= d_tol && Math.abs(this.yRadius() - mate.xRadius()) <= d_tol) {
                double mateParam = this.position().x().dotProduct(mate.position().y()) > 0.0 ? 1.5707963267948966 : 4.71238898038469;
                JgclIntersectionPoint2D one_sol = !doExchange ? new JgclIntersectionPoint2D(this, 0.0, mate, mateParam, false) : new JgclIntersectionPoint2D(mate, mateParam, this, 0.0, false);
                throw new JgclIndefiniteSolution(one_sol);
            }
        }
        JgclIntsEllCnc2D doObj = new JgclIntsEllCnc2D();
        return doObj.intersection(this, mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclParabola2D mate, boolean doExchange) {
        JgclIntsEllCnc2D doObj = new JgclIntsEllCnc2D();
        return doObj.intersection(this, mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D mate, boolean doExchange) {
        JgclIntsEllCnc2D doObj = new JgclIntsEllCnc2D();
        return doObj.intersection(this, mate, doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    public JgclBsplineCurve2D offsetByBsplineCurve(JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tol) {
        JgclOfst2D doObj = new JgclOfst2D(this, pint, magni, side, tol);
        return doObj.offset();
    }

    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    public JgclCommonNormal2D[] commonNormal(JgclParametricCurve2D mate) {
        throw new JgclNotSupported();
    }

    JgclParameterDomain getParameterDomain() {
        try {
            return new JgclParameterDomain(true, 0.0, Math.PI * 2);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    boolean getClosedFlag() {
        return true;
    }

    int type() {
        return 11;
    }

    protected synchronized JgclParametricCurve2D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        double tSemiAxis2;
        double tSemiAxis1;
        JgclAxis2Placement2D tPosition = this.position().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        if (!reverseTransform) {
            tSemiAxis1 = transformationOperator.transform(this.semiAxis1());
            tSemiAxis2 = transformationOperator.transform(this.semiAxis2());
        } else {
            tSemiAxis1 = transformationOperator.reverseTransform(this.semiAxis1());
            tSemiAxis2 = transformationOperator.reverseTransform(this.semiAxis2());
        }
        return new JgclEllipse2D(tPosition, tSemiAxis1, tSemiAxis2);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tposition");
        this.position().output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tsemiAxis1 " + this.semiAxis1);
        writer.println(String.valueOf(indent_tab) + "\tsemiAxis2 " + this.semiAxis2);
        writer.println(String.valueOf(indent_tab) + "End");
    }

    private static final class 1
    implements JgclRealFunctionWithOneVariable {
        private final /* synthetic */ double val$m2eal_minrd2;
        private final /* synthetic */ double val$m2eal_majrd2;

        public double evaluate(double parameter) {
            double ecos = Math.cos(parameter);
            double esin = Math.sin(parameter);
            return Math.sqrt(this.val$m2eal_majrd2 * esin * esin + this.val$m2eal_minrd2 * ecos * ecos);
        }

        /* synthetic */ 1(double val$m2eal_majrd2, double val$m2eal_minrd2) {
            this.val$m2eal_majrd2 = val$m2eal_majrd2;
            this.val$m2eal_minrd2 = val$m2eal_minrd2;
        }
    }
}

