/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclAxis2Placement2D;
import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclBsplineCurve2D;
import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclConicalSurface3D;
import jp.go.ipa.jgcl.JgclElementarySurface3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclIntsCylCon3D;
import jp.go.ipa.jgcl.JgclIntsCylCyl3D;
import jp.go.ipa.jgcl.JgclIntsQrdBzs3D;
import jp.go.ipa.jgcl.JgclIntsSphCyl3D;
import jp.go.ipa.jgcl.JgclIntsSrfBss3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclMesh3D;
import jp.go.ipa.jgcl.JgclOfst3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclSphericalSurface3D;
import jp.go.ipa.jgcl.JgclSurfaceCurvature3D;
import jp.go.ipa.jgcl.JgclSurfaceDerivative3D;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterference3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclCylindricalSurface3D
extends JgclElementarySurface3D {
    private double radius;

    private void setRadius(double radius) {
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol = condition.getToleranceForDistance();
        if (radius < dTol) {
            throw new JgclInvalidArgumentValue();
        }
        this.radius = radius;
    }

    public JgclCylindricalSurface3D(JgclAxis2Placement3D position, double radius) {
        super(position);
        this.setRadius(radius);
    }

    public JgclCylindricalSurface3D(JgclPoint3D cntr, JgclVector3D axis, double radius) {
        super(new JgclAxis2Placement3D(cntr, axis, axis.verticalVector().unitized()));
        this.setRadius(radius);
    }

    public double radius() {
        return this.radius;
    }

    public JgclPoint3D coordinates(double uParam, double vParam) {
        JgclCartesianTransformationOperator3D gtrans = this.toGlobal();
        double x = this.radius * Math.cos(uParam);
        double y = this.radius * Math.sin(uParam);
        JgclCartesianPoint3D pnt = new JgclCartesianPoint3D(x, y, vParam);
        return gtrans.transform(pnt);
    }

    public JgclVector3D[] tangentVector(double uParam, double vParam) {
        JgclCartesianTransformationOperator3D gtrans = this.toGlobal();
        double dux = -this.radius * Math.sin(uParam);
        double duy = this.radius * Math.cos(uParam);
        JgclLiteralVector3D dup = new JgclLiteralVector3D(dux, duy, 0.0);
        JgclVector3D dvp = JgclVector3D.zUnitVector;
        JgclVector3D[] tang = new JgclVector3D[]{gtrans.transform(dup), gtrans.transform(dvp)};
        return tang;
    }

    public JgclVector3D normalVector(double uParam, double vParam) {
        JgclCartesianTransformationOperator3D gtrans = this.toGlobal();
        double x = this.radius * Math.cos(uParam);
        double y = this.radius * Math.sin(uParam);
        JgclLiteralVector3D nrm = new JgclLiteralVector3D(x, y, 0.0);
        return gtrans.transform(nrm).unitized();
    }

    public JgclSurfaceCurvature3D curvature(double uParam, double vParam) {
        JgclVector3D[] tangent = this.tangentVector(uParam, vParam);
        return new JgclSurfaceCurvature3D(-1.0 / this.radius, tangent[0].unitized(), 0.0, tangent[1].unitized());
    }

    public JgclSurfaceDerivative3D evaluation(double uParam, double vParam) {
        JgclCartesianTransformationOperator3D gtrans = this.toGlobal();
        double x = this.radius * Math.cos(uParam);
        double y = this.radius * Math.sin(uParam);
        JgclCartesianPoint3D pnt = new JgclCartesianPoint3D(x, y, vParam);
        JgclLiteralVector3D dup = new JgclLiteralVector3D(-y, x, 0.0);
        JgclVector3D dvp = JgclVector3D.zUnitVector;
        JgclLiteralVector3D duup = new JgclLiteralVector3D(-x, -y, 0.0);
        JgclVector3D zerov = JgclVector3D.zeroVector;
        return new JgclSurfaceDerivative3D(gtrans.transform(pnt), gtrans.transform(dup), gtrans.transform(dvp), gtrans.transform(duup), gtrans.transform(zerov), gtrans.transform(zerov));
    }

    public JgclPointOnSurface3D[] projectFrom(JgclPoint3D point) throws JgclIndefiniteSolution {
        JgclCartesianTransformationOperator3D gtrans = this.toGlobal();
        JgclPoint3D lpoint = gtrans.reverseTransform(point);
        double z = lpoint.z();
        JgclCartesianPoint3D apoint = new JgclCartesianPoint3D(0.0, 0.0, z);
        JgclVector3D eduvec = lpoint.subtract(apoint);
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol = Math.abs(condition.getToleranceForDistance());
        if (eduvec.length() < dTol) {
            JgclPointOnSurface3D p;
            try {
                p = new JgclPointOnSurface3D(this, 0.0, z, false);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            throw new JgclIndefiniteSolution(p);
        }
        double u = Math.atan2((eduvec = eduvec.unitized()).y(), eduvec.x());
        if (u < 0.0) {
            u += Math.PI * 2;
        }
        JgclPointOnSurface3D foot1 = new JgclPointOnSurface3D(this, u, z, false);
        if ((u += Math.PI) >= Math.PI * 2) {
            u -= Math.PI * 2;
        }
        JgclPointOnSurface3D foot2 = new JgclPointOnSurface3D(this, u, z, false);
        JgclPointOnSurface3D[] proj = new JgclPointOnSurface3D[]{foot1, foot2};
        return proj;
    }

    public JgclMesh3D toMesh(JgclParameterSection uPint, JgclParameterSection vPint, JgclToleranceForDistance tol) {
        return this.makeMesh(1, uPint, vPint, tol);
    }

    private JgclMesh3D makeMesh(int meshType, JgclParameterSection uPint, JgclParameterSection vPint, JgclToleranceForDistance tol) {
        JgclPoint3D[][] mesh;
        JgclVector3D vec2;
        JgclPolyline3D pol;
        JgclPoint3D pnt;
        double vStart = vPint.start();
        double vEnd = vPint.end();
        double vMiddle = (vStart + vEnd) / 2.0;
        try {
            JgclCartesianTransformationOperator3D gtrans = this.toGlobal();
            pnt = new JgclCartesianPoint3D(0.0, 0.0, vStart);
            JgclPoint3D cntr = gtrans.transform(pnt);
            JgclAxis2Placement3D pos = new JgclAxis2Placement3D(cntr, this.position().z(), this.position().x());
            JgclCircle3D cir = new JgclCircle3D(pos, this.radius());
            pol = cir.toPolyline(uPint, tol);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
        int u_npnts = pol.nPoints();
        JgclVector3D vec = this.position().z().multiply(vPint.increase());
        if (meshType == 1) {
            vec2 = null;
            mesh = new JgclPointOnSurface3D[u_npnts][2];
        } else {
            vec2 = this.position().z().multiply(vPint.increase() / 2.0);
            mesh = new JgclPointOnSurface3D[u_npnts][3];
        }
        int i = 0;
        while (i < u_npnts) {
            try {
                JgclPointOnCurve3D poc = (JgclPointOnCurve3D)pol.pointAt(i);
                pnt = new JgclCartesianPoint3D(poc.x(), poc.y(), poc.z());
                double uParam = poc.parameter();
                mesh[i][0] = new JgclPointOnSurface3D(pnt, this, uParam, vStart, false);
                if (meshType == 1) {
                    pnt = pnt.add(vec);
                    mesh[i][1] = new JgclPointOnSurface3D(pnt, this, uParam, vEnd, false);
                } else {
                    JgclPoint3D pnt2 = pnt.add(vec2);
                    mesh[i][1] = new JgclPointOnSurface3D(pnt, this, uParam, vMiddle, false);
                    pnt = pnt.add(vec);
                    mesh[i][2] = new JgclPointOnSurface3D(pnt, this, uParam, vEnd, false);
                }
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            ++i;
        }
        return new JgclMesh3D(mesh, false);
    }

    public JgclBsplineSurface3D toBsplineSurface(JgclParameterSection uPint, JgclParameterSection vPint) {
        JgclCircle2D circle2D = new JgclCircle2D(JgclAxis2Placement2D.origin, this.radius());
        JgclBsplineCurve2D uBsplineCurve2D = circle2D.toBsplineCurve(uPint);
        int uNPoints = uBsplineCurve2D.nControlPoints();
        int vNPoints = 2;
        JgclPoint3D[][] controlPoints = new JgclPoint3D[uNPoints][vNPoints];
        double[][] weights = new double[uNPoints][vNPoints];
        JgclCartesianTransformationOperator3D localTransformationOperator = this.position().toCartesianTransformationOperator(1.0);
        double vLowerCoord = vPint.start();
        double vUpperCoord = vPint.end();
        int ui = 0;
        while (ui < uNPoints) {
            JgclPoint2D uPoint = uBsplineCurve2D.controlPointAt(ui);
            controlPoints[ui][0] = localTransformationOperator.toEnclosed(uPoint.to3D(vLowerCoord));
            controlPoints[ui][1] = localTransformationOperator.toEnclosed(uPoint.to3D(vUpperCoord));
            double d = uBsplineCurve2D.weightAt(ui);
            weights[ui][1] = d;
            weights[ui][0] = d;
            ++ui;
        }
        return new JgclBsplineSurface3D(uBsplineCurve2D.knotData(), JgclBsplineKnot.quasiUniformKnotsOfLinearOneSegment, controlPoints, weights);
    }

    boolean checkSolution(JgclPoint3D point) {
        double dTol = this.getToleranceForDistance();
        double dist = Math.sqrt(point.x() * point.x() + point.y() * point.y());
        return Math.abs(dist - this.radius()) < dTol;
    }

    JgclRealPolynomial makePoly(JgclRealPolynomial[] poly) {
        JgclRealPolynomial xPoly = poly[0].multiply(poly[0]);
        JgclRealPolynomial yPoly = poly[1].multiply(poly[1]);
        double radius2 = this.radius() * this.radius();
        boolean isPoly = poly.length < 4;
        int degree = xPoly.degree();
        double[] coef = new double[degree + 1];
        if (isPoly) {
            int j = 0;
            while (j <= degree) {
                coef[j] = xPoly.coefficientAt(j) + yPoly.coefficientAt(j);
                ++j;
            }
            coef[0] = coef[0] - radius2;
        } else {
            JgclRealPolynomial wPoly = poly[3].multiply(poly[3]);
            int j = 0;
            while (j <= degree) {
                coef[j] = xPoly.coefficientAt(j) + yPoly.coefficientAt(j) - radius2 * wPoly.coefficientAt(j);
                ++j;
            }
        }
        return new JgclRealPolynomial(coef);
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        double aTol = this.getToleranceForAngle();
        double dTol = this.getToleranceForDistance();
        JgclVector3D unit_dir = mate.dir().unitized();
        JgclVector3D cyl_axis = this.position().z();
        JgclPoint3D cyl_org = this.position().location();
        if (Math.abs(unit_dir.dotProduct(cyl_axis)) > Math.cos(aTol)) {
            JgclVector3D pnt_to_org = cyl_org.subtract(mate.pnt());
            double innerProduct = pnt_to_org.dotProduct(unit_dir);
            double[] pnt = new double[]{mate.pnt().x() + innerProduct * unit_dir.x(), mate.pnt().y() + innerProduct * unit_dir.y(), mate.pnt().z() + innerProduct * unit_dir.z()};
            JgclCartesianPoint3D projected_org = new JgclCartesianPoint3D(pnt[0], pnt[1], pnt[2]);
            JgclVector3D org_to_line = projected_org.subtract(cyl_org);
            if (Math.abs(org_to_line.length() - this.radius()) < dTol) {
                throw new JgclIndefiniteSolution(mate.pnt());
            }
            return new JgclIntersectionPoint3D[0];
        }
        JgclCartesianTransformationOperator3D trans = new JgclCartesianTransformationOperator3D(this.position(), 1.0);
        JgclPoint3D ppnt = trans.reverseTransform(mate.pnt());
        JgclVector3D pvector = trans.reverseTransform(mate.dir());
        JgclLine3D translated_line = new JgclLine3D(ppnt, pvector);
        JgclCartesianPoint2D cir_org = new JgclCartesianPoint2D(0.0, 0.0);
        JgclCircle2D circle = new JgclCircle2D(cir_org, this.radius());
        JgclLine2D line2 = mate.toLocal2D(trans);
        JgclIntersectionPoint2D[] int_pnt2d = new JgclIntersectionPoint2D[]{};
        try {
            int_pnt2d = circle.intersect(line2);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {}
        if (int_pnt2d.length == 0) {
            return new JgclIntersectionPoint3D[0];
        }
        JgclIntersectionPoint3D[] int_pnt = new JgclIntersectionPoint3D[int_pnt2d.length];
        int i = 0;
        while (i < int_pnt2d.length) {
            double line_param = int_pnt2d[i].pointOnCurve2().parameter();
            double cyl_param = int_pnt2d[i].pointOnCurve1().parameter();
            JgclPoint3D pnt = mate.coordinates(line_param);
            double height_param = translated_line.pnt().z() + line_param * translated_line.dir().z();
            JgclPointOnCurve3D PonC = new JgclPointOnCurve3D(pnt, mate, line_param, false);
            JgclPointOnSurface3D PonS = new JgclPointOnSurface3D(pnt, this, cyl_param, height_param, false);
            int_pnt[i] = doExchange ? new JgclIntersectionPoint3D(pnt, PonC, PonS, false) : new JgclIntersectionPoint3D(pnt, PonS, PonC, false);
            ++i;
        }
        return int_pnt;
    }

    public JgclSurfaceSurfaceInterference3D[] intersect(JgclParametricSurface3D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclPlane3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclSphericalSurface3D mate, boolean doExchange) {
        return JgclIntsSphCyl3D.intersection(mate, this, !doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclCylindricalSurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return JgclIntsCylCyl3D.intersection(this, mate, doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclConicalSurface3D mate, boolean doExchange) {
        return JgclIntsCylCon3D.intersection(this, mate, doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclPureBezierSurface3D mate, boolean doExchange) {
        return JgclIntsQrdBzs3D.intersection(this, mate, doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclBsplineSurface3D mate, boolean doExchange) {
        return JgclIntsSrfBss3D.intersection(this, mate, doExchange);
    }

    public JgclBsplineSurface3D offsetByBsplineSurface(JgclParameterSection uPint, JgclParameterSection vPint, double magni, int side, JgclToleranceForDistance tol) {
        JgclOfst3D doObj = new JgclOfst3D(this, uPint, vPint, magni, side, tol);
        return doObj.offset();
    }

    public JgclParametricCurve3D uIsoParametricCurve(double uParam) {
        JgclPoint3D pnt = this.coordinates(uParam, 0.0);
        JgclVector3D dir = this.position().z();
        return new JgclLine3D(pnt, dir);
    }

    public JgclParametricCurve3D vIsoParametricCurve(double vParam) {
        JgclPoint3D pnt = this.position().location().add(this.position().z().multiply(vParam));
        JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(pnt, this.position().z(), this.position().x());
        return new JgclCircle3D(a2p, this.radius());
    }

    JgclParameterDomain getUParameterDomain() {
        try {
            return new JgclParameterDomain(true, 0.0, Math.PI * 2);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    JgclParameterDomain getVParameterDomain() {
        return new JgclParameterDomain();
    }

    int type() {
        return 10;
    }

    boolean isParallel(JgclCylindricalSurface3D mate) {
        JgclVector3D mateAxis;
        JgclVector3D thisAxis = this.position().z();
        double dot = thisAxis.dotProduct(mateAxis = mate.position().z());
        return Math.abs(dot) > Math.cos(this.getToleranceForAngle());
    }

    boolean equals(JgclCylindricalSurface3D mate) {
        if (this.isParallel(mate)) {
            double dTol;
            JgclPoint3D source = mate.position().location();
            JgclPointOnCurve3D[] foot = this.getAxis().projectFrom(source);
            if (foot.length != 1) {
                throw new JgclFatal();
            }
            double dist = source.distance(foot[0]);
            if (dist < (dTol = this.getToleranceForDistance()) && Math.abs(this.radius() - mate.radius()) < dTol) {
                return true;
            }
        }
        return false;
    }

    JgclLine3D getAxis() {
        return new JgclLine3D(this.position().location(), this.position().z());
    }

    public Vector toNonStructuredPoints(JgclParameterSection uParameterSection, JgclParameterSection vParameterSection, double tolerance, double[] scalingFactor) {
        Vector<JgclPoint3D> result = new Vector<JgclPoint3D>();
        JgclMesh3D mesh = this.makeMesh(2, uParameterSection, vParameterSection, new JgclToleranceForDistance(tolerance));
        int u = 0;
        while (u < mesh.uNPoints()) {
            int v = 0;
            while (v < mesh.vNPoints()) {
                result.addElement(mesh.pointAt(u, v));
                ++v;
            }
            ++u;
        }
        scalingFactor[0] = this.radius();
        scalingFactor[1] = 1.0;
        return result;
    }

    protected synchronized JgclParametricSurface3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclAxis2Placement3D tPosition = this.position().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        double tRadius = !reverseTransform ? transformationOperator.transform(this.radius()) : transformationOperator.reverseTransform(this.radius());
        return new JgclCylindricalSurface3D(tPosition, tRadius);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tposition");
        this.position().output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tradius\t" + this.radius);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

