/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclBoundedCurve2D;
import jp.go.ipa.jgcl.JgclBoundedCurve3D;
import jp.go.ipa.jgcl.JgclBoundedLine2D;
import jp.go.ipa.jgcl.JgclBoundedSurface3D;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclCompositeCurve2D;
import jp.go.ipa.jgcl.JgclCompositeCurve3D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment2D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment3D;
import jp.go.ipa.jgcl.JgclConic3D;
import jp.go.ipa.jgcl.JgclConicalSurface3D;
import jp.go.ipa.jgcl.JgclCylindricalSurface3D;
import jp.go.ipa.jgcl.JgclEnclosingBox2D;
import jp.go.ipa.jgcl.JgclException;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclFilletObject3D;
import jp.go.ipa.jgcl.JgclFilletSection3D;
import jp.go.ipa.jgcl.JgclGeometry;
import jp.go.ipa.jgcl.JgclImproperOperation;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionCurve3D;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclListSorter;
import jp.go.ipa.jgcl.JgclMesh3D;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclOpenCurve;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterOutOfRange;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPointOnGeometry3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclRectangularTrimmedSurface3D;
import jp.go.ipa.jgcl.JgclSetOfTriangles3D;
import jp.go.ipa.jgcl.JgclSphericalSurface3D;
import jp.go.ipa.jgcl.JgclSurfaceCurve3D;
import jp.go.ipa.jgcl.JgclSurfaceDerivative3D;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterference3D;
import jp.go.ipa.jgcl.JgclSweptSurface3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve2D;
import jp.go.ipa.jgcl.JgclTrimmedCurve3D;
import jp.go.ipa.jgcl.JgclVector2D;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclCurveBoundedSurface3D
extends JgclBoundedSurface3D {
    private JgclParametricSurface3D basisSurface;
    private JgclCompositeCurve3D outerBoundary;
    private Vector innerBoundaries;
    private JgclCompositeCurve2D outerBoundary2D;
    private Vector innerBoundaries2D;
    private JgclEnclosingBox2D enclosingBox2D;

    public JgclParametricSurface3D basisSurface() {
        return this.basisSurface;
    }

    public JgclCompositeCurve3D outerBoundary() {
        return this.outerBoundary;
    }

    public int numberOfInnerBoundaries() {
        return this.innerBoundaries.size();
    }

    public JgclCompositeCurve3D innerBoundary(int i) {
        return (JgclCompositeCurve3D)this.innerBoundaries.elementAt(i);
    }

    public JgclCompositeCurve2D outerBoundary2D() {
        return this.outerBoundary2D;
    }

    public JgclCompositeCurve2D innerBoundary2D(int i) {
        return (JgclCompositeCurve2D)this.innerBoundaries2D.elementAt(i);
    }

    public JgclEnclosingBox2D enclosingBox2D() {
        return this.enclosingBox2D;
    }

    private static String compositeCurveIsValidForBoundary(JgclCompositeCurve3D compositeCurve, JgclParametricSurface3D basisSurface) {
        if (!compositeCurve.isClosed()) {
            return "A composite curve is not closed";
        }
        int i = 0;
        while (i < compositeCurve.nSegments()) {
            JgclSurfaceCurve3D basis;
            JgclTrimmedCurve3D parent;
            JgclCompositeCurveSegment3D segment = compositeCurve.segmentAt(i);
            try {
                parent = (JgclTrimmedCurve3D)segment.parentCurve();
            }
            catch (ClassCastException classCastException) {
                return "The parent of a segment is not JgclTrimmedCurve3D";
            }
            try {
                basis = (JgclSurfaceCurve3D)parent.basisCurve();
            }
            catch (ClassCastException classCastException) {
                return "The basis of the parent of a segment is not JgclSurfaceCurve3D";
            }
            if (basis.basisSurface() != basisSurface) {
                return "The basis surface of a segment is not same as given surface";
            }
            ++i;
        }
        return null;
    }

    private static JgclCompositeCurve2D make2DCurve(JgclCompositeCurve3D boundary3D) {
        int nSegments = boundary3D.nSegments();
        JgclBoundedCurve2D[] segments2D = new JgclBoundedCurve2D[nSegments];
        boolean[] senses2D = new boolean[nSegments];
        int i = 0;
        while (i < nSegments) {
            JgclCompositeCurveSegment3D segment = boundary3D.segmentAt(i);
            JgclTrimmedCurve3D parent = (JgclTrimmedCurve3D)segment.parentCurve();
            JgclSurfaceCurve3D basis = (JgclSurfaceCurve3D)parent.basisCurve();
            segments2D[i] = new JgclTrimmedCurve2D(basis.curve2d(), parent.tParam1(), parent.tParam2(), parent.senseAgreement());
            senses2D[i] = segment.sameSense();
            ++i;
        }
        return new JgclCompositeCurve2D(segments2D, senses2D);
    }

    private void makeEnclosingBox2D() {
        JgclPoint2D[] points = new JgclPoint2D[(this.innerBoundaries2D.size() + 1) * 2];
        JgclToleranceForDistance tolD = this.getToleranceForDistanceAsObject();
        JgclEnclosingBox2D box = this.outerBoundary2D.toPolyline(tolD).enclosingBox();
        points[0] = box.min();
        points[1] = box.max();
        int i = 0;
        while (i < this.innerBoundaries2D.size()) {
            JgclCompositeCurve2D inner = (JgclCompositeCurve2D)this.innerBoundaries2D.elementAt(i);
            box = inner.toPolyline(tolD).enclosingBox();
            points[(i + 1) * 2] = box.min();
            points[(i + 1) * 2 + 1] = box.max();
            ++i;
        }
        this.enclosingBox2D = new JgclEnclosingBox2D(points);
    }

    public JgclCurveBoundedSurface3D(JgclParametricSurface3D basisSurface, JgclCompositeCurve3D outerBoundary, Vector innerBoundaries) {
        if (basisSurface.type() == 33) {
            throw new JgclInvalidArgumentValue("The basis surface is JgclCurveBoundedSurface3D");
        }
        this.basisSurface = basisSurface;
        String message = JgclCurveBoundedSurface3D.compositeCurveIsValidForBoundary(outerBoundary, basisSurface);
        if (message != null) {
            throw new JgclInvalidArgumentValue(message);
        }
        this.outerBoundary = outerBoundary;
        this.outerBoundary2D = JgclCurveBoundedSurface3D.make2DCurve(outerBoundary);
        this.innerBoundaries = new Vector();
        this.innerBoundaries2D = new Vector();
        if (innerBoundaries != null) {
            Enumeration e = innerBoundaries.elements();
            while (e.hasMoreElements()) {
                try {
                    JgclCompositeCurve3D inner = (JgclCompositeCurve3D)e.nextElement();
                    message = JgclCurveBoundedSurface3D.compositeCurveIsValidForBoundary(inner, basisSurface);
                    if (message != null) {
                        throw new JgclInvalidArgumentValue(message);
                    }
                    this.innerBoundaries.addElement(inner);
                    this.innerBoundaries2D.addElement(JgclCurveBoundedSurface3D.make2DCurve(inner));
                }
                catch (ClassCastException classCastException) {
                    throw new JgclInvalidArgumentValue("An inner boundary is not JgclCompositeCurve3D");
                }
            }
        }
        this.makeEnclosingBox2D();
    }

    JgclParameterDomain getUParameterDomain() {
        throw new JgclImproperOperation();
    }

    JgclParameterDomain getVParameterDomain() {
        throw new JgclImproperOperation();
    }

    int type() {
        return 33;
    }

    public boolean isFreeform() {
        return this.basisSurface.isFreeform();
    }

    public JgclPoint3D coordinates(double uParam, double vParam) {
        if (!this.contains(uParam, vParam)) {
            throw new JgclParameterOutOfRange();
        }
        return this.basisSurface.coordinates(uParam, vParam);
    }

    public JgclVector3D[] tangentVector(double uParam, double vParam) {
        if (!this.contains(uParam, vParam)) {
            throw new JgclParameterOutOfRange();
        }
        return this.basisSurface.tangentVector(uParam, vParam);
    }

    public JgclSurfaceDerivative3D evaluation(double uParam, double vParam) {
        if (!this.contains(uParam, vParam)) {
            throw new JgclParameterOutOfRange();
        }
        return this.basisSurface.evaluation(uParam, vParam);
    }

    public JgclPointOnSurface3D[] projectFrom(JgclPoint3D point) throws JgclIndefiniteSolution {
        JgclPointOnSurface3D[] pointsOnBasisSurface = this.basisSurface.projectFrom(point);
        if (pointsOnBasisSurface == null) {
            return new JgclPointOnSurface3D[0];
        }
        if (pointsOnBasisSurface.length == 0) {
            return pointsOnBasisSurface;
        }
        Vector<JgclPointOnSurface3D> innerPoints = new Vector<JgclPointOnSurface3D>();
        int i = 0;
        while (i < pointsOnBasisSurface.length) {
            double vParam;
            double uParam = this.basisSurface.uParameterDomain().wrap(pointsOnBasisSurface[i].uParameter());
            JgclCartesianPoint2D point2D = JgclPoint2D.of(uParam, vParam = this.basisSurface.vParameterDomain().wrap(pointsOnBasisSurface[i].vParameter()));
            if (this.contains(point2D)) {
                JgclPointOnSurface3D pos = new JgclPointOnSurface3D(this, uParam, vParam, false);
                innerPoints.addElement(pos);
            }
            ++i;
        }
        Object[] results = new JgclPointOnSurface3D[innerPoints.size()];
        innerPoints.copyInto(results);
        return results;
    }

    public JgclMesh3D toMesh(JgclToleranceForDistance tol) {
        throw new JgclImproperOperation();
    }

    public JgclMesh3D toMesh(JgclParameterSection uPint, JgclParameterSection vPint, JgclToleranceForDistance tol) {
        throw new JgclImproperOperation();
    }

    public JgclBsplineSurface3D toBsplineSurface(JgclParameterSection uPint, JgclParameterSection vPint) {
        throw new JgclImproperOperation();
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) throws JgclIndefiniteSolution {
        JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate);
        return this.selectInternalIntersections(results, false);
    }

    JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate);
        return this.selectInternalIntersections(results, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate, doExchange);
        return this.selectInternalIntersections(results, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclConic3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate, doExchange);
        return this.selectInternalIntersections(results, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate, doExchange);
        return this.selectInternalIntersections(results, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate, doExchange);
        return this.selectInternalIntersections(results, doExchange);
    }

    public JgclSurfaceSurfaceInterference3D[] intersect(JgclParametricSurface3D mate) throws JgclIndefiniteSolution {
        JgclSurfaceSurfaceInterference3D[] results;
        int basisType = this.basisSurface.type();
        if (basisType == 20 || basisType == 21) {
            JgclPoint2D[] minMax = this.enclosingBox2D.toArray();
            JgclParameterSection uPint = new JgclParameterSection(minMax[0].x(), minMax[1].x() - minMax[0].x());
            JgclParameterSection vPint = new JgclParameterSection(minMax[0].y(), minMax[1].y() - minMax[0].y());
            results = ((JgclSweptSurface3D)this.basisSurface).intersect(uPint, vPint, mate);
        } else {
            results = this.basisSurface.intersect(mate);
        }
        return this.trimIntersectionsWithBoundaries(mate, results, false);
    }

    public JgclBsplineSurface3D offsetByBsplineSurface(JgclParameterSection uPint, JgclParameterSection vPint, double magni, int side, JgclToleranceForDistance tol) {
        throw new JgclImproperOperation();
    }

    private JgclFilletObject3D trimFillet(JgclBoundedSurface3D mate, double radius, JgclPolyline3D fllt3, JgclPolyline2D flltT, JgclPolyline2D flltM, boolean isOpenT, JgclParameterSection sectionOfFlltT, boolean crossBoundary, double spT, double ipT) {
        double epT = spT + ipT;
        if (crossBoundary && isOpenT) {
            spT = this.wrapParameterIntoOpenSection(spT, sectionOfFlltT);
            epT = this.wrapParameterIntoOpenSection(epT, sectionOfFlltT);
        }
        JgclParameterSection pint = new JgclParameterSection(spT, epT - spT);
        JgclToleranceForDistance tolD = this.getToleranceForDistanceAsObject();
        JgclPolyline3D curve3 = fllt3.toPolyline(pint, tolD);
        JgclPolyline2D curveT = flltT.toPolyline(pint, tolD);
        JgclPolyline2D curveM = flltM.toPolyline(pint, tolD);
        JgclFilletSection3D[] sections = new JgclFilletSection3D[curve3.nPoints()];
        int i = 0;
        while (i < curve3.nPoints()) {
            JgclPointOnSurface3D pogT = new JgclPointOnSurface3D((JgclParametricSurface3D)this, curveT.pointAt(i), false);
            JgclPointOnSurface3D pogM = new JgclPointOnSurface3D((JgclParametricSurface3D)mate, curveM.pointAt(i), false);
            sections[i] = new JgclFilletSection3D(radius, curve3.pointAt(i), pogT, pogM);
            ++i;
        }
        return new JgclFilletObject3D(sections);
    }

    /*
     * Unable to fully structure code
     */
    JgclFilletObject3D[] trimFilletsWithBoundaries(JgclBoundedSurface3D mate, double radius, JgclFilletObject3D[] fillets) {
        results = new Vector<JgclFilletObject3D>();
        iwbiBothEnds = new IntersectionWithBoundaryInfo[2];
        comparator = new 1(iwbiBothEnds);
        i = 0;
        while (i < fillets.length) {
            block28: {
                block27: {
                    theFillet = fillets[i];
                    fllt3 = theFillet.curveOfCenter();
                    flltT = theFillet.curveOnSurface1();
                    flltM = theFillet.curveOnSurface2();
                    isOpen3 = true;
                    isOpenT = true;
                    isOpenM = true;
                    domainOfFlltT = flltT.parameterDomain();
                    sectionOfFlltT = domainOfFlltT.section();
                    listOfIntersectionsWithBoundaries = new Vector<IntersectionWithBoundaryInfo>();
                    j = -1;
                    while (j < this.innerBoundaries2D.size()) {
                        aBoundary = j == -1 ? this.outerBoundary2D : (JgclCompositeCurve2D)this.innerBoundaries2D.elementAt(j);
                        intsWithBoundary = this.getIntersectionsWithBoundary(aBoundary, flltT);
                        k = 0;
                        while (k < intsWithBoundary.length) {
                            iwbi = new IntersectionWithBoundaryInfo(j, intsWithBoundary[k].pointOnCurve1().parameter(), intsWithBoundary[k].pointOnCurve2().parameter());
                            listOfIntersectionsWithBoundaries.addElement(iwbi);
                            ++k;
                        }
                        ++j;
                    }
                    iwbiBothEnds[0] = null;
                    iwbiBothEnds[1] = null;
                    addEndPoints = false;
                    if (isOpen3) {
                        if (flltT.isFinite()) {
                            iwbiBothEnds[0] = new IntersectionWithBoundaryInfo(-100, 0.0, sectionOfFlltT.start());
                            iwbiBothEnds[1] = new IntersectionWithBoundaryInfo(-100, 0.0, sectionOfFlltT.end());
                            listOfIntersectionsWithBoundaries.addElement(iwbiBothEnds[0]);
                            listOfIntersectionsWithBoundaries.addElement(iwbiBothEnds[1]);
                            addEndPoints = true;
                        }
                    } else if (listOfIntersectionsWithBoundaries.size() == 1) {
                        iwbi = (IntersectionWithBoundaryInfo)listOfIntersectionsWithBoundaries.elementAt(0);
                        iwbi2 = new IntersectionWithBoundaryInfo(iwbi.boundaryIndex, iwbi.boundaryParameter, iwbi.curveParameter);
                        listOfIntersectionsWithBoundaries.addElement(iwbi2);
                    }
                    if (listOfIntersectionsWithBoundaries.size() != 0) break block27;
                    v0 = aParameter = flltT.isFinite() == true ? sectionOfFlltT.start() : 0.0;
                    if (this.containsWithWrapping(flltT.coordinates(aParameter))) {
                        results.addElement(theFillet);
                    }
                    break block28;
                }
                JgclListSorter.doSorting(listOfIntersectionsWithBoundaries, comparator);
                nIntervals = listOfIntersectionsWithBoundaries.size() - 1;
                listOfTrimmingIntervals = new Vector<TrimmingInterval>();
                trimmingInterval = null;
                sIdx = 0;
                sIwb = (IntersectionWithBoundaryInfo)listOfIntersectionsWithBoundaries.elementAt(0);
                j = 1;
                while (j <= nIntervals) {
                    block30: {
                        block29: {
                            sp = sIwb.curveParameter;
                            if (!isOpen3 && j >= nIntervals) break block29;
                            eIdx = j;
                            eIwb = (IntersectionWithBoundaryInfo)listOfIntersectionsWithBoundaries.elementAt(j);
                            crossBoundary = false;
                            ip = eIwb.curveParameter - sIwb.curveParameter;
                            if (sIwb != iwbiBothEnds[0] && eIwb != iwbiBothEnds[1] || !(Math.abs(ip) < this.getToleranceForParameter())) ** GOTO lbl-1000
                            sIdx = eIdx;
                            sIwb = eIwb;
                            break block30;
                        }
                        eIdx = 0;
                        eIwb = (IntersectionWithBoundaryInfo)listOfIntersectionsWithBoundaries.elementAt(0);
                        crossBoundary = true;
                        ip = eIwb.curveParameter - sIwb.curveParameter + sectionOfFlltT.increase();
                        if (Math.abs(ip) < this.getToleranceForParameter()) {
                            sIdx = eIdx;
                            sIwb = eIwb;
                        } else lbl-1000:
                        // 2 sources

                        {
                            mp = sp + ip / 2.0;
                            if (addEndPoints) {
                                if (j == 1) {
                                    mp = sp;
                                } else if (j == nIntervals) {
                                    mp = sp + ip;
                                }
                            }
                            if (crossBoundary && isOpenT) {
                                if (mp < sectionOfFlltT.lower()) {
                                    mp += sectionOfFlltT.absIncrease();
                                }
                                if (mp > sectionOfFlltT.upper()) {
                                    mp -= sectionOfFlltT.absIncrease();
                                }
                            }
                            if (this.containsWithWrapping(flltT.coordinates(mp))) {
                                if (trimmingInterval != null && trimmingInterval.eIdx == sIdx) {
                                    trimmingInterval.eIdx = eIdx;
                                } else {
                                    trimmingInterval = new TrimmingInterval(sIdx, eIdx);
                                    listOfTrimmingIntervals.addElement(trimmingInterval);
                                }
                            }
                            sIdx = eIdx;
                            sIwb = eIwb;
                        }
                    }
                    ++j;
                }
                nIntervals = listOfTrimmingIntervals.size();
                if (nIntervals > 1) {
                    head = (TrimmingInterval)listOfTrimmingIntervals.firstElement();
                    tail = (TrimmingInterval)listOfTrimmingIntervals.lastElement();
                    if (head.sIdx == tail.eIdx) {
                        head.sIdx = tail.sIdx;
                        --nIntervals;
                    }
                }
                j = 0;
                while (j < nIntervals) {
                    trimmingInterval = (TrimmingInterval)listOfTrimmingIntervals.elementAt(j);
                    sIwb = (IntersectionWithBoundaryInfo)listOfIntersectionsWithBoundaries.elementAt(trimmingInterval.sIdx);
                    eIwb = (IntersectionWithBoundaryInfo)listOfIntersectionsWithBoundaries.elementAt(trimmingInterval.eIdx);
                    sp = sIwb.curveParameter;
                    if (trimmingInterval.sIdx < trimmingInterval.eIdx) {
                        crossBoundary = false;
                        ip = eIwb.curveParameter - sIwb.curveParameter;
                    } else {
                        crossBoundary = true;
                        ip = eIwb.curveParameter - sIwb.curveParameter + sectionOfFlltT.increase();
                    }
                    if (!(ip < this.getToleranceForParameter())) {
                        theTrimmedFillet = this.trimFillet(mate, radius, fllt3, flltT, flltM, isOpenT, sectionOfFlltT, crossBoundary, sp, ip);
                        results.addElement(theTrimmedFillet);
                    }
                    ++j;
                }
            }
            ++i;
        }
        fillets = new JgclFilletObject3D[results.size()];
        results.copyInto(fillets);
        return fillets;
    }

    public JgclFilletObject3D[] fillet(int side1, JgclBoundedSurface3D mate, int side2, double radius) throws JgclIndefiniteSolution {
        JgclParameterSection uPint = new JgclParameterSection(this.enclosingBox2D.min().x(), this.enclosingBox2D.max().x() - this.enclosingBox2D.min().x());
        JgclParameterSection vPint = new JgclParameterSection(this.enclosingBox2D.min().y(), this.enclosingBox2D.max().y() - this.enclosingBox2D.min().y());
        JgclRectangularTrimmedSurface3D thisTrimmedBasis = new JgclRectangularTrimmedSurface3D(this.basisSurface, uPint, vPint);
        JgclFilletObject3D[] results = mate.fillet(side2, thisTrimmedBasis, side1, radius);
        int i = 0;
        while (i < results.length) {
            JgclFilletSection3D[] sections = results[i].sections();
            int j = 0;
            while (j < sections.length) {
                JgclPointOnSurface3D posT = sections[j].pointOnSurface2();
                JgclPointOnSurface3D pos = new JgclPointOnSurface3D(this, thisTrimmedBasis.toBasisUParameter(posT.uParameter()), thisTrimmedBasis.toBasisVParameter(posT.vParameter()), false);
                sections[j] = new JgclFilletSection3D(radius, sections[j].center(), pos, sections[j].pointOnSurface1());
                ++j;
            }
            results[i] = new JgclFilletObject3D(sections);
            ++i;
        }
        return this.trimFilletsWithBoundaries(mate, radius, results);
    }

    public JgclFilletObject3D[] fillet(JgclParameterSection uSect1, JgclParameterSection vSect1, int side1, JgclParametricSurface3D mate, JgclParameterSection uSect2, JgclParameterSection vSect2, int side2, double radius) throws JgclIndefiniteSolution {
        throw new JgclImproperOperation();
    }

    public JgclParametricCurve3D uIsoParametricCurve(double parameter) {
        throw new JgclImproperOperation();
    }

    public JgclParametricCurve3D vIsoParametricCurve(double parameter) {
        throw new JgclImproperOperation();
    }

    protected synchronized JgclParametricSurface3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclParametricSurface3D tBasisSurface = this.basisSurface.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        JgclCompositeCurve3D tOuterBoundary = (JgclCompositeCurve3D)this.outerBoundary.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        Vector<JgclParametricCurve3D> tInnerBoundaries = new Vector<JgclParametricCurve3D>();
        Enumeration e = this.innerBoundaries.elements();
        while (e.hasMoreElements()) {
            JgclCompositeCurve3D inner = (JgclCompositeCurve3D)e.nextElement();
            tInnerBoundaries.addElement(inner.transformBy(reverseTransform, transformationOperator, transformedGeometries));
        }
        return new JgclCurveBoundedSurface3D(tBasisSurface, tOuterBoundary, tInnerBoundaries);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tbasisSurface");
        this.basisSurface.output(writer, indent + 1);
        writer.println(String.valueOf(indent_tab) + "\touterBoundary");
        this.outerBoundary.output(writer, indent + 1);
        if (this.innerBoundaries.size() > 0) {
            writer.println(String.valueOf(indent_tab) + "\tinnerBoundaries");
            Enumeration e = this.innerBoundaries.elements();
            while (e.hasMoreElements()) {
                JgclCompositeCurve3D inner = (JgclCompositeCurve3D)e.nextElement();
                inner.output(writer, indent + 1);
            }
        }
        writer.println(String.valueOf(indent_tab) + "End");
    }

    private boolean intersectionIsInternal(JgclIntersectionPoint3D ints, boolean doExchange) {
        JgclPointOnSurface3D pointOnSurface = !doExchange ? (JgclPointOnSurface3D)ints.pointOnGeometry1() : (JgclPointOnSurface3D)ints.pointOnGeometry2();
        return this.containsWithWrapping(pointOnSurface.uParameter(), pointOnSurface.vParameter());
    }

    private JgclIntersectionPoint3D changeTargetOfIntersection(JgclIntersectionPoint3D ints, boolean doExchange) {
        JgclPointOnGeometry3D pog1 = ints.pointOnGeometry1();
        JgclPointOnGeometry3D pog2 = ints.pointOnGeometry2();
        if (!doExchange) {
            JgclPointOnSurface3D pos = (JgclPointOnSurface3D)pog1;
            double uParam = this.basisSurface.uParameterDomain().wrap(pos.uParameter());
            double vParam = this.basisSurface.vParameterDomain().wrap(pos.vParameter());
            pog1 = new JgclPointOnSurface3D(this, uParam, vParam, false);
        } else {
            JgclPointOnSurface3D pos = (JgclPointOnSurface3D)pog2;
            double uParam = this.basisSurface.uParameterDomain().wrap(pos.uParameter());
            double vParam = this.basisSurface.vParameterDomain().wrap(pos.vParameter());
            pog2 = new JgclPointOnSurface3D(this, uParam, vParam, false);
        }
        return new JgclIntersectionPoint3D(ints.coordinates(), pog1, pog2, false);
    }

    private JgclIntersectionCurve3D changeTargetOfIntersection(JgclIntersectionCurve3D ints, boolean doExchange) {
        JgclParametricSurface3D basisSurface2;
        JgclParametricSurface3D basisSurface1;
        if (!doExchange) {
            basisSurface1 = this;
            basisSurface2 = ints.basisSurface2();
        } else {
            basisSurface1 = ints.basisSurface1();
            basisSurface2 = this;
        }
        return new JgclIntersectionCurve3D(ints.curve3d(), basisSurface1, ints.curve2d1(), basisSurface2, ints.curve2d2(), ints.masterRepresentation());
    }

    JgclIntersectionPoint3D[] selectInternalIntersections(JgclIntersectionPoint3D[] intersections, boolean doExchange) {
        Vector<JgclIntersectionPoint3D> innerPoints = new Vector<JgclIntersectionPoint3D>();
        int i = 0;
        while (i < intersections.length) {
            if (this.intersectionIsInternal(intersections[i], doExchange)) {
                JgclIntersectionPoint3D ints = this.changeTargetOfIntersection(intersections[i], doExchange);
                innerPoints.addElement(ints);
            }
            ++i;
        }
        Object[] results = new JgclIntersectionPoint3D[innerPoints.size()];
        innerPoints.copyInto(results);
        return results;
    }

    private JgclIntersectionCurve3D makeIntersectionClose(JgclIntersectionCurve3D theIntersection) {
        JgclParametricCurve2D curve2d2;
        JgclParametricCurve2D curve2d1;
        boolean changed = false;
        JgclParametricCurve3D curve3d = theIntersection.curve3d();
        if (curve3d.isClosed() && !curve3d.isPeriodic() && curve3d.type() == 20) {
            JgclPolyline3D polyline3d = (JgclPolyline3D)curve3d;
            int nPoints = polyline3d.nPoints() - 1;
            JgclPoint3D[] points = new JgclPoint3D[nPoints];
            int i = 0;
            while (i < nPoints) {
                points[i] = polyline3d.pointAt(i);
                ++i;
            }
            curve3d = new JgclPolyline3D(points, true);
            changed = true;
        }
        if ((curve2d1 = theIntersection.curve2d1()).isClosed() && !curve2d1.isPeriodic() && curve2d1 instanceof JgclPolyline2D) {
            JgclPolyline2D polyline2d = (JgclPolyline2D)curve2d1;
            int nPoints = polyline2d.nPoints() - 1;
            JgclPoint2D[] points = new JgclPoint2D[nPoints];
            int i = 0;
            while (i < nPoints) {
                points[i] = polyline2d.pointAt(i);
                ++i;
            }
            curve2d1 = new JgclPolyline2D(points, true);
            changed = true;
        }
        if ((curve2d2 = theIntersection.curve2d2()).isClosed() && !curve2d2.isPeriodic() && curve2d2 instanceof JgclPolyline2D) {
            JgclPolyline2D polyline2d = (JgclPolyline2D)curve2d2;
            int nPoints = polyline2d.nPoints() - 1;
            JgclPoint2D[] points = new JgclPoint2D[nPoints];
            int i = 0;
            while (i < nPoints) {
                points[i] = polyline2d.pointAt(i);
                ++i;
            }
            curve2d2 = new JgclPolyline2D(points, true);
            changed = true;
        }
        if (!changed) {
            return theIntersection;
        }
        return new JgclIntersectionCurve3D(curve3d, theIntersection.basisSurface1(), curve2d1, theIntersection.basisSurface2(), curve2d2, theIntersection.masterRepresentation());
    }

    private double getParameterWithCurve3D(JgclParametricCurve3D curve3d, JgclPoint3D point3d) {
        double nearDist;
        JgclPointOnCurve3D nearProj3d;
        JgclPoint3D nearestProj3d = null;
        double nearestDist = Double.NaN;
        JgclPointOnCurve3D lowerPoint = null;
        JgclPoint3D upperPoint = null;
        if (curve3d.isFinite() && curve3d.isOpen()) {
            lowerPoint = new JgclPointOnCurve3D(curve3d, curve3d.parameterDomain().section().lower());
            upperPoint = new JgclPointOnCurve3D(curve3d, curve3d.parameterDomain().section().upper());
        }
        JgclPolyline3D polyline3d = null;
        if (curve3d.hasPolyline()) {
            JgclBoundedCurve3D bounded3d = (JgclBoundedCurve3D)curve3d;
            polyline3d = bounded3d.toPolyline(this.getToleranceForDistanceAsObject());
        }
        if ((nearProj3d = curve3d.nearestProjectFrom(point3d)) != null) {
            nearDist = nearProj3d.distance(point3d);
            if (nearestProj3d == null || nearDist < nearestDist) {
                nearestProj3d = nearProj3d;
                nearestDist = nearDist;
            }
        }
        if (lowerPoint != null) {
            nearDist = lowerPoint.distance(point3d);
            if (nearestProj3d == null || nearDist < nearestDist) {
                nearestProj3d = lowerPoint;
                nearestDist = nearDist;
            }
        }
        if (upperPoint != null) {
            nearDist = upperPoint.distance(point3d);
            if (nearestProj3d == null || nearDist < nearestDist) {
                nearestProj3d = upperPoint;
                nearestDist = nearDist;
            }
        }
        if (polyline3d != null) {
            int i = 0;
            while (i < polyline3d.nPoints()) {
                nearDist = polyline3d.pointAt(i).distance(point3d);
                if (nearestProj3d == null || nearDist < nearestDist) {
                    nearestProj3d = (JgclPointOnCurve3D)polyline3d.pointAt(i);
                    nearestDist = nearDist;
                }
                ++i;
            }
        }
        if (nearestProj3d == null) {
            throw new JgclFatal("No projection.");
        }
        return nearestProj3d.parameter();
    }

    private double getParameterWithCurveOnSurface3D(JgclParametricSurface3D surface3d, JgclParametricCurve2D curve2d, JgclPoint3D point3d) {
        JgclPointOnSurface3D nearestProj3d = surface3d.nearestProjectFrom(point3d);
        if (nearestProj3d == null) {
            throw new JgclFatal("No projection in 3d.");
        }
        double[] param3d = nearestProj3d.parameters();
        JgclPointOnCurve2D lowerPoint = null;
        JgclPointOnCurve2D upperPoint = null;
        if (curve2d.isFinite() && curve2d.isOpen()) {
            lowerPoint = new JgclPointOnCurve2D(curve2d, curve2d.parameterDomain().section().lower());
            upperPoint = new JgclPointOnCurve2D(curve2d, curve2d.parameterDomain().section().upper());
        }
        JgclPolyline2D polyline2d = null;
        if (curve2d.hasPolyline()) {
            JgclBoundedCurve2D bounded2d = (JgclBoundedCurve2D)curve2d;
            polyline2d = bounded2d.toPolyline(this.getToleranceForDistanceAsObject());
        }
        int nU = 1;
        double dU = Double.NaN;
        int nV = 1;
        double dV = Double.NaN;
        if (surface3d.type() != 33) {
            if (surface3d.isUPeriodic()) {
                nU = 3;
                dU = surface3d.uParameterDomain().section().increase();
            }
            if (surface3d.isVPeriodic()) {
                nV = 3;
                dV = surface3d.vParameterDomain().section().increase();
            }
        }
        JgclPointOnCurve2D nearestProj2d = null;
        double nearestDist = Double.NaN;
        int iU = 0;
        while (iU < nU) {
            double pU;
            switch (iU) {
                case 1: {
                    pU = param3d[0] - dU;
                    break;
                }
                case 2: {
                    pU = param3d[0] + dU;
                    break;
                }
                default: {
                    pU = param3d[0];
                }
            }
            int iV = 0;
            while (iV < nV) {
                double nearDist;
                double pV;
                switch (iV) {
                    case 1: {
                        pV = param3d[1] - dV;
                        break;
                    }
                    case 2: {
                        pV = param3d[1] + dV;
                        break;
                    }
                    default: {
                        pV = param3d[1];
                    }
                }
                JgclCartesianPoint2D point2d = JgclPoint2D.of(pU, pV);
                JgclPointOnCurve2D nearProj2d = curve2d.nearestProjectFrom(point2d);
                if (nearProj2d != null) {
                    nearDist = nearProj2d.distance(point2d);
                    if (nearestProj2d == null || nearDist < nearestDist) {
                        nearestProj2d = nearProj2d;
                        nearestDist = nearDist;
                    }
                }
                if (lowerPoint != null) {
                    nearDist = lowerPoint.distance(point2d);
                    if (nearestProj2d == null || nearDist < nearestDist) {
                        nearestProj2d = lowerPoint;
                        nearestDist = nearDist;
                    }
                }
                if (upperPoint != null) {
                    nearDist = upperPoint.distance(point2d);
                    if (nearestProj2d == null || nearDist < nearestDist) {
                        nearestProj2d = upperPoint;
                        nearestDist = nearDist;
                    }
                }
                if (polyline2d != null) {
                    int i = 0;
                    while (i < polyline2d.nPoints()) {
                        nearDist = polyline2d.pointAt(i).distance(point2d);
                        if (nearestProj2d == null || nearDist < nearestDist) {
                            nearestProj2d = (JgclPointOnCurve2D)polyline2d.pointAt(i);
                            nearestDist = nearDist;
                        }
                        ++i;
                    }
                }
                ++iV;
            }
            ++iU;
        }
        if (nearestProj2d == null) {
            throw new JgclFatal("No projection in 2d.");
        }
        return nearestProj2d.parameter();
    }

    private JgclIntersectionPoint2D[] getIntersectionsWithBoundary(JgclCompositeCurve2D boundaryCurve, JgclParametricCurve2D intsT) {
        JgclIntersectionPoint2D[] intsWithBoundary;
        int nU = 1;
        double dU = Double.NaN;
        int nV = 1;
        double dV = Double.NaN;
        if (this.basisSurface.type() != 33) {
            if (this.basisSurface.isUPeriodic()) {
                nU = 3;
                dU = this.basisSurface.uParameterDomain().section().increase();
            }
            if (this.basisSurface.isVPeriodic()) {
                nV = 3;
                dV = this.basisSurface.vParameterDomain().section().increase();
            }
        }
        Vector<JgclIntersectionPoint2D[]> intsWithBoundaryList = new Vector<JgclIntersectionPoint2D[]>();
        int nInts = 0;
        int iU = 0;
        while (iU < nU) {
            double pU;
            switch (iU) {
                case 1: {
                    pU = -dU;
                    break;
                }
                case 2: {
                    pU = dU;
                    break;
                }
                default: {
                    pU = 0.0;
                }
            }
            int iV = 0;
            while (iV < nV) {
                JgclCompositeCurve2D tBoundaryCurve;
                double pV;
                switch (iV) {
                    case 1: {
                        pV = -dV;
                        break;
                    }
                    case 2: {
                        pV = dV;
                        break;
                    }
                    default: {
                        pV = 0.0;
                    }
                }
                if (iU == 0 && iV == 0) {
                    tBoundaryCurve = boundaryCurve;
                } else {
                    JgclCartesianTransformationOperator2D transformer = new JgclCartesianTransformationOperator2D(null, null, JgclPoint2D.of(pU, pV), 1.0);
                    tBoundaryCurve = (JgclCompositeCurve2D)boundaryCurve.transformBy(transformer, null);
                }
                intsWithBoundary = tBoundaryCurve.intersect(intsT);
                if (intsWithBoundary.length > 0) {
                    intsWithBoundaryList.addElement(intsWithBoundary);
                    nInts += intsWithBoundary.length;
                }
                ++iV;
            }
            ++iU;
        }
        JgclIntersectionPoint2D[] result = new JgclIntersectionPoint2D[nInts];
        int iResult = 0;
        Enumeration e = intsWithBoundaryList.elements();
        while (e.hasMoreElements()) {
            intsWithBoundary = (JgclIntersectionPoint2D[])e.nextElement();
            int i = 0;
            while (i < intsWithBoundary.length) {
                result[iResult++] = intsWithBoundary[i];
                ++i;
            }
        }
        return result;
    }

    private double wrapParameterIntoOpenSection(double param, JgclParameterSection section) {
        while (param < section.lower()) {
            param += section.absIncrease();
        }
        while (param > section.upper()) {
            param -= section.absIncrease();
        }
        return param;
    }

    private JgclParametricCurve2D connectHeadToTail(JgclParametricCurve2D curve, double sp, double ep) {
        JgclParameterSection section = curve.parameterDomain().section();
        double sp1 = this.wrapParameterIntoOpenSection(sp, section);
        double ep1 = section.upper();
        double sp2 = section.lower();
        double ep2 = this.wrapParameterIntoOpenSection(ep, section);
        JgclPoint2D lowerCoord = curve.coordinates(section.lower());
        JgclPoint2D upperCoord = curve.coordinates(section.upper());
        JgclVector2D period = upperCoord.subtract(lowerCoord);
        JgclCartesianTransformationOperator2D transformer = new JgclCartesianTransformationOperator2D(null, null, period.toPoint2D(), 1.0);
        JgclParametricCurve2D curve1 = curve;
        JgclParametricCurve2D curve2 = curve.transformBy(transformer, null);
        JgclTrimmedCurve2D tCurve1 = new JgclTrimmedCurve2D(curve1, sp1, ep1, true);
        JgclTrimmedCurve2D tCurve2 = new JgclTrimmedCurve2D(curve2, sp2, ep2, true);
        JgclCompositeCurveSegment2D[] segments = new JgclCompositeCurveSegment2D[]{new JgclCompositeCurveSegment2D(1, true, tCurve1), new JgclCompositeCurveSegment2D(0, true, tCurve2)};
        return new JgclCompositeCurve2D(segments, false);
    }

    private JgclIntersectionCurve3D trimIntersection2(boolean doExchange, JgclIntersectionCurve3D theIntersection, boolean isOpenT, boolean isOpenM, boolean crossBoundary, double spT, double ipT) {
        JgclParameterSection section;
        boolean isOpen;
        double epT = spT + ipT;
        JgclParametricCurve3D curve3d = theIntersection.curve3d();
        double sp = spT;
        double ep = epT;
        curve3d = new JgclTrimmedCurve3D(curve3d, sp, ep, true);
        JgclParametricCurve2D curve2d1 = theIntersection.curve2d1();
        sp = spT;
        ep = epT;
        boolean bl = isOpen = !doExchange ? isOpenT : isOpenM;
        if (crossBoundary && isOpen) {
            section = curve2d1.parameterDomain().section();
            sp = this.wrapParameterIntoOpenSection(sp, section);
            ep = this.wrapParameterIntoOpenSection(ep, section);
        }
        curve2d1 = sp < ep || !isOpen ? new JgclTrimmedCurve2D(curve2d1, sp, ep, true) : this.connectHeadToTail(curve2d1, sp, ep);
        JgclParametricCurve2D curve2d2 = theIntersection.curve2d2();
        sp = spT;
        ep = epT;
        boolean bl2 = isOpen = !doExchange ? isOpenM : isOpenT;
        if (crossBoundary && isOpen) {
            section = curve2d2.parameterDomain().section();
            sp = this.wrapParameterIntoOpenSection(sp, section);
            ep = this.wrapParameterIntoOpenSection(ep, section);
        }
        curve2d2 = sp < ep || !isOpen ? new JgclTrimmedCurve2D(curve2d2, sp, ep, true) : this.connectHeadToTail(curve2d2, sp, ep);
        return new JgclIntersectionCurve3D(curve3d, theIntersection.basisSurface1(), curve2d1, theIntersection.basisSurface2(), curve2d2, theIntersection.masterRepresentation());
    }

    private JgclIntersectionCurve3D trimIntersection(boolean doExchange, JgclIntersectionCurve3D theIntersection, JgclParametricCurve2D intsT, JgclParameterSection sectionOfIntsT, boolean isOpenT, boolean isOpenM, boolean crossBoundary, double spT, double ipT) {
        boolean isOpen;
        if (theIntersection.curve3d().isComposedOfOnlyPolylines() && theIntersection.curve2d1().isComposedOfOnlyPolylines() && theIntersection.curve2d2().isComposedOfOnlyPolylines()) {
            JgclParameterSection section3d = theIntersection.curve3d().parameterDomain().section();
            JgclParameterSection section2d1 = theIntersection.curve2d1().parameterDomain().section();
            JgclParameterSection section2d2 = theIntersection.curve2d2().parameterDomain().section();
            if (section3d.identical(section2d1) && section3d.identical(section2d2)) {
                return this.trimIntersection2(doExchange, theIntersection, isOpenT, isOpenM, crossBoundary, spT, ipT);
            }
        }
        double epT = spT + ipT;
        if (crossBoundary && isOpenT) {
            spT = this.wrapParameterIntoOpenSection(spT, sectionOfIntsT);
            epT = this.wrapParameterIntoOpenSection(epT, sectionOfIntsT);
        }
        JgclPoint2D spnt2d = intsT.coordinates(spT);
        JgclPoint2D epnt2d = intsT.coordinates(epT);
        JgclPoint3D spnt3d = this.basisSurface.coordinates(spnt2d.x(), spnt2d.y());
        JgclPoint3D epnt3d = this.basisSurface.coordinates(epnt2d.x(), epnt2d.y());
        JgclParametricCurve3D curve3d = theIntersection.curve3d();
        double sp = this.getParameterWithCurve3D(curve3d, spnt3d);
        double ep = this.getParameterWithCurve3D(curve3d, epnt3d);
        curve3d = new JgclTrimmedCurve3D(curve3d, sp, ep, true);
        JgclParametricCurve2D curve2d1 = theIntersection.curve2d1();
        if (!doExchange) {
            sp = spT;
            ep = epT;
            isOpen = isOpenT;
        } else {
            sp = this.getParameterWithCurveOnSurface3D(theIntersection.basisSurface1(), curve2d1, spnt3d);
            ep = this.getParameterWithCurveOnSurface3D(theIntersection.basisSurface1(), curve2d1, epnt3d);
            isOpen = isOpenM;
        }
        curve2d1 = sp < ep || !isOpen ? new JgclTrimmedCurve2D(curve2d1, sp, ep, true) : this.connectHeadToTail(curve2d1, sp, ep);
        JgclParametricCurve2D curve2d2 = theIntersection.curve2d2();
        if (!doExchange) {
            sp = this.getParameterWithCurveOnSurface3D(theIntersection.basisSurface2(), curve2d2, spnt3d);
            ep = this.getParameterWithCurveOnSurface3D(theIntersection.basisSurface2(), curve2d2, epnt3d);
            isOpen = isOpenM;
        } else {
            sp = spT;
            ep = epT;
            isOpen = isOpenT;
        }
        curve2d2 = sp < ep || !isOpen ? new JgclTrimmedCurve2D(curve2d2, sp, ep, true) : this.connectHeadToTail(curve2d2, sp, ep);
        return new JgclIntersectionCurve3D(curve3d, theIntersection.basisSurface1(), curve2d1, theIntersection.basisSurface2(), curve2d2, theIntersection.masterRepresentation());
    }

    private JgclParametricCurve2D moveIntoPrimarySections(JgclParametricCurve2D curve) {
        double lower = curve.parameterDomain().section().lower();
        double upper = curve.parameterDomain().section().upper();
        double middle = (lower + upper) / 2.0;
        JgclPoint2D lowerPoint = curve.coordinates(lower);
        JgclPoint2D upperPoint = curve.coordinates(upper);
        JgclPoint2D middlePoint = curve.coordinates(middle);
        int nU = 1;
        double dU = Double.NaN;
        int nV = 1;
        double dV = Double.NaN;
        if (this.basisSurface.type() != 33) {
            if (this.basisSurface.isUPeriodic()) {
                nU = 3;
                dU = this.basisSurface.uParameterDomain().section().increase();
            }
            if (this.basisSurface.isVPeriodic()) {
                nV = 3;
                dV = this.basisSurface.vParameterDomain().section().increase();
            }
        }
        int iU = 0;
        while (iU < nU) {
            double pU;
            switch (iU) {
                case 1: {
                    pU = -dU;
                    break;
                }
                case 2: {
                    pU = dU;
                    break;
                }
                default: {
                    pU = 0.0;
                }
            }
            int iV = 0;
            while (iV < nV) {
                JgclPoint2D tMiddlePoint;
                JgclPoint2D tUpperPoint;
                JgclPoint2D tLowerPoint;
                JgclCartesianTransformationOperator2D transformer;
                double pV;
                switch (iV) {
                    case 1: {
                        pV = -dV;
                        break;
                    }
                    case 2: {
                        pV = dV;
                        break;
                    }
                    default: {
                        pV = 0.0;
                    }
                }
                if (iU == 0 && iV == 0) {
                    transformer = null;
                    tLowerPoint = lowerPoint;
                    tUpperPoint = upperPoint;
                    tMiddlePoint = middlePoint;
                } else {
                    transformer = new JgclCartesianTransformationOperator2D(null, null, JgclPoint2D.of(pU, pV), 1.0);
                    tLowerPoint = lowerPoint.transformBy(transformer, null);
                    tUpperPoint = upperPoint.transformBy(transformer, null);
                    tMiddlePoint = middlePoint.transformBy(transformer, null);
                }
                if (this.contains(tLowerPoint) && this.contains(tUpperPoint) && this.contains(tMiddlePoint)) {
                    if (transformer == null) {
                        return curve;
                    }
                    return curve.transformBy(transformer, null);
                }
                ++iV;
            }
            ++iU;
        }
        return null;
    }

    private JgclIntersectionCurve3D changeParameterSpaceOfIntersection(JgclIntersectionCurve3D ints, boolean doExchange) {
        JgclParametricCurve2D curve2d1 = ints.curve2d1();
        JgclParametricCurve2D curve2d2 = ints.curve2d2();
        if (!doExchange) {
            curve2d1 = this.moveIntoPrimarySections(curve2d1);
        } else {
            curve2d2 = this.moveIntoPrimarySections(curve2d2);
        }
        return new JgclIntersectionCurve3D(ints.curve3d(), ints.basisSurface1(), curve2d1, ints.basisSurface2(), curve2d2, ints.masterRepresentation());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    JgclSurfaceSurfaceInterference3D[] trimIntersectionsWithBoundaries(JgclParametricSurface3D mate, JgclSurfaceSurfaceInterference3D[] intersections, boolean doExchange) {
        i = 0;
        while (i < intersections.length) {
            if (intersections[i].isIntersectionPoint()) {
                ints /* !! */  = intersections[i].toIntersectionPoint();
                intersections[i] = this.changeTargetOfIntersection(ints /* !! */ , doExchange);
            } else {
                ints /* !! */  = intersections[i].toIntersectionCurve();
                intersections[i] = this.changeTargetOfIntersection((JgclIntersectionCurve3D)ints /* !! */ , doExchange);
            }
            ++i;
        }
        results = new Vector<JgclGeometry>();
        iwbiBothEnds = new IntersectionWithBoundaryInfo[2];
        comparator = new 2(iwbiBothEnds);
        i = 0;
        while (i < intersections.length) {
            block34: {
                block35: {
                    block33: {
                        if (!intersections[i].isIntersectionPoint()) break block33;
                        ints = intersections[i].toIntersectionPoint();
                        if (this.intersectionIsInternal(ints, doExchange)) {
                            results.addElement(ints);
                        }
                        break block34;
                    }
                    theIntersection = intersections[i].toIntersectionCurve();
                    theIntersection = this.makeIntersectionClose(theIntersection);
                    if (!doExchange) {
                        intsT = theIntersection.curve2d1();
                        intsM = theIntersection.curve2d2();
                    } else {
                        intsT = theIntersection.curve2d2();
                        intsM = theIntersection.curve2d1();
                    }
                    isOpen3 = theIntersection.curve3d().isOpen();
                    isOpenT = intsT.isOpen();
                    isOpenM = intsM.isOpen();
                    domainOfIntsT = intsT.parameterDomain();
                    sectionOfIntsT = domainOfIntsT.section();
                    listOfIntersectionsWithBoundaries = new Vector<IntersectionWithBoundaryInfo>();
                    j = -1;
                    while (j < this.innerBoundaries2D.size()) {
                        aBoundary = j == -1 ? this.outerBoundary2D : (JgclCompositeCurve2D)this.innerBoundaries2D.elementAt(j);
                        intsWithBoundary = this.getIntersectionsWithBoundary(aBoundary, intsT);
                        k = 0;
                        while (k < intsWithBoundary.length) {
                            iwbi = new IntersectionWithBoundaryInfo(j, intsWithBoundary[k].pointOnCurve1().parameter(), intsWithBoundary[k].pointOnCurve2().parameter());
                            listOfIntersectionsWithBoundaries.addElement(iwbi);
                            ++k;
                        }
                        ++j;
                    }
                    iwbiBothEnds[0] = null;
                    iwbiBothEnds[1] = null;
                    addEndPoints = false;
                    if (isOpen3) {
                        if (intsT.isFinite()) {
                            iwbiBothEnds[0] = new IntersectionWithBoundaryInfo(-100, 0.0, sectionOfIntsT.start());
                            iwbiBothEnds[1] = new IntersectionWithBoundaryInfo(-100, 0.0, sectionOfIntsT.end());
                            listOfIntersectionsWithBoundaries.addElement(iwbiBothEnds[0]);
                            listOfIntersectionsWithBoundaries.addElement(iwbiBothEnds[1]);
                            addEndPoints = true;
                        }
                    } else if (listOfIntersectionsWithBoundaries.size() == 1) {
                        iwbi = (IntersectionWithBoundaryInfo)listOfIntersectionsWithBoundaries.elementAt(0);
                        iwbi2 = new IntersectionWithBoundaryInfo(iwbi.boundaryIndex, iwbi.boundaryParameter, iwbi.curveParameter);
                        listOfIntersectionsWithBoundaries.addElement(iwbi2);
                    }
                    if (listOfIntersectionsWithBoundaries.size() != 0) break block35;
                    v0 = aParameter = intsT.isFinite() == true ? sectionOfIntsT.start() : 0.0;
                    if (this.containsWithWrapping(intsT.coordinates(aParameter))) {
                        results.addElement(this.changeParameterSpaceOfIntersection(theIntersection, doExchange));
                    }
                    break block34;
                }
                JgclListSorter.doSorting(listOfIntersectionsWithBoundaries, comparator);
                nIntervals = isOpen3 == true ? listOfIntersectionsWithBoundaries.size() - 1 : listOfIntersectionsWithBoundaries.size();
                listOfTrimmingIntervals = new Vector<TrimmingInterval>();
                trimmingInterval = null;
                sIdx = 0;
                sIwb = (IntersectionWithBoundaryInfo)listOfIntersectionsWithBoundaries.elementAt(0);
                j = 1;
                while (j <= nIntervals) {
                    block37: {
                        block36: {
                            sp = sIwb.curveParameter;
                            if (!isOpen3 && j >= nIntervals) break block36;
                            eIdx = j;
                            eIwb = (IntersectionWithBoundaryInfo)listOfIntersectionsWithBoundaries.elementAt(j);
                            crossBoundary = false;
                            ip = eIwb.curveParameter - sIwb.curveParameter;
                            if (sIwb != iwbiBothEnds[0] && eIwb != iwbiBothEnds[1] || !(Math.abs(ip) < this.getToleranceForParameter())) ** GOTO lbl-1000
                            sIdx = eIdx;
                            sIwb = eIwb;
                            break block37;
                        }
                        eIdx = 0;
                        eIwb = (IntersectionWithBoundaryInfo)listOfIntersectionsWithBoundaries.elementAt(0);
                        crossBoundary = true;
                        ip = eIwb.curveParameter - sIwb.curveParameter + sectionOfIntsT.increase();
                        if (Math.abs(ip) < this.getToleranceForParameter()) {
                            sIdx = eIdx;
                            sIwb = eIwb;
                        } else lbl-1000:
                        // 2 sources

                        {
                            mp = sp + ip / 2.0;
                            if (addEndPoints) {
                                if (j == 1) {
                                    mp = sp;
                                } else if (j == nIntervals) {
                                    mp = sp + ip;
                                }
                            }
                            if (crossBoundary && isOpenT) {
                                if (mp < sectionOfIntsT.lower()) {
                                    mp += sectionOfIntsT.absIncrease();
                                }
                                if (mp > sectionOfIntsT.upper()) {
                                    mp -= sectionOfIntsT.absIncrease();
                                }
                            }
                            if (this.containsWithWrapping(intsT.coordinates(mp))) {
                                if (trimmingInterval != null && trimmingInterval.eIdx == sIdx) {
                                    trimmingInterval.eIdx = eIdx;
                                } else {
                                    trimmingInterval = new TrimmingInterval(sIdx, eIdx);
                                    listOfTrimmingIntervals.addElement(trimmingInterval);
                                }
                            }
                            sIdx = eIdx;
                            sIwb = eIwb;
                        }
                    }
                    ++j;
                }
                nIntervals = listOfTrimmingIntervals.size();
                if (nIntervals > 1) {
                    head = (TrimmingInterval)listOfTrimmingIntervals.firstElement();
                    tail = (TrimmingInterval)listOfTrimmingIntervals.lastElement();
                    if (head.sIdx == tail.eIdx) {
                        head.sIdx = tail.sIdx;
                        --nIntervals;
                    }
                }
                j = 0;
                while (j < nIntervals) {
                    trimmingInterval = (TrimmingInterval)listOfTrimmingIntervals.elementAt(j);
                    sIwb = (IntersectionWithBoundaryInfo)listOfIntersectionsWithBoundaries.elementAt(trimmingInterval.sIdx);
                    eIwb = (IntersectionWithBoundaryInfo)listOfIntersectionsWithBoundaries.elementAt(trimmingInterval.eIdx);
                    sp = sIwb.curveParameter;
                    if (trimmingInterval.sIdx < trimmingInterval.eIdx) {
                        crossBoundary = false;
                        ip = eIwb.curveParameter - sIwb.curveParameter;
                    } else {
                        crossBoundary = true;
                        ip = eIwb.curveParameter - sIwb.curveParameter + sectionOfIntsT.increase();
                    }
                    if (!(ip < this.getToleranceForParameter())) {
                        theTrimmedIntersection = this.trimIntersection(doExchange, theIntersection, intsT, sectionOfIntsT, isOpenT, isOpenM, crossBoundary, sp, ip);
                        results.addElement(this.changeParameterSpaceOfIntersection(theTrimmedIntersection, doExchange));
                    }
                    ++j;
                }
            }
            ++i;
        }
        intersections = new JgclSurfaceSurfaceInterference3D[results.size()];
        results.copyInto(intersections);
        return intersections;
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclPlane3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
        return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclSphericalSurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
        return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclCylindricalSurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
        return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclConicalSurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
        return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclPureBezierSurface3D mate, boolean doExchange) {
        JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
        return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclBsplineSurface3D mate, boolean doExchange) {
        JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
        return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    public Vector toNonStructuredPoints(JgclParameterSection uParameterSection, JgclParameterSection vParameterSection, double tolerance, double[] scalingFactor) {
        throw new JgclNotSupported();
    }

    public boolean contains(double uParam, double vParam) {
        return this.contains(JgclPoint2D.of(uParam, vParam));
    }

    public boolean contains(JgclPoint2D point2D) {
        try {
            if (!point2D.isIn(this.outerBoundary2D)) {
                return false;
            }
            Enumeration e = this.innerBoundaries2D.elements();
            while (e.hasMoreElements()) {
                if (!point2D.isInsideOf((JgclParametricCurve2D)e.nextElement())) continue;
                return false;
            }
        }
        catch (JgclOpenCurve jgclOpenCurve) {}
        return true;
    }

    private boolean containsWithWrapping(double uParam, double vParam) {
        return this.contains(this.basisSurface.uParameterDomain().wrap(uParam), this.basisSurface.vParameterDomain().wrap(vParam));
    }

    private boolean containsWithWrapping(JgclPoint2D point2D) {
        return this.contains(this.basisSurface.uParameterDomain().wrap(point2D.x()), this.basisSurface.vParameterDomain().wrap(point2D.y()));
    }

    private JgclBoundedLine2D makeBoundedLine(JgclSetOfTriangles3D.Vertex v1, JgclSetOfTriangles3D.Vertex v2) {
        SurfacePointWithBoundaryInfo c1 = (SurfacePointWithBoundaryInfo)v1.getCoordinates();
        SurfacePointWithBoundaryInfo c2 = (SurfacePointWithBoundaryInfo)v2.getCoordinates();
        return new JgclBoundedLine2D((JgclPoint2D)JgclPoint2D.of(c1.parameters()), JgclPoint2D.of(c2.parameters()));
    }

    private JgclSetOfTriangles3D.Edge findWrongEdge(JgclSetOfTriangles3D.Vertex v1, JgclSetOfTriangles3D.Vertex v2, JgclSetOfTriangles3D.Face[] v1Face) throws SomeThingWrong {
        JgclSetOfTriangles3D.Vertex[] mates;
        int j1;
        JgclSetOfTriangles3D.Edge[] edges1;
        Object wrongEdge = null;
        JgclSetOfTriangles3D.Face[] faces1 = v1.getFacesInCCW();
        JgclSetOfTriangles3D.Face[] faces2 = v2.getFacesInCCW();
        int i1 = 0;
        while (i1 < faces1.length) {
            if (faces1[i1] != null) {
                int i2 = 0;
                while (i2 < faces2.length) {
                    if (faces2[i2] != null && faces1[i1].isIdentWith(faces2[i2])) {
                        return null;
                    }
                    ++i2;
                }
            }
            ++i1;
        }
        JgclBoundedLine2D Abln = this.makeBoundedLine(v1, v2);
        int i12 = 0;
        while (i12 < faces1.length) {
            if (faces1[i12] != null) {
                edges1 = faces1[i12].getEdgesInCCW();
                int i2 = 0;
                while (i2 < faces2.length) {
                    if (faces2[i2] != null) {
                        JgclSetOfTriangles3D.Edge[] edges2 = faces2[i2].getEdgesInCCW();
                        j1 = 0;
                        while (j1 < 3) {
                            int j2 = 0;
                            while (j2 < 3) {
                                if (!(!edges1[j1].isIdentWith(edges2[j2]) || v1.isIdentWith((mates = edges1[j1].getVerticesOfStartEnd())[0]) || v1.isIdentWith(mates[1]) || v2.isIdentWith(mates[0]) || v2.isIdentWith(mates[1]))) {
                                    try {
                                        if (Abln.intersect1(this.makeBoundedLine(mates[0], mates[1])) != null) {
                                            if (v1Face != null) {
                                                v1Face[0] = faces1[i12];
                                            }
                                            return edges1[j1];
                                        }
                                    }
                                    catch (JgclIndefiniteSolution jgclIndefiniteSolution) {}
                                }
                                ++j2;
                            }
                            ++j1;
                        }
                    }
                    ++i2;
                }
            }
            ++i12;
        }
        int i13 = 0;
        while (i13 < faces1.length) {
            if (faces1[i13] != null) {
                edges1 = faces1[i13].getEdgesInCCW();
                j1 = 0;
                while (j1 < 3) {
                    mates = edges1[j1].getVerticesOfStartEnd();
                    if (!v1.isIdentWith(mates[0]) && !v1.isIdentWith(mates[1])) {
                        try {
                            if (Abln.intersect1(this.makeBoundedLine(mates[0], mates[1])) != null) {
                                if (v1Face != null) {
                                    v1Face[0] = faces1[i13];
                                }
                                return edges1[j1];
                            }
                        }
                        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {}
                    }
                    ++j1;
                }
            }
            ++i13;
        }
        throw new SomeThingWrong();
    }

    private JgclSetOfTriangles3D.Edge findWrongEdge2(JgclSetOfTriangles3D.Vertex v1, JgclSetOfTriangles3D.Vertex v2, JgclSetOfTriangles3D.Edge wrongEdge, JgclSetOfTriangles3D.Face[] nearFace) throws SomeThingWrong {
        JgclSetOfTriangles3D.Face farFace;
        JgclSetOfTriangles3D.Face[] wrongEdgeFaces = wrongEdge.getFacesOfLeftRight();
        JgclSetOfTriangles3D.Face face = farFace = nearFace[0].isIdentWith(wrongEdgeFaces[0]) ? wrongEdgeFaces[1] : wrongEdgeFaces[0];
        if (farFace == null) {
            throw new SomeThingWrong();
        }
        JgclBoundedLine2D Abln = this.makeBoundedLine(v1, v2);
        JgclSetOfTriangles3D.Edge[] farFaceEdges = farFace.getEdgesInCCW();
        int i = 0;
        while (i < 3) {
            if (!wrongEdge.isIdentWith(farFaceEdges[i])) {
                JgclSetOfTriangles3D.Vertex[] mates = farFaceEdges[i].getVerticesOfStartEnd();
                if (v2.isIdentWith(mates[0]) || v2.isIdentWith(mates[1])) {
                    throw new SomeThingWrong();
                }
                try {
                    if (Abln.intersect1(this.makeBoundedLine(mates[0], mates[1])) != null) {
                        nearFace[0] = farFace;
                        return farFaceEdges[i];
                    }
                }
                catch (JgclIndefiniteSolution jgclIndefiniteSolution) {}
            }
            ++i;
        }
        throw new SomeThingWrong();
    }

    private boolean edgeCanBeFlipped(JgclSetOfTriangles3D.Edge edge) {
        SurfacePointWithBoundaryInfo c;
        JgclSetOfTriangles3D.Vertex[] vrtcs = edge.getVerticesOfStartEnd();
        JgclSetOfTriangles3D.Face[] faces = edge.getFacesOfLeftRight();
        JgclPoint2D[] crds = new JgclPoint2D[3];
        int i = 0;
        while (i < 2) {
            if (faces[i] == null) {
                return false;
            }
            JgclSetOfTriangles3D.Vertex[] faceVrtx = faces[i].getVerticesInCCW();
            int j = 0;
            while (j < 3) {
                if (!faceVrtx[j].isIdentWith(vrtcs[0]) && !faceVrtx[j].isIdentWith(vrtcs[1])) {
                    c = (SurfacePointWithBoundaryInfo)faceVrtx[j].getCoordinates();
                    crds[i] = JgclPoint2D.of(c.parameters());
                    break;
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < 2) {
            c = (SurfacePointWithBoundaryInfo)vrtcs[i2].getCoordinates();
            crds[2] = JgclPoint2D.of(c.parameters());
            if (JgclPoint2D.collinear(crds, 0, 2) != null) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private boolean wasteOfTime(JgclSetOfTriangles3D.Edge wrongEdge, Vector vertexPairList) {
        JgclSetOfTriangles3D.Vertex[] crntVertexPair = wrongEdge.getVerticesOfStartEnd();
        int nWastes = 0;
        Enumeration e = vertexPairList.elements();
        while (e.hasMoreElements()) {
            JgclSetOfTriangles3D.Vertex[] vertexPair = (JgclSetOfTriangles3D.Vertex[])e.nextElement();
            if ((!vertexPair[0].isIdentWith(crntVertexPair[0]) || !vertexPair[1].isIdentWith(crntVertexPair[1])) && (!vertexPair[0].isIdentWith(crntVertexPair[1]) || !vertexPair[1].isIdentWith(crntVertexPair[0]))) continue;
            ++nWastes;
        }
        if (nWastes >= 20) {
            return true;
        }
        vertexPairList.addElement(crntVertexPair);
        return false;
    }

    private boolean flipDiagonalsIn(JgclSetOfTriangles3D triangles, JgclPolyline2D outerPolyline2D, Vector innerPolylines2D) {
        int i;
        boolean success = true;
        Vector<JgclSetOfTriangles3D.Vertex> wrongConnectedVertexList = new Vector<JgclSetOfTriangles3D.Vertex>();
        Enumeration e = triangles.vertexElements();
        while (e.hasMoreElements()) {
            JgclSetOfTriangles3D.Vertex vrtx = (JgclSetOfTriangles3D.Vertex)e.nextElement();
            SurfacePointWithBoundaryInfo vrtxCoord = (SurfacePointWithBoundaryInfo)vrtx.getCoordinates();
            if (vrtxCoord.boundaryNumber == -2) continue;
            int connectedNumber = 0;
            JgclSetOfTriangles3D.Edge[] edges = vrtx.getEdgesInCCW();
            i = 0;
            while (i < edges.length) {
                JgclSetOfTriangles3D.Vertex[] vrtcs = edges[i].getVerticesOfStartEnd();
                JgclSetOfTriangles3D.Vertex mate = !vrtx.isIdentWith(vrtcs[0]) ? vrtcs[0] : vrtcs[1];
                SurfacePointWithBoundaryInfo mateCoord = (SurfacePointWithBoundaryInfo)mate.getCoordinates();
                if (vrtxCoord.isNeighborOf(mateCoord, outerPolyline2D, innerPolylines2D) && ++connectedNumber == 2) break;
                ++i;
            }
            int i2 = connectedNumber;
            while (i2 < 2) {
                wrongConnectedVertexList.addElement(vrtx);
                ++i2;
            }
        }
        while (!wrongConnectedVertexList.isEmpty()) {
            JgclSetOfTriangles3D.Vertex v1 = (JgclSetOfTriangles3D.Vertex)wrongConnectedVertexList.elementAt(0);
            SurfacePointWithBoundaryInfo c1 = (SurfacePointWithBoundaryInfo)v1.getCoordinates();
            JgclSetOfTriangles3D.Vertex v2 = null;
            i = 1;
            while (i < wrongConnectedVertexList.size()) {
                v2 = (JgclSetOfTriangles3D.Vertex)wrongConnectedVertexList.elementAt(i);
                SurfacePointWithBoundaryInfo c2 = (SurfacePointWithBoundaryInfo)v2.getCoordinates();
                if (c1.isNeighborOf(c2, outerPolyline2D, innerPolylines2D)) {
                    try {
                        if (this.findWrongEdge(v1, v2, null) != null) {
                            break;
                        }
                    }
                    catch (SomeThingWrong someThingWrong) {
                        success = false;
                    }
                }
                ++i;
            }
            if (i < wrongConnectedVertexList.size()) {
                JgclSetOfTriangles3D.Vertex vA = v1;
                JgclSetOfTriangles3D.Vertex vB = v2;
                boolean reverse = false;
                int nFails = 0;
                Vector vertexPairList = new Vector();
                JgclSetOfTriangles3D.Face[] nearFace = new JgclSetOfTriangles3D.Face[1];
                while (true) {
                    JgclSetOfTriangles3D.Edge wrongEdge;
                    block18: {
                        try {
                            wrongEdge = this.findWrongEdge(vA, vB, nearFace);
                        }
                        catch (SomeThingWrong someThingWrong) {
                            wrongEdge = null;
                        }
                        if (wrongEdge == null || this.wasteOfTime(wrongEdge, vertexPairList)) break;
                        if (this.edgeCanBeFlipped(wrongEdge) && wrongEdge.flipDiagonal() != null) {
                            nFails = 0;
                            continue;
                        }
                        do {
                            try {
                                wrongEdge = this.findWrongEdge2(vA, vB, wrongEdge, nearFace);
                            }
                            catch (SomeThingWrong someThingWrong) {
                                wrongEdge = null;
                            }
                            if (wrongEdge == null) break block18;
                        } while (!this.edgeCanBeFlipped(wrongEdge) || wrongEdge.flipDiagonal() == null);
                        nFails = 0;
                    }
                    if (wrongEdge == null && ++nFails == 2) break;
                    if (!reverse) {
                        vA = v2;
                        vB = v1;
                        reverse = true;
                        continue;
                    }
                    vA = v1;
                    vB = v2;
                    reverse = false;
                }
                wrongConnectedVertexList.removeElementAt(i);
            }
            wrongConnectedVertexList.removeElementAt(0);
        }
        return success;
    }

    public JgclSetOfTriangles3D toSetOfTriangles(double tol4S, double tol4B) {
        double vScale;
        double uScale;
        JgclPoint2D point2D;
        JgclParameterSection uPint = new JgclParameterSection(this.enclosingBox2D.min().x(), this.enclosingBox2D.max().x() - this.enclosingBox2D.min().x());
        JgclParameterSection vPint = new JgclParameterSection(this.enclosingBox2D.min().y(), this.enclosingBox2D.max().y() - this.enclosingBox2D.min().y());
        double[] scalingFactor = new double[2];
        Vector<SurfacePointWithBoundaryInfo> pointsOnBasisSurface = this.basisSurface.toNonStructuredPoints(uPint, vPint, tol4S, scalingFactor);
        JgclToleranceForDistance tol4Boundary = new JgclToleranceForDistance(tol4B);
        JgclPolyline2D outerPolyline2D = this.outerBoundary2D.toPolyline(tol4Boundary);
        Vector<JgclPolyline2D> innerPolyline2D = new Vector<JgclPolyline2D>();
        Enumeration e = this.innerBoundaries2D.elements();
        while (e.hasMoreElements()) {
            JgclCompositeCurve2D inner = (JgclCompositeCurve2D)e.nextElement();
            innerPolyline2D.addElement(inner.toPolyline(tol4Boundary));
        }
        Vector<SurfacePointWithBoundaryInfo> innerPointsOnBasisSurface = new Vector<SurfacePointWithBoundaryInfo>();
        boolean jjj = false;
        Enumeration e2 = pointsOnBasisSurface.elements();
        while (e2.hasMoreElements()) {
            JgclPointOnSurface3D point = (JgclPointOnSurface3D)e2.nextElement();
            point2D = JgclPoint2D.of(point.parameters());
            if (!this.contains(point2D)) continue;
            SurfacePointWithBoundaryInfo innerPoint = new SurfacePointWithBoundaryInfo(this.basisSurface, point.uParameter(), point.vParameter(), -2, -1);
            innerPointsOnBasisSurface.addElement(innerPoint);
        }
        pointsOnBasisSurface = innerPointsOnBasisSurface;
        int i = 0;
        while (i < outerPolyline2D.nPoints() - 1) {
            point2D = outerPolyline2D.pointAt(i);
            SurfacePointWithBoundaryInfo point3D = new SurfacePointWithBoundaryInfo(this.basisSurface, point2D.x(), point2D.y(), -1, i);
            pointsOnBasisSurface.addElement(point3D);
            ++i;
        }
        int j = 0;
        while (j < innerPolyline2D.size()) {
            JgclPolyline2D inner = (JgclPolyline2D)innerPolyline2D.elementAt(j);
            int i2 = 0;
            while (i2 < inner.nPoints() - 1) {
                JgclPoint2D point2D2 = inner.pointAt(i2);
                SurfacePointWithBoundaryInfo point3D = new SurfacePointWithBoundaryInfo(this.basisSurface, point2D2.x(), point2D2.y(), j, i2);
                pointsOnBasisSurface.addElement(point3D);
                ++i2;
            }
            ++j;
        }
        if (scalingFactor[0] < scalingFactor[1]) {
            uScale = scalingFactor[0] / scalingFactor[1];
            vScale = 1.0;
        } else {
            uScale = 1.0;
            vScale = scalingFactor[1] / scalingFactor[0];
        }
        JgclSetOfTriangles3D triangles = null;
        int maxTrys = 5;
        int nTrys = 1;
        double radiusScale = 100.0;
        while (!this.flipDiagonalsIn(triangles = new JgclSetOfTriangles3D(pointsOnBasisSurface.elements(), uScale, vScale, radiusScale), outerPolyline2D, innerPolyline2D) && nTrys < maxTrys) {
            ++nTrys;
            radiusScale *= 10.0;
        }
        SurfacePointWithBoundaryInfo[] vpnts = new SurfacePointWithBoundaryInfo[3];
        JgclPoint2D[] vcrds2 = new JgclPoint2D[3];
        int[] order = new int[3];
        Enumeration e3 = triangles.faceElements();
        while (e3.hasMoreElements()) {
            JgclSetOfTriangles3D.Face face = (JgclSetOfTriangles3D.Face)e3.nextElement();
            JgclSetOfTriangles3D.Vertex[] vrtcs = face.getVerticesInCCW();
            vpnts[0] = (SurfacePointWithBoundaryInfo)vrtcs[0].getCoordinates();
            int boundaryNumber = vpnts[0].boundaryNumber;
            if (boundaryNumber < -1) continue;
            vpnts[1] = (SurfacePointWithBoundaryInfo)vrtcs[1].getCoordinates();
            if (vpnts[1].boundaryNumber != boundaryNumber) continue;
            vpnts[2] = (SurfacePointWithBoundaryInfo)vrtcs[2].getCoordinates();
            if (vpnts[2].boundaryNumber != boundaryNumber) continue;
            int i3 = 0;
            while (i3 < 3) {
                vcrds2[i3] = JgclPoint2D.of(vpnts[i3].parameters());
                ++i3;
            }
            if (vpnts[0].pointNumber < vpnts[1].pointNumber) {
                order[0] = 0;
                order[1] = 1;
            } else {
                order[0] = 1;
                order[1] = 0;
            }
            if (vpnts[order[1]].pointNumber < vpnts[2].pointNumber) {
                order[2] = 2;
            } else {
                order[2] = order[1];
                if (vpnts[order[0]].pointNumber < vpnts[2].pointNumber) {
                    order[1] = 2;
                } else {
                    order[1] = order[0];
                    order[0] = 2;
                }
            }
            JgclVector2D edge0 = vcrds2[order[1]].subtract(vcrds2[order[0]]);
            JgclVector2D edge1 = vcrds2[order[2]].subtract(vcrds2[order[1]]);
            if (edge0.zOfCrossProduct(edge1) > 0.0) continue;
            face.setKilled(true);
        }
        return triangles;
    }

    public static void main(String[] args) {
        JgclPoint3D[][] controlPoints = new JgclPoint3D[4][4];
        controlPoints[0][0] = JgclPoint3D.of(3.0, 5.0, 8.0);
        controlPoints[1][0] = JgclPoint3D.of(7.82963, 6.2941, 13.0);
        controlPoints[2][0] = JgclPoint3D.of(12.6593, 7.58819, 3.0);
        controlPoints[3][0] = JgclPoint3D.of(17.4889, 8.88229, 8.0);
        controlPoints[0][1] = JgclPoint3D.of(1.7059, 9.82963, 18.0);
        controlPoints[1][1] = JgclPoint3D.of(6.53553, 11.1237, 23.0);
        controlPoints[2][1] = JgclPoint3D.of(11.3652, 12.4178, 13.0);
        controlPoints[3][1] = JgclPoint3D.of(16.1948, 13.7119, 18.0);
        controlPoints[0][2] = JgclPoint3D.of(0.41181, 14.6593, 18.0);
        controlPoints[1][2] = JgclPoint3D.of(5.24144, 15.9534, 23.0);
        controlPoints[2][2] = JgclPoint3D.of(10.0711, 17.2474, 13.0);
        controlPoints[3][2] = JgclPoint3D.of(14.9007, 18.5415, 18.0);
        controlPoints[0][3] = JgclPoint3D.of(-0.882286, 19.4889, 8.0);
        controlPoints[1][3] = JgclPoint3D.of(3.94734, 20.783, 13.0);
        controlPoints[2][3] = JgclPoint3D.of(8.77697, 22.0771, 3.0);
        controlPoints[3][3] = JgclPoint3D.of(13.6066, 23.3712, 8.0);
        JgclPureBezierSurface3D basisSurface = new JgclPureBezierSurface3D(controlPoints);
        JgclCircle2D circle2D = new JgclCircle2D(JgclPoint2D.of(0.5, 0.5), 0.3);
        JgclSurfaceCurve3D surfaceCurve3D = new JgclSurfaceCurve3D(null, basisSurface, circle2D, 1);
        JgclTrimmedCurve3D trimmedCurve3D = new JgclTrimmedCurve3D(surfaceCurve3D, circle2D.parameterDomain().section());
        JgclCompositeCurveSegment3D[] segments = new JgclCompositeCurveSegment3D[]{new JgclCompositeCurveSegment3D(1, true, trimmedCurve3D)};
        JgclCompositeCurve3D outerBoundary = new JgclCompositeCurve3D(segments, true);
        Vector innerBoundaries = new Vector();
        JgclCurveBoundedSurface3D surface = new JgclCurveBoundedSurface3D(basisSurface, outerBoundary, innerBoundaries);
        JgclSetOfTriangles3D stri = surface.toSetOfTriangles(0.01, 0.001);
        int i = 0;
        Enumeration e = stri.edgeElements();
        while (e.hasMoreElements()) {
            JgclSetOfTriangles3D.Edge edge = (JgclSetOfTriangles3D.Edge)e.nextElement();
            JgclSetOfTriangles3D.Vertex[] vrtcs = edge.getVerticesOfStartEnd();
            JgclPoint3D pnt0 = vrtcs[0].getCoordinates();
            JgclPoint3D pnt1 = vrtcs[1].getCoordinates();
            System.out.println("JgclLine3D\tlin" + i);
            System.out.println("\tpnt\t" + pnt0.x() + " " + pnt0.y() + " " + pnt0.z());
            System.out.println("\tpnt\t" + pnt1.x() + " " + pnt1.y() + " " + pnt1.z());
            System.out.println("End");
            ++i;
        }
    }

    private static final class 1
    implements JgclListSorter.ObjectComparator {
        private final /* synthetic */ IntersectionWithBoundaryInfo[] val$iwbiBothEnds;

        public boolean latterIsGreaterThanFormer(Object former, Object latter) {
            IntersectionWithBoundaryInfo f = (IntersectionWithBoundaryInfo)former;
            IntersectionWithBoundaryInfo l = (IntersectionWithBoundaryInfo)latter;
            if (f == l) {
                return false;
            }
            if (f == this.val$iwbiBothEnds[0] || l == this.val$iwbiBothEnds[1]) {
                return true;
            }
            if (l == this.val$iwbiBothEnds[0] || f == this.val$iwbiBothEnds[1]) {
                return false;
            }
            return f.curveParameter < l.curveParameter;
        }

        /* synthetic */ 1(IntersectionWithBoundaryInfo[] val$iwbiBothEnds) {
            this.val$iwbiBothEnds = val$iwbiBothEnds;
        }
    }

    private class IntersectionWithBoundaryInfo {
        int boundaryIndex;
        double boundaryParameter;
        double curveParameter;

        IntersectionWithBoundaryInfo() {
            JgclCurveBoundedSurface3D.this = JgclCurveBoundedSurface3D.this;
        }

        IntersectionWithBoundaryInfo(int boundaryIndex, double boundaryParameter, double curveParameter) {
            JgclCurveBoundedSurface3D.this = JgclCurveBoundedSurface3D.this;
            this.boundaryIndex = boundaryIndex;
            this.boundaryParameter = boundaryParameter;
            this.curveParameter = curveParameter;
        }
    }

    private class TrimmingInterval {
        int sIdx;
        int eIdx;

        TrimmingInterval(int sIdx, int eIdx) {
            JgclCurveBoundedSurface3D.this = JgclCurveBoundedSurface3D.this;
            this.sIdx = sIdx;
            this.eIdx = eIdx;
        }
    }

    private static final class 2
    implements JgclListSorter.ObjectComparator {
        private final /* synthetic */ IntersectionWithBoundaryInfo[] val$iwbiBothEnds;

        public boolean latterIsGreaterThanFormer(Object former, Object latter) {
            IntersectionWithBoundaryInfo f = (IntersectionWithBoundaryInfo)former;
            IntersectionWithBoundaryInfo l = (IntersectionWithBoundaryInfo)latter;
            if (f == l) {
                return false;
            }
            if (f == this.val$iwbiBothEnds[0] || l == this.val$iwbiBothEnds[1]) {
                return true;
            }
            if (l == this.val$iwbiBothEnds[0] || f == this.val$iwbiBothEnds[1]) {
                return false;
            }
            return f.curveParameter < l.curveParameter;
        }

        /* synthetic */ 2(IntersectionWithBoundaryInfo[] val$iwbiBothEnds) {
            this.val$iwbiBothEnds = val$iwbiBothEnds;
        }
    }

    private class SurfacePointWithBoundaryInfo
    extends JgclPointOnSurface3D {
        int boundaryNumber;
        int pointNumber;

        SurfacePointWithBoundaryInfo(JgclParametricSurface3D basisSurface, double uParam, double vParam, int boundaryNumber, int pointNumber) {
            super(basisSurface, uParam, vParam);
            JgclCurveBoundedSurface3D.this = JgclCurveBoundedSurface3D.this;
            this.boundaryNumber = boundaryNumber;
            this.pointNumber = pointNumber;
        }

        boolean isNeighborOf(SurfacePointWithBoundaryInfo mate, JgclPolyline2D outerPolyline2D, Vector innerPolylines2D) {
            JgclPolyline2D boundary;
            if (this.boundaryNumber != mate.boundaryNumber) {
                return false;
            }
            if (this.pointNumber == mate.pointNumber - 1 || this.pointNumber == mate.pointNumber + 1) {
                return true;
            }
            if (this.pointNumber != 0 && mate.pointNumber != 0) {
                return false;
            }
            JgclPolyline2D jgclPolyline2D = boundary = this.boundaryNumber == -1 ? outerPolyline2D : (JgclPolyline2D)innerPolylines2D.elementAt(this.boundaryNumber);
            return this.pointNumber == 0 ? mate.pointNumber == boundary.nPoints() - 2 : this.pointNumber == boundary.nPoints() - 2;
        }
    }

    private class SomeThingWrong
    extends JgclException {
        public SomeThingWrong() {
            JgclCurveBoundedSurface3D.this = JgclCurveBoundedSurface3D.this;
        }
    }
}

