/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Vector;
import jp.go.ipa.jgcl.JgclAxis2Placement2D;
import jp.go.ipa.jgcl.JgclBinaryTree;
import jp.go.ipa.jgcl.JgclBsplineCurve2D;
import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclComplex;
import jp.go.ipa.jgcl.JgclComplexPolynomial;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclCurveDerivative2D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclVector2D;
import jp.go.ipa.jgcl.JgclZeroLength;

public abstract class JgclConic2D
extends JgclParametricCurve2D {
    private JgclAxis2Placement2D position;

    private JgclConic2D() {
        this.position = null;
    }

    protected JgclConic2D(JgclAxis2Placement2D position) {
        if (position == null) {
            throw new JgclInvalidArgumentValue("position is null.");
        }
        this.position = position;
    }

    public JgclPolyline2D toPolyline(JgclParameterSection pint, JgclToleranceForDistance tol) {
        double ep;
        double sp;
        if (pint.increase() < 0.0) {
            return this.toPolyline(pint.reverse(), tol).reverse();
        }
        JgclParameterDomain domain = this.parameterDomain();
        if (domain.isPeriodic()) {
            sp = domain.wrap(pint.start());
            ep = sp + pint.increase();
        } else {
            sp = pint.lower();
            this.checkValidity(sp);
            ep = pint.upper();
            this.checkValidity(ep);
        }
        double tolerance = Math.abs(tol.value());
        IntervalInfo root_info = new IntervalInfo();
        root_info.left = new JgclPointOnCurve2D(this, sp, false);
        root_info.right = new JgclPointOnCurve2D(this, ep, false);
        JgclBinaryTree pnt_tree = new JgclBinaryTree(root_info);
        int no_pnts = 2;
        JgclPoint2D[] pnts = new JgclPoint2D[no_pnts += this.divideInterval(pnt_tree.rootNode(), tolerance)];
        FillInfo fill_info = new FillInfo(pnts, 0);
        pnt_tree.rootNode().preOrderTraverse(new FillArray(), fill_info);
        if (no_pnts == 2 && pnts[0].identical(pnts[1])) {
            throw new JgclZeroLength();
        }
        return new JgclPolyline2D(pnts);
    }

    private int divideInterval(JgclBinaryTree.Node crnt_node, double tol) {
        int no_pnts = 1;
        IntervalInfo crnt_info = (IntervalInfo)crnt_node.data();
        double mid_param = (crnt_info.left.parameter() + crnt_info.right.parameter()) / 2.0;
        IntervalInfo left_info = new IntervalInfo();
        left_info.left = crnt_info.left;
        try {
            left_info.right = new JgclPointOnCurve2D(this, mid_param, false);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
        JgclBinaryTree.Node left_node = crnt_node.makeLeft(left_info);
        IntervalInfo right_info = new IntervalInfo();
        right_info.left = left_info.right;
        right_info.right = crnt_info.right;
        JgclBinaryTree.Node right_node = crnt_node.makeRight(right_info);
        if (!this.checkInterval(left_info, tol)) {
            no_pnts += this.divideInterval(left_node, tol);
        }
        if (!this.checkInterval(right_info, tol)) {
            no_pnts += this.divideInterval(right_node, tol);
        }
        return no_pnts;
    }

    abstract double getPeak(double var1, double var3);

    private boolean checkInterval(IntervalInfo info, double tol) {
        double peak_param = this.getPeak(info.left.parameter(), info.right.parameter());
        JgclPoint2D peak = this.coordinates(peak_param);
        JgclVector2D unitChord = info.right.subtract(info.left).unitized();
        JgclVector2D left2peak = peak.subtract(info.left);
        double height = Math.abs(left2peak.zOfCrossProduct(unitChord));
        return height < tol;
    }

    public JgclAxis2Placement2D position() {
        return this.position;
    }

    public JgclPointOnCurve2D[] singular() {
        return new JgclPointOnCurve2D[0];
    }

    public JgclPointOnCurve2D[] inflexion() {
        return new JgclPointOnCurve2D[0];
    }

    JgclIntersectionPoint2D[] intersect(JgclPureBezierCurve2D mate, boolean doExchange) {
        JgclComplex[] roots;
        JgclAxis2Placement2D placement = this.position();
        JgclCartesianTransformationOperator2D transform = new JgclCartesianTransformationOperator2D(placement, 1.0);
        int uicp = mate.nControlPoints();
        JgclPoint2D[] newCp = new JgclPoint2D[uicp];
        int i = 0;
        while (i < uicp) {
            newCp[i] = transform.toLocal(mate.controlPointAt(i));
            ++i;
        }
        JgclPureBezierCurve2D bzc = new JgclPureBezierCurve2D(newCp, mate.weights(), false);
        Vector<JgclPoint2D> pointVec = new Vector<JgclPoint2D>();
        Vector<Double> paramVec = new Vector<Double>();
        boolean isPoly = bzc.isPolynomial();
        JgclRealPolynomial[] poly = bzc.polynomial(isPoly);
        JgclRealPolynomial realPoly = this.makePoly(poly);
        JgclComplexPolynomial compPoly = realPoly.toComplexPolynomial();
        try {
            roots = compPoly.getRootsByDKA();
        }
        catch (JgclComplexPolynomial.DKANotConverge e) {
            roots = e.getValues();
        }
        catch (JgclComplexPolynomial.ImpossibleEquation impossibleEquation) {
            throw new JgclFatal();
        }
        catch (JgclComplexPolynomial.IndefiniteEquation indefiniteEquation) {
            throw new JgclFatal();
        }
        int nRoots = roots.length;
        int j = 0;
        while (j < nRoots) {
            double realRoot = roots[j].real();
            if (bzc.parameterValidity(realRoot) != 3) {
                JgclPoint2D workPoint;
                if (realRoot < 0.0) {
                    realRoot = 0.0;
                }
                if (realRoot > 1.0) {
                    realRoot = 1.0;
                }
                if (this.checkSolution(workPoint = bzc.coordinates(realRoot))) {
                    int jj = 0;
                    while (jj < pointVec.size()) {
                        JgclPoint2D pt = (JgclPoint2D)pointVec.elementAt(jj);
                        double param = (Double)paramVec.elementAt(jj);
                        if (pt.identical(workPoint) && bzc.identicalParameter(param, realRoot)) break;
                        ++jj;
                    }
                    pointVec.addElement(workPoint);
                    paramVec.addElement(new Double(realRoot));
                }
            }
            ++j;
        }
        int num = paramVec.size();
        JgclIntersectionPoint2D[] intersectPoint = new JgclIntersectionPoint2D[num];
        int i2 = 0;
        while (i2 < num) {
            JgclPoint2D point = (JgclPoint2D)pointVec.elementAt(i2);
            double param = this.getParameter(point);
            JgclPointOnCurve2D pointOnConic = new JgclPointOnCurve2D(this, param, false);
            double work = (Double)paramVec.elementAt(i2);
            JgclPointOnCurve2D pointOnBzc = new JgclPointOnCurve2D(mate, work, false);
            intersectPoint[i2] = !doExchange ? new JgclIntersectionPoint2D(pointOnConic, pointOnBzc, false) : new JgclIntersectionPoint2D(pointOnBzc, pointOnConic, false);
            ++i2;
        }
        return intersectPoint;
    }

    JgclIntersectionPoint2D[] intersect(JgclBsplineCurve2D mate, boolean doExchange) {
        JgclAxis2Placement2D placement = this.position();
        JgclCartesianTransformationOperator2D transform = new JgclCartesianTransformationOperator2D(placement, 1.0);
        JgclBsplineKnot.ValidSegmentInfo vsegInfo = mate.validSegments();
        JgclPoint2D[] cp = mate.controlPoints();
        int uicp = mate.nControlPoints();
        JgclPoint2D[] newCp = new JgclPoint2D[uicp];
        int i = 0;
        while (i < uicp) {
            newCp[i] = transform.toLocal(cp[i]);
            ++i;
        }
        JgclBsplineCurve2D bsc = new JgclBsplineCurve2D(mate.knotData(), newCp, mate.weights());
        Vector<JgclPoint2D> pointVec = new Vector<JgclPoint2D>();
        Vector<Double> paramVec = new Vector<Double>();
        int nSeg = vsegInfo.nSegments();
        int k = 0;
        int i2 = 0;
        while (i2 < nSeg) {
            JgclComplex[] roots;
            JgclRealPolynomial[] poly = bsc.polynomial(vsegInfo.segmentNumber(i2), bsc.isPolynomial());
            JgclRealPolynomial realPoly = this.makePoly(poly);
            JgclComplexPolynomial compPoly = realPoly.toComplexPolynomial();
            try {
                roots = compPoly.getRootsByDKA();
            }
            catch (JgclComplexPolynomial.DKANotConverge e) {
                roots = e.getValues();
            }
            catch (JgclComplexPolynomial.ImpossibleEquation impossibleEquation) {
                throw new JgclFatal();
            }
            catch (JgclComplexPolynomial.IndefiniteEquation indefiniteEquation) {
                throw new JgclFatal();
            }
            int nRoots = roots.length;
            int j = 0;
            while (j < nRoots) {
                double realRoot = roots[j].real();
                if (bsc.parameterValidity(realRoot) != 3) {
                    JgclPoint2D workPoint;
                    double[] knotParams = vsegInfo.knotPoint(i2);
                    if (realRoot < knotParams[0]) {
                        realRoot = knotParams[0];
                    }
                    if (realRoot > knotParams[1]) {
                        realRoot = knotParams[1];
                    }
                    if (this.checkSolution(workPoint = bsc.coordinates(realRoot))) {
                        int jj = 0;
                        while (jj < k) {
                            double dTol = bsc.getToleranceForDistance();
                            JgclPoint2D pt = (JgclPoint2D)pointVec.elementAt(jj);
                            double param = (Double)paramVec.elementAt(jj);
                            if (pt.identical(workPoint) && bsc.identicalParameter(param, realRoot)) break;
                            ++jj;
                        }
                        if (jj >= k) {
                            pointVec.addElement(workPoint);
                            paramVec.addElement(new Double(realRoot));
                            ++k;
                        }
                    }
                }
                ++j;
            }
            ++i2;
        }
        int num = paramVec.size();
        JgclIntersectionPoint2D[] intersectPoint = new JgclIntersectionPoint2D[num];
        int i3 = 0;
        while (i3 < k) {
            JgclPoint2D point = (JgclPoint2D)pointVec.elementAt(i3);
            double param = this.getParameter(point);
            JgclPointOnCurve2D pointOnConic = new JgclPointOnCurve2D(this, param, false);
            double work = (Double)paramVec.elementAt(i3);
            JgclPointOnCurve2D pointOnBsc = new JgclPointOnCurve2D(mate, work, false);
            intersectPoint[i3] = !doExchange ? new JgclIntersectionPoint2D(pointOnConic, pointOnBsc, false) : new JgclIntersectionPoint2D(pointOnBsc, pointOnConic, false);
            ++i3;
        }
        return intersectPoint;
    }

    abstract JgclRealPolynomial makePoly(JgclRealPolynomial[] var1);

    abstract boolean checkSolution(JgclPoint2D var1);

    abstract double getParameter(JgclPoint2D var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected JgclPoint2D[] getControlPointsOfBezierCurve(JgclParameterSection pint) {
        double d;
        double angle;
        JgclCurveDerivative2D derivative = this.evaluation(pint.lower());
        JgclLine2D lowerTangentLine = new JgclLine2D(derivative.d0D(), derivative.d1D());
        derivative = this.evaluation(pint.upper());
        JgclLine2D upperTangentLine = new JgclLine2D(derivative.d0D(), derivative.d1D());
        JgclPoint2D[] controlPoints = new JgclPoint2D[3];
        if (pint.increase() > 0.0) {
            controlPoints[0] = lowerTangentLine.pnt();
            controlPoints[2] = upperTangentLine.pnt();
        } else {
            controlPoints[2] = lowerTangentLine.pnt();
            controlPoints[0] = upperTangentLine.pnt();
        }
        double atol = this.getToleranceForAngle();
        boolean push = false;
        double angleFromParallel = angle = lowerTangentLine.dir().angleWith(upperTangentLine.dir());
        if (d < atol) {
            push = true;
        } else {
            double d2;
            angleFromParallel = Math.abs(Math.PI - angle);
            if (d2 < atol) {
                push = true;
            } else {
                double d3;
                angleFromParallel = Math.abs(Math.PI * 2 - angle);
                if (d3 < atol) {
                    push = true;
                }
            }
        }
        if (push) {
            JgclConditionOfOperation.getCondition().makeCopyWithToleranceForAngle(angleFromParallel / 2.0).push();
        }
        try {
            try {
                controlPoints[1] = lowerTangentLine.intersect1Line(upperTangentLine).literal();
            }
            catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                throw new JgclFatal("Two tangent lines does not intersect");
            }
            Object var14_10 = null;
            if (!push) return controlPoints;
        }
        catch (Throwable throwable) {
            Object var14_11 = null;
            if (!push) throw throwable;
            JgclConditionOfOperation.pop();
            throw throwable;
        }
        JgclConditionOfOperation.pop();
        return controlPoints;
    }

    protected static JgclBsplineCurve2D convertPolyBezierCurvesToOneBsplineCurve(JgclPureBezierCurve2D[] bezierCurves, boolean closed) {
        int uik;
        int uicp;
        int nBeziers = bezierCurves.length;
        if (!closed) {
            uicp = nBeziers != 3 ? nBeziers + 2 : nBeziers + 3;
            uik = nBeziers + 1;
        } else {
            uicp = 5;
            uik = 6;
        }
        int degree = 2;
        boolean periodic = closed;
        int[] knotMultiplicities = new int[uik];
        double[] knots = new double[uik];
        JgclPoint2D[] controlPoints = new JgclPoint2D[uicp];
        double[] weights = new double[uicp];
        switch (nBeziers) {
            case 1: {
                int i = 0;
                while (i < 3) {
                    controlPoints[i] = bezierCurves[0].controlPointAt(i);
                    weights[i] = bezierCurves[0].weightAt(i);
                    ++i;
                }
                knots[0] = 0.0;
                knotMultiplicities[0] = 3;
                knots[1] = 1.0;
                knotMultiplicities[1] = 3;
                break;
            }
            case 2: {
                controlPoints[0] = bezierCurves[0].controlPointAt(0);
                controlPoints[1] = bezierCurves[0].controlPointAt(1);
                controlPoints[2] = bezierCurves[1].controlPointAt(1);
                controlPoints[3] = bezierCurves[1].controlPointAt(2);
                weights[0] = 1.0;
                weights[1] = weights[2] = bezierCurves[0].weightAt(1) * bezierCurves[0].weightAt(1);
                weights[3] = 1.0;
                knots[0] = 0.0;
                knotMultiplicities[0] = 3;
                knots[1] = 1.0;
                knotMultiplicities[1] = 1;
                knots[2] = 2.0;
                knotMultiplicities[2] = 3;
                break;
            }
            case 3: {
                if (!closed) {
                    controlPoints[0] = bezierCurves[0].controlPointAt(0);
                    controlPoints[1] = bezierCurves[0].controlPointAt(1);
                    controlPoints[2] = bezierCurves[1].controlPointAt(1);
                    controlPoints[3] = bezierCurves[1].controlPointAt(2);
                    controlPoints[4] = bezierCurves[2].controlPointAt(1);
                    controlPoints[5] = bezierCurves[2].controlPointAt(2);
                    weights[0] = 1.0;
                    weights[1] = weights[2] = bezierCurves[0].weightAt(1) * bezierCurves[0].weightAt(1);
                    weights[3] = 1.0;
                    weights[4] = bezierCurves[2].weightAt(1);
                    weights[5] = 1.0;
                    knots[0] = 0.0;
                    knotMultiplicities[0] = 3;
                    knots[1] = 1.0;
                    knotMultiplicities[1] = 1;
                    knots[2] = 2.0;
                    knotMultiplicities[2] = 2;
                    knots[3] = 4.0;
                    knotMultiplicities[3] = 3;
                    break;
                }
                controlPoints[0] = bezierCurves[2].controlPointAt(1);
                controlPoints[1] = bezierCurves[0].controlPointAt(0);
                controlPoints[2] = bezierCurves[0].controlPointAt(1);
                controlPoints[3] = bezierCurves[1].controlPointAt(1);
                controlPoints[4] = bezierCurves[1].controlPointAt(2);
                weights[0] = bezierCurves[2].weightAt(1);
                weights[1] = 1.0;
                weights[2] = weights[3] = bezierCurves[0].weightAt(1) * bezierCurves[0].weightAt(1);
                weights[4] = 1.0;
                knots[0] = -2.0;
                knotMultiplicities[0] = 2;
                knots[1] = 0.0;
                knotMultiplicities[1] = 2;
                knots[2] = 1.0;
                knotMultiplicities[2] = 1;
                knots[3] = 2.0;
                knotMultiplicities[3] = 2;
                knots[4] = 4.0;
                knotMultiplicities[4] = 2;
                knots[5] = 5.0;
                knotMultiplicities[5] = 1;
                break;
            }
        }
        return new JgclBsplineCurve2D(degree, periodic, knotMultiplicities, knots, controlPoints, weights);
    }

    private class IntervalInfo {
        JgclPointOnCurve2D left;
        JgclPointOnCurve2D right;

        IntervalInfo() {
            JgclConic2D.this = JgclConic2D.this;
        }
    }

    private class FillArray
    implements JgclBinaryTree.TraverseProc {
        public boolean doit(JgclBinaryTree.Node node, int ctl, Object pdata) {
            if (node.left() == null && node.right() == null) {
                FillInfo fill_info = (FillInfo)pdata;
                int idx = fill_info.index;
                IntervalInfo info = (IntervalInfo)node.data();
                if (idx == 0) {
                    ((FillInfo)fill_info).pnts[idx++] = info.left;
                }
                ((FillInfo)fill_info).pnts[idx++] = info.right;
                fill_info.index = idx;
            }
            return false;
        }

        FillArray() {
            JgclConic2D.this = JgclConic2D.this;
        }
    }

    private class FillInfo {
        private JgclPoint2D[] pnts;
        private int index;

        private FillInfo(JgclPoint2D[] pnts, int index) {
            JgclConic2D.this = JgclConic2D.this;
            this.pnts = pnts;
            this.index = index;
        }
    }
}

