/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclComplex;
import jp.go.ipa.jgcl.JgclComplexFunctionWithOneVariable;
import jp.go.ipa.jgcl.JgclException;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclMachineEpsilon;
import jp.go.ipa.jgcl.JgclMath;

public class JgclComplexPolynomial
implements JgclComplexFunctionWithOneVariable {
    private JgclComplex[] coef;
    private boolean normalized;

    private JgclComplexPolynomial() {
        this.coef = null;
        this.normalized = false;
    }

    private JgclComplexPolynomial(JgclComplex[] coef, boolean normalized) {
        this.coef = (JgclComplex[])coef.clone();
        this.normalized = normalized;
    }

    public JgclComplexPolynomial(JgclComplex[] coef) {
        if (coef == null) {
            throw new JgclInvalidArgumentValue("Array of coefficients is null.");
        }
        if (coef.length < 1) {
            throw new JgclInvalidArgumentValue("Size of array of coefficients is zero.");
        }
        this.coef = (JgclComplex[])coef.clone();
        this.normalized = false;
    }

    public JgclComplexPolynomial(double[] coef) {
        if (coef == null) {
            throw new JgclInvalidArgumentValue("Array of coefficients is null.");
        }
        if (coef.length < 1) {
            throw new JgclInvalidArgumentValue("Size of array of coefficients is zero.");
        }
        this.coef = new JgclComplex[coef.length];
        int i = 0;
        while (i < coef.length) {
            this.coef[i] = new JgclComplex(coef[i]);
            ++i;
        }
        this.normalized = false;
    }

    public JgclComplexPolynomial(JgclComplex coef0, JgclComplex coef1, JgclComplex coef2) {
        this.coef = new JgclComplex[3];
        this.coef[0] = coef0;
        this.coef[1] = coef1;
        this.coef[2] = coef2;
    }

    public int degree() {
        return this.coef.length - 1;
    }

    public JgclComplex coefficientAt(int degree) {
        return this.coef[degree];
    }

    public JgclComplex[] coefficientsBetween(int lower, int upper) {
        int n = upper - lower + 1;
        JgclComplex[] result = new JgclComplex[n];
        int i = 0;
        while (i < n) {
            result[i] = this.coef[lower + i];
            ++i;
        }
        return result;
    }

    public JgclComplex evaluate(JgclComplex parameter) {
        JgclComplex value = this.coef[this.degree()];
        int i = this.degree() - 1;
        while (i >= 0) {
            value = value.mul(parameter).add(this.coef[i]);
            --i;
        }
        return value;
    }

    public JgclComplex[] getRootsIfQuadric() {
        if (this.degree() != 2) {
            return null;
        }
        JgclComplex[] roots = new JgclComplex[2];
        if (this.coef[2].abs() > JgclMachineEpsilon.DOUBLE) {
            boolean secondByAdding;
            JgclComplex discriminant = this.coef[1].mul(this.coef[1]).sub(this.coef[2].mul(this.coef[0]).mul(4.0)).sqrt();
            JgclComplex minusCoef1 = this.coef[1].minus();
            if (this.coef[1].real() > 0.0) {
                roots[0] = minusCoef1.sub(discriminant);
                secondByAdding = true;
            } else {
                roots[0] = minusCoef1.add(discriminant);
                secondByAdding = false;
            }
            roots[0] = roots[0].div(this.coef[2].mul(2.0));
            if (roots[0].abs() > JgclMachineEpsilon.DOUBLE) {
                roots[1] = this.coef[0].div(this.coef[2]).div(roots[0]);
            } else {
                roots[1] = secondByAdding ? minusCoef1.add(discriminant) : minusCoef1.sub(discriminant);
                roots[1] = roots[1].div(this.coef[2].mul(2.0));
            }
        } else if (this.coef[1].abs() > JgclMachineEpsilon.DOUBLE) {
            roots[0] = this.coef[0].minus().div(this.coef[1]);
            roots[1] = roots[0].copy();
        } else {
            roots[0] = new JgclComplex(Double.NaN, 0.0);
            roots[1] = roots[0].copy();
        }
        return roots;
    }

    public JgclComplexPolynomial normalize() {
        double maxVal;
        int maxIdx;
        if (this.normalized) {
            return this;
        }
        int minIdx = maxIdx = this.degree();
        double minVal = maxVal = this.coef[this.degree()].abs();
        int i = this.degree() - 1;
        while (i >= 0) {
            double absVal = this.coef[i].abs();
            if (absVal < minVal) {
                minIdx = i;
                minVal = absVal;
            }
            if (maxVal < absVal) {
                maxIdx = i;
                maxVal = absVal;
            }
            --i;
        }
        if (minIdx == maxIdx && maxVal < JgclMachineEpsilon.DOUBLE) {
            JgclComplex[] zeroCoef = new JgclComplex[]{new JgclComplex(0.0, 0.0)};
            return new JgclComplexPolynomial(zeroCoef, true);
        }
        int actualDegree = this.degree() + 1;
        while (--actualDegree >= 0) {
            if (this.coef[actualDegree].div(maxVal).abs() > JgclMachineEpsilon.DOUBLE) break;
        }
        if (actualDegree == 0) {
            JgclComplex[] zeroCoef = new JgclComplex[]{new JgclComplex(0.0, 0.0)};
            return new JgclComplexPolynomial(zeroCoef, true);
        }
        JgclComplex[] normalizedCoef = new JgclComplex[actualDegree + 1];
        int i2 = 0;
        while (i2 <= actualDegree) {
            normalizedCoef[i2] = this.coef[i2].div(maxVal);
            ++i2;
        }
        return new JgclComplexPolynomial(normalizedCoef, true);
    }

    public JgclComplexPolynomial add(JgclComplexPolynomial mate) {
        if (mate.degree() > this.degree()) {
            return mate.add(this);
        }
        if (this.degree() < 0 || mate.degree() < 0) {
            throw new JgclFatal();
        }
        JgclComplex[] newCoef = new JgclComplex[this.degree() + 1];
        int ijk = 0;
        while (ijk <= mate.degree()) {
            newCoef[ijk] = this.coef[ijk].add(mate.coef[ijk]);
            ++ijk;
        }
        while (ijk <= this.degree()) {
            newCoef[ijk] = this.coef[ijk];
            ++ijk;
        }
        return new JgclComplexPolynomial(newCoef, false);
    }

    public JgclComplexPolynomial subtract(JgclComplexPolynomial mate) {
        return this.add(mate.multiply(new JgclComplex(-1.0)));
    }

    public JgclComplexPolynomial multiply(JgclComplex val) {
        if (this.degree() < 0) {
            throw new JgclFatal();
        }
        JgclComplex[] newCoef = new JgclComplex[this.degree() + 1];
        int ijk = 0;
        while (ijk <= this.degree()) {
            newCoef[ijk] = val.mul(this.coef[ijk]);
            ++ijk;
        }
        return new JgclComplexPolynomial(newCoef, false);
    }

    public JgclComplexPolynomial multiply(JgclComplexPolynomial mate) {
        if (this.degree() < 0 || mate.degree() < 0) {
            throw new JgclFatal();
        }
        int newDegree = this.degree() + mate.degree();
        JgclComplex[] newCoef = new JgclComplex[newDegree + 1];
        int ijk = 0;
        while (ijk <= newDegree) {
            newCoef[ijk] = new JgclComplex();
            ++ijk;
        }
        ijk = 0;
        while (ijk <= this.degree()) {
            int klm = 0;
            while (klm <= mate.degree()) {
                int idx = ijk + klm;
                JgclComplex c = this.coefficientAt(ijk).mul(mate.coefficientAt(klm));
                newCoef[idx] = newCoef[idx].add(c);
                ++klm;
            }
            ++ijk;
        }
        return new JgclComplexPolynomial(newCoef, false);
    }

    public JgclComplexPolynomial derive() {
        if (this.degree() < 0) {
            throw new JgclFatal();
        }
        JgclComplex[] newCoef = new JgclComplex[this.degree()];
        int ijk = 1;
        while (ijk <= this.degree()) {
            newCoef[ijk - 1] = this.coef[ijk].mul(new JgclComplex(ijk));
            ++ijk;
        }
        return new JgclComplexPolynomial(newCoef, false);
    }

    public JgclComplex getOneRootByNR(JgclComplex initialGuess) throws NRNotConverge {
        JgclComplex root = initialGuess;
        double epsilon = JgclMachineEpsilon.DOUBLE;
        int maxIteration = 50;
        int iteration = 0;
        while (iteration < maxIteration) {
            JgclComplex value = this.coefficientAt(this.degree());
            JgclComplex deriv = value.copy();
            double delta = 0.0;
            int j = this.degree() - 1;
            while (j >= 0) {
                JgclComplex tempVal = value.mul(root);
                JgclComplex theCoef = this.coefficientAt(j);
                value = tempVal.add(theCoef);
                double absTempVal = tempVal.abs();
                if (j > 0) {
                    deriv = deriv.mul(root).add(value);
                }
                delta = root.abs() * delta + epsilon * (absTempVal + JgclMath.maxOf3(theCoef.abs(), absTempVal, value.abs()));
                --j;
            }
            double absVal = value.abs();
            if (absVal < epsilon && delta < epsilon || absVal < delta) {
                return root;
            }
            root = deriv.abs() > epsilon ? root.sub(value.div(deriv)) : root.sub(value.div(deriv.getEpsilon()));
            ++iteration;
        }
        throw new NRNotConverge(root);
    }

    public JgclComplex[] getRootsByDKA() throws DKANotConverge, IndefiniteEquation, ImpossibleEquation {
        if (!this.normalized) {
            return this.normalize().getRootsByDKA();
        }
        JgclComplexPolynomial func = this;
        int degree = func.degree();
        if (degree == 0) {
            if (func.coefficientAt(degree).abs() < JgclMachineEpsilon.DOUBLE) {
                throw new IndefiniteEquation();
            }
            throw new ImpossibleEquation();
        }
        JgclComplex[] result = new JgclComplex[degree];
        double radiusEps = 1.0E-8;
        int i = 0;
        while (i <= degree) {
            if (func.coefficientAt(i).abs() > JgclMachineEpsilon.DOUBLE) break;
            ++i;
        }
        int nonZeroCoef = i;
        if (nonZeroCoef > degree) {
            throw new IndefiniteEquation();
        }
        if (nonZeroCoef > 0) {
            int j = nonZeroCoef;
            while (j > 0) {
                result[degree - j] = new JgclComplex(0.0, 0.0);
                --j;
            }
            int revDegree = degree - nonZeroCoef;
            if (revDegree == 0) {
                return result;
            }
            JgclComplex[] coefs = new JgclComplex[revDegree + 1];
            j = revDegree;
            int k = degree;
            while (k >= nonZeroCoef) {
                coefs[j] = func.coefficientAt(k);
                --j;
                --k;
            }
            func = new JgclComplexPolynomial(coefs, true);
            degree = func.degree();
        }
        if (degree == 1) {
            result[0] = func.coefficientAt(degree - 1).minus().div(func.coefficientAt(degree));
            return result;
        }
        if (degree == 2) {
            JgclComplex[] moreResult = func.getRootsIfQuadric();
            result[0] = moreResult[0];
            result[1] = moreResult[1];
            return result;
        }
        if (func.getAbrth(result) < radiusEps) {
            return result;
        }
        if (!func.compDK3(result)) {
            throw new DKANotConverge(result);
        }
        return result;
    }

    private double getAbrth(JgclComplex[] result) {
        JgclComplexPolynomial func = this;
        int degree = func.degree();
        JgclComplex[] dcA = new JgclComplex[degree + 1];
        int i = 0;
        while (i <= degree) {
            dcA[i] = func.coefficientAt(degree - i);
            ++i;
        }
        double erng1 = 0.0;
        int maxIteration = 50;
        JgclComplex ecci = new JgclComplex(0.0, 1.0);
        JgclComplex[] ecC = new JgclComplex[degree + 1];
        double[] eCA = new double[degree + 1];
        JgclComplex ecbeta = dcA[1].minus().div(dcA[0].mul(degree));
        int ijk = 0;
        while (ijk <= degree) {
            ecC[ijk] = dcA[ijk].copy();
            ++ijk;
        }
        int klm = 0;
        while (klm < degree) {
            int mno = degree - klm;
            ijk = 1;
            while (ijk <= mno) {
                ecC[ijk] = ecC[ijk].add(ecbeta.mul(ecC[ijk - 1]));
                ++ijk;
            }
            ++klm;
        }
        ijk = 0;
        while (ijk <= degree) {
            eCA[ijk] = ecC[ijk].abs();
            ++ijk;
        }
        int jm = degree;
        ijk = 1;
        while (ijk <= degree) {
            if (eCA[ijk] == 0.0) {
                --jm;
            }
            ++ijk;
        }
        double erng = 0.0;
        double eCM = (double)jm / eCA[0];
        ijk = 1;
        while (ijk <= degree) {
            if (eCA[ijk] != 0.0) {
                double d;
                double erv = Math.exp(Math.log(eCA[ijk] * eCM) / (double)ijk);
                if (d > erng) {
                    erng = erv;
                }
            }
            ++ijk;
        }
        double ereps = erng * 0.01;
        int iter = 0;
        while (iter < maxIteration) {
            double eQ0;
            double eQ1 = eQ0 = eCA[0];
            klm = 1;
            while (klm < degree) {
                eQ0 = erng * eQ0 - eCA[klm];
                eQ1 = erng * eQ1 + eQ0;
                ++klm;
            }
            eQ0 = erng * eQ0 - eCA[degree];
            erng1 = Math.abs(eQ1) > JgclMachineEpsilon.DOUBLE ? erng - eQ0 / eQ1 : erng - eQ0 / JgclMath.copySign(JgclMachineEpsilon.DOUBLE, eQ1);
            if (erng - erng1 <= ereps) break;
            erng = erng1;
            ++iter;
        }
        double ep2n = Math.PI * 2 / (double)degree;
        double eh3n = 3.0 / (double)(2 * degree);
        ijk = 0;
        while (ijk < degree) {
            result[ijk] = ecbeta.add(ecci.mul(ep2n * (double)ijk + eh3n).exp().mul(erng1));
            ++ijk;
        }
        return erng1;
    }

    private boolean compDK3(JgclComplex[] result) {
        JgclComplexPolynomial func = this;
        int degree = func.degree();
        JgclComplex[] dcA = new JgclComplex[degree + 1];
        int i = 0;
        while (i <= degree) {
            dcA[i] = func.coefficientAt(degree - i);
            ++i;
        }
        int maxIteration = 50;
        JgclComplex ec1 = new JgclComplex(1.0, 0.0);
        double secondEps = 1.0E-8;
        double[] eCA = new double[degree + 1];
        JgclComplex[] edcA = new JgclComplex[degree + 1];
        JgclComplex[] ecZN = new JgclComplex[degree];
        int imax = 0;
        double emax = dcA[0].abs();
        int ijk = 1;
        while (ijk <= degree) {
            double d;
            double ewrk = dcA[ijk].abs();
            if (d > emax) {
                imax = ijk;
                emax = ewrk;
            }
            ++ijk;
        }
        ijk = 0;
        while (ijk <= degree) {
            edcA[ijk] = ijk != imax ? dcA[ijk].div(dcA[imax]) : new JgclComplex(1.0, 0.0);
            eCA[ijk] = edcA[ijk].abs();
            ++ijk;
        }
        int iter = 0;
        while (iter < maxIteration) {
            int inconv = 0;
            int klm = 0;
            while (klm < degree) {
                JgclComplex ecP0 = edcA[0].copy();
                JgclComplex ecP1 = ecP0.copy();
                double edelta = 0.0;
                double eZA = result[klm].abs();
                ijk = 1;
                while (ijk <= degree) {
                    JgclComplex ecPT = result[klm].mul(ecP0);
                    ecP0 = ecPT.add(edcA[ijk]);
                    edelta = eZA * edelta + JgclMachineEpsilon.DOUBLE * (ecPT.abs() + JgclMath.maxOf3(eCA[ijk], ecPT.abs(), ecP0.abs()));
                    if (ijk != degree) {
                        ecP1 = result[klm].mul(ecP1).add(ecP0);
                    }
                    ++ijk;
                }
                JgclComplex ecQA = new JgclComplex(0.0, 0.0);
                ijk = 0;
                while (ijk < degree) {
                    if (ijk != klm) {
                        ecQA = ecQA.add(ec1.div(result[klm].sub(result[ijk])));
                    }
                    ++ijk;
                }
                JgclComplex ecQB = ecP0.div(ecP1);
                ecZN[klm] = result[klm].sub(ecQB.div(ec1.sub(ecQB.mul(ecQA))));
                if (ecP0.abs() < edelta) {
                    ++inconv;
                }
                ++klm;
            }
            if (iter > 5) {
                double ec2CT = 0.0;
                ijk = 0;
                while (ijk < degree) {
                    ec2CT += ecZN[ijk].sub(result[ijk]).abs();
                    ++ijk;
                }
                if (ec2CT < secondEps) {
                    inconv = degree;
                }
            }
            ijk = 0;
            while (ijk < degree) {
                result[ijk] = ecZN[ijk];
                ++ijk;
            }
            if (inconv == degree) break;
            ++iter;
        }
        return iter != maxIteration;
    }

    private static void debugGetRootsIfQuadric(String[] argv) {
        JgclComplex[] coef = new JgclComplex[argv.length - 2];
        int i = 0;
        while (i < argv.length - 2) {
            coef[i] = new JgclComplex(Double.valueOf(argv[i]), 0.0);
            ++i;
        }
        try {
            JgclComplexPolynomial poly = new JgclComplexPolynomial(coef);
            JgclComplex[] result = poly.getRootsIfQuadric();
            int i2 = 0;
            while (i2 < result.length) {
                System.out.println("result : " + result[i2] + ", evaluate : " + poly.evaluate(result[i2]));
                ++i2;
            }
        }
        catch (JgclInvalidArgumentValue e) {
            System.err.println(e);
        }
    }

    private static void debugGetOneRootByNR(String[] argv) {
        JgclComplex[] coef = new JgclComplex[argv.length - 2];
        int i = 0;
        while (i < argv.length - 2) {
            coef[i] = new JgclComplex(Double.valueOf(argv[i]), 0.0);
            ++i;
        }
        try {
            JgclComplexPolynomial poly = new JgclComplexPolynomial(coef);
            JgclComplex result = poly.getOneRootByNR(new JgclComplex(Double.valueOf(argv[argv.length - 2]), Double.valueOf(argv[argv.length - 1])));
            System.out.println("result : " + result + ", evaluate : " + poly.evaluate(result));
        }
        catch (JgclInvalidArgumentValue e) {
            System.err.println(e);
        }
        catch (NRNotConverge e) {
            System.err.println(e);
        }
    }

    private static void debugGetRootsByDKA(String[] argv) {
        JgclComplex[] coef = new JgclComplex[argv.length - 2];
        int i = 0;
        while (i < argv.length - 2) {
            coef[i] = new JgclComplex(Double.valueOf(argv[i]), 0.0);
            ++i;
        }
        try {
            JgclComplexPolynomial poly = new JgclComplexPolynomial(coef);
            JgclComplex[] result = poly.getRootsByDKA();
            int i2 = 0;
            while (i2 < result.length) {
                System.out.println("result : " + result[i2] + ", evaluate : " + poly.evaluate(result[i2]));
                ++i2;
            }
        }
        catch (JgclInvalidArgumentValue e) {
            System.err.println(e);
        }
        catch (DKANotConverge e) {
            System.err.println(e);
        }
        catch (IndefiniteEquation e) {
            System.err.println(e);
        }
        catch (ImpossibleEquation e) {
            System.err.println(e);
        }
    }

    public static void main(String[] argv) {
        System.err.println("---");
        JgclComplexPolynomial.debugGetOneRootByNR(argv);
        System.err.println("---");
        JgclComplexPolynomial.debugGetRootsByDKA(argv);
    }

    public class NRNotConverge
    extends JgclException {
        private JgclComplex value;

        private NRNotConverge(JgclComplex value) {
            JgclComplexPolynomial.this = JgclComplexPolynomial.this;
            this.value = value;
        }

        public JgclComplex getValue() {
            return this.value;
        }
    }

    public class IndefiniteEquation
    extends JgclException {
        public IndefiniteEquation() {
            JgclComplexPolynomial.this = JgclComplexPolynomial.this;
        }

        public IndefiniteEquation(String s) {
            super(s);
            JgclComplexPolynomial.this = JgclComplexPolynomial.this;
        }
    }

    public class ImpossibleEquation
    extends JgclException {
        public ImpossibleEquation() {
            JgclComplexPolynomial.this = JgclComplexPolynomial.this;
        }

        public ImpossibleEquation(String s) {
            super(s);
            JgclComplexPolynomial.this = JgclComplexPolynomial.this;
        }
    }

    public class DKANotConverge
    extends JgclException {
        private JgclComplex[] values;

        private DKANotConverge(JgclComplex[] values) {
            JgclComplexPolynomial.this = JgclComplexPolynomial.this;
            this.values = values;
        }

        public JgclComplex[] getValues() {
            return this.values;
        }
    }
}

