/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;

class JgclBsplineCurveEvaluation {
    static boolean debug;

    private JgclBsplineCurveEvaluation() {
    }

    static int getDimension(double[][] controlPoints) {
        int i = 0;
        while (i < controlPoints.length) {
            if (controlPoints[i] != null) {
                return controlPoints[i].length;
            }
            ++i;
        }
        throw new JgclFatal();
    }

    static double[] coordinates(JgclBsplineKnot knotData, double[][] controlPoints, double param) {
        double[] d0D = new double[JgclBsplineCurveEvaluation.getDimension(controlPoints)];
        JgclBsplineCurveEvaluation.evaluation(knotData, controlPoints, param, d0D, null, null, null);
        return d0D;
    }

    static void evaluation(JgclBsplineKnot knotData, double[][] controlPoints, double param, double[] d0D, double[] d1D, double[] d2D, double[] d3D) {
        block33: {
            double scale;
            int i;
            int j;
            int dimension = JgclBsplineCurveEvaluation.getDimension(controlPoints);
            int degree = knotData.degree();
            double[][] auxv1s = null;
            double[][] auxv2s = null;
            double[][] auxv3s = null;
            int isckt = knotData.segmentIndex(param);
            if (isckt < 0) {
                throw new JgclFatal();
            }
            double[][] auxpnts = new double[degree + 1][dimension];
            if (d1D != null || d2D != null) {
                auxv1s = new double[degree][dimension];
            }
            if (d2D != null && degree > 1) {
                auxv2s = new double[degree - 1][dimension];
            }
            if (d3D != null && degree > 2) {
                auxv3s = new double[degree - 2][dimension];
            }
            if (knotData.isNonPeriodic()) {
                j = degree;
                while (j >= 0) {
                    i = 0;
                    while (i < dimension) {
                        auxpnts[j][i] = controlPoints[isckt + j][i];
                        ++i;
                    }
                    --j;
                }
            } else {
                j = degree;
                while (j >= 0) {
                    int k = (isckt + j) % controlPoints.length;
                    i = 0;
                    while (i < dimension) {
                        auxpnts[j][i] = controlPoints[k][i];
                        ++i;
                    }
                    --j;
                }
            }
            j = degree - 1;
            while (j >= 0) {
                if (d1D != null || d2D != null) {
                    i = 0;
                    while (i < dimension) {
                        auxv1s[j][i] = auxpnts[j + 1][i] - auxpnts[j][i];
                        ++i;
                    }
                    double denom = knotData.knotValueAt(degree + isckt + j + 1) - knotData.knotValueAt(isckt + j + 1);
                    i = 0;
                    while (i < dimension) {
                        double[] dArray = auxv1s[j];
                        int n = i++;
                        dArray[n] = dArray[n] / denom;
                    }
                    if (d2D != null && degree > 1 && j < degree - 1) {
                        i = 0;
                        while (i < dimension) {
                            auxv2s[j][i] = auxv1s[j + 1][i] - auxv1s[j][i];
                            ++i;
                        }
                        denom = knotData.knotValueAt(degree + isckt + j + 1) - knotData.knotValueAt(isckt + j + 2);
                        i = 0;
                        while (i < dimension) {
                            double[] dArray = auxv2s[j];
                            int n = i++;
                            dArray[n] = dArray[n] / denom;
                        }
                        if (d3D != null && degree > 2 && j < degree - 2) {
                            i = 0;
                            while (i < dimension) {
                                auxv3s[j][i] = auxv2s[j + 1][i] - auxv2s[j][i];
                                ++i;
                            }
                            denom = knotData.knotValueAt(degree + isckt + j + 1) - knotData.knotValueAt(isckt + j + 3);
                            i = 0;
                            while (i < dimension) {
                                double[] dArray = auxv3s[j];
                                int n = i++;
                                dArray[n] = dArray[n] / denom;
                            }
                        }
                    }
                }
                --j;
            }
            if (d0D != null) {
                JgclBsplineCurveEvaluation.deboorProc(knotData, dimension, degree, isckt + degree, param, auxpnts);
                i = 0;
                while (i < dimension) {
                    d0D[i] = auxpnts[degree][i];
                    ++i;
                }
            }
            if (d1D != null) {
                JgclBsplineCurveEvaluation.deboorProc(knotData, dimension, degree - 1, isckt + degree, param, auxv1s);
                i = 0;
                while (i < dimension) {
                    d1D[i] = auxv1s[degree - 1][i] * (double)degree;
                    ++i;
                }
            }
            if (d2D != null) {
                if (degree > 1) {
                    JgclBsplineCurveEvaluation.deboorProc(knotData, dimension, degree - 2, isckt + degree, param, auxv2s);
                    scale = degree * (degree - 1);
                    i = 0;
                    while (i < dimension) {
                        d2D[i] = auxv2s[degree - 2][i] * scale;
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < dimension) {
                        d2D[i] = 0.0;
                        ++i;
                    }
                }
            }
            if (d3D == null) break block33;
            if (degree > 2) {
                JgclBsplineCurveEvaluation.deboorProc(knotData, dimension, degree - 3, isckt + degree, param, auxv3s);
                scale = degree * (degree - 1) * (degree - 2);
                i = 0;
                while (i < dimension) {
                    d3D[i] = auxv3s[degree - 3][i] * scale;
                    ++i;
                }
            } else {
                i = 0;
                while (i < dimension) {
                    d3D[i] = 0.0;
                    ++i;
                }
            }
        }
    }

    private static void deboorProc(JgclBsplineKnot knotData, int dimension, int degree, int sct, double param, double[][] avs) {
        int j = 1;
        while (j <= degree) {
            int k = degree;
            int i = sct;
            while (k >= j) {
                double kf = knotData.knotValueAt(i + degree - j + 1);
                double kb = knotData.knotValueAt(i);
                double t1 = (kf - param) / (kf - kb);
                double t2 = 1.0 - t1;
                int l = 0;
                while (l < dimension) {
                    avs[k][l] = t1 * avs[k - 1][l] + t2 * avs[k][l];
                    ++l;
                }
                --k;
                --i;
            }
            ++j;
        }
    }

    private static void blossomDeboorProc(JgclBsplineKnot knotData, int dimension, int degree, int sct, double[] param, double[][] avs) {
        int j = 1;
        while (j <= degree) {
            int k = degree;
            int i = sct;
            while (k >= j) {
                double kf = knotData.knotValueAt(i + degree - j + 1);
                double kb = knotData.knotValueAt(i);
                double t1 = (kf - param[j - 1]) / (kf - kb);
                double t2 = 1.0 - t1;
                int l = 0;
                while (l < dimension) {
                    avs[k][l] = t1 * avs[k - 1][l] + t2 * avs[k][l];
                    ++l;
                }
                --k;
                --i;
            }
            ++j;
        }
    }

    static double[] blossoming(JgclBsplineKnot knotData, double[][] controlPoints, int segNumber, double[] param) {
        int i;
        int k;
        int j;
        int dimension = JgclBsplineCurveEvaluation.getDimension(controlPoints);
        int degree = knotData.degree();
        double[][] auxpnts = new double[degree + 1][dimension];
        if (knotData.isNonPeriodic()) {
            j = degree;
            while (j >= 0) {
                k = segNumber + j;
                i = 0;
                while (i < dimension) {
                    auxpnts[j][i] = controlPoints[k][i];
                    ++i;
                }
                --j;
            }
        } else {
            j = degree;
            while (j >= 0) {
                k = (segNumber + j) % controlPoints.length;
                i = 0;
                while (i < dimension) {
                    auxpnts[j][i] = controlPoints[k][i];
                    ++i;
                }
                --j;
            }
        }
        JgclBsplineCurveEvaluation.blossomDeboorProc(knotData, dimension, degree, segNumber + degree, param, auxpnts);
        double[] result = new double[dimension];
        int i2 = 0;
        while (i2 < dimension) {
            result[i2] = auxpnts[degree][i2];
            ++i2;
        }
        return result;
    }

    static JgclBsplineKnot getNewKnotDataAtDegreeElevation(JgclBsplineKnot knotData) {
        JgclBsplineKnot newKnotData;
        int[] newKnotMultiplicities;
        double[] newKnots;
        int newNUniqueKnots;
        int oldNKnots = knotData.nKnotValues();
        JgclBsplineKnot.ValidSegmentInfo oldValidSegments = knotData.validSegments();
        int oldNValidSegments = oldValidSegments.nSegments();
        int newNControlPoints = knotData.nControlPoints() + oldNValidSegments;
        int n = newNUniqueKnots = knotData.knotSpec() == 0 ? 2 * oldNKnots - 2 * knotData.degree() : knotData.nKnots();
        if (knotData.knotSpec() == 0) {
            newKnots = new double[newNUniqueKnots];
            newKnotMultiplicities = new int[newNUniqueKnots];
            int lowerOfInternal = knotData.degree();
            int upperOfInternal = knotData.degree() + knotData.nSegments();
            int j = 0;
            int i = 0;
            while (i < oldNKnots) {
                newKnots[j] = knotData.knotValueAt(i);
                newKnotMultiplicities[j] = 1;
                ++j;
                if (lowerOfInternal <= i && i <= upperOfInternal) {
                    newKnots[j] = newKnots[j - 1];
                    newKnotMultiplicities[j] = 1;
                    ++j;
                }
                ++i;
            }
        } else {
            newKnots = knotData.knots();
            newKnotMultiplicities = knotData.knotMultiplicities();
            newNUniqueKnots = JgclBsplineKnot.beautify(newNUniqueKnots, newKnots, newKnotMultiplicities);
            double lowerKnotOfOldValidSegments = oldValidSegments.headKnotPoint(0);
            double upperKnotOfOldValidSegments = oldValidSegments.tailKnotPoint(oldNValidSegments - 1);
            int i = 0;
            while (i < newNUniqueKnots) {
                if (!(lowerKnotOfOldValidSegments > newKnots[i]) && !(newKnots[i] > upperKnotOfOldValidSegments)) {
                    int n2 = i;
                    newKnotMultiplicities[n2] = newKnotMultiplicities[n2] + 1;
                }
                ++i;
            }
        }
        if (knotData.isNonPeriodic()) {
            newNUniqueKnots = JgclBsplineKnot.beautify(newNUniqueKnots, newKnots, newKnotMultiplicities);
            newKnotData = new JgclBsplineKnot(knotData.degree() + 1, 1, knotData.isPeriodic(), newNUniqueKnots, newKnotMultiplicities, newKnots, newNControlPoints);
        } else {
            newKnotData = new JgclBsplineKnot(knotData.degree() + 1, 1, knotData.isPeriodic(), newNUniqueKnots, newKnotMultiplicities, newKnots, newNControlPoints, false);
            newKnotData = newKnotData.makeKnotsClosed();
        }
        return newKnotData;
    }

    private static int getTargetSegmentOfBlossomingAtDegreeElevation(double[] targetParams, int oldDegree, JgclBsplineKnot.ValidSegmentInfo oldValidSegments) {
        int targetSegment;
        int oldNValidSegments = oldValidSegments.nSegments();
        int lowerSegmentIndex = -1;
        int k = 0;
        while (k < oldNValidSegments) {
            if (!(targetParams[0] > oldValidSegments.tailKnotPoint(k))) {
                lowerSegmentIndex = k;
                break;
            }
            ++k;
        }
        int upperSegmentIndex = oldNValidSegments;
        int k2 = oldNValidSegments - 1;
        while (k2 >= 0) {
            if (!(oldValidSegments.headKnotPoint(k2) > targetParams[oldDegree])) {
                upperSegmentIndex = k2;
                break;
            }
            --k2;
        }
        if (lowerSegmentIndex == -1) {
            targetSegment = oldValidSegments.segmentNumber(upperSegmentIndex);
        } else if (upperSegmentIndex == oldNValidSegments) {
            targetSegment = oldValidSegments.segmentNumber(lowerSegmentIndex);
        } else if (targetParams[0] < oldValidSegments.headKnotPoint(lowerSegmentIndex)) {
            targetSegment = oldValidSegments.segmentNumber(lowerSegmentIndex);
        } else if (targetParams[oldDegree] > oldValidSegments.tailKnotPoint(upperSegmentIndex)) {
            targetSegment = oldValidSegments.segmentNumber(upperSegmentIndex);
        } else {
            int targetSegmentIndex = (lowerSegmentIndex + upperSegmentIndex) / 2;
            targetSegment = oldValidSegments.segmentNumber(targetSegmentIndex);
            if (targetSegmentIndex != oldNValidSegments - 1) {
                double diff1 = Math.abs(targetParams[0] - oldValidSegments.headKnotPoint(++targetSegmentIndex));
                double diff2 = Math.abs(targetParams[oldDegree] - oldValidSegments.tailKnotPoint(targetSegmentIndex));
                double pTol = JgclConditionOfOperation.getCondition().getToleranceForParameter();
                if (diff1 < pTol && diff2 < pTol) {
                    targetSegment = oldValidSegments.segmentNumber(targetSegmentIndex);
                }
            }
        }
        return targetSegment;
    }

    static double[][] getNewControlPointsAtDegreeElevation(JgclBsplineKnot oldKnotData, JgclBsplineKnot newKnotData, double[][] oldControlPoints) {
        JgclBsplineKnot.ValidSegmentInfo oldValidSegments = oldKnotData.validSegments();
        int oldNValidSegments = oldValidSegments.nSegments();
        int newNControlPoints = oldKnotData.nControlPoints() + oldNValidSegments;
        double[] targetParams = new double[oldKnotData.degree() + 1];
        double[] blossomParams = new double[oldKnotData.degree()];
        int dimension = oldControlPoints[0].length;
        double[][] newControlPoints = new double[newNControlPoints][dimension];
        int i = 0;
        while (i < newNControlPoints) {
            int k = 0;
            int l = i + 1;
            while (k < newKnotData.degree()) {
                targetParams[k] = newKnotData.knotValueAt(l);
                ++k;
                ++l;
            }
            int targetSegment = JgclBsplineCurveEvaluation.getTargetSegmentOfBlossomingAtDegreeElevation(targetParams, oldKnotData.degree(), oldValidSegments);
            k = 0;
            while (k < dimension) {
                newControlPoints[i][k] = 0.0;
                ++k;
            }
            int j = 0;
            while (j < newKnotData.degree()) {
                k = 0;
                l = 0;
                while (k < oldKnotData.degree()) {
                    if (k == j) {
                        ++l;
                    }
                    blossomParams[k] = targetParams[l];
                    ++k;
                    ++l;
                }
                double[] blossomPoint = JgclBsplineCurveEvaluation.blossoming(oldKnotData, oldControlPoints, targetSegment, blossomParams);
                k = 0;
                while (k < dimension) {
                    double[] dArray = newControlPoints[i];
                    int n = k;
                    dArray[n] = dArray[n] + blossomPoint[k] / (double)newKnotData.degree();
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return newControlPoints;
    }

    /*
     * Unable to fully structure code
     */
    static double[][][] toBezierCurve(JgclBsplineKnot knotData, double[][] controlPoints) {
        dimension = JgclBsplineCurveEvaluation.getDimension(controlPoints);
        p_tol = JgclConditionOfOperation.getCondition().getToleranceForParameter();
        knotData0 = knotData.beautify().makeExplicit();
        degree = knotData.degree();
        knots = knotData0.knots();
        knot_multi = knotData0.knotMultiplicities();
        uicp = knotData.nControlPoints();
        if (knotData.isPeriodic()) {
            uicp += degree;
        }
        knotData0 = new JgclBsplineKnot(degree, 1, false, knot_multi, knots, uicp);
        uik = knotData0.nKnots();
        cntrl_pnts = new double[uik * (degree + 1)][dimension];
        uicp = knotData.nControlPoints();
        i = 0;
        while (i < uicp) {
            j = 0;
            while (j < dimension) {
                cntrl_pnts[i][j] = controlPoints[i][j];
                ++j;
            }
            ++i;
        }
        if (knotData.isPeriodic()) {
            uicp += degree;
            j = 0;
            while (j < degree) {
                k = 0;
                while (k < dimension) {
                    cntrl_pnts[i][k] = controlPoints[j][k];
                    ++k;
                }
                ++j;
                ++i;
            }
        }
        d_num = JgclBsplineCurveEvaluation.sum_internal_multi(knotData0);
        n_seg = knotData0.nSegments();
        skn = knotData0.knotValueAt(degree);
        ekn = knotData0.knotValueAt(degree + n_seg);
        i = 0;
        while (i < uik) {
            block12: {
                if (!(knots[i] < skn) && !(ekn < knots[i])) ** GOTO lbl47
                break block12;
lbl-1000:
                // 1 sources

                {
                    uicp = JgclBsplineCurveEvaluation.exch_bsc(knotData0, cntrl_pnts, dimension, knots[i]);
                    v0 = i;
                    knot_multi[v0] = knot_multi[v0] + 1;
                    knotData0 = new JgclBsplineKnot(degree, 1, false, knot_multi, knots, uicp);
lbl47:
                    // 2 sources

                    ** while (knot_multi[i] < degree)
                }
            }
            ++i;
        }
        s = 0;
        while (knotData0.knotValueAt(s + degree + 1) < skn + p_tol) {
            ++s;
        }
        num = n_seg - d_num;
        bzc = new double[num][degree + 1][dimension];
        i = 0;
        while (i < num) {
            j = 0;
            while (j <= degree) {
                k = s + i * degree + j;
                l = 0;
                while (l < dimension) {
                    bzc[i][j][l] = cntrl_pnts[k][l];
                    ++l;
                }
                ++j;
            }
            ++i;
        }
        return bzc;
    }

    private static int sum_internal_multi(JgclBsplineKnot knotData) {
        int d_num = 0;
        int k = 0;
        int j = 0;
        int s_knot_no = knotData.degree() + 1;
        int e_knot_no = knotData.degree() + knotData.nSegments() + 1;
        int i = 0;
        while (i < knotData.nKnots()) {
            if ((j += knotData.knotMultiplicityAt(i)) >= s_knot_no && e_knot_no > k) {
                d_num = k < s_knot_no && s_knot_no <= j ? (d_num += knotData.knotMultiplicityAt(i) - (s_knot_no - 1 - k) - 1) : (k < e_knot_no && e_knot_no <= j ? (d_num += knotData.knotMultiplicityAt(i) - (j - e_knot_no) - 1) : (d_num += knotData.knotMultiplicityAt(i) - 1));
            }
            k = j;
            ++i;
        }
        return d_num;
    }

    private static int exch_bsc(JgclBsplineKnot knotData, double[][] cntrl_pnts, int dimension, double para) {
        int k;
        int uicp = knotData.nControlPoints();
        int degree = knotData.degree();
        int i = knotData.segmentIndex(para);
        double[] p0 = new double[dimension];
        double[] p1 = new double[dimension];
        int j = i + 1;
        while (j <= i + degree) {
            double alp = (para - knotData.knotValueAt(j)) / (knotData.knotValueAt(j + degree) - knotData.knotValueAt(j));
            k = 0;
            while (k < dimension) {
                p1[k] = (1.0 - alp) * cntrl_pnts[j - 1][k] + alp * cntrl_pnts[j][k];
                ++k;
            }
            if (j > i + 1) {
                k = 0;
                while (k < dimension) {
                    cntrl_pnts[j - 1][k] = p0[k];
                    ++k;
                }
            }
            k = 0;
            while (k < dimension) {
                p0[k] = p1[k];
                ++k;
            }
            ++j;
        }
        j = i + degree;
        while (j < uicp) {
            k = 0;
            while (k < dimension) {
                p1[k] = cntrl_pnts[j][k];
                cntrl_pnts[j][k] = p0[k];
                p0[k] = p1[k];
                ++k;
            }
            ++j;
        }
        k = 0;
        while (k < dimension) {
            cntrl_pnts[uicp][k] = p0[k];
            ++k;
        }
        return uicp + 1;
    }

    /*
     * Unable to fully structure code
     */
    static double[][][][][] toBezierSurface(JgclBsplineKnot uKnotData, JgclBsplineKnot vKnotData, double[][][] controlPoints) {
        dimension = controlPoints[0][0].length;
        p_tol = JgclConditionOfOperation.getCondition().getToleranceForParameter();
        uKnotData0 = uKnotData.beautify().makeExplicit();
        uDegree = uKnotData.degree();
        uKnots = uKnotData0.knots();
        uKnotMulti = uKnotData0.knotMultiplicities();
        uUicp = uKnotData.nControlPoints();
        if (uKnotData.isPeriodic()) {
            uUicp += uDegree;
        }
        uKnotData0 = new JgclBsplineKnot(uDegree, 1, false, uKnotMulti, uKnots, uUicp);
        vKnotData0 = vKnotData.beautify().makeExplicit();
        vDegree = vKnotData.degree();
        vKnots = vKnotData0.knots();
        vKnotMulti = vKnotData0.knotMultiplicities();
        vUicp = vKnotData.nControlPoints();
        if (vKnotData.isPeriodic()) {
            vUicp += vDegree;
        }
        vKnotData0 = new JgclBsplineKnot(vDegree, 1, false, vKnotMulti, vKnots, vUicp);
        uicp0 = (uKnotData.nControlPoints() + uKnotData.degree()) * (uKnotData.degree() + 1);
        uicp1 = (vKnotData.nControlPoints() + vKnotData.degree()) * (vKnotData.degree() + 1);
        cntrl_pnts = new double[uicp0][uicp1][dimension];
        uj = 0;
        while (uj < uKnotData.nControlPoints()) {
            vj = 0;
            while (vj < vKnotData.nControlPoints()) {
                j = 0;
                while (j < dimension) {
                    cntrl_pnts[uj][vj][j] = controlPoints[uj][vj][j];
                    ++j;
                }
                ++vj;
            }
            if (vKnotData.isPeriodic()) {
                vk = 0;
                while (vk < vKnotData.degree()) {
                    j = 0;
                    while (j < dimension) {
                        cntrl_pnts[uj][vj][j] = controlPoints[uj][vk][j];
                        ++j;
                    }
                    ++vk;
                    ++vj;
                }
            }
            ++uj;
        }
        if (uKnotData.isPeriodic()) {
            uk = 0;
            while (uk < uKnotData.degree()) {
                vj = 0;
                while (vj < vKnotData.nControlPoints()) {
                    j = 0;
                    while (j < dimension) {
                        cntrl_pnts[uj][vj][j] = controlPoints[uk][vj][j];
                        ++j;
                    }
                    ++vj;
                }
                if (vKnotData.isPeriodic()) {
                    vk = 0;
                    while (vk < vKnotData.degree()) {
                        j = 0;
                        while (j < dimension) {
                            cntrl_pnts[uj][vj][j] = controlPoints[uk][vk][j];
                            ++j;
                        }
                        ++vk;
                        ++vj;
                    }
                }
                ++uk;
                ++uj;
            }
        }
        u_dno = JgclBsplineCurveEvaluation.sum_internal_multi(uKnotData0);
        un_seg = uKnotData0.nSegments();
        u_skn = uKnotData0.knotValueAt(uDegree);
        u_ekn = uKnotData0.knotValueAt(uDegree + un_seg);
        u_uik = uKnotData0.nKnots();
        ui = 0;
        while (ui < u_uik) {
            block25: {
                if (!(uKnots[ui] < u_skn) && !(u_ekn < uKnots[ui])) ** GOTO lbl85
                break block25;
lbl-1000:
                // 1 sources

                {
                    uUicp = JgclBsplineCurveEvaluation.exch_bss_u(uKnotData0, vKnotData0, cntrl_pnts, dimension, uKnots[ui]);
                    v0 = ui;
                    uKnotMulti[v0] = uKnotMulti[v0] + 1;
                    uKnotData0 = new JgclBsplineKnot(uDegree, 1, false, uKnotMulti, uKnots, uUicp);
lbl85:
                    // 2 sources

                    ** while (uKnotMulti[ui] < uDegree)
                }
            }
            ++ui;
        }
        v_dno = JgclBsplineCurveEvaluation.sum_internal_multi(vKnotData0);
        vn_seg = vKnotData0.nSegments();
        v_skn = vKnotData0.knotValueAt(vDegree);
        v_ekn = vKnotData0.knotValueAt(vDegree + vn_seg);
        v_uik = vKnotData0.nKnots();
        vi = 0;
        while (vi < v_uik) {
            block26: {
                if (!(vKnots[vi] < v_skn) && !(v_ekn < vKnots[vi])) ** GOTO lbl102
                break block26;
lbl-1000:
                // 1 sources

                {
                    vUicp = JgclBsplineCurveEvaluation.exch_bss_v(uKnotData0, vKnotData0, cntrl_pnts, dimension, vKnots[vi]);
                    v1 = vi;
                    vKnotMulti[v1] = vKnotMulti[v1] + 1;
                    vKnotData0 = new JgclBsplineKnot(vDegree, 1, false, vKnotMulti, vKnots, vUicp);
lbl102:
                    // 2 sources

                    ** while (vKnotMulti[vi] < vDegree)
                }
            }
            ++vi;
        }
        us = 0;
        while (uKnotData0.knotValueAt(us + uDegree + 1) < u_skn + p_tol) {
            ++us;
        }
        u_no = un_seg - u_dno;
        vs = 0;
        while (vKnotData0.knotValueAt(vs + vDegree + 1) < v_skn + p_tol) {
            ++vs;
        }
        v_no = vn_seg - v_dno;
        bzs = new double[u_no][v_no][uDegree + 1][vDegree + 1][dimension];
        ui = 0;
        while (ui < u_no) {
            vi = 0;
            while (vi < v_no) {
                uj = 0;
                while (uj <= uDegree) {
                    vj = 0;
                    while (vj <= vDegree) {
                        bzs[ui][vi][uj][vj] = cntrl_pnts[us + ui * uDegree + uj][vs + vi * vDegree + vj];
                        ++vj;
                    }
                    ++uj;
                }
                ++vi;
            }
            ++ui;
        }
        return bzs;
    }

    private static int exch_bss_u(JgclBsplineKnot uKnotData, JgclBsplineKnot vKnotData, double[][][] cntrl_pnts, int dimension, double para) {
        int uUicp = uKnotData.nControlPoints();
        int vUicp = vKnotData.nControlPoints();
        int uDegree = uKnotData.degree();
        int i = uKnotData.segmentIndex(para);
        double[] p0 = new double[dimension];
        double[] p1 = new double[dimension];
        int vj = 0;
        while (vj < vUicp) {
            int k;
            int uj = i + 1;
            while (uj <= i + uDegree) {
                double alp = (para - uKnotData.knotValueAt(uj)) / (uKnotData.knotValueAt(uj + uDegree) - uKnotData.knotValueAt(uj));
                k = 0;
                while (k < dimension) {
                    p1[k] = (1.0 - alp) * cntrl_pnts[uj - 1][vj][k] + alp * cntrl_pnts[uj][vj][k];
                    ++k;
                }
                if (uj > i + 1) {
                    k = 0;
                    while (k < dimension) {
                        cntrl_pnts[uj - 1][vj][k] = p0[k];
                        ++k;
                    }
                }
                k = 0;
                while (k < dimension) {
                    p0[k] = p1[k];
                    ++k;
                }
                ++uj;
            }
            uj = i + uDegree;
            while (uj < uUicp) {
                k = 0;
                while (k < dimension) {
                    p1[k] = cntrl_pnts[uj][vj][k];
                    cntrl_pnts[uj][vj][k] = p0[k];
                    p0[k] = p1[k];
                    ++k;
                }
                ++uj;
            }
            k = 0;
            while (k < dimension) {
                cntrl_pnts[uUicp][vj][k] = p0[k];
                ++k;
            }
            ++vj;
        }
        return uUicp + 1;
    }

    private static int exch_bss_v(JgclBsplineKnot uKnotData, JgclBsplineKnot vKnotData, double[][][] cntrl_pnts, int dimension, double para) {
        int uUicp = uKnotData.nControlPoints();
        int vUicp = vKnotData.nControlPoints();
        int vDegree = vKnotData.degree();
        int i = vKnotData.segmentIndex(para);
        double[] p0 = new double[dimension];
        double[] p1 = new double[dimension];
        int uj = 0;
        while (uj < uUicp) {
            int k;
            int vj = i + 1;
            while (vj <= i + vDegree) {
                double alp = (para - vKnotData.knotValueAt(vj)) / (vKnotData.knotValueAt(vj + vDegree) - vKnotData.knotValueAt(vj));
                k = 0;
                while (k < dimension) {
                    p1[k] = (1.0 - alp) * cntrl_pnts[uj][vj - 1][k] + alp * cntrl_pnts[uj][vj][k];
                    ++k;
                }
                if (vj > i + 1) {
                    k = 0;
                    while (k < dimension) {
                        cntrl_pnts[uj][vj - 1][k] = p0[k];
                        ++k;
                    }
                }
                k = 0;
                while (k < dimension) {
                    p0[k] = p1[k];
                    ++k;
                }
                ++vj;
            }
            vj = i + vDegree;
            while (vj < vUicp) {
                k = 0;
                while (k < dimension) {
                    p1[k] = cntrl_pnts[uj][vj][k];
                    cntrl_pnts[uj][vj][k] = p0[k];
                    p0[k] = p1[k];
                    ++k;
                }
                ++vj;
            }
            k = 0;
            while (k < dimension) {
                cntrl_pnts[uj][vUicp][k] = p0[k];
                ++k;
            }
            ++uj;
        }
        return vUicp + 1;
    }

    static void divide(JgclBsplineKnot knotData, double[][] controlPoints, double para, JgclBsplineKnot[] newKnotData, double[][][] newControlPoints) {
        int dimension = controlPoints[0].length;
        int degree = knotData.degree();
        int ins_seg = knotData.segmentIndex(para);
        int[] nk_info = new int[2];
        double p_tol = JgclConditionOfOperation.getCondition().getToleranceForParameter();
        int[] new_n = JgclBsplineCurveEvaluation.get_new_ui_c(knotData, degree);
        int new_uicp = new_n[0];
        int new_uik = new_n[1];
        if (knotData.isPeriodic()) {
            new_uicp += degree;
        }
        double[] new_knots = new double[new_uik];
        int[] new_knot_multi = new int[new_uik];
        double[][] new_cntrl_pnts = new double[new_uicp][dimension];
        --new_uik;
        new_uik = JgclBsplineCurveEvaluation.fill_new_knot(knotData, para, new_uik, new_knots, new_knot_multi, nk_info, p_tol);
        if (debug) {
            System.out.println("new_uik : " + new_uik);
            System.out.println("new_uicp : " + new_uicp);
            System.out.println("nk_info : [" + nk_info[0] + "],[" + nk_info[1] + "]");
            int i = 0;
            while (i < new_uik) {
                System.out.println("new_knots[" + i + "] : " + new_knots[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < new_uik) {
                System.out.println("new_knot_multi[" + i2 + "] : " + new_knot_multi[i2]);
                ++i2;
            }
        }
        if (knotData.isNonPeriodic()) {
            int l;
            int n_ins = degree - nk_info[1];
            if (n_ins < 0) {
                n_ins = 0;
            } else if (nk_info[1] != 0) {
                new_uicp -= nk_info[1];
            }
            int j = 0;
            int k = ins_seg + degree + 1;
            while (j < k) {
                l = 0;
                while (l < dimension) {
                    new_cntrl_pnts[j][l] = controlPoints[j][l];
                    ++l;
                }
                ++j;
            }
            j = ins_seg + degree + 1;
            k = ins_seg + degree + n_ins;
            while (j < k) {
                l = 0;
                while (l < dimension) {
                    new_cntrl_pnts[j][l] = controlPoints[ins_seg + degree][l];
                    ++l;
                }
                ++j;
            }
            j = ins_seg + degree + n_ins;
            k = new_uicp;
            while (j < k) {
                l = 0;
                while (l < dimension) {
                    new_cntrl_pnts[j][l] = controlPoints[j - n_ins][l];
                    ++l;
                }
                ++j;
            }
            JgclBsplineKnot kdn = knotData;
            while (n_ins > 0) {
                j = ins_seg + degree;
                while (j >= ins_seg + 1) {
                    double[] t = JgclBsplineCurveEvaluation.comp_iratio(kdn, j, para, p_tol);
                    JgclBsplineCurveEvaluation.comp_r2p(dimension, new_cntrl_pnts, j, t[0], new_cntrl_pnts, j - 1, t[1], new_cntrl_pnts, j);
                    --j;
                }
                int n = nk_info[0];
                new_knot_multi[n] = new_knot_multi[n] + 1;
                kdn = JgclBsplineCurveEvaluation.make_open_knot(degree, new_knot_multi, new_knots, new_uik, -1);
                ++ins_seg;
                --n_ins;
            }
            int front_uik = nk_info[0] + 1;
            int front_uicp = JgclBsplineCurveEvaluation.get_front_uicp(nk_info, new_knot_multi);
            newControlPoints[0] = new double[front_uicp][dimension];
            double[] knots = new double[front_uik];
            int[] knot_multi = new int[front_uik];
            JgclBsplineCurveEvaluation.copy_front_kinfo(knots, knot_multi, new_knots, new_knot_multi, front_uik, degree);
            newKnotData[0] = JgclBsplineCurveEvaluation.make_open_knot(degree, knot_multi, knots, front_uik, front_uicp);
            j = 0;
            while (j < front_uicp) {
                l = 0;
                while (l < dimension) {
                    newControlPoints[0][j][l] = new_cntrl_pnts[j][l];
                    ++l;
                }
                ++j;
            }
            int rear_uik = new_uik - nk_info[0];
            int rear_uicp = JgclBsplineCurveEvaluation.get_rear_uicp(nk_info, new_knot_multi, new_uik);
            newControlPoints[1] = new double[rear_uicp][dimension];
            knots = new double[rear_uik];
            knot_multi = new int[rear_uik];
            JgclBsplineCurveEvaluation.copy_rear_kinfo(knots, knot_multi, new_knots, new_knot_multi, front_uik, rear_uik, degree);
            newKnotData[1] = JgclBsplineCurveEvaluation.make_open_knot(degree, knot_multi, knots, rear_uik, rear_uicp);
            j = 0;
            k = front_uicp - 1;
            while (j < rear_uicp) {
                l = 0;
                while (l < dimension) {
                    newControlPoints[1][j][l] = new_cntrl_pnts[k + j][l];
                    ++l;
                }
                ++j;
            }
        } else {
            int n_kel;
            int l;
            int k_0;
            int uicp = knotData.nControlPoints();
            int n_ins = degree - nk_info[1];
            if (n_ins < 0) {
                n_ins = 0;
            } else if (nk_info[1] != 0) {
                new_uicp -= nk_info[1];
            }
            int j = 0;
            int k = ins_seg + degree + 1;
            while (j < k) {
                k_0 = j % uicp;
                l = 0;
                while (l < dimension) {
                    new_cntrl_pnts[j][l] = controlPoints[k_0][l];
                    ++l;
                }
                ++j;
            }
            j = ins_seg + degree + 1;
            k = ins_seg + degree + n_ins;
            while (j < k) {
                k_0 = (ins_seg + degree) % uicp;
                l = 0;
                while (l < dimension) {
                    new_cntrl_pnts[j][l] = controlPoints[k_0][l];
                    ++l;
                }
                ++j;
            }
            j = ins_seg + degree + n_ins;
            k = new_uicp;
            while (j < k) {
                k_0 = (j - n_ins) % uicp;
                l = 0;
                while (l < dimension) {
                    new_cntrl_pnts[j][l] = controlPoints[k_0][l];
                    ++l;
                }
                ++j;
            }
            JgclBsplineKnot kdn = knotData;
            while (n_ins > 0) {
                j = ins_seg + degree;
                while (j >= ins_seg + 1) {
                    double[] t = JgclBsplineCurveEvaluation.comp_iratio(kdn, j, para, p_tol);
                    JgclBsplineCurveEvaluation.comp_r2p(dimension, new_cntrl_pnts, j, t[0], new_cntrl_pnts, j - 1, t[1], new_cntrl_pnts, j);
                    if (j < degree) {
                        l = 0;
                        while (l < dimension) {
                            new_cntrl_pnts[new_uicp - degree + j][l] = new_cntrl_pnts[j][l];
                            ++l;
                        }
                    } else if (j > new_uicp - degree - 1) {
                        l = 0;
                        while (l < dimension) {
                            new_cntrl_pnts[j - (new_uicp - degree)][l] = new_cntrl_pnts[j][l];
                            ++l;
                        }
                    }
                    --j;
                }
                nk_info[0] = JgclBsplineCurveEvaluation.get_knot_idx(new_uik, new_knots, para, p_tol);
                int n = nk_info[0];
                new_knot_multi[n] = new_knot_multi[n] + 1;
                kdn = JgclBsplineCurveEvaluation.make_open_knot(degree, new_knot_multi, new_knots, new_uik, -1);
                n_kel = kdn.nKnotValues();
                kdn = JgclBsplineCurveEvaluation.treat_closed_bsp(kdn, n_kel, para, p_tol);
                new_knot_multi = kdn.knotMultiplicities();
                new_knots = kdn.knots();
                new_uik = kdn.nKnots();
                ++ins_seg;
                --n_ins;
            }
            kdn = JgclBsplineCurveEvaluation.make_open_knot(degree, new_knot_multi, new_knots, new_uik, -1);
            int n_seg = kdn.nSegments();
            double lower_limit = kdn.knotValueAt(degree);
            double upper_limit = kdn.knotValueAt(degree + n_seg);
            int lower_idx = JgclBsplineCurveEvaluation.get_knot_idx(new_uik, new_knots, lower_limit, p_tol);
            int upper_idx = JgclBsplineCurveEvaluation.get_knot_idx(new_uik, new_knots, upper_limit, p_tol);
            int bsc1_uik = upper_idx - lower_idx + 1;
            n_kel = 0;
            j = lower_idx;
            while (j < upper_idx) {
                n_kel += new_knot_multi[j];
                ++j;
            }
            int bsc1_uicp = (n_kel += degree + 2) - degree - 1;
            if (Math.abs(upper_limit - para) < p_tol) {
                para = lower_limit;
            }
            nk_info[0] = JgclBsplineCurveEvaluation.get_knot_idx(new_uik, new_knots, para, p_tol);
            int iksct = kdn.segmentIndex(para);
            newControlPoints[0] = new double[bsc1_uicp][dimension];
            double[] knots = new double[bsc1_uik];
            int[] knot_multi = new int[bsc1_uik];
            knots[0] = 0.0;
            knot_multi[0] = new_knot_multi[nk_info[0]] + 1;
            j = 1;
            k = nk_info[0] + 1;
            while (j < bsc1_uik - 1) {
                knots[j] = knots[j - 1] + (new_knots[k] - new_knots[k - 1]);
                knot_multi[j] = new_knot_multi[k];
                if (k == upper_idx) {
                    k = lower_idx;
                }
                ++j;
                ++k;
            }
            knots[j] = knots[j - 1] + (new_knots[nk_info[0]] - new_knots[nk_info[0] - 1]);
            knot_multi[j] = new_knot_multi[nk_info[0]] + 1;
            newKnotData[0] = JgclBsplineCurveEvaluation.make_open_knot(degree, knot_multi, knots, bsc1_uik, bsc1_uicp);
            j = 0;
            k = iksct;
            while (j < bsc1_uicp) {
                l = 0;
                while (l < dimension) {
                    newControlPoints[0][j][l] = new_cntrl_pnts[k][l];
                    ++l;
                }
                if (k == new_uicp - 1) {
                    k = degree - 1;
                }
                ++j;
                ++k;
            }
            newControlPoints[1] = null;
            newKnotData[1] = null;
        }
    }

    static Object[] insertKnot(JgclBsplineKnot knotData, double[][] controlPoints, double para) {
        JgclBsplineKnot newKnotData;
        int dimension = controlPoints[0].length;
        int degree = knotData.degree();
        int i_seg = knotData.segmentIndex(para);
        int[] nk_info = new int[2];
        double p_tol = JgclConditionOfOperation.getCondition().getToleranceForParameter();
        Object[] result = new Object[2];
        int[] new_n = JgclBsplineCurveEvaluation.get_new_ui_c(knotData, 1);
        int new_uicp = new_n[0];
        int new_uik = new_n[1];
        double[] new_knots = new double[new_uik];
        int[] new_knot_multi = new int[new_uik];
        double[][] new_cntrl_pnts = new double[new_uicp][dimension];
        --new_uik;
        new_uik = JgclBsplineCurveEvaluation.fill_new_knot(knotData, para, new_uik, new_knots, new_knot_multi, nk_info, p_tol);
        int n = nk_info[0];
        new_knot_multi[n] = new_knot_multi[n] + 1;
        if (knotData.isNonPeriodic()) {
            int l;
            int j = 0;
            while (j <= i_seg) {
                l = 0;
                while (l < dimension) {
                    new_cntrl_pnts[j][l] = controlPoints[j][l];
                    ++l;
                }
                ++j;
            }
            j = i_seg + 1;
            while (j <= i_seg + degree) {
                double[] t = JgclBsplineCurveEvaluation.comp_iratio(knotData, j, para, p_tol);
                JgclBsplineCurveEvaluation.comp_r2p(dimension, new_cntrl_pnts, j, t[0], controlPoints, j - 1, t[1], controlPoints, j);
                ++j;
            }
            j = i_seg + degree + 1;
            while (j < new_uicp) {
                l = 0;
                while (l < dimension) {
                    new_cntrl_pnts[j][l] = controlPoints[j - 1][l];
                    ++l;
                }
                ++j;
            }
            newKnotData = JgclBsplineCurveEvaluation.make_open_knot(degree, new_knot_multi, new_knots, new_uik, new_uicp);
        } else {
            int k_1;
            int k_0;
            int l;
            int k;
            JgclBsplineKnot kdn = new JgclBsplineKnot(degree, 1, true, new_uik, new_knot_multi, new_knots, new_uicp, false);
            int n_kel = kdn.nKnotValues();
            kdn = JgclBsplineCurveEvaluation.treat_closed_bsp(kdn, n_kel, para, p_tol);
            int j = 0;
            while (j <= i_seg) {
                k = j % knotData.nControlPoints();
                l = 0;
                while (l < dimension) {
                    new_cntrl_pnts[k][l] = controlPoints[k][l];
                    ++l;
                }
                ++j;
            }
            j = i_seg + 1;
            while (j <= i_seg + degree) {
                k_0 = j % kdn.nControlPoints();
                k = j % knotData.nControlPoints();
                k_1 = (j - 1) % knotData.nControlPoints();
                double[] t = JgclBsplineCurveEvaluation.comp_iratio(knotData, j, para, p_tol);
                JgclBsplineCurveEvaluation.comp_r2p(dimension, new_cntrl_pnts, k_0, t[0], controlPoints, k_1, t[1], controlPoints, k);
                ++j;
            }
            j = i_seg + degree + 1;
            while (j < kdn.nControlPoints() + degree) {
                if (j < kdn.nControlPoints()) {
                    k_0 = j % kdn.nControlPoints();
                    k_1 = (j - 1) % knotData.nControlPoints();
                    l = 0;
                    while (l < dimension) {
                        new_cntrl_pnts[k_0][l] = controlPoints[k_1][l];
                        ++l;
                    }
                }
                ++j;
            }
            newKnotData = kdn;
        }
        result[0] = newKnotData;
        result[1] = new_cntrl_pnts;
        return result;
    }

    private static int[] get_new_ui_c(JgclBsplineKnot knotData, int n_ins) {
        int[] new_n = new int[]{knotData.nControlPoints() + n_ins, (knotData.knotSpec() == 1 ? knotData.nKnots() : knotData.nKnotValues()) + 1};
        return new_n;
    }

    private static int fill_new_knot(JgclBsplineKnot knotData, double para, int new_uik, double[] new_knots, int[] new_knot_multi, int[] nk_info, double p_tol) {
        int i;
        int[] om;
        double[] ok;
        if (knotData.knotSpec() == 1) {
            ok = knotData.knots();
            om = knotData.knotMultiplicities();
        } else {
            ok = new double[new_uik];
            om = new int[new_uik];
            i = 0;
            while (i < new_uik) {
                ok[i] = i - knotData.degree();
                om[i] = 1;
                ++i;
            }
        }
        int f = 0;
        nk_info[0] = -1;
        i = 0;
        while (i < new_uik) {
            if (Math.abs(ok[i] - para) < p_tol) {
                if (nk_info[0] < 0) {
                    if (i == new_uik - 1) {
                        new_knots[f] = para;
                        new_knot_multi[f] = 0;
                        nk_info[0] = f;
                        nk_info[1] = new_knot_multi[f];
                        ++f;
                    }
                    new_knots[f] = ok[i];
                    new_knot_multi[f] = om[i];
                    if (f == 0) {
                        new_knots[++f] = para;
                        new_knot_multi[f] = 0;
                    }
                    if (i != new_uik - 1) {
                        nk_info[0] = f;
                        nk_info[1] = new_knot_multi[f];
                    }
                    ++f;
                } else {
                    int n = nk_info[0];
                    int n2 = new_knot_multi[n] + om[i];
                    new_knot_multi[n] = n2;
                    nk_info[1] = n2;
                }
            } else if (i > 0 && ok[i - 1] + p_tol < para && para < ok[i] - p_tol) {
                new_knots[f] = para;
                new_knot_multi[f] = 0;
                nk_info[0] = f;
                nk_info[1] = new_knot_multi[f];
                new_knots[++f] = ok[i];
                new_knot_multi[f] = om[i];
                ++f;
            } else {
                new_knots[f] = ok[i];
                new_knot_multi[f] = om[i];
                ++f;
            }
            ++i;
        }
        if (nk_info[0] <= 0) {
            throw new JgclFatal();
        }
        return f;
    }

    private static double[] comp_iratio(JgclBsplineKnot knotData, int j, double param, double p_tol) {
        double kb;
        double[] t = new double[2];
        double kf = knotData.knotValueAt(j + knotData.degree());
        double kdiff = kf - (kb = knotData.knotValueAt(j));
        if (kdiff < p_tol) {
            t[0] = 0.5;
            t[1] = 0.5;
            return t;
        }
        t[0] = (kf - param) / kdiff;
        t[1] = 1.0 - t[0];
        return t;
    }

    private static void comp_r2p(int dimension, double[][] d, int di, double t1, double[][] s1, int s1i, double t2, double[][] s2, int s2i) {
        int i = 0;
        while (i < dimension) {
            d[di][i] = t1 * s1[s1i][i] + t2 * s2[s2i][i];
            ++i;
        }
    }

    private static void copy_kinfo(double[] d_knots, int[] d_knot_multi, double[] s_knots, int[] s_knot_multi, int n) {
        int i = 0;
        while (i < n) {
            d_knots[i] = s_knots[i];
            d_knot_multi[i] = s_knot_multi[i];
            ++i;
        }
    }

    private static int get_front_uicp(int[] nk_info, int[] knot_multi) {
        int uicp = 0;
        int j = nk_info[0] - 1;
        while (j >= 0) {
            uicp += knot_multi[j];
            --j;
        }
        return uicp;
    }

    private static int get_rear_uicp(int[] nk_info, int[] knot_multi, int uik) {
        int uicp = 0;
        int j = nk_info[0] + 1;
        while (j < uik) {
            uicp += knot_multi[j];
            ++j;
        }
        return uicp;
    }

    private static void copy_front_kinfo(double[] dk, int[] dkm, double[] sk, int[] skm, int uik, int deg) {
        int j = uik - 1;
        JgclBsplineCurveEvaluation.copy_kinfo(dk, dkm, sk, skm, j);
        dk[j] = sk[j];
        dkm[j] = deg + 1;
    }

    private static void copy_rear_kinfo(double[] dk, int[] dkm, double[] sk, int[] skm, int fuik, int uik, int deg) {
        int k = fuik - 1;
        double init_knot = sk[k];
        dk[0] = 0.0;
        dkm[0] = deg + 1;
        int j = 1;
        while (j < uik) {
            dk[j] = sk[k + j] - init_knot;
            dkm[j] = skm[k + j];
            ++j;
        }
    }

    private static int get_knot_idx(int uik, double[] knots, double para, double p_tol) {
        int i = 0;
        while (i < uik) {
            if (Math.abs(knots[i] - para) < p_tol) break;
            ++i;
        }
        return i;
    }

    private static JgclBsplineKnot make_open_knot(int degree, int[] knot_multi, double[] knots, int uik, int uicp) {
        if (uicp < 0) {
            uicp = 0;
            int i = 0;
            while (i < uik) {
                uicp += knot_multi[i];
                ++i;
            }
            uicp -= degree + 1;
        }
        return new JgclBsplineKnot(degree, 1, false, uik, knot_multi, knots, uicp);
    }

    private static JgclBsplineKnot treat_closed_bsp(JgclBsplineKnot knotData, int n_kel, double para, double p_tol) {
        int degree = knotData.degree();
        double[] simple_knots = new double[n_kel];
        int[] simple_knot_multi = new int[n_kel];
        int ick = -1;
        int i = 0;
        while (i < n_kel) {
            simple_knots[i] = knotData.knotValueAt(i);
            simple_knot_multi[i] = 1;
            if (ick < 0 && Math.abs(simple_knots[i] - para) < p_tol) {
                ick = i;
            }
            ++i;
        }
        int chck_intvl = 2 * degree;
        int chck_head_s = 1;
        int chck_head_e = 2 * degree;
        int chck_tail_s = n_kel - 2 * degree;
        int chck_tail_e = n_kel - 1;
        int refer = 0;
        if (chck_head_s <= ick && ick <= chck_head_e) {
            refer |= 1;
        }
        if (chck_tail_s <= ick && ick <= chck_tail_e) {
            refer |= 2;
        }
        if (refer == 0) {
            return knotData;
        }
        switch (refer) {
            case 1: {
                int j = chck_head_s + 1;
                int k = chck_tail_s + 1;
                i = 1;
                while (i < chck_intvl) {
                    simple_knots[k] = simple_knots[k - 1] + (simple_knots[j] - simple_knots[j - 1]);
                    ++j;
                    ++k;
                    ++i;
                }
                simple_knots[j -= chck_intvl + 1] = simple_knots[j + 1] - (simple_knots[(k -= chck_intvl + 1) + 1] - simple_knots[k]);
                break;
            }
            case 2: {
                int j = chck_head_e - 1;
                int k = chck_tail_e - 1;
                i = 1;
                while (i < chck_intvl) {
                    simple_knots[j] = simple_knots[j + 1] - (simple_knots[k + 1] - simple_knots[k]);
                    --j;
                    --k;
                    ++i;
                }
                simple_knots[j] = simple_knots[j + 1] - (simple_knots[k + 1] - simple_knots[k]);
                break;
            }
            case 3: {
                int j = chck_head_e - 1;
                int k = chck_tail_e - 1;
                simple_knots[k + 1] = simple_knots[k] + (simple_knots[j + 1] - simple_knots[j]);
                j = chck_head_s + 1;
                k = chck_tail_s + 1;
                simple_knots[j - 1] = simple_knots[j] - (simple_knots[k] - simple_knots[k - 1]);
                simple_knots[j - 2] = simple_knots[j - 1] - (simple_knots[k - 1] - simple_knots[k - 2]);
                break;
            }
        }
        try {
            int uicp = 0;
            i = 0;
            while (i < n_kel) {
                uicp += simple_knot_multi[i];
                ++i;
            }
            uicp = knotData.isPeriodic() ? (uicp -= 2 * degree + 1) : (uicp -= degree + 1);
            return new JgclBsplineKnot(degree, knotData.knotSpec(), knotData.isPeriodic(), n_kel, simple_knot_multi, simple_knots, uicp).beautify();
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }
}

