/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclBoundedCurve3D;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclCompositeCurve3D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment3D;
import jp.go.ipa.jgcl.JgclCurveCurvature3D;
import jp.go.ipa.jgcl.JgclCurveCurveInterference3D;
import jp.go.ipa.jgcl.JgclCurveDerivative3D;
import jp.go.ipa.jgcl.JgclElementarySurface3D;
import jp.go.ipa.jgcl.JgclEllipse3D;
import jp.go.ipa.jgcl.JgclEnclosingBox3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclGeometry;
import jp.go.ipa.jgcl.JgclHyperbola3D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclOverlapCurve3D;
import jp.go.ipa.jgcl.JgclParabola3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterOutOfRange;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve3D;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclBoundedLine3D
extends JgclBoundedCurve3D {
    private JgclPoint3D spnt;
    private JgclPoint3D epnt;

    private void setPoints(JgclPoint3D spnt, JgclPoint3D epnt, boolean doCheck) {
        if (doCheck && spnt.identical(epnt)) {
            throw new JgclInvalidArgumentValue();
        }
        this.spnt = spnt;
        this.epnt = epnt;
    }

    public JgclBoundedLine3D(JgclPoint3D spnt, JgclPoint3D epnt) {
        this.setPoints(spnt, epnt, true);
    }

    JgclBoundedLine3D(JgclPoint3D spnt, JgclPoint3D epnt, boolean doCheck) {
        this.setPoints(spnt, epnt, doCheck);
    }

    public JgclBoundedLine3D(JgclPoint3D spnt, JgclVector3D dir) {
        this.setPoints(spnt, spnt.add(dir), true);
    }

    JgclBoundedLine3D(JgclPoint3D spnt, JgclVector3D dir, boolean doCheck) {
        this.setPoints(spnt, spnt.add(dir), doCheck);
    }

    public JgclPoint3D spnt() {
        return this.spnt;
    }

    public JgclPoint3D epnt() {
        return this.epnt;
    }

    public double length(JgclParameterSection pint) {
        this.checkParameter(pint.start());
        this.checkParameter(pint.end());
        return this.length() * Math.abs(pint.increase());
    }

    public double length() {
        return this.spnt().distance(this.epnt());
    }

    public JgclPoint3D coordinates(double param) {
        param = this.checkParameter(param);
        return this.epnt().linearInterpolate(this.spnt(), param);
    }

    public JgclVector3D tangentVector(double param) {
        param = this.checkParameter(param);
        return this.epnt().subtract(this.spnt());
    }

    public JgclCurveCurvature3D curvature(double param) {
        param = this.checkParameter(param);
        return new JgclCurveCurvature3D(0.0, JgclVector3D.zeroVector);
    }

    public double torsion(double param) {
        param = this.checkParameter(param);
        return 0.0;
    }

    public JgclCurveDerivative3D evaluation(double param) {
        param = this.checkParameter(param);
        return new JgclCurveDerivative3D(this.coordinates(param), this.tangentVector(param), JgclVector3D.zeroVector, JgclVector3D.zeroVector);
    }

    public JgclPointOnCurve3D[] singular() {
        return new JgclPointOnCurve3D[0];
    }

    public JgclPointOnCurve3D[] inflexion() {
        return new JgclPointOnCurve3D[0];
    }

    public JgclPointOnCurve3D[] projectFrom(JgclPoint3D point) {
        JgclPointOnCurve3D poc = this.project1From(point);
        if (poc == null) {
            return new JgclPointOnCurve3D[0];
        }
        JgclPointOnCurve3D[] prjp = new JgclPointOnCurve3D[]{poc};
        return prjp;
    }

    public JgclPointOnCurve3D project1From(JgclPoint3D point) {
        JgclPointOnCurve3D poc = this.toLine().project1From(point);
        double param = poc.parameter();
        Object result = null;
        if (!this.isValid(param)) {
            return null;
        }
        return new JgclPointOnCurve3D(this, param, false);
    }

    public JgclPolyline3D toPolyline(JgclParameterSection pint, JgclToleranceForDistance tol) {
        JgclPoint3D[] points = new JgclPoint3D[]{new JgclPointOnCurve3D(this, pint.start(), false), new JgclPointOnCurve3D(this, pint.end(), false)};
        return new JgclPolyline3D(points);
    }

    JgclPolyline3D toPolyline() {
        JgclPoint3D[] points = new JgclPoint3D[]{this.spnt, this.epnt};
        return new JgclPolyline3D(points);
    }

    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection pint) {
        return this.toLine().toBsplineCurve(pint);
    }

    public JgclLine3D toLine() {
        return new JgclLine3D(this.spnt(), this.epnt());
    }

    public JgclVector3D unitizedDirection() {
        return this.tangentVector(0.0).unitized();
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclEllipse3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierSurface3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineSurface3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    private int haveIntsWithLine(JgclLine3D lin, JgclVector3D ludir) {
        double[] dists = new double[2];
        double d_tol = this.getToleranceForDistance();
        JgclVector3D dir = this.spnt.subtract(lin.pnt());
        dists[0] = dir.crossProduct(ludir).length();
        dir = this.epnt.subtract(lin.pnt());
        dists[1] = dir.crossProduct(ludir).length();
        if (Math.abs(dists[0]) < d_tol && Math.abs(dists[1]) < d_tol) {
            return -1;
        }
        if (Math.abs(dists[0] - dists[1]) < d_tol && (dir = this.epnt.subtract(this.spnt)).crossProduct(ludir).length() < d_tol) {
            return 0;
        }
        return 1;
    }

    private void isThisInBase(JgclBoundedLine3D bas, JgclVector3D BUdir, double BLeng, int[] is_in, double[] param) {
        double d_tol = this.getToleranceForDistance();
        int i = 0;
        while (i < 2) {
            JgclVector3D dir = i == 0 ? this.spnt().subtract(bas.spnt()) : this.epnt().subtract(bas.spnt());
            param[i] = BUdir.dotProduct(dir);
            if (param[i] < 0.0 - d_tol || param[i] > BLeng + d_tol) {
                is_in[i] = 0;
            } else {
                is_in[i] = 1;
                if (param[i] < 0.0 + d_tol) {
                    param[i] = 0.0;
                }
                if (param[i] > BLeng - d_tol) {
                    param[i] = BLeng;
                }
                int n = i;
                param[n] = param[n] / BLeng;
            }
            ++i;
        }
    }

    private JgclIntersectionPoint3D toIntersectionPoint(JgclBoundedCurve3D mate, double Aparam, double Bparam) {
        JgclPoint3D crd1 = this.coordinates(Aparam);
        JgclPoint3D crd2 = mate.coordinates(Bparam);
        JgclPointOnCurve3D poc1 = new JgclPointOnCurve3D(crd1, this, Aparam, false);
        JgclPointOnCurve3D poc2 = new JgclPointOnCurve3D(crd2, mate, Bparam, false);
        crd1 = crd1.linearInterpolate(crd2, 0.5);
        return new JgclIntersectionPoint3D(crd1, poc1, poc2, false);
    }

    private JgclCurveCurveInterference3D haveCommonSection(boolean needOverlap, JgclBoundedLine3D mate, JgclVector3D AUdir, JgclVector3D BUdir, double Aleng, double Bleng) throws JgclIndefiniteSolution {
        JgclGeometry intf;
        int[] A_inB = new int[2];
        int[] B_inA = new int[2];
        double[] pA_inA = new double[2];
        double[] pA_inB = new double[2];
        double[] pB_inA = new double[2];
        double[] pB_inB = new double[2];
        double[] Ap = new double[2];
        double[] Bp = new double[2];
        this.isThisInBase(mate, BUdir, Bleng, A_inB, pA_inB);
        mate.isThisInBase(this, AUdir, Aleng, B_inA, pB_inA);
        if (A_inB[0] + A_inB[1] + B_inA[0] + B_inA[1] < 2) {
            return null;
        }
        pA_inA[0] = 0.0;
        pA_inA[1] = 1.0;
        pB_inB[0] = 0.0;
        pB_inB[1] = 1.0;
        switch (A_inB[0] + A_inB[1] + B_inA[0] + B_inA[1]) {
            case 2: {
                int i = 0;
                if (A_inB[0] != 0) {
                    Ap[i] = pA_inA[0];
                    Bp[i] = pA_inB[0];
                    ++i;
                }
                if (A_inB[1] != 0) {
                    Ap[i] = pA_inA[1];
                    Bp[i] = pA_inB[1];
                    ++i;
                }
                if (B_inA[0] != 0) {
                    Ap[i] = pB_inA[0];
                    Bp[i] = pB_inB[0];
                    ++i;
                }
                if (B_inA[1] == 0) break;
                Ap[i] = pB_inA[1];
                Bp[i] = pB_inB[1];
                ++i;
                break;
            }
            case 3: {
                if (A_inB[0] != 0 && A_inB[1] != 0) {
                    Ap[0] = pA_inA[0];
                    Bp[0] = pA_inB[0];
                    Ap[1] = pA_inA[1];
                    Bp[1] = pA_inB[1];
                    break;
                }
                Ap[0] = pB_inA[0];
                Bp[0] = pB_inB[0];
                Ap[1] = pB_inA[1];
                Bp[1] = pB_inB[1];
                break;
            }
            case 4: {
                if (Aleng > Bleng) {
                    Ap[0] = pA_inA[0];
                    Bp[0] = pA_inB[0];
                    Ap[1] = pA_inA[1];
                    Bp[1] = pA_inB[1];
                    break;
                }
                Ap[0] = pB_inA[0];
                Bp[0] = pB_inB[0];
                Ap[1] = pB_inA[1];
                Bp[1] = pB_inB[1];
                break;
            }
        }
        double d_tol = this.getToleranceForDistance();
        boolean hasWidth = true;
        boolean throwIndefinite = false;
        if (Math.abs(Ap[0] - Ap[1]) * Aleng < d_tol || Math.abs(Bp[0] - Bp[1]) * Bleng < d_tol) {
            hasWidth = false;
        } else if (!needOverlap) {
            hasWidth = false;
            throwIndefinite = true;
        }
        if (hasWidth) {
            JgclParameterSection sec1 = new JgclParameterSection(Ap[0], Ap[1] - Ap[0]);
            JgclParameterSection sec2 = new JgclParameterSection(Bp[0], Bp[1] - Bp[0]);
            intf = new JgclOverlapCurve3D(this, sec1, mate, sec2, false);
        } else {
            Ap[0] = (Ap[0] + Ap[1]) / 2.0;
            Bp[0] = (Bp[0] + Bp[1]) / 2.0;
            intf = this.toIntersectionPoint(mate, Ap[0], Bp[0]);
            if (throwIndefinite) {
                throw new JgclIndefiniteSolution(intf.toIntersectionPoint());
            }
        }
        return intf;
    }

    private JgclIntersectionPoint3D getIntsWithBln(JgclBoundedLine3D mate, JgclLine3D Alin, JgclLine3D Blin) {
        double Bparam;
        double Aparam;
        JgclIntersectionPoint3D ints;
        try {
            ints = Alin.intersect1Line(Blin);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
        if (ints == null) {
            return null;
        }
        try {
            JgclPointOnCurve3D poc = (JgclPointOnCurve3D)ints.pointOnGeometry1();
            Aparam = this.checkParameter(poc.parameter());
            poc = (JgclPointOnCurve3D)ints.pointOnGeometry2();
            Bparam = mate.checkParameter(poc.parameter());
        }
        catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
            return null;
        }
        return this.toIntersectionPoint(mate, Aparam, Bparam);
    }

    JgclCurveCurveInterference3D interfere1(JgclBoundedLine3D mate, JgclVector3D thisUdir, JgclVector3D mateUdir, double thisLeng, double mateLeng) {
        JgclLine3D Blin = mate.toLine();
        if (this.haveIntsWithLine(Blin, mateUdir) < 0) {
            try {
                return this.haveCommonSection(true, mate, thisUdir, mateUdir, thisLeng, mateLeng);
            }
            catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                throw new JgclFatal();
            }
        }
        JgclLine3D Alin = this.toLine();
        switch (mate.haveIntsWithLine(Alin, thisUdir)) {
            case -1: {
                try {
                    return this.haveCommonSection(true, mate, thisUdir, mateUdir, thisLeng, mateLeng);
                }
                catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                    throw new JgclFatal();
                }
            }
            case 0: {
                return null;
            }
        }
        return this.getIntsWithBln(mate, Alin, Blin);
    }

    public JgclCurveCurveInterference3D interfere1(JgclBoundedLine3D mate) {
        JgclVector3D AUdir = this.unitizedDirection();
        JgclVector3D BUdir = mate.unitizedDirection();
        double Aleng = this.length();
        double Bleng = mate.length();
        return this.interfere1(mate, AUdir, BUdir, Aleng, Bleng);
    }

    JgclCurveCurveInterference3D[] interfere(JgclBoundedLine3D mate, JgclVector3D thisUdir, JgclVector3D mateUdir, double thisLeng, double mateLeng) {
        JgclCurveCurveInterference3D sol = this.interfere1(mate, thisUdir, mateUdir, thisLeng, mateLeng);
        if (sol == null) {
            return new JgclCurveCurveInterference3D[0];
        }
        JgclCurveCurveInterference3D[] intf = new JgclCurveCurveInterference3D[]{sol};
        return intf;
    }

    JgclCurveCurveInterference3D[] interfere(JgclBoundedLine3D mate, boolean doExchange) {
        JgclBoundedLine3D Bbln;
        JgclBoundedLine3D Abln;
        if (!doExchange) {
            Abln = this;
            Bbln = mate;
        } else {
            Abln = mate;
            Bbln = this;
        }
        JgclVector3D AUdir = Abln.unitizedDirection();
        JgclVector3D BUdir = Bbln.unitizedDirection();
        double Aleng = Abln.length();
        double Bleng = Bbln.length();
        return Abln.interfere(Bbln, AUdir, BUdir, Aleng, Bleng);
    }

    private JgclCurveCurveInterference3D[] convertInterferences(JgclCurveCurveInterference3D[] sourceInterferences, boolean doExchange) {
        Vector<JgclCurveCurveInterference3D> resultVector = new Vector<JgclCurveCurveInterference3D>();
        int i = 0;
        while (i < sourceInterferences.length) {
            JgclCurveCurveInterference3D intf = !doExchange ? sourceInterferences[i].changeCurve1(this) : sourceInterferences[i].changeCurve2(this);
            if (intf != null) {
                resultVector.addElement(intf);
            }
            ++i;
        }
        Object[] result = new JgclCurveCurveInterference3D[resultVector.size()];
        resultVector.copyInto(result);
        return result;
    }

    JgclCurveCurveInterference3D[] interfere(JgclPolyline3D mate, boolean doExchange) {
        return this.convertInterferences(this.toPolyline().interfere(mate, doExchange), doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclPureBezierCurve3D mate, boolean doExchange) {
        return this.convertInterferences(this.toBsplineCurve().interfere(mate, doExchange), doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclBsplineCurve3D mate, boolean doExchange) {
        return this.convertInterferences(this.toBsplineCurve().interfere(mate, doExchange), doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclTrimmedCurve3D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurveSegment3D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurve3D mate, boolean doExchange) {
        return mate.interfere(this, !doExchange);
    }

    public JgclCurveCurveInterference3D[] interfere(JgclBoundedCurve3D mate) {
        return mate.interfere(this, true);
    }

    JgclIntersectionPoint3D intersect1(JgclBoundedLine3D mate, JgclVector3D AUdir, JgclVector3D BUdir, double Aleng, double Bleng) throws JgclIndefiniteSolution {
        JgclLine3D Blin = mate.toLine();
        if (this.haveIntsWithLine(Blin, BUdir) < 0) {
            JgclCurveCurveInterference3D com_sec = this.haveCommonSection(false, mate, AUdir, BUdir, Aleng, Bleng);
            if (com_sec == null) {
                return null;
            }
            return com_sec.toIntersectionPoint();
        }
        JgclLine3D Alin = this.toLine();
        switch (mate.haveIntsWithLine(Alin, AUdir)) {
            case -1: {
                JgclCurveCurveInterference3D com_sec = this.haveCommonSection(false, mate, AUdir, BUdir, Aleng, Bleng);
                if (com_sec == null) {
                    return null;
                }
                return com_sec.toIntersectionPoint();
            }
            case 0: {
                return null;
            }
        }
        return this.getIntsWithBln(mate, Alin, Blin);
    }

    public JgclIntersectionPoint3D intersect1(JgclBoundedLine3D mate) throws JgclIndefiniteSolution {
        JgclVector3D AUdir = this.unitizedDirection();
        JgclVector3D BUdir = mate.unitizedDirection();
        double Aleng = this.length();
        double Bleng = mate.length();
        return this.intersect1(mate, AUdir, BUdir, Aleng, Bleng);
    }

    JgclEnclosingBox3D enclosingBox() {
        double max_z;
        double min_z;
        double max_y;
        double min_y;
        double max_x;
        double min_x;
        if (this.spnt().x() < this.epnt().x()) {
            min_x = this.spnt().x();
            max_x = this.epnt().x();
        } else {
            min_x = this.epnt().x();
            max_x = this.spnt().x();
        }
        if (this.spnt().y() < this.epnt().y()) {
            min_y = this.spnt().y();
            max_y = this.epnt().y();
        } else {
            min_y = this.epnt().y();
            max_y = this.spnt().y();
        }
        if (this.spnt().z() < this.epnt().z()) {
            min_z = this.spnt().z();
            max_z = this.epnt().z();
        } else {
            min_z = this.epnt().z();
            max_z = this.spnt().z();
        }
        return new JgclEnclosingBox3D(min_x, min_y, min_z, max_x, max_y, max_z);
    }

    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
        return new JgclBoundedLine3D(this.spnt.add(moveVec), this.epnt.add(moveVec));
    }

    JgclParameterDomain getParameterDomain() {
        return new JgclParameterDomain(false, 0.0, 1.0);
    }

    private double checkParameter(double param) {
        this.checkValidity(param);
        return this.parameterDomain().force(param);
    }

    public JgclBoundedLine3D reverse() {
        return new JgclBoundedLine3D(this.epnt(), this.spnt());
    }

    int type() {
        return 2;
    }

    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns, double rCos, double rSin) {
        JgclPoint3D rspnt = this.spnt().rotateZ(trns, rCos, rSin);
        JgclPoint3D repnt = this.epnt().rotateZ(trns, rCos, rSin);
        return new JgclBoundedLine3D(rspnt, repnt);
    }

    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
        throw new JgclNotSupported();
    }

    protected synchronized JgclParametricCurve3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint3D tSpnt = this.spnt().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        JgclPoint3D tEpnt = this.epnt().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        return new JgclBoundedLine3D(tSpnt, tEpnt);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tspnt");
        this.spnt.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tepnt");
        this.epnt.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

