/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclGeometrySchemaFunction;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclPlacement3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclAxis1Placement3D
extends JgclPlacement3D {
    private JgclVector3D axis;
    private JgclVector3D z;

    public JgclAxis1Placement3D(JgclPoint3D location, JgclVector3D axis) {
        super(location);
        this.axis = axis;
        this.checkAxis();
    }

    private void checkAxis() {
        if (this.axis != null) {
            JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
            double tol_d = condition.getToleranceForDistance();
            if (this.axis.norm() <= tol_d * tol_d) {
                throw new JgclInvalidArgumentValue();
            }
        }
    }

    public JgclVector3D axis() {
        return this.axis;
    }

    public JgclVector3D effectiveAxis() {
        return this.axis != null ? this.axis : JgclGeometrySchemaFunction.defaultAxis3D;
    }

    public JgclVector3D z() {
        if (this.z == null) {
            this.z = this.axis != null ? this.axis.unitized() : JgclGeometrySchemaFunction.defaultAxis3D;
        }
        return this.z;
    }

    public JgclLine3D toLine() {
        return new JgclLine3D(this.location(), this.z());
    }

    protected synchronized JgclAxis1Placement3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint3D tLocation = this.location().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        JgclVector3D tAxis = this.effectiveAxis().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        return new JgclAxis1Placement3D(tLocation, tAxis);
    }

    public synchronized JgclAxis1Placement3D transformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        if (transformedGeometries == null) {
            return this.doTransformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        JgclAxis1Placement3D transformed = (JgclAxis1Placement3D)transformedGeometries.get(this);
        if (transformed == null) {
            transformed = this.doTransformBy(reverseTransform, transformationOperator, transformedGeometries);
            transformedGeometries.put(this, transformed);
        }
        return transformed;
    }

    public synchronized JgclAxis1Placement3D transformBy(JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        return this.transformBy(false, transformationOperator, transformedGeometries);
    }

    public synchronized JgclAxis1Placement3D reverseTransformBy(JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        return this.transformBy(true, transformationOperator, transformedGeometries);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tlocation");
        this.location().output(writer, indent + 2);
        if (this.axis != null) {
            writer.println(String.valueOf(indent_tab) + "\taxis");
            this.axis.output(writer, indent + 2);
        }
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

