/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclApproximation;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclInterpolation3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclMatrix;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclUtil;
import jp.go.ipa.jgcl.JgclVector3D;

class JgclApproximation3D
extends JgclApproximation {
    private JgclPoint3D[] points;
    private JgclVector3D[] endVectors;

    JgclApproximation3D(JgclPoint3D[] points, double[] params, JgclVector3D[] endVectors, boolean isClosed) {
        super(points.length, params, isClosed);
        this.points = points;
        if (!isClosed) {
            this.endVectors = endVectors == null ? JgclInterpolation3D.besselPoints(points, params) : endVectors;
        }
    }

    private boolean tolerated2(JgclBsplineCurve3D bsc, double mid_tol) {
        if (!this.isClosed) {
            int i = 0;
            while (i < this.nPoints - 1) {
                double mid_param;
                JgclPoint3D mid_param_crd;
                JgclPoint3D mid_pnt = this.points[i].midPoint(this.points[i + 1]);
                if (mid_pnt.distance(mid_param_crd = bsc.coordinates(mid_param = 0.5 * this.params[i] + 0.5 * this.params[i + 1])) > mid_tol) {
                    return false;
                }
                ++i;
            }
        } else {
            int i = 0;
            int j = 1;
            while (i < this.nPoints) {
                double mid_param;
                JgclPoint3D mid_param_crd;
                JgclPoint3D mid_pnt = this.points[i].midPoint(this.points[j % this.nPoints]);
                if (mid_pnt.distance(mid_param_crd = bsc.coordinates(mid_param = 0.5 * this.params[i] + 0.5 * this.params[j])) > mid_tol) {
                    return false;
                }
                ++i;
                ++j;
            }
        }
        return true;
    }

    private double[] getCurvatures(int lower, int upper, JgclBsplineCurve3D bsc_intp) {
        double[] curvatures = new double[this.nPoints];
        int i = lower;
        while (i <= upper) {
            curvatures[i] = bsc_intp.curvature(this.params[i]).curvature();
            ++i;
        }
        return curvatures;
    }

    private JgclPoint3D projectPointLine(JgclPoint3D dApnt, JgclPoint3D dBpnt, JgclVector3D dBdir) {
        JgclVector3D euvec = dBdir.unitized();
        JgclVector3D evpp = dApnt.subtract(dBpnt);
        double edot = euvec.dotProduct(evpp);
        return dBpnt.add(euvec.multiply(edot));
    }

    private double[] compResiduals(JgclBsplineCurve3D bsc) {
        int npnts = this.points.length;
        double[] res = new double[npnts];
        if (JgclApproximation.debug) {
            bsc.output(System.err);
        }
        int i = 0;
        while (i < npnts) {
            JgclPoint3D bpnt = bsc.coordinates(this.params[i]);
            res[i] = this.points[i].distance(bpnt);
            if (JgclApproximation.debug) {
                System.err.println("i = " + i);
                System.err.println("params[" + i + "] = " + this.params[i]);
                System.err.println("bpnt[" + i + "] = (" + bpnt.x() + ", " + bpnt.y() + ", " + bpnt.z() + ")");
                System.err.println("res[" + i + "] = " + res[i]);
            }
            ++i;
        }
        return res;
    }

    private JgclMatrix.LinearLeastSquareSolution fitX(JgclMatrix matrix) {
        if (JgclApproximation.debug) {
            System.err.println("[getting fitX]");
        }
        double[] rightHandSideVector = new double[matrix.getRowSize()];
        int i = 0;
        while (i < rightHandSideVector.length) {
            rightHandSideVector[i] = this.points[i].x();
            ++i;
        }
        return matrix.solveLinearLeastSquare2(rightHandSideVector);
    }

    private JgclMatrix.LinearLeastSquareSolution fitY(JgclMatrix matrix) {
        if (JgclApproximation.debug) {
            System.err.println("[getting fitY]");
        }
        double[] rightHandSideVector = new double[matrix.getRowSize()];
        int i = 0;
        while (i < rightHandSideVector.length) {
            rightHandSideVector[i] = this.points[i].y();
            ++i;
        }
        return matrix.solveLinearLeastSquare2(rightHandSideVector);
    }

    private JgclMatrix.LinearLeastSquareSolution fitZ(JgclMatrix matrix) {
        if (JgclApproximation.debug) {
            System.err.println("[getting fitZ]");
        }
        double[] rightHandSideVector = new double[matrix.getRowSize()];
        int i = 0;
        while (i < rightHandSideVector.length) {
            rightHandSideVector[i] = this.points[i].z();
            ++i;
        }
        return matrix.solveLinearLeastSquare2(rightHandSideVector);
    }

    private JgclCartesianPoint3D[] getControlPoints(JgclBsplineKnot knotData) {
        JgclMatrix matrix = this.getDesignMatrix(knotData);
        JgclMatrix.LinearLeastSquareSolution x = this.fitX(matrix);
        JgclMatrix.LinearLeastSquareSolution y = this.fitY(matrix);
        JgclMatrix.LinearLeastSquareSolution z = this.fitZ(matrix);
        JgclCartesianPoint3D[] controlPoints = new JgclCartesianPoint3D[knotData.nControlPoints()];
        int i = 0;
        while (i < knotData.nControlPoints()) {
            controlPoints[i] = new JgclCartesianPoint3D(x.solutionAt(i), y.solutionAt(i), z.solutionAt(i));
            ++i;
        }
        return controlPoints;
    }

    JgclBsplineCurve3D getApproximationWithKnots(int nsegs, double[] knots) {
        if (nsegs < this.minSegmentNumber() || nsegs > this.maxSegmentNumber()) {
            throw new JgclInvalidArgumentValue();
        }
        JgclBsplineKnot knotData = this.getKnotData(nsegs, knots);
        JgclPoint3D[] control = this.getControlPoints(knotData);
        if (JgclApproximation.debug) {
            int i = 0;
            while (i < control.length) {
                System.err.println("control[" + i + "] = (" + control[i].x() + ", " + control[i].y() + ", " + control[i].z() + ")");
                ++i;
            }
        }
        if (!this.isClosed) {
            control[1] = this.projectPointLine(control[1], control[0], this.endVectors[0]);
            control[control.length - 2] = this.projectPointLine(control[control.length - 2], control[control.length - 1], this.endVectors[1]);
        }
        return new JgclBsplineCurve3D(knotData, control, null);
    }

    JgclBsplineCurve3D getApproximationWithTolerance(JgclToleranceForDistance tol, JgclToleranceForDistance midTol) {
        JgclBsplineCurve3D intp_bsc = new JgclBsplineCurve3D(this.points, this.params, this.endVectors, this.isClosed);
        if (JgclApproximation.debug) {
            intp_bsc.output(System.err);
        }
        int lower = 2;
        int upper = this.isClosed ? this.nPoints - 2 : this.nPoints - 3;
        double[] curvatures = this.getCurvatures(lower, upper, intp_bsc);
        double[] sortedCurvatures = (double[])curvatures.clone();
        if (lower < upper) {
            JgclUtil.sortDoubleArray(sortedCurvatures, lower, upper);
        }
        int[] nsegs = new int[this.nPoints + 4];
        int nsegI = 0;
        nsegs[nsegI] = this.initSegmentNumber();
        if (nsegs[nsegI] < 0) {
            return intp_bsc;
        }
        double[] knots = new double[this.nPoints + 4];
        JgclBsplineCurve3D bsc = null;
        JgclBsplineCurve3D aprx_bsc = null;
        int bsc_nseg = nsegs[nsegI];
        while (true) {
            boolean isTolerated;
            double ep;
            if (this.compKnots(this.params[0], ep = this.isClosed ? this.params[this.nPoints] : this.params[this.nPoints - 1], nsegs[nsegI], lower, upper, curvatures, sortedCurvatures, knots)) {
                aprx_bsc = this.getApproximationWithKnots(nsegs[nsegI], knots);
                double[] res = this.compResiduals(aprx_bsc);
                if (this.tolerated(tol.value(), res) && this.tolerated2(aprx_bsc, midTol.value())) {
                    isTolerated = true;
                    bsc = aprx_bsc;
                    bsc_nseg = nsegs[nsegI];
                } else {
                    isTolerated = false;
                }
            } else {
                aprx_bsc = null;
                isTolerated = false;
            }
            if (!this.reNewSegmentNumber(nsegs, nsegI, isTolerated)) break;
            ++nsegI;
        }
        if (this.isClosed && bsc != null && bsc_nseg >= this.nPoints - 3) {
            if (JgclApproximation.debug) {
                System.err.println("nseg = " + bsc_nseg + ", discarded");
            }
            bsc = null;
        }
        if (bsc == null) {
            bsc = intp_bsc;
        }
        return bsc;
    }

    public static void main(String[] argv) {
        JgclToleranceForDistance tol = new JgclToleranceForDistance(0.1);
        JgclToleranceForDistance mid_tol = new JgclToleranceForDistance(10.0);
        System.out.println("Main: [creating JgclApproximation3D.]");
        JgclCartesianPoint3D p0 = new JgclCartesianPoint3D(0.0, 0.0, 0.0);
        JgclCartesianPoint3D p1 = new JgclCartesianPoint3D(0.4, 0.6, 0.1);
        JgclCartesianPoint3D p2 = new JgclCartesianPoint3D(1.0, 1.0, 0.2);
        JgclCartesianPoint3D p3 = new JgclCartesianPoint3D(1.6, 0.6, 0.3);
        JgclCartesianPoint3D p4 = new JgclCartesianPoint3D(2.0, 0.0, 0.4);
        JgclCartesianPoint3D p5 = new JgclCartesianPoint3D(1.6, -0.6, 0.3);
        JgclCartesianPoint3D p6 = new JgclCartesianPoint3D(1.0, -1.0, 0.2);
        JgclCartesianPoint3D p7 = new JgclCartesianPoint3D(0.4, -0.6, 0.1);
        JgclPoint3D[] pntsClosed = new JgclCartesianPoint3D[]{p0, p1, p2, p3, p4, p5, p6, p7};
        double[] dArray = new double[9];
        dArray[1] = 0.125;
        dArray[2] = 0.25;
        dArray[3] = 0.375;
        dArray[4] = 0.5;
        dArray[5] = 0.625;
        dArray[6] = 0.75;
        dArray[7] = 0.875;
        dArray[8] = 1.0;
        double[] prmsClosed = dArray;
        JgclApproximation3D aprxClosed = new JgclApproximation3D(pntsClosed, prmsClosed, null, true);
        System.out.println("Main: [creating JgclBsplineCurve3D.]");
        JgclBsplineCurve3D bsplineClosed = aprxClosed.getApproximationWithTolerance(tol, mid_tol);
        System.out.println("\nMain: [JgclApproximation3D Closed Test]");
        bsplineClosed.output(System.out);
        JgclCartesianPoint3D p02 = new JgclCartesianPoint3D(0.0, 0.0, 0.0);
        JgclCartesianPoint3D p12 = new JgclCartesianPoint3D(0.4, 0.2, 0.1);
        JgclCartesianPoint3D p22 = new JgclCartesianPoint3D(1.0, 0.3, 0.2);
        JgclCartesianPoint3D p32 = new JgclCartesianPoint3D(1.6, 0.25, 0.3);
        JgclCartesianPoint3D p42 = new JgclCartesianPoint3D(2.0, 0.2, 0.4);
        JgclCartesianPoint3D p52 = new JgclCartesianPoint3D(2.4, 0.25, 0.5);
        JgclCartesianPoint3D p62 = new JgclCartesianPoint3D(3.0, 0.3, 0.4);
        JgclCartesianPoint3D p72 = new JgclCartesianPoint3D(3.6, 0.25, 0.3);
        JgclCartesianPoint3D p8 = new JgclCartesianPoint3D(4.0, 0.2, 0.2);
        JgclLiteralVector3D sv = new JgclLiteralVector3D(0.4, 0.2, 0.1);
        JgclLiteralVector3D ev = new JgclLiteralVector3D(0.4, -0.05, -0.1);
        JgclPoint3D[] pntsOpen = new JgclCartesianPoint3D[]{p02, p12, p22, p32, p42, p52, p62, p72, p8};
        double[] dArray2 = new double[9];
        dArray2[1] = 0.125;
        dArray2[2] = 0.25;
        dArray2[3] = 0.375;
        dArray2[4] = 0.5;
        dArray2[5] = 0.625;
        dArray2[6] = 0.75;
        dArray2[7] = 0.875;
        dArray2[8] = 1.0;
        double[] prmsOpen = dArray2;
        JgclVector3D[] endvecs = new JgclLiteralVector3D[]{sv, ev};
        JgclApproximation3D aprxOpen = new JgclApproximation3D(pntsOpen, prmsOpen, endvecs, false);
        System.out.println("\n\nMain: [creating Open JgclBsplineCurve3D.]");
        JgclBsplineCurve3D bsplineOpen = aprxOpen.getApproximationWithTolerance(tol, mid_tol);
        System.out.println("\nMain: [JgclApproximation3D Open Test]");
        bsplineOpen.output(System.out);
    }
}

